/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.mftorder;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class MftPickStartWorkUtils {
    private static final Log logger = LogFactory.getLog(MftPickStartWorkUtils.class);
    public static final String KEY_TRANSACTPRODUCT = "mpdm_transactproduct";
    public static final String KEY_TRANSACTIONTYPE = "transactiontype";
    public static final String KEY_MANUBILL = "manubill";
    public static final String KEY_MANUENTRYID = "manuentryid";
    public static final String KEY_MANUBILLID = "manubillid";
    public static final String POM_MFTORDER = "pom_mftorder";

    public static void updateMftStartworktime(Set<Long> mftentryIdList, Set<Long> mftIdList, String entity, String pickentity) {
        MftPickStartWorkUtils.updateMftStartworktimeInner(mftentryIdList, mftIdList, entity, pickentity, null);
    }

    public static void updateMftStartworktimeNew(Set<Long> mftentryIdList, Set<Long> mftIdList, String entity, String pickentity, Set<Long> setBookDateOrderEntryIds) {
        MftPickStartWorkUtils.updateMftStartworktimeInner(mftentryIdList, mftIdList, entity, pickentity, setBookDateOrderEntryIds);
    }

    public static void updateMftStartworktimeNewImpl(Set<Long> mftentryIdList, Set<Long> mftIdList, String entity, String pickentity, Set<Long> setBookDateOrderEntryIds, Map<Long, Date> entryDateMap) {
        logger.info("\u9886\u6599\u5373\u5f00\u5de5---------start----");
        if (CollectionUtils.isNotEmpty(mftIdList)) {
            QFilter qf = new QFilter("id", "in", mftIdList);
            DynamicObject[] manuObjList = BusinessDataServiceHelper.load((String)entity, (String)MftPickStartWorkUtils.mftOrderSelected(), (QFilter[])new QFilter[]{qf});
            HashMap<Long, Boolean> transIsprocedureMap = new HashMap<Long, Boolean>(16);
            Map<Long, Boolean> transactiontypeMap = MftPickStartWorkUtils.getTransactiontypeAndIsprocedure(manuObjList, transIsprocedureMap);
            HashSet<Long> orderStartWork = new HashSet<Long>(16);
            HashSet<Long> technicsStartWork = new HashSet<Long>(16);
            HashSet<Long> technicsOrderStartWork = new HashSet<Long>(16);
            StringBuilder ordersb = new StringBuilder();
            for (DynamicObject mftOrder : manuObjList) {
                Long mid = (Long)mftOrder.getPkValue();
                DynamicObjectCollection orderentry = mftOrder.getDynamicObjectCollection("treeentryentity");
                String billno = mftOrder.getString("billno");
                for (DynamicObject mEntry : orderentry) {
                    Long entryid = mEntry.getLong("id");
                    DynamicObject transactiontype = mftOrder.getDynamicObject(KEY_TRANSACTIONTYPE);
                    Long transactiontypeId = transactiontype == null ? 0L : transactiontype.getLong("id");
                    String planstatus = mEntry.getString("planstatus");
                    String taskstatus = mEntry.getString("taskstatus");
                    if (!transactiontypeMap.get(transactiontypeId).booleanValue() || !mftentryIdList.contains(entryid) || !"C".equals(planstatus) || !"A".equals(taskstatus)) continue;
                    if (!((Boolean)transIsprocedureMap.get(transactiontypeId)).booleanValue()) {
                        orderStartWork.add(mid);
                        ordersb.append(billno).append(',').append(entryid).append("@@@");
                        continue;
                    }
                    technicsStartWork.add(entryid);
                    technicsOrderStartWork.add(mid);
                }
            }
            logger.info("\u9886\u6599\u5373\u5f00\u5de5---------orderStartWork----" + orderStartWork);
            if (!orderStartWork.isEmpty()) {
                String ordersbStr = ordersb.toString();
                logger.info("\u9886\u6599\u5373\u5f00\u5de5-----\u5de5\u5355\u5f00\u5de5----ordersbStr----" + ordersbStr);
                OperateOption startWorkOption = MftPickStartWorkUtils.getOperateOption();
                startWorkOption.setVariableValue("operateOption", ordersbStr);
                OperationResult saveResult = OperationServiceHelper.executeOperate((String)"beginwork", (String)entity, (Object[])orderStartWork.toArray(), (OperateOption)startWorkOption);
                logger.info("saveResult.isSuccess()---\u5de5\u5355\u5f00\u5de5--" + saveResult.isSuccess() + "----" + saveResult.getMessage());
                if (!saveResult.isSuccess()) {
                    throw new KDBizException(saveResult.getMessage());
                }
            }
            logger.info("\u9886\u6599\u5373\u5f00\u5de5---------technicsStartWork----" + technicsStartWork);
            if (!technicsStartWork.isEmpty()) {
                String technicsEntity = MftPickStartWorkUtils.getTechnicsEntity(entity);
                HashSet<Long> unorderStartWork = new HashSet<Long>(technicsStartWork.size());
                QFilter qfilter = new QFilter("mftentryseq", "in", technicsStartWork);
                String selectProperties = "id,mftentryseq,billno,oprentryentity.id,manufactureorderid";
                HashSet<Long> technicsIdSet = new HashSet<Long>(16);
                ArrayList<Long> technicsEntryIdList = new ArrayList<Long>(16);
                DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"mftentryseq_query", (String)technicsEntity, (String)selectProperties, (QFilter[])qfilter.toArray(), null);
                Object object = null;
                try {
                    for (Row row : queryDataSet) {
                        String manufactureorderid = row.getString("manufactureorderid");
                        unorderStartWork.add(Long.valueOf(manufactureorderid));
                        Long pkid = row.getLong("id");
                        Long entityId = row.getLong("oprentryentity.id");
                        technicsIdSet.add(pkid);
                        technicsEntryIdList.add(entityId);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (queryDataSet != null) {
                        if (object != null) {
                            try {
                                queryDataSet.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            queryDataSet.close();
                        }
                    }
                }
                logger.info("\u9886\u6599\u5373\u5f00\u5de5-----\u5de5\u5e8f\u5f00\u5de5----technicsIdSet----" + technicsIdSet);
                logger.info("\u9886\u6599\u5373\u5f00\u5de5-----\u5de5\u5e8f\u5f00\u5de5----technicsEntryIdList----" + technicsEntryIdList);
                if (!technicsIdSet.isEmpty()) {
                    OperateOption startWorkOption = MftPickStartWorkUtils.getOperateOption();
                    startWorkOption.setVariableValue("operateOption", JSON.toJSONString(technicsEntryIdList));
                    startWorkOption.setVariableValue("orderBillType", entity);
                    OperationResult result = OperationServiceHelper.executeOperate((String)"donothing_start", (String)technicsEntity, (Object[])technicsIdSet.toArray(), (OperateOption)startWorkOption);
                    logger.info("saveResult.isSuccess()---\u5de5\u5e8f\u5f00\u5de5--" + result.isSuccess() + "----" + result.getMessage());
                    if (!result.isSuccess()) {
                        throw new KDBizException(result.getMessage());
                    }
                }
                if (!unorderStartWork.isEmpty()) {
                    technicsOrderStartWork.removeAll(unorderStartWork);
                }
                if (technicsOrderStartWork != null && !technicsOrderStartWork.isEmpty()) {
                    MftPickStartWorkUtils.dealNotExitTechnics(technicsOrderStartWork, transIsprocedureMap, transactiontypeMap, entity, manuObjList, mftentryIdList);
                }
            }
        }
    }

    private static void updateMftStartworktimeInner(Set<Long> mftentryIdList, Set<Long> mftIdList, String entity, String pickentity, Set<Long> setBookDateOrderEntryIds) {
        logger.debug("updateMftStartworktime---------start----");
        if (CollectionUtils.isNotEmpty(mftIdList)) {
            QFilter qf = new QFilter("id", "in", mftIdList);
            DynamicObject[] manuObjList = BusinessDataServiceHelper.load((String)entity, (String)MftPickStartWorkUtils.mftOrderSelected(), (QFilter[])new QFilter[]{qf});
            Map<Long, Boolean> transactiontypeMap = MftPickStartWorkUtils.getTransactiontype(manuObjList);
            for (DynamicObject mftOrder : manuObjList) {
                Object mid = mftOrder.getPkValue();
                DynamicObjectCollection orderentry = mftOrder.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject mEntry : orderentry) {
                    Long entryid = mEntry.getLong("id");
                    DynamicObject transactiontype = mftOrder.getDynamicObject(KEY_TRANSACTIONTYPE);
                    Long transactiontypeId = transactiontype == null ? 0L : transactiontype.getLong("id");
                    if (!transactiontypeMap.get(transactiontypeId).booleanValue() || !mftentryIdList.contains(entryid)) continue;
                    MftPickStartWorkUtils.setStartWorkTimeNew(mEntry, mid, pickentity, orderentry, setBookDateOrderEntryIds);
                }
            }
            if (manuObjList.length > 0) {
                logger.debug("updateMftStartworktime---------save----");
                SaveServiceHelper.save((DynamicObject[])manuObjList);
            }
        }
    }

    public static void setStartWorkTime(DynamicObject mEntry, Object mid, String pickentity, DynamicObjectCollection orderentry) {
        MftPickStartWorkUtils.setStartWorkTimeInner(mEntry, mid, pickentity, orderentry, null);
    }

    public static void setStartWorkTimeNew(DynamicObject mEntry, Object mid, String pickentity, DynamicObjectCollection orderentry, Set<Long> setBookDateOrderEntryIds) {
        MftPickStartWorkUtils.setStartWorkTimeInner(mEntry, mid, pickentity, orderentry, setBookDateOrderEntryIds);
    }

    private static void setStartWorkTimeInner(DynamicObject mEntry, Object mid, String pickentity, DynamicObjectCollection orderentry, Set<Long> setBookDateOrderEntryIds) {
        Object entryid = mEntry.getPkValue();
        QFilter qf2 = new QFilter("billentry.manuentryid", "=", (Object)NumberUtils.toLong((String)entryid.toString()));
        qf2.and(new QFilter("billentry.manubillid", "=", (Object)NumberUtils.toLong((String)mid.toString())));
        qf2.and(new QFilter("billstatus", "=", (Object)"C"));
        qf2.and(new QFilter("ischargeoff", "=", (Object)Boolean.FALSE));
        DynamicObjectCollection query = QueryServiceHelper.query((String)pickentity, (String)"id,biztime,billentry.manuentryid,billentry.manubillid", (QFilter[])new QFilter[]{qf2}, (String)"biztime", (int)1);
        if (!query.isEmpty()) {
            Date biztime = ((DynamicObject)query.get(0)).getDate("biztime");
            logger.debug("updateMftStartworktime----------" + biztime);
            Date dayStartTime = MftPickStartWorkUtils.getDayStartTime(biztime);
            mEntry.set("startworktime", (Object)dayStartTime);
            if ("A".equals(mEntry.getString("taskstatus"))) {
                mEntry.set("taskstatus", (Object)"B");
                setBookDateOrderEntryIds.add(mEntry.getLong("id"));
            }
            for (DynamicObject mcoll : orderentry) {
                Long pid = mcoll.getLong("pid");
                if (!pid.toString().equals(entryid.toString())) continue;
                mcoll.set("startworktime", (Object)dayStartTime);
                if (!"A".equals(mcoll.getString("taskstatus"))) continue;
                mcoll.set("taskstatus", (Object)"B");
            }
        }
    }

    public static Map<Long, Boolean> getTransactiontype(DynamicObject[] manuObjList) {
        HashMap<Long, Boolean> transactiontypeMap = new HashMap<Long, Boolean>(16);
        HashSet<Long> transactionIds = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : manuObjList) {
            DynamicObject transactiontype = dynamicObject.getDynamicObject(KEY_TRANSACTIONTYPE);
            if (transactiontype == null) continue;
            transactionIds.add(transactiontype.getLong("id"));
        }
        QFilter qfilter0 = new QFilter("id", "in", transactionIds);
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"querytransaction", (String)KEY_TRANSACTPRODUCT, (String)"id,transmitbeginwork,pickbeginwork", (QFilter[])new QFilter[]{qfilter0}, (String)"");){
            for (Row row : queryDataSet) {
                Boolean transmitbeginwork = row.getBoolean("pickbeginwork");
                Long id = row.getLong("id");
                transactiontypeMap.put(id, transmitbeginwork);
            }
        }
        return transactiontypeMap;
    }

    public static Date getDayStartTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String mftOrderSelected() {
        StringBuilder sql = new StringBuilder();
        sql.append("isinitbill,billno, id,transactiontype,org,");
        sql.append("treeentryentity.quainwaqty , treeentryentity.unquainwaqty,treeentryentity.waitcheckqty,treeentryentity.scrinwaqty, ");
        sql.append("treeentryentity.planstatus, ");
        sql.append("treeentryentity.inwarmin , treeentryentity.inwarmin,treeentryentity.taskstatus,treeentryentity.stockqty,treeentryentity.baseqty ,");
        sql.append("treeentryentity.seq , treeentryentity.endworktime ,treeentryentity.iscontrolqty,treeentryentity.pid,");
        sql.append("treeentryentity.transmittime , treeentryentity.startworktime,treeentryentity.endworktime ");
        return sql.toString();
    }

    public static Map<Long, Boolean> getTransactiontypeAndIsprocedure(DynamicObject[] manuObjList, Map<Long, Boolean> transIsprocedureMap) {
        HashMap<Long, Boolean> transactiontypeMap = new HashMap<Long, Boolean>(16);
        HashSet<Long> transactionIds = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : manuObjList) {
            DynamicObject transactiontype = dynamicObject.getDynamicObject(KEY_TRANSACTIONTYPE);
            if (transactiontype == null) continue;
            transactionIds.add(transactiontype.getLong("id"));
        }
        QFilter qfilter0 = new QFilter("id", "in", transactionIds);
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"querytransaction", (String)KEY_TRANSACTPRODUCT, (String)"id,transmitbeginwork,pickbeginwork,isprocedure", (QFilter[])new QFilter[]{qfilter0}, (String)"");){
            for (Row row : queryDataSet) {
                Boolean transmitbeginwork = row.getBoolean("pickbeginwork");
                Boolean isprocedure = row.getBoolean("isprocedure");
                Long id = row.getLong("id");
                transactiontypeMap.put(id, transmitbeginwork);
                transIsprocedureMap.put(id, isprocedure);
            }
        }
        return transactiontypeMap;
    }

    public static OperateOption getOperateOption() {
        OperateOption saveOption = OperateOption.create();
        saveOption.setVariableValue("ignorewarn", String.valueOf(true));
        saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        saveOption.setVariableValue("strictvalidation", String.valueOf(false));
        saveOption.setVariableValue("ignoreValidation", String.valueOf(true));
        saveOption.setVariableValue("WF", "false");
        return saveOption;
    }

    public static String getTechnicsEntity(String orderNum) {
        String technicsNum = "sfc_manftech";
        switch (orderNum) {
            case "om_mftorder": {
                technicsNum = "om_mfttechnics";
                break;
            }
            case "prop_mftorder": {
                technicsNum = "prop_manftech";
                break;
            }
        }
        return technicsNum;
    }

    public static void dealNotExitTechnics(Set<Long> mftIdList, Map<Long, Boolean> transIsprocedureMap, Map<Long, Boolean> transactiontypeMap, String entity, DynamicObject[] manuObjList, Set<Long> mftentryIdList) {
        StringBuilder unorderSb = new StringBuilder();
        HashSet<Long> needorderStartWork = new HashSet<Long>(mftIdList.size());
        for (DynamicObject mftOrder : manuObjList) {
            Long mid = (Long)mftOrder.getPkValue();
            if (!mftIdList.contains(mid)) continue;
            DynamicObjectCollection orderentry = mftOrder.getDynamicObjectCollection("treeentryentity");
            String billno = mftOrder.getString("billno");
            for (DynamicObject mEntry : orderentry) {
                Long entryid = mEntry.getLong("id");
                DynamicObject transactiontype = mftOrder.getDynamicObject(KEY_TRANSACTIONTYPE);
                Long transactiontypeId = transactiontype == null ? 0L : transactiontype.getLong("id");
                String planstatus = mEntry.getString("planstatus");
                String taskstatus = mEntry.getString("taskstatus");
                if (!transactiontypeMap.get(transactiontypeId).booleanValue() || !mftentryIdList.contains(entryid) || !"C".equals(planstatus) || !"A".equals(taskstatus) || !transIsprocedureMap.get(transactiontypeId).booleanValue()) continue;
                needorderStartWork.add(mid);
                unorderSb.append(billno).append(',').append(entryid).append("@@@");
            }
        }
        logger.info("\u9886\u6599\u5373\u5f00\u5de5---------needorderStartWork----" + needorderStartWork);
        if (!needorderStartWork.isEmpty()) {
            String unorderSbStr = unorderSb.toString();
            logger.info("\u9886\u6599\u5373\u5f00\u5de5-----\u5de5\u5355\u5f00\u5de5----unorderSbStr----" + unorderSbStr);
            OperateOption startWorkOption = MftPickStartWorkUtils.getOperateOption();
            startWorkOption.setVariableValue("operateOption", unorderSbStr);
            OperationResult beginworkResult = OperationServiceHelper.executeOperate((String)"beginwork", (String)entity, (Object[])needorderStartWork.toArray(), (OperateOption)startWorkOption);
            logger.info("beginworkResult.isSuccess()---\u5de5\u5355\u5f00\u5de5--" + beginworkResult.isSuccess() + "----" + beginworkResult.getMessage());
            if (!beginworkResult.isSuccess()) {
                throw new KDBizException(beginworkResult.getMessage());
            }
        }
    }
}

