/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.mftorder;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bd.mpdm.business.mftorder.OrderBookDateService;
import kd.bd.mpdm.business.mftorder.OrderCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MftorderChangeLogUtils {
    public static void updateChangeLog(DynamicObject xBill, Map<Long, Date> bookdates, String xbilllogEntity, String mftorderEntity) {
        if (null != xBill) {
            HashSet<Long> xBillEntryIds = new HashSet<Long>(16);
            HashSet<Long> manuEntryIds = new HashSet<Long>(16);
            DynamicObjectCollection xbillEntrys = xBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject xbillEntry : xbillEntrys) {
                if (null == xbillEntry) continue;
                xBillEntryIds.add(xbillEntry.getLong("id"));
                manuEntryIds.add(xbillEntry.getLong("srcbillentryid"));
            }
            DynamicObject[] manuBills = OrderCommonService.queryManuBills(manuEntryIds, mftorderEntity);
            HashSet<Long> xBillEntryIdsForBookDate = new HashSet<Long>(16);
            for (DynamicObject xbillEntry : xbillEntrys) {
                if (null == xbillEntry) continue;
                xBillEntryIds.add(xbillEntry.getLong("id"));
                DynamicObject matchEntry = OrderCommonService.matchEntryInfo(xbillEntry, xbillEntrys);
                if (!OrderBookDateService.isXbillFillBeginBookDate(matchEntry, manuBills)) continue;
                xBillEntryIdsForBookDate.add(xbillEntry.getLong("id"));
            }
            if (!xBillEntryIds.isEmpty()) {
                DynamicObject[] xbillLogs;
                QFilter qFilter = new QFilter("xbillentryid", "in", xBillEntryIds);
                String select = "id,changestatus,xbillentryid,srcbillentryid,beginbookdate,srcbillentryseq,entryentity.srcbillnoentry,entryentity.srcbillseqentry";
                for (DynamicObject xbillLog : xbillLogs = BusinessDataServiceHelper.load((String)xbilllogEntity, (String)select, (QFilter[])qFilter.toArray())) {
                    if (null == xbillLog) continue;
                    xbillLog.set("changestatus", (Object)"B");
                    long xbillentryid = xbillLog.getLong("xbillentryid");
                    DynamicObject xbillEntry = OrderCommonService.matchXBillEntryByXentryId(xbillentryid, xBill, "id");
                    if (null == xbillEntry) continue;
                    String srcbillentryid = xbillEntry.getString("srcbillentryid");
                    String srcbillentrySeq = xbillEntry.getString("srcbillentryseq");
                    String srcbillBillNo = xbillEntry.getString("srcbillno");
                    if (StringUtils.isNotBlank((CharSequence)srcbillentryid)) {
                        xbillLog.set("srcbillentryid", (Object)srcbillentryid);
                    }
                    if (StringUtils.isNotBlank((CharSequence)srcbillentrySeq)) {
                        xbillLog.set("srcbillentryseq", (Object)srcbillentrySeq);
                    }
                    DynamicObjectCollection xBillLogEntry = xbillLog.getDynamicObjectCollection("entryentity");
                    for (DynamicObject dynamicObjectEntry : xBillLogEntry) {
                        if (StringUtils.isNotBlank((CharSequence)srcbillBillNo)) {
                            dynamicObjectEntry.set("srcbillnoentry", (Object)srcbillBillNo);
                        }
                        if (!StringUtils.isNotBlank((CharSequence)srcbillentrySeq)) continue;
                        dynamicObjectEntry.set("srcbillseqentry", (Object)srcbillentrySeq);
                    }
                    if (!xBillEntryIdsForBookDate.contains(xbillentryid)) continue;
                    Date beginBookDate = null;
                    DynamicObject xbillMainEntry = OrderCommonService.matchEntryInfo(xbillEntry, xbillEntrys);
                    if (null != xbillMainEntry) {
                        beginBookDate = MftorderChangeLogUtils.queryBookDate(xbillEntry, xbillLog, xbillMainEntry.getLong("id"), bookdates, xbillLogs);
                    }
                    if (null == beginBookDate) continue;
                    xbillLog.set("beginbookdate", beginBookDate);
                }
                SaveServiceHelper.update((DynamicObject[])xbillLogs);
            }
        }
    }

    private static Date queryBookDate(DynamicObject xbillEntry, DynamicObject xbillLog, long mainEntryId, Map<Long, Date> bookdates, DynamicObject[] xbillLogs) {
        Date beginBookDate = null;
        if (null != xbillEntry && null != xbillLog && !bookdates.isEmpty() && null != xbillLogs) {
            Date beginBookDateInLog = null;
            String producttype = xbillEntry.getString("producttype");
            if ("C".equals(producttype)) {
                beginBookDateInLog = xbillLog.getDate("beginbookdate");
            } else {
                long xbillPid = xbillEntry.getLong("pid");
                for (DynamicObject xbillLogTemp : xbillLogs) {
                    long xbillentryidTemp;
                    if (null == xbillLogTemp || xbillPid != (xbillentryidTemp = xbillLogTemp.getLong("xbillentryid"))) continue;
                    beginBookDateInLog = xbillLogTemp.getDate("beginbookdate");
                    break;
                }
            }
            beginBookDate = bookdates.get(mainEntryId);
            if (null != beginBookDateInLog && null != beginBookDate) {
                Date theDayAfter = OrderBookDateService.theDayAfterMaxBookDate(beginBookDate);
                beginBookDate = beginBookDateInLog.before(theDayAfter) ? theDayAfter : beginBookDateInLog;
            }
        }
        return beginBookDate;
    }
}

