/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.mftorder;

import com.alibaba.fastjson.JSON;
import com.google.common.primitives.Longs;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bd.mpdm.business.helper.OrderSplitTechnicsHelper;
import kd.bd.mpdm.business.helper.split.OrderSplitHelper;
import kd.bd.mpdm.business.manuversion.AutoSetManuVersionParamEntryHelper;
import kd.bd.mpdm.business.manuversion.IAutoSetManuVersionParamEntryExt;
import kd.bd.mpdm.business.mftorder.OrderQualityOrgService;
import kd.bd.mpdm.business.mftorder.OrderSpliteService;
import kd.bd.mpdm.business.mftorder.StockCulUtils;
import kd.bd.mpdm.business.mftorder.validate.OrderSplitValidateService;
import kd.bd.mpdm.common.mftorder.enums.ManuBillBizStatusEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillPickStatusEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillPlanStatusEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillTaskStatusEnum;
import kd.bd.mpdm.common.mftorder.enums.PrecisionAccountEnum;
import kd.bd.mpdm.common.mftorder.helper.BillUnitAndQtytHelper;
import kd.bd.mpdm.common.mftorder.utils.JsonUtils;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsManuVersionQueryHelper;
import kd.bd.mpdm.common.utils.UnitPrecisionUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;

public class MyTaskSplitOrder
implements Runnable {
    private static Log logger = LogFactory.getLog(MyTaskSplitOrder.class);
    private RequestContext rc;
    private String pageId;
    private List<DynamicObject> selectDym;
    private DynamicObjectCollection orderEntrys;
    private int pkValuePomConner;
    private int pkValueOmConner;
    private Set<Object> orderEntryIds = new HashSet<Object>(10);
    private Map<Object, List<DynamicObject>> newOrderEntryMap = new HashMap<Object, List<DynamicObject>>(16);
    private Map<Object, DynamicObject> newOrderMap = new HashMap<Object, DynamicObject>(16);
    private Map<Object, DynamicObject> orderEntryMap = new HashMap<Object, DynamicObject>(16);
    private Map<Object, DynamicObject> oldOrderMap = new HashMap<Object, DynamicObject>(16);
    private Set<Long> orderEntryIdsForUpdateEndWorkTime = new HashSet<Long>(10);
    private Set<Long> orderEntryIdsForUpdate = new HashSet<Long>(10);
    private Set<Long> orderIdsForUpdate = new HashSet<Long>(10);
    private String dispatchSource = "pom_mftorder";

    public String getDispatchSource() {
        return this.dispatchSource;
    }

    public void setDispatchSource(String dispatchSource) {
        if (StringUtils.isNotBlank((CharSequence)dispatchSource)) {
            this.dispatchSource = dispatchSource;
        }
    }

    public MyTaskSplitOrder() {
    }

    public MyTaskSplitOrder(RequestContext rc, String pageId, List<DynamicObject> selectDym, DynamicObjectCollection orderEntrys) {
        this.rc = rc;
        this.pageId = pageId;
        this.selectDym = selectDym;
        this.orderEntrys = orderEntrys;
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        try {
            this.doTask();
        }
        catch (Exception e) {
            PageCache pageCache = new PageCache(this.pageId);
            pageCache.put("opexception", e.toString());
            logger.error((Throwable)e);
        }
    }

    private void doTask() {
        List<DynamicObject> selectDyms = this.selectDym;
        HashMap<DynamicObject, String> res = new HashMap<DynamicObject, String>(selectDyms.size());
        ArrayList<DynamicObject> billEntryList = new ArrayList<DynamicObject>(selectDyms.size());
        HashSet<Long> srcEntryIdInSplitEntrys = new HashSet<Long>(16);
        HashMap<Long, BigDecimal> actSplitQtyMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject select : selectDyms) {
            long srcEntryId = select.getLong("splitmftorderentryid");
            billEntryList.add(select);
            res.put(select, "");
            srcEntryIdInSplitEntrys.add(srcEntryId);
            BigDecimal actTotalSplitQty = null == actSplitQtyMap.get(srcEntryId) ? BigDecimal.ZERO : (BigDecimal)actSplitQtyMap.get(srcEntryId);
            BigDecimal splitqty = select.getBigDecimal("splitqty");
            actTotalSplitQty = actTotalSplitQty.add(splitqty);
            actSplitQtyMap.put(srcEntryId, actTotalSplitQty);
        }
        this.dealData(srcEntryIdInSplitEntrys, billEntryList, this.pageId, res, actSplitQtyMap);
        PageCache pageCache = new PageCache(this.pageId);
        for (Map.Entry item : res.entrySet()) {
            DynamicObject entry;
            if (null == item || null == (entry = (DynamicObject)item.getKey())) continue;
            String key = "SOR:" + entry.getString("splitmftorderentryid") + "@seq:" + entry.getInt("seq");
            pageCache.put(key, (String)item.getValue());
        }
        pageCache.put("opProgressPro", "100");
    }

    public void dealData(Set<Long> srcEntryIdInSplitEntrys, List<DynamicObject> billEntryList, String pageCacheOption, Map<DynamicObject, String> res, Map<Long, BigDecimal> actSplitQtyMap) {
        String jsonString;
        HashMap<String, Object> calparam;
        TXHandle tXHandle;
        boolean issucess;
        HashSet<DynamicObject> newOmBillList;
        HashSet<DynamicObject> newBillList;
        block58: {
            int numInt = billEntryList.size();
            int indexInt = 0;
            HashMap<Long, BigDecimal> nonMainProSameSrcOrderEntrySplitQtyMap = new HashMap<Long, BigDecimal>();
            HashMap<Object, Map<String, Object>> splitMap = new HashMap<Object, Map<String, Object>>();
            List<DynamicObject> manftechInfos = OrderSplitValidateService.queryPushedManftechInfos("pom_mftorder", srcEntryIdInSplitEntrys);
            Set<Long> mftentryPkvalus = OrderSplitValidateService.manftechValFail(manftechInfos);
            Set<Long> mftentryOmPkvalus = OrderSplitValidateService.manftechOmValFail(manftechInfos);
            Set<Long> orderEntryIdsInUnAuditXmftorderBill = OrderSplitValidateService.queryUnAuditXmftorderBill(new ArrayList<Long>(srcEntryIdInSplitEntrys));
            Set<Long> orderEntryIdsInUnAuditXmftstockBill = OrderSplitValidateService.queryUnAuditXmftstockBill(new ArrayList<Long>(srcEntryIdInSplitEntrys));
            String selectPro = OrderSpliteService.getBillAllPropers("pom_mftorder", "treeentryentity");
            QFilter qFilter = new QFilter("treeentryentity.id", "in", srcEntryIdInSplitEntrys);
            DynamicObject[] mftorderBillForPks = BusinessDataServiceHelper.load((String)"pom_mftorder", (String)selectPro, (QFilter[])new QFilter[]{qFilter});
            ArrayList<DynamicObject> mftorderBillForPkList = new ArrayList<DynamicObject>(mftorderBillForPks.length);
            for (DynamicObject dynamicObject : mftorderBillForPks) {
                mftorderBillForPkList.add(dynamicObject);
            }
            Map<Long, BigDecimal> transferMap = OrderSpliteService.queryTransferQtyMap(srcEntryIdInSplitEntrys);
            DynamicObject[] techBillcol = OrderSpliteService.queryTechBillcol(srcEntryIdInSplitEntrys);
            Set<Long> nosplitNonmainEntryIds = OrderSplitValidateService.manftechValPass(mftorderBillForPkList, manftechInfos);
            HashMap<Object, Map<String, BigDecimal>> srcOrderEntryQtyMap = new HashMap<Object, Map<String, BigDecimal>>(16);
            HashMap<Object, BigDecimal> srcEntryfIdAndSeparableqtyMap = new HashMap<Object, BigDecimal>(16);
            HashSet<Long> srcNonMainProEntryIds = new HashSet<Long>(10);
            this.packgeCommonInfo(mftorderBillForPks, srcOrderEntryQtyMap, srcEntryfIdAndSeparableqtyMap, srcEntryIdInSplitEntrys, srcNonMainProEntryIds);
            srcNonMainProEntryIds.addAll(srcEntryIdInSplitEntrys);
            Map loadf7Map = BusinessDataServiceHelper.loadFromCache((String)"pom_mftorder_f7", (String)"entryseq", (QFilter[])new QFilter[]{new QFilter("id", "in", srcNonMainProEntryIds)});
            DynamicObject[] stockBillCol = StockCulUtils.queryStocks(srcEntryIdInSplitEntrys);
            HashSet<Long> srcPomEntryIdInSplitEntrys = new HashSet<Long>(16);
            HashSet<Long> srcOmEntryIdInSplitEntrys = new HashSet<Long>(16);
            for (DynamicObject splitEntry2 : billEntryList) {
                long srcEntryId = splitEntry2.getLong("splitmftorderentryid");
                String splitType = splitEntry2.getString("splittype");
                if ("P".equals(splitType)) {
                    srcPomEntryIdInSplitEntrys.add(srcEntryId);
                    continue;
                }
                if (!"O".equals(splitType)) continue;
                srcOmEntryIdInSplitEntrys.add(srcEntryId);
            }
            ArrayList<DynamicObject> pushBills = new ArrayList(10);
            if (srcPomEntryIdInSplitEntrys.size() > 0) {
                pushBills = OrderSpliteService.pushBills(mftorderBillForPkList, srcPomEntryIdInSplitEntrys, res);
            }
            ArrayList<DynamicObject> pushOmBills = new ArrayList(10);
            if (srcOmEntryIdInSplitEntrys.size() > 0) {
                pushOmBills = OrderSpliteService.pushOmBills(mftorderBillForPkList, srcOmEntryIdInSplitEntrys, res);
            }
            Map<String, List<Long>> pkMap = this.genNewOrderPkValues(billEntryList, mftorderBillForPks);
            HashMap<Object, DynamicObject> updateMap = new HashMap<Object, DynamicObject>(16);
            newBillList = new HashSet<DynamicObject>(10);
            newOmBillList = new HashSet<DynamicObject>(10);
            HashSet<DynamicObject> neworderList = new HashSet<DynamicObject>(10);
            HashMap<Object, Boolean> newBillMap = new HashMap<Object, Boolean>(16);
            for (DynamicObject dynamicObject : billEntryList) {
                long srcEntryId = dynamicObject.getLong("splitmftorderentryid");
                Object srcEntryIdObj = dynamicObject.get("splitmftorderentryid");
                String splitType = dynamicObject.getString("splittype");
                DynamicObject mftorderBill = this.matchOrderBill(mftorderBillForPkList, srcEntryId, true);
                String orderEntityName = ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355", (String)"MyTaskSplitOrder_12", (String)"bd-mpdm-business", (Object[])new Object[0]);
                DynamicObject pushmftorderBill = null;
                if ("P".equals(splitType)) {
                    pushmftorderBill = this.matchOrderBill(pushBills, srcEntryId, false);
                } else if ("O".equals(splitType)) {
                    pushmftorderBill = this.matchOrderBill(pushOmBills, srcEntryId, false);
                    orderEntityName = ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355", (String)"MyTaskSplitOrder_13", (String)"bd-mpdm-business", (Object[])new Object[0]);
                }
                if (null == pushmftorderBill) {
                    this.dealErrorResult(dynamicObject, res, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u5206\u5f55\u7b2c%1$s\u884c\u6267\u884c\u4e0b\u63a8\u65f6\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u62c6\u5206\u5931\u8d25\u3002", (String)"MyTaskSplitOrder_5", (String)"bd-mpdm-business", (Object[])new Object[0]), dynamicObject.get("seq")));
                }
                if (null == mftorderBill || !this.checkInfo(mftorderBill, mftentryPkvalus, mftentryOmPkvalus, orderEntryIdsInUnAuditXmftorderBill, orderEntryIdsInUnAuditXmftstockBill, res, dynamicObject, srcEntryfIdAndSeparableqtyMap, actSplitQtyMap, stockBillCol, transferMap, techBillcol)) {
                    ++indexInt;
                    if (StringUtils.isNotBlank((CharSequence)pageCacheOption)) {
                        PageCache pageCache = new PageCache(pageCacheOption);
                        pageCache.put("opProgressPro", String.valueOf((indexInt - 1) * 100 / numInt));
                    }
                    if (!OrderSpliteService.isStop(pageCacheOption)) continue;
                    return;
                }
                DynamicObject mftorderBillForNew = (DynamicObject)OrmUtils.clone((IDataEntityBase)pushmftorderBill, (boolean)true, (boolean)true);
                DynamicObject newMftOrderBill = this.createNewMftOrder(mftorderBillForNew, srcEntryId, dynamicObject, nonMainProSameSrcOrderEntrySplitQtyMap, pkMap, loadf7Map, srcOrderEntryQtyMap, mftorderBill, splitMap, nosplitNonmainEntryIds, newBillMap);
                this.updateSrcMftOrder(mftorderBill, res, dynamicObject, newMftOrderBill, actSplitQtyMap);
                if (StringUtils.isBlank((CharSequence)res.get(dynamicObject))) {
                    neworderList.add(newMftOrderBill);
                    updateMap.put(mftorderBill.getPkValue(), mftorderBill);
                    if (newMftOrderBill.getDataEntityType().getName().equals("pom_mftorder")) {
                        newBillList.add(newMftOrderBill);
                    } else if (newMftOrderBill.getDataEntityType().getName().equals("om_mftorder")) {
                        newOmBillList.add(newMftOrderBill);
                    }
                    this.packageArgsForNextStep(srcEntryIdObj, newMftOrderBill, mftorderBill);
                    if (StringUtils.isNotBlank((CharSequence)pageCacheOption)) {
                        this.dealErrorResult(dynamicObject, res, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a%1$s\u7684%2$s\uff0c\u751f\u6210\u6210\u529f\u3002", (String)"MyTaskSplitOrder_14", (String)"bd-mpdm-business", (Object[])new Object[0]), newMftOrderBill.getString("billno"), orderEntityName));
                        OrderSplitHelper.validPickingPaires(res, dynamicObject, mftorderBill);
                    }
                }
                ++indexInt;
                if (StringUtils.isNotBlank((CharSequence)pageCacheOption)) {
                    PageCache pageCache = new PageCache(pageCacheOption);
                    pageCache.put("opProgressPro", String.valueOf((indexInt - 1) * 100 / numInt));
                }
                if (!OrderSpliteService.isStop(pageCacheOption)) continue;
                return;
            }
            if (StringUtils.equals((CharSequence)"mps_scheduleplan", (CharSequence)this.dispatchSource)) {
                this.setManuVersion(newBillList, neworderList, newBillMap);
            }
            this.setManuVersion(newBillList, neworderList, newBillMap);
            Throwable throwable = null;
            try (TXHandle tx2 = TX.requiresNew((String)"splitOrder-save");){
                DynamicObject entry;
                DynamicObjectCollection entrys;
                logger.info("MyTaskSplitOrder\uff1anewBillList size:" + newBillList.size());
                logger.info("MyTaskSplitOrder\uff1anewOmBillList size:" + newOmBillList.size());
                if (newBillList.size() > 0) {
                    for (DynamicObject newOrder : newBillList) {
                        entrys = newOrder.getDynamicObjectCollection("treeentryentity");
                        for (int i = 0; i < entrys.size(); ++i) {
                            entry = (DynamicObject)entrys.get(i);
                            entry.set("seq", (Object)(i + 1));
                            this.updateUnReportQty(entry);
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])newBillList.toArray(new DynamicObject[newBillList.size()]));
                    logger.info("MyTaskSplitOrder\uff1a\u5de5\u5355\u4fdd\u5b58");
                }
                if (newOmBillList.size() > 0) {
                    for (DynamicObject newOrder : newOmBillList) {
                        entrys = newOrder.getDynamicObjectCollection("treeentryentity");
                        for (int i = 0; i < entrys.size(); ++i) {
                            entry = (DynamicObject)entrys.get(i);
                            entry.set("seq", (Object)(i + 1));
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])newOmBillList.toArray(new DynamicObject[newOmBillList.size()]));
                    logger.info("MyTaskSplitOrder\uff1a\u59d4\u5916\u5de5\u5355\u4fdd\u5b58");
                }
            }
            catch (Throwable srcEntryId) {
                Throwable throwable2 = srcEntryId;
                throw srcEntryId;
            }
            issucess = true;
            tXHandle = TX.requiresNew((String)"splitOrder-genstock-technics");
            try {
                Collection valueCollection = updateMap.values();
                ArrayList<DynamicObject> updateBillList = new ArrayList<DynamicObject>(valueCollection);
                if (updateBillList.size() > 0) {
                    this.updateOrderBills(updateBillList);
                }
                if (this.orderEntryIds.size() <= 0) break block58;
                DynamicObjectCollection entryEntity = mftorderBillForPks[0].getDynamicObjectCollection("treeentryentity");
                if (!entryEntity.isEmpty()) {
                    IDataEntityType dataEntityType = ((DynamicObject)entryEntity.get(0)).getDataEntityType();
                    DataEntityCacheManager cacheManager = new DataEntityCacheManager(dataEntityType);
                    cacheManager.removeByDt();
                }
                if (StringUtils.equals((CharSequence)"mps_scheduleplan", (CharSequence)this.dispatchSource)) {
                    StockCulUtils.generateStockByOrderMps(this.orderEntryIds, this.newOrderEntryMap, this.newOrderMap, this.oldOrderMap, manftechInfos);
                    OrderSplitTechnicsHelper.orderSpiltTechnicsBillMps(this.orderEntryIds, this.newOrderEntryMap, this.newOrderMap, this.orderEntryMap, this.oldOrderMap);
                } else {
                    StockCulUtils.generateStockByOrder(this.orderEntryIds, this.newOrderEntryMap, this.newOrderMap, this.oldOrderMap, manftechInfos);
                    OrderSplitTechnicsHelper.orderSpiltTechnicsBill(this.orderEntryIds, this.newOrderEntryMap, this.newOrderMap, this.orderEntryMap, this.oldOrderMap);
                }
                StockCulUtils.splitLog(this.orderEntryIds, this.newOrderEntryMap, this.newOrderMap, this.oldOrderMap, splitMap);
            }
            catch (Exception e) {
                try {
                    tXHandle.markRollback();
                    issucess = false;
                    throw e;
                }
                catch (Throwable throwable3) {
                    tXHandle.close();
                    if (!issucess) {
                        OperationResult executeOperate;
                        logger.error("MyTaskSplitOrder\uff1a\u5de5\u5355\u56de\u6eda");
                        OperateOption create = OperateOption.create();
                        create.setVariableValue("ishasright", "false");
                        create.setVariableValue("ignorewarn", "true");
                        create.setVariableValue("ignoreinteraction", "true");
                        if (newBillList.size() > 0) {
                            executeOperate = OperationServiceHelper.executeOperate((String)"delete", (String)"pom_mftorder", (DynamicObject[])newBillList.toArray(new DynamicObject[newBillList.size()]), (OperateOption)create);
                            logger.info("MyTaskSplitOrder\uff1aexecuteOperate:" + OrderOpUtils.getErrDetail((OperationResult)executeOperate));
                            if (!executeOperate.isSuccess()) {
                                logger.error(String.format(ResManager.loadKDString((String)"\u56de\u6eda\u5de5\u5355\u5f02\u5e38\uff1a%1$s", (String)"MyTaskSplitOrder_15", (String)"bd-mpdm-business", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)executeOperate)));
                            }
                        }
                        if (newOmBillList.size() > 0) {
                            logger.info("MyTaskSplitOrder\uff1anewOmBillList size: newOmBillList.size()");
                            executeOperate = OperationServiceHelper.executeOperate((String)"delete", (String)"om_mftorder", (DynamicObject[])newOmBillList.toArray(new DynamicObject[newOmBillList.size()]), (OperateOption)create);
                            logger.info("MyTaskSplitOrder\uff1aexecuteOperate:" + OrderOpUtils.getErrDetail((OperationResult)executeOperate));
                            if (!executeOperate.isSuccess()) {
                                logger.error(String.format(ResManager.loadKDString((String)"\u56de\u6eda\u5de5\u5355\u5f02\u5e38\uff1a%1$s", (String)"MyTaskSplitOrder_15", (String)"bd-mpdm-business", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)executeOperate)));
                            }
                        }
                    }
                    throw throwable3;
                }
            }
        }
        tXHandle.close();
        if (!issucess) {
            OperationResult executeOperate;
            logger.error("MyTaskSplitOrder\uff1a\u5de5\u5355\u56de\u6eda");
            OperateOption create = OperateOption.create();
            create.setVariableValue("ishasright", "false");
            create.setVariableValue("ignorewarn", "true");
            create.setVariableValue("ignoreinteraction", "true");
            if (newBillList.size() > 0) {
                executeOperate = OperationServiceHelper.executeOperate((String)"delete", (String)"pom_mftorder", (DynamicObject[])newBillList.toArray(new DynamicObject[newBillList.size()]), (OperateOption)create);
                logger.info("MyTaskSplitOrder\uff1aexecuteOperate:" + OrderOpUtils.getErrDetail((OperationResult)executeOperate));
                if (!executeOperate.isSuccess()) {
                    logger.error(String.format(ResManager.loadKDString((String)"\u56de\u6eda\u5de5\u5355\u5f02\u5e38\uff1a%1$s", (String)"MyTaskSplitOrder_15", (String)"bd-mpdm-business", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)executeOperate)));
                }
            }
            if (newOmBillList.size() > 0) {
                logger.info("MyTaskSplitOrder\uff1anewOmBillList size: newOmBillList.size()");
                executeOperate = OperationServiceHelper.executeOperate((String)"delete", (String)"om_mftorder", (DynamicObject[])newOmBillList.toArray(new DynamicObject[newOmBillList.size()]), (OperateOption)create);
                logger.info("MyTaskSplitOrder\uff1aexecuteOperate:" + OrderOpUtils.getErrDetail((OperationResult)executeOperate));
                if (!executeOperate.isSuccess()) {
                    logger.error(String.format(ResManager.loadKDString((String)"\u56de\u6eda\u5de5\u5355\u5f02\u5e38\uff1a%1$s", (String)"MyTaskSplitOrder_15", (String)"bd-mpdm-business", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)executeOperate)));
                }
            }
        }
        if (!this.orderEntryIdsForUpdate.isEmpty() && !this.orderIdsForUpdate.isEmpty()) {
            calparam = new HashMap<String, Object>();
            calparam.put("orderentryids", this.orderEntryIdsForUpdate);
            calparam.put("orderids", this.orderIdsForUpdate);
            calparam.put("operate", "audit");
            calparam.put("iscloseorder", "0");
            calparam.put("modetype", "1");
            calparam.put("isautocal", "0");
            calparam.put("isautoflag", "0");
            jsonString = JSON.toJSONString(calparam);
            EventServiceHelper.triggerEventSubscribe((String)"auditCalMaterial", (String)jsonString);
        }
        if (!this.orderEntryIdsForUpdate.isEmpty()) {
            calparam = new HashMap();
            calparam.put("orderentryids", this.orderEntryIdsForUpdate);
            jsonString = JSON.toJSONString(calparam);
            EventServiceHelper.triggerEventSubscribe((String)"orderSplitExpand", (String)jsonString);
        }
        ThreadPools.executeOnce((String)"MyTaskSplitOrder_Operate", () -> {
            try {
                DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mrp", (String)"INetChangeSynService", (String)"synSplitManuFactureOrderRecords", (Object[])new Object[]{newBillList.toArray(new DynamicObject[0])});
            }
            catch (Exception ex) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
            }
        });
    }

    private void setManuVersion(Set<DynamicObject> newBillList, Set<DynamicObject> neworderList, Map<Object, Boolean> newBillMap) {
        Map<Long, Long> filterManuVersion;
        HashSet<DynamicObject> saveBills = new HashSet<DynamicObject>(newBillList.size());
        boolean isEnablePlanScope = (Boolean)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IPlanScopeService", (String)"isEnablePlanScope", (Object[])new Object[0]);
        if (neworderList.size() > 0) {
            for (DynamicObject newOrder : neworderList) {
                DynamicObject transactiontype = newOrder.getDynamicObject("transactiontype");
                if (!transactiontype.getBoolean("versionreq") && !isEnablePlanScope) continue;
                saveBills.add(newOrder);
            }
        }
        if ((filterManuVersion = this.getManuVersionData(saveBills)).size() > 0) {
            Map manuversions = MsManuVersionQueryHelper.getDataCacheBySet(new HashSet<Long>(filterManuVersion.values()));
            for (DynamicObject newOrder : neworderList) {
                DynamicObject transactiontype = newOrder.getDynamicObject("transactiontype");
                if (!transactiontype.getBoolean("versionreq") && !isEnablePlanScope) continue;
                DynamicObjectCollection entrys = newOrder.getDynamicObjectCollection("treeentryentity");
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    Long manuVersionId = filterManuVersion.get(entry.getLong("id"));
                    if (manuVersionId != null && !manuVersionId.equals(0L)) {
                        DynamicObject manuVersion = (DynamicObject)manuversions.get(manuVersionId);
                        entry.set("manuversion", (Object)manuVersion);
                        if (manuVersion != null) {
                            entry.set("scheduler", manuVersion.get("person"));
                            entry.set("bomid", manuVersion.get("bom"));
                            entry.set("processroute", manuVersion.get("processroute"));
                            continue;
                        }
                    }
                    entry.set("manuversion", null);
                    entry.set("scheduler", null);
                    entry.set("bomid", null);
                    entry.set("processroute", null);
                }
            }
        }
    }

    private Map<Long, Long> getManuVersionData(Set<DynamicObject> saveBills) {
        ArrayList params = new ArrayList(16);
        for (DynamicObject order : saveBills) {
            Long orgId = order.getDynamicObject("org").getLong("id");
            DynamicObjectCollection entrys = order.getDynamicObjectCollection("treeentryentity");
            for (int i = 0; i < entrys.size(); ++i) {
                PluginProxy<IAutoSetManuVersionParamEntryExt> newExtPlugin;
                DynamicObject auxPropertyDyn;
                DynamicObject configureDyn;
                HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                paramMap.put("bizorg", orgId);
                DynamicObject entry = (DynamicObject)entrys.get(i);
                Object materialInfoId = entry.getDynamicObject("material").getPkValue();
                paramMap.put("materialInfo", materialInfoId);
                Object materialId = entry.getDynamicObject("materielmasterid").getPkValue();
                paramMap.put("material", materialId);
                Date expBomDat = entry.getDate("expendbomtime");
                paramMap.put("bomdate", new Date());
                BigDecimal qtyDec = entry.getBigDecimal("baseqty");
                paramMap.put("qty", qtyDec);
                DynamicObject workCenterDyn = entry.getDynamicObject("workcenter");
                if (workCenterDyn != null) {
                    paramMap.put("workcenter", workCenterDyn.getPkValue());
                }
                if ((configureDyn = entry.getDynamicObject("configuredcode")) != null) {
                    paramMap.put("configure", configureDyn.getPkValue());
                }
                if ((auxPropertyDyn = entry.getDynamicObject("auxproperty")) != null) {
                    paramMap.put("auxproperty", auxPropertyDyn.getPkValue());
                }
                if ((newExtPlugin = AutoSetManuVersionParamEntryHelper.genExtPluginxy()) != null) {
                    newExtPlugin.callReplace(p -> {
                        p.setFilterManuVersionEntryParam(paramMap, entry);
                        return null;
                    });
                }
                params.add(paramMap);
            }
        }
        Map versionMap = new HashMap(16);
        if (params != null && params.size() > 0) {
            versionMap = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IAutoSetManuVersionService", (String)"getBatchManuVersion", (Object[])new Object[]{params});
        }
        HashMap<Long, Long> filterManuVersion = new HashMap<Long, Long>(16);
        for (DynamicObject order : saveBills) {
            long bizeOrg = order.getDynamicObject("org").getLong("id");
            if (versionMap.size() == 0) continue;
            Map versionResMap = (Map)versionMap.get(bizeOrg);
            DynamicObjectCollection entrys = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : entrys) {
                Object materialId = entry.getDynamicObject("materielmasterid").getPkValue();
                Set versions = (Set)versionResMap.get(materialId);
                if (versions == null || versions.size() <= 0) continue;
                DynamicObject version = (DynamicObject)versions.toArray()[0];
                filterManuVersion.put(entry.getLong("id"), version.getLong("id"));
            }
        }
        return filterManuVersion;
    }

    private Map<String, List<Long>> genNewOrderPkValues(List<DynamicObject> billEntryList, DynamicObject[] mftorderBillForPks) {
        int newPomEntryNum = this.countNewEntryIdNum("P", billEntryList, mftorderBillForPks);
        int newOmEntryNum = this.countNewEntryIdNum("O", billEntryList, mftorderBillForPks);
        List<Long> pkPomValues = this.genPkValues(newPomEntryNum, "pom_mftorder");
        List<Long> pkOmValues = this.genPkValues(newOmEntryNum, "om_mftorder");
        HashMap<String, List<Long>> pkMap = new HashMap<String, List<Long>>(16);
        pkMap.put("pkPomValues", pkPomValues);
        pkMap.put("pkOmValues", pkOmValues);
        return pkMap;
    }

    private Long getPkValue(String orderType, Map<String, List<Long>> pkMap) {
        long pkvalue = 0L;
        if ("pom_mftorder".equals(orderType)) {
            pkvalue = pkMap.get("pkPomValues").get(this.pkValuePomConner);
            ++this.pkValuePomConner;
        } else if ("om_mftorder".equals(orderType)) {
            pkvalue = pkMap.get("pkOmValues").get(this.pkValueOmConner);
            ++this.pkValueOmConner;
        }
        return pkvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOrderBills(List<DynamicObject> updateBillList) {
        DataSet prblentryDataSet = null;
        HashMap<Long, Date> inBillAuditDateMap = new HashMap<Long, Date>(16);
        try {
            QFilter prblentryFilter = new QFilter("billentry.manuentryid", "in", this.orderEntryIdsForUpdateEndWorkTime);
            prblentryFilter.and(new QFilter("billstatus", "=", (Object)"C"));
            String prblentryFieldsStr = "billentry.manuentryid,auditdate";
            prblentryDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_mdc_mftmanuinbill", (String)prblentryFieldsStr, (QFilter[])prblentryFilter.toArray(), (String)"auditdate");
            if (prblentryDataSet.hasNext()) {
                Row row = prblentryDataSet.next();
                inBillAuditDateMap.put(row.getLong("billentry.manuentryid"), row.getDate("auditdate"));
            }
        }
        finally {
            if (null != prblentryDataSet) {
                prblentryDataSet.close();
            }
        }
        for (DynamicObject orderBill : updateBillList) {
            DynamicObjectCollection entrys = orderBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : entrys) {
                long entryId = Long.parseLong(entry.getPkValue().toString());
                if (this.orderEntryIdsForUpdateEndWorkTime.contains(entryId)) {
                    entry.set("taskstatus", (Object)ManuBillTaskStatusEnum.ENDWORK.getValue());
                    entry.set("endworktime", inBillAuditDateMap.get(entryId));
                }
                this.updateUnReportQty(entry);
            }
        }
        SaveServiceHelper.update((DynamicObject[])updateBillList.toArray(new DynamicObject[0]));
    }

    private void updateUnReportQty(DynamicObject entry) {
        BigDecimal qty = entry.getBigDecimal("qty");
        BigDecimal reportQty = entry.get("reportqty") == null ? BigDecimal.ZERO : entry.getBigDecimal("reportqty");
        BigDecimal repairQty = entry.get("repairqty") == null ? BigDecimal.ZERO : entry.getBigDecimal("repairqty");
        BigDecimal unReportQty = qty.subtract(reportQty).add(repairQty);
        unReportQty = unReportQty.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : unReportQty;
        entry.set("unreportqty", (Object)unReportQty);
    }

    private void packgeCommonInfo(DynamicObject[] mftorderBillForPks, Map<Object, Map<String, BigDecimal>> srcOrderEntryQtyMap, Map<Object, BigDecimal> srcEntryfIdAndSeparableqtyMap, Set<Long> srcEntryIdInSplitEntrys, Set<Long> srcNonMainProEntryIds) {
        for (DynamicObject mftorderBill : mftorderBillForPks) {
            DynamicObjectCollection mftorderBillEntrys = mftorderBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject mftorderBillEntry : mftorderBillEntrys) {
                DynamicObject unit = mftorderBillEntry.getDynamicObject("unit");
                DynamicObject baseUnit = mftorderBillEntry.getDynamicObject("baseunit");
                DynamicObject material = mftorderBillEntry.getDynamicObject("material");
                if (null != material) {
                    material = material.getDynamicObject("masterid");
                }
                BigDecimal qty = mftorderBillEntry.getBigDecimal("qty");
                BigDecimal rptqty = mftorderBillEntry.getBigDecimal("rptqty");
                BigDecimal baseQty = mftorderBillEntry.getBigDecimal("baseqty");
                BigDecimal stockBaseQty = mftorderBillEntry.getBigDecimal("stockqty");
                BigDecimal rptMin = qty.subtract(rptqty);
                BigDecimal stockMin = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)baseUnit, (BigDecimal)baseQty.subtract(stockBaseQty), (DynamicObject)unit);
                logger.info(String.format("rptMin:%s,stockMin:%s,material,%s,baseUnit:%s,unit:%s,baseQty:%s,stockBaseQty:%s", rptMin, stockMin, material == null ? "" : material.getPkValue().toString(), baseUnit == null ? "" : baseUnit.getPkValue().toString(), unit == null ? "" : unit.getPkValue().toString(), baseQty, stockBaseQty));
                BigDecimal quantitySplitQty = rptMin.min(stockMin);
                quantitySplitQty = quantitySplitQty.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : quantitySplitQty;
                HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>(16);
                qtyMap.put("qty", mftorderBillEntry.getBigDecimal("qty"));
                qtyMap.put("rptqty", mftorderBillEntry.getBigDecimal("rptqty"));
                qtyMap.put("baseqty", mftorderBillEntry.getBigDecimal("baseqty"));
                qtyMap.put("stockqty", mftorderBillEntry.getBigDecimal("stockqty"));
                srcOrderEntryQtyMap.put(mftorderBillEntry.getPkValue(), qtyMap);
                srcEntryfIdAndSeparableqtyMap.put(mftorderBillEntry.getPkValue(), quantitySplitQty);
                logger.info(String.format("PkValue:%s,quantitySplitQty:%s", mftorderBillEntry.getPkValue().toString(), quantitySplitQty));
                long entryPid = mftorderBillEntry.getLong("pid");
                if (null == mftorderBillEntry || !srcEntryIdInSplitEntrys.contains(entryPid)) continue;
                srcNonMainProEntryIds.add(mftorderBillEntry.getLong("id"));
            }
        }
    }

    private DynamicObject matchOrderBill(List<DynamicObject> mftorderBillForPks, Long srcEntryId, boolean matchIdFlag) {
        DynamicObject mftorderBill = null;
        block0: for (DynamicObject mftorderBillForPk : mftorderBillForPks) {
            if (null == mftorderBillForPk) continue;
            DynamicObjectCollection mftorderBillForPkEntrys = mftorderBillForPk.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject mftorderBillForPkEntry : mftorderBillForPkEntrys) {
                DynamicObject srcsplitbillseq;
                Long mftorderBillForPkEntryId = mftorderBillForPkEntry.getLong("id");
                if (!matchIdFlag && null != (srcsplitbillseq = mftorderBillForPkEntry.getDynamicObject("srcsplitbillseq"))) {
                    mftorderBillForPkEntryId = srcsplitbillseq.getLong("id");
                }
                if (!srcEntryId.equals(mftorderBillForPkEntryId)) continue;
                mftorderBill = mftorderBillForPk;
                continue block0;
            }
        }
        return mftorderBill;
    }

    private void packageArgsForNextStep(Object srcEntryIdObj, DynamicObject newMftOrderBill, DynamicObject mftorderBill) {
        this.orderEntryIds.add(srcEntryIdObj);
        List<DynamicObject> newOrderEntryList = this.newOrderEntryMap.get(srcEntryIdObj);
        if (null == newOrderEntryList) {
            newOrderEntryList = new ArrayList<DynamicObject>(10);
        }
        DynamicObjectCollection newOrderEntrys = newMftOrderBill.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject newOrderEntry : newOrderEntrys) {
            if (null == newOrderEntry) continue;
            Object newEntryId = newOrderEntry.getPkValue();
            String newMftOrderEntryProducttype = newOrderEntry.getString("producttype");
            if (StringUtils.equals((CharSequence)"C", (CharSequence)newMftOrderEntryProducttype)) {
                newOrderEntryList.add(newOrderEntry);
            } else {
                DynamicObject srcsplitbillseqObj = newOrderEntry.getDynamicObject("srcsplitbillseq");
                if (null != srcsplitbillseqObj) {
                    List<DynamicObject> nonMainEntryList = this.newOrderEntryMap.get(srcsplitbillseqObj.get("id"));
                    if (null == nonMainEntryList) {
                        nonMainEntryList = new ArrayList<DynamicObject>(10);
                        this.orderEntryIds.add(srcsplitbillseqObj.get("id"));
                        this.oldOrderMap.put(srcsplitbillseqObj.get("id"), mftorderBill);
                    }
                    nonMainEntryList.add(newOrderEntry);
                    this.newOrderEntryMap.put(srcsplitbillseqObj.get("id"), nonMainEntryList);
                }
            }
            this.newOrderMap.put(newEntryId, newMftOrderBill);
        }
        this.newOrderEntryMap.put(srcEntryIdObj, newOrderEntryList);
        DynamicObjectCollection oldOrderEntrys = mftorderBill.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject oldOrderEntry : oldOrderEntrys) {
            if (null == oldOrderEntry || !srcEntryIdObj.equals(oldOrderEntry.getPkValue()) || !StringUtils.equals((CharSequence)"C", (CharSequence)oldOrderEntry.getString("producttype"))) continue;
            this.orderEntryMap.put(srcEntryIdObj, oldOrderEntry);
        }
        this.oldOrderMap.put(srcEntryIdObj, mftorderBill);
    }

    private List<Long> genPkValues(int size, String entityName) {
        ORM orm = ORM.create();
        long[] genLongIds = orm.genLongIds(entityName + ".treeentryentity", size);
        return Longs.asList((long[])genLongIds);
    }

    private int countNewEntryIdNum(String splitType, List<DynamicObject> billEntryList, DynamicObject[] mftorderBillForPks) {
        int result = 0;
        if (null != billEntryList && billEntryList.size() > 0) {
            for (DynamicObject billEntry : billEntryList) {
                Long srcEntryId = billEntry.getLong("splitmftorderentryid");
                String entrySplitType = billEntry.getString("splittype");
                if (null == srcEntryId || !splitType.equals(entrySplitType)) continue;
                for (DynamicObject mftorderBill : mftorderBillForPks) {
                    if (null == mftorderBill) continue;
                    DynamicObjectCollection entrys = mftorderBill.getDynamicObjectCollection("treeentryentity");
                    for (DynamicObject entry : entrys) {
                        if (null == entry) continue;
                        Long entryId = entry.getLong("id");
                        Long entryPId = entry.getLong("pid");
                        if (!entryId.equals(srcEntryId) && !srcEntryId.equals(entryPId)) continue;
                        ++result;
                    }
                }
            }
            result += billEntryList.size();
        }
        return result;
    }

    private boolean checkInfo(DynamicObject mftorderBill, Set<Long> mftentryPkvalus, Set<Long> mftentryOmPkvalus, Set<Long> orderEntryIdsInUnAuditXmftorderBill, Set<Long> orderEntryIdsInUnAuditXmftstockBill, Map<DynamicObject, String> res, DynamicObject splitEntry, Map<Object, BigDecimal> srcEntryfIdAndSeparableqtyMap, Map<Long, BigDecimal> actSplitQtyMap, DynamicObject[] stockBillCol, Map<Long, BigDecimal> transferMap, DynamicObject[] techBillcol) {
        boolean result = Boolean.TRUE;
        if (null != mftorderBill && null != splitEntry) {
            Long orderEntryId = splitEntry.getLong("splitmftorderentryid");
            String splitType = splitEntry.getString("splittype");
            DynamicObjectCollection mftorderEntrys = mftorderBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject mftorderEntry : mftorderEntrys) {
                String opName;
                DynamicObject techBill;
                String checkOrderEntryQty;
                String checkOrderEntrysStatus;
                String unAuditXmftstockInfo;
                String unAuditXmftorderInfo;
                String planStatusInfo;
                String dispatchSource;
                Long entryId;
                if (null == mftorderEntry || !orderEntryId.equals(entryId = Long.valueOf(mftorderEntry.getLong("id")))) continue;
                String allSplitInfo = OrderSplitValidateService.checkAllSplitInfo(mftorderEntry, actSplitQtyMap, mftorderBill.getDynamicObjectType().getDisplayName().getLocaleValue());
                if (StringUtils.isNotBlank((CharSequence)allSplitInfo)) {
                    this.dealErrorResult(splitEntry, res, allSplitInfo);
                }
                if (StringUtils.equals((CharSequence)"mps_scheduleplan", (CharSequence)(dispatchSource = this.getDispatchSource())) && StringUtils.isNotBlank((CharSequence)(planStatusInfo = OrderSplitValidateService.checkOrderPlanStatus(mftorderBill, mftorderEntry, splitEntry)))) {
                    this.dealErrorResult(splitEntry, res, planStatusInfo);
                }
                if (StringUtils.isNotBlank((CharSequence)(unAuditXmftorderInfo = OrderSplitValidateService.checkUnAuditXmftorderInfo(mftorderEntry, orderEntryIdsInUnAuditXmftorderBill)))) {
                    this.dealErrorResult(splitEntry, res, unAuditXmftorderInfo);
                }
                if (StringUtils.isNotBlank((CharSequence)(unAuditXmftstockInfo = OrderSplitValidateService.checkUnAuditXmftstockInfo(mftorderEntry, orderEntryIdsInUnAuditXmftstockBill)))) {
                    this.dealErrorResult(splitEntry, res, unAuditXmftstockInfo);
                }
                String checkSfcMaInfo = "";
                if ("P".equals(splitType)) {
                    checkSfcMaInfo = OrderSplitValidateService.checkSfcMaInfo(mftorderEntry, mftentryPkvalus);
                } else if ("O".equals(splitType)) {
                    checkSfcMaInfo = OrderSplitValidateService.checkSfcOmMaInfo(mftorderEntry, mftentryOmPkvalus);
                }
                if (StringUtils.isNotBlank((CharSequence)checkSfcMaInfo)) {
                    this.dealErrorResult(splitEntry, res, checkSfcMaInfo);
                }
                if (StringUtils.isNotBlank((CharSequence)(checkOrderEntrysStatus = OrderSplitValidateService.checkOrderEntrysStatus(mftorderEntry)))) {
                    this.dealErrorResult(splitEntry, res, checkOrderEntrysStatus);
                }
                if (StringUtils.isNotBlank((CharSequence)(checkOrderEntryQty = OrderSplitValidateService.checkOrderEntryQtyNew(mftorderEntry, mftorderBill, transferMap, techBill = OrderSpliteService.matchTechBill(techBillcol, orderEntryId), opName = ResManager.loadKDString((String)"\u62c6\u5206\u5de5\u5355", (String)"MyTaskSplitOrder_10", (String)"bd-mpdm-business", (Object[])new Object[0]))))) {
                    String info = String.format(ResManager.loadKDString((String)"\u62c6\u5206\u5de5\u5355\u7684\u751f\u4ea7\u5de5\u5355\u5206\u5f55\u884c%1$s", (String)"MyTaskSplitOrder_11", (String)"bd-mpdm-business", (Object[])new Object[0]), checkOrderEntryQty);
                    this.dealErrorResult(splitEntry, res, info);
                }
                BigDecimal splitQty = splitEntry.getBigDecimal("splitqty");
                BigDecimal separableqty = srcEntryfIdAndSeparableqtyMap.get(mftorderEntry.getPkValue());
                if (separableqty.compareTo(splitQty) < 0) {
                    logger.info(String.format("PkValue:%s,separableqty:%s,splitQty:%s", mftorderEntry.getPkValue().toString(), separableqty, splitQty));
                    this.dealErrorResult(splitEntry, res, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u5206\u5f55\u7b2c%1$s\u884c\u62c6\u5206\u6570\u91cf\u4e0d\u6ee1\u8db3\u53ef\u62c6\u5206\u6570\u91cf\uff0c\u62c6\u5206\u5931\u8d25\u3002", (String)"MyTaskSplitOrder_7", (String)"bd-mpdm-business", (Object[])new Object[0]), splitEntry.get("seq")));
                } else {
                    srcEntryfIdAndSeparableqtyMap.put(mftorderEntry.getPkValue(), separableqty.subtract(splitQty));
                }
                if (!StringUtils.isNotBlank((CharSequence)res.get(splitEntry))) break;
                result = Boolean.FALSE;
                break;
            }
        }
        return result;
    }

    private void dealErrorResult(DynamicObject billEntryDym, Map<DynamicObject, String> res, String errroInfo) {
        if (null != billEntryDym) {
            String errorInfos = res.get(billEntryDym);
            if (StringUtils.isNotBlank((CharSequence)errorInfos)) {
                errroInfo = errorInfos.substring(0, errorInfos.length() - 1) + ";" + errroInfo;
            }
            res.put(billEntryDym, errroInfo);
        }
    }

    private DynamicObject createNewMftOrder(DynamicObject mftorderBillNew, long srcEntryId, DynamicObject splitEntry, Map<Long, BigDecimal> nonMainProSameSrcOrderEntrySplitQtyMap, Map<String, List<Long>> pkMap, Map<Object, DynamicObject> loadf7Map, Map<Object, Map<String, BigDecimal>> srcOrderEntryMap, DynamicObject mftorderBill, Map<Object, Map<String, Object>> splitMap, Set<Long> nosplitNonmainEntryIds, Map<Object, Boolean> newBillMap) {
        DynamicObject transactiontype;
        String orderType = mftorderBillNew.getDataEntityType().getName();
        List<Long> entryIds = OrderSpliteService.matchOrderEntryIdsInOrderBill(srcEntryId, mftorderBill);
        DynamicObjectCollection mftorderBillEntrys = mftorderBillNew.getDynamicObjectCollection("treeentryentity");
        boolean isprocedure = false;
        if ("om_mftorder".equals(orderType)) {
            mftorderBillNew.set("billtype", splitEntry.get("splitbilltype"));
            mftorderBillNew.set("transactiontype", splitEntry.get("splittransactiontype"));
        }
        if (null != (transactiontype = mftorderBillNew.getDynamicObject("transactiontype"))) {
            isprocedure = transactiontype.getBoolean("isprocedure");
        }
        Iterator it = mftorderBillEntrys.iterator();
        while (it.hasNext()) {
            DynamicObject mftorderBillEntry = (DynamicObject)it.next();
            if (null == mftorderBillEntry) continue;
            DynamicObject srcsplitbillseq = mftorderBillEntry.getDynamicObject("srcsplitbillseq");
            if (null == srcsplitbillseq || !entryIds.contains(srcsplitbillseq.getLong("id")) || isprocedure && nosplitNonmainEntryIds.contains(srcsplitbillseq.getLong("id"))) {
                it.remove();
                continue;
            }
            if (null == loadf7Map) continue;
            mftorderBillEntry.set("srcsplitbillseq", (Object)loadf7Map.get(srcsplitbillseq.getLong("id")));
        }
        long pkvalue = this.getPkValue(orderType, pkMap);
        this.pakageNewMftOrderBillHead(mftorderBillNew, pkvalue);
        long entryPkValueInMainPro = 0L;
        DynamicObjectCollection newMftOrderEntrys = mftorderBillNew.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject newMftOrderEntry : newMftOrderEntrys) {
            if (null == newMftOrderEntry) continue;
            String newMftOrderEntryProducttype = newMftOrderEntry.getString("producttype");
            HashMap<String, Object> splitMapTemp = new HashMap<String, Object>(16);
            if (StringUtils.equals((CharSequence)"C", (CharSequence)newMftOrderEntryProducttype)) {
                entryPkValueInMainPro = this.getPkValue(orderType, pkMap);
                newMftOrderEntry.set("id", (Object)entryPkValueInMainPro);
                this.pakageNewMftOrderEntryMainPro(newMftOrderEntry, splitEntry);
                splitMapTemp.put("splitreason", splitEntry.get("splitreason"));
                splitMap.put(entryPkValueInMainPro, splitMapTemp);
            }
            if (!StringUtils.equals((CharSequence)"C", (CharSequence)newMftOrderEntryProducttype)) {
                long entryPkValue = this.getPkValue(orderType, pkMap);
                newMftOrderEntry.set("id", (Object)entryPkValue);
                newMftOrderEntry.set("pid", (Object)entryPkValueInMainPro);
                this.pakageNewMftOrderEntryNonMainPro(newMftOrderEntry, splitEntry, nonMainProSameSrcOrderEntrySplitQtyMap, srcOrderEntryMap);
                splitMapTemp.put("splitreason", splitEntry.get("splitreason"));
                splitMap.put(entryPkValueInMainPro, splitMapTemp);
            }
            this.pakageNewMftOrderEntryCommon(newMftOrderEntry, splitEntry, srcEntryId, mftorderBillNew, newBillMap);
        }
        DynamicObjectCollection newOrderBillEntrys = mftorderBillNew.getDynamicObjectCollection("treeentryentity");
        Iterator itNew = newOrderBillEntrys.iterator();
        while (itNew.hasNext()) {
            BigDecimal qty;
            DynamicObject mftorderBillEntry = (DynamicObject)itNew.next();
            if (null == mftorderBillEntry || (qty = mftorderBillEntry.getBigDecimal("qty")).compareTo(BigDecimal.ZERO) != 0) continue;
            itNew.remove();
        }
        return mftorderBillNew;
    }

    private void pakageNewMftOrderBillHead(DynamicObject newMftOrderBill, long pkvalue) {
        DynamicObject org = newMftOrderBill.getDynamicObject("org");
        String billNo = "";
        if (null != org) {
            String orgId = org.getString("id");
            billNo = JsonUtils.getAutoNumber((DynamicObject)newMftOrderBill, (String)orgId, (String)newMftOrderBill.getDataEntityType().getName());
        }
        if (StringUtils.isBlank((CharSequence)billNo)) {
            billNo = UUID.randomUUID().toString().substring(0, 30);
        }
        newMftOrderBill.set("id", (Object)pkvalue);
        newMftOrderBill.set("billno", (Object)billNo);
        newMftOrderBill.set("billstatus", (Object)"A");
        DynamicObject transaction = newMftOrderBill.getDynamicObject("transactiontype");
        transaction = TransactionTypeQueryHelper.getDataCacheByID((Object)transaction.getPkValue());
        newMftOrderBill.set("transactiontype", (Object)transaction);
        newMftOrderBill.set("creator", (Object)UserServiceHelper.getCurrentUser((String)"id"));
        newMftOrderBill.set("createtime", (Object)new Date());
        newMftOrderBill.set("modifier", (Object)UserServiceHelper.getCurrentUser((String)"id"));
        newMftOrderBill.set("modifytime", (Object)new Date());
        newMftOrderBill.set("auditor", null);
        newMftOrderBill.set("auditdate", null);
    }

    private void pakageNewMftOrderEntryCommon(DynamicObject newMftOrderEntry, DynamicObject splitEntry, long srcEntryId, DynamicObject newMftOrderBill, Map<Object, Boolean> newBillMap) {
        BigDecimal qty = newMftOrderEntry.getBigDecimal("qty");
        newMftOrderEntry.set("planqty", (Object)qty);
        Object newOrderid = newMftOrderBill.getPkValue();
        DynamicObject org = newMftOrderBill.getDynamicObject("org");
        DynamicObject transaction = newMftOrderBill.getDynamicObject("transactiontype");
        newMftOrderEntry.set("headbillno", (Object)newMftOrderBill.getString("billno"));
        DynamicObject unit = newMftOrderEntry.getDynamicObject("unit");
        DynamicObject baseUnit = newMftOrderEntry.getDynamicObject("baseunit");
        DynamicObject mftmaterial = newMftOrderEntry.getDynamicObject("material");
        if (null != mftmaterial) {
            DynamicObject material = mftmaterial.getDynamicObject("masterid");
            BigDecimal baseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
            newMftOrderEntry.set("baseqty", (Object)baseQty);
            newMftOrderEntry.set("planbaseqty", (Object)baseQty);
            BigDecimal estscrapqty = OrderSpliteService.calEstscrapqty(newMftOrderEntry, org);
            newMftOrderEntry.set("estscrapqty", (Object)estscrapqty);
            BigDecimal highlimit = newMftOrderEntry.getBigDecimal("rcvinhighlimit");
            BigDecimal inwarmax = baseQty.multiply(BigDecimal.ONE.add(highlimit.divide(BigDecimal.valueOf(100L), baseUnit.getInt("precision"), UnitPrecisionUtils.getPrecisionDeal((String)baseUnit.getString("precisionaccount")))));
            newMftOrderEntry.set("inwarmax", (Object)inwarmax);
            BigDecimal rcvinlowlimit = newMftOrderEntry.getBigDecimal("rcvinlowlimit");
            BigDecimal inwarmin = baseQty.multiply(BigDecimal.ONE.subtract(rcvinlowlimit.divide(BigDecimal.valueOf(100L), baseUnit.getInt("precision"), UnitPrecisionUtils.getPrecisionDeal((String)baseUnit.getString("precisionaccount")))));
            newMftOrderEntry.set("inwarmin", (Object)inwarmin);
            BigDecimal repmaxrate = newMftOrderEntry.getBigDecimal("repmaxrate");
            BigDecimal repmaxqty = qty.multiply(BigDecimal.ONE.add(repmaxrate.divide(BigDecimal.valueOf(100L), unit.getInt("precision"), UnitPrecisionUtils.getPrecisionDeal((String)unit.getString("precisionaccount")))));
            newMftOrderEntry.set("repmaxqty", (Object)repmaxqty);
            BigDecimal repminrate = newMftOrderEntry.getBigDecimal("repminrate");
            BigDecimal repminqty = qty.multiply(BigDecimal.ONE.subtract(repminrate.divide(BigDecimal.valueOf(100L), unit.getInt("precision"), UnitPrecisionUtils.getPrecisionDeal((String)unit.getString("precisionaccount")))));
            newMftOrderEntry.set("repminqty", (Object)repminqty);
            DynamicObject qualityorg = newMftOrderEntry.getDynamicObject("qualityorg");
            long initOrgId = 0L;
            if (null != qualityorg) {
                initOrgId = qualityorg.getLong("id");
            }
            boolean isinspection = OrderQualityOrgService.getMaterialQCInfo(mftmaterial, initOrgId);
            newMftOrderEntry.set("isinspection", (Object)isinspection);
        }
        newMftOrderEntry.set("warehouse", (Object)splitEntry.getDynamicObject("warehouse"));
        newMftOrderEntry.set("location", (Object)splitEntry.getDynamicObject("location"));
        newMftOrderEntry.set("planpreparetime", (Object)splitEntry.getDate("splitplanpreparetime"));
        newMftOrderEntry.set("planbegintime", (Object)splitEntry.getDate("splitplanbegintime"));
        newMftOrderEntry.set("planendtime", (Object)splitEntry.getDate("splitplanendtime"));
        DynamicObject oldWorkCenter = newMftOrderEntry.getDynamicObject("workcenter");
        DynamicObject newWorkCenter = splitEntry.getDynamicObject("splitworkcenter");
        String oldWorkCenterId = oldWorkCenter == null ? "0" : oldWorkCenter.getPkValue().toString();
        String newWorkCenterId = newWorkCenter == null ? "0" : newWorkCenter.getPkValue().toString();
        newBillMap.put(newOrderid, Boolean.FALSE);
        if (!oldWorkCenterId.equals(newWorkCenterId)) {
            newBillMap.put(newOrderid, Boolean.TRUE);
        }
        newMftOrderEntry.set("workcenter", (Object)newWorkCenter);
        newMftOrderEntry.set("planstatus", (Object)ManuBillPlanStatusEnum.PLAN.getValue());
        newMftOrderEntry.set("taskstatus", (Object)ManuBillTaskStatusEnum.NOBEGINWORK.getValue());
        newMftOrderEntry.set("bizstatus", (Object)ManuBillBizStatusEnum.NORMAL.getValue());
        newMftOrderEntry.set("pickstatus", (Object)ManuBillPickStatusEnum.NOBEGINWORK.getValue());
        String ordersrcbillid = splitEntry.getString("ordersrcbillid");
        newMftOrderEntry.set("sourceentryseq", (Object)ordersrcbillid);
        DynamicObject inwarDeptInSplitEntry = splitEntry.getDynamicObject("inwardept");
        DynamicObject warehouseInSplitEntry = splitEntry.getDynamicObject("warehouse");
        DynamicObject locationInSplitEntry = splitEntry.getDynamicObject("location");
        if (StringUtils.isNotBlank((CharSequence)ordersrcbillid)) {
            Long nullId = 0L;
            if (null == inwarDeptInSplitEntry || nullId.equals(inwarDeptInSplitEntry.getLong("id"))) {
                inwarDeptInSplitEntry = newMftOrderEntry.getDynamicObject("inwardept");
            }
            if (null == warehouseInSplitEntry || nullId.equals(warehouseInSplitEntry.getLong("id"))) {
                warehouseInSplitEntry = newMftOrderEntry.getDynamicObject("warehouse");
            }
            if (null == locationInSplitEntry || nullId.equals(locationInSplitEntry.getLong("id"))) {
                locationInSplitEntry = newMftOrderEntry.getDynamicObject("location");
            }
        }
        newMftOrderEntry.set("inwardept", (Object)inwarDeptInSplitEntry);
        if (!StringUtils.equals((CharSequence)this.getDispatchSource(), (CharSequence)"mps_scheduleplan")) {
            newMftOrderEntry.set("producedept", (Object)splitEntry.getDynamicObject("splitproducedept"));
            newMftOrderEntry.set("inwardept", (Object)splitEntry.getDynamicObject("inwardept"));
        }
        newMftOrderEntry.set("warehouse", (Object)warehouseInSplitEntry);
        newMftOrderEntry.set("location", (Object)locationInSplitEntry);
        newMftOrderEntry.set("batchno", splitEntry.get("splitbatchno"));
        if ("om_mftorder".equals(newMftOrderBill.getDataEntityType().getName())) {
            newMftOrderEntry.set("purorg", (Object)splitEntry.getDynamicObject("splitpurorg"));
            newMftOrderEntry.set("supplier", (Object)splitEntry.getDynamicObject("splitsupplier"));
        }
    }

    private void pakageNewMftOrderEntryMainPro(DynamicObject newMftOrderEntry, DynamicObject splitEntry) {
        newMftOrderEntry.set("unit", (Object)splitEntry.getDynamicObject("splitunit"));
        BigDecimal qty = splitEntry.getBigDecimal("splitqty");
        newMftOrderEntry.set("qty", (Object)qty);
        newMftOrderEntry.set("auxptyqty", (Object)splitEntry.getBigDecimal("splitauxptyqty"));
    }

    private void pakageNewMftOrderEntryNonMainPro(DynamicObject newMftOrderEntry, DynamicObject splitEntry, Map<Long, BigDecimal> nonMainProSameSrcOrderEntrySplitQtyMap, Map<Object, Map<String, BigDecimal>> srcOrderEntryMap) {
        DynamicObject srcsplitbillseqObj;
        if (null != newMftOrderEntry && null != splitEntry && null != nonMainProSameSrcOrderEntrySplitQtyMap && null != (srcsplitbillseqObj = newMftOrderEntry.getDynamicObject("srcsplitbillseq"))) {
            long srcsplitbillseq = srcsplitbillseqObj.getLong("id");
            Map<String, BigDecimal> srcOrderQtyMap = srcOrderEntryMap.get(srcsplitbillseq);
            long splitmftorderentryid = splitEntry.getLong("splitmftorderentryid");
            Map<String, BigDecimal> srcOrderMainProQtyMap = srcOrderEntryMap.get(splitmftorderentryid);
            BigDecimal mainBaseQty = srcOrderMainProQtyMap.get("baseqty");
            BigDecimal quantitySplitQty = this.calQuantitySplitQty(newMftOrderEntry, splitEntry, srcOrderQtyMap, mainBaseQty);
            BigDecimal remainingSplittableQty = this.calRemainingSplittableQuantity(newMftOrderEntry, splitEntry, nonMainProSameSrcOrderEntrySplitQtyMap, srcOrderQtyMap);
            BigDecimal realSplitQty = quantitySplitQty.min(remainingSplittableQty);
            newMftOrderEntry.set("qty", (Object)realSplitQty);
            DynamicObject unit = newMftOrderEntry.getDynamicObject("unit");
            DynamicObject auxptyUnit = newMftOrderEntry.getDynamicObject("auxptyunit");
            DynamicObject material = newMftOrderEntry.getDynamicObject("material");
            if (null != material) {
                material = material.getDynamicObject("masterid");
            }
            BigDecimal auxptyQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)realSplitQty, (DynamicObject)auxptyUnit);
            newMftOrderEntry.set("auxptyqty", (Object)auxptyQty);
            BigDecimal srcSplitQtyTotal = nonMainProSameSrcOrderEntrySplitQtyMap.get(srcsplitbillseq);
            if (null == srcSplitQtyTotal) {
                srcSplitQtyTotal = BigDecimal.ZERO;
            }
            nonMainProSameSrcOrderEntrySplitQtyMap.put(srcsplitbillseq, srcSplitQtyTotal.add(realSplitQty));
        }
    }

    private BigDecimal calRemainingSplittableQuantity(DynamicObject newMftOrderEntry, DynamicObject splitEntry, Map<Long, BigDecimal> nonMainProSameSrcOrderEntrySplitQtyMap, Map<String, BigDecimal> srcOrderQtyMap) {
        DynamicObject srcsplitbillseqObj;
        BigDecimal quantitySplitQty = BigDecimal.ZERO;
        if (null != newMftOrderEntry && null != splitEntry && null != nonMainProSameSrcOrderEntrySplitQtyMap && null != (srcsplitbillseqObj = newMftOrderEntry.getDynamicObject("srcsplitbillseq"))) {
            long srcsplitbillseq = srcsplitbillseqObj.getLong("id");
            BigDecimal srcSplitQtyTotal = nonMainProSameSrcOrderEntrySplitQtyMap.get(srcsplitbillseq);
            if (null == srcSplitQtyTotal) {
                srcSplitQtyTotal = BigDecimal.ZERO;
            }
            DynamicObject unit = newMftOrderEntry.getDynamicObject("unit");
            DynamicObject baseUnit = newMftOrderEntry.getDynamicObject("baseunit");
            DynamicObject material = newMftOrderEntry.getDynamicObject("material");
            if (null != material) {
                material = material.getDynamicObject("masterid");
            }
            BigDecimal qty = srcOrderQtyMap.get("qty");
            BigDecimal rptqty = srcOrderQtyMap.get("rptqty");
            BigDecimal baseQty = srcOrderQtyMap.get("baseqty");
            BigDecimal stockBaseQty = srcOrderQtyMap.get("stockqty");
            quantitySplitQty = qty.subtract(rptqty).min(BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)baseUnit, (BigDecimal)baseQty.subtract(stockBaseQty), (DynamicObject)unit)).subtract(srcSplitQtyTotal);
            quantitySplitQty = quantitySplitQty.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : quantitySplitQty;
        }
        return quantitySplitQty;
    }

    private BigDecimal calQuantitySplitQty(DynamicObject newMftOrderEntry, DynamicObject splitEntry, Map<String, BigDecimal> srcOrderQtyMap, BigDecimal mainBaseQty) {
        DynamicObject unit;
        BigDecimal quantitySplitQty = BigDecimal.ZERO;
        if (null != newMftOrderEntry && null != splitEntry && null != (unit = newMftOrderEntry.getDynamicObject("unit"))) {
            int precision = unit.getInt("precision");
            String precisionAccount = unit.getString("precisionaccount");
            BigDecimal srcOrderEntryQty = srcOrderQtyMap.get("qty");
            BigDecimal splitbaseqty = splitEntry.getBigDecimal("splitbaseqty");
            quantitySplitQty = srcOrderEntryQty.multiply(splitbaseqty).divide(mainBaseQty, precision, PrecisionAccountEnum.getEnumByVal((int)Integer.parseInt(precisionAccount)));
        }
        return quantitySplitQty;
    }

    private void updateSrcMftOrder(DynamicObject mftOrderBill, Map<DynamicObject, String> res, DynamicObject splitEntry, DynamicObject newMftOrderBill, Map<Long, BigDecimal> actSplitQtyMap) {
        if (null != mftOrderBill && null != splitEntry) {
            String billStatus = mftOrderBill.getString("billstatus");
            Long srcEntryId = splitEntry.getLong("splitmftorderentryid");
            DynamicObject org = mftOrderBill.getDynamicObject("org");
            DynamicObjectCollection mftOrderEntrys = mftOrderBill.getDynamicObjectCollection("treeentryentity");
            long orderId = mftOrderBill.getLong("id");
            for (DynamicObject mftOrderEntry : mftOrderEntrys) {
                Long orderEntryId = mftOrderEntry.getLong("id");
                Long orderEntryPId = mftOrderEntry.getLong("pid");
                if (!srcEntryId.equals(orderEntryId) && !srcEntryId.equals(orderEntryPId)) continue;
                DynamicObject orderEntryInNewOrderBill = this.matchOrderEntryInSplitBill(orderEntryId, newMftOrderBill);
                BigDecimal qtyOld = mftOrderEntry.getBigDecimal("qty");
                BigDecimal separatedqty = BigDecimal.ZERO;
                BigDecimal separatedbaseqty = BigDecimal.ZERO;
                if (null != orderEntryInNewOrderBill) {
                    separatedqty = orderEntryInNewOrderBill.getBigDecimal("qty");
                    separatedbaseqty = orderEntryInNewOrderBill.getBigDecimal("baseqty");
                }
                BigDecimal qty = qtyOld.subtract(separatedqty);
                if (srcEntryId.equals(orderEntryId)) {
                    BigDecimal actSplitQty = actSplitQtyMap.get(orderEntryId).subtract(separatedqty);
                    actSplitQtyMap.put(orderEntryId, actSplitQty);
                }
                BigDecimal totalsplitqtyOld = mftOrderEntry.getBigDecimal("totalsplitqty");
                BigDecimal totalsplitbaseqtyOld = mftOrderEntry.getBigDecimal("totalsplitbaseqty");
                totalsplitqtyOld = totalsplitqtyOld.add(separatedqty);
                totalsplitbaseqtyOld = totalsplitbaseqtyOld.add(separatedbaseqty);
                DynamicObject unit = mftOrderEntry.getDynamicObject("unit");
                DynamicObject baseUnit = mftOrderEntry.getDynamicObject("baseunit");
                DynamicObject material = mftOrderEntry.getDynamicObject("material");
                if (null != material) {
                    BigDecimal rptqty;
                    BigDecimal stockqty;
                    material = material.getDynamicObject("masterid");
                    BigDecimal baseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                    BigDecimal estscrapqty = OrderSpliteService.calEstscrapqty(mftOrderEntry, org);
                    BigDecimal highlimit = mftOrderEntry.getBigDecimal("rcvinhighlimit");
                    BigDecimal inwarmax = baseQty.multiply(BigDecimal.ONE.add(highlimit.divide(BigDecimal.valueOf(100L), baseUnit.getInt("precision"), UnitPrecisionUtils.getPrecisionDeal((String)baseUnit.getString("precisionaccount")))));
                    boolean iscontrolqty = mftOrderEntry.getBoolean("iscontrolqty");
                    if (iscontrolqty && inwarmax.compareTo(stockqty = mftOrderEntry.getBigDecimal("stockqty")) < 0) {
                        String errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u62c6\u5206\u5de5\u5355\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u63a7\u5236\u5165\u5e93\u6570\u91cf\u65f6\uff0c\u5165\u5e93\u4e0a\u9650\u57fa\u672c\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u4e0b\u63a8\u5165\u5e93\u57fa\u672c\u6570\u91cf\u3002", (String)"MyTaskSplitOrder_8", (String)"bd-mpdm-business", (Object[])new Object[0]), splitEntry.getString("seq"));
                        this.dealErrorResult(splitEntry, res, errorInfo);
                        return;
                    }
                    BigDecimal rcvinlowlimit = mftOrderEntry.getBigDecimal("rcvinlowlimit");
                    BigDecimal inwarmin = baseQty.multiply(BigDecimal.ONE.subtract(rcvinlowlimit.divide(BigDecimal.valueOf(100L), baseUnit.getInt("precision"), UnitPrecisionUtils.getPrecisionDeal((String)baseUnit.getString("precisionaccount")))));
                    BigDecimal repmaxrate = mftOrderEntry.getBigDecimal("repmaxrate");
                    BigDecimal repmaxqty = qty.multiply(BigDecimal.ONE.add(repmaxrate.divide(BigDecimal.valueOf(100L), unit.getInt("precision"), UnitPrecisionUtils.getPrecisionDeal((String)unit.getString("precisionaccount")))));
                    BigDecimal repminrate = mftOrderEntry.getBigDecimal("repminrate");
                    BigDecimal repminqty = qty.multiply(BigDecimal.ONE.subtract(repminrate.divide(BigDecimal.valueOf(100L), unit.getInt("precision"), UnitPrecisionUtils.getPrecisionDeal((String)unit.getString("precisionaccount")))));
                    boolean isconreportqty = mftOrderEntry.getBoolean("isconreportqty");
                    if (isconreportqty && repmaxqty.compareTo(rptqty = mftOrderEntry.getBigDecimal("rptqty")) < 0) {
                        String errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u62c6\u5206\u5de5\u5355\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u63a7\u5236\u6c47\u62a5\u6570\u91cf\u65f6\uff0c\u62c6\u5206\u540e\u6c47\u62a5\u4e0a\u9650\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u4e0b\u63a8\u6c47\u62a5\u6570\u91cf\u3002", (String)"MyTaskSplitOrder_9", (String)"bd-mpdm-business", (Object[])new Object[0]), splitEntry.getString("seq"));
                        this.dealErrorResult(splitEntry, res, errorInfo);
                        return;
                    }
                    if (StringUtils.equals((CharSequence)"C", (CharSequence)billStatus)) {
                        mftOrderEntry.set("totalsplitqty", (Object)totalsplitqtyOld);
                        mftOrderEntry.set("totalsplitbaseqty", (Object)totalsplitbaseqtyOld);
                    }
                    mftOrderEntry.set("baseqty", (Object)baseQty);
                    mftOrderEntry.set("estscrapqty", (Object)estscrapqty);
                    mftOrderEntry.set("inwarmax", (Object)inwarmax);
                    mftOrderEntry.set("inwarmin", (Object)inwarmin);
                    mftOrderEntry.set("repmaxqty", (Object)repmaxqty);
                    mftOrderEntry.set("repminqty", (Object)repminqty);
                    if (StringUtils.equals((CharSequence)"A", (CharSequence)billStatus) || StringUtils.equals((CharSequence)"B", (CharSequence)billStatus)) {
                        mftOrderEntry.set("planqty", (Object)qty);
                        mftOrderEntry.set("planbaseqty", (Object)baseQty);
                    }
                    BigDecimal auxptyqtyInNewOrderEntry = BigDecimal.ZERO;
                    if (null != orderEntryInNewOrderBill) {
                        auxptyqtyInNewOrderEntry = orderEntryInNewOrderBill.getBigDecimal("auxptyqty");
                    }
                    BigDecimal auxptyqty = mftOrderEntry.getBigDecimal("auxptyqty").subtract(auxptyqtyInNewOrderEntry).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : mftOrderEntry.getBigDecimal("auxptyqty").subtract(auxptyqtyInNewOrderEntry);
                    mftOrderEntry.set("auxptyqty", (Object)auxptyqty);
                }
                mftOrderEntry.set("qty", (Object)qty);
                BigDecimal quainwaQty = mftOrderEntry.getBigDecimal("quainwaqty");
                BigDecimal unQuainwaQty = mftOrderEntry.getBigDecimal("unquainwaqty");
                BigDecimal waitcheckQty = mftOrderEntry.getBigDecimal("waitcheckqty");
                BigDecimal scrinwaqtyQty = mftOrderEntry.getBigDecimal("scrinwaqty");
                BigDecimal inwarminQty = mftOrderEntry.getBigDecimal("inwarmin");
                int compareResult = inwarminQty.compareTo(quainwaQty.add(unQuainwaQty).add(waitcheckQty).add(scrinwaqtyQty));
                if (compareResult <= 0) {
                    this.orderEntryIdsForUpdateEndWorkTime.add(Long.parseLong(mftOrderEntry.getPkValue().toString()));
                }
                this.orderEntryIdsForUpdate.add(orderEntryId);
                this.orderIdsForUpdate.add(orderId);
            }
        }
    }

    private DynamicObject matchOrderEntryInSplitBill(Long orderEntryId, DynamicObject newMftOrderBill) {
        DynamicObject orderEntry = null;
        if (null != newMftOrderBill && 0L != orderEntryId) {
            DynamicObjectCollection newMftOrderBillEntrys = newMftOrderBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : newMftOrderBillEntrys) {
                DynamicObject seq;
                Long seqId;
                if (null == entry || !orderEntryId.equals(seqId = Long.valueOf((seq = entry.getDynamicObject("srcsplitbillseq")).getLong("id")))) continue;
                orderEntry = entry;
                break;
            }
        }
        return orderEntry;
    }
}

