/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.mftorder;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.helper.CostRelateHelper;
import kd.bd.mpdm.business.mftorder.MftOrderModTimeUtils;
import kd.bd.mpdm.business.mftorder.OrderCommonService;
import kd.bd.mpdm.business.mftorder.OrderQualityOrgService;
import kd.bd.mpdm.common.service.GetAcctCloseDate;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bd.mpdm.common.utils.MpdmDyObjUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrderBookDateService {
    private static final Log logger = LogFactory.getLog(OrderBookDateService.class);
    private static final String KEY_BOOKDATE_EQUALS_BIZDATE = "INV0004";

    public static long queryAccountingOrgByProduceOrg(long produceOrgId) {
        long accountingOrgId = 0L;
        if (OrderQualityOrgService.checkOrgWithFisqc(produceOrgId, "fisaccounting")) {
            accountingOrgId = produceOrgId;
            logger.info("accountingOrgId:produceOrgId");
        } else {
            List fromOrgs = OrgUnitServiceHelper.getFromOrgs((String)"04", (Long)produceOrgId, (String)"10", (boolean)true);
            if (fromOrgs.size() > 0) {
                accountingOrgId = (Long)fromOrgs.get(0);
                logger.info("accountingOrgId:fromOrgs.get(0)");
            } else {
                Map mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)produceOrgId, (Boolean)false, (Boolean)true);
                if (mapOrg != null && mapOrg.get("id") != null) {
                    logger.info("accountingOrgId\uff1a" + mapOrg);
                    accountingOrgId = (Long)mapOrg.get("id");
                }
            }
        }
        return accountingOrgId;
    }

    private static Map<Long, Long> queryProductorgAndAccountingorgMap(Set<Long> productOrgs) {
        HashMap<Long, Long> productAndAccountingorgMap = new HashMap<Long, Long>(16);
        if (null != productOrgs && productOrgs.size() > 0) {
            for (long productOrgId : productOrgs) {
                long accountingOrgId = OrderBookDateService.queryAccountingOrgByProduceOrg(productOrgId);
                productAndAccountingorgMap.put(productOrgId, accountingOrgId);
            }
        }
        return productAndAccountingorgMap;
    }

    public static Map<Long, Date> queryProductOrgAndBookDateMap(Set<Long> productOrgs) {
        HashMap<Long, Date> productOrgAndBookDateMap = new HashMap<Long, Date>(16);
        if (null != productOrgs && productOrgs.size() > 0) {
            Map<Long, Long> productorgAndAccountingorgMap = OrderBookDateService.queryProductorgAndAccountingorgMap(productOrgs);
            HashSet<Long> acctOrgIds = new HashSet<Long>(16);
            if (null != productorgAndAccountingorgMap) {
                for (Map.Entry<Long, Long> entry : productorgAndAccountingorgMap.entrySet()) {
                    acctOrgIds.add(entry.getValue());
                }
            }
            Map accountingorgAndBookDateMap = GetAcctCloseDate.getAcctOrgCloseDate(acctOrgIds);
            if (null != productorgAndAccountingorgMap) {
                block1: for (Map.Entry<Long, Long> entry : productorgAndAccountingorgMap.entrySet()) {
                    long productOrgId = entry.getKey();
                    long accountingOrgId = entry.getValue();
                    if (null == accountingorgAndBookDateMap) continue;
                    for (Map.Entry dateEntry : accountingorgAndBookDateMap.entrySet()) {
                        long accountingOrgIdTemp = (Long)dateEntry.getKey();
                        Date bookDate = (Date)dateEntry.getValue();
                        if (accountingOrgId != accountingOrgIdTemp) continue;
                        productOrgAndBookDateMap.put(productOrgId, DateUtils.getShortDate((Date)bookDate));
                        continue block1;
                    }
                }
            }
        }
        return productOrgAndBookDateMap;
    }

    public static Map<Long, Date> queryMaxInvOrgAndBookDateMap(Set<Long> invOrgs) {
        HashMap<Long, Date> invOrgAndBookDateMap = new HashMap<Long, Date>(16);
        if (null != invOrgs && invOrgs.size() > 0) {
            QFilter closeFilter = new QFilter("org.id", "in", invOrgs);
            closeFilter.and(new QFilter("isdelete", "<>", (Object)true));
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"im_closeaccountrecord", (String)"im_closeaccountrecord", (String)"closedate,org.id", (QFilter[])closeFilter.toArray(), (String)"closedate");
            for (Row row : dataSet) {
                long invOrgId = row.getLong("org.id");
                Date bookDate = row.getDate("closedate");
                if (null == bookDate) continue;
                invOrgAndBookDateMap.put(invOrgId, DateUtils.getShortDate((Date)bookDate));
            }
        }
        return invOrgAndBookDateMap;
    }

    public static Date queryMaxBookDate(long productOrgId, long invOrgId, Map<Long, Date> productOrgAndBookDateMap, Map<Long, Date> invOrgAndBookDateMap) {
        Date tempDate;
        Date maxBookDate = null;
        for (Map.Entry<Long, Date> productBookDateEntry : productOrgAndBookDateMap.entrySet()) {
            long productOrgIdInEntry = productBookDateEntry.getKey();
            if (productOrgId != productOrgIdInEntry || null == (tempDate = productBookDateEntry.getValue())) continue;
            if (maxBookDate == null) {
                maxBookDate = tempDate;
                continue;
            }
            maxBookDate = maxBookDate.after(tempDate) ? maxBookDate : tempDate;
        }
        for (Map.Entry<Long, Date> invBookDateEntry : invOrgAndBookDateMap.entrySet()) {
            long invOrgIdInEntry = invBookDateEntry.getKey();
            if (invOrgId != invOrgIdInEntry || null == (tempDate = invBookDateEntry.getValue())) continue;
            if (maxBookDate == null) {
                maxBookDate = tempDate;
                continue;
            }
            maxBookDate = maxBookDate.after(tempDate) ? maxBookDate : tempDate;
        }
        return maxBookDate;
    }

    public static Date queryBookDate(long productOrgId, long invOrgId, Map<Long, Date> productOrgAndBookDateMap, Map<Long, Date> invOrgAndBookDateMap, Date time) {
        Date beginBookDate = null;
        if (null != time) {
            Date theDayAfterMaxBookDate;
            Date maxBookDate = OrderBookDateService.queryMaxBookDate(productOrgId, invOrgId, productOrgAndBookDateMap, invOrgAndBookDateMap);
            beginBookDate = null != maxBookDate ? (time.before(theDayAfterMaxBookDate = OrderBookDateService.theDayAfterMaxBookDate(maxBookDate)) ? theDayAfterMaxBookDate : time) : time;
        }
        return beginBookDate;
    }

    public static boolean bookDateEqualsBizDate() {
        return false;
    }

    public static Map<String, Map<Long, Date>> makeupOrgDates(Set<Long> entityentryidList, DynamicObject[] data) {
        HashMap<String, Map<Long, Date>> result = new HashMap<String, Map<Long, Date>>(2);
        HashSet<Long> invOrgs = new HashSet<Long>(16);
        HashSet<Long> productOrgs = new HashSet<Long>(16);
        for (int i = 0; i < ArrayUtils.getLength((Object)data); ++i) {
            DynamicObject orgDyn;
            boolean billSelectFlag = false;
            DynamicObject mftorderBill = data[i];
            DynamicObjectCollection entryCols = mftorderBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : entryCols) {
                long entryId = entry.getLong("id");
                if (!entityentryidList.contains(entryId)) continue;
                billSelectFlag = true;
                DynamicObject invOrgDyn = entry.getDynamicObject("inwardept");
                if (null == invOrgDyn) continue;
                invOrgs.add(invOrgDyn.getLong("id"));
            }
            if (!billSelectFlag || null == (orgDyn = mftorderBill.getDynamicObject("org"))) continue;
            productOrgs.add(orgDyn.getLong("id"));
        }
        Map<Long, Date> productOrgAndBookDateMap = OrderBookDateService.queryProductOrgAndBookDateMap(productOrgs);
        Map<Long, Date> maxInvOrgAndBookDateMap = OrderBookDateService.queryMaxInvOrgAndBookDateMap(invOrgs);
        result.put("productOrgAndBookDateMap", productOrgAndBookDateMap);
        result.put("maxInvOrgAndBookDateMap", maxInvOrgAndBookDateMap);
        return result;
    }

    public static boolean isIntertemporal(Date compareBookDate, Date bookDate) {
        boolean result = false;
        if (null != compareBookDate && null != bookDate && compareBookDate.before(OrderBookDateService.theDayAfterMaxBookDate(bookDate))) {
            result = true;
        }
        return result;
    }

    public static Date theDayAfterMaxBookDate(Date date) {
        Date theDayAfterMaxBookDate = null;
        if (null != date) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            ((Calendar)calendar).add(5, 1);
            theDayAfterMaxBookDate = calendar.getTime();
        }
        return theDayAfterMaxBookDate;
    }

    public static Date queryBookDateWithCompare(DynamicObject manubill, DynamicObject entry, Map<Long, Date> productOrgAndBookDateMap, Map<Long, Date> maxInvOrgAndBookDateMap, Date time, String field, boolean iscompareFlag, Date compareDate, boolean fillDate) {
        long invOrgId = 0L;
        DynamicObject invOrgDyn = entry.getDynamicObject("inwardept");
        if (null != invOrgDyn) {
            invOrgId = invOrgDyn.getLong("id");
        }
        long orgId = 0L;
        DynamicObject orgDyn = manubill.getDynamicObject("org");
        if (null != orgDyn) {
            orgId = orgDyn.getLong("id");
        }
        Date bookDateInEntry = null;
        Date maxBookDate = OrderBookDateService.queryMaxBookDate(orgId, invOrgId, productOrgAndBookDateMap, maxInvOrgAndBookDateMap);
        if (!iscompareFlag || !OrderBookDateService.isIntertemporal(compareDate, maxBookDate)) {
            bookDateInEntry = OrderBookDateService.queryBookDate(orgId, invOrgId, productOrgAndBookDateMap, maxInvOrgAndBookDateMap, time);
        }
        if (null != bookDateInEntry) {
            Date beginBookDate;
            if ("beginbookdate".equals(field)) {
                Date closeBookDate = entry.getDate("closebookdate");
                if (null != closeBookDate && DateUtils.getShortDate((Date)bookDateInEntry).after(DateUtils.getShortDate((Date)closeBookDate))) {
                    bookDateInEntry = null;
                }
            } else if ("closebookdate".equals(field) && null != (beginBookDate = entry.getDate("beginbookdate")) && DateUtils.getShortDate((Date)bookDateInEntry).before(DateUtils.getShortDate((Date)beginBookDate))) {
                bookDateInEntry = fillDate ? beginBookDate : null;
            }
        }
        return bookDateInEntry;
    }

    public static boolean isXbillFillBeginBookDate(DynamicObject mtfOrderChangeEntry, DynamicObject[] manuBills) {
        boolean flag = false;
        if (null != mtfOrderChangeEntry && null != manuBills) {
            String taskstatus;
            String productType = mtfOrderChangeEntry.getString("producttype");
            String changetype = mtfOrderChangeEntry.getString("changetype");
            long mftorderEntryId = mtfOrderChangeEntry.getLong("srcbillentryid");
            DynamicObject mftorderEntry = null;
            block0: for (DynamicObject mftorderBill : manuBills) {
                if (null == mftorderBill) continue;
                DynamicObjectCollection entrys = mftorderBill.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject entry : entrys) {
                    long entryId = entry.getLong("id");
                    if (mftorderEntryId != entryId) continue;
                    mftorderEntry = entry;
                    continue block0;
                }
            }
            String string = taskstatus = null == mftorderEntry ? "A" : mftorderEntry.getString("taskstatus");
            if (!(!StringUtils.equals((CharSequence)"C", (CharSequence)productType) || StringUtils.equals((CharSequence)"C", (CharSequence)productType) && StringUtils.equals((CharSequence)"B", (CharSequence)changetype) && StringUtils.equals((CharSequence)"A", (CharSequence)taskstatus))) {
                flag = true;
            }
        }
        return flag;
    }

    public static DynamicObject[] modBookDate(Set<Long> manuEntryidSet, String modetype, String pageEntity, String opType, boolean flag) {
        DynamicObject[] manuBills;
        block19: {
            boolean bookDateEqualsBizDate;
            block18: {
                if (manuEntryidSet.isEmpty() || StringUtils.isBlank((CharSequence)pageEntity) || StringUtils.isBlank((CharSequence)modetype) || StringUtils.isBlank((CharSequence)opType)) {
                    return new DynamicObject[0];
                }
                bookDateEqualsBizDate = false;
                manuBills = OrderCommonService.queryManuBills(manuEntryidSet, pageEntity);
                if (!"beginwork".equals(opType) && !"shut".equals(opType)) break block18;
                Map<Long, Date> productOrgAndBookDateMap = null;
                HashMap<Long, Date> maxInvOrgAndBookDateMap = null;
                HashMap<Long, Date> orderEntryIdAndBookDateMap = new HashMap<Long, Date>(16);
                HashMap<Long, DynamicObject> orderMap = new HashMap<Long, DynamicObject>(16);
                if (!bookDateEqualsBizDate) {
                    Map<String, Map<Long, Date>> bookdates = OrderBookDateService.makeupOrgDates(manuEntryidSet, manuBills);
                    productOrgAndBookDateMap = bookdates.get("productOrgAndBookDateMap");
                    maxInvOrgAndBookDateMap = new HashMap<Long, Date>(1);
                }
                if ("beginbookdate".equals(modetype)) {
                    DynamicObject[] orgIds = new HashSet(16);
                    for (DynamicObject manuBill : manuBills) {
                        Long orgID;
                        boolean isinitbill;
                        if (null == manuBill) continue;
                        boolean bl = isinitbill = manuBill.containsProperty("isinitbill") && manuBill.getBoolean("isinitbill");
                        if (!isinitbill || !MpdmDyObjUtils.isNotEmptyId((Long)(orgID = MpdmDyObjUtils.getDyObjId((Object)manuBill.get("org"))))) continue;
                        orgIds.add(orgID);
                    }
                    Map<Long, Date> orgId_costSubOneDateMap = CostRelateHelper.getCostSubOneDateMap((Set<Long>)orgIds);
                    for (DynamicObject manuBill : manuBills) {
                        if (null == manuBill) continue;
                        boolean isinitbill = manuBill.containsProperty("isinitbill") && manuBill.getBoolean("isinitbill");
                        Long orgID = MpdmDyObjUtils.getDyObjId((Object)manuBill.get("org"));
                        DynamicObjectCollection orderEntryCols = manuBill.getDynamicObjectCollection("treeentryentity");
                        orderMap.put(manuBill.getLong("id"), manuBill);
                        for (DynamicObject orderEntry : orderEntryCols) {
                            String productType;
                            long orderEntryId = orderEntry.getLong("id");
                            long orderEntryPid = orderEntry.getLong("pid");
                            if (!manuEntryidSet.contains(orderEntryId) && !manuEntryidSet.contains(orderEntryPid)) continue;
                            Date beginBookDate = null;
                            Date startworktime = orderEntry.getDate("startworktime");
                            String startworktimeStr = null == startworktime ? "" : DateUtils.transDate((Object)startworktime);
                            logger.info(String.format("modBookDateService startworktime:%s", startworktimeStr));
                            if (bookDateEqualsBizDate) {
                                beginBookDate = startworktime;
                            } else {
                                DynamicObject entryTemp = OrderCommonService.matchEntryInfo(orderEntry, orderEntryCols);
                                beginBookDate = OrderBookDateService.queryBookDateWithCompare(manuBill, entryTemp, productOrgAndBookDateMap, maxInvOrgAndBookDateMap, startworktime, "beginbookdate", false, null, false);
                            }
                            if (isinitbill) {
                                beginBookDate = orgId_costSubOneDateMap.get(orgID);
                            }
                            if (!"C".equals(productType = orderEntry.getString("producttype"))) continue;
                            orderEntryIdAndBookDateMap.put(orderEntryId, beginBookDate);
                        }
                    }
                    if (!bookDateEqualsBizDate && !orderEntryIdAndBookDateMap.isEmpty()) {
                        OrderBookDateService.updateXBillAndSBills(orderEntryIdAndBookDateMap, orderMap, pageEntity);
                    }
                }
                if (!"closebookdate".equals(modetype)) break block19;
                for (DynamicObject manuBill : manuBills) {
                    if (null == manuBill) continue;
                    DynamicObjectCollection orderEntryCols = manuBill.getDynamicObjectCollection("treeentryentity");
                    for (DynamicObject orderEntry : orderEntryCols) {
                        long orderEntryId = orderEntry.getLong("id");
                        long orderEntryPid = orderEntry.getLong("pid");
                        if (!manuEntryidSet.contains(orderEntryId) && !manuEntryidSet.contains(orderEntryPid)) continue;
                        Date closeBookDate = null;
                        Date closetime = orderEntry.getDate("closetime");
                        if (bookDateEqualsBizDate) {
                            closeBookDate = closetime;
                        } else {
                            DynamicObject entryTemp = OrderCommonService.matchEntryInfo(orderEntry, orderEntryCols);
                            closeBookDate = OrderBookDateService.queryBookDateWithCompare(manuBill, entryTemp, productOrgAndBookDateMap, maxInvOrgAndBookDateMap, closetime, "closebookdate", false, null, true);
                        }
                        orderEntry.set("closebookdate", (Object)(closeBookDate != null ? DateUtils.getShortDate((Date)closeBookDate) : null));
                        if (orderEntry.get("beginbookdate") != null) continue;
                        orderEntry.set("beginbookdate", (Object)(closeBookDate != null ? DateUtils.getShortDate((Date)closeBookDate) : closeBookDate));
                    }
                }
                break block19;
            }
            if (bookDateEqualsBizDate && ("unbeginwork".equals(opType) || "unshut".equals(opType))) {
                for (DynamicObject manuBill : manuBills) {
                    if (null == manuBill) continue;
                    DynamicObjectCollection orderEntryCols = manuBill.getDynamicObjectCollection("treeentryentity");
                    for (DynamicObject orderEntry : orderEntryCols) {
                        long orderEntryId = orderEntry.getLong("id");
                        long orderEntryPid = orderEntry.getLong("pid");
                        if (!manuEntryidSet.contains(orderEntryId) && !manuEntryidSet.contains(orderEntryPid)) continue;
                        if ("closebookdate".equals(modetype)) {
                            orderEntry.set("closebookdate", null);
                            continue;
                        }
                        if (!"beginbookdate".equals(modetype)) continue;
                        orderEntry.set("beginbookdate", null);
                    }
                }
            }
        }
        return manuBills;
    }

    public static void modBookDate(Set<Long> manuEntryidSet, String modetype, String pageEntity, String opType) {
        if (manuEntryidSet.isEmpty() || StringUtils.isBlank((CharSequence)pageEntity) || StringUtils.isBlank((CharSequence)modetype) || StringUtils.isBlank((CharSequence)opType)) {
            return;
        }
        boolean bookDateEqualsBizDate = false;
        DynamicObject[] manuBills = OrderCommonService.queryManuBills(manuEntryidSet, pageEntity);
        if ("beginwork".equals(opType) || "shut".equals(opType)) {
            Map<Long, Date> productOrgAndBookDateMap = null;
            HashMap<Long, Date> maxInvOrgAndBookDateMap = null;
            HashMap<Long, Date> orderEntryIdAndBookDateMap = new HashMap<Long, Date>(16);
            HashMap<Long, DynamicObject> orderMap = new HashMap<Long, DynamicObject>(16);
            if (!bookDateEqualsBizDate) {
                Map<String, Map<Long, Date>> bookdates = OrderBookDateService.makeupOrgDates(manuEntryidSet, manuBills);
                productOrgAndBookDateMap = bookdates.get("productOrgAndBookDateMap");
                maxInvOrgAndBookDateMap = new HashMap<Long, Date>(1);
            }
            if ("beginbookdate".equals(modetype)) {
                HashSet<Long> orgIds = new HashSet<Long>(16);
                for (DynamicObject manuBill : manuBills) {
                    Long orgID;
                    boolean isinitbill;
                    if (null == manuBill) continue;
                    boolean bl = isinitbill = manuBill.containsProperty("isinitbill") && manuBill.getBoolean("isinitbill");
                    if (!isinitbill || !MpdmDyObjUtils.isNotEmptyId((Long)(orgID = MpdmDyObjUtils.getDyObjId((Object)manuBill.get("org"))))) continue;
                    orgIds.add(orgID);
                }
                Map<Long, Date> orgId_costSubOneDateMap = CostRelateHelper.getCostSubOneDateMap(orgIds);
                for (DynamicObject manuBill : manuBills) {
                    if (null == manuBill) continue;
                    boolean isinitbill = manuBill.containsProperty("isinitbill") && manuBill.getBoolean("isinitbill");
                    Long orgID = MpdmDyObjUtils.getDyObjId((Object)manuBill.get("org"));
                    DynamicObjectCollection orderEntryCols = manuBill.getDynamicObjectCollection("treeentryentity");
                    orderMap.put(manuBill.getLong("id"), manuBill);
                    for (DynamicObject orderEntry : orderEntryCols) {
                        String productType;
                        long orderEntryId = orderEntry.getLong("id");
                        long orderEntryPid = orderEntry.getLong("pid");
                        if (!manuEntryidSet.contains(orderEntryId) && !manuEntryidSet.contains(orderEntryPid)) continue;
                        Date beginBookDate = null;
                        Date startworktime = orderEntry.getDate("startworktime");
                        String startworktimeStr = null == startworktime ? "" : DateUtils.transDate((Object)startworktime);
                        logger.info(String.format("modBookDateService startworktime:%s", startworktimeStr));
                        if (bookDateEqualsBizDate) {
                            beginBookDate = startworktime;
                        } else {
                            DynamicObject entryTemp = OrderCommonService.matchEntryInfo(orderEntry, orderEntryCols);
                            beginBookDate = OrderBookDateService.queryBookDateWithCompare(manuBill, entryTemp, productOrgAndBookDateMap, maxInvOrgAndBookDateMap, startworktime, "beginbookdate", false, null, false);
                        }
                        if (isinitbill) {
                            beginBookDate = orgId_costSubOneDateMap.get(orgID);
                        }
                        if (!"C".equals(productType = orderEntry.getString("producttype"))) continue;
                        orderEntryIdAndBookDateMap.put(orderEntryId, beginBookDate != null ? DateUtils.getShortDate((Date)beginBookDate) : beginBookDate);
                    }
                }
                if (!bookDateEqualsBizDate && !orderEntryIdAndBookDateMap.isEmpty()) {
                    OrderBookDateService.updateXBillAndSBills(orderEntryIdAndBookDateMap, orderMap, pageEntity);
                }
            }
            if ("closebookdate".equals(modetype)) {
                HashSet<Long> entryIds = new HashSet<Long>(2);
                HashMap<Long, List<Long>> mainEntryAndSecondEntry = new HashMap<Long, List<Long>>();
                for (DynamicObject manuBill : manuBills) {
                    DynamicObjectCollection orderEntryCols = manuBill.getDynamicObjectCollection("treeentryentity");
                    for (DynamicObject col : orderEntryCols) {
                        entryIds.add(col.getLong("id"));
                        long orderEntryPid = col.getLong("pid");
                        if (orderEntryPid == 0L) continue;
                        List secondEntry = mainEntryAndSecondEntry.computeIfAbsent(orderEntryPid, k -> new ArrayList());
                        secondEntry.add(col.getLong("id"));
                    }
                }
                Map<Long, Date> mftEntryId_maxInvBookDateMap = MftOrderModTimeUtils.getMaxOrMinInvBookDateMap(true, manuBills[0].getDataEntityType().getName(), entryIds);
                for (DynamicObject manuBill : manuBills) {
                    if (null == manuBill) continue;
                    DynamicObjectCollection orderEntryCols = manuBill.getDynamicObjectCollection("treeentryentity");
                    for (DynamicObject orderEntry : orderEntryCols) {
                        long orderEntryId = orderEntry.getLong("id");
                        long orderEntryPid = orderEntry.getLong("pid");
                        if (!manuEntryidSet.contains(orderEntryId) && !manuEntryidSet.contains(orderEntryPid)) continue;
                        Date closeBookDate = null;
                        Date closetime = orderEntry.getDate("closetime");
                        Date maxBookDate = OrderBookDateService.getMaxBookDate(mainEntryAndSecondEntry, orderEntryId, orderEntryPid, mftEntryId_maxInvBookDateMap);
                        if (maxBookDate != null) {
                            closeBookDate = maxBookDate;
                        } else if (bookDateEqualsBizDate) {
                            closeBookDate = closetime;
                        } else {
                            DynamicObject entryTemp = OrderCommonService.matchEntryInfo(orderEntry, orderEntryCols);
                            closeBookDate = OrderBookDateService.queryBookDateWithCompare(manuBill, entryTemp, productOrgAndBookDateMap, maxInvOrgAndBookDateMap, closetime, "closebookdate", false, null, true);
                        }
                        orderEntry.set("closebookdate", (Object)(closeBookDate != null ? DateUtils.getShortDate((Date)closeBookDate) : closeBookDate));
                        if (orderEntry.get("beginbookdate") != null) continue;
                        orderEntry.set("beginbookdate", (Object)(closeBookDate != null ? DateUtils.getShortDate((Date)closeBookDate) : closeBookDate));
                    }
                }
            }
        } else if (bookDateEqualsBizDate && ("unbeginwork".equals(opType) || "unshut".equals(opType))) {
            for (DynamicObject manuBill : manuBills) {
                if (null == manuBill) continue;
                DynamicObjectCollection orderEntryCols = manuBill.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject orderEntry : orderEntryCols) {
                    long orderEntryId = orderEntry.getLong("id");
                    long orderEntryPid = orderEntry.getLong("pid");
                    if (!manuEntryidSet.contains(orderEntryId) && !manuEntryidSet.contains(orderEntryPid)) continue;
                    if ("closebookdate".equals(modetype)) {
                        orderEntry.set("closebookdate", null);
                        continue;
                    }
                    if (!"beginbookdate".equals(modetype)) continue;
                    orderEntry.set("beginbookdate", null);
                }
            }
        }
        SaveServiceHelper.update((DynamicObject[])manuBills);
    }

    private static Date getMaxBookDate(Map<Long, List<Long>> mainEntryAndSecondEntry, long orderEntryId, long orderPid, Map<Long, Date> mftEntryId_maxInvBookDateMap) {
        Date maxBookDate = mftEntryId_maxInvBookDateMap.get(orderEntryId);
        List<Long> secondEntrys = mainEntryAndSecondEntry.get(orderEntryId);
        if (secondEntrys != null && secondEntrys.size() > 0) {
            for (Long second : secondEntrys) {
                Date secondBookDate = mftEntryId_maxInvBookDateMap.get(second);
                if (secondBookDate == null || maxBookDate != null && !secondBookDate.after(maxBookDate)) continue;
                maxBookDate = secondBookDate;
            }
        } else {
            Date mainBookDate = mftEntryId_maxInvBookDateMap.get(orderPid);
            if (mainBookDate != null && (maxBookDate == null || mainBookDate.after(maxBookDate))) {
                maxBookDate = mainBookDate;
            }
        }
        return maxBookDate;
    }

    public static void updateXBillAndSBills(Map<Long, Date> orderEntryIdAndBookDateMap, Map<Long, DynamicObject> orderMap, String orderEntity) {
        HashSet<Long> orderEntryIds = new HashSet<Long>(16);
        for (Map.Entry<Long, Date> entry : orderEntryIdAndBookDateMap.entrySet()) {
            orderEntryIds.add(entry.getKey());
        }
        if (!orderEntryIds.isEmpty()) {
            for (Map.Entry<Long, Date> entry : orderMap.entrySet()) {
                DynamicObject orderBill = (DynamicObject)entry.getValue();
                if (null == orderBill) continue;
                DynamicObjectCollection entryCols = orderBill.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject entry2 : entryCols) {
                    long entryId = entry2.getLong("id");
                    long entryPid = entry2.getLong("pid");
                    if (!orderEntryIds.contains(entryPid)) continue;
                    orderEntryIds.add(entryId);
                    orderEntryIdAndBookDateMap.put(entryId, orderEntryIdAndBookDateMap.get(entryPid));
                }
            }
            OrderBookDateService.updateXbills(orderEntity, orderEntryIds, orderEntryIdAndBookDateMap);
            OrderBookDateService.updateSBills(orderEntity, orderEntryIds, orderEntryIdAndBookDateMap);
        }
    }

    public static void updateXbills(String orderEntity, Set<Long> orderEntryIds, Map<Long, Date> orderEntryIdAndBookDateMap) {
        DynamicObject[] xbills;
        String xentityName = "pom_xmftorderlog";
        if ("om_mftorder".equals(orderEntity)) {
            xentityName = "om_xmftorderlog";
        }
        QFilter xqfilter = new QFilter("srcbillentryid", "in", orderEntryIds);
        xqfilter.and("beginbookdate", "=", null);
        for (DynamicObject xbill : xbills = BusinessDataServiceHelper.load((String)xentityName, (String)"srcbillentryid,beginbookdate", (QFilter[])xqfilter.toArray())) {
            Date beginBookDate;
            long orderEntryId = xbill.getLong("srcbillentryid");
            if (!orderEntryIds.contains(orderEntryId) || null != (beginBookDate = xbill.getDate("beginbookdate"))) continue;
            Date date = orderEntryIdAndBookDateMap.get(orderEntryId);
            xbill.set("beginbookdate", (Object)(date != null ? DateUtils.getShortDate((Date)date) : null));
        }
        SaveServiceHelper.update((DynamicObject[])xbills);
    }

    public static void updateSBills(String orderEntity, Set<Long> orderEntryIds, Map<Long, Date> orderEntryIdAndBookDateMap) {
        if ("pom_mftorder".equals(orderEntity)) {
            DynamicObject[] sbills;
            QFilter sqfilter = new QFilter("orderentryid", "in", orderEntryIds);
            sqfilter.and("billentry.beginbookdate", "=", null);
            for (DynamicObject sbill : sbills = BusinessDataServiceHelper.load((String)"pom_mftorder_splitlog", (String)"orderentryid,billentry.beginbookdate", (QFilter[])sqfilter.toArray())) {
                long orderEntryId;
                DynamicObject orderentryF7 = sbill.getDynamicObject("orderentryid");
                if (null == orderentryF7 || !orderEntryIds.contains(orderEntryId = orderentryF7.getLong("id"))) continue;
                DynamicObjectCollection sbillEntryCols = sbill.getDynamicObjectCollection("billentry");
                for (DynamicObject sbillEntry : sbillEntryCols) {
                    Date beginBookDate = sbillEntry.getDate("beginbookdate");
                    if (null != beginBookDate) continue;
                    Date date = orderEntryIdAndBookDateMap.get(orderEntryId);
                    sbillEntry.set("beginbookdate", (Object)(date != null ? DateUtils.getShortDate((Date)date) : null));
                }
            }
            SaveServiceHelper.update((DynamicObject[])sbills);
        }
    }

    public static Map<Long, Date> orderEntryIdAndOldBookDateMap(DynamicObject[] dataEntities, String filedName) {
        HashMap<Long, Date> mainProIdAndBookDateMaps = new HashMap<Long, Date>();
        for (DynamicObject manubill : dataEntities) {
            DynamicObjectCollection dynamicObjectCollection = manubill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : dynamicObjectCollection) {
                DynamicObject entryTemp = OrderCommonService.matchEntryInfo(entry, dynamicObjectCollection);
                Date bookdate = entryTemp.getDate(filedName);
                mainProIdAndBookDateMaps.put(entry.getLong("id"), bookdate);
            }
        }
        return mainProIdAndBookDateMaps;
    }

    public static DynamicObject xBillEntrymatchSrcEntry(DynamicObject xBillEntry, DynamicObject[] manuBills) {
        DynamicObject srcEntry = null;
        long srcEntryId = xBillEntry.getLong("srcbillentryid");
        String changeType = xBillEntry.getString("changetype");
        if ("A".equals(changeType)) {
            srcEntry = xBillEntry;
        } else if ("B".equals(changeType)) {
            block0: for (DynamicObject manuBill : manuBills) {
                if (null == manuBill) continue;
                DynamicObjectCollection manuBillEntrys = manuBill.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject manuBillEntry : manuBillEntrys) {
                    long manuBillId;
                    if (null == manuBillEntry || srcEntryId != (manuBillId = manuBillEntry.getLong("id"))) continue;
                    srcEntry = manuBillEntry;
                    continue block0;
                }
            }
        }
        return srcEntry;
    }

    public static Map<String, Map<Long, Date>> xBillQueryBookDate(List<ExtendedDataEntity> selectedRows, DynamicObject[] manuBills, String xmftorderEntityId) {
        DynamicObject[] xBills;
        HashMap<String, Map<Long, Date>> bookdates = new HashMap<String, Map<Long, Date>>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> inwardeptIds = new HashSet<Long>(16);
        HashSet<Object> xbillPkValues = new HashSet<Object>(16);
        for (ExtendedDataEntity xBill : selectedRows) {
            xbillPkValues.add(xBill.getBillPkId());
        }
        QFilter qf = new QFilter("id", "in", xbillPkValues);
        String selectProperties = "org,treeentryentity.srcbillentryid,treeentryentity.changetype,treeentryentity.inwardept";
        for (DynamicObject xBillNew : xBills = BusinessDataServiceHelper.load((String)xmftorderEntityId, (String)selectProperties, (QFilter[])qf.toArray())) {
            DynamicObject org = xBillNew.getDynamicObject("org");
            if (null != org) {
                orgIds.add(org.getLong("id"));
            }
            DynamicObjectCollection xBillEntrys = xBillNew.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject xBillEntry : xBillEntrys) {
                DynamicObject inwardept;
                DynamicObject srcEntry;
                if (null == xBillEntry || null == (srcEntry = OrderBookDateService.xBillEntrymatchSrcEntry(xBillEntry, manuBills)) || null == (inwardept = srcEntry.getDynamicObject("inwardept"))) continue;
                inwardeptIds.add(inwardept.getLong("id"));
            }
        }
        Map<Long, Date> productOrgAndBookDateMap = OrderBookDateService.queryProductOrgAndBookDateMap(orgIds);
        Map<Long, Date> maxInvOrgAndBookDateMap = OrderBookDateService.queryMaxInvOrgAndBookDateMap(inwardeptIds);
        bookdates.put("productOrgAndBookDateMap", productOrgAndBookDateMap);
        bookdates.put("maxInvOrgAndBookDateMap", maxInvOrgAndBookDateMap);
        return bookdates;
    }

    public static Map<Long, Date> queryXbillEntryAndSrcBookDate(List<ExtendedDataEntity> selectedRows, String mftorderEntityId) {
        HashMap<Long, Date> result = new HashMap<Long, Date>(16);
        HashSet<Long> srcEntryIds = new HashSet<Long>(16);
        for (ExtendedDataEntity xBill : selectedRows) {
            DynamicObject xBillNew = xBill.getDataEntity();
            if (null == xBillNew) continue;
            DynamicObjectCollection xBillEntrys = xBillNew.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject xBillEntry : xBillEntrys) {
                if (null == xBillEntry) continue;
                srcEntryIds.add(xBillEntry.getLong("srcbillentryid"));
            }
        }
        Map<Object, Object> bookdates = new HashMap(16);
        if (!srcEntryIds.isEmpty()) {
            DynamicObject[] manuBills = OrderCommonService.queryManuBills(srcEntryIds, mftorderEntityId);
            String xmftorderEntityId = "pom_xmftorder";
            if ("om_mftorder".equals(mftorderEntityId)) {
                xmftorderEntityId = "om_xmftorder";
            }
            if ((bookdates = OrderBookDateService.xBillQueryBookDate(selectedRows, manuBills, xmftorderEntityId)) != null) {
                for (ExtendedDataEntity xBill : selectedRows) {
                    DynamicObject xBillNew = xBill.getDataEntity();
                    if (null == xBillNew) continue;
                    long orgId = 0L;
                    DynamicObject org = xBillNew.getDynamicObject("org");
                    if (null != org) {
                        orgId = org.getLong("id");
                    }
                    DynamicObjectCollection xBillEntrys = xBillNew.getDynamicObjectCollection("treeentryentity");
                    for (DynamicObject xBillEntry : xBillEntrys) {
                        DynamicObject inwardept;
                        if (null == xBillEntry) continue;
                        long inwardeptId = 0L;
                        DynamicObject srcEntry = OrderBookDateService.xBillEntrymatchSrcEntry(xBillEntry, manuBills);
                        if (null != srcEntry && null != (inwardept = srcEntry.getDynamicObject("inwardept"))) {
                            inwardeptId = inwardept.getLong("id");
                        }
                        Date entryBookDate = OrderBookDateService.queryMaxBookDate(orgId, inwardeptId, (Map)bookdates.get("productOrgAndBookDateMap"), (Map)bookdates.get("maxInvOrgAndBookDateMap"));
                        result.put(xBillEntry.getLong("id"), entryBookDate);
                    }
                }
            }
        }
        return result;
    }
}

