/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.mftorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.mftorder.MftOrderSetWorkCenterHelper;
import kd.bd.mpdm.business.mftorder.OrderBookDateService;
import kd.bd.mpdm.business.mftorder.OrderSpliteService;
import kd.bd.mpdm.common.mftorder.utils.XMftOrderChangeLogUtils;
import kd.bd.mpdm.common.query.helper.MaterialPlanQueryHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.mmc.business.query.helper.BillTypeQueryHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;

public class OrderCommonService {
    private static final String MASTERID = "masterid";
    private static Log LOGGER = LogFactory.getLog(OrderCommonService.class);
    private static String[] xmftorderFromOrderFields = new String[]{"billno", "org", "entrustdept", "transactiontype", "remark"};
    private static String[] xmftorderEntryFromOrderEntryFields = new String[]{"producttype", "material", "producedept", "unit", "baseunit", "auxptyunit", "qty", "baseqty", "auxptyqty", "manuversion", "bomid", "planpreparetime", "planbegintime", "planendtime", "ecnversion", "expendbomtime", "processroute", "routereplace", "planstatus", "taskstatus", "bizstatus", "pickstatus", "batchno", "auxproperty", "yieldrate", "estscrapqty", "inwardept", "warehouse", "location", "iscontrolqty", "inwarmax", "inwarmin", "rcvinhighlimit", "rcvinlowlimit", "outputoperation", "qualifiedqty", "unqualifiedqty", "scrapqty", "repairqty", "reworkqty", "pickingpairs", "quainwaqty", "unquainwaqty", "scrinwaqty", "repinwaqty", "plansuretime", "transmittime", "startworktime", "endworktime", "closetime", "sourcebilltype", "sourcebillnumber", "rptqty", "stockqty", "materielmasterid", "isconreportqty", "repmaxqty", "repmaxrate", "repminqty", "repminrate", "isinspection", "reportqty", "workwasteqty", "acceptqty", "mtlcostqty", "workcenter", "manuseq", "tracknumber", "configuredcode", "materielinv", "isreqapply"};

    public static QFilter getProcessRouteFilter(DynamicObject mftmaterial, DynamicObject org) {
        QFilter orgqFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_route", (Long)((Long)org.getPkValue()));
        QFilter typeA = new QFilter("processtype", "=", (Object)"A");
        QFilter typeB = new QFilter("processtype", "=", (Object)"B");
        QFilter typeC = new QFilter("processtype", "=", (Object)"C");
        mftmaterial = BusinessDataServiceHelper.loadSingleFromCache((Object)mftmaterial.getPkValue(), (String)"bd_materialmftinfo");
        DynamicObject bdmaterial = mftmaterial.getDynamicObject(MASTERID);
        QFilter materialFilter = new QFilter("material.id", "=", bdmaterial.getPkValue());
        DynamicObjectCollection materialgroup = mftmaterial.getDynamicObjectCollection("mftcontrolentry");
        ArrayList<Long> grouplist = new ArrayList<Long>();
        for (DynamicObject group : materialgroup) {
            grouplist.add((Long)group.getDynamicObject("materialcontrol").getPkValue());
        }
        QFilter result = orgqFilter.and(new QFilter("status", "=", (Object)"C"));
        QFilter statusFilter = typeA.and(materialFilter);
        if (grouplist.size() > 0) {
            statusFilter.or(typeB.and(new QFilter("materialgroup", "in", grouplist)));
        }
        statusFilter.or(typeC);
        result.and(statusFilter);
        return result;
    }

    public static List<Long> getInwareOrgFilter(Long mftOrg) {
        ArrayList<Long> filterList = new ArrayList<Long>();
        if (OrderCommonService.checkOrgIsAccount(mftOrg)) {
            List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)mftOrg);
            if (!allToOrg.isEmpty()) {
                filterList.addAll(allToOrg);
            }
        } else {
            List fromOrgs = OrgUnitServiceHelper.getFromOrgs((String)"04", (Long)mftOrg, (String)"10");
            if (fromOrgs.isEmpty()) {
                Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)mftOrg, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                Integer fromOrg = map == null || map.isEmpty() ? Integer.valueOf(0) : map.get("id");
                Long longFromOrg = (Long)((Object)fromOrg);
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)longFromOrg);
                if (!allToOrg.isEmpty()) {
                    filterList.addAll(allToOrg);
                }
            } else {
                Long fromOrg = (Long)fromOrgs.get(0);
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)fromOrg);
                if (!allToOrg.isEmpty()) {
                    filterList.addAll(allToOrg);
                }
            }
        }
        return filterList;
    }

    private static boolean checkOrgIsAccount(Long orgid) {
        DynamicObject dyOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgid, (String)"bos_org");
        return dyOrg.getBoolean("fisaccounting");
    }

    public static List<DynamicObject> queryBillType(String entityId) {
        return BillTypeQueryHelper.getBillTypesCacheList((String)entityId);
    }

    public static DynamicObject matchEntryInfo(DynamicObject entry, DynamicObjectCollection entrys) {
        if (entry == null) {
            return null;
        }
        String productType = entry.getString("producttype");
        if ("C".equals(productType)) {
            return entry;
        }
        DynamicObject result = entry;
        for (DynamicObject entryObj : entrys) {
            if (null == entryObj || entryObj.getLong("id") != entry.getLong("pid")) continue;
            result = entryObj;
            break;
        }
        return result;
    }

    public static DynamicObject matchXBillEntryByXentryId(long xbillentryid, DynamicObject xBill, String matchFlag) {
        DynamicObject result = null;
        if (null != xBill) {
            DynamicObjectCollection xbillEntrys = xBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject xbillEntry : xbillEntrys) {
                long matchId = xbillEntry.getLong(matchFlag);
                if (xbillentryid != matchId) continue;
                result = xbillEntry;
                break;
            }
        }
        return result;
    }

    public static DynamicObject[] queryManuBills(Set<Long> modEntrysLongIds, String entityType) {
        DynamicObject[] result = null;
        if (!modEntrysLongIds.isEmpty() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)entityType)) {
            String selectProperties = "isinitbill,org,treeentryentity,treeentryentity.id,treeentryentity.pid,treeentryentity.startworktime,treeentryentity.closetime,treeentryentity.taskstatus,treeentryentity.beginbookdate,treeentryentity.closebookdate,treeentryentity.inwardept,treeentryentity.producttype";
            QFilter filters = new QFilter("treeentryentity.id", "in", modEntrysLongIds);
            result = BusinessDataServiceHelper.load((String)entityType, (String)selectProperties, (QFilter[])filters.toArray());
        }
        return result;
    }

    public Map<Long, Map<String, Object>> closeOrInvalidOrderByOrderEntryId(Set<Long> orderEntryIdSet, String orderEntity) {
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(16);
        if (CollectionUtils.isNotEmpty(orderEntryIdSet) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderEntity)) {
            QFilter qFilter = new QFilter("treeentryentity.id", "in", orderEntryIdSet);
            String selectProperties = "billstatus,billno,transactiontype,treeentryentity.id";
            DynamicObject[] mftOrderBills = BusinessDataServiceHelper.load((String)orderEntity, (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
            StringBuilder sb = new StringBuilder(200);
            HashSet<Long> closeOrderIds = new HashSet<Long>(16);
            HashSet<Long> invalidOrderIds = new HashSet<Long>(16);
            HashMap<Long, List<Long>> orderIdAndEntryIdMap = new HashMap<Long, List<Long>>(16);
            HashMap<Long, ArrayList<Long>> orderIdAndEntryids = new HashMap<Long, ArrayList<Long>>(16);
            if (null != mftOrderBills && mftOrderBills.length > 0) {
                for (DynamicObject dynamicObject : mftOrderBills) {
                    Long l = dynamicObject.getLong("id");
                    String billStatus = dynamicObject.getString("billstatus");
                    if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"A", (CharSequence)billStatus) || org.apache.commons.lang3.StringUtils.equals((CharSequence)"B", (CharSequence)billStatus)) {
                        invalidOrderIds.add(dynamicObject.getLong("id"));
                    }
                    String billno = dynamicObject.getString("billno");
                    DynamicObjectCollection mftOrderBillEntrys = dynamicObject.getDynamicObjectCollection("treeentryentity");
                    for (DynamicObject mftOrderBillEntry : mftOrderBillEntrys) {
                        ArrayList<Long> tempEntryIds;
                        Long orderEntryId = mftOrderBillEntry.getLong("id");
                        if (orderEntryIdSet.contains(orderEntryId)) {
                            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"C", (CharSequence)billStatus)) {
                                Object entryPK = mftOrderBillEntry.getPkValue();
                                sb.append(billno).append(',').append(entryPK).append("@@@");
                                closeOrderIds.add(dynamicObject.getLong("id"));
                            } else {
                                ArrayList<Long> entryIds = (ArrayList<Long>)orderIdAndEntryids.get(l);
                                if (entryIds == null) {
                                    entryIds = new ArrayList<Long>(16);
                                }
                                entryIds.add(orderEntryId);
                                orderIdAndEntryids.put(l, entryIds);
                            }
                        }
                        if (null == (tempEntryIds = (ArrayList<Long>)orderIdAndEntryIdMap.get(l))) {
                            tempEntryIds = new ArrayList<Long>(16);
                        }
                        tempEntryIds.add(orderEntryId);
                        orderIdAndEntryIdMap.put(l, tempEntryIds);
                    }
                }
            }
            String key = this.getClass().getName() + ".closeOrInvalidOrderByOrderEntryId";
            HashMap<Long, Integer> orderIdAndAllEntrySize = new HashMap<Long, Integer>(16);
            Throwable throwable = null;
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)key, (String)orderEntity, (String)"id,treeentryentity.id", (QFilter[])new QFilter("id", "in", invalidOrderIds).toArray(), null);){
                for (Row row : ds) {
                    Long id = row.getLong("id");
                    Integer size = (Integer)orderIdAndAllEntrySize.get(id);
                    if (size == null) {
                        orderIdAndAllEntrySize.put(id, 1);
                        continue;
                    }
                    size = size + 1;
                    orderIdAndAllEntrySize.put(id, size);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            HashMap<Long, List<Long>> orderId2EntryIdMap = new HashMap<Long, List<Long>>(16);
            for (Map.Entry entry : orderIdAndEntryids.entrySet()) {
                int size = ((List)entry.getValue()).size();
                Long billId = (Long)entry.getKey();
                int allSize = (Integer)orderIdAndAllEntrySize.get(billId);
                if (allSize == size) continue;
                invalidOrderIds.remove(billId);
                orderId2EntryIdMap.put(billId, (List<Long>)entry.getValue());
            }
            if (CollectionUtils.isNotEmpty(invalidOrderIds)) {
                OperationResult operationResult;
                LOGGER.info("\u8c03\u7528\u751f\u4ea7\u5de5\u5355\u4f5c\u5e9f\u65b9\u6cd5");
                OperateOption operateOption = OperateOption.create();
                Object var16_31 = null;
                try {
                    operationResult = OperationServiceHelper.executeOperate((String)"invalid", (String)orderEntity, (Object[])invalidOrderIds.toArray(), (OperateOption)operateOption);
                }
                catch (Exception e) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u751f\u4ea7\u5de5\u5355\u4f5c\u5e9f\u65b9\u6cd5\u5931\u8d25\uff1a%1$s\u3002", (String)"OrderCommonService_6", (String)"bd-mpdm-business", (Object[])new Object[0]), null == e.getCause() ? ResManager.loadKDString((String)"\u8bf7\u67e5\u770b\u65e5\u5fd7\u4fe1\u606f", (String)"OrderCommonService_7", (String)"bd-mpdm-business", (Object[])new Object[0]) : e.getCause().getMessage()));
                }
                this.packageEntryOpResultInfo(operationResult, orderIdAndEntryIdMap, orderEntryIdSet, result);
            }
            if (CollectionUtils.isNotEmpty(closeOrderIds)) {
                OperationResult operationResult;
                LOGGER.info("\u8c03\u7528\u751f\u4ea7\u5de5\u5355\u5173\u95ed\u65b9\u6cd5");
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("operateOption", sb.toString());
                Object var16_34 = null;
                try {
                    operationResult = OperationServiceHelper.executeOperate((String)"shut", (String)orderEntity, (Object[])closeOrderIds.toArray(), (OperateOption)operateOption);
                }
                catch (Exception e) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u751f\u4ea7\u5de5\u5355\u5173\u95ed\u65b9\u6cd5\u5931\u8d25\uff1a%1$s\u3002", (String)"OrderCommonService_8", (String)"bd-mpdm-business", (Object[])new Object[0]), null == e.getCause() ? ResManager.loadKDString((String)"\u8bf7\u67e5\u770b\u65e5\u5fd7\u4fe1\u606f", (String)"OrderCommonService_7", (String)"bd-mpdm-business", (Object[])new Object[0]) : e.getCause().getMessage()));
                }
                this.packageEntryOpResultInfo(operationResult, orderIdAndEntryIdMap, orderEntryIdSet, result);
            }
            if (!orderId2EntryIdMap.isEmpty()) {
                LOGGER.info("\u8c03\u7528\u5206\u5f55\u5220\u9664\u65b9\u6cd5");
                this.deleteEntry(orderId2EntryIdMap, orderIdAndEntryIdMap, orderEntryIdSet, result);
            }
        }
        return result;
    }

    private void deleteEntry(Map<Long, List<Long>> orderId2EntryIdMap, Map<Long, List<Long>> orderIdAndEntryIdMap, Set<Long> orderEntryIdSet, Map<Long, Map<String, Object>> result) {
        LOGGER.info("orderId2EntryIdMap:" + orderId2EntryIdMap);
        HashSet entryIds = new HashSet();
        HashMap<Long, Long> entryId2Id = new HashMap<Long, Long>(100);
        for (Map.Entry<Long, List<Long>> entry : orderId2EntryIdMap.entrySet()) {
            for (Long entryid : entry.getValue()) {
                entryId2Id.put(entryid, entry.getKey());
            }
        }
        for (List list : orderId2EntryIdMap.values()) {
            entryIds.addAll(list);
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(new QFilter("mftentryseq.id", "in", entryIds));
        filters.add(new QFilter("billstatus", "=", (Object)"B"));
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>(entryIds.size());
        HashSet<Long> sfcmanftechIds = new HashSet<Long>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"query.sfcmanftech", (String)"sfc_manftech", (String)"id,mftentryseq.id entryid", (QFilter[])filters.toArray(new QFilter[2]), null);){
            for (Row row : ds) {
                sfcmanftechIds.add(row.getLong("id"));
                hashMap.put(row.getLong("id"), row.getLong("entryid"));
            }
        }
        OperationResult opresult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)"sfc_manftech", (Object[])sfcmanftechIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
        List successPkIds = opresult.getSuccessPkIds().stream().map(v -> Long.parseLong(v.toString())).collect(Collectors.toList());
        sfcmanftechIds.removeAll(successPkIds);
        for (Long id : sfcmanftechIds) {
            entryId2Id.remove(hashMap.get(id));
        }
        HashMap<Long, Long> mftstockIdAndorderEntryId = new HashMap<Long, Long>(entryIds.size());
        HashSet<Long> mftstockIds = new HashSet<Long>();
        filters.clear();
        filters.add(new QFilter("orderentryid.id", "in", entryIds));
        filters.add(new QFilter("billstatus", "=", (Object)"B"));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"query.pommftstock", (String)"pom_mftstock", (String)"id,orderentryid.id entryid", (QFilter[])filters.toArray(new QFilter[2]), null);){
            Iterator iterator = ds.iterator();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                mftstockIds.add(row.getLong("id"));
                mftstockIdAndorderEntryId.put(row.getLong("id"), row.getLong("entryid"));
            }
        }
        opresult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)"pom_mftstock", (Object[])mftstockIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
        successPkIds = opresult.getSuccessPkIds().stream().map(v -> Long.parseLong(v.toString())).collect(Collectors.toList());
        mftstockIds.removeAll(successPkIds);
        for (Long id : mftstockIds) {
            entryId2Id.remove(mftstockIdAndorderEntryId.get(id));
        }
        if (!entryId2Id.isEmpty()) {
            HashSet<Long> finalEntryIds = new HashSet<Long>(entryId2Id.keySet());
            this.excuteSqlForDelentry(finalEntryIds);
            Set<Long> finalIds = entryId2Id.values().stream().map(v -> Long.parseLong(v.toString())).collect(Collectors.toSet());
            opresult = OperationServiceHelper.executeOperate((String)"save", (String)"pom_mftorder", (Object[])finalIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
            this.packageEntryOpResultInfo(opresult, orderIdAndEntryIdMap, orderEntryIdSet, result);
        }
    }

    private void excuteSqlForDelentry(Set<Long> finalEntryIds) {
        LOGGER.info("finalEntryIds:" + finalEntryIds);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fentryid from t_pom_mftorderentry where ", new Object[0]);
        sqlBuilder.appendIn("fparententryid", new ArrayList<Long>(finalEntryIds));
        try (DataSet ds = DB.queryDataSet((String)"gett_pom_mftorderentry", (DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sqlBuilder);){
            for (Row row : ds) {
                finalEntryIds.add(row.getLong("fentryid"));
            }
        }
        LOGGER.info("finalEntryIds:" + finalEntryIds);
        String sql1 = "delete from t_pom_mftorderentry where ";
        String sql2 = "delete from t_pom_mftorderentry_e where ";
        SqlBuilder sqlBuilder1 = new SqlBuilder();
        sqlBuilder1.append(sql1, new Object[0]);
        sqlBuilder1.appendIn("fentryid", new ArrayList<Long>(finalEntryIds));
        SqlBuilder sqlBuilder2 = new SqlBuilder();
        sqlBuilder2.append(sql2, new Object[0]);
        sqlBuilder2.appendIn("fentryid", new ArrayList<Long>(finalEntryIds));
        try (TXHandle h = TX.requiresNew((String)"excuteSqlForDelentry");){
            try {
                DB.execute((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sqlBuilder1);
                DB.execute((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sqlBuilder2);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public DynamicObject filterByorderBy(Map<Object, DynamicObject> processrouteMap) {
        DynamicObject processroute = null;
        DynamicObject nullVersionProcessroute = null;
        if (processrouteMap != null) {
            Date date = null;
            for (Map.Entry<Object, DynamicObject> entry : processrouteMap.entrySet()) {
                DynamicObject processrouteInMap = entry.getValue();
                if (null == processrouteInMap) continue;
                DynamicObject version = processrouteInMap.getDynamicObject("routeversion");
                if (null != version) {
                    Date effectivedate = version.getDate("effectdate");
                    if (null != date && !date.before(effectivedate)) continue;
                    date = effectivedate;
                    processroute = processrouteInMap;
                    continue;
                }
                nullVersionProcessroute = processrouteInMap;
            }
        }
        if (processroute == null && nullVersionProcessroute != null) {
            return nullVersionProcessroute;
        }
        return processroute;
    }

    public Map<Long, Map<String, Object>> xOrderByOrderEntryIdNew(Map<Long, Map<String, Object>> orderEntryIdAndChangeInfo, String orderEntity) {
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(16);
        if (null != orderEntryIdAndChangeInfo && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderEntity)) {
            Set<Long> orderEntryIds = orderEntryIdAndChangeInfo.keySet();
            ArrayList<DynamicObject> xOrderLogs = new ArrayList<DynamicObject>(10);
            QFilter qFilter = new QFilter("treeentryentity.id", "in", orderEntryIds);
            String selectPro = OrderSpliteService.getBillAllPropers("pom_mftorder", "treeentryentity") + ",treeentryentity_lk,treeentryentity_lk_stableid,treeentryentity_lk_sbillid,treeentryentity_lk_sid";
            DynamicObject[] mftOrderBills = BusinessDataServiceHelper.load((String)orderEntity, (String)selectPro, (QFilter[])new QFilter[]{qFilter});
            Set<Long> orderEntryIdByCompareExpendbomTimeSet = this.compareExpendbomTime(orderEntryIdAndChangeInfo, mftOrderBills);
            Map<Object, String> filterStockPassed = this.filterStockFaild(orderEntryIdByCompareExpendbomTimeSet);
            if (null != mftOrderBills && mftOrderBills.length > 0) {
                HashSet<Long> stockIdSet;
                DynamicObject[] stockDyns;
                HashMap<Long, List<Long>> orderIdAndEntryIdMap = new HashMap<Long, List<Long>>(16);
                HashMap<String, DynamicObject> orgAndMetarialPlanInfo = new HashMap<String, DynamicObject>(16);
                this.queryPlanInfo(mftOrderBills, orgAndMetarialPlanInfo);
                Date now = new Date();
                Map productOrgAndBookDateMap = null;
                Map maxInvOrgAndBookDateMap = null;
                boolean bookDateEqualsBizDate = OrderBookDateService.bookDateEqualsBizDate();
                HashSet<Long> mftorderEntryIds = new HashSet<Long>(10);
                if (!bookDateEqualsBizDate) {
                    Map<String, Map<Long, Date>> bookdates = OrderBookDateService.makeupOrgDates(mftorderEntryIds, mftOrderBills);
                    productOrgAndBookDateMap = (Map)bookdates.get("productOrgAndBookDateMap");
                    maxInvOrgAndBookDateMap = (Map)bookdates.get("maxInvOrgAndBookDateMap");
                }
                for (DynamicObject mftOrderBill : mftOrderBills) {
                    Long orgID = 0L;
                    DynamicObject org = mftOrderBill.getDynamicObject("org");
                    if (null != org) {
                        orgID = org.getLong("id");
                    }
                    DynamicObject[] orderEntrys = mftOrderBill.getDynamicObjectCollection("treeentryentity");
                    Long mftOrderBillId = mftOrderBill.getLong("id");
                    for (DynamicObject orderEntry : orderEntrys) {
                        ArrayList<Long> tempEntryIds;
                        Map<String, Object> chanInfoMap;
                        Long orderEntryId = orderEntry.getLong("id");
                        if (orderEntryIds.contains(orderEntryId) && null != (chanInfoMap = orderEntryIdAndChangeInfo.get(orderEntryId))) {
                            DynamicObject xLog;
                            String taskstatus;
                            Object workCenterObj = chanInfoMap.get("workcenter");
                            if (null != workCenterObj) {
                                orderEntry.set("workcenter", (Object)((DynamicObject)workCenterObj));
                                MftOrderSetWorkCenterHelper mftOrderSetWorkCenterHelper = new MftOrderSetWorkCenterHelper();
                                mftOrderSetWorkCenterHelper.setWorkCenter(mftOrderBill, orderEntry.getInt("seq") - 1, (DynamicObject)workCenterObj);
                            }
                            DynamicObject planInfo = null;
                            DynamicObject mftMaterial = orderEntry.getDynamicObject("material");
                            if (null != mftMaterial) {
                                DynamicObject bdmaterial = mftMaterial.getDynamicObject(MASTERID);
                                String key = "orgid:" + orgID + ";materialID:" + bdmaterial.getLong("id");
                                planInfo = (DynamicObject)orgAndMetarialPlanInfo.get(key);
                            }
                            this.setOrderEntryInfo(orderEntry, orderEntryIdAndChangeInfo, planInfo, filterStockPassed);
                            Date bookDate = null;
                            DynamicObject matchEntry = OrderCommonService.matchEntryInfo(orderEntry, (DynamicObjectCollection)orderEntrys);
                            String string = taskstatus = null == matchEntry ? "A" : matchEntry.getString("taskstatus");
                            if (!StringUtils.equals((CharSequence)"A", (CharSequence)taskstatus)) {
                                if (bookDateEqualsBizDate) {
                                    bookDate = now;
                                } else {
                                    Date xbillDate = now;
                                    bookDate = OrderBookDateService.queryBookDateWithCompare(mftOrderBill, matchEntry, productOrgAndBookDateMap, maxInvOrgAndBookDateMap, xbillDate, null, false, null, false);
                                }
                            }
                            if (null != (xLog = this.packageXLogList(bookDate, mftOrderBill, orderEntry))) {
                                xOrderLogs.add(xLog);
                            }
                        }
                        if (null == (tempEntryIds = (ArrayList<Long>)orderIdAndEntryIdMap.get(mftOrderBillId))) {
                            tempEntryIds = new ArrayList<Long>(16);
                        }
                        tempEntryIds.add(orderEntryId);
                        orderIdAndEntryIdMap.put(mftOrderBillId, tempEntryIds);
                    }
                }
                OperateOption op = OperateOption.create();
                op.setVariableValue("isInvokeByXorderAudit", "true");
                OperationResult saveOperate = null;
                try {
                    saveOperate = SaveServiceHelper.saveOperate((String)"pom_mftorder", (DynamicObject[])mftOrderBills, (OperateOption)op);
                }
                catch (Exception e) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u751f\u4ea7\u5de5\u5355\u4fdd\u5b58\u65b9\u6cd5\u5931\u8d25\uff1a%1$s\u3002", (String)"OrderCommonService_9", (String)"bd-mpdm-business", (Object[])new Object[0]), null == e.getCause() ? ResManager.loadKDString((String)"\u8bf7\u67e5\u770b\u65e5\u5fd7\u4fe1\u606f", (String)"OrderCommonService_7", (String)"bd-mpdm-business", (Object[])new Object[0]) : e.getCause().getMessage()));
                }
                this.packageEntryOpResultInfo(saveOperate, orderIdAndEntryIdMap, orderEntryIds, result);
                List successPkIds = saveOperate.getSuccessPkIds();
                ArrayList<DynamicObject> xOrderSuccessLogs = new ArrayList<DynamicObject>(10);
                HashSet<Long> submitOrderEntryIdSet = new HashSet<Long>(16);
                HashSet<Long> auditOrderEntryIdSet = new HashSet<Long>(16);
                for (DynamicObject mftOrderBill : mftOrderBills) {
                    if (!successPkIds.contains(mftOrderBill.getPkValue())) continue;
                    DynamicObjectCollection orderEntrys = mftOrderBill.getDynamicObjectCollection("treeentryentity");
                    for (DynamicObject orderEntry : orderEntrys) {
                        Long orderEntryId = orderEntry.getLong("id");
                        if (!orderEntryIds.contains(orderEntryId)) continue;
                        for (DynamicObject xOrderLog : xOrderLogs) {
                            Long srcbillentryid = xOrderLog.getLong("srcbillentryid");
                            if (!orderEntryId.equals(srcbillentryid)) continue;
                            xOrderSuccessLogs.add(xOrderLog);
                        }
                        HashMap<String, String> temp = new HashMap<String, String>(16);
                        temp.put("success", "true");
                        temp.put("message", ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"OrderCommonService_0", (String)"bd-mpdm-business", (Object[])new Object[0]));
                        result.put(orderEntryId, temp);
                        if (null == filterStockPassed.get(orderEntry.getPkValue())) continue;
                        String stockBillStatus = filterStockPassed.get(orderEntry.getPkValue());
                        if ("C".equals(stockBillStatus)) {
                            auditOrderEntryIdSet.add(orderEntryId);
                            submitOrderEntryIdSet.add(orderEntryId);
                            continue;
                        }
                        if (!"B".equals(stockBillStatus)) continue;
                        submitOrderEntryIdSet.add(orderEntryId);
                    }
                }
                if (CollectionUtils.isNotEmpty(xOrderSuccessLogs)) {
                    SaveServiceHelper.save((DynamicObject[])xOrderSuccessLogs.toArray(new DynamicObject[0]));
                }
                String stockEntity = "pom_mftstock";
                if (CollectionUtils.isNotEmpty(submitOrderEntryIdSet)) {
                    String selectProperties = "id,orderentryid";
                    QFilter qFilter1 = new QFilter("orderentryid", "in", submitOrderEntryIdSet);
                    stockDyns = BusinessDataServiceHelper.load((String)stockEntity, (String)selectProperties, (QFilter[])new QFilter[]{qFilter1});
                    stockIdSet = new HashSet<Long>(16);
                    for (DynamicObject stockDyn : stockDyns) {
                        stockIdSet.add(stockDyn.getLong("id"));
                    }
                    if (CollectionUtils.isNotEmpty(stockIdSet)) {
                        OperationServiceHelper.executeOperate((String)"submit", (String)stockEntity, (Object[])stockIdSet.toArray(), (OperateOption)OperateOption.create());
                    }
                }
                if (CollectionUtils.isNotEmpty(auditOrderEntryIdSet)) {
                    String selectProperties = "id,orderentryid";
                    QFilter qFilter1 = new QFilter("orderentryid", "in", auditOrderEntryIdSet);
                    stockDyns = BusinessDataServiceHelper.load((String)stockEntity, (String)selectProperties, (QFilter[])new QFilter[]{qFilter1});
                    stockIdSet = new HashSet(16);
                    for (DynamicObject stockDyn : stockDyns) {
                        stockIdSet.add(stockDyn.getLong("id"));
                    }
                    if (CollectionUtils.isNotEmpty(stockIdSet)) {
                        OperationServiceHelper.executeOperate((String)"audit", (String)stockEntity, (Object[])stockIdSet.toArray(), (OperateOption)OperateOption.create());
                    }
                }
            }
        }
        return result;
    }

    private Set<Long> compareExpendbomTime(Map<Long, Map<String, Object>> orderEntryIdAndChangeInfo, DynamicObject[] mftOrderBills) {
        HashSet<Long> result = new HashSet<Long>(16);
        if (null != orderEntryIdAndChangeInfo && null != mftOrderBills) {
            for (DynamicObject mftOrderBill : mftOrderBills) {
                DynamicObjectCollection orderEntrys = mftOrderBill.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject orderEntry : orderEntrys) {
                    Object planBeginTime;
                    Long orderEntryId = orderEntry.getLong("id");
                    Date expendbomtime = orderEntry.getDate("expendbomtime");
                    Map<String, Object> orderModInfoMap = orderEntryIdAndChangeInfo.get(orderEntryId);
                    if (null == orderModInfoMap || null == (planBeginTime = orderModInfoMap.get("planbegintime")) || expendbomtime.compareTo((Date)planBeginTime) == 0) continue;
                    result.add(orderEntryId);
                }
            }
        }
        return result;
    }

    private Map<Object, String> filterStockFaild(Set<Long> orderEntryIdSet) {
        QFilter qFilter;
        String selectProperties;
        String stockEntity;
        DynamicObject[] stockDyns;
        HashMap<Object, String> result = new HashMap<Object, String>(16);
        HashMap<Long, String> temMap = new HashMap<Long, String>(16);
        HashMap<Long, Long> stockIdAndOrderEntryIdMap = new HashMap<Long, Long>(16);
        if (CollectionUtils.isNotEmpty(orderEntryIdSet) && null != (stockDyns = BusinessDataServiceHelper.load((String)(stockEntity = "pom_mftstock"), (String)(selectProperties = "id,orderentryid,billstatus"), (QFilter[])new QFilter[]{qFilter = new QFilter("orderentryid", "in", orderEntryIdSet)}))) {
            Long orderEntryId;
            HashSet<Object> unauditStockIdSet = new HashSet<Object>(16);
            HashSet<Object> unsubmitStockIdSet = new HashSet<Object>(16);
            for (DynamicObject stockDyn : stockDyns) {
                DynamicObject orderentryid = stockDyn.getDynamicObject("orderentryid");
                if (null == orderentryid || !orderEntryIdSet.contains(orderentryid.getLong("id"))) continue;
                orderEntryId = orderentryid.getLong("id");
                String billstatus = stockDyn.getString("billstatus");
                temMap.put(orderEntryId, billstatus);
                Long stockId = stockDyn.getLong("id");
                stockIdAndOrderEntryIdMap.put(stockId, orderEntryId);
                Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"pom_mftstock", (Long[])new Long[]{stockId});
                if (!targetBills.isEmpty()) continue;
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"C", (CharSequence)billstatus)) {
                    unauditStockIdSet.add(stockDyn.getPkValue());
                    continue;
                }
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"B", (CharSequence)billstatus)) {
                    unsubmitStockIdSet.add(stockDyn.getPkValue());
                    continue;
                }
                result.put(orderEntryId, billstatus);
            }
            if (CollectionUtils.isNotEmpty(unauditStockIdSet)) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("stockchangecheckplanstatus", "false");
                OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"unaudit", (String)stockEntity, (Object[])unauditStockIdSet.toArray(), (OperateOption)operateOption);
                List successPkIds = executeOperate.getSuccessPkIds();
                for (Object successPkId : successPkIds) {
                    orderEntryId = (Long)stockIdAndOrderEntryIdMap.get(successPkId);
                    result.put(orderEntryId, (String)temMap.get(orderEntryId));
                }
            }
            if (CollectionUtils.isNotEmpty(unsubmitStockIdSet)) {
                OperationResult unsubmitexecuteOperate = OperationServiceHelper.executeOperate((String)"unsubmit", (String)stockEntity, (Object[])unsubmitStockIdSet.toArray(), (OperateOption)OperateOption.create());
                List unsubmitsuccessPkIds = unsubmitexecuteOperate.getSuccessPkIds();
                for (Object successPkId : unsubmitsuccessPkIds) {
                    Long orderEntryId2 = (Long)stockIdAndOrderEntryIdMap.get(successPkId);
                    result.put(orderEntryId2, (String)temMap.get(orderEntryId2));
                }
            }
        }
        return result;
    }

    private void queryPlanInfo(DynamicObject[] mftOrderBills, Map<String, DynamicObject> orgAndMetarialPlanInfo) {
        HashMap<Long, HashSet<Long>> orgAndMaterialMap = new HashMap<Long, HashSet<Long>>(16);
        for (DynamicObject mftOrderBill : mftOrderBills) {
            DynamicObject org = mftOrderBill.getDynamicObject("org");
            if (null == org) continue;
            DynamicObjectCollection orderEntrys = mftOrderBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntrys) {
                DynamicObject bdmaterial;
                DynamicObject mftMaterial = orderEntry.getDynamicObject("material");
                if (null == mftMaterial || null == (bdmaterial = mftMaterial.getDynamicObject(MASTERID))) continue;
                HashSet<Long> temp = (HashSet<Long>)orgAndMaterialMap.get(org.getLong("id"));
                if (null == temp) {
                    temp = new HashSet<Long>(16);
                }
                temp.add(bdmaterial.getLong("id"));
                orgAndMaterialMap.put(org.getLong("id"), temp);
            }
        }
        if (null != orgAndMaterialMap && orgAndMaterialMap.size() > 0) {
            for (Map.Entry entry : orgAndMaterialMap.entrySet()) {
                Long orgID = (Long)entry.getKey();
                Set materialIDSet = (Set)entry.getValue();
                Map planInfoMap = MaterialPlanQueryHelper.getDataCacheByMaterialSet((Set)materialIDSet, (Long)orgID);
                if (null == planInfoMap) continue;
                for (Map.Entry planMapEntry : planInfoMap.entrySet()) {
                    if (null == planMapEntry.getKey()) continue;
                    Long parseLong = Long.parseLong(planMapEntry.getKey().toString());
                    String key = "orgid:" + orgID + ";materialID:" + parseLong;
                    orgAndMetarialPlanInfo.put(key, (DynamicObject)planMapEntry.getValue());
                }
            }
        }
    }

    private void setOrderEntryInfo(DynamicObject orderEntry, Map<Long, Map<String, Object>> orderEntryIdAndChangeInfo, DynamicObject planInfo, Map<Object, String> filterStockFaild) {
        Long orderEntryId;
        Map<String, Object> changeInfoMap;
        Object planBeginTime;
        if (null != orderEntry && null != orderEntryIdAndChangeInfo && null != (planBeginTime = (changeInfoMap = orderEntryIdAndChangeInfo.get(orderEntryId = Long.valueOf(orderEntry.getLong("id")))).get("planbegintime"))) {
            Date begindate = (Date)planBeginTime;
            Date enddate = null;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(begindate);
            if (planInfo != null) {
                String leadtimetype = planInfo.getString("leadtimetype");
                int fixedleadtime = planInfo.getInt("fixedleadtime");
                int changeleadtime = planInfo.getInt("changeleadtime");
                int preprocessingtime = planInfo.getInt("preprocessingtime");
                int postprocessingtime = planInfo.getInt("postprocessingtime");
                int changebatch = planInfo.getInt("changebatch");
                if ("A".equals(leadtimetype)) {
                    calendar.add(5, fixedleadtime);
                } else if ("B".equals(leadtimetype)) {
                    BigDecimal qty = orderEntry.getBigDecimal("qty");
                    BigDecimal decChangebatch = new BigDecimal(changebatch);
                    BigDecimal decChangeleadtime = new BigDecimal(changeleadtime);
                    if (changebatch != 0) {
                        BigDecimal calResult = qty.multiply(decChangeleadtime).divide(decChangebatch, 0, 0);
                        calendar.add(5, calResult.intValue());
                    }
                }
                calendar.add(5, preprocessingtime);
                calendar.add(5, postprocessingtime);
                enddate = calendar.getTime();
            } else {
                enddate = calendar.getTime();
            }
            orderEntry.set("planpreparetime", (Object)begindate);
            orderEntry.set("planbegintime", (Object)begindate);
            if (null != filterStockFaild.get(orderEntry.getPkValue())) {
                orderEntry.set("expendbomtime", (Object)begindate);
            }
            orderEntry.set("planendtime", (Object)enddate);
        }
    }

    private DynamicObject packageXLogList(Date bookDate, DynamicObject orderDyn, DynamicObject newOrderEntryDyn) {
        DynamicObject xlog = null;
        if (null != orderDyn && null != newOrderEntryDyn) {
            HashMap addSeqMap = new HashMap(16);
            DynamicObject xOrderDy = BusinessDataServiceHelper.newDynamicObject((String)"pom_xmftorder");
            DynamicObjectCollection xOrderDyEntryCol = xOrderDy.getDynamicObjectCollection("treeentryentity");
            DynamicObject xOrderDyEntry = xOrderDyEntryCol.addNew();
            this.packageXorderDyn(xOrderDy, orderDyn);
            this.packageXorderEntryDyn(xOrderDyEntry, newOrderEntryDyn, orderDyn);
            xlog = XMftOrderChangeLogUtils.makeUpXMftorderChangeLog((String)"B", (DynamicObject)xOrderDy, (DynamicObject)xOrderDyEntry, addSeqMap, (Date)bookDate);
        }
        return xlog;
    }

    private void packageXorderDyn(DynamicObject xOrderDy, DynamicObject orderDy) {
        if (null != orderDy && null != xOrderDy) {
            for (String xmftorderFromOrderField : xmftorderFromOrderFields) {
                xOrderDy.set(xmftorderFromOrderField, orderDy.get(xmftorderFromOrderField));
            }
            xOrderDy.set("id", orderDy.get("id"));
            xOrderDy.set("billdate", (Object)new Date());
            xOrderDy.set("reason", (Object)ResManager.loadKDString((String)"\u6392\u4ea7\u8ba1\u5212\u8054\u52a8\u8c03\u6574\u8ba1\u5212\u5f00\u5de5\u65f6\u95f4", (String)"OrderCommonService_5", (String)"bd-mpdm-business", (Object[])new Object[0]));
            xOrderDy.set("creator", (Object)RequestContext.get().getUserId());
        }
    }

    private void packageXorderEntryDyn(DynamicObject xOrderEntryDy, DynamicObject orderEntryDy, DynamicObject orderDyn) {
        if (null != orderEntryDy && null != xOrderEntryDy) {
            for (String xmftorderEntryFromOrderEntryField : xmftorderEntryFromOrderEntryFields) {
                xOrderEntryDy.set(xmftorderEntryFromOrderEntryField, orderEntryDy.get(xmftorderEntryFromOrderEntryField));
            }
            xOrderEntryDy.set("changetype", (Object)"B");
            xOrderEntryDy.set("srcbillno", (Object)orderDyn.getString("billno"));
            xOrderEntryDy.set("srcbillid", (Object)orderDyn.getString("id"));
            xOrderEntryDy.set("srcbillentryid", (Object)orderEntryDy.getString("id"));
            xOrderEntryDy.set("srcbillentryseq", (Object)orderEntryDy.getString("seq"));
        }
    }

    private void packageEntryOpResultInfo(OperationResult invalidResult, Map<Long, List<Long>> orderIdAndEntryIdMap, Set<Long> orderEntryIdList, Map<Long, Map<String, Object>> result) {
        List invalidSuccessPkIds = invalidResult.getSuccessPkIds();
        HashSet<Long> set = new HashSet<Long>(16);
        for (Object invalidSuccessPkIdObj : invalidSuccessPkIds) {
            if (null == invalidSuccessPkIdObj) continue;
            Long invalidSuccessPkId = Long.parseLong(invalidSuccessPkIdObj.toString());
            List<Long> entryIds = orderIdAndEntryIdMap.get(invalidSuccessPkId);
            entryIds.retainAll(orderEntryIdList);
            for (Long entryId : entryIds) {
                HashMap<String, String> temp = new HashMap<String, String>(16);
                temp.put("success", "true");
                temp.put("message", ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"OrderCommonService_0", (String)"bd-mpdm-business", (Object[])new Object[0]));
                result.put(entryId, temp);
                set.add(entryId);
            }
        }
        List allErrorOrValidateInfo = invalidResult.getAllErrorOrValidateInfo();
        for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
            Object pkValue = iOperateInfo.getPkValue();
            if (null == pkValue) continue;
            Long invalidFailPkId = Long.parseLong(pkValue.toString());
            List<Long> entryIds = orderIdAndEntryIdMap.get(invalidFailPkId);
            entryIds.retainAll(orderEntryIdList);
            for (Long entryId : entryIds) {
                HashMap<String, String> temp = new HashMap<String, String>(16);
                temp.put("success", "false");
                temp.put("message", iOperateInfo.getMessage());
                result.put(entryId, temp);
                set.add(entryId);
            }
        }
        if (CollectionUtils.isNotEmpty(orderEntryIdList) && !invalidResult.isSuccess()) {
            orderEntryIdList.removeAll(set);
            for (Long aLong : orderEntryIdList) {
                HashMap<String, String> temp = new HashMap<String, String>(16);
                temp.put("success", "false");
                temp.put("message", invalidResult.getMessage());
                result.put(aLong, temp);
            }
        }
    }
}

