/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.mftorder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.primitives.Longs;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.business.mftorder.OrderCommonService;
import kd.bd.mpdm.business.mftorder.OrderQualityOrgService;
import kd.bd.mpdm.common.enums.UnitConvertDirEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillProductTypeEnum;
import kd.bd.mpdm.common.mftorder.helper.BillUnitAndQtytHelper;
import kd.bd.mpdm.common.mftorder.helper.WarehouseHelper;
import kd.bd.mpdm.common.utils.MulBaseDataUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class OrderImportService {
    private static Log logger = LogFactory.getLog(OrderImportService.class);
    private static final String KEY_ID = "id";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_TREEENTRYENTITY = "treeentryentity";
    private static final String SUSPEND = "suspend";
    private static String entityId = "pom_mftorder";
    private static String billName = "";
    private static DynamicObject transactiontype = null;
    private static DynamicObject org = null;

    public static void initImportDataMethod(List<Map<String, Object>> sourceDataList, BillModel billModel, Map<String, Object> option) {
        if (OrderImportService.isfromapi(option)) {
            return;
        }
        int paValueIDsNum = 0;
        if (null != sourceDataList && sourceDataList.size() > 0) {
            for (Map<String, Object> sourceData : sourceDataList) {
                Object objEntry = sourceData.get(KEY_TREEENTRYENTITY);
                JSONArray arrEntrys = new JSONArray();
                logger.info("OrderImportService->initImportDataMethod->01: objEntry = " + objEntry.toString());
                if (OrderImportService.isfromapi(option)) {
                    arrEntrys = (JSONArray)JSONObject.toJSON((Object)objEntry);
                    sourceData.put(KEY_TREEENTRYENTITY, JSONObject.toJSON((Object)objEntry));
                    Object org = sourceData.get("org");
                    sourceData.put("org", JSONObject.toJSON((Object)org));
                    Object transactiontype = sourceData.get("transactiontype");
                    sourceData.put("transactiontype", JSONObject.toJSON((Object)transactiontype));
                }
                if (option.containsKey("importtype")) {
                    arrEntrys = (JSONArray)objEntry;
                }
                if (arrEntrys == null) continue;
                for (int i = 0; i < arrEntrys.size(); ++i) {
                    long id;
                    JSONObject entryObj = arrEntrys.getJSONObject(i);
                    if (entryObj == null || 0L != (id = entryObj.getLongValue(KEY_ID))) continue;
                    ++paValueIDsNum;
                }
            }
        }
        MainEntityType mainEntityType = billModel.getMainEntityType();
        String entityName = mainEntityType.getName();
        List<Long> pkValues = OrderImportService.genPkValues(paValueIDsNum, entityName);
        int pkValueConner = 0;
        JSONObject billTypeJson = null;
        List<DynamicObject> billTypes = OrderCommonService.queryBillType(entityName);
        for (DynamicObject dynamicObject : billTypes) {
            if (null == dynamicObject) continue;
            boolean isdefault = dynamicObject.getBoolean("isdefault");
            String number = dynamicObject.getString(KEY_NUMBER);
            String name = dynamicObject.getString("name");
            if (!isdefault || !StringUtils.isNotBlank((CharSequence)number)) continue;
            HashMap<String, String> mapObj = new HashMap<String, String>();
            mapObj.put("importprop", KEY_NUMBER);
            mapObj.put(KEY_NUMBER, number);
            mapObj.put("name", name);
            billTypeJson = new JSONObject(mapObj);
            break;
        }
        if (null != sourceDataList && sourceDataList.size() > 0) {
            for (Map map : sourceDataList) {
                Object objEntry = map.get(KEY_TREEENTRYENTITY);
                JSONArray arrEntrys = new JSONArray();
                if (OrderImportService.isfromapi(option)) {
                    arrEntrys = (JSONArray)JSONObject.toJSON(objEntry);
                    map.put(KEY_TREEENTRYENTITY, JSONObject.toJSON(objEntry));
                    Object org = map.get("org");
                    map.put("org", JSONObject.toJSON(org));
                    Object transactiontype = map.get("transactiontype");
                    map.put("transactiontype", JSONObject.toJSON(transactiontype));
                }
                if (option.containsKey("importtype")) {
                    arrEntrys = (JSONArray)objEntry;
                }
                if (arrEntrys == null) continue;
                pkValueConner = OrderImportService.setRelatedProductsPid(map, pkValues, pkValueConner);
                OrderImportService.setEntryStatus(map);
                for (int i = 0; i < arrEntrys.size(); ++i) {
                    JSONObject entryObj = arrEntrys.getJSONObject(i);
                    if (entryObj == null) continue;
                    OrderImportService.setManulVersion(entryObj, map);
                    OrderImportService.recalEntryQtys(entryObj);
                }
                OrderImportService.assignEntryOrgs(map);
                OrderImportService.setBillType(map, billTypeJson);
                OrderImportService.setMaterielMasterid(map);
            }
        }
    }

    public static List<Long> genPkValues(int size, String entityName) {
        ORM orm = ORM.create();
        long[] genLongIds = orm.genLongIds(entityName + ".treeentryentity", size);
        return Longs.asList((long[])genLongIds);
    }

    private static int setRelatedProductsPid(Map<String, Object> sourceData, List<Long> pkValues, int pkValusCon) {
        JSONArray arrEntrys = (JSONArray)sourceData.get(KEY_TREEENTRYENTITY);
        long pid = 0L;
        for (int i = 0; i < arrEntrys.size(); ++i) {
            JSONObject entryObj = arrEntrys.getJSONObject(i);
            if (null == entryObj) continue;
            String productType = entryObj.getString("producttype");
            if (StringUtils.equals((CharSequence)"C", (CharSequence)productType)) {
                long pidInEntry = entryObj.getLongValue(KEY_ID);
                if (0L == pidInEntry) {
                    pid = pkValues.get(pkValusCon);
                    ++pkValusCon;
                    entryObj.put(KEY_ID, (Object)pid);
                    continue;
                }
                pid = pidInEntry;
                continue;
            }
            long idInEntry = entryObj.getLongValue(KEY_ID);
            if (0L == idInEntry) {
                long id = pkValues.get(pkValusCon);
                ++pkValusCon;
                entryObj.put(KEY_ID, (Object)id);
            }
            entryObj.put("pid", (Object)pid);
        }
        return pkValusCon;
    }

    private static void setEntryStatus(Map<String, Object> sourceData) {
        JSONArray arrEntrys = (JSONArray)sourceData.get(KEY_TREEENTRYENTITY);
        for (int i = 0; i < arrEntrys.size(); ++i) {
            JSONObject entryObj = arrEntrys.getJSONObject(i);
            if (null == entryObj) continue;
            entryObj.put("planstatus", (Object)"A");
            entryObj.put("taskstatus", (Object)"A");
            entryObj.put("bizstatus", (Object)"A");
            entryObj.put("pickstatus", (Object)"A");
            entryObj.put("manftechstatus", (Object)"F");
            BigDecimal qty = entryObj.getBigDecimal("qty");
            if (null == qty) continue;
            entryObj.put("planqty", (Object)qty);
        }
    }

    private static void setMaterielMasterid(Map<String, Object> sourceData) {
        JSONArray arrEntrys = (JSONArray)sourceData.get(KEY_TREEENTRYENTITY);
        for (int i = 0; i < arrEntrys.size(); ++i) {
            String materialNumber;
            QFilter materialFilter;
            DynamicObject material;
            JSONObject materialObj;
            JSONObject entryObj = arrEntrys.getJSONObject(i);
            if (null == entryObj || null == (materialObj = (JSONObject)entryObj.get((Object)"material")) || null == (material = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (String)"id,number,name", (QFilter[])new QFilter[]{materialFilter = new QFilter(KEY_NUMBER, "=", (Object)(materialNumber = materialObj.getString(KEY_NUMBER)))}))) continue;
            HashMap<String, String> materialDO = new HashMap<String, String>();
            materialDO.put("importprop", KEY_NUMBER);
            materialDO.put(KEY_NUMBER, material.getString(KEY_NUMBER));
            materialDO.put("name", material.getString("name"));
            JSONObject materialJson = new JSONObject(materialDO);
            entryObj.put("materielmasterid", (Object)materialJson);
        }
    }

    private static void setBillType(Map<String, Object> sourceData, JSONObject billTypeJson) {
        Object billtype = sourceData.get("billtype");
        if (null == billtype) {
            sourceData.put("billtype", billTypeJson);
        }
    }

    private static void setManulVersion(JSONObject entryObj, Map<String, Object> sourceData) {
        JSONObject orgObj = (JSONObject)sourceData.get("org");
        JSONObject materialObj = (JSONObject)entryObj.get((Object)"material");
        JSONObject manuversionObj = (JSONObject)entryObj.get((Object)"manuversion");
        if (orgObj == null || materialObj == null || manuversionObj == null) {
            return;
        }
        String id = manuversionObj.getString(KEY_ID);
        String number = manuversionObj.getString(KEY_NUMBER);
        String orgNumber = orgObj.getString(KEY_NUMBER);
        String materialNumber = materialObj.getString(KEY_NUMBER);
        if (id != null) {
            DynamicObject verionDyncObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(id), (String)"pdm_manuversion", (String)"id,bom,processroute");
            OrderImportService.setBOMByManulVersion(entryObj, verionDyncObj);
        }
        if (StringUtils.isBlank((CharSequence)number) || id != null || StringUtils.isBlank((CharSequence)orgNumber) || StringUtils.isBlank((CharSequence)materialNumber)) {
            return;
        }
        QFilter qfilter = new QFilter(KEY_NUMBER, "=", (Object)number);
        qfilter.and("createorg.number", "=", (Object)orgNumber);
        qfilter.and("material.masterid.number", "=", (Object)materialNumber);
        DynamicObject verionDyncObj = BusinessDataServiceHelper.loadSingleFromCache((String)"pdm_manuversion", (String)"id,bom,processroute", (QFilter[])qfilter.toArray());
        if (verionDyncObj != null) {
            manuversionObj.put(KEY_ID, (Object)verionDyncObj.getLong(KEY_ID));
            OrderImportService.setBOMByManulVersion(entryObj, verionDyncObj);
        }
    }

    private static void setBOMByManulVersion(JSONObject entryObj, DynamicObject manulversion) {
        JSONObject bom = (JSONObject)entryObj.get((Object)"bomid");
        JSONObject processroute = (JSONObject)entryObj.get((Object)"processroute");
        if (bom == null) {
            DynamicObject dyBOM = manulversion.getDynamicObject("bom");
            HashMap<String, String> mapbom = new HashMap<String, String>();
            mapbom.put("importprop", KEY_NUMBER);
            mapbom.put(KEY_NUMBER, dyBOM.getString(KEY_NUMBER));
            bom = new JSONObject(mapbom);
            entryObj.put("bomid", (Object)bom);
        }
        if (processroute == null) {
            DynamicObject dyprocessroute = manulversion.getDynamicObject("processroute");
            HashMap<String, String> mapprocessroute = new HashMap<String, String>();
            mapprocessroute.put("importprop", KEY_NUMBER);
            String routeNumber = dyprocessroute == null ? "" : dyprocessroute.getString(KEY_NUMBER);
            mapprocessroute.put(KEY_NUMBER, routeNumber);
            processroute = new JSONObject(mapprocessroute);
            entryObj.put("processroute", (Object)processroute);
        }
    }

    private static void recalEntryQtys(JSONObject entryObj) {
        Object unitObj = entryObj.get((Object)"unit");
        DynamicObject unitDo = null;
        if (null == unitObj) {
            return;
        }
        JSONObject unit = (JSONObject)unitObj;
        QFilter filter = new QFilter(KEY_NUMBER, "=", (Object)unit.getString(KEY_NUMBER));
        unitDo = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_measureunits", (QFilter[])new QFilter[]{filter});
        Object materialObj = entryObj.get((Object)"material");
        if (null != unitDo && null != materialObj) {
            String selectProperties = "auxptyunit,unitconvertdir,baseunit,auxptyunit";
            JSONObject materialNumber = (JSONObject)materialObj;
            QFilter filter2 = new QFilter(KEY_NUMBER, "=", (Object)materialNumber.getString(KEY_NUMBER));
            DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (String)selectProperties, (QFilter[])new QFilter[]{filter2});
            if (null == material) {
                return;
            }
            DynamicObject baseunitDO = material.getDynamicObject("baseunit");
            DynamicObject auxunitDO = material.getDynamicObject("auxptyunit");
            BigDecimal qty = entryObj.getBigDecimal("qty");
            BigDecimal baseQty = null;
            BigDecimal auxQty = null;
            JSONObject baseQtyJson = null;
            JSONObject auxQtyJson = null;
            if (baseunitDO != null) {
                HashMap<String, String> mapBaseunitDO = new HashMap<String, String>();
                mapBaseunitDO.put("importprop", KEY_NUMBER);
                mapBaseunitDO.put(KEY_NUMBER, baseunitDO.getString(KEY_NUMBER));
                mapBaseunitDO.put("name", baseunitDO.getString("name"));
                baseQtyJson = new JSONObject(mapBaseunitDO);
                baseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unitDo, (BigDecimal)qty, (DynamicObject)baseunitDO);
            }
            if (auxunitDO != null) {
                HashMap<String, String> mapAuxunitDO = new HashMap<String, String>();
                mapAuxunitDO.put("importprop", KEY_NUMBER);
                mapAuxunitDO.put(KEY_NUMBER, auxunitDO.getString(KEY_NUMBER));
                mapAuxunitDO.put("name", auxunitDO.getString("name"));
                auxQtyJson = new JSONObject(mapAuxunitDO);
                String unitConvertDir = material.getString("unitconvertdir");
                boolean isConvert = UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
                auxQty = isConvert && null != baseQty && baseQty.compareTo(BigDecimal.ZERO) > 0 ? BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)baseunitDO, (BigDecimal)baseQty, (DynamicObject)auxunitDO) : entryObj.getBigDecimal("auxptyqty");
            }
            entryObj.put("baseunit", baseQtyJson);
            entryObj.put("baseqty", baseQty);
            entryObj.put("auxptyunit", auxQtyJson);
            entryObj.put("auxptyqty", auxQty);
            entryObj.put("planqty", (Object)qty);
            entryObj.put("planbaseqty", baseQty);
        }
    }

    private static void assignEntryOrgs(Map<String, Object> sourceData) {
        QFilter filter;
        DynamicObject orgDo;
        JSONObject orgObj = (JSONObject)sourceData.get("org");
        JSONObject qualityOrgJson = null;
        JSONObject purOrgJson = null;
        long initOrgId = 0L;
        if (orgObj != null && null != (orgDo = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"masterid,id", (QFilter[])new QFilter[]{filter = new QFilter(KEY_NUMBER, "=", (Object)orgObj.getString(KEY_NUMBER))}))) {
            long purInitOrgId;
            DynamicObject purOrgDo;
            long mftOrgId = orgDo.getLong(KEY_ID);
            initOrgId = OrderQualityOrgService.queryFisqcInitOrgId(mftOrgId, "fisqc", "06");
            DynamicObject qualityOrgDo = BusinessDataServiceHelper.loadSingleFromCache((Object)initOrgId, (String)"bos_org", (String)"number,name");
            if (null != qualityOrgDo) {
                HashMap<String, String> mapObj = new HashMap<String, String>();
                mapObj.put("importprop", KEY_NUMBER);
                mapObj.put(KEY_NUMBER, qualityOrgDo.getString(KEY_NUMBER));
                mapObj.put("name", qualityOrgDo.getString("name"));
                qualityOrgJson = new JSONObject(mapObj);
            }
            if ("om_mftorder".equals(entityId) && null != (purOrgDo = BusinessDataServiceHelper.loadSingleFromCache((Object)(purInitOrgId = OrderQualityOrgService.queryFisqcInitOrgId(mftOrgId, "fispurchase", "02")), (String)"bos_org", (String)"number,name"))) {
                HashMap<String, String> mapObj = new HashMap<String, String>();
                mapObj.put("importprop", KEY_NUMBER);
                mapObj.put(KEY_NUMBER, purOrgDo.getString(KEY_NUMBER));
                mapObj.put("name", purOrgDo.getString("name"));
                purOrgJson = new JSONObject(mapObj);
            }
        }
        JSONArray arrEntrys = (JSONArray)sourceData.get(KEY_TREEENTRYENTITY);
        for (int i = 0; i < arrEntrys.size(); ++i) {
            JSONObject entryObj = arrEntrys.getJSONObject(i);
            if (null == entryObj) continue;
            entryObj.put("qualityorg", qualityOrgJson);
            JSONObject materialObj = (JSONObject)entryObj.get((Object)"material");
            QFilter filter2 = new QFilter(KEY_NUMBER, "=", (Object)materialObj.getString(KEY_NUMBER));
            DynamicObject materialDo = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (String)KEY_ID, (QFilter[])new QFilter[]{filter2});
            Boolean isinspection = null;
            if (null != materialDo) {
                Object pkValue = materialDo.getPkValue();
                isinspection = OrderQualityOrgService.queryMaterialQCIsInspectionInfo(pkValue, initOrgId);
            }
            entryObj.put("isinspection", isinspection);
            Object purorgObj = entryObj.get((Object)"purorg");
            if (!"om_mftorder".equals(entityId) || null != purorgObj) continue;
            entryObj.put("purorg", purOrgJson);
        }
    }

    public static String validateBeforeImport(Map<String, Object> sourceData, String billEntityId) {
        if (OrderImportService.isfromapi(null)) {
            return "";
        }
        if ("om_mftorder".equals(billEntityId)) {
            entityId = "om_mftorder";
            billName = ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355", (String)"OrderImportService_0", (String)"bd-mpdm-business", (Object[])new Object[0]);
        } else {
            entityId = "pom_mftorder";
            billName = ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355", (String)"OrderImportService_1", (String)"bd-mpdm-business", (Object[])new Object[0]);
        }
        logger.info("OrderImportService->validateBeforeImport->01: begin.... ");
        Object orgClassObj = sourceData.get("org");
        if (orgClassObj != null && !(orgClassObj instanceof JSONObject)) {
            logger.info("OrderImportService->validateBeforeImport->02: orgClassObj not equal jsonObject ");
            return "";
        }
        JSONObject orgObj = (JSONObject)sourceData.get("org");
        if (null != orgObj) {
            String orgNumber = orgObj.getString(KEY_NUMBER);
            QFilter orgFilter = new QFilter(KEY_NUMBER, "=", (Object)orgNumber);
            org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)KEY_ID, (QFilter[])new QFilter[]{orgFilter});
        } else {
            org = null;
        }
        logger.info("OrderImportService->validateBeforeImport->03: validedata begin ");
        String errMessage = OrderImportService.validManulVersion(sourceData);
        errMessage = OrderImportService.validateBanedBomAndProcessroute(sourceData, errMessage);
        errMessage = OrderImportService.validateBillStatus(sourceData, errMessage);
        errMessage = OrderImportService.validateBillType(sourceData, errMessage);
        errMessage = OrderImportService.validateTransactiontype(sourceData, errMessage);
        errMessage = OrderImportService.validateEntryInfo(sourceData, errMessage);
        return errMessage;
    }

    private static String validManulVersion(Map<String, Object> sourceData) {
        StringBuilder sbMessage = new StringBuilder();
        JSONArray arrEntrys = (JSONArray)sourceData.get(KEY_TREEENTRYENTITY);
        for (int i = 0; i < arrEntrys.size(); ++i) {
            Object mversionObj;
            JSONObject entryObj = arrEntrys.getJSONObject(i);
            if (entryObj == null || (mversionObj = entryObj.get((Object)"manuversion")) == null) continue;
            JSONObject manuversionObj = (JSONObject)mversionObj;
            String id = manuversionObj.getString(KEY_ID);
            String number = manuversionObj.getString(KEY_NUMBER);
            String importprop = manuversionObj.getString("importprop");
            if (!StringUtils.isNotBlank((CharSequence)number) || !StringUtils.isBlank((CharSequence)id)) continue;
            sbMessage.append(String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u7248\u672c\uff08%1$s\uff09\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u7684\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u3001\u201c\u7269\u6599\u7f16\u7801\u201d\u3001\u201c\u751f\u4ea7\u7248\u672c\u201d\u662f\u5426\u6709\u5bf9\u5e94\u7684\u751f\u4ea7\u7248\u672c\u4fe1\u606f\u3002", (String)"OrderImportService_25", (String)"bd-mpdm-business", (Object[])new Object[0]), importprop));
            break;
        }
        return sbMessage.toString();
    }

    private static String validateBanedBomAndProcessroute(Map<String, Object> sourceData, String sbMessage) {
        StringBuilder errorMsg = new StringBuilder();
        JSONArray arrEntrys = (JSONArray)sourceData.get(KEY_TREEENTRYENTITY);
        int entryMainProNum = 0;
        for (int i = 0; i < arrEntrys.size(); ++i) {
            String processrouteEnable;
            JSONObject processrouteJObj;
            String processrouteNumber;
            QFilter processrouteQFilter;
            DynamicObject processroute;
            Object processrouteObj;
            String bomEnable;
            JSONObject bomJObj;
            String bomNumber;
            QFilter bomQFilter;
            DynamicObject bom;
            Object bomObj;
            JSONObject entryObj = arrEntrys.getJSONObject(i);
            if (null == entryObj) continue;
            String productType = entryObj.getString("producttype");
            Object outputoperation = entryObj.get((Object)"outputoperation");
            if (StringUtils.equals((CharSequence)"C", (CharSequence)productType)) {
                ++entryMainProNum;
                if (null != outputoperation) {
                    errorMsg.append(ResManager.loadKDString((String)"\u5f53\u4ea7\u54c1\u7c7b\u578b\u4e3a\u4e3b\u4ea7\u54c1\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u4ea7\u51fa\u5de5\u5e8f\u3002", (String)"OrderImportService_3", (String)"bd-mpdm-business", (Object[])new Object[0]));
                }
            }
            if (!("A".equals(productType) || "B".equals(productType) || "C".equals(productType))) {
                errorMsg.append(ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u578b\u4ec5\u652f\u6301\u201c\u4e3b\u4ea7\u54c1\u201d\u3001\u201c\u8054\u4ea7\u54c1\u201d\u3001\u201c\u526f\u4ea7\u54c1\u201d\u3002", (String)"OrderImportService_4", (String)"bd-mpdm-business", (Object[])new Object[0]));
            }
            if (null != (bomObj = entryObj.get((Object)"bomid")) && null != (bom = BusinessDataServiceHelper.loadSingleFromCache((String)"pdm_mftbom", (String)"enable", (QFilter[])new QFilter[]{bomQFilter = new QFilter(KEY_NUMBER, "=", (Object)(bomNumber = (bomJObj = (JSONObject)bomObj).getString(KEY_NUMBER)))})) && StringUtils.equals((CharSequence)"0", (CharSequence)(bomEnable = bom.getString("enable")))) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"OrderImportService_26", (String)"bd-mpdm-business", (Object[])new Object[0]), bomNumber));
            }
            if (null == (processrouteObj = entryObj.get((Object)"processroute")) || null == (processroute = BusinessDataServiceHelper.loadSingleFromCache((String)"pdm_route", (String)"enable", (QFilter[])new QFilter[]{processrouteQFilter = new QFilter(KEY_NUMBER, "=", (Object)(processrouteNumber = (processrouteJObj = (JSONObject)processrouteObj).getString(KEY_NUMBER)))})) || !StringUtils.equals((CharSequence)"0", (CharSequence)(processrouteEnable = processroute.getString("enable")))) continue;
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u201c%1$s\u201d\u5df2\u7981\u7528\u3002", (String)"OrderImportService_27", (String)"bd-mpdm-business", (Object[])new Object[0]), processrouteNumber));
        }
        if (entryMainProNum == 0) {
            errorMsg.append(ResManager.loadKDString((String)"\u4e00\u5f20\u5355\u636e\u5206\u5f55\u81f3\u5c11\u9700\u8981\u5bfc\u5165\u4e00\u4e2a\u4e3b\u4ea7\u54c1\u3002", (String)"OrderImportService_7", (String)"bd-mpdm-business", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            sbMessage = sbMessage + errorMsg;
        }
        return sbMessage;
    }

    private static String validateBillStatus(Map<String, Object> sourceData, String sbMessage) {
        String errorInfo = ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bfc\u5165\u6682\u5b58\u72b6\u6001\u7684\u5355\u636e\u3002", (String)"OrderImportService_8", (String)"bd-mpdm-business", (Object[])new Object[0]);
        String billStatus = (String)sourceData.get("billstatus");
        if (null != billStatus && !StringUtils.equals((CharSequence)"A", (CharSequence)billStatus)) {
            sbMessage = sbMessage + errorInfo;
        }
        return sbMessage;
    }

    private static String validateBillType(Map<String, Object> sourceData, String sbMessage) {
        String errorInfo = String.format(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bfc\u5165\u5355\u636e\u7c7b\u578b\u4e3a\u201c%1$s\u201d\u7684\u5355\u636e\u3002", (String)"OrderImportService_28", (String)"bd-mpdm-business", (Object[])new Object[0]), billName);
        boolean flag = false;
        Object billtype = sourceData.get("billtype");
        if (billtype != null) {
            JSONObject billtypeObj = (JSONObject)JSON.toJSON((Object)billtype);
            List<DynamicObject> billTypeLists = OrderCommonService.queryBillType(entityId);
            String billTypeNumber = billtypeObj.getString(KEY_NUMBER);
            for (DynamicObject dynamicObject : billTypeLists) {
                String numberTemp;
                if (null == dynamicObject || !(numberTemp = dynamicObject.getString(KEY_NUMBER)).equals(billTypeNumber)) continue;
                flag = true;
                break;
            }
        }
        if (!flag) {
            sbMessage = sbMessage + errorInfo;
        }
        return sbMessage;
    }

    private static String validateTransactiontype(Map<String, Object> sourceData, String sbMessage) {
        String errorInfo = ResManager.loadKDString((String)"\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185\u3002", (String)"OrderImportService_10", (String)"bd-mpdm-business", (Object[])new Object[0]);
        boolean flag = false;
        Object transactiontype = sourceData.get("transactiontype");
        if (null != transactiontype) {
            Map transactiontypes;
            JSONObject transactiontypeObj = (JSONObject)JSON.toJSON((Object)transactiontype);
            String transactiontypeNumber = transactiontypeObj.getString(KEY_NUMBER);
            String selectPro = "number,name,bomtypes,shutdowncontrol";
            QFilter qf = new QFilter(KEY_NUMBER, "=", (Object)transactiontypeNumber);
            if ("pom_mftorder".equals(entityId)) {
                qf.and(new QFilter("transactiontype.domain", "=", (Object)"3"));
                qf.and(new QFilter("isinnerprocess", "=", (Object)false));
            } else if ("om_mftorder".equals(entityId)) {
                // empty if block
            }
            QFilter transactiontypeFilter = null;
            if (null != org) {
                transactiontypeFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_transactproduct", (Long)Long.parseLong(org.getPkValue().toString()));
            }
            if (null != transactiontypeFilter) {
                qf.and(transactiontypeFilter);
            }
            if (null != (transactiontypes = BusinessDataServiceHelper.loadFromCache((String)"mpdm_transactproduct", (String)selectPro, (QFilter[])qf.toArray())) && transactiontypes.size() > 0) {
                for (Map.Entry item : transactiontypes.entrySet()) {
                    if (null == item.getValue()) continue;
                    OrderImportService.transactiontype = (DynamicObject)item.getValue();
                    flag = true;
                    break;
                }
            } else {
                OrderImportService.transactiontype = null;
            }
        }
        if (!flag) {
            sbMessage = sbMessage + errorInfo;
        }
        return sbMessage;
    }

    private static String validateEntryInfo(Map<String, Object> sourceData, String sbMessage) {
        String errorMsg = "";
        JSONArray arrEntrys = (JSONArray)sourceData.get(KEY_TREEENTRYENTITY);
        List<Long> purchOrgs = null;
        if ("om_mftorder".equals(entityId) && null != org) {
            purchOrgs = OrderQualityOrgService.queryFisqcRangeList(org.getLong(KEY_ID), "fispurchase", "02");
        }
        DynamicObject material = null;
        for (int i = 0; i < arrEntrys.size(); ++i) {
            JSONObject entryObj = arrEntrys.getJSONObject(i);
            if (null == entryObj) continue;
            Map<String, Object> checkMaterialMap = OrderImportService.checkMaterial(entryObj, errorMsg);
            if (null != checkMaterialMap) {
                errorMsg = (String)checkMaterialMap.get("errorMsg");
                material = (DynamicObject)checkMaterialMap.get("material");
            }
            errorMsg = OrderImportService.checkUnitByMaterial(entryObj, errorMsg, material);
            errorMsg = OrderImportService.checkProducedept(sourceData, entryObj, errorMsg);
            errorMsg = OrderImportService.checkProcessroute(sourceData, entryObj, errorMsg);
            errorMsg = OrderImportService.checkBomByMaterial(sourceData, entryObj, errorMsg, material);
            errorMsg = OrderImportService.checkInwardept(sourceData, entryObj, errorMsg);
            errorMsg = OrderImportService.checkWarehouse(sourceData, entryObj, errorMsg);
            errorMsg = OrderImportService.checkLocation(sourceData, entryObj, errorMsg);
            if (!"om_mftorder".equals(entityId)) continue;
            errorMsg = OrderImportService.checkSupplier(sourceData, entryObj, errorMsg, org);
            errorMsg = OrderImportService.checkPurorg(sourceData, entryObj, errorMsg, org, purchOrgs);
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            sbMessage = sbMessage + errorMsg;
        }
        return sbMessage;
    }

    private static Map<String, Object> checkMaterial(JSONObject entryObj, String errorMsg) {
        StringBuilder sb = new StringBuilder();
        DynamicObject material = null;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        JSONObject materialObj = (JSONObject)entryObj.get((Object)"material");
        boolean flag = false;
        if (null != materialObj) {
            QFilter qFilter;
            String materialNumber = materialObj.getString(KEY_NUMBER);
            QFilter materialFilter = new QFilter(KEY_NUMBER, "=", (Object)materialNumber);
            if (null != org && null != (qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)Long.parseLong(org.getPkValue().toString())))) {
                materialFilter.and(qFilter);
            }
            if (null != (material = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (String)"id,baseunit,number,isenablematerialversion", (QFilter[])new QFilter[]{materialFilter}))) {
                DynamicObject mftmaterial;
                QFilter qFilter2;
                QFilter filter = new QFilter("masterid", "=", (Object)material.getLong(KEY_ID));
                String producttype = entryObj.getString("producttype");
                QFilter qFilter1 = new QFilter("ismainproduct", "=", (Object)"C");
                qFilter1 = ManuBillProductTypeEnum.MAIN.getValue().equals(producttype) ? new QFilter("ismainproduct", "=", (Object)"1") : new QFilter("isjointproduct", "=", (Object)"1");
                if (null != transactiontype) {
                    QFilter qfilter2 = new QFilter(SUSPEND, "=", (Object)"0").or(new QFilter(SUSPEND, "=", (Object)"1"));
                    if ("1".equals(transactiontype.get("shutdowncontrol").toString())) {
                        qfilter2 = new QFilter(SUSPEND, "=", (Object)"0").or(new QFilter(SUSPEND, "=", (Object)"1"));
                    } else if ("2".equals(transactiontype.get("shutdowncontrol").toString())) {
                        qfilter2 = new QFilter(SUSPEND, "=", (Object)"1");
                    } else if ("3".equals(transactiontype.get("shutdowncontrol").toString())) {
                        qfilter2 = new QFilter(SUSPEND, "=", (Object)"0");
                    }
                    filter.and(qfilter2);
                }
                filter.and(qFilter1);
                logger.info("orderImport->checkMaterial:" + filter.toString());
                if (null != org && null != (qFilter2 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)Long.parseLong(org.getPkValue().toString())))) {
                    filter.and(qFilter2);
                }
                if (null != (mftmaterial = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialmftinfo", (String)KEY_ID, (QFilter[])new QFilter[]{filter}))) {
                    flag = true;
                }
            }
            if (!flag) {
                sb.append(String.format(ResManager.loadKDString((String)"\u7269\u6599\uff08%1$s\uff09\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185\u3002", (String)"OrderImportService_29", (String)"bd-mpdm-business", (Object[])new Object[0]), materialNumber));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sb)) {
            errorMsg = errorMsg + sb;
        }
        result.put("errorMsg", errorMsg);
        result.put("material", material);
        return result;
    }

    private static String checkUnitByMaterial(JSONObject entryObj, String errorMsg, DynamicObject material) {
        StringBuilder sb = new StringBuilder();
        JSONObject unitObj = (JSONObject)entryObj.get((Object)"unit");
        if (null == unitObj || null == unitObj.get((Object)KEY_NUMBER) || kd.bos.util.StringUtils.isEmpty((String)unitObj.getString(KEY_NUMBER))) {
            sb.append(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"OrderImportService_12", (String)"bd-mpdm-business", (Object[])new Object[0]));
        } else if (null != material) {
            Long buid;
            String unitNumber = unitObj.getString(KEY_NUMBER);
            boolean flag = false;
            DynamicObject baseunitDO = material.getDynamicObject("baseunit");
            Long mid = material.getLong(KEY_ID);
            List fixconunitlist = BaseDataServiceHelper.getAssistMUListResult((Long)mid, (Long)(buid = Long.valueOf(baseunitDO == null ? 0L : baseunitDO.getLong(KEY_ID))), (String)"1", (Boolean)Boolean.FALSE);
            QFilter fixconFilter = new QFilter(KEY_ID, "in", (Object)fixconunitlist);
            Map units = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)KEY_NUMBER, (QFilter[])new QFilter[]{fixconFilter});
            if (null != units) {
                for (Map.Entry entry : units.entrySet()) {
                    String numberInUnit;
                    DynamicObject unit = (DynamicObject)entry.getValue();
                    if (null == unit || !StringUtils.equals((CharSequence)unitNumber, (CharSequence)(numberInUnit = unit.getString(KEY_NUMBER)))) continue;
                    flag = true;
                    break;
                }
            }
            if (!flag) {
                sb.append(String.format(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d[%1$s]\u5728\u7269\u6599[%2$s]\u4e0a\u627e\u4e0d\u5230\u5339\u914d\u5173\u7cfb\u3002", (String)"OrderImportService_13", (String)"bd-mpdm-business", (Object[])new Object[0]), unitNumber, material.getString(KEY_NUMBER)));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sb)) {
            errorMsg = errorMsg + sb;
        }
        return errorMsg;
    }

    private static String checkProducedept(Map<String, Object> sourceData, JSONObject entryObj, String errorMsg) {
        StringBuilder sb = new StringBuilder();
        JSONObject producedeptObj = (JSONObject)entryObj.get((Object)"producedept");
        if (null != producedeptObj && null != producedeptObj.get((Object)KEY_NUMBER) && null != org) {
            String producedeptObjNumber = producedeptObj.getString(KEY_NUMBER);
            if (kd.bos.util.StringUtils.isEmpty((String)producedeptObjNumber)) {
                return errorMsg;
            }
            boolean flag = false;
            long orgId = org.getLong(KEY_ID);
            QFilter producedepFilter = new QFilter("fisadministrative", "=", (Object)"1");
            producedepFilter.and("status", "=", (Object)Character.valueOf('C'));
            producedepFilter.and("enable", "=", (Object)Character.valueOf('1'));
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_workshopsetup", (Long)orgId);
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            Map workshops = BusinessDataServiceHelper.loadFromCache((String)"mpdm_workshopsetup", (String)"workshoporg", (QFilter[])new QFilter[]{qFilter});
            if (null != workshops && !workshops.isEmpty()) {
                logger.info("checkProducedept->workshops:not null entry");
                HashSet<Long> idSet = new HashSet<Long>(workshops.size());
                for (Map.Entry entry : workshops.entrySet()) {
                    DynamicObject workshoporg;
                    DynamicObject workshop = (DynamicObject)entry.getValue();
                    if (null == workshop || null == (workshoporg = workshop.getDynamicObject("workshoporg"))) continue;
                    idSet.add(Long.parseLong(workshoporg.getPkValue().toString()));
                }
                producedepFilter.and(KEY_ID, "in", idSet);
            } else {
                List toOrg = OrgUnitServiceHelper.getAllToOrg((String)"15", (String)"01", (Long)orgId);
                if (!toOrg.isEmpty()) {
                    producedepFilter.and(KEY_ID, "in", (Object)toOrg);
                } else {
                    return errorMsg;
                }
            }
            logger.info("checkProducedept->producedepFilter:" + producedepFilter.toString());
            Map producedeps = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)KEY_NUMBER, (QFilter[])new QFilter[]{producedepFilter});
            if (null == producedeps || producedeps.isEmpty()) {
                return errorMsg;
            }
            if (null != producedeps) {
                logger.info("checkProducedept->producedeps:not null");
                for (Map.Entry entry : producedeps.entrySet()) {
                    String producedepNumber;
                    DynamicObject producedep = (DynamicObject)entry.getValue();
                    if (null == producedep || !StringUtils.equals((CharSequence)producedeptObjNumber, (CharSequence)(producedepNumber = producedep.getString(KEY_NUMBER)))) continue;
                    flag = true;
                    break;
                }
            }
            if (!flag) {
                sb.append(String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u90e8\u95e8\uff08%1$s\uff09\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185\u3002", (String)"OrderImportService_30", (String)"bd-mpdm-business", (Object[])new Object[0]), producedeptObjNumber));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sb)) {
            errorMsg = errorMsg + sb;
        }
        return errorMsg;
    }

    private static String checkProcessroute(Map<String, Object> sourceData, JSONObject entryObj, String errorMsg) {
        StringBuilder sb = new StringBuilder();
        JSONObject orgObj = (JSONObject)sourceData.get("org");
        JSONObject mftmaterialObj = (JSONObject)entryObj.get((Object)"material");
        JSONObject processrouteObj = (JSONObject)entryObj.get((Object)"processroute");
        boolean flag = false;
        if (null != processrouteObj && null != orgObj && null != mftmaterialObj && null != entryObj && "C".equals(entryObj.getString("producttype"))) {
            String orgNumber = orgObj.getString(KEY_NUMBER);
            String mftmaterialNumber = mftmaterialObj.getString(KEY_NUMBER);
            String processrouteNumber = processrouteObj.getString(KEY_NUMBER);
            if (StringUtils.isNotBlank((CharSequence)processrouteNumber) && StringUtils.isNotBlank((CharSequence)orgNumber) && StringUtils.isNotBlank((CharSequence)mftmaterialNumber)) {
                QFilter orgFilter = new QFilter(KEY_NUMBER, "=", (Object)orgNumber);
                DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{orgFilter});
                if (null != org) {
                    QFilter pageFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_route", (Long)Long.parseLong(org.getPkValue().toString()));
                    QFilter bdmaterialFilter = new QFilter(KEY_NUMBER, "=", (Object)mftmaterialNumber);
                    DynamicObject bdmaterial = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (String)KEY_ID, (QFilter[])new QFilter[]{bdmaterialFilter});
                    if (null != bdmaterial) {
                        QFilter mftmaterialFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)Long.parseLong(org.getPkValue().toString()));
                        mftmaterialFilter.and(new QFilter("masterid", "=", bdmaterial.getPkValue()));
                        DynamicObject mftmaterial = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialmftinfo", (QFilter[])new QFilter[]{mftmaterialFilter});
                        if (null != mftmaterial) {
                            Map pdmRoutes;
                            QFilter qfilter1 = OrderCommonService.getProcessRouteFilter(mftmaterial, org);
                            if (null != qfilter1) {
                                pageFilter.and(qfilter1);
                            }
                            if (null != (pdmRoutes = BusinessDataServiceHelper.loadFromCache((String)"pdm_route", (QFilter[])new QFilter[]{pageFilter}))) {
                                for (Map.Entry entry : pdmRoutes.entrySet()) {
                                    String numberInpdmRoute;
                                    DynamicObject pdmRoute = (DynamicObject)entry.getValue();
                                    if (null == pdmRoute || !StringUtils.equals((CharSequence)processrouteNumber, (CharSequence)(numberInpdmRoute = pdmRoute.getString(KEY_NUMBER)))) continue;
                                    flag = true;
                                    break;
                                }
                            }
                        }
                    }
                }
                if (!flag) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\uff08%1$s\uff09\u4e0e\u7269\u6599\uff08%2$s\uff09\u65e0\u5173\u8054\u5173\u7cfb\u3002", (String)"OrderImportService_23", (String)"bd-mpdm-business", (Object[])new Object[0]), processrouteNumber, mftmaterialNumber));
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sb)) {
            errorMsg = errorMsg + sb;
        }
        return errorMsg;
    }

    private static String checkBomByMaterial(Map<String, Object> sourceData, JSONObject entryObj, String errorMsg, DynamicObject material) {
        String bomNumber;
        StringBuilder sb = new StringBuilder();
        JSONObject bomObj = (JSONObject)entryObj.get((Object)"bomid");
        boolean flag = false;
        if (null != material && null != bomObj && null != entryObj && "C".equals(entryObj.getString("producttype")) && StringUtils.isNotBlank((CharSequence)(bomNumber = bomObj.getString(KEY_NUMBER)))) {
            QFilter bomFilter;
            QFilter qfilter = new QFilter("materialid", "=", material.getPkValue());
            if (null != transactiontype) {
                logger.info("checkBomByMaterial->transactiontype null");
                DynamicObjectCollection bomtypes = transactiontype.getDynamicObjectCollection("bomtypes");
                List pkValues = MulBaseDataUtils.getPkValuesByMulData((DynamicObjectCollection)bomtypes);
                if (CollectionUtils.isNotEmpty((Collection)pkValues)) {
                    qfilter.and(new QFilter("type", "in", (Object)pkValues));
                }
            }
            if (null != org && null != (bomFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_mftbom", (Long)Long.parseLong(org.getPkValue().toString())))) {
                qfilter.and(bomFilter);
            }
            logger.info("checkBomByMaterial->qfilter:" + qfilter.toString());
            boolean isenablematerialversion = material.getBoolean("isenablematerialversion");
            Map boms = BusinessDataServiceHelper.loadFromCache((String)"pdm_mftbom", (String)"number,id,type,type.isversion,version,version.effectdate,version.invaliddate", (QFilter[])new QFilter[]{qfilter});
            if (MapUtils.isNotEmpty((Map)boms)) {
                for (Map.Entry entry : boms.entrySet()) {
                    DynamicObject bom = (DynamicObject)entry.getValue();
                    String numberInBom = bom.getString(KEY_NUMBER);
                    if (null != bom && (isenablematerialversion || bom.getDynamicObject("type").getBoolean("isversion"))) {
                        logger.info("checkBomByMaterial->isVersionBOM:" + numberInBom);
                        String expendbomtimeObj = entryObj.getString("expendbomtime");
                        Date expendbomtime = null;
                        if (StringUtils.isNotBlank((CharSequence)expendbomtimeObj)) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            try {
                                expendbomtime = sdf.parse(expendbomtimeObj);
                                if (expendbomtime == null) {
                                    continue;
                                }
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                        }
                        Date effectDate = bom.getDate("version.effectdate");
                        Date invalidDate = bom.getDate("version.invaliddate");
                        if (null == effectDate || null == invalidDate || null != expendbomtime && expendbomtime.after(invalidDate) || null != expendbomtime && expendbomtime.before(effectDate)) {
                            logger.info("checkBomByMaterial->isInvalidVersionBOM:" + numberInBom);
                            continue;
                        }
                    }
                    logger.info("checkBomByMaterial->numberInBom:" + numberInBom);
                    if (!StringUtils.equals((CharSequence)bomNumber, (CharSequence)numberInBom)) continue;
                    logger.info("checkBomByMaterial->bomNumber:" + bomNumber);
                    flag = true;
                    break;
                }
            }
            if (!flag) {
                sb.append(String.format(ResManager.loadKDString((String)"BOM\uff08%1$s\uff09\u4e0e\u7269\u6599\uff08%2$s\uff09\u65e0\u5173\u8054\u5173\u7cfb\u3002", (String)"OrderImportService_16", (String)"bd-mpdm-business", (Object[])new Object[0]), bomNumber, material.getString(KEY_NUMBER)));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sb)) {
            errorMsg = errorMsg + sb;
        }
        return errorMsg;
    }

    private static String checkInwardept(Map<String, Object> sourceData, JSONObject entryObj, String errorMsg) {
        StringBuilder sb = new StringBuilder();
        JSONObject inwardeptObj = (JSONObject)entryObj.get((Object)"inwardept");
        JSONObject orgObj = (JSONObject)sourceData.get("org");
        boolean flag = false;
        if (null != inwardeptObj && null != orgObj) {
            String inwardeptObjNumber = inwardeptObj.getString(KEY_NUMBER);
            String orgNumber = orgObj.getString(KEY_NUMBER);
            if (StringUtils.isNotBlank((CharSequence)inwardeptObjNumber) && StringUtils.isNotBlank((CharSequence)orgNumber)) {
                Map inwardepts;
                QFilter qfilter = new QFilter("fisinventory", "=", (Object)"1");
                qfilter.and("status", "=", (Object)"C");
                qfilter.and("enable", "=", (Object)"1");
                QFilter orgFilter = new QFilter(KEY_NUMBER, "=", (Object)orgNumber);
                DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)KEY_ID, (QFilter[])new QFilter[]{orgFilter});
                if (org != null) {
                    List<Long> inwareOrgFilter = OrderCommonService.getInwareOrgFilter((Long)org.getPkValue());
                    if (!inwareOrgFilter.isEmpty()) {
                        qfilter.and(new QFilter(KEY_ID, "in", inwareOrgFilter));
                    } else {
                        return errorMsg;
                    }
                }
                if (null == (inwardepts = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)KEY_NUMBER, (QFilter[])new QFilter[]{qfilter})) || inwardepts.isEmpty()) {
                    return errorMsg;
                }
                if (null != inwardepts) {
                    for (Map.Entry entry : inwardepts.entrySet()) {
                        String numberInInwardept;
                        DynamicObject inwardept = (DynamicObject)entry.getValue();
                        if (null == inwardept || !StringUtils.equals((CharSequence)inwardeptObjNumber, (CharSequence)(numberInInwardept = inwardept.getString(KEY_NUMBER)))) continue;
                        flag = true;
                        break;
                    }
                }
                if (!flag) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u5165\u5e93\u7ec4\u7ec7\uff08%1$s\uff09\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185\u3002", (String)"OrderImportService_31", (String)"bd-mpdm-business", (Object[])new Object[0]), inwardeptObjNumber));
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sb)) {
            errorMsg = errorMsg + sb;
        }
        return errorMsg;
    }

    private static String checkWarehouse(Map<String, Object> sourceData, JSONObject entryObj, String errorMsg) {
        StringBuilder sb = new StringBuilder();
        JSONObject warehouseObj = (JSONObject)entryObj.get((Object)"warehouse");
        JSONObject inwardeptObj = (JSONObject)sourceData.get("inwardept");
        if (null != warehouseObj && null != inwardeptObj) {
            boolean flag = false;
            String warehouseObjNumber = warehouseObj.getString(KEY_NUMBER);
            String orgNumber = inwardeptObj.getString(KEY_NUMBER);
            if (StringUtils.isNotBlank((CharSequence)warehouseObjNumber) && StringUtils.isNotBlank((CharSequence)orgNumber)) {
                QFilter filter = new QFilter(KEY_NUMBER, "=", (Object)warehouseObjNumber);
                QFilter orgFilter = new QFilter(KEY_NUMBER, "=", (Object)orgNumber);
                DynamicObject inwardept = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)KEY_ID, (QFilter[])new QFilter[]{orgFilter});
                if (null != inwardept) {
                    DynamicObject warehouse;
                    Long[] warehouseids = WarehouseHelper.getAllWarehouseIDs((Long)Long.parseLong(inwardept.getPkValue().toString()));
                    ArrayList<Long> ids = new ArrayList<Long>();
                    for (Long warehouseid : warehouseids) {
                        if (warehouseid == null) continue;
                        ids.add(warehouseid);
                    }
                    if (!ids.isEmpty()) {
                        filter.and(new QFilter(KEY_ID, "in", ids));
                    } else {
                        filter.and(new QFilter(KEY_ID, "=", (Object)Long.valueOf("0")));
                    }
                    QFilter inwardeptFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", (Long)Long.parseLong(inwardept.getPkValue().toString()));
                    if (null != inwardeptFilter) {
                        filter.and(inwardeptFilter);
                    }
                    if (null != (warehouse = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_warehouse", (String)KEY_ID, (QFilter[])new QFilter[]{filter}))) {
                        flag = true;
                    }
                }
                if (!flag) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\uff08%1$s\uff09\u4e0d\u5b58\u5728\u6216\u8005\u4e0e\u5e93\u5b58\u7ec4\u7ec7\uff08%2$s\uff09\u6ca1\u6709\u59d4\u6258\u5173\u7cfb\u3002", (String)"OrderImportService_18", (String)"bd-mpdm-business", (Object[])new Object[0]), warehouseObjNumber, orgNumber));
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sb)) {
            errorMsg = errorMsg + sb;
        }
        return errorMsg;
    }

    private static String checkLocation(Map<String, Object> sourceData, JSONObject entryObj, String errorMsg) {
        StringBuilder sb = new StringBuilder();
        JSONObject warehouseObj = (JSONObject)entryObj.get((Object)"warehouse");
        JSONObject locationObj = (JSONObject)entryObj.get((Object)"location");
        boolean flag = false;
        if (null == warehouseObj && null != locationObj) {
            String locationObjNumber = locationObj.getString(KEY_NUMBER);
            sb.append(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4ed3\u5e93\uff0c\u518d\u5f55\u5165\u4ed3\u4f4d\uff08%1$s\uff09\u3002", (String)"OrderImportService_24", (String)"bd-mpdm-business", (Object[])new Object[0]), locationObjNumber));
        } else if (null != warehouseObj && null != locationObj) {
            String warehouseObjNumber = warehouseObj.getString(KEY_NUMBER);
            String locationObjNumber = locationObj.getString(KEY_NUMBER);
            if (StringUtils.isNotBlank((CharSequence)warehouseObjNumber) && StringUtils.isNotBlank((CharSequence)locationObjNumber)) {
                QFilter warehouseFilter = new QFilter(KEY_NUMBER, "=", (Object)warehouseObjNumber);
                DynamicObject warehouse = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_warehouse", (QFilter[])new QFilter[]{warehouseFilter});
                if (null != warehouse) {
                    boolean isopenlocation = warehouse.getBoolean("isopenlocation");
                    if (!isopenlocation) {
                        sb.append(String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\uff08%1$s\uff09\u672a\u542f\u7528\u4ed3\u4f4d\uff0c\u4e0d\u5141\u8bb8\u586b\u5199\u4ed3\u4f4d\u3002", (String)"OrderImportService_32", (String)"bd-mpdm-business", (Object[])new Object[0]), warehouseObjNumber, locationObjNumber));
                    } else {
                        DynamicObjectCollection col = warehouse.getDynamicObjectCollection("entryentity");
                        for (int i = 0; i < col.size(); ++i) {
                            String locationNumber;
                            DynamicObject location;
                            DynamicObject obj = (DynamicObject)col.get(i);
                            if (null == obj || null == (location = (DynamicObject)obj.get("location")) || !StringUtils.equals((CharSequence)locationObjNumber, (CharSequence)(locationNumber = location.getString(KEY_NUMBER)))) continue;
                            flag = true;
                            break;
                        }
                    }
                }
                if (!flag) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\uff08%1$s\uff09\u4e0e\u4ed3\u4f4d\uff08%2$s\uff09\u65e0\u5173\u8054\u5173\u7cfb\u3002", (String)"OrderImportService_20", (String)"bd-mpdm-business", (Object[])new Object[0]), warehouseObjNumber, locationObjNumber));
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sb)) {
            errorMsg = errorMsg + sb;
        }
        return errorMsg;
    }

    private static String checkSupplier(Map<String, Object> sourceData, JSONObject entryObj, String errorMsg, DynamicObject org) {
        StringBuilder sb = new StringBuilder();
        JSONObject supplierObj = (JSONObject)entryObj.get((Object)"supplier");
        if (null != supplierObj && null != org) {
            boolean flag = false;
            String supplierObjNumber = supplierObj.getString(KEY_NUMBER);
            if (StringUtils.isNotBlank((CharSequence)supplierObjNumber)) {
                DynamicObject supplier;
                QFilter supplierFilter = new QFilter(KEY_NUMBER, "=", (Object)supplierObjNumber);
                QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)Long.parseLong(org.getPkValue().toString()));
                if (null != filter) {
                    supplierFilter.and(filter);
                }
                if (null != (supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (QFilter[])new QFilter[]{supplierFilter}))) {
                    flag = true;
                }
                if (!flag) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u59d4\u5916\u52a0\u5de5\u5546\uff08%1$s\uff09\u4e0d\u5728\u9009\u62e9\u8303\u56f4\u5185\u3002", (String)"OrderImportService_33", (String)"bd-mpdm-business", (Object[])new Object[0]), supplierObjNumber));
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sb)) {
            errorMsg = errorMsg + sb;
        }
        return errorMsg;
    }

    private static String checkPurorg(Map<String, Object> sourceData, JSONObject entryObj, String errorMsg, DynamicObject org, List<Long> purchOrgs) {
        StringBuilder sb = new StringBuilder();
        JSONObject purorgObj = (JSONObject)entryObj.get((Object)"purorg");
        if (null != purorgObj && null != org) {
            boolean flag = false;
            String purorgObjNumber = purorgObj.getString(KEY_NUMBER);
            if (StringUtils.isNotBlank((CharSequence)purorgObjNumber)) {
                long purorgId;
                QFilter purorgFilter = new QFilter(KEY_NUMBER, "=", (Object)purorgObjNumber);
                DynamicObject purorg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)KEY_ID, (QFilter[])new QFilter[]{purorgFilter});
                if (null != purorg && null != purchOrgs && purchOrgs.size() > 0 && purchOrgs.contains(purorgId = purorg.getLong(KEY_ID))) {
                    flag = true;
                }
                if (!flag) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\uff08%1$s\uff09\u4e0d\u5728\u9009\u62e9\u8303\u56f4\u5185\u3002", (String)"OrderImportService_34", (String)"bd-mpdm-business", (Object[])new Object[0]), purorgObjNumber));
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sb)) {
            errorMsg = errorMsg + sb;
        }
        return errorMsg;
    }

    private static boolean isfromapi(Map<String, Object> option) {
        return option != null && option.isEmpty() || RequestContext.get().getClient().equals("api");
    }
}

