/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.mftorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.operate.botp.Push;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OrderMergeHelper {
    public static ConvertOperationResult pushTo(IFormView formView, List<ListSelectedRow> selectedRows, String ruleId, String srcEntityNumber, String targetEntityNumber, PushArgs pushArgs) {
        pushArgs.setSourceEntityNumber(srcEntityNumber);
        pushArgs.setTargetEntityNumber(targetEntityNumber);
        pushArgs.setBuildConvReport(true);
        pushArgs.setHasRight(false);
        if (StringUtils.isNotBlank((CharSequence)ruleId)) {
            pushArgs.setRuleId(ruleId);
        }
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (formView != null) {
            if (!pushResult.isSuccess() || pushResult.getCachePageIds().size() + pushResult.getTargetBillIds().size() == 0) {
                Push.showReport((IFormView)formView, (AbstractConvertServiceArgs)pushArgs, (ConvertOperationResult)pushResult);
            } else if (pushResult.getCachePageIds().size() + pushResult.getTargetBillIds().size() == 1) {
                Push.showTargetBill((IFormView)formView, (PushArgs)pushArgs, (ConvertOperationResult)pushResult, (boolean)false);
            } else {
                Push.showMultiTargetBills((IFormView)formView, (PushArgs)pushArgs, (ConvertOperationResult)pushResult, (boolean)false);
            }
        }
        return pushResult;
    }

    public static String getOperationResultErrorInfos(OperationResult operationResult) {
        if (operationResult.isSuccess()) {
            return "";
        }
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        int size = errorInfos.size() + operationResult.getSuccessPkIds().size();
        if (size > 1) {
            StringBuilder stringBuilder = new StringBuilder();
            int len = errorInfos.size();
            for (int i = 0; i < 5 && i < len; ++i) {
                stringBuilder.append(((IOperateInfo)errorInfos.get(i)).getMessage());
                if (i >= errorInfos.size() - 1) continue;
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }
        if (!errorInfos.isEmpty()) {
            OperateErrorInfo errorInfo = (OperateErrorInfo)errorInfos.get(0);
            String msg = errorInfo.getMessage() == null ? "" : errorInfo.getMessage();
            return msg;
        }
        String msg = operationResult.getMessage() == null ? "" : operationResult.getMessage();
        return msg;
    }

    public static void callBillOperation(String entityNumber, Set<Object> billIds, String operation) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("strictvalidation", String.valueOf(false));
        OperationResult deleteResult = OperationServiceHelper.executeOperate((String)operation, (String)entityNumber, (Object[])billIds.toArray(), (OperateOption)option);
        if (!deleteResult.isSuccess()) {
            String operationResultErrorInfos = OrderMergeHelper.getOperationResultErrorInfos(deleteResult);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u5355\u636e\u64cd\u4f5c\u5931\u8d25\uff1a%1$s", (String)"OrderMergeHelper_0", (String)"bd-mpdm-business", (Object[])new Object[0]), operationResultErrorInfos));
        }
    }

    public static String getAllEntryFields(String entityKey, String entryEntityKey) {
        StringBuilder sb = new StringBuilder("id");
        EntityType subEntryType = OrderMergeHelper.getEntityType(entityKey, entryEntityKey);
        Set keySet = subEntryType.getFields().keySet();
        keySet.remove("isGroupNode");
        for (String entryField : keySet) {
            sb.append(',');
            sb.append(entryEntityKey);
            sb.append('.');
            sb.append(entryField);
        }
        return sb.toString();
    }

    public static EntityType getEntityType(String entityKey, String entryEntityKey) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityKey);
        EntityType subEntryType = (EntityType)mainType.getAllEntities().get(entryEntityKey);
        return subEntryType;
    }

    public static DynamicObject[] getMftOrderDataMap(Set<Long> ids, String entityid) {
        DynamicObject[] result = null;
        if (!ids.isEmpty()) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityid);
            StringBuilder selectFields = new StringBuilder("id,billno,billstatus,billtype,biztype,transactiontype.id,transactiontype.isinnerprocess,transactiontype.isprocedure,org.id,");
            selectFields.append("treeentryentity,treeentryentity.id,treeentryentity.seq,treeentryentity.planstatus,treeentryentity.taskstatus,treeentryentity.bizstatus,treeentryentity.producttype");
            result = BusinessDataServiceHelper.load((String)entityType.getName(), (String)selectFields.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> queryMergeOrderOut(Set<Long> orderIds) {
        HashSet<Long> result = new HashSet<Long>(16);
        if (orderIds == null || orderIds.size() < 1) {
            return result;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select forderno,forderid from t_pom_mgsrcentry where", new Object[0]);
        sql.appendIn("forderid", orderIds.toArray());
        try (DataSet dataSet = null;){
            dataSet = DB.queryDataSet((String)OrderMergeHelper.class.getName(), (DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long orderEntryId = row.getLong("forderid");
                result.add(orderEntryId);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> queryMergeOrderOutExcept(Set<Long> orderIds, long mergeid) {
        HashSet<Long> result = new HashSet<Long>(16);
        if (orderIds == null || orderIds.size() < 1) {
            return result;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select distinct b.forderno,b.forderid from t_pom_ordermerge a ", new Object[0]);
        sql.append("inner join t_pom_mgsrcentry b on b.fid = a.fid ", new Object[0]);
        sql.append("where", new Object[0]);
        sql.append("a.fid != ? ", new Object[]{mergeid});
        sql.appendIn("and forderid", orderIds.toArray());
        try (DataSet dataSet = null;){
            dataSet = DB.queryDataSet((String)OrderMergeHelper.class.getName(), (DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long orderEntryId = row.getLong("forderid");
                result.add(orderEntryId);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> queryMergeOrder(Set<String> mergeOrderNos) {
        HashSet<String> billnos = new HashSet<String>(16);
        if (mergeOrderNos == null || mergeOrderNos.size() < 1) {
            return billnos;
        }
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)OrderMergeHelper.class.getName(), (String)"pom_ordermerge", (String)"billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", mergeOrderNos)}, null);
            for (Row row : dataSet) {
                Object billnoObj = row.get("billno");
                if (!StringUtils.isNotBlank((Object)billnoObj)) continue;
                billnos.add(billnoObj.toString());
            }
        }
        return billnos;
    }

    public static Map<Long, List<DynamicObject>> queryTechMap(Set<Long> orderIds) {
        DynamicObject[] count;
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>(orderIds.size());
        QFilter qfilter = new QFilter("manufactureorderid", "in", OrderMergeHelper.longIdsConvertToStr(orderIds));
        for (DynamicObject dynamicObject : count = BusinessDataServiceHelper.load((String)"sfc_manftech", (String)"id,manufactureorderid,oprentryentity,oprentryentity.oprstatus", (QFilter[])new QFilter[]{qfilter})) {
            long manufactureorderid = Long.parseLong(dynamicObject.getString("manufactureorderid"));
            List matechnics = result.computeIfAbsent(manufactureorderid, k -> new ArrayList(10));
            matechnics.add(dynamicObject);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> queryStockChange(Set<Long> orderIds) {
        HashSet<Long> result = new HashSet<Long>(orderIds.size());
        QFilter filter = new QFilter("orderid", "in", orderIds.stream().map(k -> String.valueOf(k)).collect(Collectors.toSet()));
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)"C");
        try (DataSet ds = null;){
            ds = QueryServiceHelper.queryDataSet((String)OrderMergeHelper.class.getName(), (String)"pom_xmftstock", (String)"id,orderid", (QFilter[])new QFilter[]{filter, statusFilter}, null);
            for (Row row : ds) {
                String orderid = row.get("orderid") == null ? "0" : row.get("orderid").toString();
                result.add(Long.parseLong(orderid));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> queryOrderOut(Set<Long> orderIds) {
        HashSet<Long> result = new HashSet<Long>(orderIds.size());
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter filter = new QFilter("billentry.manubillid", "in", orderIds);
        try (DataSet ds = null;){
            ds = QueryServiceHelper.queryDataSet((String)OrderMergeHelper.class.getName(), (String)"im_mdc_mftproorder", (String)"id,billentry.manubillid manubillid", (QFilter[])new QFilter[]{statusFilter, filter}, null);
            while (ds.hasNext()) {
                Row row = ds.next();
                Long orderEntryId = row.getLong("manubillid");
                result.add(orderEntryId);
            }
        }
        return result;
    }

    public static Set<String> longIdsConvertToStr(Set<Long> orderIds) {
        HashSet<String> result = new HashSet<String>(16);
        if (orderIds == null || orderIds.isEmpty()) {
            return result;
        }
        for (Long entryId : orderIds) {
            if (null == entryId) continue;
            result.add(entryId.toString());
        }
        return result;
    }

    public static void updateStatusByMainProduct(DynamicObjectCollection entryCol, String entityentryid, int status, boolean flag, boolean bookDateEqualsBizDate, Date bookDate) {
        Date now = new Date();
        block3: for (int j = 0; j < entryCol.size(); ++j) {
            DynamicObject entry = (DynamicObject)entryCol.get(j);
            if (!entry.get("pid").toString().equals(entityentryid)) continue;
            switch (status) {
                case 5: {
                    if (flag) {
                        entry.set("bizstatus", (Object)"C");
                        entry.set("closetime", (Object)now);
                        if (null == bookDate) continue block3;
                        entry.set("closebookdate", (Object)(bookDate != null ? DateUtils.getShortDate((Date)bookDate) : null));
                        continue block3;
                    }
                    entry.set("bizstatus", (Object)"A");
                    entry.set("closetime", null);
                    if (!bookDateEqualsBizDate) continue block3;
                    entry.set("closebookdate", null);
                    continue block3;
                }
            }
        }
    }

    public static void clearStockWipqty(Long orderEntryid, String orderEntity) {
        DynamicObjectCollection stockEntryDym;
        DynamicObject stockDym;
        QFilter filter2 = new QFilter("orderentryid", "=", (Object)orderEntryid);
        String stockEntityName = "pom_mftstock";
        if (StringUtils.equals((CharSequence)"om_mftorder", (CharSequence)orderEntity)) {
            stockEntityName = "om_mftstock";
        }
        if ((stockDym = BusinessDataServiceHelper.loadSingle((String)stockEntityName, (String)"stockentry,stockentry.iscannegative,stockentry.wipqty,stockentry.actissueqty,stockentry.feedingqty,stockentry.rejectedqty,stockentry.useqty", (QFilter[])new QFilter[]{filter2})) != null && (stockEntryDym = stockDym.getDynamicObjectCollection("stockentry")) != null) {
            for (int i = 0; i < stockEntryDym.size(); ++i) {
                DynamicObject stockEntry = (DynamicObject)stockEntryDym.get(i);
                BigDecimal actissueQty = stockEntry.getBigDecimal("actissueqty");
                BigDecimal feedingQty = stockEntry.getBigDecimal("feedingqty");
                BigDecimal rejectedQty = stockEntry.getBigDecimal("rejectedqty");
                stockEntry.set("wipqty", (Object)0);
                if (stockEntry.getBoolean("iscannegative")) {
                    stockEntry.set("useqty", (Object)0);
                    continue;
                }
                stockEntry.set("useqty", (Object)actissueQty.add(feedingQty).subtract(rejectedQty));
            }
            SaveServiceHelper.update((DynamicObject)stockDym);
        }
    }

    public static DynamicObject[] queryStocks(Map<Long, String> orderids) {
        if (orderids == null || orderids.size() < 1) {
            return null;
        }
        StringBuilder selectProperties = new StringBuilder(500);
        selectProperties.append("id,billno,org.id,billtype,billstatus,transactiontypeid.id,productid.id,configuredcode.id,tracknumber.id,mftdeptorgid.id,");
        selectProperties.append("billauxunit.id,auxproperty.id,bomid.id,processroute.id,orderentryid.workcenter.id,");
        selectProperties.append("stockentry.id,stockentry.seq,pid,materialid.id,entryconfiguredcode.id,bomreversion.id,batchno,qtytype,useratio,");
        selectProperties.append("rework,qtynumerator,qtydenominator,wastagerateformula,fixscrap,");
        selectProperties.append("childauxpropertyid.id,supplymode,supplierid.id,supplyorgid.id,warehouseid.id,location.id,");
        selectProperties.append("isstockallot,outorgunitid.id,outwarehouseid.id,outlocation.id,");
        selectProperties.append("issuemode,isbulkmaterial,isbackflush,backflushtime,iskeypart,overissuecontrl,issinhighlimit,");
        selectProperties.append("issinlowlimit,leadtime,demanddate,oprno,processseq,");
        selectProperties.append("replaceplan.id,priority,ismainreplace,");
        selectProperties.append("oprno,processseq");
        QFilter qFilter = new QFilter("orderid", "in", orderids.values());
        qFilter.and("orderentryid", "in", orderids.keySet());
        DynamicObject[] stocks = BusinessDataServiceHelper.load((String)"pom_mftstock", (String)selectProperties.toString(), (QFilter[])qFilter.toArray());
        return stocks;
    }

    public static DynamicObject[] queryManuftech(Map<Long, String> orderids) {
        if (orderids == null || orderids.size() < 1) {
            return null;
        }
        StringBuilder selectProperties = new StringBuilder(500);
        selectProperties.append("id,billno,org.id,billtype,manufactureorderid,material.id,configuredcode.id,tracknumber.id,plantype,billstatus,processroute.id,");
        selectProperties.append("transactiontype.id,bomversion,baseunit.id,");
        selectProperties.append("proentryentity.id,proentryentity.seq,processseq,processseqname,processseqtype,processreference,processrelation,processplanbegintime,");
        selectProperties.append("processplanendtime,processoutput,processoutputdesc,processinput,processinputdesc,processplanouttime,processplanintime,");
        selectProperties.append("oprentryentity.id,oprentryentity.seq,oprparent,oprno,oprorg.id,oprworkcenter.id,oprworkshop.id,oproperation.id,oprdescription,oprctrlstrategy.id,");
        selectProperties.append("machiningtype,workstation.id,inspectiontype,oprunit.id,oprstatus,oprsourcetype,collaborative,oprinvalid,firstinspection,storagepoint,");
        selectProperties.append("upperratio,floorratio,purchaseorg.id,purchasegroup.id,purchaser.id,supplier.id");
        selectProperties.append("actsubentryentity.id,actsubentryentity.seq,actactivity.id,actresources.id,actunit.id,actqty,actstandardformula.id,actstandardformula1.id,actplanbegintime,actplanfinishtime");
        QFilter qFilter = new QFilter("manufactureorderid", "in", orderids.values());
        qFilter.and("mftentryseq", "in", orderids.keySet());
        DynamicObject[] manuftechs = BusinessDataServiceHelper.load((String)"sfc_manftech", (String)selectProperties.toString(), (QFilter[])qFilter.toArray());
        return manuftechs;
    }
}

