/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.mftorder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrderQualityOrgService {
    private static final Log logger = LogFactory.getLog(OrderQualityOrgService.class);

    public static long queryFisqcInitOrgId(long mftOrgId, String orgRole, String orgViewType) {
        long initOrgId = 0L;
        if (0L == mftOrgId) {
            return initOrgId;
        }
        if (OrderQualityOrgService.checkOrgWithFisqc(mftOrgId, orgRole)) {
            initOrgId = mftOrgId;
            logger.info("initOrgId:mftOrgId");
        } else {
            List fromOrgs = OrgUnitServiceHelper.getAllToOrg((String)"", (String)orgViewType, (Long)mftOrgId, (boolean)true);
            if (fromOrgs.size() > 0) {
                initOrgId = (Long)fromOrgs.get(0);
                logger.info("initOrgId:fromOrgs.get(0)");
            } else {
                List orgIds = OrgUnitServiceHelper.getAllOrgByViewNumber((String)orgViewType, (boolean)false);
                if (orgIds.size() > 0) {
                    initOrgId = (Long)orgIds.get(0);
                    logger.info("initOrgId:orgIds.get(0)");
                }
            }
        }
        return initOrgId;
    }

    public static boolean checkOrgWithFisqc(Long orgId, String orgRole) {
        boolean result = false;
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)orgRole);
        if (null != org) {
            result = org.getBoolean(orgRole);
        }
        return result;
    }

    public static List<Long> queryFisqcRangeList(Long mftOrgId, String orgRole, String orgViewType) {
        ArrayList<Long> rangeList = new ArrayList<Long>(10);
        if (null == mftOrgId) {
            return rangeList;
        }
        List fromOrgs = OrgUnitServiceHelper.getAllToOrg((String)"", (String)orgViewType, (Long)mftOrgId, (boolean)true);
        if (OrderQualityOrgService.checkOrgWithFisqc(mftOrgId, orgRole)) {
            rangeList.add(mftOrgId);
            rangeList.addAll(fromOrgs);
        } else if (fromOrgs.size() > 0) {
            rangeList.addAll(fromOrgs);
        } else {
            rangeList = null;
        }
        return rangeList;
    }

    public static boolean queryMaterialQCIsInspectionInfo(Object bdmaterialPkValue, long orgID) {
        boolean result = false;
        if (bdmaterialPkValue == null || 0L == orgID) {
            logger.info("mftmaterial and orgID is null");
            return result;
        }
        logger.info("pkvalue" + bdmaterialPkValue);
        QFilter qFilter = new QFilter("masterid", "=", bdmaterialPkValue);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_inspect_cfg", (Long)orgID));
        DynamicObject qcmaterail = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_inspect_cfg", (String)"id,finishflg", (QFilter[])qFilter.toArray());
        if (qcmaterail != null) {
            boolean finishflg;
            result = finishflg = qcmaterail.getBoolean("finishflg");
        } else {
            logger.info("qcmaterial is null");
        }
        return result;
    }

    public static boolean getMaterialQCInfo(DynamicObject mftmaterial, long orgID) {
        boolean isinspection = false;
        if (null != mftmaterial) {
            DynamicObject bdmaterial = mftmaterial.getDynamicObject("masterid");
            Object pkValue = bdmaterial.getPkValue();
            isinspection = OrderQualityOrgService.queryMaterialQCIsInspectionInfo(pkValue, orgID);
        }
        return isinspection;
    }

    public static Set<String> queryMaterialQCIsTrueInfo(Set<Object> materialIDSet, Long orgID) {
        if (materialIDSet == null || materialIDSet.size() < 1 || orgID == null || orgID == 0L) {
            return null;
        }
        QFilter qFilter = new QFilter("masterid", "in", materialIDSet);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_inspect_cfg", (Long)orgID));
        Map dyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_inspect_cfg", (String)"id,finishflg,masterid", (QFilter[])qFilter.toArray());
        if (dyMap == null) {
            return null;
        }
        HashSet<String> returnMaterialIDSet = new HashSet<String>(10);
        for (Map.Entry entry : dyMap.entrySet()) {
            DynamicObject inspectObj = (DynamicObject)entry.getValue();
            if (!inspectObj.getBoolean("finishflg")) continue;
            returnMaterialIDSet.add(inspectObj.getDynamicObject("masterid").getPkValue() + "_" + orgID);
        }
        return returnMaterialIDSet;
    }
}

