/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.mftorder;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.mftorder.MyTaskSplitOrder;
import kd.bd.mpdm.common.mftorder.enums.billIdentity.MftManftechIdentityEnum;
import kd.bd.mpdm.common.mftorder.utils.ManuFactureTraceUtils;
import kd.bd.mpdm.common.query.helper.WorkcenterQueryHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OrderSpliteService {
    private static Log logger = LogFactory.getLog(OrderSpliteService.class);

    public static FormShowParameter splitOrderShowForm(String caption, IFormPlugin plugin, String action) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pom_ordersplit");
        showParameter.setCaption(caption);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return showParameter;
    }

    public static boolean isStop(String pageCacheOption) {
        PageCache pageCache = new PageCache(pageCacheOption);
        String startProgress = pageCache.get("opProgressStop");
        return "1".equals(startProgress);
    }

    public static String getBillAllPropers(String entityKey, String ... entryEntityKey) {
        String result = "";
        if (StringUtils.isBlank((CharSequence)entityKey) || entryEntityKey.length == 0) {
            return result;
        }
        DynamicObject billDyn = ORM.create().newDynamicObject(entityKey);
        ArrayList<String> proNameList = new ArrayList<String>(10);
        DataEntityPropertyCollection properties = billDyn.getDataEntityType().getProperties();
        for (IDataEntityProperty pro : properties) {
            String propName;
            if (pro instanceof MuliLangTextProp || (propName = pro.getName()).endsWith("_id")) continue;
            proNameList.add(propName);
        }
        for (String entryEntity : entryEntityKey) {
            if (!StringUtils.isNotBlank((CharSequence)entryEntity)) continue;
            DynamicObjectCollection entryDynCol = billDyn.getDynamicObjectCollection(entryEntity);
            DataEntityPropertyCollection entryProperties = entryDynCol.getDynamicObjectType().getProperties();
            for (IDataEntityProperty pro : entryProperties) {
                String propName;
                if (pro instanceof MuliLangTextProp || (propName = pro.getName()).endsWith("_id")) continue;
                proNameList.add("treeentryentity." + propName);
            }
        }
        if (proNameList.size() > 0) {
            for (String entryEntity : entryEntityKey) {
                proNameList.add(entryEntity);
            }
            result = Joiner.on((String)",").join(proNameList);
        }
        return result;
    }

    public static BigDecimal calEstscrapqty(DynamicObject mftOrderEntry, DynamicObject org) {
        BigDecimal estscrapqty = BigDecimal.ZERO;
        if (null != mftOrderEntry) {
            BigDecimal yield = mftOrderEntry.getBigDecimal("yieldrate");
            BigDecimal qty = mftOrderEntry.getBigDecimal("qty");
            DynamicObject bom = mftOrderEntry.getDynamicObject("bomid");
            if (BigDecimal.ZERO.compareTo(yield) < 0) {
                estscrapqty = qty.multiply(BigDecimal.valueOf(1L).subtract(yield));
            } else if (null == bom) {
                DynamicObject planinfo = OrderSpliteService.getMaterialPlanInfo(mftOrderEntry, org);
                if (planinfo != null) {
                    BigDecimal yieldrate = planinfo.getBigDecimal("yield");
                    estscrapqty = qty.multiply(BigDecimal.valueOf(1L).subtract(new BigDecimal(yieldrate.toString())));
                }
            } else {
                BigDecimal yieldrate = bom.getBigDecimal("yieldrate");
                estscrapqty = qty.multiply(BigDecimal.valueOf(1L).subtract(yieldrate));
            }
        }
        return estscrapqty;
    }

    private static DynamicObject getMaterialPlanInfo(DynamicObject mftOrderEntry, DynamicObject org) {
        DynamicObject mftMaterial = mftOrderEntry.getDynamicObject("material");
        if (mftMaterial != null) {
            DynamicObject bdmaterial = mftMaterial.getDynamicObject("masterid");
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_materialplan", (Long)org.getLong("id"));
            qFilter.and(new QFilter("masterid", "=", (Object)bdmaterial.getLong("id")));
            DynamicObject planInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_materialplan", (String)"yield,leadtimetype,fixedleadtime,changeleadtime,preprocessingtime,postprocessingtime,changebatch", (QFilter[])new QFilter[]{qFilter});
            if (planInfo != null) {
                return planInfo;
            }
        }
        return null;
    }

    public static List<DynamicObject> pushBills(List<DynamicObject> mftorderBillForPkList, Set<Long> srcEntryIdInSplitEntrys, Map<DynamicObject, String> res) {
        return OrderSpliteService.pushBills(mftorderBillForPkList, srcEntryIdInSplitEntrys, "pom_mftorder", "1328292396806731776");
    }

    public static List<DynamicObject> pushBills(List<DynamicObject> mftorderBillForPkList, Set<Long> srcEntryIdInSplitEntrys, String sourceEntity, String ruleId) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(sourceEntity);
        pushArgs.setTargetEntityNumber("pom_mftorder");
        pushArgs.setHasRight(false);
        pushArgs.setRuleId(ruleId);
        pushArgs.setBuildConvReport(true);
        List<DynamicObject> targetBillObjs = OrderSpliteService.doPush(pushArgs, "pom_mftorder", mftorderBillForPkList, srcEntryIdInSplitEntrys);
        return targetBillObjs;
    }

    public static List<DynamicObject> pushOmBills(List<DynamicObject> mftorderBillForPkList, Set<Long> srcEntryIdInSplitEntrys, Map<DynamicObject, String> res) {
        return OrderSpliteService.pushOmBills(mftorderBillForPkList, srcEntryIdInSplitEntrys, "pom_mftorder", "1622374736220747776");
    }

    public static List<DynamicObject> pushOmBills(List<DynamicObject> mftorderBillForPkList, Set<Long> srcEntryIdInSplitEntrys, String sourceEntity, String ruleId) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(sourceEntity);
        pushArgs.setTargetEntityNumber("om_mftorder");
        pushArgs.setHasRight(false);
        pushArgs.setRuleId(ruleId);
        pushArgs.setBuildConvReport(true);
        List<DynamicObject> targetBillObjs = OrderSpliteService.doPush(pushArgs, "om_mftorder", mftorderBillForPkList, srcEntryIdInSplitEntrys);
        return targetBillObjs;
    }

    private static List<DynamicObject> doPush(PushArgs pushArgs, String entityKey, List<DynamicObject> mftorderBillForPkList, Set<Long> srcEntryIdInSplitEntrys) {
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(10);
        for (DynamicObject mftorderBill : mftorderBillForPkList) {
            if (null == mftorderBill) continue;
            DynamicObjectCollection entrys = mftorderBill.getDynamicObjectCollection("treeentryentity");
            Iterator iterator = entrys.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                long entryId = entry.getLong("id");
                if (!srcEntryIdInSplitEntrys.contains(entryId)) continue;
                List<Long> entryIds = OrderSpliteService.matchOrderEntryIdsInOrderBill(entryId, mftorderBill);
                for (Long entryIdTem : entryIds) {
                    ListSelectedRow srcBill = new ListSelectedRow(mftorderBill.getPkValue());
                    srcBill.setEntryEntityKey("treeentryentity");
                    srcBill.setEntryPrimaryKeyValue((Object)entryIdTem);
                    needPushRows.add(srcBill);
                }
            }
        }
        if (needPushRows.isEmpty()) {
            logger.info("\u5bf9\u5e94\u7684\u751f\u4ea7\u5de5\u5355\u6ca1\u6709\u9700\u8981\u4e0b\u63a8\u7684\u6570\u636e\u3002");
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        StringBuilder errMessage = new StringBuilder().append(pushResult.getMessage());
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            errMessage.append(billReport.getFailMessage());
        }
        if (null != errMessage && !"null".equals(errMessage.toString()) && !"".equals(errMessage.toString())) {
            logger.info("\u4e0b\u63a8\u5931\u8d25:" + errMessage);
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)entityKey);
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        return targetBillObjs;
    }

    public static List<Long> matchOrderEntryIdsInOrderBill(Long orderEntryId, DynamicObject orderBill) {
        ArrayList<Long> orderEntryIds = new ArrayList<Long>(10);
        if (null != orderBill && 0L != orderEntryId) {
            DynamicObjectCollection orderBillEntrys = orderBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : orderBillEntrys) {
                if (null == entry) continue;
                Long entryId = entry.getLong("id");
                Long entryPId = entry.getLong("pid");
                if (!orderEntryId.equals(entryId) && !orderEntryId.equals(entryPId)) continue;
                orderEntryIds.add(entryId);
            }
        }
        return orderEntryIds;
    }

    public static void viewSplitOrder(List<Object> entryIdList, List<Long> entryOrgValues, IFormView view) {
        if (CollectionUtils.isNotEmpty(entryIdList)) {
            String keyEntity = "pom_mftorder";
            ArrayList<QFilter> qfilterList = new ArrayList<QFilter>();
            QFilter qfilter = new QFilter("treeentryentity.srcsplitbillseq", "in", entryIdList);
            qfilterList.add(qfilter);
            Map splitOrderMap = BusinessDataServiceHelper.loadFromCache((String)keyEntity, (String)"id", (QFilter[])qfilterList.toArray(new QFilter[qfilterList.size()]));
            if (null == splitOrderMap || splitOrderMap.size() == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u62c6\u5206\u751f\u6210\u7684\u751f\u4ea7\u5de5\u5355\u3002", (String)"OrderSpliteService_0", (String)"bd-mpdm-business", (Object[])new Object[0]));
                return;
            }
            ArrayList<Long> splitOrderIds = new ArrayList<Long>(10);
            for (Map.Entry objectDynamicObjectEntry : splitOrderMap.entrySet()) {
                splitOrderIds.add(((DynamicObject)objectDynamicObjectEntry.getValue()).getLong("id"));
            }
            if (splitOrderIds.size() == 1) {
                BillShowParameter showParameter = ManuFactureTraceUtils.createBillShowParam((String)keyEntity, splitOrderIds.get(0));
                showParameter.setCustomParam("useorgIdFilter", entryOrgValues);
                view.showForm((FormShowParameter)showParameter);
            } else {
                ArrayList<QFilter> list = new ArrayList<QFilter>(10);
                list.add(new QFilter("id", "in", splitOrderIds));
                ListShowParameter showParameter = ManuFactureTraceUtils.createShowParam((String)keyEntity, list);
                showParameter.setCustomParam("useorgIdFilter", entryOrgValues);
                view.showForm((FormShowParameter)showParameter);
            }
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u5f55\u3002", (String)"OrderSpliteService_1", (String)"bd-mpdm-business", (Object[])new Object[0]));
            return;
        }
    }

    public static Map<Long, BigDecimal> queryTransferQtyMap(Set<Long> mftorderEntryIds) {
        HashMap<Long, BigDecimal> transferMap = new HashMap<Long, BigDecimal>(16);
        if (CollectionUtils.isNotEmpty(mftorderEntryIds)) {
            QFilter transferQFilter = new QFilter("outentryentity.manufactureentryid", "in", mftorderEntryIds);
            transferQFilter.and("outentryentity.biztype", "=", (Object)"1");
            transferQFilter.and("billstatus", "!=", (Object)"C");
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrderSplitValidateService.queryTransferMap", (String)"sfc_protransferbill", (String)"outentryentity.outprocessid,outentryentity.transferbaseqty", (QFilter[])new QFilter[]{transferQFilter}, null);){
                if (null != dataSet) {
                    for (Row row : dataSet) {
                        long processEntryId = row.getLong("outentryentity.outprocessid");
                        BigDecimal totalTransferQty = null == transferMap.get(processEntryId) ? BigDecimal.ZERO : (BigDecimal)transferMap.get(processEntryId);
                        totalTransferQty = totalTransferQty.add(row.getBigDecimal("outentryentity.transferbaseqty"));
                        transferMap.put(row.getLong("outentryentity.outprocessid"), totalTransferQty);
                    }
                }
            }
        }
        return transferMap;
    }

    public static DynamicObject[] queryTechBillcol(Set<Long> mftorderEntryIds) {
        ArrayList<String> techStatus = new ArrayList<String>(2);
        techStatus.add("F");
        techStatus.add("G");
        QFilter techQf = new QFilter("mftentryseq", "in", mftorderEntryIds);
        techQf.and(new QFilter("oprentryentity.oprinvalid", "=", (Object)"0").and("oprentryentity.oprstatus", "not in", techStatus));
        return BusinessDataServiceHelper.load((String)MftManftechIdentityEnum.getBillIdentityByEntityKey((String)"pom_mftorder"), (String)"baseqty,oprentryentity.oprtotalsplitqty,oprentryentity.pushreportbaseqty,oprentryentity.oprtotaloutbaseqty,mftentryseq,oprentryentity.pushreportbaseqty,oprentryentity.oprtotaloutbaseqty,oprentryentity.entrustorderqty,oprentryentity.oprstatus,oprentryentity.oprinvalid", (QFilter[])techQf.toArray());
    }

    public static DynamicObject matchTechBill(DynamicObject[] techBillcol, Long mftorderEntryId) {
        DynamicObject result = null;
        for (DynamicObject techBill : techBillcol) {
            if (null == techBill || null == techBill.getDynamicObject("mftentryseq") || techBill.getDynamicObject("mftentryseq").getLong("id") != mftorderEntryId.longValue()) continue;
            result = techBill;
            break;
        }
        return result;
    }

    public static JSONObject splitMftOrderService(JSONObject param) {
        HashSet<Long> srcEntryIdInSplitEntrys = new HashSet<Long>(8);
        HashMap<Long, BigDecimal> actSplitQtyMap = new HashMap<Long, BigDecimal>(8);
        ArrayList<DynamicObject> billEntryList = new ArrayList<DynamicObject>(8);
        HashMap<DynamicObject, String> res = new HashMap<DynamicObject, String>(8);
        OrderSpliteService.readParam(param, srcEntryIdInSplitEntrys, actSplitQtyMap, billEntryList, res);
        String splitsrctype = param.getString("splitsrctype");
        MyTaskSplitOrder split = new MyTaskSplitOrder();
        split.setDispatchSource(splitsrctype);
        split.dealData(srcEntryIdInSplitEntrys, billEntryList, null, res, actSplitQtyMap);
        JSONObject result = new JSONObject();
        JSONArray detail = new JSONArray();
        for (Map.Entry entry : res.entrySet()) {
            DynamicObject key = (DynamicObject)entry.getKey();
            String value = (String)entry.getValue();
            JSONObject detailRow = new JSONObject();
            detailRow.put(key.get("splitmftorderentryid").toString(), (Object)value);
            detail.add((Object)detailRow);
        }
        result.put("detail", (Object)detail);
        return result;
    }

    private static void readParam(JSONObject param, Set<Long> srcEntryIdInSplitEntrys, Map<Long, BigDecimal> actSplitQtyMap, List<DynamicObject> billEntryList, Map<DynamicObject, String> res) {
        if (param.isEmpty()) {
            logger.info("\u672a\u8bfb\u53d6\u5230\u53c2\u6570");
            return;
        }
        DynamicObject splitDy = BusinessDataServiceHelper.newDynamicObject((String)"pom_ordersplit");
        DynamicObjectCollection splitDyEntry = splitDy.getDynamicObjectCollection("spittreeentryentity");
        JSONArray splitData = param.getJSONArray("splitData");
        for (int i = 0; i < splitData.size(); ++i) {
            JSONObject paraRow = splitData.getJSONObject(i);
            Long orderEntryID = paraRow.getLong("splitmftorderentryid");
            srcEntryIdInSplitEntrys.add(orderEntryID);
            BigDecimal splitQty = paraRow.getBigDecimal("splitqty");
            actSplitQtyMap.put(orderEntryID, splitQty);
            DynamicObject billEntry = splitDyEntry.addNew();
            billEntry.set("splitmftorderentryid", (Object)orderEntryID);
            billEntry.set("seq", (Object)paraRow.getInteger("seq"));
            DynamicObject bd_measureunits = BusinessDataServiceHelper.loadSingleFromCache((Object)paraRow.getLong("splitunit"), (String)"bd_measureunits", (String)"id");
            billEntry.set("splitunit", (Object)bd_measureunits);
            billEntry.set("splitqty", (Object)splitQty);
            billEntry.set("splitauxptyqty", (Object)paraRow.getBigDecimal("splitauxptyqty"));
            billEntry.set("splitbaseqty", (Object)paraRow.getBigDecimal("splitbaseqty"));
            DynamicObject producedept = BusinessDataServiceHelper.loadSingleFromCache((Object)paraRow.getLong("splitproducedept"), (String)"bos_org", (String)"id");
            billEntry.set("splitproducedept", (Object)producedept);
            DynamicObject inwaredept = BusinessDataServiceHelper.loadSingleFromCache((Object)paraRow.getLong("inwardept"), (String)"bos_org", (String)"id");
            billEntry.set("inwardept", (Object)inwaredept);
            DynamicObject warehouse = BusinessDataServiceHelper.loadSingleFromCache((Object)paraRow.getLong("warehouse"), (String)"bd_warehouse", (String)"id");
            billEntry.set("warehouse", (Object)warehouse);
            DynamicObject location = BusinessDataServiceHelper.loadSingleFromCache((Object)paraRow.getLong("location"), (String)"bd_location", (String)"id");
            billEntry.set("location", (Object)location);
            billEntry.set("splitplanpreparetime", (Object)paraRow.getDate("splitplanpreparetime"));
            billEntry.set("splitplanbegintime", (Object)paraRow.getDate("splitplanbegintime"));
            billEntry.set("splitplanendtime", (Object)paraRow.getDate("splitplanendtime"));
            billEntry.set("splittype", (Object)paraRow.getString("splittype"));
            DynamicObject workcenter = WorkcenterQueryHelper.getDataCacheByID((Object)paraRow.getLong("splitworkcenter"));
            billEntry.set("splitworkcenter", (Object)workcenter);
            billEntry.set("splitbatchmode", (Object)"B");
            billEntry.set("ordersrcbillid", (Object)paraRow.getLong("newscheduleplanid"));
            billEntryList.add(billEntry);
            res.put(billEntry, "");
        }
    }

    public static DynamicObject[] queryOmTechBillcol(Set<Long> mftorderEntryIds) {
        QFilter techQf = new QFilter("mftentryseq", "in", mftorderEntryIds);
        techQf.and(new QFilter("oprentryentity.oprinvalid", "=", (Object)"0").and("oprentryentity.oprstatus", "not in", Arrays.asList("F", "G")));
        return BusinessDataServiceHelper.load((String)MftManftechIdentityEnum.getBillIdentityByEntityKey((String)"om_mftorder"), (String)"unit,baseunit,baseqty,oprtotalsplitqty,material,oprunit,headunit,pushreportqty,oprtotaloutbaseqty,mftentryseq,oprtotaloutbaseqty,entrustorderqty,oprstatus,oprinvalid,headqty,operationqty", (QFilter[])techQf.toArray());
    }
}

