/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.mftorder;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.mftorder.OrderMergeHelper;
import kd.bd.mpdm.common.botp.BotpRowLinkUtils;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class OutUpdateStockService {
    private static final Log logger = LogFactory.getLog(OutUpdateStockService.class);
    private String stockEntity = "pom_mftstock";
    private String stockEntryEntity = "stockentry";
    private String xstocklogEntity = "pom_xmfstockchangelog";
    private String xstocklogEntryEntity = "entryentity";
    private String xStocklogReasonEntity = ResManager.loadKDString((String)"\u751f\u4ea7\u8865\u6599\u5355\u624b\u5de5\u65b0\u589e\u7ec4\u4ef6\u6e05\u5355\u5206\u5f55\u884c\u3002", (String)"OutUpdateStockService_0", (String)"bd-mpdm-business", (Object[])new Object[0]);
    private String xStocklogReasonEntityReplace = ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5916\u9886\u6599\u6307\u5b9a\u7684\u66ff\u4ee3\u7ec4\u4ef6\u5206\u5f55\u7684\u53d8\u66f4\u65e5\u5fd7\u3002", (String)"OutUpdateStockService_1", (String)"bd-mpdm-business", (Object[])new Object[0]);
    private String orderEntity = "pom_mftorder";
    private String techEntity = "sfc_manftech";
    private String outEntity = "im_mdc_mftfeedorder";
    private String outEntryEntity = "billentry";
    private String outEntryOprnoEntity = "oprno";
    private String outTcTable = "t_im_mdc_probill_tc";
    private String reqApplyEntity = "im_mdc_mftomreqapplybill";
    private String reqApplyEntryEntity = "billentry";
    private String returnEntryEntity = "billentry";

    private void dealEntityInfo(String outBillEntityType, String productionDomain) {
        this.outEntity = outBillEntityType;
        if ("im_mdc_omfeedbill".equals(outBillEntityType)) {
            this.orderEntity = "om_mftorder";
            this.stockEntity = "om_mftstock";
            this.techEntity = "om_mfttechnics";
            this.xstocklogEntity = "om_xmfstockchangelog";
            this.outEntryOprnoEntity = "operationno";
            this.outTcTable = "t_im_mdc_omoutbill_tc";
            this.xStocklogReasonEntity = ResManager.loadKDString((String)"\u59d4\u5916\u8865\u6599\u5355\u624b\u5de5\u65b0\u589e\u7ec4\u4ef6\u6e05\u5355\u5206\u5f55\u884c\u3002", (String)"OutUpdateStockService_2", (String)"bd-mpdm-business", (Object[])new Object[0]);
        }
        if ("im_mdc_omreqapplybill".equals(outBillEntityType)) {
            this.orderEntity = "om_mftorder";
            this.stockEntity = "om_mftstock";
            this.techEntity = "om_mfttechnics";
        }
        if ("im_mdc_mftreturnorder".equals(outBillEntityType)) {
            this.xStocklogReasonEntity = ResManager.loadKDString((String)"\u751f\u4ea7\u9000\u6599\u5355\u624b\u5de5\u65b0\u589e\u7ec4\u4ef6\u6e05\u5355\u5206\u5f55\u884c\u3002", (String)"OutUpdateStockService_19", (String)"bd-mpdm-business", (Object[])new Object[0]);
        }
        if ("im_mdc_omreturnbill".equals(outBillEntityType)) {
            this.orderEntity = "om_mftorder";
            this.stockEntity = "om_mftstock";
            this.techEntity = "om_mfttechnics";
            this.xstocklogEntity = "om_xmfstockchangelog";
            this.outEntryOprnoEntity = "operationno";
            this.outTcTable = "t_im_mdc_omoutbill_tc";
            this.xStocklogReasonEntity = ResManager.loadKDString((String)"\u59d4\u5916\u9000\u6599\u5355\u624b\u5de5\u65b0\u589e\u7ec4\u4ef6\u6e05\u5355\u5206\u5f55\u884c\u3002", (String)"OutUpdateStockService_20", (String)"bd-mpdm-business", (Object[])new Object[0]);
        }
        if ("E".equals(productionDomain)) {
            this.orderEntity = "prop_mftorder";
            this.stockEntity = "prop_mftstock";
            this.techEntity = "prop_manftech";
        }
    }

    public void updateNewStock(Set<Long> outBillIds, String outBillEntityType, String productionDomain) {
        this.updateStockImpl(outBillIds, outBillEntityType, productionDomain);
    }

    public void updateStock(Set<Long> outBillIds, String outBillEntityType) {
        this.updateStockImpl(outBillIds, outBillEntityType, "");
    }

    private void updateStockImpl(Set<Long> outBillIds, String outBillEntityType, String productionDomain) {
        List<DynamicObject> outBills;
        this.dealEntityInfo(outBillEntityType, productionDomain);
        if (StringUtils.equals((CharSequence)"im_mdc_omreqapplybill", (CharSequence)outBillEntityType) || StringUtils.equals((CharSequence)"im_mdc_mftreqapplybill", (CharSequence)outBillEntityType)) {
            outBills = this.queryMdcApplyBills(outBillIds);
        } else {
            outBills = StringUtils.equals((CharSequence)"im_mdc_mftreturnorder", (CharSequence)outBillEntityType) || StringUtils.equals((CharSequence)"im_mdc_omreturnbill", (CharSequence)outBillEntityType) ? this.queryReturnBills(outBillIds, outBillEntityType) : this.queryOutBills(outBillIds);
            HashMap<Long, DynamicObject> feedEntryAndBillMap = new HashMap<Long, DynamicObject>(16);
            HashMap<Long, Boolean> orderIdAndTransIsUpdateStockMap = new HashMap<Long, Boolean>(16);
            this.packageWriteBackCondition(outBills, feedEntryAndBillMap, orderIdAndTransIsUpdateStockMap);
            List<DynamicObject> writeBackList = this.packageWriteBackList(outBills, orderIdAndTransIsUpdateStockMap);
            if (CollectionUtils.isNotEmpty(writeBackList)) {
                this.writeBackMftStock(outBills, writeBackList);
            } else {
                logger.info("OutUpdateMftStockService todo writeBackList is empty.");
            }
        }
        if (!StringUtils.equals((CharSequence)"im_mdc_mftreturnorder", (CharSequence)outBillEntityType) || !StringUtils.equals((CharSequence)"im_mdc_omreturnbill", (CharSequence)outBillEntityType)) {
            this.updateStockReplace(outBills);
        }
        if (StringUtils.equals((CharSequence)this.outEntity, (CharSequence)outBillEntityType)) {
            this.calAuditCalMaterial(outBills, "audit", productionDomain);
        }
    }

    private void calAuditCalMaterial(List<DynamicObject> outBills, String operationKey, String productionDomain) {
        if (CollectionUtils.isNotEmpty(outBills)) {
            HashSet<Long> orderEntryids = new HashSet<Long>(16);
            HashSet<Long> orderids = new HashSet<Long>(16);
            for (DynamicObject outBill : outBills) {
                DynamicObjectCollection outBillEntrys = outBill.getDynamicObjectCollection("billentry");
                if (!CollectionUtils.isNotEmpty((Collection)outBillEntrys)) continue;
                for (DynamicObject outBillEntry : outBillEntrys) {
                    orderids.add(outBillEntry.getLong("manubillid"));
                    orderEntryids.add(outBillEntry.getLong("manuentryid"));
                }
            }
            if (orderEntryids.size() > 0 && orderids.size() > 0) {
                HashMap<String, Object> calparam = new HashMap<String, Object>(8);
                calparam.put("orderentryids", orderEntryids);
                calparam.put("orderids", orderids);
                calparam.put("operate", operationKey);
                calparam.put("iscloseorder", "1");
                calparam.put("isautocal", "0");
                calparam.put("isautoflag", "0");
                String modetype = "1";
                if ("im_mdc_omfeedbill".equals(this.outEntity) || "im_mdc_omreturnbill".equals(this.outEntity)) {
                    modetype = "2";
                }
                if ("E".equals(productionDomain)) {
                    modetype = "9";
                }
                calparam.put("modetype", modetype);
                String jsonString = JSON.toJSONString(calparam);
                logger.info("outUpdateStockService start invoke auditCalMaterial " + operationKey);
                EventServiceHelper.triggerEventSubscribe((String)"auditCalMaterial", (String)jsonString);
                logger.info("outUpdateStockService end invoke auditCalMaterial " + operationKey);
            }
        }
    }

    public void updateStockReplace(List<DynamicObject> outBills) {
        if (outBills == null || outBills.size() < 1) {
            return;
        }
        HashSet<Long> needUpdateStockEntryIdSet = new HashSet<Long>(16);
        HashMap<Long, DynamicObject> stockEntryIdAndOutBill = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> stockEntryIdAndOutBillEntry = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject outBill : outBills) {
            DynamicObject billEntry;
            DynamicObjectCollection billEntrys = outBill.getDynamicObjectCollection(this.outEntryEntity);
            Iterator iterator = billEntrys.iterator();
            while (iterator.hasNext() && (billEntry = (DynamicObject)iterator.next()).containsProperty("stockentryid")) {
                long stockentryid = billEntry.getLong("stockentryid");
                long mainbillid = billEntry.getLong("mainbillid");
                String materialreplace = billEntry.getString("materialreplace");
                if (!StringUtils.isNotBlank((CharSequence)materialreplace) || stockentryid == 0L) continue;
                needUpdateStockEntryIdSet.add(stockentryid);
                stockEntryIdAndOutBill.put(stockentryid, outBill);
                stockEntryIdAndOutBillEntry.put(stockentryid, billEntry);
            }
        }
        QFilter stockQfiter = new QFilter("stockentry.id", "in", needUpdateStockEntryIdSet);
        DynamicObject[] stockBills = BusinessDataServiceHelper.load((String)this.stockEntity, (String)this.getStockSelectProperties(), (QFilter[])stockQfiter.toArray());
        ArrayList<DynamicObject> updateStockBills = new ArrayList<DynamicObject>(16);
        HashSet<Long> needStockLogSet = new HashSet<Long>(16);
        HashMap<Long, String> stockBillEntryIdAndOldIssueMode = new HashMap<Long, String>(16);
        for (DynamicObject stockBill : stockBills) {
            DynamicObjectCollection stockBillEntrys = stockBill.getDynamicObjectCollection(this.stockEntryEntity);
            for (DynamicObject stockBillEntry : stockBillEntrys) {
                long stockBillEntryId = stockBillEntry.getLong("id");
                String issuemode = stockBillEntry.getString("issuemode");
                if (StringUtils.equals((CharSequence)issuemode, (CharSequence)"C") || !needUpdateStockEntryIdSet.contains(stockBillEntryId)) continue;
                stockBillEntry.set("issuemode", (Object)"C");
                updateStockBills.add(stockBill);
                needStockLogSet.add(stockBillEntryId);
                stockBillEntryIdAndOldIssueMode.put(stockBillEntryId, issuemode);
            }
        }
        if (!updateStockBills.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])updateStockBills.toArray(new DynamicObject[updateStockBills.size()]));
            ArrayList<DynamicObject> xmfStockLogList = new ArrayList<DynamicObject>(10);
            for (DynamicObject updateStockBill : updateStockBills) {
                DynamicObjectCollection stockBillEntrys = updateStockBill.getDynamicObjectCollection(this.stockEntryEntity);
                for (DynamicObject stockBillEntry : stockBillEntrys) {
                    long stockBillEntryId = stockBillEntry.getLong("id");
                    if (!needStockLogSet.contains(stockBillEntryId)) continue;
                    String oldIssueMode = (String)stockBillEntryIdAndOldIssueMode.get(stockBillEntryId);
                    xmfStockLogList.add(this.insertXmftOrderLogByReplace(stockBillEntry, (DynamicObject)stockEntryIdAndOutBillEntry.get(stockBillEntryId), updateStockBill, (DynamicObject)stockEntryIdAndOutBill.get(stockBillEntryId), oldIssueMode));
                }
            }
            if (!xmfStockLogList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])xmfStockLogList.toArray(new DynamicObject[xmfStockLogList.size()]));
            }
        }
    }

    private DynamicObject insertXmftOrderLogByReplace(DynamicObject stockentry, DynamicObject feedBillEntry, DynamicObject stockBill, DynamicObject feedBill, String oldIssueMode) {
        DynamicObject xmftstocklog = BusinessDataServiceHelper.newDynamicObject((String)this.xstocklogEntity);
        xmftstocklog = this.dealXMftOrderChangeLogByReplace(xmftstocklog, stockentry, stockBill, feedBillEntry, feedBill, oldIssueMode);
        return xmftstocklog;
    }

    private DynamicObject dealXMftOrderChangeLogByReplace(DynamicObject xmftstocklog, DynamicObject stockentry, DynamicObject stockBill, DynamicObject feedBillEntry, DynamicObject feedBill, String oldIssueMode) {
        xmftstocklog.set("stockchangeid", feedBill.getPkValue());
        xmftstocklog.set("stockchangeentryid", feedBillEntry.getPkValue());
        xmftstocklog.set("org", stockBill.get("org"));
        xmftstocklog.set("changeno", feedBill.get("billno"));
        xmftstocklog.set("billstatus", (Object)"C");
        xmftstocklog.set("creator", feedBill.get("auditor"));
        xmftstocklog.set("reason", (Object)this.xStocklogReasonEntityReplace);
        xmftstocklog.set("entryidf", stockentry.getPkValue());
        xmftstocklog.set("stockno", (Object)stockBill.getString("billno"));
        xmftstocklog.set("stockentryid", stockentry.getPkValue());
        xmftstocklog.set("stockid", stockBill.getPkValue());
        xmftstocklog.set("stockchangeentryseq", stockBill.getPkValue());
        DynamicObjectCollection entryentity = xmftstocklog.getDynamicObjectCollection("entryentity");
        DynamicObject addNew = entryentity.addNew();
        this.createStockChangeLogEntryByReplace(addNew, stockentry, this.getIssueMode(oldIssueMode));
        return xmftstocklog;
    }

    public String getIssueMode(String oldIssueMode) {
        StringBuilder issueModeValue = new StringBuilder(50);
        if (StringUtils.equals((CharSequence)"A", (CharSequence)oldIssueMode)) {
            issueModeValue.append(ResManager.loadKDString((String)"\u751f\u4ea7\u9886\u6599", (String)"OutUpdateStockService_3", (String)"bd-mpdm-business", (Object[])new Object[0]));
        } else if (StringUtils.equals((CharSequence)"B", (CharSequence)oldIssueMode)) {
            issueModeValue.append(ResManager.loadKDString((String)"\u76f4\u9001", (String)"OutUpdateStockService_4", (String)"bd-mpdm-business", (Object[])new Object[0]));
        }
        issueModeValue.append("->").append(ResManager.loadKDString((String)"\u4e0d\u9886\u6599", (String)"OutUpdateStockService_5", (String)"bd-mpdm-business", (Object[])new Object[0]));
        return issueModeValue.toString();
    }

    private void createStockChangeLogEntryByReplace(DynamicObject addNew, DynamicObject stockentry, String issueMode) {
        DynamicObject materialUnitid = stockentry.getDynamicObject("materialunitid");
        int precision = materialUnitid == null ? 4 : materialUnitid.getInt("precision");
        addNew.set("entrychangetype", (Object)"B");
        addNew.set("materialid", stockentry.get("materialid"));
        addNew.set("qtytype", stockentry.get("qtytype"));
        addNew.set("useratio", stockentry.get("useratio"));
        addNew.set("qtynumerator", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("qtynumerator"), "qtynumerator", precision));
        addNew.set("qtydenominator", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("qtydenominator"), "qtydenominator", precision));
        addNew.set("wastagerateformula", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("wastagerateformula"), "wastagerateformula", precision));
        addNew.set("fixscrap", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("fixscrap"), "fixscrap", precision));
        addNew.set("scraprate", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("scraprate"), "scraprate", precision));
        addNew.set("standqty", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("standqty"), "standqty", precision));
        addNew.set("demandqty", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("demandqty"), "demandqty", precision));
        addNew.set("unissueqty", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("unissueqty"), "unissueqty", precision));
        addNew.set("useqty", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("useqty"), "useqty", precision));
        addNew.set("wipqty", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("wipqty"), "wipqty", precision));
        addNew.set("supplymode", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("supplymode"), "supplymode", precision));
        addNew.set("supplierid", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("supplierid"), "supplierid", precision));
        addNew.set("supplyorgid", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("supplyorgid"), "supplyorgid", precision));
        addNew.set("warehouseid", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("warehouseid"), "warehouseid", precision));
        addNew.set("location", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("location"), "location", precision));
        addNew.set("outorgunitid", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("outorgunitid"), "outorgunitid", precision));
        addNew.set("outwarehouseid", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("outwarehouseid"), "outwarehouseid", precision));
        addNew.set("outwarehouseid", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("outwarehouseid"), "outwarehouseid", precision));
        addNew.set("outlocation", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("outlocation"), "outlocation", precision));
        addNew.set("issuemode", (Object)issueMode);
        addNew.set("isbackflush", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("isbackflush"), "isbackflush", precision));
        addNew.set("isbulkmaterial", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("isbulkmaterial"), "isbulkmaterial", precision));
        addNew.set("iskeypart", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("iskeypart"), "iskeypart", precision));
        addNew.set("overissuecontrl", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("overissuecontrl"), "overissuecontrl", precision));
        addNew.set("issinhighlimit", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("issinhighlimit"), "issinhighlimit", precision));
        addNew.set("extraratioqty", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("extraratioqty"), "extraratioqty", precision));
        addNew.set("issinlowlimit", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("issinlowlimit"), "issinlowlimit", precision));
        addNew.set("lackraitioqty", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("lackraitioqty"), "lackraitioqty", precision));
        addNew.set("demanddate", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("demanddate"), "demanddate", precision));
        if (stockentry.containsProperty("processseq")) {
            this.setValue(addNew, "processseq", OutUpdateStockService.addNewEntryValue(stockentry.get("processseq"), "processseq", precision));
        }
        addNew.set("oprno", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("oprno"), "oprno", precision));
    }

    public String getStockSelectProperties() {
        return "billno,productid,org,stockentry.id,stockentry.rework,stockentry.materielmasterid,stockentry.materielinv,stockentry.materialid,stockentry.entryconfiguredcode,stockentry.materialunitid,stockentry.bomreversion,stockentry.batchno,stockentry.lot,stockentry.qtytype,stockentry.isstep,stockentry.useratio,stockentry.qtynumerator,stockentry.qtydenominator,stockentry.wastagerateformula,stockentry.fixscrap,stockentry.scraprate,stockentry.standqty,stockentry.demandqty,stockentry.actissueqty,stockentry.unissueqty,stockentry.pushapplybaseqty,stockentry.outqty,stockentry.useqty,stockentry.avbbaseqty,stockentry.reservebaseqty,stockentry.iscannegative,stockentry.childbomid,stockentry.childbomversion,stockentry.childauxpropertyid,stockentry.supplymode,stockentry.supplierid,stockentry.isstockallot,stockentry.supplyorgid,stockentry.warehouseid,stockentry.location,stockentry.outorgunitid,stockentry.outwarehouseid,stockentry.outlocation,stockentry.issuemode,stockentry.isbackflush,stockentry.backflushtime,stockentry.iskeypart,stockentry.overissuecontrl,stockentry.issinhighlimit,stockentry.extraratioqty,stockentry.issinlowlimit,stockentry.lackraitioqty,stockentry.leadtime,stockentry.demanddate,stockentry.childremarks,stockentry.setuplocation,stockentry.rejectedqty,stockentry.feedingqty,stockentry.allotqty,stockentry.scrapqty,stockentry.wipqty,stockentry.cansendqty,stockentry.workprocedureid,stockentry.isbomextend,stockentry.entrychangetype,stockentry.isbulkmaterial,stockentry.srcbillid,stockentry.srcbillentryid,stockentry.processseq,stockentry.workplanid,stockentry.replaceplan,stockentry.oprno,stockentry.priority,stockentry.ecostcenter,stockentry.parentmaterial,stockentry.workstation,stockentry.outsupplier,stockentry.isjumplevel,stockentry.promaterentryid,stockentry.sourcetype,stockentry.bomentryid,stockentry.machiningtype,stockentry.operationdesc,stockentry.oprworkcenter,stockentry.ismainreplace";
    }

    public void deleteNewStock(Set<Long> outBillIds, String outBillEntityType, String productionDomain) {
        this.deleteStockImpl(outBillIds, outBillEntityType, productionDomain);
    }

    public void deleteStock(Set<Long> outBillIds, String outBillEntityType) {
        this.deleteStockImpl(outBillIds, outBillEntityType, "");
    }

    private void deleteStockImpl(Set<Long> outBillIds, String outBillEntityType, String productionDomain) {
        this.dealEntityInfo(outBillEntityType, productionDomain);
        List<Object> outBills = new ArrayList(16);
        outBills = StringUtils.equals((CharSequence)"im_mdc_mftreturnorder", (CharSequence)outBillEntityType) || StringUtils.equals((CharSequence)"im_mdc_omreturnbill", (CharSequence)outBillEntityType) ? this.queryReturnBills(outBillIds, outBillEntityType) : this.queryOutBills(outBillIds);
        Set<DynamicObject> deleteEntrys = this.queryDeleteSrcStockEntrys(outBills);
        HashSet<Long> stockEntryIds = new HashSet<Long>(16);
        for (DynamicObject deleteEntry : deleteEntrys) {
            stockEntryIds.add(deleteEntry.getLong("mainbillentryid"));
        }
        this.deleteStockEntrys(stockEntryIds);
        this.clearStockEntryInfo(deleteEntrys, outBills);
        if (StringUtils.equals((CharSequence)this.outEntity, (CharSequence)outBillEntityType)) {
            this.calAuditCalMaterial(outBills, "unaudit", productionDomain);
        }
    }

    private List<DynamicObject> queryOutBills(Set<Long> outBillIds) {
        List<DynamicObject> outBills = new ArrayList<DynamicObject>(10);
        if (CollectionUtils.isNotEmpty(outBillIds)) {
            QFilter qFilter = new QFilter("id", "in", outBillIds);
            String selectProperties = "id,billno,needtime,billstatus,biztype,invscheme,qty,material,srcbillentity,srcbillid,srcbillentryid,srcbillnumber,srcbillentryseq,mainbillentity,mainbillid,mainbillentryid,mainbillnumber,mainbillentryseq,billtype,biztime,billentry,manubill,manubillid,manuentry,manuentryid,baseqty,ischargeoff,isbackflush,isvirtualbill,org,bizorg,billcretype,auditor,bookdate,lastupdateuser,lastupdatetime,billhead_lk,billentry.stockentryid,billentry.stockno,billentry.stockentry,billentry.stockid,billentry.material,billentry.configuredcode,billentry.lotnumber,billentry.baseunit,billentry.auxpty,billentry.outownertype,billentry.outowner,billentry.warehouse,billentry.location,billentry.oprno,billentry.processseq,billentry.isadd,billentry.workprocedureid,billentry.operationdesc,billentry.oprworkcenter,billentry.workstation,billentry.workstation,billentry.billentry_lk,billentry.billentry_lk_stableid,billentry.billentry_lk_sbillid,billentry.billentry_lk_sid,billentry.linetype,billentry.materialname,billentry.isrework,billentry.feedreason,billentry.lot,billentry.isrework,billentry.updatestockresult,billentry.ecostcenter,billentry.manuentryid,billentry.baseqty,billentry.seq,billentry.srcbillentity,billentry.materialreplace,billentry.stockentryid,billentry." + this.outEntryOprnoEntity;
            DynamicObject[] load = BusinessDataServiceHelper.load((String)this.outEntity, (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
            outBills = Arrays.asList(load);
        }
        return outBills;
    }

    private List<DynamicObject> queryReturnBills(Set<Long> outBillIds, String returnEntity) {
        List<DynamicObject> returnBills = new ArrayList<DynamicObject>(10);
        if (CollectionUtils.isNotEmpty(outBillIds)) {
            QFilter qFilter = new QFilter("id", "in", outBillIds);
            String selectProperties = "id,billno,needtime,billstatus,biztype,invscheme,qty,material,srcbillentity,srcbillid,srcbillentryid,srcbillnumber,srcbillentryseq,mainbillentity,mainbillid,mainbillentryid,mainbillnumber,mainbillentryseq,billtype,biztime,billentry,manubill,manubillid,manuentry,manuentryid,baseqty,ischargeoff,isbackflush,isvirtualbill,org,bizorg,billcretype,auditor,bookdate,lastupdateuser,lastupdatetime,billhead_lk,billentry.stockentryid,billentry.stockno,billentry.stockentry,billentry.stockid,billentry.material,billentry.configuredcode,billentry.lotnumber,billentry.baseunit,billentry.auxpty,billentry.outownertype,billentry.outowner,billentry.warehouse,billentry.location,billentry.oprno,billentry.processseq,billentry.isadd,billentry.workprocedureid,billentry.operationdesc,billentry.oprworkcenter,billentry.workstation,billentry.workstation,billentry.billentry_lk,billentry.billentry_lk_stableid,billentry.billentry_lk_sbillid,billentry.billentry_lk_sid,billentry.linetype,billentry.materialname,billentry.isrework,billentry.feedreason,billentry.lot,billentry.isrework,billentry.updatestockresult,billentry.ecostcenter,billentry.manuentryid,billentry.baseqty,billentry.seq,billentry.srcbillentity,billentry.materialreplace,billentry.stockentryid,billentry." + this.outEntryOprnoEntity;
            DynamicObject[] load = BusinessDataServiceHelper.load((String)returnEntity, (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
            returnBills = Arrays.asList(load);
        }
        return returnBills;
    }

    private List<DynamicObject> queryMdcApplyBills(Set<Long> applyBillIds) {
        List<DynamicObject> outBills = new ArrayList<DynamicObject>(10);
        if (CollectionUtils.isNotEmpty(applyBillIds)) {
            QFilter qFilter = new QFilter("id", "in", applyBillIds);
            StringBuilder selectProperties = new StringBuilder(200);
            selectProperties.append("id,billno,auditor,mainbillentity,mainbillid,mainbillentryid,mainbillnumber,mainbillentryseq,billtype,biztime,");
            selectProperties.append("billentry.stockentryid,billentry.stockno,billentry.stockentry,billentry.stockid,");
            selectProperties.append("billentry.materialreplace,billentry.stockentryid");
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"im_mdc_mftomreqapplybill", (String)selectProperties.toString(), (QFilter[])new QFilter[]{qFilter});
            outBills = Arrays.asList(load);
        }
        return outBills;
    }

    private long[] getMftStockEntryIds(String billName, int size) {
        ORM orm = ORM.create();
        long[] ids = orm.genLongIds(billName + "." + this.stockEntryEntity, size);
        return ids;
    }

    private Map<Long, DynamicObject> queryOrderEntryMap(Set<Long> orderEntryIdSet) {
        HashMap<Long, DynamicObject> orderEntryMap = new HashMap<Long, DynamicObject>(16);
        if (CollectionUtils.isNotEmpty(orderEntryIdSet)) {
            DynamicObject[] orderList;
            QFilter qFilter = new QFilter("treeentryentity.id", "in", orderEntryIdSet);
            String selectProperties = "treeentryentity.planbegintime,treeentryentity.baseqty,treeentryentity.id";
            for (DynamicObject orderBill : orderList = BusinessDataServiceHelper.load((String)this.orderEntity, (String)selectProperties, (QFilter[])new QFilter[]{qFilter})) {
                DynamicObjectCollection orderBillEntrys = orderBill.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject orderBillEntry : orderBillEntrys) {
                    orderEntryMap.put(orderBillEntry.getLong("id"), orderBillEntry);
                }
            }
        }
        return orderEntryMap;
    }

    private List<DynamicObject> queryTechBills(Set<Long> orderEntryIdSet) {
        List<DynamicObject> techBillList = new ArrayList<DynamicObject>(10);
        if (CollectionUtils.isNotEmpty(orderEntryIdSet)) {
            QFilter techQFilter = new QFilter("mftentryseq", "in", orderEntryIdSet);
            techQFilter.and(new QFilter("billstatus", "=", (Object)"C"));
            String techSelectProperties = "mftentryseq,oprentryentity,oprentryentity.oprno,oprentryentity.oprparent,oprentryentity.oprworkcenter,oprentryentity.machiningtype,oprentryentity.supplier,oprentryentity.oproperation,oprentryentity.workstation,oprentryentity.oprdescription";
            DynamicObject[] techList = BusinessDataServiceHelper.load((String)this.techEntity, (String)techSelectProperties, (QFilter[])new QFilter[]{techQFilter});
            techBillList = Arrays.asList(techList);
        }
        return techBillList;
    }

    private void writeBackMftStock(List<DynamicObject> outBills, List<DynamicObject> wBackList) {
        int newEntrySize = wBackList.size();
        long[] genstockEntryIds = this.getMftStockEntryIds(this.stockEntity, newEntrySize);
        int newEntryIdIndex = 0;
        HashSet<Long> stockIdSet = new HashSet<Long>(16);
        HashSet<Long> orderEntryIdSet = new HashSet<Long>(16);
        HashSet<Long> outEntryIdSet = new HashSet<Long>(16);
        for (DynamicObject feedBillColRow : wBackList) {
            stockIdSet.add(feedBillColRow.getLong("mainbillid"));
            orderEntryIdSet.add(feedBillColRow.getLong("manuentryid"));
            outEntryIdSet.add(feedBillColRow.getLong("id"));
        }
        ArrayList<DynamicObject> stockList = new ArrayList<DynamicObject>(10);
        Map<Long, DynamicObject> orderEntryMap = this.queryOrderEntryMap(orderEntryIdSet);
        List<DynamicObject> techList = this.queryTechBills(orderEntryIdSet);
        ArrayList<DynamicObject> xStockLogList = new ArrayList<DynamicObject>(10);
        ArrayList linkList = new ArrayList(10);
        Iterator iterator = stockIdSet.iterator();
        while (iterator.hasNext()) {
            DynamicObject stockDym = BusinessDataServiceHelper.loadSingle(iterator.next(), (String)this.stockEntity);
            if (stockDym == null) continue;
            Long orderEntryIdInStockEntry = 0L;
            DynamicObject orderEntryDynInStockEntry = stockDym.getDynamicObject("orderentryid");
            if (null != orderEntryDynInStockEntry) {
                orderEntryIdInStockEntry = orderEntryDynInStockEntry.getLong("id");
            }
            DynamicObject transactionType = stockDym.getDynamicObject("transactiontypeid");
            boolean isprocedure = transactionType.getBoolean("isprocedure");
            DynamicObject techBill = null;
            if (isprocedure && null != techList) {
                for (DynamicObject tempTech : techList) {
                    Long orderEntryIdInTempTech = 0L;
                    DynamicObject orderEntryDynInTempTech = tempTech.getDynamicObject("mftentryseq");
                    if (null != orderEntryDynInTempTech) {
                        orderEntryIdInTempTech = orderEntryDynInTempTech.getLong("id");
                    }
                    if (!orderEntryIdInStockEntry.equals(orderEntryIdInTempTech)) continue;
                    techBill = tempTech;
                    break;
                }
            }
            DynamicObjectCollection stockentrys = stockDym.getDynamicObjectCollection(this.stockEntryEntity);
            DynamicObject orderEntryDyn = orderEntryMap.get(stockDym.getDynamicObject("orderentryid").getLong("id"));
            int index = stockentrys.size();
            DynamicObjectType dynamicObjectType = stockentrys.getDynamicObjectType();
            for (DynamicObject outBill : outBills) {
                if (null == outBill) continue;
                DynamicObjectCollection outBillEntrys = outBill.getDynamicObjectCollection(this.outEntryEntity);
                for (DynamicObject feedBillColRow : outBillEntrys) {
                    Long outEntryId = feedBillColRow.getLong("id");
                    if (!outEntryIdSet.contains(outEntryId)) continue;
                    long stockidInFeedEntry = feedBillColRow.getLong("mainbillid");
                    if (stockDym.getLong("id") != stockidInFeedEntry) continue;
                    DynamicObject newStockEntry = (DynamicObject)dynamicObjectType.createInstance();
                    newStockEntry.set("seq", (Object)(++index));
                    newStockEntry.set("id", (Object)genstockEntryIds[newEntryIdIndex]);
                    this.insertEntryData(newStockEntry, feedBillColRow, outBill, orderEntryDyn, transactionType);
                    if (null != techBill) {
                        this.updateMftStockEntry(newStockEntry, techBill);
                    }
                    stockentrys.add((Object)newStockEntry);
                    feedBillColRow.set("mainbillentryseq", newStockEntry.get("seq"));
                    feedBillColRow.set("mainbillentryid", (Object)newStockEntry.getLong("id"));
                    feedBillColRow.set("workprocedureid", newStockEntry.get("workprocedureid"));
                    feedBillColRow.set("operationdesc", newStockEntry.get("operationdesc"));
                    if (newStockEntry.containsProperty("oprworkcenter")) {
                        this.setValue(feedBillColRow, "oprworkcenter", newStockEntry.get("oprworkcenter"));
                    }
                    if (newStockEntry.containsProperty("workstation")) {
                        this.setValue(feedBillColRow, "workstation", newStockEntry.get("workstation"));
                    }
                    if (newStockEntry.containsProperty("processseq")) {
                        this.setValue(feedBillColRow, "processseq", newStockEntry.get("processseq"));
                    }
                    feedBillColRow.set(this.outEntryOprnoEntity, newStockEntry.get("oprno"));
                    feedBillColRow.set("updatestockresult", (Object)"B");
                    String reqApplyEntityStr = feedBillColRow.getString("srcbillentity");
                    if (!this.reqApplyEntity.equals(reqApplyEntityStr)) {
                        feedBillColRow.set("srcbillentryid", newStockEntry.get("id"));
                        feedBillColRow.set("srcbillid", stockDym.get("id"));
                    }
                    xStockLogList.add(this.insertXmftOrderLog(newStockEntry, feedBillColRow, stockDym, outBill));
                    HashMap<String, Object> linkMap = new HashMap<String, Object>(16);
                    linkMap.put("sbillid", stockDym.get("id"));
                    linkMap.put("sbillentryid", newStockEntry.get("id"));
                    linkMap.put("tbillid", null == outBill ? Long.valueOf(0L) : outBill.get("id"));
                    linkMap.put("tbillentryid", feedBillColRow.get("id"));
                    linkMap.put("tseq", feedBillColRow.get("seq"));
                    linkList.add(linkMap);
                    ++newEntryIdIndex;
                }
            }
            stockList.add(stockDym);
        }
        OperationResult saveOperate = SaveServiceHelper.saveOperate((String)this.stockEntity, (DynamicObject[])stockList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!saveOperate.isSuccess()) {
            throw new KDBizException(OrderMergeHelper.getOperationResultErrorInfos(saveOperate));
        }
        if (CollectionUtils.isNotEmpty(xStockLogList)) {
            SaveServiceHelper.save((DynamicObject[])xStockLogList.toArray(new DynamicObject[xStockLogList.size()]));
            SaveServiceHelper.save((DynamicObject[])outBills.toArray(new DynamicObject[outBills.size()]));
            if (CollectionUtils.isNotEmpty(linkList)) {
                BotpRowLinkUtils.batchFixRowLinkDB((String)this.outEntity, (String)this.outEntryEntity, (String)this.stockEntity, (String)this.stockEntryEntity, linkList);
            }
        }
    }

    private DynamicObject insertXmftOrderLog(DynamicObject stockentry, DynamicObject row, DynamicObject stockDym, DynamicObject feedBill) {
        DynamicObject xmftstocklog = BusinessDataServiceHelper.newDynamicObject((String)this.xstocklogEntity);
        xmftstocklog = this.dealXMftOrderChangeLog(xmftstocklog, stockentry, stockDym, row, feedBill);
        return xmftstocklog;
    }

    private DynamicObject dealXMftOrderChangeLog(DynamicObject xmftstocklog, DynamicObject stockentry, DynamicObject stockDym, DynamicObject row, DynamicObject feedBill) {
        xmftstocklog.set("stockchangeid", feedBill.getPkValue());
        xmftstocklog.set("stockchangeentryid", row.getPkValue());
        xmftstocklog.set("org", stockDym.get("org"));
        String number = MPDMMftGenStocksUtils.getAutoNumber((DynamicObject)xmftstocklog, (String)xmftstocklog.getDynamicObject("org").getPkValue().toString(), (String)this.xstocklogEntity);
        if (number == null) {
            number = "mo_" + row.getPkValue();
        }
        xmftstocklog.set("changeno", (Object)number);
        xmftstocklog.set("billstatus", (Object)"C");
        xmftstocklog.set("creator", feedBill.get("auditor"));
        xmftstocklog.set("reason", (Object)this.xStocklogReasonEntity);
        xmftstocklog.set("createtime", feedBill.get("bookdate"));
        xmftstocklog.set("entryidf", (Object)row.getLong("mainbillentryid"));
        xmftstocklog.set("stockno", (Object)row.getString("mainbillnumber"));
        xmftstocklog.set("stockentryid", (Object)row.getLong("mainbillentryid"));
        xmftstocklog.set("stockid", (Object)row.getLong("mainbillid"));
        xmftstocklog.set("stockchangeentryseq", (Object)row.getLong("mainbillid"));
        DynamicObjectCollection entryentity = xmftstocklog.getDynamicObjectCollection("entryentity");
        DynamicObject addNew = entryentity.addNew();
        this.createStockChangeLogEntry(addNew, stockentry);
        return xmftstocklog;
    }

    private void createStockChangeLogEntry(DynamicObject addNew, DynamicObject stockentry) {
        DynamicObject materialUnitid = stockentry.getDynamicObject("materialunitid");
        int precision = materialUnitid == null ? 4 : materialUnitid.getInt("precision");
        addNew.set("entrychangetype", (Object)"A");
        addNew.set("materialid", stockentry.get("materialid"));
        addNew.set("qtytype", stockentry.get("qtytype"));
        addNew.set("useratio", stockentry.get("useratio"));
        addNew.set("qtynumerator", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("qtynumerator"), "qtynumerator", precision));
        addNew.set("qtydenominator", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("qtydenominator"), "qtydenominator", precision));
        addNew.set("wastagerateformula", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("wastagerateformula"), "wastagerateformula", precision));
        addNew.set("fixscrap", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("fixscrap"), "fixscrap", precision));
        addNew.set("scraprate", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("scraprate"), "scraprate", precision));
        addNew.set("standqty", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("standqty"), "standqty", precision));
        addNew.set("demandqty", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("demandqty"), "demandqty", precision));
        addNew.set("unissueqty", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("unissueqty"), "unissueqty", precision));
        addNew.set("useqty", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("useqty"), "useqty", precision));
        addNew.set("wipqty", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("wipqty"), "wipqty", precision));
        addNew.set("supplymode", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("supplymode"), "supplymode", precision));
        addNew.set("supplierid", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("supplierid"), "supplierid", precision));
        addNew.set("supplyorgid", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("supplyorgid"), "supplyorgid", precision));
        addNew.set("warehouseid", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("warehouseid"), "warehouseid", precision));
        addNew.set("location", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("location"), "location", precision));
        addNew.set("outorgunitid", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("outorgunitid"), "outorgunitid", precision));
        addNew.set("outwarehouseid", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("outwarehouseid"), "outwarehouseid", precision));
        addNew.set("outwarehouseid", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("outwarehouseid"), "outwarehouseid", precision));
        addNew.set("outlocation", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("outlocation"), "outlocation", precision));
        addNew.set("issuemode", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("issuemode"), "issuemode", precision));
        addNew.set("isbackflush", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("isbackflush"), "isbackflush", precision));
        addNew.set("isbulkmaterial", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("isbulkmaterial"), "isbulkmaterial", precision));
        addNew.set("iskeypart", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("iskeypart"), "iskeypart", precision));
        addNew.set("overissuecontrl", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("overissuecontrl"), "overissuecontrl", precision));
        addNew.set("issinhighlimit", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("issinhighlimit"), "issinhighlimit", precision));
        addNew.set("extraratioqty", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("extraratioqty"), "extraratioqty", precision));
        addNew.set("issinlowlimit", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("issinlowlimit"), "issinlowlimit", precision));
        addNew.set("lackraitioqty", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("lackraitioqty"), "lackraitioqty", precision));
        addNew.set("demanddate", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("demanddate"), "demanddate", precision));
        if (stockentry.containsProperty("processseq")) {
            this.setValue(addNew, "processseq", OutUpdateStockService.addNewEntryValue(stockentry.get("processseq"), "processseq", precision));
        }
        addNew.set("oprno", (Object)OutUpdateStockService.addNewEntryValue(stockentry.get("oprno"), "oprno", precision));
    }

    public static String addNewEntryValue(Object newValue, String colName, int precision) {
        String newValueString = "";
        if (null != newValue) {
            if (newValue instanceof DynamicObject) {
                newValueString = "materialid".equals(colName) ? ((DynamicObject)newValue).getString("masterid.name") : (newValue.toString().contains(",name,") ? ((DynamicObject)newValue).getString("name") : ((DynamicObject)newValue).getPkValue().toString());
            } else if (newValue instanceof Boolean) {
                newValueString = OutUpdateStockService.replaceBooleanField(newValue);
            } else if (newValue instanceof Date) {
                newValueString = new SimpleDateFormat("yyyy/MM/dd HH:mm").format((Date)newValue);
            } else if (StringUtils.equals((CharSequence)"supplymode", (CharSequence)colName)) {
                newValueString = OutUpdateStockService.replaceSupplyMode(newValue);
            } else if (StringUtils.equals((CharSequence)"wastagerateformula", (CharSequence)colName)) {
                newValueString = OutUpdateStockService.replaceWastagerateFormula(newValue);
            } else if (StringUtils.equals((CharSequence)"overissuecontrl", (CharSequence)colName)) {
                newValueString = OutUpdateStockService.replaceOverissueContrl(newValue);
            } else if (StringUtils.equals((CharSequence)"issuemode", (CharSequence)colName)) {
                newValueString = OutUpdateStockService.replaceIssuemode(newValue);
            } else if (StringUtils.equals((CharSequence)"isbackflush", (CharSequence)colName)) {
                newValueString = OutUpdateStockService.replaceIsbackflush(newValue);
            } else if (StringUtils.equals((CharSequence)"scraprate", (CharSequence)colName)) {
                newValueString = ((BigDecimal)newValue).stripTrailingZeros().toPlainString();
            } else if (newValue instanceof BigDecimal) {
                int scale = ((BigDecimal)newValue).scale();
                int scalePrecision = scale > precision ? precision : scale;
                BigDecimal newValueBigDecimal = ((BigDecimal)newValue).setScale(scalePrecision, 4);
                newValueString = newValueBigDecimal.toEngineeringString();
            } else {
                String s = "";
                newValueString = newValue.toString();
            }
        }
        if (newValueString.isEmpty()) {
            newValueString = ResManager.loadKDString((String)"\u65e0", (String)"OutUpdateStockService_6", (String)"bd-mpdm-business", (Object[])new Object[0]);
        }
        return newValueString;
    }

    public static String replaceIsbackflush(Object oldValue) {
        return oldValue.toString().replace("A", ResManager.loadKDString((String)"\u4e0d\u5012\u51b2", (String)"OutUpdateStockService_7", (String)"bd-mpdm-business", (Object[])new Object[0])).replace("B", ResManager.loadKDString((String)"\u59cb\u7ec8\u5012\u51b2", (String)"OutUpdateStockService_8", (String)"bd-mpdm-business", (Object[])new Object[0])).replace("C", ResManager.loadKDString((String)"\u5de5\u4f5c\u4e2d\u5fc3\u51b3\u5b9a\u662f\u5426\u5012\u51b2\u3002", (String)"OutUpdateStockService_9", (String)"bd-mpdm-business", (Object[])new Object[0]));
    }

    public static String replaceIssuemode(Object oldValue) {
        return oldValue.toString().replace("A", ResManager.loadKDString((String)"\u751f\u4ea7\u9886\u6599", (String)"OutUpdateStockService_3", (String)"bd-mpdm-business", (Object[])new Object[0])).replace("B", ResManager.loadKDString((String)"\u76f4\u9001", (String)"OutUpdateStockService_4", (String)"bd-mpdm-business", (Object[])new Object[0])).replace("C", ResManager.loadKDString((String)"\u4e0d\u9886\u6599", (String)"OutUpdateStockService_5", (String)"bd-mpdm-business", (Object[])new Object[0]));
    }

    public static String replaceOverissueContrl(Object oldValue) {
        return oldValue.toString().replace("A", ResManager.loadKDString((String)"\u53ef\u8d85\u53d1", (String)"OutUpdateStockService_10", (String)"bd-mpdm-business", (Object[])new Object[0])).replace("B", ResManager.loadKDString((String)"\u4e0d\u53ef\u8d85\u53d1", (String)"OutUpdateStockService_11", (String)"bd-mpdm-business", (Object[])new Object[0]));
    }

    public static String replaceWastagerateFormula(Object oldValue) {
        return oldValue.toString().replace("A", ResManager.loadKDString((String)"\u6807\u51c6\u7528\u91cf/\uff081-\u635f\u8017\u7387%\uff09\u3002", (String)"OutUpdateStockService_12", (String)"bd-mpdm-business", (Object[])new Object[0])).replace("B", ResManager.loadKDString((String)"\u6807\u51c6\u7528\u91cf*\uff081+\u635f\u8017\u7387%\uff09\u3002", (String)"OutUpdateStockService_13", (String)"bd-mpdm-business", (Object[])new Object[0]));
    }

    public static String replaceBooleanField(Object oldValue) {
        return oldValue.toString().replace("false", ResManager.loadKDString((String)"\u5426", (String)"OutUpdateStockService_14", (String)"bd-mpdm-business", (Object[])new Object[0])).replace("true", ResManager.loadKDString((String)"\u662f", (String)"OutUpdateStockService_15", (String)"bd-mpdm-business", (Object[])new Object[0]));
    }

    public static String replaceSupplyMode(Object oldValue) {
        return oldValue.toString().replace("bd_customer", ResManager.loadKDString((String)"\u5ba2\u6237", (String)"OutUpdateStockService_16", (String)"bd-mpdm-business", (Object[])new Object[0])).replace("bos_org", ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143", (String)"OutUpdateStockService_17", (String)"bd-mpdm-business", (Object[])new Object[0])).replace("bd_supplier", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"OutUpdateStockService_18", (String)"bd-mpdm-business", (Object[])new Object[0]));
    }

    private void insertEntryData(DynamicObject stockEntry, DynamicObject addStockEntry, DynamicObject addBillHead, DynamicObject orderEntryDyn, DynamicObject transactionType) {
        BigDecimal orderQty;
        String billName = addBillHead.getDataEntityType().getName();
        boolean isconsiderloss = transactionType.getBoolean("isconsiderloss");
        DynamicObject materialInv = addStockEntry.getDynamicObject("material");
        DynamicObject mftmaterial = null;
        Long masterid = 0L;
        if (null != materialInv && null != materialInv.getDynamicObject("masterid")) {
            masterid = addStockEntry.getDynamicObject("material").getDynamicObject("masterid").getLong("id");
            DynamicObject bizorg = addBillHead.getDynamicObject("bizorg");
            QFilter mftmaterialFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)Long.parseLong(bizorg.getPkValue().toString()));
            mftmaterialFilter.and(new QFilter("masterid", "=", (Object)masterid));
            mftmaterialFilter.and(new QFilter("enable", "=", (Object)"1"));
            mftmaterialFilter.and(new QFilter("status", "=", (Object)"C"));
            mftmaterial = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialmftinfo", (QFilter[])new QFilter[]{mftmaterialFilter});
        }
        stockEntry.set("materielmasterid", (Object)masterid);
        stockEntry.set("materialid", mftmaterial);
        stockEntry.set("entryconfiguredcode", (Object)addStockEntry.getDynamicObject("configuredcode"));
        stockEntry.set("batchno", (Object)addStockEntry.getString("lotnumber"));
        stockEntry.set("lot", addStockEntry.get("lot"));
        String qtytype = "A";
        stockEntry.set("qtytype", (Object)qtytype);
        BigDecimal useratio = new BigDecimal(100);
        stockEntry.set("useratio", (Object)useratio);
        BigDecimal qtynumerator = addStockEntry.getBigDecimal("baseqty").abs();
        stockEntry.set("qtynumerator", (Object)qtynumerator);
        BigDecimal qtydenominator = orderQty = orderEntryDyn.getBigDecimal("baseqty");
        stockEntry.set("qtydenominator", (Object)orderQty);
        String wastagerateformula = "A";
        stockEntry.set("wastagerateformula", (Object)wastagerateformula);
        DynamicObject unit = addStockEntry.getDynamicObject("baseunit");
        int precision = MPDMMftGenStocksUtils.getPrecision((DynamicObject)unit);
        stockEntry.set("materialunitid", (Object)unit);
        stockEntry.set("allotqty", (Object)BigDecimal.ZERO);
        if (StringUtils.equals((CharSequence)"im_mdc_mftreturnorder", (CharSequence)billName) || StringUtils.equals((CharSequence)"im_mdc_omreturnbill", (CharSequence)billName)) {
            stockEntry.set("rejectedqty", (Object)qtynumerator);
            stockEntry.set("feedingqty", (Object)BigDecimal.ZERO);
            stockEntry.set("iscannegative", (Object)"1");
            stockEntry.set("issuemode", (Object)"C");
        } else {
            stockEntry.set("rejectedqty", (Object)BigDecimal.ZERO);
            stockEntry.set("feedingqty", (Object)qtynumerator);
            stockEntry.set("iscannegative", (Object)"0");
            stockEntry.set("issuemode", (Object)"A");
        }
        stockEntry.set("childauxpropertyid", (Object)addStockEntry.getDynamicObject("auxpty"));
        stockEntry.set("supplymode", (Object)addStockEntry.getString("outownertype"));
        stockEntry.set("supplierid", (Object)addStockEntry.getDynamicObject("outowner"));
        stockEntry.set("supplyorgid", (Object)addBillHead.getDynamicObject("org"));
        stockEntry.set("warehouseid", (Object)addStockEntry.getDynamicObject("warehouse"));
        stockEntry.set("location", (Object)addStockEntry.getDynamicObject("location"));
        stockEntry.set("ecostcenter", addStockEntry.get("ecostcenter"));
        stockEntry.set("isstockallot", (Object)"0");
        stockEntry.set("isbulkmaterial", (Object)"0");
        stockEntry.set("isbackflush", (Object)"A");
        stockEntry.set("iskeypart", (Object)"0");
        stockEntry.set("overissuecontrl", (Object)"B");
        stockEntry.set("leadtime", (Object)BigDecimal.ZERO);
        Date demanddate = addBillHead.getDate("needtime");
        if (null == demanddate) {
            demanddate = orderEntryDyn.getDate("planbegintime");
        }
        stockEntry.set("demanddate", (Object)demanddate);
        stockEntry.set("ismainreplace", (Object)"0");
        String oprno = addStockEntry.getString(this.outEntryOprnoEntity);
        stockEntry.set("oprno", (Object)oprno);
        if (addStockEntry.containsProperty("processseq")) {
            String processseq = addStockEntry.getString("processseq");
            this.setValue(stockEntry, "processseq", processseq);
        }
        stockEntry.set("rework", addStockEntry.get("isrework"));
        if (StringUtils.equals((CharSequence)"im_mdc_mftreturnorder", (CharSequence)billName) || StringUtils.equals((CharSequence)"im_mdc_omreturnbill", (CharSequence)billName)) {
            stockEntry.set("sourcetype", (Object)"E");
        } else {
            stockEntry.set("sourcetype", (Object)"D");
        }
        if (addStockEntry.containsProperty("oprworkcenter")) {
            this.setValue(stockEntry, "oprworkcenter", addStockEntry.get("oprworkcenter"));
        }
        BigDecimal standqty = MPDMMftGenStocksUtils.calculateStandQty((DynamicObject)unit, (String)qtytype, (BigDecimal)useratio.divide(new BigDecimal("100"), 4, 4), (BigDecimal)orderQty, (BigDecimal)qtynumerator, (BigDecimal)qtydenominator);
        stockEntry.set("standqty", (Object)standqty);
        BigDecimal scraprate = stockEntry.getBigDecimal("scraprate");
        BigDecimal fixscrap = stockEntry.getBigDecimal("fixscrap");
        BigDecimal demandqty = MPDMMftGenStocksUtils.calculateDemadQty((int)precision, (boolean)isconsiderloss, (BigDecimal)standqty, (BigDecimal)scraprate, (BigDecimal)fixscrap, (String)wastagerateformula);
        stockEntry.set("demandqty", (Object)demandqty);
        stockEntry.set("extraratioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.add(stockEntry.getBigDecimal("issinhighlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
        stockEntry.set("lackraitioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.subtract(stockEntry.getBigDecimal("issinlowlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
        stockEntry.set("actissueqty", MPDMMftGenStocksUtils.aculActissueQty((DynamicObject)stockEntry));
        stockEntry.set("cansendqty", MPDMMftGenStocksUtils.aculCanSendQty((DynamicObject)stockEntry));
        stockEntry.set("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty((DynamicObject)stockEntry));
        stockEntry.set("useqty", (Object)MPDMMftGenStocksUtils.aculUseQty((DynamicObject)stockEntry, (Object)orderEntryDyn.getPkValue(), (DynamicObject)transactionType, (String)this.orderEntity));
        stockEntry.set("wipqty", (Object)MPDMMftGenStocksUtils.aculWIPQty((DynamicObject)stockEntry));
    }

    private void packageWriteBackCondition(List<DynamicObject> outBills, Map<Long, DynamicObject> feedEntryAndBillMap, Map<Long, Boolean> orderIdAndTransIsUpdateStockMap) {
        HashSet<Long> orderIds = new HashSet<Long>(16);
        if (CollectionUtils.isNotEmpty(outBills)) {
            for (DynamicObject outBill : outBills) {
                DynamicObjectCollection entryCol = outBill.getDynamicObjectCollection("billentry");
                for (DynamicObject eColRow : entryCol) {
                    if (null != entryCol && null != feedEntryAndBillMap) {
                        feedEntryAndBillMap.put(eColRow.getLong("id"), outBill);
                    }
                    orderIds.add(eColRow.getLong("manubillid"));
                }
            }
        }
        if (CollectionUtils.isNotEmpty(orderIds)) {
            QFilter qFilter = new QFilter("id", "in", orderIds);
            String selectFields = "id,transactiontype.isoffrequpdatestock";
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryOrderIdAndTransIsUpdateStockMap", (String)this.orderEntity, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");
            Object object = null;
            try {
                while (dataSet.hasNext()) {
                    Row mftRow = dataSet.next();
                    orderIdAndTransIsUpdateStockMap.put(mftRow.getLong("id"), mftRow.getBoolean("transactiontype.isoffrequpdatestock"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
    }

    private List<DynamicObject> packageWriteBackList(List<DynamicObject> outBills, Map<Long, Boolean> orderIdAndTransIsUpdateStockMap) {
        ArrayList<DynamicObject> writeBackList = new ArrayList<DynamicObject>(10);
        if (CollectionUtils.isNotEmpty(outBills) && null != orderIdAndTransIsUpdateStockMap) {
            for (DynamicObject outBill : outBills) {
                boolean isvirtualbill = outBill.getBoolean("isvirtualbill");
                if (isvirtualbill) continue;
                DynamicObjectCollection entryCol = outBill.getDynamicObjectCollection("billentry");
                for (DynamicObject eColRow : entryCol) {
                    long stockentryid;
                    boolean isUpdateStock = false;
                    Boolean isadd = eColRow.getBoolean("isadd");
                    long manubillid = eColRow.getLong("manubillid");
                    String updatestockresult = eColRow.getString("updatestockresult");
                    if (null != orderIdAndTransIsUpdateStockMap) {
                        boolean bl = isUpdateStock = null == orderIdAndTransIsUpdateStockMap.get(manubillid) ? false : orderIdAndTransIsUpdateStockMap.get(manubillid);
                    }
                    if ((stockentryid = eColRow.getLong("mainbillentryid")) != 0L || !isadd.booleanValue() || !isUpdateStock || "B".equals(updatestockresult)) continue;
                    writeBackList.add(eColRow);
                }
            }
        }
        return writeBackList;
    }

    private void updateMftStockEntry(DynamicObject stockBillEntry, DynamicObject load) {
        DynamicObjectCollection workPlanEntrys = load.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject workPlanEntry : workPlanEntrys) {
            int seqInt = 0;
            if (stockBillEntry.containsProperty("processseq")) {
                String seqStr = stockBillEntry.getString("processseq");
                seqInt = NumberUtils.toInt((String)seqStr);
            }
            boolean isProcessSeq = false;
            String name = load.getDataEntityType().getName();
            if ("prop_manftech".equals(name)) {
                isProcessSeq = true;
            } else {
                boolean bl = isProcessSeq = Integer.parseInt(workPlanEntry.getString("oprparent")) == seqInt;
            }
            if (!isProcessSeq || !StringUtils.equals((CharSequence)workPlanEntry.getString("oprno"), (CharSequence)stockBillEntry.getString("oprno"))) continue;
            stockBillEntry.set("oprno", workPlanEntry.get("oprno"));
            if (workPlanEntry.containsProperty("oprparent")) {
                this.setValue(stockBillEntry, "processseq", workPlanEntry.get("oprparent"));
            }
            if (workPlanEntry.containsProperty("oprworkcenter")) {
                this.setValue(stockBillEntry, "oprworkcenter", workPlanEntry.get("oprworkcenter"));
            }
            if (workPlanEntry.containsProperty("machiningtype")) {
                this.setValue(stockBillEntry, "machiningtype", workPlanEntry.get("machiningtype"));
            }
            stockBillEntry.set("outsupplier", workPlanEntry.get("supplier"));
            stockBillEntry.set("workprocedureid", workPlanEntry.get("oproperation"));
            if (workPlanEntry.containsProperty("workstation")) {
                this.setValue(stockBillEntry, "workstation", workPlanEntry.get("workstation"));
            }
            stockBillEntry.set("operationdesc", workPlanEntry.get("oprdescription"));
        }
    }

    private void clearStockEntryInfo(Set<DynamicObject> deleteEntrys, List<DynamicObject> reqOutBills) {
        if (CollectionUtils.isNotEmpty(deleteEntrys) && null != reqOutBills) {
            String tBillType = reqOutBills.get(0).getDynamicObjectType().getName();
            Long tTableId = ConvertMetaServiceHelper.loadTableDefine((String)tBillType, (String)this.outEntryEntity).getTableId();
            Long sTableId = ConvertMetaServiceHelper.loadTableDefine((String)this.stockEntity, (String)this.stockEntryEntity).getTableId();
            Long tMainTableId = ConvertMetaServiceHelper.loadMainTableDefine((String)tBillType).getTableId();
            Long sMainTableId = ConvertMetaServiceHelper.loadMainTableDefine((String)this.stockEntity).getTableId();
            ArrayList<Object[]> deleteList = new ArrayList<Object[]>(10);
            HashMap<Long, HashSet<Long>> deleteMap = new HashMap<Long, HashSet<Long>>(16);
            for (DynamicObject dynamicObject : reqOutBills) {
                DynamicObjectCollection billeEntrys = dynamicObject.getDynamicObjectCollection(this.outEntryEntity);
                Long reqOutBillId = dynamicObject.getLong("id");
                for (DynamicObject billeEntry : billeEntrys) {
                    HashSet<Long> temp;
                    Long mainbillid = billeEntry.getLong("mainbillid");
                    boolean isadd = billeEntry.getBoolean("isadd");
                    if (!isadd || !deleteEntrys.contains(billeEntry)) continue;
                    billeEntry.set("mainbillentryid", null);
                    billeEntry.set("mainbillentryseq", null);
                    billeEntry.set("updatestockresult", (Object)"A");
                    String reqApplyEntityStr = billeEntry.getString("srcbillentity");
                    if (!this.reqApplyEntity.equals(reqApplyEntityStr)) {
                        billeEntry.set("srcbillentryid", null);
                    }
                    boolean isDeleteFlag = false;
                    HashSet<DynamicObject> deleteSet = new HashSet<DynamicObject>(16);
                    DynamicObjectCollection tagLinkRows = (DynamicObjectCollection)billeEntry.get("billentry_lk");
                    for (DynamicObject tagLinkRow : tagLinkRows) {
                        if (!sTableId.equals(tagLinkRow.getLong("billentry_lk_stableid"))) continue;
                        deleteSet.add(tagLinkRow);
                        isDeleteFlag = true;
                    }
                    if (CollectionUtils.isNotEmpty(deleteSet)) {
                        tagLinkRows.removeAll(deleteSet);
                    }
                    if (null == (temp = (HashSet<Long>)deleteMap.get(reqOutBillId))) {
                        temp = new HashSet<Long>(16);
                    }
                    temp.add(mainbillid);
                    deleteMap.put(reqOutBillId, temp);
                }
            }
            for (Map.Entry entry : deleteMap.entrySet()) {
                Long key = (Long)entry.getKey();
                Set value = (Set)entry.getValue();
                if (!CollectionUtils.isNotEmpty((Collection)value)) continue;
                for (Long aLong : value) {
                    deleteList.add(new Object[]{key, aLong});
                }
            }
            SaveServiceHelper.save((DynamicObject[])reqOutBills.toArray(new DynamicObject[reqOutBills.size()]));
            if (deleteList.size() > 0) {
                String sql = "delete from " + this.outTcTable + " where fttableid = " + tTableId + " and fstableid = " + sTableId + " and ftbillid = ? and fsbillid = ?";
                DBRoute dBRoute = new DBRoute("scm");
                DB.executeBatch((DBRoute)dBRoute, (String)sql, deleteList);
                String trackerSql = "delete from t_botp_billtracker where fttableid = " + tMainTableId + " and fstableid = " + sMainTableId + " and ftbillid = ? and fsbillid = ?";
                DBRoute sysRoute = new DBRoute("sys");
                DB.executeBatch((DBRoute)sysRoute, (String)trackerSql, deleteList);
            }
        }
    }

    private void deleteStockEntrys(Set<Long> stockEntryIds) {
        if (null != stockEntryIds && CollectionUtils.isNotEmpty(stockEntryIds)) {
            DynamicObject[] load;
            HashSet<String> deleteStockEntrySet = new HashSet<String>(16);
            QFilter qFilter = new QFilter("stockentry.id", "in", stockEntryIds);
            HashMap<Object, DynamicObject> pomMftstockMap = new HashMap<Object, DynamicObject>(stockEntryIds.size());
            for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)this.stockEntity, (String)"id,billno,stockentry,stockentry.id", (QFilter[])qFilter.toArray())) {
                pomMftstockMap.put(dynamicObject.getPkValue(), dynamicObject);
            }
            if (null != pomMftstockMap) {
                ArrayList<DynamicObject> saveDyn = new ArrayList<DynamicObject>(16);
                for (Map.Entry dynamicObjectEntry : pomMftstockMap.entrySet()) {
                    DynamicObject mftStockBill = (DynamicObject)dynamicObjectEntry.getValue();
                    ArrayList<DynamicObject> removeEntrys = new ArrayList<DynamicObject>(16);
                    DynamicObjectCollection stockEntrys = mftStockBill.getDynamicObjectCollection(this.stockEntryEntity);
                    for (DynamicObject stockEntry : stockEntrys) {
                        if (!stockEntryIds.contains(stockEntry.getLong("id"))) continue;
                        removeEntrys.add(stockEntry);
                        deleteStockEntrySet.add(stockEntry.getString("id"));
                    }
                    if (removeEntrys.size() > 0) {
                        stockEntrys.removeAll(removeEntrys);
                    }
                    saveDyn.add(mftStockBill);
                }
                if (CollectionUtils.isNotEmpty(saveDyn)) {
                    SaveServiceHelper.save((DynamicObject[])saveDyn.toArray(new DynamicObject[saveDyn.size()]));
                }
            }
            QFilter xLogQFilter = new QFilter("stockentryid", "in", deleteStockEntrySet);
            DeleteServiceHelper.delete((String)this.xstocklogEntity, (QFilter[])new QFilter[]{xLogQFilter});
        }
    }

    private Set<DynamicObject> queryDeleteSrcStockEntrys(List<DynamicObject> reqOutBills) {
        HashSet<DynamicObject> result = new HashSet<DynamicObject>(16);
        if (null != reqOutBills) {
            HashSet<Long> srcStockBillIds = new HashSet<Long>(16);
            HashSet<Long> srcStockEntryIds = new HashSet<Long>(16);
            boolean onlyDirtLink = false;
            for (DynamicObject reqOutBill : reqOutBills) {
                DynamicObjectCollection billEntrys = reqOutBill.getDynamicObjectCollection("billentry");
                for (DynamicObject billEntry : billEntrys) {
                    srcStockBillIds.add(billEntry.getLong("mainbillid"));
                    srcStockEntryIds.add(billEntry.getLong("mainbillentryid"));
                }
            }
            Map<Long, Map<String, HashSet<Long>>> trackInfo = this.findTrackInfo(this.stockEntity, this.stockEntryEntity, srcStockBillIds, srcStockEntryIds, onlyDirtLink);
            for (DynamicObject reqOutBill : reqOutBills) {
                DynamicObjectCollection billEntrys = reqOutBill.getDynamicObjectCollection("billentry");
                for (DynamicObject billEntry : billEntrys) {
                    if (!this.canBeDeleted(billEntry, trackInfo)) continue;
                    result.add(billEntry);
                }
            }
        }
        return result;
    }

    private boolean canBeDeleted(DynamicObject billEntry, Map<Long, Map<String, HashSet<Long>>> trackInfo) {
        boolean result = true;
        if (null != billEntry && null != trackInfo) {
            boolean isAdd = billEntry.getBoolean("isadd");
            if (isAdd) {
                long srcStockEntryId = billEntry.getLong("mainbillentryid");
                long billEntryId = billEntry.getLong("id");
                long srcbillentryid = billEntry.getLong("srcbillentryid");
                String srcbillentity = billEntry.getString("srcbillentity");
                Map<String, HashSet<Long>> trackMap = trackInfo.get(srcStockEntryId);
                if (null != trackMap) {
                    block0: for (Map.Entry<String, HashSet<Long>> hashSetEntry : trackMap.entrySet()) {
                        String billKey = hashSetEntry.getKey();
                        HashSet<Long> valueSet = hashSetEntry.getValue();
                        if (this.outEntity.equals(billKey)) {
                            for (Long aLong : valueSet) {
                                if (aLong.equals(billEntryId)) continue;
                                result = false;
                                logger.info("\u542b\u6709\u5176\u5b83\u4e0b\u6e38\u8865\u6599\u5355");
                                continue block0;
                            }
                            continue;
                        }
                        if (this.reqApplyEntity.equals(srcbillentity)) {
                            for (Long aLong : valueSet) {
                                if (aLong.equals(srcbillentryid)) continue;
                                result = false;
                                logger.info("\u542b\u6709\u5176\u5b83\u4e0b\u6e38\u9886\u6599\u7533\u8bf7\u5355");
                                continue block0;
                            }
                            continue;
                        }
                        result = false;
                        logger.info("\u542b\u6709\u5176\u5b83\u4e0b\u6e38\u5355\uff1a" + billKey);
                        break;
                    }
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    private Map<Long, Map<String, HashSet<Long>>> findTrackInfo(String entityNumber, String entryKey, Set<Long> billIds, Set<Long> entryIds, boolean onlyDirtLink) {
        HashMap<Long, Map<String, HashSet<Long>>> trackInfoMap = new HashMap<Long, Map<String, HashSet<Long>>>(16);
        if (StringUtils.isNotBlank((CharSequence)entityNumber) && StringUtils.isNotBlank((CharSequence)entryKey) && CollectionUtils.isNotEmpty(billIds) && CollectionUtils.isNotEmpty(entryIds)) {
            List bfRowLinkDownNodes;
            OperateOption option = OperateOption.create();
            if (onlyDirtLink) {
                option.setVariableValue("botp_track_only_dirt_link", "true");
            }
            if (null != (bfRowLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)this.stockEntity, (String)"stockentry", (Long[])billIds.toArray(new Long[billIds.size()]), (Long[])entryIds.toArray(new Long[entryIds.size()]), (OperateOption)option))) {
                for (BFRowLinkDownNode bfRowLinkDownNode : bfRowLinkDownNodes) {
                    BFRowId sRowId = bfRowLinkDownNode.getRowId();
                    Long sEntryId = sRowId.getEntryId();
                    HashMap<String, HashSet<Long>> tempMap = (HashMap<String, HashSet<Long>>)trackInfoMap.get(sEntryId);
                    if (null == tempMap) {
                        tempMap = new HashMap<String, HashSet<Long>>(16);
                    }
                    Map tNodes = bfRowLinkDownNode.getTNodes();
                    for (Map.Entry next : tNodes.entrySet()) {
                        BFRowLinkDownNode value = (BFRowLinkDownNode)next.getValue();
                        BFRowId rowId = value.getRowId();
                        Long entryId = rowId.getEntryId();
                        Long mainTableId = rowId.getMainTableId();
                        String tEntityNumber = EntityMetadataCache.loadTableDefine((Long)mainTableId).getEntityNumber();
                        HashSet<Long> tEntityIds = (HashSet<Long>)tempMap.get(tEntityNumber);
                        if (null == tEntityIds) {
                            tEntityIds = new HashSet<Long>(16);
                        }
                        tEntityIds.add(entryId);
                        tempMap.put(tEntityNumber, tEntityIds);
                    }
                    trackInfoMap.put(sEntryId, tempMap);
                }
            }
        }
        return trackInfoMap;
    }

    private void setValue(DynamicObject dyn, String key, Object value) {
        if (ObjectUtils.isNotEmpty((Object)dyn) && dyn.containsProperty(key)) {
            dyn.set(key, value);
        }
    }
}

