/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.mftorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.mftorder.OrderBookDateService;
import kd.bd.mpdm.business.mftorder.OrderCommonService;
import kd.bd.mpdm.business.mftorder.splitmodel.SplitModel;
import kd.bd.mpdm.business.ordersplit.OrderSplitFactory;
import kd.bd.mpdm.common.mftorder.utils.CreateStockByBomUtils;
import kd.bd.mpdm.common.mftorder.utils.CreateStockUtils;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.mftorder.utils.OrderBaseData;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bd.mpdm.common.stockchange.utils.StockChangeUtils;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class StockCulUtils {
    private static final Log logger = LogFactory.getLog(StockCulUtils.class);

    public static void generateStockByOrder(Set<Object> oldOrderEntrySet, Map<Object, List<DynamicObject>> newOrderEntryMap, Map<Object, DynamicObject> newOrderMap, Map<Object, DynamicObject> oldOrderMap, List<DynamicObject> manftechInfos) {
        String stockName = "pom_mftstock";
        String omStockName = "om_mftstock";
        HashSet<Object> pomOrderEntrySetIds = new HashSet<Object>(16);
        HashSet<Object> omOrderEntrySetIds = new HashSet<Object>(16);
        for (Map.Entry<Object, DynamicObject> orderEntry : newOrderMap.entrySet()) {
            String entityNo = orderEntry.getValue().getDataEntityType().getName();
            if ("pom_mftorder".equals(entityNo)) {
                pomOrderEntrySetIds.add(orderEntry.getKey());
                continue;
            }
            if (!"om_mftorder".equals(entityNo)) continue;
            omOrderEntrySetIds.add(orderEntry.getKey());
        }
        Map<Long, DynamicObject> stockMap = StockCulUtils.getStockMap(oldOrderEntrySet, stockName);
        HashMap<Long, DynamicObject> pomStockMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> omStockMap = new HashMap<Long, DynamicObject>(16);
        for (Map.Entry<Long, DynamicObject> entry : stockMap.entrySet()) {
            Long mftentryseq = entry.getKey();
            List<DynamicObject> newOrderEntrys = newOrderEntryMap.get(mftentryseq);
            for (DynamicObject newOrderEntry : newOrderEntrys) {
                if (pomOrderEntrySetIds.contains(newOrderEntry.getPkValue())) {
                    pomStockMap.put(mftentryseq, entry.getValue());
                }
                if (!omOrderEntrySetIds.contains(newOrderEntry.getPkValue())) continue;
                omStockMap.put(mftentryseq, entry.getValue());
            }
        }
        if (!pomStockMap.isEmpty()) {
            Map<Long, DynamicObject> botpPomStockMap = StockCulUtils.getBotpStockMap(stockMap, stockName);
            StockCulUtils.executeStockSplit("pom_mftorder", stockName, newOrderEntryMap, newOrderMap, oldOrderMap, manftechInfos, stockMap, pomOrderEntrySetIds, botpPomStockMap);
        }
        if (!omStockMap.isEmpty()) {
            Map<Long, DynamicObject> botpOmStockMap = StockCulUtils.getBotpStockMap(stockMap, omStockName);
            StockCulUtils.executeStockSplit("pom_mftorder", omStockName, newOrderEntryMap, newOrderMap, oldOrderMap, manftechInfos, stockMap, omOrderEntrySetIds, botpOmStockMap);
        }
    }

    public static void generateStockByOrder(Set<Object> oldOrderEntrySet, Map<Object, List<DynamicObject>> newOrderEntryMap, Map<Object, DynamicObject> newOrderMap, Map<Object, DynamicObject> oldOrderMap, List<DynamicObject> manftechInfos, SplitModel splitModel) {
        String stockName = "pom_mftstock";
        String omStockName = "om_mftstock";
        HashSet<Object> pomOrderEntrySetIds = new HashSet<Object>(16);
        HashSet<Object> omOrderEntrySetIds = new HashSet<Object>(16);
        for (Map.Entry<Object, DynamicObject> orderEntry : newOrderMap.entrySet()) {
            String entityNo = orderEntry.getValue().getDataEntityType().getName();
            if ("pom_mftorder".equals(entityNo)) {
                pomOrderEntrySetIds.add(orderEntry.getKey());
                continue;
            }
            if (!"om_mftorder".equals(entityNo)) continue;
            omOrderEntrySetIds.add(orderEntry.getKey());
        }
        Map<Long, DynamicObject> stockMap = StockCulUtils.getStockMap(oldOrderEntrySet, splitModel.getMftStockEntity());
        HashMap<Long, DynamicObject> pomStockMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> omStockMap = new HashMap<Long, DynamicObject>(16);
        for (Map.Entry<Long, DynamicObject> entry : stockMap.entrySet()) {
            Long mftentryseq = entry.getKey();
            List<DynamicObject> newOrderEntrys = newOrderEntryMap.get(mftentryseq);
            for (DynamicObject newOrderEntry : newOrderEntrys) {
                if (pomOrderEntrySetIds.contains(newOrderEntry.getPkValue())) {
                    pomStockMap.put(mftentryseq, entry.getValue());
                }
                if (!omOrderEntrySetIds.contains(newOrderEntry.getPkValue())) continue;
                omStockMap.put(mftentryseq, entry.getValue());
            }
        }
        if (!pomStockMap.isEmpty()) {
            Map<Long, DynamicObject> botpPomStockMap = StockCulUtils.getBotpStockMap(stockMap, stockName, splitModel.getMftStockEntity(), splitModel.getPushPomMfStockRuleId());
            StockCulUtils.executeStockSplit(splitModel.getMforder(), stockName, newOrderEntryMap, newOrderMap, oldOrderMap, manftechInfos, stockMap, pomOrderEntrySetIds, botpPomStockMap);
        }
        if (!omStockMap.isEmpty()) {
            Map<Long, DynamicObject> botpOmStockMap = StockCulUtils.getBotpStockMap(stockMap, omStockName, splitModel.getMftStockEntity(), splitModel.getPushOmMfStockRuleId());
            StockCulUtils.executeStockSplit(splitModel.getMforder(), omStockName, newOrderEntryMap, newOrderMap, oldOrderMap, manftechInfos, stockMap, omOrderEntrySetIds, botpOmStockMap);
        }
    }

    public static void generateStockByOrderMps(Set<Object> oldOrderEntrySet, Map<Object, List<DynamicObject>> newOrderEntryMap, Map<Object, DynamicObject> newOrderMap, Map<Object, DynamicObject> oldOrderMap, List<DynamicObject> manftechInfos) {
        String stockName = "pom_mftstock";
        String omStockName = "om_mftstock";
        HashSet<Object> pomOrderEntrySetIds = new HashSet<Object>(16);
        HashSet<Object> omOrderEntrySetIds = new HashSet<Object>(16);
        for (Map.Entry<Object, DynamicObject> orderEntry : newOrderMap.entrySet()) {
            String entityNo = orderEntry.getValue().getDataEntityType().getName();
            if ("pom_mftorder".equals(entityNo)) {
                pomOrderEntrySetIds.add(orderEntry.getKey());
                continue;
            }
            if (!"om_mftorder".equals(entityNo)) continue;
            omOrderEntrySetIds.add(orderEntry.getKey());
        }
        Map<Long, DynamicObject> stockMap = StockCulUtils.getStockMap(oldOrderEntrySet, stockName);
        HashMap<Long, DynamicObject> pomStockMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> omStockMap = new HashMap<Long, DynamicObject>(16);
        for (Map.Entry<Long, DynamicObject> entry : stockMap.entrySet()) {
            Long mftentryseq = entry.getKey();
            List<DynamicObject> newOrderEntrys = newOrderEntryMap.get(mftentryseq);
            for (DynamicObject newOrderEntry : newOrderEntrys) {
                if (pomOrderEntrySetIds.contains(newOrderEntry.getPkValue())) {
                    pomStockMap.put(mftentryseq, entry.getValue());
                }
                if (!omOrderEntrySetIds.contains(newOrderEntry.getPkValue())) continue;
                omStockMap.put(mftentryseq, entry.getValue());
            }
        }
        if (!pomStockMap.isEmpty()) {
            Map<Long, DynamicObject> botpPomStockMap = StockCulUtils.getBotpStockMap(stockMap, stockName);
            StockCulUtils.executeStockSplit("mps_scheduleplan", stockName, newOrderEntryMap, newOrderMap, oldOrderMap, manftechInfos, stockMap, pomOrderEntrySetIds, botpPomStockMap);
        }
        if (!omStockMap.isEmpty()) {
            Map<Long, DynamicObject> botpOmStockMap = StockCulUtils.getBotpStockMap(stockMap, omStockName);
            StockCulUtils.executeStockSplit("mps_scheduleplan", omStockName, newOrderEntryMap, newOrderMap, oldOrderMap, manftechInfos, stockMap, omOrderEntrySetIds, botpOmStockMap);
        }
    }

    public static void generateStockByOrderMps(Set<Object> oldOrderEntrySet, Map<Object, List<DynamicObject>> newOrderEntryMap, Map<Object, DynamicObject> newOrderMap, Map<Object, DynamicObject> oldOrderMap, List<DynamicObject> manftechInfos, SplitModel splitModel) {
        String stockName = "pom_mftstock";
        String omStockName = "om_mftstock";
        HashSet<Object> pomOrderEntrySetIds = new HashSet<Object>(16);
        HashSet<Object> omOrderEntrySetIds = new HashSet<Object>(16);
        for (Map.Entry<Object, DynamicObject> orderEntry : newOrderMap.entrySet()) {
            String entityNo = orderEntry.getValue().getDataEntityType().getName();
            if ("pom_mftorder".equals(entityNo)) {
                pomOrderEntrySetIds.add(orderEntry.getKey());
                continue;
            }
            if (!"om_mftorder".equals(entityNo)) continue;
            omOrderEntrySetIds.add(orderEntry.getKey());
        }
        Map<Long, DynamicObject> stockMap = StockCulUtils.getStockMap(oldOrderEntrySet, splitModel.getMftStockEntity());
        HashMap<Long, DynamicObject> pomStockMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> omStockMap = new HashMap<Long, DynamicObject>(16);
        for (Map.Entry<Long, DynamicObject> entry : stockMap.entrySet()) {
            Long mftentryseq = entry.getKey();
            List<DynamicObject> newOrderEntrys = newOrderEntryMap.get(mftentryseq);
            for (DynamicObject newOrderEntry : newOrderEntrys) {
                if (pomOrderEntrySetIds.contains(newOrderEntry.getPkValue())) {
                    pomStockMap.put(mftentryseq, entry.getValue());
                }
                if (!omOrderEntrySetIds.contains(newOrderEntry.getPkValue())) continue;
                omStockMap.put(mftentryseq, entry.getValue());
            }
        }
        if (!pomStockMap.isEmpty()) {
            Map<Long, DynamicObject> botpPomStockMap = StockCulUtils.getBotpStockMap(stockMap, stockName, splitModel.getMftStockEntity(), splitModel.getPushPomMfStockRuleId());
            StockCulUtils.executeStockSplit("mps_scheduleplan", stockName, newOrderEntryMap, newOrderMap, oldOrderMap, manftechInfos, stockMap, pomOrderEntrySetIds, botpPomStockMap);
        }
        if (!omStockMap.isEmpty()) {
            Map<Long, DynamicObject> botpOmStockMap = StockCulUtils.getBotpStockMap(stockMap, omStockName, splitModel.getMftStockEntity(), splitModel.getPushOmMfStockRuleId());
            StockCulUtils.executeStockSplit("mps_scheduleplan", omStockName, newOrderEntryMap, newOrderMap, oldOrderMap, manftechInfos, stockMap, omOrderEntrySetIds, botpOmStockMap);
        }
    }

    private static void executeStockSplit(String splitSrcType, String stockName, Map<Object, List<DynamicObject>> newOrderEntryMap, Map<Object, DynamicObject> newOrderMap, Map<Object, DynamicObject> oldOrderMap, List<DynamicObject> manftechInfos, Map<Long, DynamicObject> stockMap, Set<Object> orderEntrySetIds, Map<Long, DynamicObject> botpStockMap) {
        DynamicObject[] loads;
        ArrayList<DynamicObject> saveStock = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> updateStock = new ArrayList<DynamicObject>(16);
        boolean isEnablePlanScope = false;
        if (StringUtils.equals((CharSequence)"mps_scheduleplan", (CharSequence)splitSrcType)) {
            isEnablePlanScope = (Boolean)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IPlanScopeService", (String)"isEnablePlanScope", (Object[])new Object[0]);
        }
        HashMap<Object, DynamicObject> loadf7Map = new HashMap<Object, DynamicObject>(16);
        if ("pom_mftstock".equals(stockName)) {
            for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)"pom_mftorder_f7", (String)"entryseq,srcsplitbillseq,omsrcsplitbillseq", (QFilter[])new QFilter[]{new QFilter("id", "in", orderEntrySetIds)})) {
                loadf7Map.put(load.getPkValue(), load);
            }
        } else if ("om_mftstock".equals(stockName)) {
            for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)"om_mftorder_f7", (String)"entryseq,srcsplitbillseq,omsrcsplitbillseq,supplier", (QFilter[])new QFilter[]{new QFilter("id", "in", orderEntrySetIds)})) {
                loadf7Map.put(load.getPkValue(), load);
            }
        }
        ArrayList<DynamicObject> saveBomStocks = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> orderList = new ArrayList<DynamicObject>(16);
        for (Map.Entry<Long, DynamicObject> objectEntry : stockMap.entrySet()) {
            Long oldOrderEntry = objectEntry.getKey();
            List<DynamicObject> newOrderEntryList = newOrderEntryMap.get(oldOrderEntry);
            DynamicObject oldStock = stockMap.get(oldOrderEntry);
            if (oldStock == null) continue;
            DynamicObject oldOrder = oldOrderMap.get(oldOrderEntry);
            DynamicObjectCollection oldEntrys = oldOrder.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject oldEntry : oldEntrys) {
                if (!oldEntry.getPkValue().equals(oldOrderEntry)) continue;
                MPDMMftGenStocksUtils.updateStock4ManuChangeBillChange((DynamicObject)oldOrder, (DynamicObject)oldEntry, (DynamicObject)oldStock, (boolean)true, (boolean)false, manftechInfos);
                updateStock.add(oldStock);
            }
            for (DynamicObject newOrderEntry : newOrderEntryList) {
                String number;
                Object linkRows;
                if (!orderEntrySetIds.contains(newOrderEntry.getPkValue())) continue;
                DynamicObject orderStockBotp = botpStockMap.get(oldStock.getPkValue());
                DynamicObject orderStock = (DynamicObject)OrmUtils.clone((IDataEntityBase)orderStockBotp, (boolean)false, (boolean)true);
                orderStock.set("billstatus", (Object)"A");
                Object orderEntryid = newOrderEntry.getPkValue();
                DynamicObject newOrder = newOrderMap.get(orderEntryid);
                DynamicObject trans = newOrder.getDynamicObject("transactiontype");
                orderStock.set("orderid", (Object)newOrder.getPkValue().toString());
                orderStock.set("orderentryid", loadf7Map.get(orderEntryid));
                if ("om_mftstock".equals(stockName)) {
                    orderStock.set("transactiontypeid", (Object)trans);
                } else if ("om_mftstock".equals(oldStock.getDynamicObjectType().getName()) && "pom_mftstock".equals(stockName)) {
                    orderStock.set("transactiontypeid", (Object)trans);
                }
                DynamicObject oldbom = orderStock.getDynamicObject("bomid");
                DynamicObject newbom = newOrderEntry.getDynamicObject("bomid");
                String oldbomid = oldbom == null ? "0" : oldbom.getPkValue().toString();
                String newbomid = newbom == null ? "0" : newbom.getPkValue().toString();
                orderStock.set("bomid", (Object)newbom);
                String stockmaterials = trans.getString("stockmaterials");
                DynamicObjectCollection stockEntrys = orderStock.getDynamicObjectCollection("stockentry");
                DynamicObjectCollection oldStockEntrys = oldStock.getDynamicObjectCollection("stockentry");
                if (CollectionUtils.isEmpty((Collection)oldStockEntrys) && CollectionUtils.isNotEmpty((Collection)stockEntrys)) {
                    stockEntrys.clear();
                    orderStock.set("stockentry", (Object)stockEntrys);
                }
                StockCulUtils.clearQty(stockEntrys);
                if (StringUtils.equals((CharSequence)"mps_scheduleplan", (CharSequence)splitSrcType)) {
                    boolean versionreq = trans.getBoolean("versionreq");
                    if (!oldbomid.equals(newbomid) && "A".equals(stockmaterials) && (versionreq || isEnablePlanScope)) {
                        MPDMMftGenStocksUtils.updateStock4ManuChangeBillChange((DynamicObject)newOrder, (DynamicObject)newOrderEntry, (DynamicObject)orderStock, (boolean)true, (boolean)true, manftechInfos);
                        saveBomStocks.add(orderStock);
                        orderList.add(newOrder);
                        stockEntrys.clear();
                    } else {
                        MPDMMftGenStocksUtils.updateStock4ManuChangeBillChange((DynamicObject)newOrder, (DynamicObject)newOrderEntry, (DynamicObject)orderStock, (boolean)true, (boolean)true, manftechInfos);
                        for (DynamicObject stockEntry : stockEntrys) {
                            DynamicObjectCollection linkRows2 = stockEntry.getDynamicObjectCollection("stockentry_lk");
                            linkRows2.clear();
                        }
                    }
                } else {
                    MPDMMftGenStocksUtils.updateStock4ManuChangeBillChange((DynamicObject)newOrder, (DynamicObject)newOrderEntry, (DynamicObject)orderStock, (boolean)true, (boolean)true, manftechInfos);
                    for (DynamicObject stockEntry : stockEntrys) {
                        linkRows = stockEntry.getDynamicObjectCollection("stockentry_lk");
                        linkRows.clear();
                    }
                }
                String sourceBillType = newOrder.getDynamicObjectType().getName();
                TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)sourceBillType, (String)sourceBillType);
                for (DynamicObject stockEntry : stockEntrys) {
                    DynamicObjectCollection linkRows3 = stockEntry.getDynamicObjectCollection("stockentry_lk");
                    linkRows3.clear();
                    if (!linkRows3.isEmpty()) continue;
                    DynamicObject linkRow = new DynamicObject(linkRows3.getDynamicObjectType());
                    linkRow.set("stockentry_lk_stableid", (Object)srcTableDefine.getTableId());
                    linkRow.set("stockentry_lk_sbillid", orderStock.get("orderid"));
                    linkRow.set("stockentry_lk_sid", orderEntryid);
                    linkRows3.add((Object)linkRow);
                }
                if (stockEntrys.isEmpty()) {
                    linkRows = orderStock.getDynamicObjectCollection("billhead_lk");
                    linkRows.clear();
                    DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
                    linkRow.set("billhead_lk_stableid", (Object)srcTableDefine.getTableId());
                    linkRow.set("billhead_lk_sbillid", orderStock.get("orderid"));
                    linkRow.set("billhead_lk_sid", orderEntryid);
                    linkRows.add((Object)linkRow);
                }
                if ((number = MPDMMftGenStocksUtils.getAutoNumber((DynamicObject)orderStock, (String)orderStock.getDynamicObject("org").getPkValue().toString(), (String)stockName)) == null) {
                    number = "mo_" + orderEntryid;
                }
                orderStock.set("billno", (Object)number);
                saveStock.add(orderStock);
            }
        }
        if (saveBomStocks.size() > 0) {
            logger.info("\u62c6\u5206\u66f4\u65b0\u7ec4\u4ef6\u6e05\u5355\u6309bom\u5c55\u5f00\u5f00\u59cb\u3002");
            OrderBaseData baseData = new OrderBaseData();
            CreateStockUtils.putOrderMap(orderList, (OrderBaseData)baseData, (String)stockName);
            CreateStockByBomUtils.expandBomStocks(saveBomStocks, (OrderBaseData)baseData);
            logger.info("\u62c6\u5206\u66f4\u65b0\u7ec4\u4ef6\u6e05\u5355\u6309bom\u5c55\u5f00\u7ed3\u675f\u3002");
        }
        MPDMMftGenStocksUtils.updateRepPid(saveStock);
        CreateStockByBomUtils.setPStockEntryId(saveStock);
        OperateOption create = OperateOption.create();
        create.setVariableValue("ishasright", "true");
        create.setVariableValue("ignorewarn", "true");
        create.setVariableValue("ignoreinteraction", "true");
        OperationResult saveOperate = SaveServiceHelper.saveOperate((String)stockName, (DynamicObject[])saveStock.toArray(new DynamicObject[saveStock.size()]), (OperateOption)create);
        if (!saveOperate.isSuccess()) {
            String info = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4fdd\u5b58\u7ec4\u4ef6\u6e05\u5355\u5f02\u5e38\u3002", (String)"StockCulUtils_0", (String)"bd-mpdm-business", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)saveOperate));
            throw new KDBizException(new ErrorCode("AutoGenerateStock3", info), new Object[0]);
        }
        SaveServiceHelper.update((DynamicObject[])updateStock.toArray(new DynamicObject[0]));
    }

    private static Map<Long, DynamicObject> getBotpStockMap(Map<Long, DynamicObject> stockMap, String stockName) {
        if ("om_mftstock".equals(stockName)) {
            return StockCulUtils.getBotpStockMap(stockMap, stockName, "pom_mftstock", "1624523645537844224");
        }
        return StockCulUtils.getBotpStockMap(stockMap, stockName, "pom_mftstock", "1381168837650661376");
    }

    private static Map<Long, DynamicObject> getBotpStockMap(Map<Long, DynamicObject> stockMap, String stockName, String srcStockname, String ruleId) {
        HashMap<Long, DynamicObject> botpStockMap = new HashMap<Long, DynamicObject>(16);
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcStockname);
        pushArgs.setTargetEntityNumber(stockName);
        pushArgs.setHasRight(true);
        pushArgs.setRuleId(ruleId);
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(16);
        for (Map.Entry<Long, DynamicObject> m : stockMap.entrySet()) {
            if (m.getValue() == null) continue;
            ListSelectedRow srcBill = new ListSelectedRow(m.getValue().getPkValue());
            needPushRows.add(srcBill);
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)stockName);
        if (!pushResult.isSuccess()) {
            throw new KDBizException(new ErrorCode("StockAutoGenerateStock", MPDMMftGenStocksUtils.getErrByRes((ConvertOperationResult)pushResult)), new Object[0]);
        }
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        for (DynamicObject targetBillObj : targetBillObjs) {
            botpStockMap.put(targetBillObj.getLong("sourcebillid"), targetBillObj);
        }
        return botpStockMap;
    }

    private static void clearQty(DynamicObjectCollection stockEntrys) {
        for (DynamicObject stockEntry : stockEntrys) {
            stockEntry.set("actissueqty", (Object)BigDecimal.ZERO);
            stockEntry.set("useqty", (Object)BigDecimal.ZERO);
            stockEntry.set("rejectedqty", (Object)BigDecimal.ZERO);
            stockEntry.set("feedingqty", (Object)BigDecimal.ZERO);
            stockEntry.set("allotqty", (Object)BigDecimal.ZERO);
            stockEntry.set("scrapqty", (Object)BigDecimal.ZERO);
            stockEntry.set("wipqty", (Object)BigDecimal.ZERO);
            stockEntry.set("outqty", (Object)BigDecimal.ZERO);
        }
    }

    public static void splitLog(Set<Object> oldOrderEntrySet, Map<Object, List<DynamicObject>> newOrderEntryMap, Map<Object, DynamicObject> newOrderMap, Map<Object, DynamicObject> oldOrderMap, Map<Object, Map<String, Object>> splitMap) {
        SplitModel splitModel = OrderSplitFactory.getSplitModel("pom_mftorder");
        StockCulUtils.splitLog(oldOrderEntrySet, newOrderEntryMap, newOrderMap, oldOrderMap, splitMap, splitModel);
    }

    public static void splitLog(Set<Object> oldOrderEntrySet, Map<Object, List<DynamicObject>> newOrderEntryMap, Map<Object, DynamicObject> newOrderMap, Map<Object, DynamicObject> oldOrderMap, Map<Object, Map<String, Object>> splitMap, SplitModel splitModel) {
        ORM orm = ORM.create();
        ArrayList<DynamicObject> splitLogs = new ArrayList<DynamicObject>(16);
        Map<Long, Date> productOrgAndBookDateMap = null;
        HashMap<Long, Date> maxInvOrgAndBookDateMap = new HashMap<Long, Date>(1);
        Map<String, Map<Long, Date>> bookdates = StockCulUtils.queryBookDate(newOrderMap, splitModel.getMforder());
        if (bookdates != null) {
            productOrgAndBookDateMap = bookdates.get("productOrgAndBookDateMap");
        }
        for (Object oldOrderEntry : oldOrderEntrySet) {
            DynamicObject splitLog = CreateStockUtils.getNewDynamicObject((String)splitModel.getSplitLogName(), (ORM)orm);
            DynamicObject oldOrder = oldOrderMap.get(oldOrderEntry);
            DynamicObjectCollection oldEntrys = oldOrder.getDynamicObjectCollection("treeentryentity");
            BigDecimal befsplitqty = BigDecimal.ZERO;
            BigDecimal befsplitbaseqty = BigDecimal.ZERO;
            BigDecimal befauxptyqty = BigDecimal.ZERO;
            Object oldbeginBookdate = null;
            for (DynamicObject oldEntry : oldEntrys) {
                if (!oldEntry.getPkValue().equals(oldOrderEntry)) continue;
                splitLog.set("orderentryid", oldOrderEntry);
                splitLog.set("material", oldEntry.get("material"));
                splitLog.set("materielmasterid", oldEntry.get("materielmasterid"));
                splitLog.set("unit", oldEntry.get("unit"));
                splitLog.set("aftsplitqty", oldEntry.get("qty"));
                befsplitqty = oldEntry.getBigDecimal("qty");
                splitLog.set("baseunit", oldEntry.get("baseunit"));
                splitLog.set("aftsplitbaseqty", oldEntry.get("baseqty"));
                befsplitbaseqty = oldEntry.getBigDecimal("baseqty");
                splitLog.set("auxptyunit", oldEntry.get("auxptyunit"));
                splitLog.set("aftauxptyqty", oldEntry.get("auxptyqty"));
                befauxptyqty = oldEntry.getBigDecimal("auxptyqty");
                oldbeginBookdate = oldEntry.get("beginbookdate");
            }
            splitLog.set("orderid", oldOrder.getPkValue());
            splitLog.set("orderno", oldOrder.get("billno"));
            splitLog.set("org", oldOrder.get("org"));
            splitLog.set("orderstatus", oldOrder.get("billstatus"));
            Date createtime = TimeServiceHelper.now();
            splitLog.set("createtime", (Object)createtime);
            splitLog.set("creator", (Object)UserServiceHelper.getCurrentUser((String)"id"));
            List<DynamicObject> newOrderEntryList = newOrderEntryMap.get(oldOrderEntry);
            for (DynamicObject newOrderEntry : newOrderEntryList) {
                DynamicObject reason;
                Map<String, Object> tempMap;
                DynamicObjectCollection logEntrys = splitLog.getDynamicObjectCollection("billentry");
                DynamicObject logEntry = CreateStockUtils.getNewDynamicObject((String)(splitModel.getSplitLogName() + ".billentry"), (ORM)orm);
                DynamicObject newOrder = newOrderMap.get(newOrderEntry.getPkValue());
                logEntry.set("torderno", newOrder.get("billno"));
                logEntry.set("torderid", newOrder.getPkValue());
                if (newOrder.getDataEntityType().getName().equals("pom_mftorder")) {
                    logEntry.set("torderentryid", newOrderEntry.getPkValue());
                } else if (newOrder.getDataEntityType().getName().equals("om_mftorder")) {
                    logEntry.set("tomorderentryid", newOrderEntry.getPkValue());
                }
                logEntry.set("splitqty", newOrderEntry.get("qty"));
                logEntry.set("splitbaseqty", newOrderEntry.get("baseqty"));
                logEntry.set("splitauxptyqty", newOrderEntry.get("auxptyqty"));
                if (null != splitMap && null != (tempMap = splitMap.get(newOrderEntry.getPkValue())) && null != (reason = (DynamicObject)tempMap.get("splitreason"))) {
                    logEntry.set("splitreason", reason.getPkValue());
                }
                befsplitqty = newOrderEntry.getBigDecimal("qty").add(befsplitqty);
                befsplitbaseqty = newOrderEntry.getBigDecimal("baseqty").add(befsplitbaseqty);
                befauxptyqty = newOrderEntry.getBigDecimal("auxptyqty").add(befauxptyqty);
                Date beginBookDate = null;
                if (oldbeginBookdate != null) {
                    DynamicObject mainProductEntry = OrderCommonService.matchEntryInfo(newOrderEntry, newOrder.getDynamicObjectCollection("treeentryentity"));
                    if (productOrgAndBookDateMap != null && maxInvOrgAndBookDateMap != null) {
                        beginBookDate = OrderBookDateService.queryBookDateWithCompare(newOrder, mainProductEntry, productOrgAndBookDateMap, maxInvOrgAndBookDateMap, createtime, null, false, null, false);
                    }
                }
                logEntry.set("beginbookdate", beginBookDate);
                logEntrys.add((Object)logEntry);
            }
            splitLog.set("befsplitqty", (Object)befsplitqty);
            splitLog.set("befsplitbaseqty", (Object)befsplitbaseqty);
            splitLog.set("befauxptyqty", (Object)befauxptyqty);
            splitLogs.add(splitLog);
        }
        SaveServiceHelper.save((DynamicObject[])splitLogs.toArray(new DynamicObject[0]));
    }

    private static Map<String, Map<Long, Date>> queryBookDate(Map<Object, DynamicObject> newOrderMap, String srcOrderName) {
        DynamicObject[] manuBills;
        Map<String, Map<Long, Date>> bookDateMap = new HashMap<String, Map<Long, Date>>(16);
        HashSet<Long> orderEntryIds = new HashSet<Long>(10);
        String entityType = "pom_mftorder";
        for (Map.Entry<Object, DynamicObject> item : newOrderMap.entrySet()) {
            DynamicObject orderBill = item.getValue();
            if (null == orderBill) continue;
            entityType = orderBill.getDataEntityType().getName();
            DynamicObjectCollection orderEntrys = orderBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntrys) {
                if (null == orderEntry) continue;
                orderEntryIds.add(orderEntry.getLong("id"));
            }
        }
        if (!orderEntryIds.isEmpty() && (manuBills = OrderCommonService.queryManuBills(orderEntryIds, srcOrderName)) != null && manuBills.length > 0) {
            bookDateMap = OrderBookDateService.makeupOrgDates(orderEntryIds, manuBills);
        }
        return bookDateMap;
    }

    private static Map<Long, DynamicObject> getStockMap(Set<Object> oldOrderEntry, String stockName) {
        DynamicObject[] stockDyms = BusinessDataServiceHelper.load((String)stockName, (String)StockCulUtils.selectStockProperties(stockName), (QFilter[])new QFilter[]{new QFilter("orderentryid", "in", oldOrderEntry)});
        HashMap<Long, DynamicObject> stockMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject stockDym : stockDyms) {
            stockMap.put((Long)stockDym.getDynamicObject("orderentryid").getPkValue(), stockDym);
        }
        return stockMap;
    }

    public static String selectStockProperties(String stockName) {
        StringBuilder sb = new StringBuilder("id,");
        sb.append("stockentry_lk,");
        sb.append("stockentry_lk_stableid,");
        sb.append("stockentry_lk_sbillid,");
        sb.append("stockentry_lk_sid");
        Set stockFields = StockChangeUtils.getAllStockFields((String)StockChangeUtils.getEntityName((int)1, (int)3, (String)stockName));
        for (String fields : stockFields) {
            sb.append(",");
            sb.append(fields);
        }
        Set stockEntryFields = StockChangeUtils.getAllStockEentryFields((String)StockChangeUtils.getEntityName((int)1, (int)3, (String)stockName));
        for (String stockField : stockEntryFields) {
            sb.append(",");
            sb.append("stockentry");
            sb.append(".");
            sb.append(stockField);
        }
        return sb.toString();
    }

    public static DynamicObject[] queryStocks(Set<Long> orderEntryIds) {
        QFilter filters = new QFilter("orderentryid", "in", orderEntryIds);
        String selectProperties = "stockentry.actissueqty,stockentry.rejectedqty,stockentry.feedingqty,orderentryid";
        return BusinessDataServiceHelper.load((String)"pom_mftstock", (String)selectProperties, (QFilter[])filters.toArray());
    }

    public static DynamicObject matchStockBill(DynamicObject[] stockBillcol, long mftorderEntryId) {
        DynamicObject result = null;
        for (DynamicObject stockBill : stockBillcol) {
            if (null == stockBill || null == stockBill.getDynamicObject("orderentryid") || stockBill.getDynamicObject("orderentryid").getLong("id") != mftorderEntryId) continue;
            result = stockBill;
            break;
        }
        return result;
    }

    @Deprecated
    public static boolean canAllSplitFlag(DynamicObject stockBill) {
        return true;
    }

    public static DynamicObject[] queryOmStocks(Set<Long> orderEntryIds) {
        QFilter filters = new QFilter("orderentryid", "in", orderEntryIds);
        String selectProperties = "stockentry.actissueqty,stockentry.rejectedqty,stockentry.feedingqty,orderentryid";
        return BusinessDataServiceHelper.load((String)"om_mftstock", (String)selectProperties, (QFilter[])filters.toArray());
    }
}

