/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.mftorder.validate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.mftorder.OrderQualityOrgService;
import kd.bd.mpdm.common.mftorder.enums.PrecisionAccountEnum;
import kd.bd.mpdm.common.mftorder.helper.BillUnitAndQtytHelper;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsBomQueryHelper;
import kd.bd.mpdm.common.utils.AuxQtyAndUnitHelper;
import kd.bd.mpdm.common.utils.UnitPrecisionUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OrderAutoSetDefaultValueService {
    private static final Log logger = LogFactory.getLog(OrderAutoSetDefaultValueService.class);
    private static final String[] NOCOPYENTRYFIELDS = new String[]{"configuredcode", "tracknumber", "auxptyqty"};
    private static final String[] FILEDS = new String[]{"supplier", "purorg", "producedept", "sourcebilltype", "sourcebillnumber", "sourceentryseq"};

    public static void assignPlanQty(DynamicObject[] objs) {
        HashSet<Object> mftIDSet = new HashSet<Object>(16);
        HashSet<Object> mIDSet = new HashSet<Object>(16);
        HashMap<Object, Object> mftToMaterialMap = new HashMap<Object, Object>();
        for (DynamicObject bill : objs) {
            DynamicObjectCollection orderEntryEntitys = bill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntryEntitys) {
                DynamicObject mftMaterialInfo;
                String productType = orderEntry.getString("producttype");
                if (!StringUtils.equals((CharSequence)"C", (CharSequence)productType) || null == (mftMaterialInfo = orderEntry.getDynamicObject("material"))) continue;
                if (mftMaterialInfo.getDynamicObject("masterid") == null) {
                    mftIDSet.add(mftMaterialInfo.getPkValue());
                    continue;
                }
                DynamicObject material = mftMaterialInfo.getDynamicObject("masterid");
                if (material == null) {
                    mftIDSet.add(mftMaterialInfo.getPkValue());
                    continue;
                }
                mIDSet.add(material.getPkValue());
                mftToMaterialMap.put(mftMaterialInfo.getPkValue(), material.getPkValue());
            }
        }
        if (!mftIDSet.isEmpty()) {
            Map mftMap = MaterialMftQueryHelper.getDataCacheBySet(mftIDSet);
            for (Map.Entry entry : mftMap.entrySet()) {
                DynamicObject material;
                DynamicObject mftMaterialInfo = (DynamicObject)entry.getValue();
                if (mftMaterialInfo.getDynamicObject("masterid") == null || (material = mftMaterialInfo.getDynamicObject("masterid")) == null) continue;
                mIDSet.add(material.getPkValue());
                mftToMaterialMap.put(mftMaterialInfo.getPkValue(), material.getPkValue());
            }
        }
        Map materialMap = new HashMap(16);
        if (!mIDSet.isEmpty()) {
            materialMap = MaterialQueryHelper.getDataCacheBySet(mIDSet);
        }
        for (DynamicObject bill : objs) {
            DynamicObjectCollection orderEntryEntitys = bill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntryEntitys) {
                DynamicObject material;
                Object materialID;
                DynamicObject mftMaterialInfo;
                String productType = orderEntry.getString("producttype");
                if (!StringUtils.equals((CharSequence)"C", (CharSequence)productType) || null == (mftMaterialInfo = orderEntry.getDynamicObject("material")) || null == (materialID = mftToMaterialMap.get(mftMaterialInfo.getPkValue())) || null == (material = (DynamicObject)materialMap.get(materialID))) continue;
                DynamicObject baseunitDO = material.getDynamicObject("baseunit");
                BigDecimal baseQty = orderEntry.getBigDecimal("baseqty");
                DynamicObject auxunitDO = material.getDynamicObject("auxptyunit");
                if (null == auxunitDO) continue;
                BigDecimal auxunitQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)baseunitDO, (BigDecimal)baseQty, (DynamicObject)auxunitDO);
                orderEntry.set("auxptyqty", (Object)auxunitQty);
            }
        }
    }

    public static void autoGenEntryByBom(DynamicObject[] objs, String entityId) {
        ORM orm = ORM.create();
        if (StringUtils.isEmpty((CharSequence)entityId)) {
            entityId = objs[0].getDataEntityType().getName();
        }
        Date currentDate = new Date();
        Map<String, Map> mMap = OrderAutoSetDefaultValueService.initBatchQueryMap(objs);
        Map mftMap = mMap == null ? null : mMap.get("mftMap");
        Map materialMap = mMap == null ? null : mMap.get("materialMap");
        for (DynamicObject bill : objs) {
            int seq = 1;
            DynamicObjectCollection orderEntryEntitys = bill.getDynamicObjectCollection("treeentryentity");
            ArrayList<DynamicObject> newOrderEntryList = new ArrayList<DynamicObject>(16);
            for (DynamicObject orderEntry : orderEntryEntitys) {
                String productType = orderEntry.getString("producttype");
                long sourceentryseq = 0L;
                if (!StringUtils.equals((CharSequence)"C", (CharSequence)productType)) continue;
                sourceentryseq = orderEntry.getLong("sourceentryseq");
                orderEntry.set("seq", (Object)seq);
                ++seq;
                newOrderEntryList.add(orderEntry);
                DynamicObject bom = orderEntry.getDynamicObject("bomid");
                if (bom == null || !bom.getBoolean("iscoproduct")) continue;
                bom = MsBomQueryHelper.getDataCacheByID((Object)bom.getPkValue());
                Date expendbomtime = orderEntry.getDate("expendbomtime");
                if (null == expendbomtime) {
                    expendbomtime = currentDate;
                }
                BigDecimal mainBaseqty = orderEntry.getBigDecimal("baseqty");
                DynamicObjectCollection bomentry = bom.getDynamicObjectCollection("copentry");
                for (DynamicObject coproduct : bomentry) {
                    DynamicObject dymftmaterial = (DynamicObject)coproduct.get("copentrymaterial");
                    DynamicObject mftmaterial = mftMap == null ? null : (DynamicObject)mftMap.get(dymftmaterial.getPkValue());
                    if (mftmaterial == null || !mftmaterial.getBoolean("isjointproduct")) continue;
                    Date copentryvaliddate = coproduct.getDate("copentryvaliddate");
                    Date copentryinvaliddate = coproduct.getDate("copentryinvaliddate");
                    if (expendbomtime.before(copentryvaliddate) || expendbomtime.after(copentryinvaliddate)) continue;
                    DynamicObject newEntry = OrderAutoSetDefaultValueService.createNewDynamicObject(entityId + "." + "treeentryentity", orm);
                    for (String string : FILEDS) {
                        if (!newEntry.containsProperty(string) || null == orderEntry.get(string) || Arrays.asList(NOCOPYENTRYFIELDS).contains(string)) continue;
                        newEntry.set(string, orderEntry.get(string));
                    }
                    newEntry.set("sourceentryseq", (Object)sourceentryseq);
                    newEntry.set("pid", orderEntry.get("id"));
                    newEntry.set("producttype", (Object)("10720".equals(coproduct.getString("copentrytype")) ? "A" : "B"));
                    newEntry.set("material", coproduct.get("copentrymaterial"));
                    DynamicObject copentryauxproperty = coproduct.getDynamicObject("copentryauxproperty");
                    newEntry.set("auxproperty", (Object)copentryauxproperty);
                    DynamicObject material = (DynamicObject)mftmaterial.get("masterid");
                    newEntry.set("materielmasterid", (Object)material);
                    material = materialMap == null ? null : (DynamicObject)materialMap.get(material.getPkValue());
                    if (null == material || null == mftmaterial) continue;
                    newEntry.set("unit", mftmaterial.get("mftunit"));
                    DynamicObject baseunitDO = material.getDynamicObject("baseunit");
                    DynamicObject unitDO = mftmaterial.getDynamicObject("mftunit");
                    DynamicObject auxunitDO = material.getDynamicObject("auxptyunit");
                    int precision = baseunitDO.getInt("precision");
                    String precisionAccount = baseunitDO.getString("precisionaccount");
                    BigDecimal baseQty = coproduct.getBigDecimal("copentryqty").multiply(mainBaseqty).setScale(precision, PrecisionAccountEnum.getEnumByVal((int)Integer.parseInt(precisionAccount)));
                    BigDecimal qty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)baseunitDO, (BigDecimal)baseQty, (DynamicObject)unitDO);
                    newEntry.set("baseunit", (Object)baseunitDO);
                    newEntry.set("auxptyunit", (Object)auxunitDO);
                    newEntry.set("planstatus", orderEntry.get("planstatus"));
                    newEntry.set("taskstatus", orderEntry.get("taskstatus"));
                    newEntry.set("bizstatus", orderEntry.get("bizstatus"));
                    newEntry.set("producedept", orderEntry.get("producedept"));
                    newEntry.set("tracknumber", orderEntry.get("tracknumber"));
                    newEntry.set("bdproject", orderEntry.get("bdproject"));
                    newEntry.set("planscope", orderEntry.get("planscope"));
                    newEntry.set("supplyrule", orderEntry.get("supplyrule"));
                    newEntry.set("qty", (Object)qty);
                    newEntry.set("baseqty", (Object)baseQty);
                    newEntry.set("planqty", (Object)qty);
                    newEntry.set("planbaseqty", (Object)baseQty);
                    newEntry.set("planbegintime", orderEntry.get("planbegintime"));
                    newEntry.set("planpreparetime", orderEntry.get("planpreparetime"));
                    newEntry.set("planendtime", orderEntry.get("planendtime"));
                    newEntry.set("expendbomtime", orderEntry.get("expendbomtime"));
                    newEntry.set("inwardept", orderEntry.get("inwardept"));
                    newEntry.set("routereplace", orderEntry.get("routereplace"));
                    newEntry.set("processroute", orderEntry.get("processroute"));
                    newEntry.set("workcenter", orderEntry.get("workcenter"));
                    newEntry.set("pickstatus", orderEntry.get("pickstatus"));
                    newEntry.set("outputoperation", coproduct.get("copentryoperation"));
                    newEntry.set("bomid", (Object)bom);
                    newEntry.set("materialspread", orderEntry.get("materialspread"));
                    newEntry.set("seq", (Object)seq);
                    ++seq;
                    if (null != auxunitDO) {
                        AuxQtyAndUnitHelper.changeUntAndQty((DynamicObject)newEntry, (DynamicObject)material, (DynamicObject)auxunitDO, (String)"baseqty", (String)"baseunit", (String)"auxptyqty");
                    }
                    newEntry.setParent((Object)bill);
                    newOrderEntryList.add(newEntry);
                }
            }
            if (null == newOrderEntryList) continue;
            orderEntryEntitys.clear();
            for (DynamicObject newEntry : newOrderEntryList) {
                newEntry.setParent((Object)bill);
            }
            orderEntryEntitys.addAll(newOrderEntryList);
            logger.info("OrderSaveBeforeExeOp newOrderEntryList size:" + newOrderEntryList.size());
        }
    }

    private static DynamicObject createNewDynamicObject(String entityID, ORM orm) {
        return orm.newDynamicObject(entityID);
    }

    private static Map<String, Map> initBatchQueryMap(DynamicObject[] objs) {
        HashMap<String, Map> returnMap = new HashMap<String, Map>(16);
        HashSet<Object> mftIDSet = new HashSet<Object>(16);
        HashSet<Object> mIDSet = new HashSet<Object>(16);
        for (DynamicObject bill : objs) {
            DynamicObjectCollection orderEntryEntitys = bill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntryEntitys) {
                DynamicObject bom;
                String productType = orderEntry.getString("producttype");
                if (!StringUtils.equals((CharSequence)"C", (CharSequence)productType) || (bom = orderEntry.getDynamicObject("bomid")) == null || !bom.getBoolean("iscoproduct")) continue;
                DynamicObjectCollection bomentry = bom.getDynamicObjectCollection("copentry");
                for (DynamicObject coproduct : bomentry) {
                    DynamicObject dymftmaterial = (DynamicObject)coproduct.get("copentrymaterial");
                    mftIDSet.add(dymftmaterial.getPkValue());
                }
            }
        }
        Map mftMap = MaterialMftQueryHelper.getDataCacheBySet(mftIDSet);
        if (null != mftMap) {
            for (Map.Entry entry : mftMap.entrySet()) {
                DynamicObject mftMaterialInfo = (DynamicObject)entry.getValue();
                DynamicObject material = (DynamicObject)mftMaterialInfo.get("masterid");
                mIDSet.add(material.getPkValue());
            }
        }
        Map materialMap = MaterialQueryHelper.getDataCacheBySet(mIDSet);
        returnMap.put("materialMap", materialMap);
        returnMap.put("mftMap", mftMap);
        return returnMap;
    }

    public static void assignQualityOrg(DynamicObject[] objs) {
        HashMap<Long, DynamicObject> cacheMap = new HashMap<Long, DynamicObject>(16);
        HashMap<String, ArrayList<DynamicObject>> orderEntryMap = new HashMap<String, ArrayList<DynamicObject>>(16);
        HashSet<Object> materialIDSet = new HashSet<Object>(16);
        ArrayList<Object> qcOrgIDList = new ArrayList<Object>(16);
        for (DynamicObject bill : objs) {
            DynamicObject initOrg;
            DynamicObject mftOrg = bill.getDynamicObject("org");
            long mftOrgId = mftOrg.getLong("id");
            if (cacheMap.containsKey(mftOrgId)) {
                initOrg = (DynamicObject)cacheMap.get(mftOrgId);
            } else {
                long initOrgId = OrderQualityOrgService.queryFisqcInitOrgId(mftOrgId, "fisqc", "06");
                initOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)initOrgId, (String)"bos_org", (String)"id");
                cacheMap.put(mftOrgId, initOrg);
            }
            Long initOrgPkValue = null == initOrg ? 0L : initOrg.getLong("id");
            if (null != initOrg && !qcOrgIDList.contains(initOrg.getPkValue())) {
                qcOrgIDList.add(initOrg.getPkValue());
            }
            DynamicObjectCollection orderEntryEntitys = bill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntryEntitys) {
                orderEntry.set("qualityorg", (Object)initOrg);
                DynamicObject mftmaterial = orderEntry.getDynamicObject("material");
                DynamicObject bdmaterial = mftmaterial.getDynamicObject("masterid");
                Object pkValue = bdmaterial.getPkValue();
                materialIDSet.add(pkValue);
                orderEntry.set("isinspection", (Object)false);
                ArrayList<DynamicObject> orderEntryList = (ArrayList<DynamicObject>)orderEntryMap.get(pkValue + "_" + initOrgPkValue);
                if (orderEntryList == null) {
                    orderEntryList = new ArrayList<DynamicObject>(16);
                }
                orderEntryList.add(orderEntry);
                orderEntryMap.put(pkValue + "_" + initOrgPkValue, orderEntryList);
            }
        }
        for (int i = 0; i < qcOrgIDList.size(); ++i) {
            Long qcOrgID = (Long)qcOrgIDList.get(i);
            Set<String> materialQcIdSet = OrderQualityOrgService.queryMaterialQCIsTrueInfo(materialIDSet, qcOrgID);
            if (materialQcIdSet == null || materialQcIdSet.isEmpty()) continue;
            for (Map.Entry orderEntrymaps : orderEntryMap.entrySet()) {
                String keys = (String)orderEntrymaps.getKey();
                if (!materialQcIdSet.contains(keys)) continue;
                List orderEntryList = (List)orderEntrymaps.getValue();
                for (int k = 0; k < orderEntryList.size(); ++k) {
                    DynamicObject orderEntry = (DynamicObject)orderEntryList.get(k);
                    orderEntry.set("isinspection", (Object)true);
                }
            }
        }
    }

    public static Map<Object, DynamicObject> querymftmaterials(DynamicObject[] objs) {
        Map result = null;
        HashSet<Object> mftmaterialPkValues = new HashSet<Object>(16);
        for (DynamicObject bill : objs) {
            DynamicObjectCollection orderEntryEntitys = bill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntryEntitys) {
                DynamicObject mftmaterial = orderEntry.getDynamicObject("material");
                if (mftmaterial == null) continue;
                mftmaterialPkValues.add(mftmaterial.getPkValue());
            }
        }
        if (!mftmaterialPkValues.isEmpty()) {
            result = BusinessDataServiceHelper.loadFromCache((String)"bd_materialmftinfo", (String)"isreportlimit,rpthighlimit,rptlowlimit,isstoragelimit,rcvinlowlimit,rcvinhighlimit", (QFilter[])new QFilter[]{new QFilter("id", "in", mftmaterialPkValues)});
        }
        return result;
    }

    public static void assignIndeptQty(DynamicObject[] objs, Map<Object, DynamicObject> mftmaterialMap) {
        for (DynamicObject bill : objs) {
            DynamicObjectCollection orderEntryEntitys = bill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntryEntitys) {
                BigDecimal demandQty;
                DynamicObject mftmaterial = orderEntry.getDynamicObject("material");
                if (mftmaterial == null || null == mftmaterialMap || null == mftmaterialMap.get(mftmaterial.getPkValue())) continue;
                mftmaterial = mftmaterialMap.get(mftmaterial.getPkValue());
                BigDecimal rcvinhighlimit = mftmaterial.getBigDecimal("rcvinhighlimit");
                BigDecimal rcvinlowlimit = mftmaterial.getBigDecimal("rcvinlowlimit");
                orderEntry.set("rcvinhighlimit", (Object)rcvinhighlimit);
                orderEntry.set("rcvinlowlimit", (Object)rcvinlowlimit);
                boolean isstoragelimit = mftmaterial.getBoolean("isstoragelimit");
                orderEntry.set("iscontrolqty", (Object)isstoragelimit);
                BigDecimal inwarmax = demandQty = orderEntry.getBigDecimal("baseqty");
                BigDecimal inwarmin = demandQty;
                if (isstoragelimit) {
                    inwarmax = OrderAutoSetDefaultValueService.calHighQty(orderEntry);
                    inwarmin = OrderAutoSetDefaultValueService.calLowQty(orderEntry);
                }
                orderEntry.set("inwarmax", (Object)inwarmax);
                orderEntry.set("inwarmin", (Object)inwarmin);
            }
        }
    }

    public static void assignRptQty(DynamicObject[] objs, Map<Object, DynamicObject> mftmaterialMap) {
        for (DynamicObject bill : objs) {
            DynamicObjectCollection orderEntryEntitys = bill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntryEntitys) {
                DynamicObject unit;
                BigDecimal qty;
                DynamicObject mftmaterial = orderEntry.getDynamicObject("material");
                if (mftmaterial == null || null == mftmaterialMap || null == mftmaterialMap.get(mftmaterial.getPkValue())) continue;
                mftmaterial = mftmaterialMap.get(mftmaterial.getPkValue());
                boolean isreportlimit = mftmaterial.getBoolean("isreportlimit");
                BigDecimal repmaxrate = mftmaterial.getBigDecimal("rpthighlimit");
                BigDecimal repminrate = mftmaterial.getBigDecimal("rptlowlimit");
                orderEntry.set("repmaxrate", (Object)repmaxrate);
                orderEntry.set("repminrate", (Object)repminrate);
                orderEntry.set("isconreportqty", (Object)isreportlimit);
                BigDecimal repmaxqty = qty = orderEntry.getBigDecimal("qty");
                BigDecimal repminqty = qty;
                if (isreportlimit && null != (unit = orderEntry.getDynamicObject("unit"))) {
                    repmaxqty = qty.multiply(BigDecimal.ONE.add(repmaxrate.divide(BigDecimal.valueOf(100L), unit.getInt("precision"), UnitPrecisionUtils.getPrecisionDeal((String)unit.getString("precisionaccount")))));
                    repminqty = qty.multiply(BigDecimal.ONE.subtract(repminrate.divide(BigDecimal.valueOf(100L), unit.getInt("precision"), UnitPrecisionUtils.getPrecisionDeal((String)unit.getString("precisionaccount")))));
                }
                orderEntry.set("repmaxqty", (Object)repmaxqty);
                orderEntry.set("repminqty", (Object)repminqty);
            }
        }
    }

    private static BigDecimal calHighQty(DynamicObject orderEntry) {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal demandQty = orderEntry.getBigDecimal("baseqty");
        BigDecimal highlimit = orderEntry.getBigDecimal("rcvinhighlimit");
        DynamicObject baseunit = orderEntry.getDynamicObject("baseunit");
        if (baseunit != null) {
            int baseprecision = baseunit.getInt("precision");
            String baseprecisionaccount = baseunit.getString("precisionaccount");
            int basepresisiondeal = UnitPrecisionUtils.getPrecisionDeal((String)baseprecisionaccount);
            bigDecimal = demandQty.multiply(BigDecimal.ONE.add(highlimit.divide(BigDecimal.valueOf(100L), 4, 4)));
            bigDecimal = bigDecimal.setScale(baseprecision, basepresisiondeal);
        }
        return bigDecimal;
    }

    private static BigDecimal calLowQty(DynamicObject orderEntry) {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal demandQty = orderEntry.getBigDecimal("baseqty");
        BigDecimal highlimit = orderEntry.getBigDecimal("rcvinlowlimit");
        DynamicObject baseunit = orderEntry.getDynamicObject("baseunit");
        if (baseunit != null) {
            int baseprecision = baseunit.getInt("precision");
            String baseprecisionaccount = baseunit.getString("precisionaccount");
            int basepresisiondeal = UnitPrecisionUtils.getPrecisionDeal((String)baseprecisionaccount);
            bigDecimal = demandQty.multiply(BigDecimal.ONE.subtract(highlimit.divide(BigDecimal.valueOf(100L), 4, 4)));
            bigDecimal = bigDecimal.setScale(baseprecision, basepresisiondeal);
        }
        return bigDecimal;
    }
}

