/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.mftorder.validate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.enums.ManuBillBizStatusEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillProductTypeEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillTaskStatusEnum;
import kd.bd.mpdm.common.mftorder.enums.billIdentity.MftManftechIdentityEnum;
import kd.bd.mpdm.common.mftorder.helper.BillUnitAndQtytHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;

public class OrderSplitValidateService {
    private static Log logger = LogFactory.getLog(OrderSplitValidateService.class);

    public static Set<Long> querySplitBillInSplitLogs(List<Object> orderEntryIds, List<String> orderStatusList) {
        return OrderSplitValidateService.querySplitBillInSplitLogs(orderEntryIds, orderStatusList, "pom_mftorder_splitlog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> querySplitBillInSplitLogs(List<Object> orderEntryIds, List<String> orderStatusList, String splitLogEntity) {
        HashSet<Long> result = new HashSet<Long>(10);
        if (null != orderEntryIds && !orderEntryIds.isEmpty()) {
            QFilter filter = new QFilter("orderentryid", "in", orderEntryIds);
            if (null != orderStatusList && orderStatusList.size() > 0) {
                filter.and(new QFilter("orderstatus", "in", orderStatusList));
            }
            DataSet dataSet = null;
            try {
                dataSet = QueryServiceHelper.queryDataSet((String)"OrderSplitValidateService.querySplitBillInSplitLogs", (String)splitLogEntity, (String)"orderentryid", (QFilter[])new QFilter[]{filter}, null);
                if (null != dataSet) {
                    for (Row row : dataSet) {
                        Long orderentryidInSplitLog = row.getLong("orderentryid");
                        result.add(orderentryidInSplitLog);
                    }
                }
            }
            finally {
                if (null != dataSet) {
                    dataSet.close();
                }
            }
        }
        return result;
    }

    public static Set<Long> queryPushedManftechMftentryPkvalus(String entityKey, Set<Long> orderEntryPkValueList) {
        List<DynamicObject> manftechInfos = OrderSplitValidateService.queryPushedManftechInfos(entityKey, orderEntryPkValueList);
        return OrderSplitValidateService.manftechValFail(manftechInfos);
    }

    public static Set<Long> manftechValFail(List<DynamicObject> manftechInfos) {
        HashSet<Long> mftentryPkvalus = new HashSet<Long>(10);
        ArrayList<String> manftechStatusList = new ArrayList<String>(10);
        manftechStatusList.add("F");
        manftechStatusList.add("G");
        for (DynamicObject manftechInfo : manftechInfos) {
            DynamicObject mftentryseq = manftechInfo.getDynamicObject("mftentryseq");
            if (null == mftentryseq) continue;
            long mftentryseqId = mftentryseq.getLong("id");
            boolean valPassFlag = true;
            DynamicObjectCollection oprentryentity = manftechInfo.getDynamicObjectCollection("oprentryentity");
            if (null == oprentryentity || oprentryentity.isEmpty()) {
                valPassFlag = false;
            } else {
                for (DynamicObject oprentry : oprentryentity) {
                    if (null == oprentry || manftechStatusList.contains(oprentry.getString("oprstatus")) || oprentry.getBoolean("oprinvalid")) continue;
                    valPassFlag = false;
                    break;
                }
            }
            if (!valPassFlag) continue;
            mftentryPkvalus.add(mftentryseqId);
        }
        return mftentryPkvalus;
    }

    public static Set<Long> manftechOmValFail(List<DynamicObject> manftechInfos) {
        HashSet<Long> mftentryPkvalus = new HashSet<Long>(10);
        ArrayList<String> manftechStatusList = new ArrayList<String>(10);
        manftechStatusList.add("E");
        manftechStatusList.add("F");
        manftechStatusList.add("G");
        for (DynamicObject manftechInfo : manftechInfos) {
            DynamicObject mftentryseq = manftechInfo.getDynamicObject("mftentryseq");
            if (null == mftentryseq) continue;
            long mftentryseqId = mftentryseq.getLong("id");
            boolean valPassFlag = false;
            DynamicObjectCollection oprentryentity = manftechInfo.getDynamicObjectCollection("oprentryentity");
            if (null == oprentryentity || oprentryentity.isEmpty()) {
                valPassFlag = false;
            } else {
                for (DynamicObject oprentry : oprentryentity) {
                    if (null == oprentry || !manftechStatusList.contains(oprentry.getString("oprstatus"))) continue;
                    valPassFlag = true;
                    break;
                }
            }
            if (!valPassFlag) continue;
            mftentryPkvalus.add(mftentryseqId);
        }
        return mftentryPkvalus;
    }

    public static Set<Long> manftechValPass(List<DynamicObject> mftorderBills, List<DynamicObject> manftechInfos) {
        HashSet<Long> mftentryPkvalus = new HashSet<Long>(10);
        if (null != mftorderBills && null != manftechInfos) {
            for (DynamicObject mftorderBill : mftorderBills) {
                if (null == mftorderBill) continue;
                DynamicObjectCollection srcorderEntrys = mftorderBill.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject srcorderEntry : srcorderEntrys) {
                    long outputoperationId;
                    long pid;
                    DynamicObject outputoperation;
                    if (null == srcorderEntry || StringUtils.equals((CharSequence)ManuBillProductTypeEnum.MAIN.getValue(), (CharSequence)srcorderEntry.getString("producttype")) || null == (outputoperation = srcorderEntry.getDynamicObject("outputoperation")) || !OrderSplitValidateService.isOperationExistInOpr(pid = srcorderEntry.getLong("pid"), outputoperationId = outputoperation.getLong("id"), manftechInfos)) continue;
                    mftentryPkvalus.add(srcorderEntry.getLong("id"));
                }
            }
        }
        return mftentryPkvalus;
    }

    public static boolean isOperationExistInOpr(long mftOrderEntryId, long operationId, List<DynamicObject> manftechInfos) {
        boolean result = false;
        if (null != manftechInfos) {
            boolean isOperationInOprs = false;
            boolean isAllOprsPass = true;
            ArrayList<String> manftechStatusList = new ArrayList<String>(10);
            manftechStatusList.add("F");
            manftechStatusList.add("G");
            block0: for (DynamicObject manftechInfo : manftechInfos) {
                long mftentryseqId;
                DynamicObject mftentryseq = manftechInfo.getDynamicObject("mftentryseq");
                if (null == mftentryseq || mftOrderEntryId != (mftentryseqId = mftentryseq.getLong("id"))) continue;
                DynamicObjectCollection oprentryentity = manftechInfo.getDynamicObjectCollection("oprentryentity");
                for (DynamicObject oprentry : oprentryentity) {
                    if (null == oprentry || null == oprentry.getDynamicObject("oproperation") || operationId != oprentry.getDynamicObject("oproperation").getLong("id")) continue;
                    isOperationInOprs = true;
                    if (manftechStatusList.contains(oprentry.getString("oprstatus")) || oprentry.getBoolean("oprinvalid")) continue;
                    isAllOprsPass = false;
                    break block0;
                }
            }
            result = isOperationInOprs && isAllOprsPass;
        }
        return result;
    }

    public static List<DynamicObject> queryPushedManftechInfos(String entityKey, Set<Long> orderEntryPkValueList) {
        QFilter manftechQFilter;
        String manftechEntityKey;
        DynamicObject[] manftechBills;
        List<DynamicObject> result = new ArrayList<DynamicObject>(10);
        if (StringUtils.isNotBlank((CharSequence)entityKey) && null != orderEntryPkValueList && orderEntryPkValueList.size() > 0 && null != (manftechBills = BusinessDataServiceHelper.load((String)(manftechEntityKey = MftManftechIdentityEnum.getBillIdentityByEntityKey((String)entityKey)), (String)"mftentryseq.id,oprentryentity.oproperation,oprentryentity.oprstatus,oprentryentity.oprinvalid,oprentryentity.oprparent,oprentryentity.oprno", (QFilter[])new QFilter[]{manftechQFilter = new QFilter("mftentryseq.id", "in", orderEntryPkValueList)}))) {
            result = Arrays.asList(manftechBills);
        }
        return result;
    }

    public static String checkOrderBillStatus(DynamicObject mftorderBill) {
        String billStatus;
        String checkInfo = "";
        if (null != mftorderBill && StringUtils.equals((CharSequence)"D", (CharSequence)(billStatus = mftorderBill.getString("billstatus")))) {
            String displayName = mftorderBill.getDynamicObjectType().getDisplayName().getLocaleValue();
            checkInfo = String.format(ResManager.loadKDString((String)"%s\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u5de5\u5355\u62c6\u5206\u5904\u7406\u3002", (String)"OrderSplitValidateService_8", (String)"bd-mpdm-business", (Object[])new Object[0]), displayName);
        }
        return checkInfo;
    }

    public static String checkOrderEntrysStatus(DynamicObject mftorderEntry) {
        String checkInfo = "";
        if (null != mftorderEntry) {
            int seq = mftorderEntry.getInt("seq");
            String entryTaskStatus = mftorderEntry.getString("taskstatus");
            String entryBizStatus = mftorderEntry.getString("bizstatus");
            if (!StringUtils.equals((CharSequence)ManuBillBizStatusEnum.NORMAL.getValue(), (CharSequence)entryBizStatus)) {
                checkInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u62c6\u5206\u5de5\u5355\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4e1a\u52a1\u72b6\u6001\u4e0d\u662f\u6b63\u5e38\u72b6\u6001\u3002", (String)"OrderSplitValidateService_9", (String)"bd-mpdm-business", (Object[])new Object[0]), seq);
            } else if (StringUtils.equals((CharSequence)ManuBillTaskStatusEnum.ENDWORK.getValue(), (CharSequence)entryTaskStatus)) {
                checkInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u62c6\u5206\u5de5\u5355\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4efb\u52a1\u72b6\u6001\u4e3a\u5b8c\u5de5\u72b6\u6001\u3002", (String)"OrderSplitValidateService_10", (String)"bd-mpdm-business", (Object[])new Object[0]), seq);
            }
        }
        return checkInfo;
    }

    public static String checkOrderPlanStatus(DynamicObject mftorderBill, DynamicObject mftorderEntry, DynamicObject splitEntry) {
        String checkInfo = "";
        if (mftorderBill != null && null != mftorderEntry && splitEntry != null) {
            int seq = mftorderEntry.getInt("seq");
            String billStatus = mftorderBill.getString("billstatus");
            String planStatus = mftorderEntry.getString("planstatus");
            if (StringUtils.equals((CharSequence)"C", (CharSequence)billStatus) && StringUtils.equals((CharSequence)"C", (CharSequence)planStatus)) {
                checkInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u62c6\u5206\u5de5\u5355\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a%2$s\u5df2\u4e0b\u8fbe\u3002", (String)"OrderSplitValidateService_11", (String)"bd-mpdm-business", (Object[])new Object[0]), seq, mftorderBill.getDynamicObjectType().getDisplayName().getLocaleValue());
            }
        }
        return checkInfo;
    }

    public static String checkSfcMaInfo(DynamicObject mftorderEntry, Set<Long> manftechSet) {
        String checkInfo = "";
        if (null != mftorderEntry) {
            int seq = mftorderEntry.getInt("seq");
            long mftorderEntryId = mftorderEntry.getLong("id");
            if (manftechSet.contains(mftorderEntryId)) {
                checkInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u62c6\u5206\u5de5\u5355\u5904\u7406\u5931\u8d25\uff0c\u987b\u6ee1\u8db3\u6761\u4ef6\uff1a\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u521b\u5efa\u201d\u3001\u201c\u8ba1\u5212\u201d\u3001\u201c\u8ba1\u5212\u786e\u8ba4\u201d\u3001\u201c\u4e0b\u8fbe\u201d\u6216\u8005\u201c\u5f00\u5de5\u201d\u4e14\u5de5\u5e8f\u672a\u4f5c\u5e9f\u3002", (String)"OrderSplitValidateService_16", (String)"bd-mpdm-business", (Object[])new Object[0]), seq);
            }
        }
        return checkInfo;
    }

    public static String checkSfcOmMaInfo(DynamicObject mftorderEntry, Set<Long> manftechSet) {
        String checkInfo = "";
        if (null != mftorderEntry) {
            int seq = mftorderEntry.getInt("seq");
            long mftorderEntryId = mftorderEntry.getLong("id");
            if (manftechSet.contains(mftorderEntryId)) {
                checkInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u751f\u6210\u59d4\u5916\u5de5\u5355\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5de5\u5e8f\u8ba1\u5212\u7684\u5de5\u5e8f\u72b6\u6001\u4e0d\u80fd\u5b58\u5728\u5f00\u5de5\u3001\u5b8c\u5de5\u3001\u5173\u95ed\u72b6\u6001\u3002", (String)"OrderSplitValidateService_26", (String)"bd-mpdm-business", (Object[])new Object[0]), seq);
            }
        }
        return checkInfo;
    }

    public static String checkUnAuditXmftstockInfo(DynamicObject mftorderEntry, Set<Long> orderEntryIds) {
        String checkInfo = "";
        if (null != mftorderEntry) {
            int seq = mftorderEntry.getInt("seq");
            long mftorderEntryId = mftorderEntry.getLong("id");
            if (orderEntryIds.contains(mftorderEntryId)) {
                checkInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u62c6\u5206\u5de5\u5355\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355\u3002", (String)"OrderSplitValidateService_24", (String)"bd-mpdm-business", (Object[])new Object[0]), seq);
            }
        }
        return checkInfo;
    }

    public static String checkUnAuditXmftorderInfo(DynamicObject mftorderEntry, Set<Long> orderEntryIds) {
        String checkInfo = "";
        if (null != mftorderEntry) {
            int seq = mftorderEntry.getInt("seq");
            long mftorderEntryId = mftorderEntry.getLong("id");
            if (orderEntryIds.contains(mftorderEntryId)) {
                checkInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u62c6\u5206\u5de5\u5355\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5de5\u5355\u53d8\u66f4\u5355\u3002", (String)"OrderSplitValidateService_12", (String)"bd-mpdm-business", (Object[])new Object[0]), seq);
            }
        }
        return checkInfo;
    }

    public static String checkAllSplitInfo(DynamicObject mftorderEntry, Map<Long, BigDecimal> actSplitQtyMap, String billname) {
        String checkInfo = "";
        if (null != mftorderEntry) {
            int seq = mftorderEntry.getInt("seq");
            long mftorderEntryId = mftorderEntry.getLong("id");
            BigDecimal orderQty = mftorderEntry.getBigDecimal("qty");
            BigDecimal actSplitQty = actSplitQtyMap.get(mftorderEntryId);
            if (null != actSplitQty && actSplitQty.compareTo(orderQty) == 0) {
                BigDecimal rptqty = mftorderEntry.getBigDecimal("rptqty");
                BigDecimal inwarbaseqty = mftorderEntry.getBigDecimal("stockqty");
                if (inwarbaseqty.compareTo(BigDecimal.ZERO) <= 0 && rptqty.compareTo(BigDecimal.ZERO) <= 0) {
                    checkInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u62c6\u5206\u5de5\u5355\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u539f%2$s\u884c\u4e0d\u5141\u8bb8\u5168\u90e8\u62c6\u5206\u3002", (String)"OrderSplitValidateService_25", (String)"bd-mpdm-business", (Object[])new Object[0]), seq, billname);
                }
            }
        }
        return checkInfo;
    }

    public static String checkOrderEntryProductType(DynamicObject mftorderEntry) {
        String checkInfo = "";
        if (null != mftorderEntry) {
            int seq = mftorderEntry.getInt("seq");
            String productType = mftorderEntry.getString("producttype");
            if (!StringUtils.equals((CharSequence)"C", (CharSequence)productType)) {
                checkInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u62c6\u5206\u5de5\u5355\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8054\u526f\u4ea7\u54c1\u4e0d\u652f\u6301\u62c6\u5206\u5de5\u5355\u5904\u7406\u3002", (String)"OrderSplitValidateService_13", (String)"bd-mpdm-business", (Object[])new Object[0]), seq);
            }
        }
        return checkInfo;
    }

    public static String checkOrderEntryQtyNew(DynamicObject mftorderEntry, DynamicObject mftorderBill, Map<Long, BigDecimal> transferMap, DynamicObject techBill, String opName) {
        String checkInfo = "";
        int seq = mftorderEntry.getInt("seq");
        DynamicObject transactiontype = mftorderBill.getDynamicObject("transactiontype");
        BigDecimal separablebaseqty = OrderSplitValidateService.calSeparableBaseQty(transactiontype, mftorderEntry, transferMap, techBill);
        if (separablebaseqty.compareTo(BigDecimal.ZERO) <= 0) {
            checkInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55%2$s\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u53ef\u62c6\u5206\u6570\u91cf\u4e0d\u8db3\u3002", (String)"OrderSplitValidateService_23", (String)"bd-mpdm-business", (Object[])new Object[0]), seq, opName);
        }
        return checkInfo;
    }

    public static String checkLeftOrderEntryQty(DynamicObject mftorderEntry, DynamicObject mftorderBill, Map<Long, BigDecimal> transferMap, DynamicObject techBill, String opName) {
        String checkInfo = "";
        int seq = mftorderEntry.getInt("seq");
        DynamicObject transactiontype = mftorderBill.getDynamicObject("transactiontype");
        BigDecimal separablebaseqty = OrderSplitValidateService.calSeparableBaseQty(transactiontype, mftorderEntry, transferMap, techBill);
        if (separablebaseqty.compareTo(BigDecimal.ZERO) <= 0) {
            checkInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55%2$s\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u53ef\u62c6\u5206\u6570\u91cf\u4e0d\u8db3\u3002", (String)"OrderSplitValidateService_23", (String)"bd-mpdm-business", (Object[])new Object[0]), seq, opName);
        }
        return checkInfo;
    }

    public static String omCheckOrderEntryQtyNew(DynamicObject mftorderEntry, DynamicObject mftorderBill, Map<Long, BigDecimal> transferMap, DynamicObject techBill) {
        String checkInfo = "";
        int seq = mftorderEntry.getInt("seq");
        DynamicObject transactiontype = mftorderBill.getDynamicObject("transactiontype");
        BigDecimal separablebaseqty = OrderSplitValidateService.omCalSeparableBaseQty(transactiontype, mftorderEntry, transferMap, techBill);
        if (separablebaseqty.compareTo(BigDecimal.ZERO) <= 0) {
            checkInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u62c6\u5206\u5931\u8d25\uff0c\u59d4\u5916\u5de5\u5355\u5206\u5f55\u6570\u91cf-\u4e0b\u63a8\u6c47\u62a5\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u4e14\u59d4\u5916\u5de5\u5355\u5206\u5f55\u57fa\u672c\u6570\u91cf-\u4e0b\u63a8\u91c7\u8d2d\u57fa\u672c\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"OrderSplitValidateService_28", (String)"bd-mpdm-business", (Object[])new Object[0]), seq);
        }
        return checkInfo;
    }

    public static BigDecimal calSeparableBaseQty(DynamicObject transactiontype, DynamicObject mftorderEntry, Map<Long, BigDecimal> transferMap, DynamicObject techBill) {
        BigDecimal separablebaseqty = BigDecimal.ZERO;
        if (null != transactiontype) {
            DynamicObject material = mftorderEntry.getDynamicObject("material");
            DynamicObject masteridObj = null == material ? null : material.getDynamicObject("masterid");
            DynamicObject unit = mftorderEntry.getDynamicObject("unit");
            DynamicObject baseunit = mftorderEntry.getDynamicObject("baseunit");
            BigDecimal baseqty = mftorderEntry.getBigDecimal("baseqty");
            BigDecimal rptqty = mftorderEntry.getBigDecimal("rptqty");
            BigDecimal inwarbaseqty = mftorderEntry.getBigDecimal("stockqty");
            BigDecimal rptbaseqty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)masteridObj, (DynamicObject)unit, (BigDecimal)rptqty, (DynamicObject)baseunit);
            boolean isprocedure = transactiontype.getBoolean("isprocedure");
            if (isprocedure) {
                BigDecimal baseqtyInOrderEntry = mftorderEntry.getBigDecimal("baseqty");
                BigDecimal maxBaseQty = BigDecimal.ZERO.max(rptbaseqty).max(inwarbaseqty);
                ArrayList<String> manftechStatusList = new ArrayList<String>(10);
                manftechStatusList.add("F");
                manftechStatusList.add("G");
                if (null != techBill) {
                    DynamicObjectCollection oprentrys = techBill.getDynamicObjectCollection("oprentryentity");
                    for (DynamicObject oprentry : oprentrys) {
                        BigDecimal entrustorderqty;
                        if (null == oprentry || manftechStatusList.contains(oprentry.getString("oprstatus")) || oprentry.getBoolean("oprinvalid")) continue;
                        BigDecimal pushreportbaseqty = oprentry.getBigDecimal("pushreportbaseqty");
                        if (null != pushreportbaseqty) {
                            maxBaseQty = maxBaseQty.max(pushreportbaseqty);
                        }
                        BigDecimal transferBaseQty = BigDecimal.ZERO;
                        if (null != transferMap) {
                            transferBaseQty = null == transferMap.get(oprentry.getLong("id")) ? BigDecimal.ZERO : transferMap.get(oprentry.getLong("id"));
                        }
                        BigDecimal oprtotaloutbaseqty = oprentry.getBigDecimal("oprtotaloutbaseqty");
                        if (null != transferBaseQty && null != oprtotaloutbaseqty) {
                            transferBaseQty = transferBaseQty.add(oprtotaloutbaseqty);
                        }
                        if (null != transferBaseQty) {
                            maxBaseQty = maxBaseQty.max(transferBaseQty);
                        }
                        if (null == (entrustorderqty = oprentry.getBigDecimal("entrustorderqty"))) continue;
                        maxBaseQty = maxBaseQty.max(entrustorderqty);
                    }
                }
                separablebaseqty = baseqtyInOrderEntry.subtract(maxBaseQty);
            } else {
                separablebaseqty = baseqty.subtract(rptbaseqty).min(baseqty.subtract(inwarbaseqty));
            }
        }
        return separablebaseqty;
    }

    public static BigDecimal omCalSeparableBaseQty(DynamicObject transactiontype, DynamicObject mftorderEntry, Map<Long, BigDecimal> transferMap, DynamicObject techBill) {
        logger.info("-----omCalSeparableBaseQty in----");
        BigDecimal separablebaseqty = BigDecimal.ZERO;
        if (null != transactiontype) {
            logger.info("-----omCalSeparableBaseQty null != transactiontype ----");
            DynamicObject material = mftorderEntry.getDynamicObject("material");
            DynamicObject masteridObj = null == material ? null : material.getDynamicObject("masterid");
            DynamicObject unit = mftorderEntry.getDynamicObject("unit");
            DynamicObject baseunit = mftorderEntry.getDynamicObject("baseunit");
            BigDecimal baseqty = mftorderEntry.getBigDecimal("baseqty");
            BigDecimal rptqty = mftorderEntry.getBigDecimal("rptqty");
            BigDecimal purpushqty = mftorderEntry.getBigDecimal("purpushqty");
            BigDecimal rptbaseqty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)masteridObj, (DynamicObject)unit, (BigDecimal)rptqty, (DynamicObject)baseunit);
            logger.info("-----omCalSeparableBaseQty rptbaseqty ----" + rptbaseqty.toPlainString());
            boolean isprocedure = transactiontype.getBoolean("isprocedure");
            if (isprocedure) {
                logger.info("-----omCalSeparableBaseQty isprocedure ----");
                BigDecimal baseqtyInOrderEntry = mftorderEntry.getBigDecimal("baseqty");
                BigDecimal maxBaseQty = BigDecimal.ZERO.max(rptbaseqty).max(purpushqty);
                ArrayList<String> manftechStatusList = new ArrayList<String>(10);
                manftechStatusList.add("F");
                manftechStatusList.add("G");
                if (null != techBill) {
                    DynamicObjectCollection oprentrys = techBill.getDynamicObjectCollection("oprentryentity");
                    logger.info("-----omCalSeparableBaseQty oprentrys.size() ----" + oprentrys.size());
                    for (DynamicObject oprentry : oprentrys) {
                        if (null == oprentry || manftechStatusList.contains(oprentry.getString("oprstatus")) || oprentry.getBoolean("oprinvalid")) continue;
                        BigDecimal pushreportbaseqty = BigDecimal.ZERO;
                        BigDecimal pushreportqty = oprentry.getBigDecimal("pushreportqty");
                        logger.info("-----omCalSeparableBaseQty pushreportqty ----" + pushreportqty);
                        if (null != pushreportqty && pushreportqty.compareTo(BigDecimal.ZERO) > 0) {
                            BigDecimal headPushreportbaseqty = OrderSplitValidateService.transferOpQtyToHeadQty(oprentry);
                            logger.info("-----omCalSeparableBaseQty headPushreportbaseqty ----" + headPushreportbaseqty);
                            pushreportbaseqty = OrderSplitValidateService.getMaterielUnitRateConvertQty(techBill, headPushreportbaseqty, oprentry.getDynamicObject("headunit"), techBill.getDynamicObject("baseunit"));
                            logger.info("-----omCalSeparableBaseQty pushreportbaseqty ----" + pushreportbaseqty);
                        }
                        if (null != pushreportbaseqty) {
                            maxBaseQty = maxBaseQty.max(pushreportbaseqty);
                        }
                        BigDecimal transferBaseQty = BigDecimal.ZERO;
                        if (null != transferMap) {
                            transferBaseQty = null == transferMap.get(oprentry.getLong("id")) ? BigDecimal.ZERO : transferMap.get(oprentry.getLong("id"));
                        }
                        BigDecimal oprtotaloutbaseqty = oprentry.getBigDecimal("oprtotaloutbaseqty");
                        if (null != transferBaseQty && null != oprtotaloutbaseqty) {
                            transferBaseQty = transferBaseQty.add(oprtotaloutbaseqty);
                        }
                        if (null == transferBaseQty) continue;
                        maxBaseQty = maxBaseQty.max(transferBaseQty);
                    }
                }
                separablebaseqty = baseqtyInOrderEntry.subtract(maxBaseQty);
            } else {
                separablebaseqty = baseqty.subtract(rptbaseqty).min(baseqty.subtract(purpushqty));
            }
        }
        return separablebaseqty;
    }

    public static String checkOrderEntryQty(DynamicObject mftorderEntry) {
        return "";
    }

    public static Set<Long> queryUnAuditXmftorderBill(List<Long> orderEntryIds) {
        return OrderSplitValidateService.queryUnAuditXmftorderBill(orderEntryIds, "pom_xmftorder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> queryUnAuditXmftorderBill(List<Long> orderEntryIds, String xorderEntityKey) {
        HashSet<Long> result = new HashSet<Long>(10);
        QFilter filter = new QFilter("billstatus", "!=", (Object)"C");
        filter.and(new QFilter("treeentryentity.srcbillentryid", "in", OrderSplitValidateService.listConvertToStr(orderEntryIds)));
        DataSet dataSet = null;
        try {
            dataSet = QueryServiceHelper.queryDataSet((String)"PomOrderCloseUtilsFilter", (String)xorderEntityKey, (String)"treeentryentity.srcbillentryid", (QFilter[])new QFilter[]{filter}, null);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long orderEntryId = row.getLong("treeentryentity.srcbillentryid");
                result.add(orderEntryId);
            }
        }
        finally {
            if (null != dataSet) {
                dataSet.close();
            }
        }
        return result;
    }

    public static Set<Long> queryUnAuditXmftstockBill(List<Long> orderEntryIds) {
        return OrderSplitValidateService.queryUnAuditXmftstockBill(orderEntryIds, "pom_xmftstock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> queryUnAuditXmftstockBill(List<Long> orderEntryIds, String stockEntityKey) {
        HashSet<Long> result = new HashSet<Long>(10);
        QFilter filter = new QFilter("billstatus", "!=", (Object)"C");
        filter.and(new QFilter("orderentryid", "in", orderEntryIds));
        DataSet dataSet = null;
        try {
            dataSet = QueryServiceHelper.queryDataSet((String)"PomOrderCloseUtilsFilter", (String)stockEntityKey, (String)"orderentryid", (QFilter[])new QFilter[]{filter}, null);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long orderEntryId = row.getLong("orderentryid");
                result.add(orderEntryId);
            }
        }
        finally {
            if (null != dataSet) {
                dataSet.close();
            }
        }
        return result;
    }

    public static List<String> listConvertToStr(List<Long> orderEntryIds) {
        ArrayList<String> result = new ArrayList<String>(10);
        if (null == orderEntryIds || orderEntryIds.isEmpty()) {
            return result;
        }
        for (Long entryId : orderEntryIds) {
            if (null == entryId) continue;
            result.add(entryId.toString());
        }
        return result;
    }

    private static BigDecimal getMaterielUnitRateConvertQty(DynamicObject billObj, BigDecimal qty, DynamicObject srcUnit, DynamicObject destUnit) {
        logger.info("getMaterielUnitRateConvertQty in");
        logger.info("getMaterielUnitRateConvertQty qty" + qty.toPlainString());
        logger.info("getMaterielUnitRateConvertQty srcUnit" + (null == srcUnit ? "" : srcUnit.getString("name")));
        logger.info("getMaterielUnitRateConvertQty destUnit" + (null == destUnit ? "" : destUnit.getString("name")));
        DynamicObject material = billObj.getDynamicObject("material");
        return UnitConvertHelper.calculateNewQty((BigDecimal)qty, (Long)(destUnit == null ? null : Long.valueOf(destUnit.getLong("id"))), (Long)(srcUnit == null ? null : Long.valueOf(srcUnit.getLong("id"))), (Long)(material == null ? null : Long.valueOf(material.getLong("id"))), (StringBuilder)new StringBuilder());
    }

    private static BigDecimal transferOpQtyToHeadQty(DynamicObject oprentryRow) {
        logger.info("transferOpQtyToHeadQty in");
        BigDecimal pushreportqty = oprentryRow.getBigDecimal("pushreportqty");
        logger.info("transferOpQtyToHeadQty pushreportqty" + pushreportqty.toPlainString());
        BigDecimal headqty = oprentryRow.getBigDecimal("headqty");
        logger.info("transferOpQtyToHeadQty headqty" + headqty.toPlainString());
        BigDecimal operationqty = oprentryRow.getBigDecimal("operationqty");
        logger.info("transferOpQtyToHeadQty operationqty" + operationqty.toPlainString());
        return pushreportqty.multiply(headqty).divide(operationqty);
    }
}

