/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.mro.lockinfo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.mro.lockinfo.LockInfoUtils;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bd.mpdm.common.query.helper.OrgQueryHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class LockInfoImportService {
    public static String addLockInfo(List<Map<String, Object>> paramList) {
        String returnValue = "ok";
        if (paramList == null || paramList.isEmpty()) {
            return returnValue;
        }
        if (paramList.size() > 1000) {
            String errorStr = ResManager.loadKDString((String)"\u6570\u91cf\u9650\u5236\u6761\u4ef6\uff1a\u6bcf\u6b21\u6700\u591a\u53ef\u8f93\u51651000\u6761\u6570\u636e\u3002", (String)"LockInfoImportService_0", (String)"bd-mpdm-business", (Object[])new Object[0]);
            throw new KDBizException(errorStr);
        }
        HashSet<Long> billTypeIDSet = new HashSet<Long>(16);
        HashSet<Long> orgIDSet = new HashSet<Long>(16);
        HashSet<Object> materialIDSet = new HashSet<Object>(paramList.size());
        HashSet<String> snSet = new HashSet<String>(paramList.size());
        for (int i = 0; i < paramList.size(); ++i) {
            Map<String, Object> dataMap = paramList.get(i);
            Long materialid = LockInfoUtils.objectToLong(dataMap.get("materialid"));
            if (materialid.equals(0L)) continue;
            Long orgID = LockInfoUtils.objectToLong(dataMap.get("orgid"));
            String sn = LockInfoUtils.objectToString(dataMap.get("sn"));
            Long sourceBillID = LockInfoUtils.objectToLong(dataMap.get("sourcebillid"));
            Long sourceBillEntryID = LockInfoUtils.objectToLong(dataMap.get("sourcebillentryid"));
            String sourceBillNo = LockInfoUtils.objectToString(dataMap.get("sourcebillno"));
            Long sourceBillTypeid = LockInfoUtils.objectToLong(dataMap.get("sourcebilltypeid"));
            if (sourceBillEntryID.equals(0L)) {
                String errorStr = String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4f20\u5165\u7684\u6765\u6e90\u5355\u636e\u5206\u5f55ID\u4e3a\u7a7a\u3002", (String)"LockInfoImportService_1", (String)"bd-mpdm-business", (Object[])new Object[0]), new Object[0]);
                throw new KDBizException(errorStr);
            }
            if (sourceBillID.equals(0L)) {
                String errorStr = String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4f20\u5165\u7684\u6765\u6e90\u5355\u636eID\u4e3a\u7a7a\u3002", (String)"LockInfoImportService_2", (String)"bd-mpdm-business", (Object[])new Object[0]), new Object[0]);
                throw new KDBizException(errorStr);
            }
            if (sourceBillTypeid.equals(0L)) {
                String errorStr = String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4f20\u5165\u7684\u6765\u6e90\u5355\u636e\u7c7b\u578bID\u4e3a\u7a7a\u3002", (String)"LockInfoImportService_3", (String)"bd-mpdm-business", (Object[])new Object[0]), new Object[0]);
                throw new KDBizException(errorStr);
            }
            if (StringUtils.isEmpty((String)sourceBillNo)) {
                String errorStr = String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4f20\u5165\u7684\u6765\u6e90\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a\u3002", (String)"LockInfoImportService_4", (String)"bd-mpdm-business", (Object[])new Object[0]), new Object[0]);
                throw new KDBizException(errorStr);
            }
            if (orgID.equals(0L)) {
                String errorStr = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u751f\u4ea7\u7ec4\u7ec7ID\u4e3a\u7a7a\u3002", (String)"LockInfoImportService_5", (String)"bd-mpdm-business", (Object[])new Object[0]), new Object[0]);
                throw new KDBizException(errorStr);
            }
            materialIDSet.add(materialid);
            billTypeIDSet.add(sourceBillTypeid);
            snSet.add(sn);
            orgIDSet.add(orgID);
        }
        Set<String> doubleDataSet = LockInfoUtils.checkDoubleData(materialIDSet, snSet);
        Map materialMap = MaterialQueryHelper.getDataCacheBySet(materialIDSet);
        Map<Object, DynamicObject> billTypeMap = LockInfoImportService.getBillTypesCacheList(billTypeIDSet);
        Map orgMap = OrgQueryHelper.getDataCacheBySet(orgIDSet);
        HashSet<String> doubleDataSet2 = new HashSet<String>(paramList.size());
        ArrayList<DynamicObject> dyList = new ArrayList<DynamicObject>(paramList.size());
        for (int i = 0; i < paramList.size(); ++i) {
            String errorStr;
            Map<String, Object> dataMap = paramList.get(i);
            Long materialid = LockInfoUtils.objectToLong(dataMap.get("materialid"));
            if (materialid.equals(0L)) continue;
            Long orgID = LockInfoUtils.objectToLong(dataMap.get("orgid"));
            String sn = LockInfoUtils.objectToString(dataMap.get("sn"));
            Long sourceBillID = LockInfoUtils.objectToLong(dataMap.get("sourcebillid"));
            Long sourceBillEntryID = LockInfoUtils.objectToLong(dataMap.get("sourcebillentryid"));
            String sourceBillNo = LockInfoUtils.objectToString(dataMap.get("sourcebillno"));
            Long sourceBillTypeid = LockInfoUtils.objectToLong(dataMap.get("sourcebilltypeid"));
            String keyString = String.valueOf(materialid) + "-" + sn;
            if (doubleDataSet.contains(keyString) || doubleDataSet2.contains(keyString)) continue;
            doubleDataSet2.add(keyString);
            DynamicObject material = (DynamicObject)materialMap.get(materialid);
            DynamicObject billtype = billTypeMap.get(sourceBillTypeid);
            DynamicObject org = (DynamicObject)orgMap.get(orgID);
            if (billtype == null) {
                errorStr = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u6765\u6e90\u5355\u636e\u7c7b\u578bID\uff08%1$s\uff09\u5728\u57fa\u7840\u8d44\u6599\u4e2d\u65e0\u6cd5\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LockInfoImportService_6", (String)"bd-mpdm-business", (Object[])new Object[]{String.valueOf(sourceBillTypeid)}), new Object[0]);
                throw new KDBizException(errorStr);
            }
            if (material == null) {
                errorStr = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7269\u6599ID\uff08%1$s\uff09\u5728\u57fa\u7840\u8d44\u6599\u4e2d\u65e0\u6cd5\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LockInfoImportService_7", (String)"bd-mpdm-business", (Object[])new Object[]{String.valueOf(materialid)}), new Object[0]);
                throw new KDBizException(errorStr);
            }
            if (org == null) {
                errorStr = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u751f\u4ea7\u7ec4\u7ec7ID\uff08%1$s\uff09\u5728\u57fa\u7840\u8d44\u6599\u4e2d\u65e0\u6cd5\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LockInfoImportService_8", (String)"bd-mpdm-business", (Object[])new Object[]{String.valueOf(orgID)}), new Object[0]);
                throw new KDBizException(errorStr);
            }
            DynamicObject lockInfo = LockInfoImportService.newLockInfo(org, material, sn, sourceBillID, sourceBillEntryID, sourceBillNo, billtype);
            dyList.add(lockInfo);
        }
        LockInfoImportService.saveData(dyList);
        return returnValue;
    }

    private static DynamicObject newLockInfo(DynamicObject org, DynamicObject material, String sn, Long sourceBillID, Long sourceBillEntryID, String sourceBillNo, DynamicObject billtype) {
        DynamicObject lockInfo = ORM.create().newDynamicObject("mpdm_lockinfo");
        lockInfo.set("createorg", (Object)org);
        lockInfo.set("material", (Object)material);
        lockInfo.set("sn", (Object)sn);
        lockInfo.set("number", (Object)LockInfoUtils.genLockNumber(material, sn));
        lockInfo.set("sourcebillentryid", (Object)sourceBillEntryID);
        lockInfo.set("sourcebillid", (Object)sourceBillID);
        lockInfo.set("sourcebillno", (Object)sourceBillNo);
        lockInfo.set("sourcetype", (Object)billtype);
        lockInfo.set("status", (Object)"C");
        lockInfo.set("enable", (Object)"1");
        return lockInfo;
    }

    public static String deleteLockInfo(List<Long> sourcebillIDList, Long sourceBillTypeid) {
        String returnValue = "ok";
        if (sourcebillIDList == null || sourcebillIDList.isEmpty()) {
            return returnValue;
        }
        if (sourceBillTypeid.equals(0L)) {
            String errorStr = String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4f20\u5165\u7684\u6765\u6e90\u5355\u636e\u7c7b\u578bID\u4e3a\u7a7a\u3002", (String)"LockInfoImportService_3", (String)"bd-mpdm-business", (Object[])new Object[0]), new Object[0]);
            throw new KDBizException(errorStr);
        }
        QFilter qFilter = new QFilter("sourcebillid", "in", sourcebillIDList);
        qFilter.and(new QFilter("sourcetype.id", "=", (Object)sourceBillTypeid));
        HashSet<Long> delIDSet = new HashSet<Long>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-LockInfoUtils-checkDoubleData", (String)"mpdm_lockinfo", (String)"KEY_ID", (QFilter[])new QFilter[]{qFilter}, (String)"");){
            for (Row row : ds) {
                delIDSet.add(row.getLong("KEY_ID"));
            }
        }
        if (delIDSet.isEmpty()) {
            return returnValue;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        OperationResult delResult = OperationServiceHelper.executeOperate((String)"delete", (String)"mpdm_lockinfo", (Object[])delIDSet.toArray(), (OperateOption)option);
        HashSet successIds = new HashSet(delResult.getSuccessPkIds());
        if (successIds.size() != delIDSet.size()) {
            String errorString = LockInfoImportService.getErrorString(delResult);
            throw new KDBizException(errorString);
        }
        return returnValue;
    }

    private static String getErrorString(OperationResult delResult) {
        StringBuilder sb = new StringBuilder();
        for (IOperateInfo errInfo : delResult.getAllErrorOrValidateInfo()) {
            sb.append(errInfo.getMessage());
            sb.append(" ");
        }
        return sb.toString();
    }

    private static synchronized void saveData(List<DynamicObject> dyList) {
        if (dyList == null || dyList.isEmpty()) {
            return;
        }
        DynamicObject[] dyColl = dyList.toArray(new DynamicObject[dyList.size()]);
        SaveServiceHelper.save((DynamicObject[])dyColl);
    }

    private static String getBillTypeSelectProperties() {
        StringBuilder sf = new StringBuilder();
        sf.append("id,");
        sf.append("number,");
        sf.append("name,");
        sf.append("isdefault,");
        sf.append("billformid");
        return sf.toString();
    }

    private static Map<Object, DynamicObject> getBillTypesCacheList(Set<Long> billTypeIDSet) {
        QFilter qFilter = new QFilter("id", "in", billTypeIDSet);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        return BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (String)LockInfoImportService.getBillTypeSelectProperties(), (QFilter[])new QFilter[]{qFilter});
    }
}

