/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.mro.lockinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class LockInfoUtils {
    public static Set<String> checkDoubleData(List<String> lockNumberList) {
        if (lockNumberList == null || lockNumberList.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> doubleNumberSet = new HashSet<String>(lockNumberList.size());
        ArrayList<String> unquieNumberList = new ArrayList<String>(lockNumberList.size());
        for (String lockNumber : lockNumberList) {
            if (!unquieNumberList.contains(lockNumber)) {
                unquieNumberList.add(lockNumber);
                continue;
            }
            doubleNumberSet.add(lockNumber);
        }
        if (!unquieNumberList.isEmpty()) {
            QFilter qFilter = new QFilter("number", "in", new HashSet(unquieNumberList));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-LockInfoUtils-checkDoubleData", (String)"mpdm_lockinfo", (String)"number", (QFilter[])new QFilter[]{qFilter}, (String)"");){
                for (Row row : ds) {
                    doubleNumberSet.add(row.getString("number"));
                }
            }
        }
        return doubleNumberSet;
    }

    public static Map<Object, String> getLockControlInfo(Set<Object> lockInfoIDSet) {
        if (lockInfoIDSet == null || lockInfoIDSet.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Object, String> lockControlMap = new HashMap<Object, String>(lockInfoIDSet.size());
        QFilter qFilter = new QFilter("lockinfo.id", "in", lockInfoIDSet);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-LockInfoUtils-getLockControlInfo", (String)"pom_mrolockcontrol", (String)"billno,lockinfo.id lockinfoid ", (QFilter[])new QFilter[]{qFilter}, (String)"");){
            for (Row row : ds) {
                lockControlMap.put(row.getLong("lockinfoid"), row.getString("billno"));
            }
        }
        return lockControlMap;
    }

    public static Set<String> checkDoubleData(Set<Object> midSet, Set<String> snSet) {
        if (midSet == null || midSet.isEmpty()) {
            return Collections.emptySet();
        }
        if (snSet == null || snSet.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> doubleNumberSet = new HashSet<String>(16);
        QFilter qFilter = new QFilter("material.id", "in", midSet);
        qFilter.and(new QFilter("sn", "in", snSet));
        String selectProperties = "material.id materialid,sn,number";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-LockInfoUtils-checkDoubleData", (String)"mpdm_lockinfo", (String)selectProperties, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            for (Row row : ds) {
                Long mid = row.getLong("materialid");
                String sn = row.getString("sn");
                doubleNumberSet.add(String.valueOf(mid) + "-" + sn);
            }
        }
        return doubleNumberSet;
    }

    public static String genLockNumber(DynamicObject material, String sn) {
        String materialnumber;
        if (material == null || StringUtils.isEmpty((String)sn)) {
            return "";
        }
        if (!material.containsProperty("number") || StringUtils.isEmpty((String)material.getString("number"))) {
            DynamicObject newMaterial = MaterialQueryHelper.getDataCacheByID((Object)material.getPkValue());
            materialnumber = newMaterial.getString("number");
        } else {
            materialnumber = material.getString("number");
        }
        return materialnumber + "-" + sn;
    }

    public static String objectToString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static Long objectToLong(Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return Long.valueOf(obj.toString());
    }
}

