/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.ordersplit;

import com.alibaba.fastjson.JSONArray;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bd.mpdm.business.mftorder.OrderSpliteService;
import kd.bd.mpdm.business.mftorder.StockCulUtils;
import kd.bd.mpdm.business.mftorder.splitmodel.IOrderSplitView;
import kd.bd.mpdm.business.mftorder.validate.OrderSplitValidateService;
import kd.bd.mpdm.common.enums.UnitConvertDirEnum;
import kd.bd.mpdm.common.mftorder.enums.PrecisionAccountEnum;
import kd.bd.mpdm.common.mftorder.enums.billIdentity.MftManftechIdentityEnum;
import kd.bd.mpdm.common.mftorder.helper.BillUnitAndQtytHelper;
import kd.bd.mpdm.common.mftorder.helper.BizTypeHelper;
import kd.bd.mpdm.common.mftorder.helper.WarehouseHelper;
import kd.bd.mpdm.common.mftorder.utils.CalendarUtils;
import kd.bd.mpdm.common.query.helper.OrgQueryHelper;
import kd.bd.mpdm.common.utils.AuxQtyAndUnitHelper;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bd.mpdm.common.utils.UnitPrecisionUtils;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractOrderSplit
implements IOrderSplitView {
    private static final Log logger = LogFactory.getLog(AbstractOrderSplit.class);
    public static final String MASTERID = "masterid";

    public <Plugin extends AbstractFormPlugin & RowClickEventListener> void initialize(Plugin plugin) {
    }

    public <Plugin extends AbstractFormPlugin & RowClickEventListener> void registerListener(Plugin plugin, EventObject e) {
        EntryGrid entryGrid = (EntryGrid)plugin.getView().getControl("spittreeentryentity");
        entryGrid.addRowClickListener((RowClickEventListener)plugin);
        BasedataEdit otherLocation = (BasedataEdit)plugin.getView().getControl("location");
        otherLocation.addBeforeF7SelectListener((BeforeF7SelectListener)plugin);
        BasedataEdit otherwarehouse = (BasedataEdit)plugin.getView().getControl("warehouse");
        otherwarehouse.addBeforeF7SelectListener((BeforeF7SelectListener)plugin);
        BasedataEdit splitproducedept = (BasedataEdit)plugin.getView().getControl("splitproducedept");
        splitproducedept.addBeforeF7SelectListener((BeforeF7SelectListener)plugin);
        BasedataEdit inwardept = (BasedataEdit)plugin.getView().getControl("inwardept");
        inwardept.addBeforeF7SelectListener((BeforeF7SelectListener)plugin);
        BasedataEdit producedept = (BasedataEdit)plugin.getView().getControl("producedept");
        producedept.addBeforeF7SelectListener((BeforeF7SelectListener)plugin);
        BasedataEdit org = (BasedataEdit)plugin.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)plugin);
        BasedataEdit splitbiztype = (BasedataEdit)plugin.getView().getControl("splitbiztype");
        splitbiztype.addBeforeF7SelectListener((BeforeF7SelectListener)plugin);
        BasedataEdit splittransactiontype = (BasedataEdit)plugin.getView().getControl("splittransactiontype");
        splittransactiontype.addBeforeF7SelectListener((BeforeF7SelectListener)plugin);
        BasedataEdit splitpurorg = (BasedataEdit)plugin.getView().getControl("splitpurorg");
        splitpurorg.addBeforeF7SelectListener((BeforeF7SelectListener)plugin);
        BasedataEdit splitsupplier = (BasedataEdit)plugin.getView().getControl("splitsupplier");
        splitsupplier.addBeforeF7SelectListener((BeforeF7SelectListener)plugin);
    }

    public <Plugin extends AbstractFormPlugin & RowClickEventListener> void beforeBindData(Plugin plugin, EventObject e) {
        int[] splitSeqArr;
        String isFromMftOrder = (String)plugin.getView().getFormShowParameter().getCustomParam("isFromMftOrderBill");
        String billSelectRow = (String)plugin.getView().getFormShowParameter().getCustomParam("billSelectRowList");
        Object mainOrgId = plugin.getView().getFormShowParameter().getCustomParam("mainOrgId");
        if (StringUtils.equals((CharSequence)"true", (CharSequence)isFromMftOrder)) {
            if (null != mainOrgId) {
                long orgId = Long.parseLong(mainOrgId.toString());
                plugin.getView().getModel().setValue("org", (Object)orgId);
                plugin.getView().setEnable(Boolean.FALSE, new String[]{"org"});
            }
            if (StringUtils.isNotBlank((CharSequence)billSelectRow)) {
                List billSelectList = JSONArray.parseArray((String)billSelectRow, Long.class);
                HashSet<Long> entryIds = new HashSet<Long>(billSelectList);
                ArrayList<QFilter> orderQf = new ArrayList<QFilter>(10);
                orderQf.add(new QFilter("treeentryentity.id", "in", entryIds));
                DynamicObject[] orderBillcol = BusinessDataServiceHelper.load((String)this.getSplitModel().getMforder(), (String)this.getMftOrderSelects(), (QFilter[])orderQf.toArray(new QFilter[orderQf.size()]));
                Map<Long, BigDecimal> transferMap = OrderSpliteService.queryTransferQtyMap(entryIds);
                this.getMftBillEntry(plugin, orderBillcol, (Set<Long>)entryIds, transferMap);
                this.countEntryQty(plugin);
            }
        }
        if (null == plugin.getView().getModel().getValue("org")) {
            RequestContext rc = RequestContext.get();
            long orgId = rc.getOrgId();
            if (0L != orgId) {
                plugin.getView().getModel().setValue("org", (Object)orgId);
            } else {
                PermissionServiceHelper.clearAllCache();
                Long userId = Long.parseLong(RequestContext.get().getUserId());
                String appId = ShowFormHelper.getBizAppId((FormShowParameter)plugin.getView().getFormShowParameter());
                String permItemId = "47150e89000000ac";
                List allPermissionOrgs = PermissionServiceHelper.getAllPermissionOrgs((Long)userId, (String)appId, (String)"pom_ordersplit", (String)permItemId);
                if (allPermissionOrgs.size() > 0) {
                    plugin.getView().getModel().setValue("org", allPermissionOrgs.get(0));
                }
            }
        }
        AbstractFormDataModel model = (AbstractFormDataModel)plugin.getView().getModel();
        HashSet<Long> srcEntryIds = new HashSet<Long>(16);
        srcEntryIds.add(0L);
        int[] seqArr = this.needDeleteRows(plugin, "treeentryentity", "mftorderentryid", (Set<Long>)srcEntryIds);
        if (null != seqArr && seqArr.length > 0) {
            model.deleteEntryRows("treeentryentity", seqArr);
        }
        if (null != (splitSeqArr = this.needDeleteRows(plugin, "spittreeentryentity", "splitmftorderentryid", (Set<Long>)srcEntryIds)) && splitSeqArr.length > 0) {
            model.deleteEntryRows("spittreeentryentity", splitSeqArr);
        }
        this.clearPurOrg(plugin);
    }

    public <Plugin extends AbstractFormPlugin & RowClickEventListener> void propertyChanged(Plugin plugin, PropertyChangedArgs e) {
        if (plugin.getView().getPageCache().get("isIgnoreChangeListener") != "true") {
            ChangeData[] changeSet;
            String propertyName = e.getProperty().getName();
            block24: for (ChangeData cd : changeSet = e.getChangeSet()) {
                int rowIndex = cd.getRowIndex();
                switch (propertyName) {
                    case "splitbilltype": {
                        this.propertyChangeBillType(plugin, cd);
                        continue block24;
                    }
                    case "splittype": {
                        this.propertyChangeSplitType(plugin, cd);
                        continue block24;
                    }
                    case "splitqty": {
                        this.propertyChangeSplitqty(plugin, cd);
                        continue block24;
                    }
                    case "splitratio": {
                        this.propertyChangeSplitratio(plugin, cd);
                        continue block24;
                    }
                    case "splitauxptyqty": {
                        this.propertyChangeSplitAuxptyqty(plugin, cd);
                        continue block24;
                    }
                    case "splitplanbegintime": {
                        this.calPlanEndTime(plugin, rowIndex);
                        continue block24;
                    }
                    case "splitbatchmode": {
                        this.propertyChangeSplitBatchMode(plugin, cd);
                        continue block24;
                    }
                    case "warehouse": {
                        Object newValue = cd.getNewValue();
                        plugin.getView().getModel().setValue("warehouse", newValue, rowIndex);
                        plugin.getView().getModel().setValue("location", null, rowIndex);
                        continue block24;
                    }
                    case "splitbiztype": {
                        DynamicObject bizType = (DynamicObject)plugin.getView().getModel().getValue("splitbiztype", rowIndex);
                        if (null == bizType) continue block24;
                        this.setDefaultTrans(plugin, bizType, rowIndex);
                        continue block24;
                    }
                    case "org": {
                        plugin.getView().getModel().deleteEntryData("treeentryentity");
                        plugin.getView().getModel().deleteEntryData("spittreeentryentity");
                        continue block24;
                    }
                }
            }
        }
    }

    public <Plugin extends AbstractFormPlugin & RowClickEventListener> void beforeDoOperation(Plugin plugin, BeforeDoOperationEventArgs e) {
        FormOperate operate = (FormOperate)e.getSource();
        String opKey = operate.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)"choose", (CharSequence)opKey)) {
            this.chooseMftorder(plugin, e);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)opKey, (CharSequence)"createorderbill")) {
            this.createOrderBill(plugin, e);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)opKey, (CharSequence)"splitcopy")) {
            this.opSplitCopy(plugin, e);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)opKey, (CharSequence)"splitdelete")) {
            this.opSplitDelete(plugin);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)opKey, (CharSequence)"splitbatch")) {
            this.opSplitBatch(plugin, e);
        }
    }

    public <Plugin extends AbstractFormPlugin & RowClickEventListener> void afterDoOperation(Plugin plugin, AfterDoOperationEventArgs e) {
        boolean isSuccess;
        DynamicObject entryRowEntity;
        BigDecimal splitqty;
        EntryGrid entryGrid;
        int index;
        BigDecimal totalseparableqty;
        FormOperate operate = (FormOperate)e.getSource();
        String key = e.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"orderdelete")) {
            this.opOrderDelete(plugin);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"splitcopy") && (totalseparableqty = this.recalTotalseparableqty(plugin, index = (entryGrid = (EntryGrid)plugin.getView().getControl("spittreeentryentity")).getSelectRows()[0], splitqty = (entryRowEntity = plugin.getView().getModel().getEntryRowEntity("spittreeentryentity", index)).getBigDecimal("splitqty"), true, true)).compareTo(BigDecimal.ZERO) < 0) {
            plugin.getView().getPageCache().put("isIgnoreChangeListener", "true");
            plugin.getView().getModel().setValue("splitqty", null, index);
            plugin.getView().getModel().setValue("splitratio", null, index);
            plugin.getView().getModel().setValue("splitauxptyqty", null, index);
            plugin.getView().getPageCache().put("isIgnoreChangeListener", "false");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"createorderbill") && (isSuccess = e.getOperationResult().isSuccess())) {
            this.createOrderBillAfterOpt(plugin, operate);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"splitbatch")) {
            this.afterSplitBatch(plugin);
        }
    }

    public <Plugin extends AbstractFormPlugin & RowClickEventListener> void closedCallBack(Plugin plugin, ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        String opexception;
        String actionKey = closedCallBackEvent.getActionId();
        if ("choose".equals(actionKey)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (rows != null && !rows.isEmpty()) {
                long entryIdInRow;
                String billNo;
                HashSet<Long> mftorderEntryIds = new HashSet<Long>(16);
                for (ListSelectedRow listSelectedRow : rows) {
                    Object pkValue = listSelectedRow.getEntryPrimaryKeyValue();
                    if (null == pkValue) continue;
                    mftorderEntryIds.add(Long.parseLong(pkValue.toString()));
                }
                StringBuilder sb = new StringBuilder();
                Set<Long> mftentryPkvalues = OrderSplitValidateService.queryPushedManftechMftentryPkvalus(this.getSplitModel().getMforder(), mftorderEntryIds);
                Set<Long> orderEntryIdsInUnAuditXmftorderBill = OrderSplitValidateService.queryUnAuditXmftorderBill(new ArrayList<Long>(mftorderEntryIds), this.getSplitModel().getXmftOrderEntity());
                Set<Long> orderEntryIdsInUnAuditXmftstockBill = OrderSplitValidateService.queryUnAuditXmftstockBill(new ArrayList<Long>(mftorderEntryIds), this.getSplitModel().getXmftStockEntity());
                HashMap orderEntryInfoMap = new HashMap(16);
                String selectFields = "treeentryentity.seq,treeentryentity.id";
                QFilter qFilter = new QFilter("treeentryentity.id", "in", mftorderEntryIds);
                try (Object ds = QueryServiceHelper.queryDataSet((String)"split_choose_queryorderinfo", (String)this.getSplitModel().getMforder(), (String)selectFields, (QFilter[])new QFilter[]{qFilter}, null);){
                    Iterator iterator = ds.iterator();
                    while (iterator.hasNext()) {
                        Row row = (Row)iterator.next();
                        HashMap<String, Integer> temp = new HashMap<String, Integer>(16);
                        temp.put("seq", row.getInteger("treeentryentity.seq"));
                        orderEntryInfoMap.put(row.getLong("treeentryentity.id"), temp);
                    }
                }
                ds = mftentryPkvalues.iterator();
                while (ds.hasNext()) {
                    long mftentryPkvalue = (Long)ds.next();
                    billNo = "";
                    int seq = 0;
                    for (ListSelectedRow listSelectedRow : rows) {
                        if (listSelectedRow.getEntryPrimaryKeyValue() == null || mftentryPkvalue != (entryIdInRow = Long.parseLong(listSelectedRow.getEntryPrimaryKeyValue().toString()))) continue;
                        billNo = listSelectedRow.getBillNo();
                        Map temp = (Map)orderEntryInfoMap.get(entryIdInRow);
                        if (null == temp) continue;
                        seq = (Integer)temp.get("seq");
                    }
                    sb.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7b2c%2$s\u884c\u5206\u5f55\u62c6\u5206\u5de5\u5355\u5904\u7406\u9009\u5355\u5931\u8d25\uff0c\u987b\u6ee1\u8db3\u6761\u4ef6\uff1a\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u521b\u5efa\u201d\u3001\u201c\u8ba1\u5212\u201d\u3001\u201c\u8ba1\u5212\u786e\u8ba4\u201d\u3001\u201c\u4e0b\u8fbe\u201d\u6216\u8005\u201c\u5f00\u5de5\u201d\u4e14\u5de5\u5e8f\u672a\u4f5c\u5e9f\u3002", (String)"AbstractOrderSplit_22", (String)"bd-mpdm-business", (Object[])new Object[0]), billNo, seq));
                }
                ds = orderEntryIdsInUnAuditXmftorderBill.iterator();
                while (ds.hasNext()) {
                    long mftentryPkvalue = (Long)ds.next();
                    billNo = "";
                    int seq = 0;
                    for (ListSelectedRow listSelectedRow : rows) {
                        if (listSelectedRow.getEntryPrimaryKeyValue() == null || mftentryPkvalue != (entryIdInRow = Long.parseLong(listSelectedRow.getEntryPrimaryKeyValue().toString()))) continue;
                        billNo = listSelectedRow.getBillNo();
                        seq = listSelectedRow.getRowKey() + 1;
                    }
                    sb.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7b2c%2$s\u884c\u5206\u5f55\u62c6\u5206\u5de5\u5355\u5904\u7406\u9009\u5355\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5de5\u5355\u53d8\u66f4\u5355\u3002", (String)"AbstractOrderSplit_5", (String)"bd-mpdm-business", (Object[])new Object[0]), billNo, seq));
                }
                ds = orderEntryIdsInUnAuditXmftstockBill.iterator();
                while (ds.hasNext()) {
                    long mftentryPkvalue = (Long)ds.next();
                    billNo = "";
                    int seq = 0;
                    for (ListSelectedRow listSelectedRow : rows) {
                        if (listSelectedRow.getEntryPrimaryKeyValue() == null || mftentryPkvalue != (entryIdInRow = Long.parseLong(listSelectedRow.getEntryPrimaryKeyValue().toString()))) continue;
                        billNo = listSelectedRow.getBillNo();
                        seq = listSelectedRow.getRowKey() + 1;
                    }
                    sb.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7b2c%2$s\u884c\u5206\u5f55\u62c6\u5206\u5de5\u5355\u5904\u7406\u9009\u5355\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355\u3002", (String)"AbstractOrderSplit_37", (String)"bd-mpdm-business", (Object[])new Object[0]), billNo, seq));
                }
                ArrayList<QFilter> orderQf = new ArrayList<QFilter>(8);
                orderQf.add(new QFilter("treeentryentity.id", "in", mftorderEntryIds));
                DynamicObject[] orderBillcol = BusinessDataServiceHelper.load((String)this.getSplitModel().getMforder(), (String)this.getMftOrderSelects(), (QFilter[])orderQf.toArray(new QFilter[orderQf.size()]));
                Map<Long, BigDecimal> transferMap = OrderSpliteService.queryTransferQtyMap(mftorderEntryIds);
                DynamicObject[] techBillcol = this.getTechBillCol(mftorderEntryIds);
                for (DynamicObject orderBill : orderBillcol) {
                    DynamicObjectCollection orderEntrys = orderBill.getDynamicObjectCollection("treeentryentity");
                    for (DynamicObject orderEntry : orderEntrys) {
                        String opName;
                        DynamicObject techBill;
                        String checkOrderEntryQty;
                        long orderEntryId;
                        if (null == orderEntry || !mftorderEntryIds.contains(orderEntryId = orderEntry.getLong("id")) || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(checkOrderEntryQty = this.checkOrderEntryQty(transferMap, orderBill, orderEntry, techBill = OrderSpliteService.matchTechBill(techBillcol, orderEntryId), opName = ResManager.loadKDString((String)"\u9009\u5355", (String)"AbstractOrderSplit_32", (String)"bd-mpdm-business", (Object[])new Object[0]))))) continue;
                        String info = orderBill.getString("billno") + checkOrderEntryQty;
                        sb.append(info);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)sb)) {
                    plugin.getView().showErrorNotification(sb.toString());
                    return;
                }
                this.getMftBillEntry(plugin, orderBillcol, (Set<Long>)mftorderEntryIds, transferMap);
                this.countEntryQty(plugin);
            }
            this.clearPurOrg(plugin);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"progressbarap", (CharSequence)actionKey) && StringUtils.isBlank((CharSequence)(opexception = plugin.getView().getPageCache().get("opexception")))) {
            HashMap<String, String> para = new HashMap<String, String>(16);
            para.put("formId", this.getSplitModel().getSplitResFormId());
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ArrayList<Integer> deleteRowSeqs = new ArrayList<Integer>(10);
            ArrayList<String> logKeyList = new ArrayList<String>(10);
            EntryGrid entryGrid = (EntryGrid)plugin.getView().getControl("spittreeentryentity");
            int[] selectRows = entryGrid.getSelectRows();
            for (int i2 = 0; i2 < selectRows.length; ++i2) {
                DynamicObject entry = plugin.getView().getModel().getEntryRowEntity("spittreeentryentity", selectRows[i2]);
                String key = "SOR:" + entry.getString("splitmftorderentryid") + "@seq:" + entry.getInt("seq");
                String splitResult = plugin.getView().getPageCache().get(key);
                if (StringUtils.isNotBlank((CharSequence)splitResult) && splitResult.indexOf(ResManager.loadKDString((String)"\u751f\u6210\u6210\u529f", (String)"AbstractOrderSplit_6", (String)"bd-mpdm-business", (Object[])new Object[0])) != -1) {
                    int[] index = new int[]{selectRows[i2]};
                    entryGrid.setRowLock(true, index);
                    this.recalOrderEntry(plugin, entry);
                    deleteRowSeqs.add(entry.getInt("seq") - 1);
                }
                logKeyList.add(key);
            }
            showParameter.getCustomParams().put("logKeyList", SerializationUtils.toJsonString(logKeyList));
            plugin.getView().showForm(showParameter);
            plugin.getView().getModel().deleteEntryRows("spittreeentryentity", deleteRowSeqs.stream().mapToInt(i -> i).toArray());
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"batchSplit", (CharSequence)actionKey) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            Map map = (Map)returnData;
            logger.info("\u6279\u91cf\u62c6\u5206\u8fd4\u56de\u7684returndata\uff1a\uff1a\uff1a\uff1a\uff1a" + map);
            int splitNumber = (Integer)map.get("splitnumber");
            Boolean isAverage = (Boolean)map.get("isaverage");
            DynamicObject splitOrderSeq = (DynamicObject)map.get("splitorderseq");
            BigDecimal splitQty = (BigDecimal)map.get("splitqty");
            DynamicObject splitUnit = (DynamicObject)map.get("splitunit");
            DynamicObject splitAuxptyUnit = (DynamicObject)map.get("splitauxptyunit");
            BigDecimal bigDecimal = splitQty.divide(new BigDecimal(splitNumber), splitUnit.getInt("precision"), UnitPrecisionUtils.getPrecisionDeal((String)splitUnit.getString("precisionaccount")));
            EntryGrid entryGrid = (EntryGrid)plugin.getView().getControl("spittreeentryentity");
            int v = (int)(splitQty.doubleValue() / bigDecimal.doubleValue());
            BigDecimal subtract = splitQty.subtract(bigDecimal.multiply(new BigDecimal(splitNumber - 1)));
            for (int i3 = 0; i3 < splitNumber - 1; ++i3) {
                plugin.getView().getModel().copyEntryRow("spittreeentryentity", entryGrid.getSelectRows(), false);
            }
            int entryRowCount = plugin.getView().getModel().getEntryRowCount("spittreeentryentity");
            for (int i4 = 0; i4 < entryRowCount; ++i4) {
                DynamicObject orderSeq = (DynamicObject)plugin.getView().getModel().getValue("splitorderseq", i4);
                if (!Objects.equals(splitOrderSeq.getPkValue(), orderSeq.getPkValue())) continue;
                plugin.getView().getModel().setValue("splitqty", (Object)BigDecimal.ZERO, i4);
                plugin.getView().getModel().setValue("splitauxptyunit", null, i4);
            }
            long srcEntryId = (Long)plugin.getView().getModel().getValue("splitmftorderentryid", entryGrid.getSelectRows()[0]);
            DynamicObject orderEntry = this.matchOrderEntryBySrcEntryId(plugin, srcEntryId);
            if (orderEntry != null) {
                int orderEntryIndex = orderEntry.getInt("seq") - 1;
                plugin.getView().getModel().setValue("totalseparableratio", (Object)BigDecimal.ZERO, orderEntryIndex);
                plugin.getView().getModel().setValue("totalseparablebaseqty", (Object)BigDecimal.ZERO, orderEntryIndex);
                plugin.getView().getModel().setValue("totalseparableqty", (Object)BigDecimal.ZERO, orderEntryIndex);
            }
            int j = 0;
            for (int i5 = 0; i5 < entryRowCount; ++i5) {
                DynamicObject orderSeq = (DynamicObject)plugin.getView().getModel().getValue("splitorderseq", i5);
                if (!Objects.equals(splitOrderSeq.getPkValue(), orderSeq.getPkValue())) continue;
                if (splitAuxptyUnit != null) {
                    plugin.getView().getModel().setValue("splitauxptyunit", (Object)splitAuxptyUnit, i5);
                }
                if (isAverage.booleanValue()) {
                    if (j == 0) {
                        if (BigDecimal.ZERO.compareTo(subtract) >= 0) {
                            plugin.getView().getModel().setValue("splitqty", (Object)bigDecimal, i5);
                        } else {
                            plugin.getView().getModel().setValue("splitqty", (Object)subtract, i5);
                        }
                    }
                    if (j > 0 && j < v) {
                        plugin.getView().getModel().setValue("splitqty", (Object)bigDecimal, i5);
                    }
                } else if (j == 0) {
                    plugin.getView().getModel().setValue("splitqty", (Object)splitQty, i5);
                }
                ++j;
            }
        }
    }

    public <Plugin extends AbstractFormPlugin & RowClickEventListener> void beforeF7Select(Plugin plugin, BeforeF7SelectEvent evt) {
        DynamicObject splitpurorg;
        EntryGrid entryGrid;
        DynamicObjectCollection col;
        ListShowParameter listShowParameter;
        Control con = (Control)evt.getSource();
        String source = con.getKey();
        if ("producedept".equals(source) || "splitproducedept".equals(source)) {
            DynamicObject org = (DynamicObject)plugin.getView().getModel().getValue("org");
            if (null == org) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"AbstractOrderSplit_40", (String)"bd-mpdm-business", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            Long orgId = org.getLong("id");
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_workshopsetup", (Long)orgId);
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            col = QueryServiceHelper.query((String)"mpdm_workshopsetup", (String)"workshoporg", (QFilter[])new QFilter[]{qFilter});
            if (!col.isEmpty()) {
                HashSet<Long> idSet = new HashSet<Long>(col.size());
                for (int i = 0; i < col.size(); ++i) {
                    DynamicObject obj = (DynamicObject)col.get(i);
                    idSet.add(Long.valueOf(obj.getString("workshoporg")));
                }
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", idSet));
            } else {
                List toOrg = OrgUnitServiceHelper.getAllToOrg((String)"15", (String)"01", (Long)orgId);
                if (!toOrg.isEmpty()) {
                    listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)toOrg));
                }
            }
            listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            listShowParameter.setMultiSelect(false);
        }
        if ("org".equals(source)) {
            ListShowParameter listShowParameter2 = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter2.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        }
        if ((entryGrid = (EntryGrid)plugin.getView().getControl("spittreeentryentity")).getSelectRows().length == 0) {
            return;
        }
        int rowIndex = evt.getRow();
        if ("location".equals(source)) {
            ArrayList<Object> locationList = new ArrayList<Object>(10);
            DynamicObject warehouse = (DynamicObject)plugin.getView().getModel().getValue("warehouse", rowIndex);
            if (warehouse != null) {
                warehouse = BusinessDataServiceHelper.loadSingle((Object)warehouse.getPkValue(), (String)"bd_warehouse");
                col = warehouse.getDynamicObjectCollection("entryentity");
                for (int i = 0; i < col.size(); ++i) {
                    DynamicObject obj = (DynamicObject)col.get(i);
                    DynamicObject location = (DynamicObject)obj.get("location");
                    if (location == null) continue;
                    locationList.add(location.getPkValue());
                }
            }
            ListShowParameter listShowParameter3 = (ListShowParameter)evt.getFormShowParameter();
            Long[] qfilter = new QFilter("id", "in", locationList);
            listShowParameter3.getListFilterParameter().getQFilters().add(qfilter);
        }
        if ("warehouse".equals(source)) {
            ListShowParameter listShowParameter4;
            DynamicObject org = (DynamicObject)plugin.getView().getModel().getValue("inwardept", rowIndex);
            if (org == null) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5165\u5e93\u7ec4\u7ec7\u201d\u3002", (String)"AbstractOrderSplit_13", (String)"bd-mpdm-business", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long[] warehouseids = WarehouseHelper.getAllWarehouseIDs((Long)Long.parseLong(org.getPkValue().toString()));
            ArrayList<Long> ids = new ArrayList<Long>(10);
            for (Long warehouseid : warehouseids) {
                if (warehouseid == null) continue;
                ids.add(warehouseid);
            }
            if (!ids.isEmpty()) {
                listShowParameter4 = (ListShowParameter)evt.getFormShowParameter();
                QFilter qfilter = new QFilter("id", "in", ids);
                listShowParameter4.getListFilterParameter().getQFilters().add(qfilter);
            } else {
                listShowParameter4 = (ListShowParameter)evt.getFormShowParameter();
                QFilter qfilter = new QFilter("id", "=", (Object)Long.valueOf("0"));
                listShowParameter4.getListFilterParameter().getQFilters().add(qfilter);
            }
        }
        if ("inwardept".equals(source)) {
            List<Long> inwareOrgFilter;
            DynamicObject mftmaterial = (DynamicObject)plugin.getView().getModel().getValue("splitproduct", rowIndex);
            if (mftmaterial == null || "0".equals(mftmaterial.getPkValue().toString())) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599", (String)"AbstractOrderSplit_14", (String)"bd-mpdm-business", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            DynamicObject org = (DynamicObject)plugin.getView().getModel().getValue("splitorg", rowIndex);
            if (org != null && !(inwareOrgFilter = this.getInwareOrgFilter((Long)org.getPkValue())).isEmpty()) {
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", inwareOrgFilter));
            }
        }
        if ("splitbiztype".equals(source)) {
            DynamicObject splitbilltype = (DynamicObject)plugin.getView().getModel().getValue("splitbilltype", rowIndex);
            if (splitbilltype == null || "0".equals(splitbilltype.getPkValue().toString())) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5355\u636e\u7c7b\u578b\u201d\u3002", (String)"AbstractOrderSplit_34", (String)"bd-mpdm-business", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            List bizTypeIds = BizTypeHelper.getAllBizTypes((String)this.getReverseMfEntity(), (Long)splitbilltype.getLong("id"), (String)"bd_billtypeparameter");
            QFilter idfilter = new QFilter("id", "in", (Object)bizTypeIds);
            listShowParameter.getListFilterParameter().getQFilters().add(idfilter);
        }
        if ("splittransactiontype".equals(source)) {
            DynamicObject bizType = (DynamicObject)plugin.getView().getModel().getValue("splitbiztype", rowIndex);
            if (null == bizType || "0".equals(bizType.getPkValue().toString())) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u4e1a\u52a1\u7c7b\u578b\u201d\u3002", (String)"AbstractOrderSplit_35", (String)"bd-mpdm-business", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("transactiontype", "=", bizType.getPkValue()));
            listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            listShowParameter.setMultiSelect(false);
        }
        if ("splitsupplier".equals(source) && ((splitpurorg = (DynamicObject)plugin.getView().getModel().getValue("splitpurorg", rowIndex)) == null || "0".equals(splitpurorg.getPkValue().toString()))) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u91c7\u8d2d\u7ec4\u7ec7\u201d\u3002", (String)"AbstractOrderSplit_36", (String)"bd-mpdm-business", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void setDefaultTrans(Plugin plugin, DynamicObject bizType, int rowIndex) {
        QFilter transactiontypeFilter = new QFilter("transactiontype", "=", bizType.getPkValue());
        transactiontypeFilter.and(new QFilter("status", "=", (Object)"C"));
        transactiontypeFilter.and(new QFilter("enable", "=", (Object)"1"));
        Map load = BusinessDataServiceHelper.loadFromCache((String)"mpdm_transactproduct", (String)"number,name,isfault", (QFilter[])new QFilter[]{transactiontypeFilter});
        if (null != load) {
            Map.Entry entry;
            DynamicObject trans = null;
            Iterator iterator = load.entrySet().iterator();
            while (iterator.hasNext() && (null == (trans = (DynamicObject)(entry = iterator.next()).getValue()) || !trans.getBoolean("isfault"))) {
            }
            plugin.getView().getModel().setValue("splittransactiontype", trans, rowIndex);
        }
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void calPlanEndTime(Plugin plugin, int rowindex) {
        DynamicObject org = (DynamicObject)plugin.getView().getModel().getValue("org");
        Long orgId = org.getLong("id");
        DynamicObject mftmaterial = (DynamicObject)plugin.getView().getModel().getValue("splitproduct", rowindex);
        if (mftmaterial == null) {
            return;
        }
        Date value = (Date)plugin.getView().getModel().getValue("splitplanbegintime", rowindex);
        Date begindate = value == null ? new Date() : value;
        Date planEndDate = null;
        DynamicObject planInfo = this.getMaterialPlanInfo(plugin, rowindex);
        if (planInfo != null) {
            String leadtimetype = planInfo.getString("leadtimetype");
            int fixedleadtime = planInfo.getInt("fixedleadtime");
            int changeleadtime = planInfo.getInt("changeleadtime");
            int changebatch = planInfo.getInt("changebatch");
            if ("A".equals(leadtimetype)) {
                Date endDate;
                planEndDate = endDate = CalendarUtils.getToWorkDateToDate((int)fixedleadtime, (Date)begindate, (Long)orgId);
            } else if ("B".equals(leadtimetype)) {
                BigDecimal qty = (BigDecimal)plugin.getView().getModel().getValue("splitqty", rowindex);
                BigDecimal decChangebatch = new BigDecimal(changebatch);
                BigDecimal decChangeleadtime = new BigDecimal(changeleadtime);
                if (null != qty && null != decChangebatch && null != decChangeleadtime && changebatch != 0) {
                    Date endDate;
                    BigDecimal preTime = qty.multiply(decChangeleadtime).divide(decChangebatch, 0, 0);
                    int preDays = preTime.setScale(0, 0).intValue();
                    planEndDate = endDate = CalendarUtils.getToWorkDateToDate((int)preDays, (Date)begindate, (Long)orgId);
                }
            }
        } else {
            planEndDate = begindate;
        }
        if (planEndDate != null) {
            plugin.getView().getModel().setValue("splitplanendtime", (Object)planEndDate, rowindex);
        }
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> DynamicObject getMaterialPlanInfo(Plugin plugin, int rowindex) {
        DynamicObject bdmaterial = (DynamicObject)plugin.getView().getModel().getValue("splitproduct", rowindex);
        if (bdmaterial != null) {
            DynamicObject mftorg = (DynamicObject)plugin.getView().getModel().getValue("org");
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_materialplan", (Long)mftorg.getLong("id"));
            qFilter.and(new QFilter(MASTERID, "=", (Object)bdmaterial.getLong("id")));
            DynamicObject planInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_materialplan", (String)"yield,leadtimetype,fixedleadtime,changeleadtime,preprocessingtime,postprocessingtime,changebatch", (QFilter[])new QFilter[]{qFilter});
            if (planInfo != null) {
                return planInfo;
            }
        }
        return null;
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void propertyChangeSplitratio(Plugin plugin, ChangeData cd) {
        plugin.getView().getPageCache().put("isIgnoreChangeListener", "true");
        int index = cd.getRowIndex();
        BigDecimal newValue = (BigDecimal)cd.getNewValue();
        BigDecimal oldValue = (BigDecimal)cd.getOldValue();
        long srcEntryIdInSplitEntry = (Long)plugin.getView().getModel().getValue("splitmftorderentryid", index);
        if (0L != srcEntryIdInSplitEntry) {
            DynamicObject mftorderEntry = this.matchOrderEntryBySrcEntryId(plugin, srcEntryIdInSplitEntry);
            boolean valFlag = true;
            int precision = 2;
            String precisionaccount = "1";
            DynamicObject unit = (DynamicObject)plugin.getView().getModel().getValue("splitunit", index);
            if (null != unit) {
                precision = unit.getInt("precision");
                precisionaccount = unit.getString("precisionaccount");
            }
            if (null == mftorderEntry) {
                return;
            }
            BigDecimal qty = mftorderEntry.getBigDecimal("qty");
            BigDecimal splitqty = newValue.multiply(qty).divide(new BigDecimal(100), precision, PrecisionAccountEnum.getEnumByVal((int)Integer.parseInt(precisionaccount)));
            BigDecimal splitqtyOld = (BigDecimal)plugin.getView().getModel().getValue("splitqty", index);
            plugin.getView().getModel().setValue("splitqty", (Object)splitqty, index);
            DynamicObject material = (DynamicObject)plugin.getView().getModel().getValue("splitproduct", index);
            DynamicObject splitbaseunit = (DynamicObject)plugin.getView().getModel().getValue("splitbaseunit", index);
            BigDecimal splitbaseqty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)splitqty, (DynamicObject)splitbaseunit);
            String mforderName = this.getSplitModel().getMforderName();
            BigDecimal aseparableqty = mftorderEntry.getBigDecimal("separableqty");
            BigDecimal orderqty = mftorderEntry.getBigDecimal("qty");
            BigDecimal totalseparableqty = this.recalTotalseparableqty(plugin, index, splitqty.subtract(splitqtyOld), false, false);
            if (aseparableqty.compareTo(BigDecimal.ZERO) > 0) {
                if (totalseparableqty.compareTo(aseparableqty) > 0) {
                    plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u8868\u4f53\u7b2c%2$s\u884c\u5b58\u5728\u53ef\u62c6\u5206\u6570\u91cf\u65f6\uff0c\u5408\u8ba1\u62c6\u5206\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u53ef\u62c6\u5206\u6570\u91cf\uff0c\u8bf7\u4fee\u6539\u62c6\u5206\u6bd4\u4f8b\u3002", (String)"AbstractOrderSplit_15", (String)"bd-mpdm-business", (Object[])new Object[0]), mforderName, mftorderEntry.getString("seq")));
                    plugin.getView().getModel().setValue("splitqty", (Object)splitqtyOld, index);
                    plugin.getView().getModel().setValue("splitratio", (Object)oldValue, index);
                    valFlag = false;
                }
                if (totalseparableqty.compareTo(orderqty) == 0) {
                    BigDecimal inwarbaseqty = mftorderEntry.getBigDecimal("inwarbaseqty");
                    BigDecimal rptqty = mftorderEntry.getBigDecimal("rptqty");
                    if (inwarbaseqty.compareTo(BigDecimal.ZERO) <= 0 && rptqty.compareTo(BigDecimal.ZERO) <= 0) {
                        String errorInfo = String.format(ResManager.loadKDString((String)"%1$s\u8868\u4f53\u7b2c%2$s\u884c\u4e0d\u5141\u8bb8\u5168\u90e8\u62c6\u5206\uff0c\u8bf7\u4fee\u6539\u62c6\u5206\u6bd4\u4f8b\u3002", (String)"AbstractOrderSplit_30", (String)"bd-mpdm-business", (Object[])new Object[0]), mforderName, mftorderEntry.getString("seq"));
                        plugin.getView().showTipNotification(errorInfo);
                        plugin.getView().getModel().setValue("splitqty", (Object)splitqtyOld, index);
                        plugin.getView().getModel().setValue("splitratio", (Object)oldValue, index);
                        valFlag = false;
                    }
                }
            } else if (totalseparableqty.compareTo(qty) >= 0) {
                plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u8868\u4f53\u7b2c%2$s\u884c\u4e0d\u5b58\u5728\u53ef\u62c6\u5206\u6570\u91cf\u65f6\uff0c\u5408\u8ba1\u62c6\u5206\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u751f\u4ea7\u6570\u91cf\uff0c\u8bf7\u4fee\u6539\u62c6\u5206\u6bd4\u4f8b\u3002", (String)"AbstractOrderSplit_16", (String)"bd-mpdm-business", (Object[])new Object[0]), mforderName, mftorderEntry.getString("seq")));
                plugin.getView().getModel().setValue("splitqty", (Object)oldValue, index);
                plugin.getView().getModel().setValue("splitqty", (Object)splitqtyOld, index);
                plugin.getView().getModel().setValue("splitratio", (Object)oldValue, index);
                valFlag = false;
            }
            if (valFlag) {
                plugin.getView().getModel().setValue("splitbaseqty", (Object)splitbaseqty, index);
                this.recalTotalseparableqty(plugin, index, splitqty.subtract(splitqtyOld), false, true);
                DynamicObject entry = plugin.getView().getModel().getEntryRowEntity("spittreeentryentity", index);
                DynamicObject auxptyUnit = (DynamicObject)plugin.getView().getModel().getValue("splitauxptyunit", index);
                BigDecimal splitauxptyqty = AuxQtyAndUnitHelper.changeUntAndQty((DynamicObject)entry, (DynamicObject)material, (DynamicObject)auxptyUnit, (String)"splitbaseqty", (String)"splitbaseunit", (String)"splitauxptyunit");
                if (null != splitauxptyqty) {
                    plugin.getView().getModel().setValue("splitauxptyqty", (Object)splitauxptyqty, index);
                }
            }
        }
        plugin.getView().getPageCache().put("isIgnoreChangeListener", "false");
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void propertyChangeSplitBatchMode(Plugin plugin, ChangeData cd) {
        plugin.getView().getPageCache().put("isIgnoreChangeListener", "true");
        int index = cd.getRowIndex();
        String newValue = (String)cd.getNewValue();
        if (StringUtils.equals((CharSequence)"A", (CharSequence)newValue)) {
            long srcEntryIdInSplitEntry = (Long)plugin.getView().getModel().getValue("splitmftorderentryid", index);
            if (0L != srcEntryIdInSplitEntry) {
                DynamicObject mftorderEntry = this.matchOrderEntryBySrcEntryId(plugin, srcEntryIdInSplitEntry);
                plugin.getView().getModel().setValue("splitbatchno", (Object)(null == mftorderEntry ? "" : mftorderEntry.getString("batchno")), index);
            }
        } else {
            plugin.getView().getModel().setValue("splitbatchno", (Object)"", index);
        }
        plugin.getView().getPageCache().put("isIgnoreChangeListener", "false");
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void propertyChangeSplitqty(Plugin plugin, ChangeData cd) {
        if (plugin.getView().getPageCache().get("isIgnoreChangeListener") == "true") {
            return;
        }
        plugin.getView().getPageCache().put("isIgnoreChangeListener", "true");
        int index = cd.getRowIndex();
        BigDecimal newValue = (BigDecimal)cd.getNewValue();
        BigDecimal oldValue = (BigDecimal)cd.getOldValue();
        Long srcEntryIdInSplitEntry = (Long)plugin.getView().getModel().getValue("splitmftorderentryid", index);
        if (0L == srcEntryIdInSplitEntry) {
            return;
        }
        DynamicObjectCollection mftorderEntryDynCol = plugin.getView().getModel().getEntryEntity("treeentryentity");
        for (DynamicObject mftorderEntry : mftorderEntryDynCol) {
            DynamicObject auxptyUnit;
            BigDecimal splitauxptyqty;
            Long srcEntryId = mftorderEntry.getLong("mftorderentryid");
            if (!srcEntryIdInSplitEntry.equals(srcEntryId)) continue;
            boolean valFlag = true;
            BigDecimal aseparableqty = mftorderEntry.getBigDecimal("separableqty");
            BigDecimal orderqty = mftorderEntry.getBigDecimal("qty");
            BigDecimal totalseparableqty = this.recalTotalseparableqty(plugin, index, newValue.subtract(oldValue == null ? BigDecimal.ZERO : oldValue), false, false);
            BigDecimal qty = mftorderEntry.getBigDecimal("qty");
            BigDecimal splitratio = newValue.multiply(new BigDecimal(100)).divide(qty, 2, 4);
            DynamicObject material = (DynamicObject)plugin.getView().getModel().getValue("splitproduct", index);
            DynamicObject unit = (DynamicObject)plugin.getView().getModel().getValue("splitunit", index);
            DynamicObject splitbaseunit = (DynamicObject)plugin.getView().getModel().getValue("splitbaseunit", index);
            BigDecimal splitbaseqty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)newValue, (DynamicObject)splitbaseunit);
            String mforderName = this.getSplitModel().getMforderName();
            if (aseparableqty.compareTo(BigDecimal.ZERO) > 0) {
                if (totalseparableqty.compareTo(aseparableqty) > 0) {
                    plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u8868\u4f53\u7b2c%2$s\u884c\u5b58\u5728\u53ef\u62c6\u5206\u6570\u91cf\u65f6\uff0c\u5408\u8ba1\u62c6\u5206\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u53ef\u62c6\u5206\u6570\u91cf\uff0c\u8bf7\u4fee\u6539\u62c6\u5206\u6570\u91cf\u3002", (String)"AbstractOrderSplit_17", (String)"bd-mpdm-business", (Object[])new Object[0]), mforderName, mftorderEntry.getString("seq")));
                    plugin.getView().getModel().setValue("splitqty", (Object)oldValue, index);
                    valFlag = false;
                }
                if (totalseparableqty.compareTo(orderqty) == 0) {
                    BigDecimal inwarbaseqty = mftorderEntry.getBigDecimal("inwarbaseqty");
                    BigDecimal rptqty = mftorderEntry.getBigDecimal("rptqty");
                    if (inwarbaseqty.compareTo(BigDecimal.ZERO) <= 0 && rptqty.compareTo(BigDecimal.ZERO) <= 0) {
                        String errorInfo = String.format(ResManager.loadKDString((String)"%1$s\u8868\u4f53\u7b2c%2$s\u884c\u4e0d\u5141\u8bb8\u5168\u90e8\u62c6\u5206\uff0c\u8bf7\u4fee\u6539\u62c6\u5206\u6570\u91cf\u3002", (String)"AbstractOrderSplit_31", (String)"bd-mpdm-business", (Object[])new Object[0]), mforderName, mftorderEntry.getString("seq"));
                        plugin.getView().showTipNotification(errorInfo);
                        plugin.getView().getModel().setValue("splitqty", (Object)oldValue, index);
                        valFlag = false;
                    }
                }
            } else if (totalseparableqty.compareTo(qty) >= 0) {
                plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u8868\u4f53\u7b2c%2$s\u884c\u4e0d\u5b58\u5728\u53ef\u62c6\u5206\u6570\u91cf\u65f6\uff0c\u5408\u8ba1\u62c6\u5206\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u751f\u4ea7\u6570\u91cf\uff0c\u8bf7\u4fee\u6539\u62c6\u5206\u6570\u91cf\u3002", (String)"AbstractOrderSplit_18", (String)"bd-mpdm-business", (Object[])new Object[0]), mforderName, mftorderEntry.getString("seq")));
                plugin.getView().getModel().setValue("splitqty", (Object)oldValue, index);
                valFlag = false;
            }
            if (!valFlag) break;
            plugin.getView().getModel().setValue("splitratio", (Object)splitratio, index);
            plugin.getView().getModel().setValue("splitbaseqty", (Object)splitbaseqty, index);
            this.recalTotalseparableqty(plugin, index, newValue.subtract(oldValue == null ? BigDecimal.ZERO : oldValue), false, true);
            DynamicObject entry = plugin.getView().getModel().getEntryRowEntity("spittreeentryentity", index);
            if (plugin.getView().getModel().getValue("splitauxptyunit", index) == null || null == (splitauxptyqty = AuxQtyAndUnitHelper.changeUntAndQty((DynamicObject)entry, (DynamicObject)material, (DynamicObject)(auxptyUnit = (DynamicObject)plugin.getView().getModel().getValue("splitauxptyunit", index)), (String)"splitbaseqty", (String)"splitbaseunit", (String)"splitauxptyunit"))) break;
            plugin.getView().getModel().setValue("splitauxptyqty", (Object)splitauxptyqty, index);
            break;
        }
        this.calPlanEndTime(plugin, index);
        plugin.getView().getPageCache().put("isIgnoreChangeListener", "false");
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void propertyChangeSplitAuxptyqty(Plugin plugin, ChangeData cd) {
        if (plugin.getView().getPageCache().get("isIgnoreChangeListener") == "true") {
            return;
        }
        plugin.getView().getPageCache().put("isIgnoreChangeListener", "true");
        int index = cd.getRowIndex();
        BigDecimal newValue = (BigDecimal)cd.getNewValue();
        BigDecimal oldValue = (BigDecimal)cd.getOldValue();
        long srcEntryIdInSplitEntry = (Long)plugin.getView().getModel().getValue("splitmftorderentryid", index);
        DynamicObject material = (DynamicObject)plugin.getView().getModel().getValue("splitproduct");
        DynamicObject splitOrderEntry = plugin.getView().getModel().getEntryRowEntity("spittreeentryentity", index);
        DynamicObject mftorderEntry = this.matchOrderEntryBySrcEntryId(plugin, srcEntryIdInSplitEntry);
        if (0L != srcEntryIdInSplitEntry && null != mftorderEntry) {
            boolean isConvert;
            String selectProperties = "auxptyunit,unitconvertdir";
            material = BusinessDataServiceHelper.loadSingleFromCache((Object)material.getPkValue(), (String)"bd_material", (String)selectProperties);
            String unitConvertDir = material.getString("unitconvertdir");
            boolean bl = isConvert = UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
            if (isConvert) {
                DynamicObject splitunit = splitOrderEntry.getDynamicObject("splitunit");
                DynamicObject splitauxptyunit = splitOrderEntry.getDynamicObject("splitauxptyunit");
                BigDecimal qty = mftorderEntry.getBigDecimal("qty");
                boolean valFlag = true;
                String mforderName = this.getSplitModel().getMforderName();
                BigDecimal splitqtyOld = (BigDecimal)plugin.getView().getModel().getValue("splitqty", index);
                DynamicObject splitbaseunit = (DynamicObject)plugin.getView().getModel().getValue("splitbaseunit", index);
                BigDecimal splitbaseqty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)splitauxptyunit, (BigDecimal)newValue, (DynamicObject)splitbaseunit);
                BigDecimal splitqty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)splitbaseunit, (BigDecimal)splitbaseqty, (DynamicObject)splitunit);
                BigDecimal aseparableqty = mftorderEntry.getBigDecimal("separableqty");
                BigDecimal orderqty = mftorderEntry.getBigDecimal("qty");
                BigDecimal totalseparableqty = this.recalTotalseparableqty(plugin, index, splitqty.subtract(splitqtyOld), false, false);
                if (aseparableqty.compareTo(BigDecimal.ZERO) > 0) {
                    if (totalseparableqty.compareTo(aseparableqty) > 0) {
                        plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u8868\u4f53\u7b2c%2$s\u884c\u5b58\u5728\u53ef\u62c6\u5206\u6570\u91cf\u65f6\uff0c\u5408\u8ba1\u62c6\u5206\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u53ef\u62c6\u5206\u6570\u91cf\uff0c\u8bf7\u4fee\u6539\u62c6\u5206\u6bd4\u4f8b\u3002", (String)"AbstractOrderSplit_15", (String)"bd-mpdm-business", (Object[])new Object[0]), mforderName, mftorderEntry.getString("seq")));
                        plugin.getView().getModel().setValue("splitauxptyqty", (Object)oldValue, index);
                        valFlag = false;
                    }
                    if (totalseparableqty.compareTo(orderqty) == 0) {
                        BigDecimal inwarbaseqty = mftorderEntry.getBigDecimal("inwarbaseqty");
                        BigDecimal rptqty = mftorderEntry.getBigDecimal("rptqty");
                        if (inwarbaseqty.compareTo(BigDecimal.ZERO) <= 0 && rptqty.compareTo(BigDecimal.ZERO) <= 0) {
                            String errorInfo = String.format(ResManager.loadKDString((String)"%1$s\u8868\u4f53\u7b2c%2$s\u884c\u4e0d\u5141\u8bb8\u5168\u90e8\u62c6\u5206\uff0c\u8bf7\u4fee\u6539\u62c6\u5206\u6bd4\u4f8b\u3002", (String)"AbstractOrderSplit_30", (String)"bd-mpdm-business", (Object[])new Object[0]), mforderName, mftorderEntry.getString("seq"));
                            plugin.getView().showTipNotification(errorInfo);
                            plugin.getView().getModel().setValue("splitauxptyqty", (Object)oldValue, index);
                            valFlag = false;
                        }
                    }
                } else if (totalseparableqty.compareTo(qty) >= 0) {
                    plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u8868\u4f53\u7b2c%2$s\u884c\u4e0d\u5b58\u5728\u53ef\u62c6\u5206\u6570\u91cf\u65f6\uff0c\u5408\u8ba1\u62c6\u5206\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u751f\u4ea7\u6570\u91cf\uff0c\u8bf7\u4fee\u6539\u62c6\u5206\u6bd4\u4f8b\u3002", (String)"AbstractOrderSplit_16", (String)"bd-mpdm-business", (Object[])new Object[0]), mforderName, mftorderEntry.getString("seq")));
                    plugin.getView().getModel().setValue("splitauxptyqty", (Object)oldValue, index);
                    valFlag = false;
                }
                if (valFlag) {
                    BigDecimal splitratio = splitqty.multiply(new BigDecimal(100)).divide(qty, 2, 4);
                    plugin.getView().getModel().setValue("splitqty", (Object)splitqty, index);
                    plugin.getView().getModel().setValue("splitratio", (Object)splitratio, index);
                    plugin.getView().getModel().setValue("splitbaseqty", (Object)splitbaseqty, index);
                    this.recalTotalseparableqty(plugin, index, splitqty.subtract(splitqtyOld), false, true);
                }
            }
        }
        plugin.getView().getPageCache().put("isIgnoreChangeListener", "false");
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> BigDecimal recalTotalseparableqty(Plugin plugin, int index, BigDecimal difference, boolean showTipFlag, boolean calBasQtyFlag) {
        BigDecimal totalseparableqty = new BigDecimal(0);
        long srcEntryId = (Long)plugin.getView().getModel().getValue("splitmftorderentryid", index);
        String mforderName = this.getSplitModel().getMforderName();
        DynamicObject orderEntry = this.matchOrderEntryBySrcEntryId(plugin, srcEntryId);
        if (null != orderEntry) {
            int orderEntryIndex = orderEntry.getInt("seq") - 1;
            BigDecimal qty = orderEntry.getBigDecimal("qty");
            DynamicObject product = orderEntry.getDynamicObject("product");
            DynamicObject unit = orderEntry.getDynamicObject("unit");
            DynamicObject baseunit = orderEntry.getDynamicObject("baseunit");
            BigDecimal rptqty = orderEntry.getBigDecimal("rptqty");
            BigDecimal inwarqty = orderEntry.getBigDecimal("inwarqty");
            BigDecimal separableqty = orderEntry.getBigDecimal("separableqty");
            int seqInOrderEntry = orderEntry.getInt("seq");
            totalseparableqty = orderEntry.getBigDecimal("totalseparableqty");
            totalseparableqty = totalseparableqty.add(difference);
            if (showTipFlag) {
                BigDecimal inwarbaseqty;
                if (totalseparableqty.compareTo(separableqty) > 0) {
                    plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u8868\u4f53\u7b2c%2$s\u884c\u5b58\u5728\u53ef\u62c6\u5206\u6570\u91cf\u65f6\uff0c\u5408\u8ba1\u62c6\u5206\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u53ef\u62c6\u5206\u6570\u91cf\uff0c\u8bf7\u4fee\u6539\u62c6\u5206\u6570\u91cf\u3002", (String)"AbstractOrderSplit_17", (String)"bd-mpdm-business", (Object[])new Object[0]), mforderName, seqInOrderEntry));
                    return new BigDecimal(-1);
                }
                if (totalseparableqty.compareTo(qty) == 0 && (inwarbaseqty = orderEntry.getBigDecimal("inwarbaseqty")).compareTo(BigDecimal.ZERO) <= 0 && rptqty.compareTo(BigDecimal.ZERO) <= 0) {
                    String errorInfo = String.format(ResManager.loadKDString((String)"%1$s\u8868\u4f53\u7b2c%2$s\u884c\u4e0d\u5141\u8bb8\u5168\u90e8\u62c6\u5206\uff0c\u8bf7\u4fee\u6539\u62c6\u5206\u6570\u91cf\u3002", (String)"AbstractOrderSplit_31", (String)"bd-mpdm-business", (Object[])new Object[0]), mforderName, seqInOrderEntry);
                    plugin.getView().showTipNotification(errorInfo);
                    return new BigDecimal(-1);
                }
            }
            if (calBasQtyFlag) {
                if (qty.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal totalseparableratio = totalseparableqty.multiply(new BigDecimal(100)).divide(qty, 2, 4);
                    plugin.getView().getModel().setValue("totalseparableratio", (Object)totalseparableratio, orderEntryIndex);
                }
                BigDecimal totalseparablebaseqty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)product, (DynamicObject)unit, (BigDecimal)totalseparableqty, (DynamicObject)baseunit);
                plugin.getView().getModel().setValue("totalseparablebaseqty", (Object)totalseparablebaseqty, orderEntryIndex);
                plugin.getView().getModel().setValue("totalseparableqty", (Object)totalseparableqty, orderEntryIndex);
            }
        }
        return totalseparableqty;
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void chooseMftorder(Plugin plugin, BeforeDoOperationEventArgs e) {
        DynamicObject org = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)plugin.getView().getModel(), (String)"org");
        if (null == org) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"AbstractOrderSplit_40", (String)"bd-mpdm-business", (Object[])new Object[0]));
            e.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)this.getSplitModel().getMforder(), (boolean)false);
        this.genShowFilters(plugin, showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setMultiSelect(Boolean.TRUE.booleanValue());
        CloseCallBack closeCallBack = new CloseCallBack(plugin, "choose");
        showParameter.setCloseCallBack(closeCallBack);
        plugin.getView().showForm((FormShowParameter)showParameter);
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void genShowFilters(Plugin plugin, ListShowParameter showParameter) {
        List filters = showParameter.getListFilterParameter().getQFilters();
        DynamicObject orgInfo = (DynamicObject)plugin.getView().getModel().getValue("org");
        filters.add(new QFilter("org", "=", null == orgInfo ? Long.valueOf(0L) : orgInfo.get("id")));
        DynamicObject producedept = (DynamicObject)plugin.getView().getModel().getValue("producedept");
        if (null != producedept) {
            filters.add(new QFilter("treeentryentity.producedept", "=", producedept.get("id")));
        }
        filters.add(new QFilter("treeentryentity.producttype", "=", (Object)"C"));
        HashSet orderStatusList = Sets.newHashSet((Object[])new String[]{"A", "B", "C"});
        filters.add(new QFilter("billstatus", "in", (Object)orderStatusList));
        HashSet taskstatusList = Sets.newHashSet((Object[])new String[]{"A", "B", "D"});
        filters.add(new QFilter("treeentryentity.taskstatus", "in", (Object)taskstatusList));
        filters.add(new QFilter("treeentryentity.bizstatus", "=", (Object)"A"));
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> Set<Long> getSelectedMftorderEntrysIds(Plugin plugin) {
        HashSet<Long> selectedMftorderEntrysIds = new HashSet<Long>(16);
        DynamicObjectCollection dynamicObjectCollection = plugin.getView().getModel().getEntryEntity("treeentryentity");
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            long srcEntryId = dynamicObject.getLong("mftorderentryid");
            selectedMftorderEntrysIds.add(srcEntryId);
        }
        return selectedMftorderEntrysIds;
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void clearPurOrg(Plugin plugin) {
        DynamicObjectCollection entryRowEntity = plugin.getView().getModel().getEntryEntity("spittreeentryentity");
        for (int i = 0; i < entryRowEntity.size(); ++i) {
            String splitType = (String)plugin.getView().getModel().getValue("splittype", i);
            if (!"P".equals(splitType)) continue;
            plugin.getView().getModel().setValue("splitpurorg", null, i);
        }
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void recalOrderEntry(Plugin plugin, DynamicObject splitEntry) {
        if (null != splitEntry && 0L != splitEntry.getLong("splitmftorderentryid")) {
            BigDecimal splitqty = splitEntry.getBigDecimal("splitqty");
            Long srcEntryId = splitEntry.getLong("splitmftorderentryid");
            DynamicObjectCollection orderEntrys = plugin.getView().getModel().getEntryEntity("treeentryentity");
            for (DynamicObject orderEntry : orderEntrys) {
                Long srcEntryIdTemp = orderEntry.getLong("mftorderentryid");
                if (!srcEntryId.equals(srcEntryIdTemp)) continue;
                int index = orderEntry.getInt("seq") - 1;
                DynamicObject product = orderEntry.getDynamicObject("product");
                DynamicObject unit = orderEntry.getDynamicObject("unit");
                DynamicObject baseunit = orderEntry.getDynamicObject("baseunit");
                BigDecimal qty = orderEntry.getBigDecimal("qty");
                BigDecimal separatedqty = orderEntry.getBigDecimal("separatedqty");
                BigDecimal separatedqtyNew = separatedqty.add(splitqty);
                plugin.getView().getModel().setValue("separatedqty", (Object)separatedqtyNew, index);
                BigDecimal separatedratio = separatedqtyNew.multiply(new BigDecimal(100)).divide(qty, 2, 4);
                plugin.getView().getModel().setValue("separatedratio", (Object)separatedratio, index);
                BigDecimal separatedqtyBaseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)product, (DynamicObject)unit, (BigDecimal)separatedqtyNew, (DynamicObject)baseunit);
                plugin.getView().getModel().setValue("separatedbaseqty", (Object)separatedqtyBaseQty, index);
                break;
            }
        }
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void countEntryQty(Plugin plugin) {
        DynamicObjectCollection mftorderEntryDynCol = plugin.getView().getModel().getEntryEntity("treeentryentity");
        for (DynamicObject mftorderEntryDyn : mftorderEntryDynCol) {
            int seq = mftorderEntryDyn.getInt("seq");
            long srcEntryIdInMftorderEntryDyn = mftorderEntryDyn.getLong("mftorderentryid");
            BigDecimal separatedqty = mftorderEntryDyn.getBigDecimal("separatedqty");
            BigDecimal totalseparableqty = this.countTotalseparableqty(plugin, srcEntryIdInMftorderEntryDyn).add(separatedqty);
            plugin.getView().getModel().setValue("totalseparableqty", (Object)totalseparableqty, seq - 1);
            BigDecimal qty = mftorderEntryDyn.getBigDecimal("qty");
            BigDecimal totalseparableratio = totalseparableqty.multiply(new BigDecimal(100)).divide(qty, 2, 4);
            plugin.getView().getModel().setValue("totalseparableratio", (Object)totalseparableratio, seq - 1);
            DynamicObject material = mftorderEntryDyn.getDynamicObject("product");
            DynamicObject unit = mftorderEntryDyn.getDynamicObject("unit");
            DynamicObject baseunit = mftorderEntryDyn.getDynamicObject("baseunit");
            BigDecimal totalseparablebaseqty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)totalseparableqty, (DynamicObject)baseunit);
            plugin.getView().getModel().setValue("totalseparablebaseqty", (Object)totalseparablebaseqty, seq - 1);
        }
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> BigDecimal countTotalseparableqty(Plugin plugin, Long srcEntryId) {
        BigDecimal totalseparableqty = BigDecimal.ZERO;
        if (0L != srcEntryId) {
            DynamicObjectCollection splitEntryDynCol = plugin.getView().getModel().getEntryEntity("spittreeentryentity");
            for (DynamicObject splitEntryDyn : splitEntryDynCol) {
                Long srcEntryIdInSplitEntryDyn = splitEntryDyn.getLong("splitmftorderentryid");
                if (!srcEntryId.equals(srcEntryIdInSplitEntryDyn)) continue;
                BigDecimal qtyInSplitEntry = splitEntryDyn.getBigDecimal("splitqty");
                totalseparableqty = totalseparableqty.add(qtyInSplitEntry);
            }
        }
        return totalseparableqty;
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void getMftBillEntry(Plugin plugin, DynamicObject[] orderBillcol, Set<Long> mftorderEntryIds, Map<Long, BigDecimal> transferMap) {
        if (null != orderBillcol) {
            int[] splitSeqArr;
            Set<Long> filterEntryIdsList = this.getSelectedMftorderEntrysIds(plugin);
            AbstractFormDataModel model = (AbstractFormDataModel)plugin.getView().getModel();
            HashSet<Long> srcEntryIds = new HashSet<Long>(16);
            srcEntryIds.add(0L);
            int[] seqArr = this.needDeleteRows(plugin, "treeentryentity", "mftorderentryid", (Set<Long>)srcEntryIds);
            if (null != seqArr && seqArr.length > 0) {
                model.deleteEntryRows("treeentryentity", seqArr);
            }
            if (null != (splitSeqArr = this.needDeleteRows(plugin, "spittreeentryentity", "splitmftorderentryid", (Set<Long>)srcEntryIds)) && splitSeqArr.length > 0) {
                model.deleteEntryRows("spittreeentryentity", splitSeqArr);
            }
            model.beginInit();
            TableValueSetter mftOrderTablevs = new TableValueSetter(new String[0]);
            List<String> fields = this.getMftOrderTableSetterFields();
            for (String field : fields) {
                mftOrderTablevs.addField(field, new Object[0]);
            }
            TableValueSetter splitTablevs = new TableValueSetter(new String[0]);
            List<String> splitFields = this.getsplitTableSetterFields();
            for (String field : splitFields) {
                splitTablevs.addField(field, new Object[0]);
            }
            DynamicObject[] techBillcol = this.getTechBillCol(mftorderEntryIds);
            DynamicObject[] stockBillcol = this.getStockBillCol(mftorderEntryIds);
            ArrayList<String> repeatEntryInfos = new ArrayList<String>(10);
            for (DynamicObject mftorderDyn : orderBillcol) {
                DynamicObjectCollection mftOrderEntrys;
                if (null == mftorderDyn || null == (mftOrderEntrys = mftorderDyn.getDynamicObjectCollection("treeentryentity"))) continue;
                for (DynamicObject mftOrderEntry : mftOrderEntrys) {
                    Long entryId = Long.parseLong(mftOrderEntry.getPkValue().toString());
                    if (filterEntryIdsList.contains(entryId)) {
                        String repeatInfo = String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c", (String)"AbstractOrderSplit_7", (String)"bd-mpdm-business", (Object[])new Object[0]), mftorderDyn.getString("billno"), mftOrderEntry.getString("seq"));
                        repeatEntryInfos.add(repeatInfo);
                        continue;
                    }
                    if (!mftorderEntryIds.contains(entryId)) continue;
                    DynamicObject techBill = OrderSpliteService.matchTechBill(techBillcol, entryId);
                    DynamicObject stockBill = StockCulUtils.matchStockBill(stockBillcol, entryId);
                    this.fillTableFromRow(mftOrderTablevs, splitTablevs, mftorderDyn, mftOrderEntry, techBill, stockBill, transferMap);
                }
            }
            model.batchCreateNewEntryRow("treeentryentity", mftOrderTablevs);
            plugin.getView().updateView("treeentryentity");
            model.batchCreateNewEntryRow("spittreeentryentity", splitTablevs);
            plugin.getView().updateView("spittreeentryentity");
            model.endInit();
            plugin.getView().setEnable(Boolean.FALSE, new String[]{"org"});
            plugin.getView().setEnable(Boolean.FALSE, new String[]{"producedept"});
            if (repeatEntryInfos.size() > 0) {
                String info = Joiner.on((String)",").join(repeatEntryInfos);
                plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u91cd\u590d\u9009\u62e9\u7684\u5de5\u5355\u884c\u6570\u636e\u4e0d\u518d\u91cd\u590d\u6dfb\u52a0\uff1a%1$s\u3002", (String)"AbstractOrderSplit_19", (String)"bd-mpdm-business", (Object[])new Object[0]), info));
            }
        }
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> int[] needDeleteRows(Plugin plugin, String entryEntity, String srcEntryIdEntity, Set<Long> entryIds) {
        HashSet<Integer> set = new HashSet<Integer>(16);
        if (null != entryIds) {
            for (Long entryId : entryIds) {
                DynamicObjectCollection dynamicObjectCollection = plugin.getView().getModel().getEntryEntity(entryEntity);
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    Long srcEntryId = dynamicObject.getLong(srcEntryIdEntity);
                    if (!entryId.equals(srcEntryId)) continue;
                    set.add(dynamicObject.getInt("seq") - 1);
                }
            }
        }
        if (null != set && !set.isEmpty()) {
            return set.stream().mapToInt(Integer::intValue).toArray();
        }
        return null;
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void createOrderBill(Plugin plugin, BeforeDoOperationEventArgs e) {
        EntryGrid entryGrid = (EntryGrid)plugin.getView().getControl("spittreeentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AbstractOrderSplit_9", (String)"bd-mpdm-business", (Object[])new Object[0]));
            e.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        ArrayList<String> seqList = new ArrayList<String>(10);
        for (int i = 0; i < entryGrid.getSelectRows().length; ++i) {
            BigDecimal splitqty;
            int index = entryGrid.getSelectRows()[i];
            DynamicObject splitEntryDym = plugin.getView().getModel().getEntryRowEntity("spittreeentryentity", index);
            if (null == splitEntryDym || (splitqty = splitEntryDym.getBigDecimal("splitqty")).compareTo(BigDecimal.ZERO) > 0) continue;
            seqList.add(splitEntryDym.getString("seq"));
        }
        int splitlimit = (Integer)plugin.getView().getModel().getValue("splitlimit");
        if (entryGrid.getSelectRows().length > splitlimit) {
            plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7d2f\u8ba1\u9009\u62e9\u884c\u6570\u8d85\u8fc7\u5141\u8bb8\u64cd\u4f5c\u6570\u91cf\uff1a%1$s\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractOrderSplit_20", (String)"bd-mpdm-business", (Object[])new Object[0]), splitlimit));
            e.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        if (seqList.size() > 0) {
            String seqs = Joiner.on((String)",").join(seqList);
            plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u62c6\u5206\u660e\u7ec6\u7b2c%1$s\u884c\u6ca1\u6709\u586b\u5199\u62c6\u5206\u6570\u91cf\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractOrderSplit_21", (String)"bd-mpdm-business", (Object[])new Object[0]), seqs));
            e.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void createOrderBillAfterOpt(Plugin plugin, FormOperate operate) {
        operate.getOption().setVariableValue("opProgressCache", plugin.getView().getPageId());
        this.startOpProgress(plugin, operate.getOperateKey());
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void startOpProgress(Plugin plugin, String operateKey) {
        HashMap<String, String> para = new HashMap<String, String>(16);
        para.put("formId", this.getSplitModel().getSplitProgressFormId());
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        CloseCallBack closeCallBack = new CloseCallBack(plugin, "progressbarap");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("operateKey", (Object)operateKey);
        plugin.getView().showForm(showParameter);
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void opSplitDelete(Plugin plugin) {
        BigDecimal splitQtyInMap;
        HashMap<Long, BigDecimal> splitQtyDeleteMap = new HashMap<Long, BigDecimal>(16);
        EntryGrid entryGrid = (EntryGrid)plugin.getView().getControl("spittreeentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length >= 1) {
            for (int i = 0; i < entryGrid.getSelectRows().length; ++i) {
                int index = entryGrid.getSelectRows()[i];
                DynamicObject splitEntryDym = plugin.getView().getModel().getEntryRowEntity("spittreeentryentity", index);
                if (null == splitEntryDym) continue;
                long srcEntryIdInSplitEntry = splitEntryDym.getLong("splitmftorderentryid");
                BigDecimal splitQty = splitEntryDym.getBigDecimal("splitqty");
                splitQtyInMap = (BigDecimal)splitQtyDeleteMap.get(srcEntryIdInSplitEntry);
                if (null == splitQtyInMap) {
                    splitQtyInMap = BigDecimal.ZERO;
                }
                splitQtyDeleteMap.put(srcEntryIdInSplitEntry, splitQtyInMap.add(splitQty));
            }
        }
        DynamicObjectCollection orderEntrys = plugin.getView().getModel().getEntryEntity("treeentryentity");
        for (DynamicObject orderEntry : orderEntrys) {
            int index = orderEntry.getInt("seq") - 1;
            long orderEntryId = orderEntry.getLong("mftorderentryid");
            splitQtyInMap = (BigDecimal)splitQtyDeleteMap.get(orderEntryId);
            if (null == splitQtyInMap) {
                splitQtyInMap = BigDecimal.ZERO;
            }
            BigDecimal totalseparableqty = orderEntry.getBigDecimal("totalseparableqty").subtract(splitQtyInMap);
            plugin.getView().getModel().setValue("totalseparableqty", (Object)totalseparableqty, index);
            BigDecimal qty = orderEntry.getBigDecimal("qty");
            if (qty.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal totalseparableratio = totalseparableqty.multiply(new BigDecimal(100)).divide(qty, 2, 4);
                plugin.getView().getModel().setValue("totalseparableratio", (Object)totalseparableratio, index);
            }
            DynamicObject product = orderEntry.getDynamicObject("product");
            DynamicObject unit = orderEntry.getDynamicObject("unit");
            DynamicObject baseunit = orderEntry.getDynamicObject("baseunit");
            BigDecimal totalseparablebaseqty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)product, (DynamicObject)unit, (BigDecimal)totalseparableqty, (DynamicObject)baseunit);
            plugin.getView().getModel().setValue("totalseparablebaseqty", (Object)totalseparablebaseqty, index);
            plugin.getView().getModel().setValue("totalseparableqty", (Object)totalseparableqty, index);
        }
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void opSplitCopy(Plugin plugin, BeforeDoOperationEventArgs e) {
        EntryGrid entryGrid = (EntryGrid)plugin.getView().getControl("spittreeentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length > 1) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"AbstractOrderSplit_12", (String)"bd-mpdm-business", (Object[])new Object[0]));
            e.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void opOrderDelete(Plugin plugin) {
        EntryGrid entryGrid = (EntryGrid)plugin.getView().getControl("treeentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length > 0) {
            int[] splitSeqArr;
            HashSet<Long> srcEntryIds = new HashSet<Long>(selectRows.length);
            for (int i = 0; i < entryGrid.getSelectRows().length; ++i) {
                int index = entryGrid.getSelectRows()[i];
                DynamicObject orderEntryDym = plugin.getView().getModel().getEntryRowEntity("treeentryentity", index);
                if (null == orderEntryDym) continue;
                long srcEntryIdInOrderEntry = orderEntryDym.getLong("mftorderentryid");
                srcEntryIds.add(srcEntryIdInOrderEntry);
            }
            int[] seqArr = this.needDeleteRows(plugin, "treeentryentity", "mftorderentryid", (Set<Long>)srcEntryIds);
            if (null != seqArr && seqArr.length > 0) {
                plugin.getView().getModel().deleteEntryRows("treeentryentity", seqArr);
            }
            if (null != (splitSeqArr = this.needDeleteRows(plugin, "spittreeentryentity", "splitmftorderentryid", (Set<Long>)srcEntryIds)) && splitSeqArr.length > 0) {
                plugin.getView().getModel().deleteEntryRows("spittreeentryentity", splitSeqArr);
            }
        } else {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AbstractOrderSplit_9", (String)"bd-mpdm-business", (Object[])new Object[0]));
            return;
        }
    }

    protected boolean checkOrgIsAccount(Long orgid) {
        DynamicObject dyOrg = null;
        try {
            dyOrg = OrgQueryHelper.getDataCacheByID((Object)orgid);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null == dyOrg ? false : dyOrg.getBoolean("fisaccounting");
    }

    protected List<Long> getInwareOrgFilter(Long mftOrg) {
        ArrayList<Long> filterList = new ArrayList<Long>(10);
        if (this.checkOrgIsAccount(mftOrg)) {
            List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)mftOrg);
            if (!allToOrg.isEmpty()) {
                filterList.addAll(allToOrg);
            }
        } else {
            List fromOrgs = OrgUnitServiceHelper.getFromOrgs((String)"04", (Long)mftOrg, (String)"10");
            if (fromOrgs.isEmpty()) {
                Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)mftOrg, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                Integer fromOrg = map == null || map.isEmpty() ? Integer.valueOf(0) : map.get("id");
                Long longFromOrg = (Long)((Object)fromOrg);
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)longFromOrg);
                if (!allToOrg.isEmpty()) {
                    filterList.addAll(allToOrg);
                }
            } else {
                Long fromOrg = (Long)fromOrgs.get(0);
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)fromOrg);
                if (!allToOrg.isEmpty()) {
                    filterList.addAll(allToOrg);
                }
            }
        }
        return filterList;
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> DynamicObject matchOrderEntryBySrcEntryId(Plugin plugin, long srcEntryId) {
        DynamicObject result = null;
        DynamicObjectCollection orderEntrys = plugin.getView().getModel().getEntryEntity("treeentryentity");
        for (DynamicObject orderEntry : orderEntrys) {
            long srcEntryIdInOrderEntry = orderEntry.getLong("mftorderentryid");
            if (srcEntryId != srcEntryIdInOrderEntry) continue;
            result = orderEntry;
        }
        return result;
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void opSplitBatch(Plugin plugin, BeforeDoOperationEventArgs e) {
        EntryGrid entryGrid = (EntryGrid)plugin.getView().getControl("spittreeentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AbstractOrderSplit_9", (String)"bd-mpdm-business", (Object[])new Object[0]));
            e.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        if (selectRows.length > 1) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u884c\u6279\u91cf\u62c6\u5206\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"AbstractOrderSplit_38", (String)"bd-mpdm-business", (Object[])new Object[0]));
            e.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void afterSplitBatch(Plugin plugin) {
        EntryGrid entryGrid = (EntryGrid)plugin.getView().getControl("spittreeentryentity");
        DynamicObject entryRowEntity = plugin.getView().getModel().getEntryRowEntity("spittreeentryentity", entryGrid.getSelectRows()[0]);
        HashMap<String, String> para = new HashMap<String, String>(16);
        para.put("formId", this.getSplitModel().getBatchSplitFormId());
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        CloseCallBack closeCallBack = new CloseCallBack(plugin, "batchSplit");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("data", this.buildBatchSplitData(plugin, entryRowEntity));
        plugin.getView().showForm(showParameter);
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> Map<String, Object> buildBatchSplitData(Plugin plugin, DynamicObject dynamicObject) {
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("splitorderno", dynamicObject.get("splitorderno"));
        if (dynamicObject.getDynamicObject("splitorderseq") != null) {
            data.put("splitorderseq", dynamicObject.getDynamicObject("splitorderseq").getPkValue());
        }
        if (dynamicObject.getDynamicObject("splitunit") != null) {
            data.put("splitunit", dynamicObject.getDynamicObject("splitunit").getPkValue());
        }
        data.put("splitqty", dynamicObject.get("splitqty"));
        if (dynamicObject.getDynamicObject("splitbaseunit") != null) {
            data.put("splitbaseunit", dynamicObject.getDynamicObject("splitbaseunit").getPkValue());
        }
        data.put("splitbaseqty", dynamicObject.get("splitbaseqty"));
        if (dynamicObject.getDynamicObject("splitauxptyunit") != null) {
            data.put("splitauxptyunit", dynamicObject.getDynamicObject("splitauxptyunit").getPkValue());
        }
        data.put("splitauxptyqty", dynamicObject.get("splitauxptyqty"));
        data.put("splitratio", dynamicObject.get("splitratio"));
        data.put("splitlimit", plugin.getView().getModel().getValue("splitlimit"));
        return data;
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void setBizType(Plugin plugin, DynamicObject billType, int rowIndex, String billEntityKey) {
        if (null != billType) {
            DynamicObject billTypeParam = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)billEntityKey, (String)"bd_billtypeparameter", (long)billType.getLong("id"));
            DynamicObject defaultBizType = null;
            DynamicObject bizType = null;
            if (billTypeParam != null) {
                HashSet<Object> bizTypIds = new HashSet<Object>(16);
                DynamicObjectCollection entryentity = billTypeParam.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentity) {
                    bizTypIds.add(entry.getDynamicObject("biztypenumber").getPkValue());
                    if (!entry.getBoolean("isdefault")) continue;
                    defaultBizType = entry.getDynamicObject("biztypenumber");
                }
                Map bizTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_biztype", (String)"id,number,enable", (QFilter[])new QFilter[]{new QFilter("id", "in", bizTypIds)});
                for (Map.Entry objectEntry : bizTypeMap.entrySet()) {
                    DynamicObject obj = (DynamicObject)objectEntry.getValue();
                    Boolean enable = obj.getBoolean("enable");
                    if (!enable.booleanValue()) continue;
                    bizType = obj;
                    if (null == defaultBizType || !obj.getPkValue().equals(defaultBizType.getPkValue())) continue;
                    break;
                }
                plugin.getView().getModel().setValue("splitbiztype", bizType, rowIndex);
            }
        }
    }

    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void splitBizTypeBeforeF7(Plugin plugin, BeforeF7SelectEvent evt, String billEntityKey) {
        DynamicObject splitbilltype = (DynamicObject)plugin.getView().getModel().getValue("splitbilltype", evt.getRow());
        if (splitbilltype == null || "0".equals(splitbilltype.getPkValue().toString())) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5355\u636e\u7c7b\u578b\u201d\u3002", (String)"AbstractOrderSplit_34", (String)"bd-mpdm-business", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        List bizTypeIds = BizTypeHelper.getAllBizTypes((String)billEntityKey, (Long)splitbilltype.getLong("id"), (String)"bd_billtypeparameter");
        QFilter idfilter = new QFilter("id", "in", (Object)bizTypeIds);
        listShowParameter.getListFilterParameter().getQFilters().add(idfilter);
    }

    private <Plugin extends AbstractFormPlugin & RowClickEventListener> void propertyChangeSplitType(Plugin plugin, ChangeData cd) {
        if ("true".equals(plugin.getView().getPageCache().get("isIgnoreChangeListener"))) {
            return;
        }
        plugin.getView().getPageCache().put("isIgnoreChangeListener", "true");
        int rowIndex = cd.getRowIndex();
        Object newValue = cd.getNewValue();
        Object oldValue = cd.getOldValue();
        if (newValue != null) {
            if (this.getSplitModel().getDefaultSplitType().equals(newValue.toString())) {
                Long splitmftorderentryid = (Long)plugin.getView().getModel().getValue("splitmftorderentryid", rowIndex);
                DynamicObjectCollection dynamicObjectCollection = plugin.getView().getModel().getEntryEntity("treeentryentity");
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    Long srcEntryId = dynamicObject.getLong("mftorderentryid");
                    if (!srcEntryId.equals(splitmftorderentryid)) continue;
                    DynamicObject billtype = dynamicObject.getDynamicObject("billtype");
                    plugin.getView().getModel().setValue("splitbilltype", (Object)billtype, rowIndex);
                    DynamicObject bizType = dynamicObject.getDynamicObject("biztype");
                    plugin.getView().getModel().setValue("splitbiztype", (Object)bizType, rowIndex);
                    DynamicObject transactiontype = dynamicObject.getDynamicObject("transactiontype");
                    plugin.getView().getModel().setValue("splittransactiontype", (Object)transactiontype, rowIndex);
                    plugin.getView().getModel().setValue("splitpurorg", dynamicObject.containsProperty("purorg") ? dynamicObject.get("purorg") : null, rowIndex);
                    plugin.getView().getModel().setValue("splitsupplier", dynamicObject.containsProperty("supplier") ? dynamicObject.get("supplier") : null, rowIndex);
                }
            } else if (StringUtils.isNotEmpty((CharSequence)newValue.toString())) {
                boolean isPush;
                Boolean flag = Boolean.TRUE;
                Long mftorderEntryId = (Long)plugin.getView().getModel().getValue("splitmftorderentryid", rowIndex);
                Object splitorderno = plugin.getView().getModel().getValue("splitorderno", rowIndex);
                DynamicObject splitorderseq = (DynamicObject)plugin.getView().getModel().getValue("splitorderseq", rowIndex);
                List<DynamicObject> manftechInfos = OrderSplitValidateService.queryPushedManftechInfos(this.getSplitModel().getMforder(), Sets.newHashSet((Object[])new Long[]{mftorderEntryId}));
                String manftechEntityKey = MftManftechIdentityEnum.getBillIdentityByEntityKey((String)this.getSplitModel().getMforder());
                if (CollectionUtils.isNotEmpty(manftechInfos) && (isPush = BFTrackerServiceHelper.isPush((String)manftechEntityKey, (Long)manftechInfos.get(0).getLong("id")))) {
                    String warningMsg = this.getWarningMsg(newValue, splitorderno, splitorderseq);
                    plugin.getView().showTipNotification(warningMsg);
                    plugin.getView().getModel().setValue("splittype", oldValue, rowIndex);
                    flag = Boolean.FALSE;
                }
                if (flag.booleanValue()) {
                    QFilter qFilter = new QFilter("billformid", "=", (Object)this.getReverseMfEntity());
                    qFilter.and(new QFilter("isdefault", "=", (Object)true));
                    qFilter.and(new QFilter("status", "=", (Object)"C"));
                    qFilter.and(new QFilter("enable", "=", (Object)"1"));
                    DynamicObject billtype = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billtype", (QFilter[])qFilter.toArray());
                    plugin.getView().getModel().setValue("splitbilltype", (Object)billtype, rowIndex);
                    this.setBizType(plugin, billtype, rowIndex, this.getReverseMfEntity());
                    DynamicObject bizType = (DynamicObject)plugin.getView().getModel().getValue("splitbiztype", rowIndex);
                    if (null != bizType) {
                        this.setDefaultTrans(plugin, bizType, rowIndex);
                    }
                    if ("O".equals(newValue)) {
                        DynamicObject org = (DynamicObject)plugin.getView().getModel().getValue("org");
                        List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"", (String)"02", (Long)org.getLong("id"), (boolean)true);
                        Long id = 0L;
                        if (CollectionUtils.isNotEmpty((Collection)allToOrg)) {
                            id = allToOrg.contains(org.getLong("id")) ? Long.valueOf(org.getLong("id")) : (Long)allToOrg.get(0);
                        } else {
                            List orgIds = OrgUnitServiceHelper.getAllOrg((String)"02");
                            id = (Long)orgIds.get(0);
                        }
                        plugin.getView().getModel().setValue("splitpurorg", (Object)id, rowIndex);
                    } else {
                        plugin.getView().getModel().setValue("splitpurorg", null, rowIndex);
                        plugin.getView().getModel().setValue("splitsupplier", null, rowIndex);
                    }
                }
            }
            plugin.getView().getPageCache().put("isIgnoreChangeListener", "false");
        }
    }

    private <Plugin extends AbstractFormPlugin & RowClickEventListener> void propertyChangeBillType(Plugin plugin, ChangeData cd) {
        int rowIndex = cd.getRowIndex();
        DynamicObject billtype = (DynamicObject)cd.getNewValue();
        this.setBizType(plugin, billtype, rowIndex, this.getReverseMfEntity());
        DynamicObject bizType = (DynamicObject)plugin.getView().getModel().getValue("splitbiztype", rowIndex);
        if (null != bizType) {
            this.setDefaultTrans(plugin, bizType, rowIndex);
        } else {
            plugin.getView().getModel().setValue("splittransactiontype", null, rowIndex);
        }
    }

    protected String getReverseMfEntity() {
        String mfOrderEntity;
        String reversEntity = null;
        switch (mfOrderEntity = this.getSplitModel().getMforder()) {
            case "om_mftorder": {
                reversEntity = "pom_mftorder";
                break;
            }
            default: {
                reversEntity = "om_mftorder";
            }
        }
        return reversEntity;
    }

    protected Object getPkValue(DynamicObject dynamicObject) {
        return dynamicObject == null ? Long.valueOf(0L) : dynamicObject.getPkValue();
    }

    private String getWarningMsg(Object splitType, Object splitorderno, DynamicObject entrySeqObj) {
        int entrySeq = null == entrySeqObj ? 1 : entrySeqObj.getInt("entryseq");
        String warningMsg = null;
        switch (String.valueOf(splitType)) {
            case "O": {
                warningMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7b2c%2$s\u884c\u5206\u5f55\u4e0d\u80fd\u62c6\u5206\u6210\u59d4\u5916\u5de5\u5355\uff0c\u539f\u56e0\uff1a\u5de5\u5e8f\u8ba1\u5212\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u3002", (String)"AbstractOrderSplit_33", (String)"bd-mpdm-business", (Object[])new Object[0]), splitorderno, entrySeq);
                break;
            }
            case "P": {
                warningMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7b2c%2$s\u884c\u5206\u5f55\u4e0d\u80fd\u62c6\u5206\u6210\u751f\u4ea7\u5de5\u5355\uff0c\u539f\u56e0\uff1a\u5de5\u5e8f\u8ba1\u5212\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u3002", (String)"AbstractOrderSplit_39", (String)"bd-mpdm-business", (Object[])new Object[0]), splitorderno, entrySeq);
                break;
            }
            default: {
                warningMsg = "";
            }
        }
        return warningMsg;
    }
}

