/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.ordersplit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.mftorder.OrderSpliteService;
import kd.bd.mpdm.business.mftorder.StockCulUtils;
import kd.bd.mpdm.business.mftorder.splitmodel.SplitModel;
import kd.bd.mpdm.business.mftorder.validate.OrderSplitValidateService;
import kd.bd.mpdm.business.ordersplit.AbstractOrderSplit;
import kd.bd.mpdm.business.ordersplit.OrderSplitFactory;
import kd.bd.mpdm.common.mftorder.helper.BillUnitAndQtytHelper;
import kd.bd.mpdm.common.utils.AuxQtyAndUnitHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;

public class OrderSplitOm
extends AbstractOrderSplit {
    private static final String PURORG = "purorg";
    private static final String PURPUSHQTY = "purpushqty";
    private static final String SUPPLIER = "supplier";

    @Override
    public SplitModel getSplitModel() {
        return OrderSplitFactory.getSplitModel("om_mftorder");
    }

    @Override
    public String getMftOrderSelects() {
        return "billno,billtype,transactiontype,org,treeentryentity,treeentryentity.material,treeentryentity.producedept,treeentryentity.unit,treeentryentity.qty,treeentryentity.purorg,treeentryentity.supplier,treeentryentity.baseunit,treeentryentity.baseqty,treeentryentity.manuversion,treeentryentity.bomid,treeentryentity.expendbomtime,treeentryentity.planpreparetime,treeentryentity.planbegintime,treeentryentity.planendtime,treeentryentity.processroute,treeentryentity.routereplace,treeentryentity.planstatus,treeentryentity.taskstatus,treeentryentity.bizstatus,treeentryentity.workcenter,treeentryentity.purpushqty,treeentryentity.inwardept,treeentryentity.warehouse,treeentryentity.location,treeentryentity.rptqty,treeentryentity.stockqty,treeentryentity.seq,treeentryentity.auxptyunit,treeentryentity.auxptyqty,treeentryentity.batchno,treeentryentity.materielinv,treeentryentity.planbaseqty,treeentryentity.baseqty,treeentryentity.id";
    }

    @Override
    public List<String> getMftOrderTableSetterFields() {
        ArrayList<String> fieldsList = new ArrayList<String>(50);
        fieldsList.add("orderno");
        fieldsList.add("orderseq");
        fieldsList.add("mftorderentryid");
        fieldsList.add("billtype");
        fieldsList.add("biztype");
        fieldsList.add("transactiontype");
        fieldsList.add("product");
        fieldsList.add("batchno");
        fieldsList.add("orderproducedept");
        fieldsList.add(PURORG);
        fieldsList.add(SUPPLIER);
        fieldsList.add("unit");
        fieldsList.add("qty");
        fieldsList.add("baseunit");
        fieldsList.add("baseqty");
        fieldsList.add("auxptyunit");
        fieldsList.add("auxptyqty");
        fieldsList.add("manuversion");
        fieldsList.add("bomid");
        fieldsList.add("expendbomtime");
        fieldsList.add("planpreparetime");
        fieldsList.add("planbegintime");
        fieldsList.add("planendtime");
        fieldsList.add("processroute");
        fieldsList.add("routereplace");
        fieldsList.add("planstatus");
        fieldsList.add("taskstatus");
        fieldsList.add("bizstatus");
        fieldsList.add("workcenter");
        fieldsList.add("rptqty");
        fieldsList.add("rptbaseqty");
        fieldsList.add(PURPUSHQTY);
        fieldsList.add("inwarqty");
        fieldsList.add("inwarbaseqty");
        fieldsList.add("separableqty");
        fieldsList.add("separableratio");
        fieldsList.add("separablebaseqty");
        fieldsList.add("totalseparableqty");
        fieldsList.add("totalseparableratio");
        fieldsList.add("totalseparablebaseqty");
        fieldsList.add("separatedqty");
        fieldsList.add("separatedratio");
        fieldsList.add("separatedbaseqty");
        return fieldsList;
    }

    @Override
    public List<String> getsplitTableSetterFields() {
        ArrayList<String> fieldsList = new ArrayList<String>(50);
        fieldsList.add("splitreason");
        fieldsList.add("splitorderno");
        fieldsList.add("splitorderseq");
        fieldsList.add("splitmftorderentryid");
        fieldsList.add("splittype");
        fieldsList.add("splitorg");
        fieldsList.add("splitbilltype");
        fieldsList.add("splitbiztype");
        fieldsList.add("splittransactiontype");
        fieldsList.add("splitproduct");
        fieldsList.add("splitmaterielinv");
        fieldsList.add("splitpurorg");
        fieldsList.add("splitsupplier");
        fieldsList.add("splitproducedept");
        fieldsList.add("splitunit");
        fieldsList.add("splitbatchmode");
        fieldsList.add("splitqty");
        fieldsList.add("splitbatchno");
        fieldsList.add("splitratio");
        fieldsList.add("splitbaseunit");
        fieldsList.add("splitbaseqty");
        fieldsList.add("splitmanuversion");
        fieldsList.add("splitbomid");
        fieldsList.add("splitauxptyunit");
        fieldsList.add("splitauxptyqty");
        fieldsList.add("splitexpendbomtime");
        fieldsList.add("splitplanpreparetime");
        fieldsList.add("splitplanbegintime");
        fieldsList.add("splitplanendtime");
        fieldsList.add("splitprocessroute");
        fieldsList.add("splitroutereplace");
        fieldsList.add("splitworkcenter");
        fieldsList.add("inwardept");
        fieldsList.add("warehouse");
        fieldsList.add("location");
        return fieldsList;
    }

    @Override
    public DynamicObject[] getStockBillCol(Set<Long> mftorderEntryIds) {
        return StockCulUtils.queryOmStocks(mftorderEntryIds);
    }

    @Override
    public DynamicObject[] getTechBillCol(Set<Long> mftorderEntryIds) {
        return OrderSpliteService.queryOmTechBillcol(mftorderEntryIds);
    }

    @Override
    public void fillTableFromRow(TableValueSetter mftorderTablevs, TableValueSetter splitTablevs, DynamicObject mftorderBill, DynamicObject mftorderEntry, DynamicObject techBill, DynamicObject stockBill, Map<Long, BigDecimal> transferMap) {
        String billNo = mftorderBill.getString("billno");
        DynamicObject billtype = mftorderBill.getDynamicObject("billtype");
        DynamicObject org = mftorderBill.getDynamicObject("org");
        DynamicObject transactiontype = mftorderBill.getDynamicObject("transactiontype");
        DynamicObject bizType = transactiontype.getDynamicObject("transactiontype");
        long mftorderentryid = mftorderEntry.getLong("id");
        DynamicObject material = mftorderEntry.getDynamicObject("material");
        DynamicObject masteridObj = null == material ? null : material.getDynamicObject("masterid");
        DynamicObject producedept = mftorderEntry.getDynamicObject("producedept");
        DynamicObject unit = mftorderEntry.getDynamicObject("unit");
        BigDecimal qty = mftorderEntry.getBigDecimal("qty");
        DynamicObject baseunit = mftorderEntry.getDynamicObject("baseunit");
        BigDecimal baseqty = mftorderEntry.getBigDecimal("baseqty");
        DynamicObject manuversion = mftorderEntry.getDynamicObject("manuversion");
        DynamicObject bomid = mftorderEntry.getDynamicObject("bomid");
        Date expendbomtime = mftorderEntry.getDate("expendbomtime");
        Date planpreparetime = mftorderEntry.getDate("planpreparetime");
        Date planbegintime = mftorderEntry.getDate("planbegintime");
        Date planendtime = mftorderEntry.getDate("planendtime");
        DynamicObject processroute = mftorderEntry.getDynamicObject("processroute");
        DynamicObject routereplace = mftorderEntry.getDynamicObject("routereplace");
        String planstatus = mftorderEntry.getString("planstatus");
        String taskstatus = mftorderEntry.getString("taskstatus");
        String bizstatus = mftorderEntry.getString("bizstatus");
        DynamicObject workcenter = mftorderEntry.getDynamicObject("workcenter");
        DynamicObject inwardept = mftorderEntry.getDynamicObject("inwardept");
        DynamicObject warehouse = mftorderEntry.getDynamicObject("warehouse");
        DynamicObject location = mftorderEntry.getDynamicObject("location");
        DynamicObject auxptyunit = mftorderEntry.getDynamicObject("auxptyunit");
        BigDecimal auxptyqty = mftorderEntry.getBigDecimal("auxptyqty");
        String batchno = mftorderEntry.getString("batchno");
        String splitbatchmode = "A";
        String splitbatchno = batchno;
        DynamicObject splitmaterielinv = mftorderEntry.getDynamicObject("materielinv");
        BigDecimal rptqty = mftorderEntry.getBigDecimal("rptqty");
        BigDecimal inwarbaseqty = mftorderEntry.getBigDecimal("stockqty");
        BigDecimal rptbaseqty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)masteridObj, (DynamicObject)unit, (BigDecimal)rptqty, (DynamicObject)baseunit);
        BigDecimal inwarqty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)masteridObj, (DynamicObject)baseunit, (BigDecimal)inwarbaseqty, (DynamicObject)unit);
        BigDecimal separableratio = BigDecimal.ZERO;
        BigDecimal separablebaseqty = OrderSplitValidateService.omCalSeparableBaseQty(transactiontype, mftorderEntry, transferMap, techBill);
        separablebaseqty = separablebaseqty.compareTo(BigDecimal.ZERO) > 0 ? separablebaseqty : BigDecimal.ZERO;
        BigDecimal separableqty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)masteridObj, (DynamicObject)baseunit, (BigDecimal)separablebaseqty, (DynamicObject)unit);
        if (qty.compareTo(BigDecimal.ZERO) != 0) {
            separableratio = separableqty.multiply(new BigDecimal(100)).divide(qty, 2, 4);
        }
        mftorderEntry.set("baseqty", (Object)separablebaseqty);
        BigDecimal auxptyqtyInSplit = AuxQtyAndUnitHelper.changeUntAndQty((DynamicObject)mftorderEntry, (DynamicObject)masteridObj, (DynamicObject)auxptyunit, (String)"baseqty", (String)"baseunit", (String)"auxptyunit");
        mftorderEntry.set("baseqty", (Object)baseqty);
        DynamicObject purOrg = mftorderEntry.getDynamicObject(PURORG);
        DynamicObject supplier = mftorderEntry.getDynamicObject(SUPPLIER);
        mftorderTablevs.addRow(new Object[]{billNo, mftorderentryid, mftorderentryid, this.getPkValue(billtype), this.getPkValue(bizType), this.getPkValue(transactiontype), this.getPkValue(masteridObj), batchno, this.getPkValue(producedept), this.getPkValue(purOrg), this.getPkValue(supplier), this.getPkValue(unit), qty, this.getPkValue(baseunit), baseqty, this.getPkValue(auxptyunit), auxptyqty, this.getPkValue(manuversion), this.getPkValue(bomid), expendbomtime, planpreparetime, planbegintime, planendtime, this.getPkValue(processroute), this.getPkValue(routereplace), planstatus, taskstatus, bizstatus, this.getPkValue(workcenter), rptqty, rptbaseqty, mftorderEntry.getBigDecimal(PURPUSHQTY), inwarqty, inwarbaseqty, separableqty, separableratio, separablebaseqty});
        splitTablevs.addRow(new Object[]{0L, billNo, mftorderentryid, mftorderentryid, "O", this.getPkValue(org), this.getPkValue(billtype), this.getPkValue(bizType), this.getPkValue(transactiontype), this.getPkValue(masteridObj), this.getPkValue(splitmaterielinv), this.getPkValue(purOrg), this.getPkValue(supplier), this.getPkValue(producedept), this.getPkValue(unit), splitbatchmode, separableqty, splitbatchno, separableratio, this.getPkValue(baseunit), separablebaseqty, this.getPkValue(manuversion), this.getPkValue(bomid), this.getPkValue(auxptyunit), separableqty == null ? null : auxptyqtyInSplit, expendbomtime, planpreparetime, planbegintime, planendtime, this.getPkValue(processroute), this.getPkValue(routereplace), this.getPkValue(workcenter), this.getPkValue(inwardept), this.getPkValue(warehouse), this.getPkValue(location)});
    }

    @Override
    public String checkOrderEntryQty(Map<Long, BigDecimal> transferMap, DynamicObject orderBill, DynamicObject orderEntry, DynamicObject techBill, String opName) {
        return OrderSplitValidateService.omCheckOrderEntryQtyNew(orderEntry, orderBill, transferMap, techBill);
    }

    @Override
    public <Plugin extends AbstractFormPlugin & RowClickEventListener> void beforeBindData(Plugin plugin, EventObject e) {
        super.beforeBindData(plugin, e);
        plugin.getView().setEnable(Boolean.TRUE, new String[]{"org"});
        plugin.getView().setEnable(Boolean.TRUE, new String[]{"producedept"});
    }

    @Override
    public <Plugin extends AbstractFormPlugin & RowClickEventListener> void beforeF7Select(Plugin plugin, BeforeF7SelectEvent evt) {
        String source;
        super.beforeF7Select(plugin, evt);
        Control con = (Control)evt.getSource();
        switch (source = con.getKey()) {
            case "splitpurorg": {
                this.beforePurOrgF7Select(evt);
                break;
            }
            case "splitsupplier": {
                this.beforeSupplierF7Select(plugin, evt);
                break;
            }
        }
    }

    @Override
    protected <Plugin extends AbstractFormPlugin & RowClickEventListener> void getMftBillEntry(Plugin plugin, DynamicObject[] orderBillcol, Set<Long> mftorderEntryIds, Map<Long, BigDecimal> transferMap) {
        super.getMftBillEntry(plugin, orderBillcol, mftorderEntryIds, transferMap);
        plugin.getView().getModel().setValue("producedept", null);
        plugin.getView().setEnable(Boolean.TRUE, new String[]{"org"});
        plugin.getView().setEnable(Boolean.TRUE, new String[]{"producedept"});
    }

    private void beforePurOrgF7Select(BeforeF7SelectEvent e) {
        FormShowParameter formShowParameter = e.getFormShowParameter();
        if (formShowParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)formShowParameter;
            listShowParameter.setMultiSelect(false);
        }
    }

    private <Plugin extends AbstractFormPlugin & RowClickEventListener> void beforeSupplierF7Select(Plugin plugin, BeforeF7SelectEvent event) {
        int row = event.getRow();
        Object value = plugin.getView().getModel().getValue("splitpurorg", row);
        if (value == null) {
            event.setCancel(true);
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\"\u91c7\u8d2d\u7ec4\u7ec7\"\u3002", (String)"OrderSplitOm_1", (String)"mmc-om-business", (Object[])new Object[0]));
        }
    }
}

