/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.state.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;

public class BillFieldEntityHelper {
    public static List<TreeNode> buildFldCalTreeNodes(BillTreeBuildParameter parameter) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        MainEntityType mainType = parameter.getMainType();
        HashSet<String> selectedEntity = new HashSet<String>();
        selectedEntity.addAll(parameter.getSelectedEntity());
        if (selectedEntity.size() == 0) {
            selectedEntity = new HashSet();
            for (String entityKey : mainType.getAllEntities().keySet()) {
                selectedEntity.add(entityKey);
            }
        }
        for (Map.Entry entry : mainType.getAllEntities().entrySet()) {
            EntityType entityType;
            if (!selectedEntity.contains(entry.getKey()) || (entityType = (EntityType)entry.getValue()) instanceof LinkEntryType) continue;
            String entityNodeId = entityType.getName();
            String entityNodeName = "";
            boolean isHead = false;
            if (entityType instanceof MainEntityType) {
                entityNodeName = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"BillFieldEntityHelper_0", (String)"bd-mpdm-business", (Object[])new Object[0]);
                entityNodeId = "billhead";
                isHead = true;
            } else if (entityType.getDisplayName() != null) {
                entityNodeName = entityType.getDisplayName().toString();
            }
            TreeNode entityNode = new TreeNode(mainType.getName(), entityNodeId, entityNodeName);
            entityNode.setIsOpened(true);
            ArrayList<TreeNode> entityFldNodes = new ArrayList<TreeNode>();
            if (parameter.isIncludePKField()) {
                BillFieldEntityHelper.buildPKFldTreeNode(entityType, entityNode, entityFldNodes, parameter);
            }
            for (IDataEntityProperty property : entityType.getFields().values()) {
                BasedataProp bdProp;
                MainEntityType bdType;
                List<TreeNode> refNodes;
                boolean matched = false;
                if (parameter.isOnlyPhysicsField() && StringUtils.isBlank((CharSequence)property.getAlias()) || "id".equalsIgnoreCase(property.getName()) || "seq".equalsIgnoreCase(property.getName())) continue;
                TreeNode fldNode = null;
                fldNode = isHead ? BillFieldEntityHelper.BuildFldTreeNode(property, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, "", parameter.isDynamicText()) : BillFieldEntityHelper.BuildFldTreeNode(property, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, entityType.getExtendName(), parameter.isDynamicText());
                if (fldNode != null) {
                    entityFldNodes.add(fldNode);
                    matched = true;
                }
                if (!(property instanceof BasedataProp)) continue;
                if (fldNode == null) {
                    fldNode = BillFieldEntityHelper.BuildFldTreeNode(property, null, null, entityNode, "", parameter.isDynamicText());
                }
                if ((refNodes = BillFieldEntityHelper.BuildBDFldRefPropNodes(bdType = (MainEntityType)(bdProp = (BasedataProp)property).getComplexType(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), fldNode, entityType.getExtendName() + '.' + property.getName(), parameter.isDynamicText())).size() <= 0) continue;
                entityFldNodes.addAll(refNodes);
                if (matched) continue;
                entityFldNodes.add(fldNode);
            }
            if (entityFldNodes.size() <= 0) continue;
            nodes.add(entityNode);
            nodes.addAll(entityFldNodes);
        }
        return nodes;
    }

    private static TreeNode BuildFldTreeNode(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode parentNode, String prefix, boolean isDynamicText) {
        TreeNode fldNode = null;
        boolean isMatch = BillFieldEntityHelper.isMatchType(fldProperty, matchedProperty, matchedClassType);
        DynamicProperty prop = null;
        if (fldProperty instanceof DynamicProperty) {
            prop = (DynamicProperty)fldProperty;
        }
        if (isMatch && prop != null) {
            String fullPropName;
            String fldNodeId = fullPropName = StringUtils.isBlank((CharSequence)prefix) ? prop.getName() : prefix + "." + prop.getName();
            if (isDynamicText) {
                fldNodeId = "{" + fullPropName + "}";
            }
            String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName);
            fldNode.setIsOpened(false);
        }
        return fldNode;
    }

    private static boolean isMatchType(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType) {
        boolean isMatch = true;
        if (matchedClassType != null && !matchedClassType.isInstance(fldProperty)) {
            isMatch = false;
        }
        if (matchedProperty != null) {
            if (matchedProperty instanceof BasedataProp && fldProperty instanceof BasedataProp) {
                BasedataProp bdProp1 = (BasedataProp)matchedProperty;
                BasedataProp bdProp2 = (BasedataProp)fldProperty;
                if (matchedProperty.getClass().isInstance(fldProperty)) {
                    return true;
                }
                if (bdProp1.isFromSampleMaster((IDataEntityProperty)bdProp2)) {
                    return true;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)bdProp1.getBaseEntityId(), (CharSequence)bdProp2.getBaseEntityId())) {
                    isMatch = false;
                }
            } else if (!matchedProperty.getClass().isInstance(fldProperty)) {
                isMatch = false;
            }
            if (!isMatch && (matchedProperty instanceof DateProp || matchedProperty instanceof DateTimeProp) && (fldProperty instanceof DateProp || fldProperty instanceof DateTimeProp)) {
                isMatch = true;
            } else if (!isMatch && (matchedProperty instanceof IntegerProp || matchedProperty instanceof DecimalProp || matchedProperty instanceof QtyProp) && (fldProperty instanceof IntegerProp || fldProperty instanceof DecimalProp || fldProperty instanceof QtyProp)) {
                isMatch = true;
            } else if (!isMatch && (matchedProperty instanceof TextProp || matchedProperty instanceof MuliLangTextProp || matchedProperty instanceof ComboProp) && (fldProperty instanceof TextProp || fldProperty instanceof MuliLangTextProp || fldProperty instanceof ComboProp)) {
                isMatch = true;
            }
        }
        return isMatch;
    }

    private static List<TreeNode> BuildBDFldRefPropNodes(MainEntityType bdType, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode bdFldNode, String prefix, boolean isDynamicText) {
        ArrayList<TreeNode> refNodes = new ArrayList<TreeNode>();
        if (bdType == null) {
            return refNodes;
        }
        for (IDataEntityProperty property : bdType.getFields().values()) {
            String prefix2;
            BasedataProp bdProp2;
            MainEntityType bdType2;
            List<TreeNode> refNodes2;
            if (property instanceof EntryProp) continue;
            TreeNode fldNode = BillFieldEntityHelper.BuildFldTreeNode(property, matchedProperty, matchedClassType, bdFldNode, prefix, isDynamicText);
            boolean matched = false;
            if (fldNode != null) {
                refNodes.add(fldNode);
                matched = true;
            }
            if (!(property instanceof BasedataProp)) continue;
            if (fldNode == null) {
                fldNode = BillFieldEntityHelper.BuildFldTreeNode(property, null, null, bdFldNode, prefix, isDynamicText);
            }
            if ((refNodes2 = BillFieldEntityHelper.BuildBDFldRefPropNodes(bdType2 = (MainEntityType)(bdProp2 = (BasedataProp)property).getComplexType(), matchedProperty, matchedClassType, fldNode, prefix2 = prefix + "." + property.getName(), isDynamicText)).size() <= 0) continue;
            refNodes.addAll(refNodes2);
            if (matched) continue;
            refNodes.add(fldNode);
        }
        return refNodes;
    }

    private static void buildPKFldTreeNode(EntityType entityType, TreeNode entityNode, List<TreeNode> entityFldNodes, BillTreeBuildParameter parameter) {
        if (entityType instanceof MainEntityType) {
            TreeNode idNode = BillFieldEntityHelper.BuildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, "", parameter.isDynamicText());
            if (idNode != null) {
                String info = String.format(ResManager.loadKDString((String)"%1$s.\u5185\u7801", (String)"BillFieldEntityHelper_4", (String)"bd-mpdm-business", (Object[])new Object[0]), entityType.getDisplayName().toString());
                idNode.setText(info);
                entityFldNodes.add(idNode);
            }
        } else {
            TreeNode seqNode;
            DynamicProperty seqProp;
            TreeNode idNode = BillFieldEntityHelper.BuildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, entityType.getName(), parameter.isDynamicText());
            if (idNode != null) {
                String info = String.format(ResManager.loadKDString((String)"%1$s.\u5185\u7801", (String)"BillFieldEntityHelper_4", (String)"bd-mpdm-business", (Object[])new Object[0]), entityType.getDisplayName().toString());
                idNode.setText(info);
                entityFldNodes.add(idNode);
            }
            if ((seqProp = entityType.getProperty("seq")) != null && (seqNode = BillFieldEntityHelper.BuildFldTreeNode((IDataEntityProperty)seqProp, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, entityType.getName(), parameter.isDynamicText())) != null) {
                String info = String.format(ResManager.loadKDString((String)"%1$s.\u5e8f\u53f7", (String)"BillFieldEntityHelper_5", (String)"bd-mpdm-business", (Object[])new Object[0]), entityType.getDisplayName().toString());
                seqNode.setText(info);
                entityFldNodes.add(seqNode);
            }
        }
    }
}

