/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.state.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.state.helper.BillFieldEntityHelper;
import kd.bd.mpdm.common.state.model.StateRuleBcModel;
import kd.bd.mpdm.common.state.model.StateRuleBtModel;
import kd.bd.mpdm.common.state.model.StateRuleMmModel;
import kd.bd.mpdm.common.state.model.StateRuleModel;
import kd.bd.mpdm.common.state.model.StateSchemeModel;
import kd.bd.mpdm.common.state.model.StateStrategyModel;
import kd.bd.mpdm.common.state.utils.StateUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class StateHelper {
    public static TreeNode buildCalTreeNodes(BillTreeBuildParameter parameter) {
        MainEntityType mainType = parameter.getMainType();
        TreeNode billNode = new TreeNode("", mainType.getName(), mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        List<TreeNode> fldNodes = BillFieldEntityHelper.buildFldCalTreeNodes(parameter);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : fldNodes) {
            nodeMap.put(node.getId(), node);
        }
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return billNode;
    }

    public static List<StateSchemeModel> getStateScheme(String bill) {
        String selectFields = StateUtils.getSelects((String[])new String[]{"id", "name", "priority", "statestrategy.bill.number", "statestrategy.condition_tag"});
        QFilter billFilter = new QFilter("statestrategy.bill.number", "=", (Object)bill);
        QFilter openFilter = new QFilter("open", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)Character.valueOf('C'));
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        ArrayList<StateSchemeModel> stateSchemes = new ArrayList<StateSchemeModel>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"StateHelper_getStateScheme", (String)"mpdm_statescheme", (String)selectFields, (QFilter[])new QFilter[]{billFilter, openFilter, statusFilter, enableFilter}, (String)"priority");){
            for (Row row : ds) {
                StateSchemeModel stateSchemeModel = new StateSchemeModel();
                stateSchemeModel.setId(row.getLong("id"));
                stateSchemeModel.setName(row.getString("name"));
                stateSchemeModel.setPriority(row.getInteger("priority"));
                StateStrategyModel stateStrategyModel = new StateStrategyModel();
                stateStrategyModel.setBill(row.getString("statestrategy.bill.number"));
                stateStrategyModel.setCondition(row.getString("statestrategy.condition_tag"));
                stateSchemeModel.setStateStrategyModel(stateStrategyModel);
                stateSchemes.add(stateSchemeModel);
            }
        }
        return stateSchemes;
    }

    public static Set<Long> getConditionForIds(String bill, Set<Long> ids, String conditionStr, String selectField) {
        HashSet<Long> idToStateSchemes = new HashSet<Long>();
        String selectFields = StateUtils.getSelects((String[])new String[]{"id", selectField});
        QFilter idsFilter = new QFilter("id", "in", ids);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"StateHelper_getConditionForIds", (String)bill, (String)selectFields, (QFilter[])new QFilter[]{idsFilter}, null).where(conditionStr);){
            for (Row row : ds) {
                idToStateSchemes.add(row.getLong("id"));
            }
        }
        return idToStateSchemes;
    }

    public static void getRuleIdForstateScheme(List<StateSchemeModel> stateSchemes) {
        Set stateSchemesIds = stateSchemes.stream().map(StateSchemeModel::getId).collect(Collectors.toSet());
        String selectFields = StateUtils.getSelects((String[])new String[]{"id", "entryentity.staterule.id", "entryentity.staterule.billstate.number"});
        QFilter idsFilter = new QFilter("id", "in", stateSchemesIds);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"StateHelper_getStateRulesForstateScheme", (String)"mpdm_statescheme", (String)selectFields, (QFilter[])new QFilter[]{idsFilter}, null);){
            for (Row row : ds) {
                stateSchemes.stream().filter(s -> s.getId().equals(row.getLong("id")) && s.getStateRuleModels().get(row.getLong("entryentity.staterule.id")) == null).forEach(stateSchemeModel -> stateSchemeModel.getStateRuleModels().put(row.getLong("entryentity.staterule.id"), new StateRuleModel()));
            }
        }
    }

    public static void getRuleIdForstateScheme(String state, List<StateSchemeModel> stateSchemes) {
        Set stateSchemesIds = stateSchemes.stream().map(StateSchemeModel::getId).collect(Collectors.toSet());
        String selectFields = StateUtils.getSelects((String[])new String[]{"id", "entryentity.staterule.id", "entryentity.staterule.billstate.number"});
        QFilter idsFilter = new QFilter("id", "in", stateSchemesIds);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"StateHelper_getStateRulesForstateScheme", (String)"mpdm_statescheme", (String)selectFields, (QFilter[])new QFilter[]{idsFilter}, null);){
            for (Row row : ds) {
                String number = row.getString("entryentity.staterule.billstate.number");
                if (number == null || !state.equalsIgnoreCase(number)) continue;
                stateSchemes.stream().filter(s -> s.getId().equals(row.getLong("id")) && s.getStateRuleModels().get(row.getLong("entryentity.staterule.id")) == null).forEach(stateSchemeModel -> stateSchemeModel.getStateRuleModels().put(row.getLong("entryentity.staterule.id"), new StateRuleModel()));
            }
        }
    }

    public static void getStateRules(List<StateSchemeModel> stateSchemes) {
        HashSet ruleIds = new HashSet();
        for (StateSchemeModel stateSchemeModel : stateSchemes) {
            ruleIds.addAll(stateSchemeModel.getStateRuleModels().keySet());
        }
        String selectFields = StateUtils.getSelects((String[])new String[]{"id", "name", "bill", "billfield", "billstate.number", "mmentryentity", "mmentryentity.mmbill.id", "mmentryentity.mmbill.number", "mmentryentity.calculationformula_tag", "mmentryentity.conditionalfilter_tag", "mmentryentity.inspectionscope", "mmentryentity.leftbracket", "mmentryentity.logic", "mmentryentity.matchattribute", "mmentryentity.rightbracket", "billstate.id", "btentryentity.btbill", "btentryentity.bttriggerevent", "btentryentity.bttriggertype", "btentryentity", "btentryentity.id", "btentryentity.btcloud.number", "btentryentity.btapp.number", "btentryentity.btmethod", "bcentryentity", "bcentryentity.bcbill", "bcentryentity.bcmatchattribute", "bcentryentity.bcconditionalfilter_tag", "bcentryentity.bccontroltype", "bcentryentity.bcoperationobject", "bcentryentity.id", "btentryentity.parameter", "mmentryentity.istip", "mmentryentity.customtip", "bcentryentity.bcmethod"});
        QFilter idsFilter = new QFilter("id", "in", ruleIds);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"StateHelper_getStateRules", (String)"mpdm_staterule", (String)selectFields, (QFilter[])new QFilter[]{idsFilter}, null);){
            for (Row row : ds) {
                for (StateSchemeModel stateSchemeModel : stateSchemes) {
                    StateRuleBcModel stateRuleBcModel;
                    StateRuleBtModel stateRuleBtModel;
                    HashSet<StateRuleMmModel> stateRuleMmModels;
                    StateRuleModel stateRuleModel = (StateRuleModel)stateSchemeModel.getStateRuleModels().get(row.getLong("id"));
                    if (stateRuleModel == null) continue;
                    if (stateRuleModel.getId() == null) {
                        stateRuleModel.setId(row.getLong("id"));
                        stateRuleModel.setName(row.getString("name"));
                        stateRuleModel.setBillfield(row.getString("billfield"));
                        stateRuleModel.setBill(row.getString("bill"));
                        stateRuleModel.setBillstateid(row.getLong("billstate.id"));
                        stateRuleModel.setBillstate(row.getString("billstate.number"));
                    }
                    if ((stateRuleMmModels = (HashSet<StateRuleMmModel>)stateRuleModel.getStateRuleMmModel().get(row.getString("mmentryentity"))) == null) {
                        stateRuleMmModels = new HashSet<StateRuleMmModel>(8);
                    }
                    if (row.getLong("mmentryentity") != 0L) {
                        StateRuleMmModel stateRuleMmModel = new StateRuleMmModel();
                        stateRuleMmModel.setMmbill(row.getString("mmentryentity.mmbill.number"));
                        stateRuleMmModel.setCalculationformula(row.getString("mmentryentity.calculationformula_tag"));
                        stateRuleMmModel.setConditionalfilter(row.getString("mmentryentity.conditionalfilter_tag"));
                        stateRuleMmModel.setInspectionscope(row.getString("mmentryentity.inspectionscope"));
                        stateRuleMmModel.setLeftbracket(row.getString("mmentryentity.leftbracket"));
                        stateRuleMmModel.setLogic(row.getString("mmentryentity.logic"));
                        stateRuleMmModel.setMatchattribute(row.getString("mmentryentity.matchattribute"));
                        stateRuleMmModel.setRightbracket(row.getString("mmentryentity.rightbracket"));
                        stateRuleMmModel.setCustomtip(row.getString("mmentryentity.customtip"));
                        stateRuleMmModel.setIstip(row.getBoolean("mmentryentity.istip").booleanValue());
                        stateRuleMmModels.add(stateRuleMmModel);
                        stateRuleModel.getStateRuleMmModel().put(row.getString("mmentryentity.mmbill.id"), stateRuleMmModels);
                    }
                    if ((stateRuleBtModel = (StateRuleBtModel)stateRuleModel.getStateRuleBtModel().get(row.getString("btentryentity"))) == null && row.getLong("btentryentity") != 0L) {
                        stateRuleBtModel = new StateRuleBtModel();
                        stateRuleBtModel.setBtbill(row.getString("btentryentity.btbill"));
                        stateRuleBtModel.setBttriggerevent(row.getString("btentryentity.bttriggerevent"));
                        stateRuleBtModel.setBttriggertype(row.getString("btentryentity.bttriggertype"));
                        stateRuleBtModel.setBtcloud(row.getString("btentryentity.btcloud.number"));
                        stateRuleBtModel.setBtapp(row.getString("btentryentity.btapp.number"));
                        stateRuleBtModel.setBtmethod(row.getString("btentryentity.btmethod"));
                        stateRuleBtModel.setBtparameter(row.getString("btentryentity.parameter"));
                        stateRuleModel.getStateRuleBtModel().put(row.getString("btentryentity.id"), stateRuleBtModel);
                    }
                    if ((stateRuleBcModel = (StateRuleBcModel)stateRuleModel.getStateRuleBcModel().get(row.getString("bcentryentity"))) == null && row.getLong("bcentryentity") != 0L) {
                        stateRuleBcModel = new StateRuleBcModel();
                        stateRuleBcModel.setBcbill(row.getString("bcentryentity.bcbill"));
                        stateRuleBcModel.setBcconditionalfilter(row.getString("bcentryentity.bcconditionalfilter_tag"));
                        stateRuleBcModel.setBccontroltype(row.getString("bcentryentity.bccontroltype"));
                        stateRuleBcModel.setBcmatchattribute(row.getString("bcentryentity.bcmatchattribute"));
                        stateRuleBcModel.setBcoperationobject(row.getString("bcentryentity.bcoperationobject"));
                        stateRuleBcModel.setBcmethod(row.getString("bcentryentity.bcmethod"));
                        stateRuleModel.getStateRuleBcModel().put(row.getString("bcentryentity.id"), stateRuleBcModel);
                    }
                    stateSchemeModel.getStateRuleModels().put(row.getLong("id"), stateRuleModel);
                }
            }
        }
    }

    public static Set<Long> checkBillCondition(String bill, String matchattribute, Set<Long> stateSchemesIds, String calConditionStr, String calSelectField, String conConditionStr, String conSelectField) {
        HashSet<Long> idToStateSchemes = new HashSet<Long>(1);
        HashMap<Long, HashSet<Object>> countMap1 = new HashMap<Long, HashSet<Object>>(8);
        String selectFields = StateUtils.getSelects((String[])new String[]{"id", matchattribute, conSelectField});
        QFilter idsFilter = new QFilter(matchattribute, "in", stateSchemesIds);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"StateHelper_checkBillCondition", (String)bill, (String)selectFields, (QFilter[])new QFilter[]{idsFilter}, null).where(conConditionStr);
        Object object = null;
        try {
            for (Row row : ds) {
                if (!(row.get(matchattribute) instanceof Long)) continue;
                HashSet<Object> countMap1Set = (HashSet<Object>)countMap1.get(row.getLong(matchattribute));
                if (countMap1Set == null) {
                    countMap1Set = new HashSet<Object>(8);
                }
                countMap1Set.add(row.get("id"));
                countMap1.put(row.getLong(matchattribute), countMap1Set);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashMap<Long, HashSet<Object>> countMap2 = new HashMap<Long, HashSet<Object>>(countMap1.size());
        selectFields = StateUtils.getSelects((String[])new String[]{selectFields, calSelectField});
        idsFilter = new QFilter(matchattribute, "in", stateSchemesIds);
        Throwable throwable = null;
        try (DataSet ds2 = QueryServiceHelper.queryDataSet((String)"StateHelper_checkBillCondition2", (String)bill, (String)selectFields, (QFilter[])new QFilter[]{idsFilter}, null).where(calConditionStr).where(conConditionStr);){
            for (Row row : ds2) {
                if (!(row.get(matchattribute) instanceof Long)) continue;
                HashSet<Object> countMap2Set = (HashSet<Object>)countMap2.get(row.getLong(matchattribute));
                if (countMap2Set == null) {
                    countMap2Set = new HashSet<Object>(8);
                }
                countMap2Set.add(row.get("id"));
                countMap2.put(row.getLong(matchattribute), countMap2Set);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (Map.Entry entry : countMap1.entrySet()) {
            if (countMap2.get(entry.getKey()) != null && ((Set)entry.getValue()).size() == ((Set)countMap2.get(entry.getKey())).size()) continue;
            idToStateSchemes.add((Long)entry.getKey());
        }
        return idToStateSchemes;
    }

    public static Map<String, Object> checkBillCondition(String bill, String matchattribute, Set<Long> stateSchemesIds, String calConditionStr, String calSelectField, String conConditionStr, String conSelectField, Set<String> fileds) {
        HashMap<String, Object> noBillConditionMap = new HashMap<String, Object>(2);
        HashSet idToStateSchemes = new HashSet(1);
        HashMap idToBill = new HashMap(8);
        HashMap<Long, HashSet<Object>> countMap1 = new HashMap<Long, HashSet<Object>>(8);
        String selectFields = StateUtils.getSelects((String[])new String[]{"id", matchattribute, conSelectField});
        if (!fileds.isEmpty()) {
            for (String filed : fileds) {
                selectFields = StateUtils.getSelects((String[])new String[]{selectFields, filed});
            }
        }
        QFilter idsFilter = new QFilter(matchattribute, "in", stateSchemesIds);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"StateHelper_checkBillCondition", (String)bill, (String)selectFields, (QFilter[])new QFilter[]{idsFilter}, null).where(conConditionStr);
        Object object = null;
        try {
            for (Row row : ds) {
                if (!(row.get(matchattribute) instanceof Long)) continue;
                HashSet<Object> countMap1Set = (HashSet<Object>)countMap1.get(row.getLong(matchattribute));
                if (countMap1Set == null) {
                    countMap1Set = new HashSet<Object>(8);
                }
                countMap1Set.add(row.get("id"));
                countMap1.put(row.getLong(matchattribute), countMap1Set);
                if (fileds.isEmpty()) continue;
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                for (String filed : fileds) {
                    map.put(filed, row.get(filed));
                }
                idToBill.put(row.getLong("id"), map);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashMap<Long, HashSet<Object>> countMap2 = new HashMap<Long, HashSet<Object>>(countMap1.size());
        selectFields = StateUtils.getSelects((String[])new String[]{selectFields, calSelectField});
        idsFilter = new QFilter(matchattribute, "in", stateSchemesIds);
        Throwable throwable = null;
        try (DataSet ds2 = QueryServiceHelper.queryDataSet((String)"StateHelper_checkBillCondition2", (String)bill, (String)selectFields, (QFilter[])new QFilter[]{idsFilter}, null).where(calConditionStr).where(conConditionStr);){
            for (Row row : ds2) {
                if (!(row.get(matchattribute) instanceof Long)) continue;
                HashSet<Object> countMap2Set = (HashSet<Object>)countMap2.get(row.getLong(matchattribute));
                if (countMap2Set == null) {
                    countMap2Set = new HashSet<Object>(8);
                }
                countMap2Set.add(row.get("id"));
                countMap2.put(row.getLong(matchattribute), countMap2Set);
                idToBill.remove(row.getLong("id"));
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (Map.Entry entry : countMap1.entrySet()) {
            if (countMap2.get(entry.getKey()) != null && ((Set)entry.getValue()).size() == ((Set)countMap2.get(entry.getKey())).size()) continue;
            idToStateSchemes.add(entry.getKey());
        }
        noBillConditionMap.put("idToStateSchemes", idToStateSchemes);
        noBillConditionMap.put("idToBill", idToBill);
        return noBillConditionMap;
    }

    public static DynamicObject[] getState(String pageBill, Set<Long> stateIds, String select) {
        String selectFields = StateUtils.getSelects((String[])new String[]{"id", select, "pjsuptime", "pjsupuser"});
        QFilter idsFilter = new QFilter("id", "in", stateIds);
        return BusinessDataServiceHelper.load((String)pageBill, (String)selectFields, (QFilter[])new QFilter[]{idsFilter});
    }

    public static Map<Long, Long> getProjectState(String bill, String billfield, Set<Long> ids) {
        String selectFields = StateUtils.getSelects((String[])new String[]{"id", billfield});
        QFilter idsFilter = new QFilter("id", "in", ids);
        HashMap<Long, Long> projectstates = new HashMap<Long, Long>(8);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"StateHelper_getProjectSate", (String)bill, (String)selectFields, (QFilter[])new QFilter[]{idsFilter}, null);){
            for (Row row : ds) {
                projectstates.put(row.getLong("id"), row.getLong(billfield));
            }
        }
        return projectstates;
    }
}

