/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.state.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bd.mpdm.business.state.StateService;
import kd.bd.mpdm.business.state.helper.StateHelper;
import kd.bd.mpdm.common.state.enums.InspectionScopeEnum;
import kd.bd.mpdm.common.state.model.StateRuleBcModel;
import kd.bd.mpdm.common.state.model.StateRuleBtModel;
import kd.bd.mpdm.common.state.model.StateRuleMmModel;
import kd.bd.mpdm.common.state.model.StateRuleModel;
import kd.bd.mpdm.common.state.model.StateSchemeModel;
import kd.bd.mpdm.common.state.utils.StateUtils;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.impl.RequestContextRunnable;

public class StateServiceImpl
implements StateService {
    private static final Log logger = LogFactory.getLog(StateServiceImpl.class);

    @Override
    public Map<String, Object> StateChange(String operationKey, String bill, Set<Long> ids) {
        HashMap<String, Object> stateChange = new HashMap<String, Object>(2);
        ArrayList<Map<String, Object>> errorList = new ArrayList<Map<String, Object>>(8);
        List<StateSchemeModel> stateSchemes = this.getConditionStateScheme(bill, ids, stateChange, errorList);
        if (!stateSchemes.isEmpty()) {
            List<Map<String, Object>> checkErrorList = this.checkOperationUpdateRules(operationKey, bill, stateSchemes);
            this.operationAutoBiz(operationKey, stateSchemes);
            errorList.addAll(checkErrorList);
        }
        stateChange.put("errorList", errorList);
        return stateChange;
    }

    private List<StateSchemeModel> getConditionStateScheme(String bill, Set<Long> ids, Map<String, Object> stateChange, List<Map<String, Object>> errorList) {
        List<StateSchemeModel> stateSchemes = StateHelper.getStateScheme(bill);
        Set<Long> allTempIds = ids;
        if (!stateSchemes.isEmpty()) {
            stateChange.put("stateScheme", stateSchemes);
            Iterator<StateSchemeModel> stateSchemeIt = stateSchemes.iterator();
            while (stateSchemeIt.hasNext()) {
                String selectField;
                StateSchemeModel stateSchemeModel = stateSchemeIt.next();
                String condition = stateSchemeModel.getStateStrategyModel().getCondition();
                String conditionStr = StateUtils.getConditionStr((String)bill, (String)condition);
                Set<Long> successteIds = StateHelper.getConditionForIds(bill, allTempIds, conditionStr, selectField = StateUtils.getConditionPro((String)condition));
                if (successteIds.isEmpty()) {
                    stateSchemeIt.remove();
                    continue;
                }
                allTempIds.removeAll(successteIds);
                stateSchemeModel.setSfSchemeIds(successteIds);
            }
            if (!allTempIds.isEmpty()) {
                HashMap<String, Object> errorMap = new HashMap<String, Object>(2);
                errorMap.put("error_msg", ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u7b56\u7565\u7684\u9879\u76ee\u72b6\u6001\u65b9\u6848\u3002", (String)"StateServiceImpl_9", (String)"bd-mpdm-business", (Object[])new Object[0]));
                errorMap.put("error_ids", ids);
                errorList.add(errorMap);
            }
        } else {
            HashMap<String, Object> errorMap = new HashMap<String, Object>(2);
            errorMap.put("error_msg", ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u9879\u76ee\u72b6\u6001\u65b9\u6848\u3002", (String)"StateServiceImpl_10", (String)"bd-mpdm-business", (Object[])new Object[0]));
            errorMap.put("error_ids", ids);
            errorList.add(errorMap);
        }
        return stateSchemes;
    }

    private void invokeBizService(Set<Long> ids, Map.Entry<Long, StateRuleModel> stateRule, Map.Entry<String, StateRuleBtModel> btEntry, Map<String, Object> paramMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("ids:");
        sb.append(ids.toString());
        sb.append(" ,projectStateId:");
        sb.append(stateRule.getValue().getBillstateid());
        sb.append(" ,projectStateNumber:");
        sb.append(stateRule.getValue().getBillstate());
        StateRuleBtModel stateRuleBtModel = btEntry.getValue();
        sb.append(" ,cloud:");
        sb.append(stateRuleBtModel.getBtcloud());
        sb.append(" ,app:");
        sb.append(stateRuleBtModel.getBtapp());
        sb.append(" ,service:");
        sb.append(stateRuleBtModel.getBttriggerevent());
        sb.append(" ,method:");
        sb.append(stateRuleBtModel.getBtmethod());
        sb.append(" ,parameter:");
        sb.append(stateRuleBtModel.getBtparameter());
        String parameters = stateRuleBtModel.getBtparameter();
        if (parameters != null && parameters.length() > 0) {
            Map parameterMap = (Map)SerializationUtils.fromJsonString((String)parameters, Map.class);
            paramMap.putAll(parameterMap);
        }
        try {
            Map map = (Map)DispatchServiceHelper.invokeBizService((String)stateRuleBtModel.getBtcloud().toLowerCase(), (String)stateRuleBtModel.getBtapp(), (String)stateRuleBtModel.getBttriggerevent(), (String)stateRuleBtModel.getBtmethod(), (Object[])new Object[]{paramMap});
            sb.append(String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c:", (String)"StateServiceImpl_4", (String)"bd-mpdm-business", (Object[])new Object[0]), new Object[0]));
            sb.append(",success:");
            sb.append((String)map.get("success"));
            sb.append(",msg:");
            sb.append((String)map.get("msg"));
            sb.append(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u6210\u529f\u3002", (String)"StateServiceImpl_3", (String)"bd-mpdm-business", (Object[])new Object[0]), new Object[0]));
            logger.info(sb.toString());
        }
        catch (Exception e) {
            sb.append(",");
            sb.append(ResManager.loadKDString((String)"\u8c03\u7528\u5fae\u670d\u52a1\u53d1\u751f\u5f02\u5e38\u3002", (String)"StateServiceImpl_7", (String)"bd-mpdm-business", (Object[])new Object[0]));
            logger.warn(sb.toString(), (Throwable)e);
        }
    }

    private void operationAutoBiz(String operationKey, List<StateSchemeModel> stateSchemes) {
        for (StateSchemeModel stateSchemeModel : stateSchemes) {
            Set ids = stateSchemeModel.getSfSchemeIds();
            if (ids == null || ids.isEmpty()) continue;
            for (Map.Entry stateRule : stateSchemeModel.getStateRuleModels().entrySet()) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
                paramMap.put("projectIds", ids);
                paramMap.put("projectStateId", ((StateRuleModel)stateRule.getValue()).getBillstateid());
                paramMap.put("projectStateNumber", ((StateRuleModel)stateRule.getValue()).getBillstate());
                for (Map.Entry btEntry : ((StateRuleModel)stateRule.getValue()).getStateRuleBtModel().entrySet()) {
                    RequestContext rc = RequestContextCreator.createForThreadPool();
                    Object runnable = new RequestContextRunnable(() -> this.invokeBizService(ids, stateRule, btEntry, paramMap), rc);
                    runnable = ThreadLifeCycleManager.wrapRunnable((Runnable)runnable);
                    new Thread((Runnable)runnable).start();
                }
            }
        }
    }

    private List<Map<String, Object>> checkOperationUpdateRules(String operationKey, String bill, List<StateSchemeModel> stateSchemes) {
        StateHelper.getRuleIdForstateScheme(operationKey, stateSchemes);
        StateHelper.getStateRules(stateSchemes);
        return this.checkRules(operationKey, bill, stateSchemes);
    }

    private List<Map<String, Object>> checkRules(String operationKey, String bill, List<StateSchemeModel> stateSchemes) {
        ArrayList<Map<String, Object>> errorList = new ArrayList<Map<String, Object>>(8);
        for (StateSchemeModel stateSchemeModel : stateSchemes) {
            for (Map.Entry stateRule : stateSchemeModel.getStateRuleModels().entrySet()) {
                for (Map.Entry mmEntry : ((StateRuleModel)stateRule.getValue()).getStateRuleMmModel().entrySet()) {
                    Set mmSet = (Set)mmEntry.getValue();
                    for (StateRuleMmModel mm : mmSet) {
                        String conSelectField;
                        HashSet<String> fileds = new HashSet(8);
                        if (mm.isIstip()) {
                            String customTip = mm.getCustomtip();
                            fileds = this.getField(customTip);
                        }
                        if (bill.equals(mm.getMmbill()) && !stateSchemeModel.getSfSchemeIds().isEmpty()) {
                            HashSet formulaSrcFields = new HashSet(8);
                            String conditionStr = StateUtils.getConditionStr((String)bill, (String)mm.getCalculationformula(), formulaSrcFields);
                            StringBuilder selectField = new StringBuilder();
                            Iterator iterator = formulaSrcFields.iterator();
                            while (iterator.hasNext()) {
                                selectField.append((String)iterator.next());
                                selectField.append(',');
                            }
                            Set<Long> successteIds = StateHelper.getConditionForIds(bill, stateSchemeModel.getSfSchemeIds(), conditionStr, selectField.length() == 0 ? null : selectField.substring(0, selectField.length() - 1));
                            HashMap<String, Object> errorMap = new HashMap<String, Object>(2);
                            if (!successteIds.isEmpty()) {
                                stateSchemeModel.getSfSchemeIds().removeAll(successteIds);
                            }
                            if (mm.isIstip()) {
                                errorMap.put("error_msg", mm.getCustomtip());
                            } else {
                                errorMap.put("error_msg", ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u89c4\u5219\u6761\u4ef6\u3002", (String)"StateServiceImpl_8", (String)"bd-mpdm-business", (Object[])new Object[0]));
                            }
                            errorMap.put("error_ids", stateSchemeModel.getSfSchemeIds());
                            stateSchemeModel.setSfSchemeIds(successteIds);
                            errorList.add(errorMap);
                            continue;
                        }
                        if (!InspectionScopeEnum.ALL.getValue().equals(mm.getInspectionscope()) || stateSchemeModel.getSfSchemeIds().isEmpty()) continue;
                        StringBuilder calSelectFieldSB = new StringBuilder();
                        HashSet formulaSrcFields = new HashSet(8);
                        String calConditionStr = StateUtils.getConditionStr((String)mm.getMmbill(), (String)mm.getCalculationformula(), formulaSrcFields);
                        Iterator formulaIterator = formulaSrcFields.iterator();
                        while (formulaIterator.hasNext()) {
                            calSelectFieldSB.append((String)formulaIterator.next());
                            calSelectFieldSB.append(',');
                        }
                        HashSet conSelectFields = new HashSet(8);
                        String conConditionStr = StateUtils.getConditionStr((String)mm.getMmbill(), (String)mm.getConditionalfilter(), conSelectFields);
                        StringBuilder conSelectFieldSB = new StringBuilder();
                        Iterator conSelectIterator = conSelectFields.iterator();
                        while (conSelectIterator.hasNext()) {
                            conSelectFieldSB.append((String)conSelectIterator.next());
                            conSelectFieldSB.append(',');
                        }
                        String calSelectField = calSelectFieldSB.length() == 0 ? null : calSelectFieldSB.substring(0, calSelectFieldSB.length() - 1);
                        String string = conSelectField = conSelectFieldSB.length() == 0 ? null : conSelectFieldSB.substring(0, conSelectFieldSB.length() - 1);
                        if (!mm.isIstip()) {
                            Set<Long> errorIds = StateHelper.checkBillCondition(mm.getMmbill(), mm.getMatchattribute(), stateSchemeModel.getSfSchemeIds(), calConditionStr, calSelectField, conConditionStr, conSelectField);
                            stateSchemeModel.getSfSchemeIds().removeAll(errorIds);
                            if (errorIds.isEmpty()) continue;
                            HashMap<String, Object> errorMap = new HashMap<String, Object>(2);
                            errorMap.put("error_msg", ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u89c4\u5219\u6761\u4ef6\u3002", (String)"StateServiceImpl_8", (String)"bd-mpdm-business", (Object[])new Object[0]));
                            errorMap.put("error_ids", errorIds);
                            errorList.add(errorMap);
                            continue;
                        }
                        Map<String, Object> noBillConditionMap = StateHelper.checkBillCondition(mm.getMmbill(), mm.getMatchattribute(), stateSchemeModel.getSfSchemeIds(), calConditionStr, calSelectField, conConditionStr, conSelectField, fileds);
                        Set errorIds = (Set)noBillConditionMap.get("idToStateSchemes");
                        stateSchemeModel.getSfSchemeIds().removeAll(errorIds);
                        if (errorIds.isEmpty()) continue;
                        HashMap<String, Object> errorMap = new HashMap<String, Object>(2);
                        Map idToBill = (Map)noBillConditionMap.get("idToBill");
                        String error_msg = mm.getCustomtip();
                        if (idToBill != null && !idToBill.isEmpty()) {
                            for (String filed : fileds) {
                                StringBuilder sb = new StringBuilder();
                                for (Map.Entry idToBillEntry : idToBill.entrySet()) {
                                    sb.append('[');
                                    sb.append(((Map)idToBillEntry.getValue()).get(filed));
                                    sb.append(']');
                                }
                                String str = "\\$\\{" + filed + "\\}";
                                error_msg = error_msg.replaceAll(str, sb.toString());
                            }
                        }
                        errorMap.put("error_msg", error_msg);
                        errorMap.put("error_ids", errorIds);
                        errorList.add(errorMap);
                    }
                }
            }
        }
        return errorList;
    }

    private Set<String> getField(String customTip) {
        HashSet<String> fields = new HashSet<String>(8);
        Pattern p = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher m = p.matcher(customTip);
        while (m.find()) {
            fields.add(m.group(1));
        }
        return fields;
    }

    @Override
    public Map<String, Object> getStateControlRules(String bill, Set<Long> ids) {
        HashMap<String, Object> getStateBcEntry = new HashMap<String, Object>(2);
        ArrayList<Map<String, Object>> errorList = new ArrayList<Map<String, Object>>(8);
        List<StateSchemeModel> stateSchemes = this.getConditionStateScheme(bill, ids, getStateBcEntry, errorList);
        if (!stateSchemes.isEmpty()) {
            StateHelper.getRuleIdForstateScheme(stateSchemes);
            StateHelper.getStateRules(stateSchemes);
            HashSet<Long> projectId = new HashSet<Long>(8);
            for (StateSchemeModel stateSchemeModel : stateSchemes) {
                projectId.addAll(stateSchemeModel.getSfSchemeIds());
            }
            Map<Long, Long> projectStates = StateHelper.getProjectState(bill, ((StateRuleModel)stateSchemes.get(0).getStateRuleModels().entrySet().iterator().next().getValue()).getBillfield(), projectId);
            this.getStateBcentity(stateSchemes, projectStates, getStateBcEntry);
        }
        getStateBcEntry.remove("stateScheme");
        getStateBcEntry.put("errorList", errorList);
        return getStateBcEntry;
    }

    private void getStateBcentity(List<StateSchemeModel> stateSchemes, Map<Long, Long> projectStates, Map<String, Object> getStateBcEntry) {
        if (!stateSchemes.isEmpty()) {
            HashMap data = new HashMap(1);
            for (StateSchemeModel stateSchemeModel : stateSchemes) {
                Set ids = stateSchemeModel.getSfSchemeIds();
                if (ids.isEmpty()) continue;
                for (Map.Entry ruleModels : stateSchemeModel.getStateRuleModels().entrySet()) {
                    for (Long id : ids) {
                        Map ruleBcModels;
                        if (!((StateRuleModel)ruleModels.getValue()).getBillstateid().equals(projectStates.get(id)) || (ruleBcModels = ((StateRuleModel)ruleModels.getValue()).getStateRuleBcModel()) == null) continue;
                        ArrayList bcList = new ArrayList(ruleBcModels.size());
                        for (Map.Entry ruleBcModelEntry : ruleBcModels.entrySet()) {
                            HashMap<String, String> ruleBcModel = new HashMap<String, String>(5);
                            ruleBcModel.put("bcbill", ((StateRuleBcModel)ruleBcModelEntry.getValue()).getBcbill());
                            ruleBcModel.put("bcmatchattribute", ((StateRuleBcModel)ruleBcModelEntry.getValue()).getBcmatchattribute());
                            ruleBcModel.put("bcconditionalfilter_tag", ((StateRuleBcModel)ruleBcModelEntry.getValue()).getBcconditionalfilter());
                            ruleBcModel.put("bccontroltype", ((StateRuleBcModel)ruleBcModelEntry.getValue()).getBccontroltype());
                            ruleBcModel.put("bcoperationobject", ((StateRuleBcModel)ruleBcModelEntry.getValue()).getBcoperationobject());
                            ruleBcModel.put("bcmethod", ((StateRuleBcModel)ruleBcModelEntry.getValue()).getBcmethod());
                            bcList.add(ruleBcModel);
                        }
                        data.put(id, bcList);
                    }
                }
            }
            getStateBcEntry.put("data", data);
        }
    }
}

