/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.task;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ManuPersonMBPTask
extends AbstractTask {
    private static final String ALOGKEY = ManuPersonMBPTask.class.getName();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String fileds = "id,hiredate,rank,currentsection,mbpratio";
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>();
        DynamicObject[] data = BusinessDataServiceHelper.load((String)"mpdm_manuperson", (String)fileds, (QFilter[])new QFilter[0]);
        if (null != data && data.length > 0) {
            ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>();
            List<Long>[] list = this.getSearchObj(data, result, objs);
            DataSet dataSet = this.getDataSet(list[0], list[1]);
            this.setMBPratio(dataSet, objs, result);
            this.SaveData(result);
        }
    }

    private void SaveData(Map<Long, DynamicObject> result) {
        ArrayList<DynamicObject> s = new ArrayList<DynamicObject>(500);
        int i = 0;
        for (DynamicObject obj : result.values()) {
            s.add(obj);
            if (++i < 500) continue;
            i = 0;
            SaveServiceHelper.update((DynamicObject[])s.toArray(new DynamicObject[0]));
            s.clear();
        }
        if (s.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])s.toArray(new DynamicObject[0]));
        }
    }

    private void setMBPratio(DataSet dataSet, ArrayList<DynamicObject> objs, Map<Long, DynamicObject> result) {
        for (DynamicObject obj : objs) {
            long id = obj.getLong("id");
            DynamicObject positions = obj.getDynamicObject("rank");
            DynamicObject currentsection = obj.getDynamicObject("currentsection");
            Date hiredate = obj.getDate("hiredate");
            DataSet ds = dataSet.copy();
            BigDecimal mbpratio = this.getMBPratio(positions, currentsection, hiredate, ds);
            obj.set("mbpratio", (Object)mbpratio);
            result.put(id, obj);
        }
    }

    private BigDecimal getMBPratio(DynamicObject positions, DynamicObject currentsection, Date hiredate, DataSet ds) {
        BigDecimal bd = new BigDecimal(0);
        long pid = positions.getLong("id");
        long cid = currentsection.getLong("id");
        if (!ds.isEmpty()) {
            for (Row row : ds) {
                if (row.getLong("position") != pid || row.getLong("department") != cid) continue;
                Boolean fixedvalue = row.getBoolean("fixedvalue");
                if (fixedvalue.booleanValue()) {
                    bd = row.getBigDecimal("mbpratio");
                    break;
                }
                bd = this.getMBPbySchema(row.getLong("mbpschema"), hiredate);
                break;
            }
            if (null == bd) {
                return new BigDecimal(0);
            }
        }
        return bd;
    }

    private BigDecimal getMBPbySchema(long schemaid, Date hiredate) {
        BigDecimal bd = new BigDecimal(0);
        if (null != hiredate) {
            QFilter filter = new QFilter("id", "=", (Object)schemaid);
            String fileds = "timelimitunit,entryentity.timelimit,entryentity.mbpratio";
            DynamicObjectCollection dyobjs = QueryServiceHelper.query((String)"fmm_mbpschema", (String)fileds, (QFilter[])new QFilter[]{filter});
            String timelimitunit = ((DynamicObject)dyobjs.get(0)).getString("timelimitunit");
            double age = this.getAge(hiredate, timelimitunit);
            BigDecimal MBPr = null;
            if (age >= 0.0) {
                MBPr = this.comparaAndget(age, dyobjs);
            }
            if (null != MBPr) {
                return MBPr;
            }
        }
        return bd;
    }

    private BigDecimal comparaAndget(double age, DynamicObjectCollection dyobjs) {
        BigDecimal pre = new BigDecimal(0);
        BigDecimal cp = BigDecimal.valueOf(age);
        BigDecimal result = null;
        BigDecimal temp = null;
        for (DynamicObject obj : dyobjs) {
            BigDecimal timeLimit = obj.getBigDecimal("entryentity.timelimit");
            temp = obj.getBigDecimal("entryentity.mbpratio");
            if (null != timeLimit && (cp.compareTo(pre) > 0 && cp.compareTo(timeLimit) <= 0 || cp.compareTo(new BigDecimal(0)) == 0)) {
                result = temp;
                break;
            }
            if (null == timeLimit) continue;
            pre = timeLimit;
        }
        if (null == result) {
            result = temp;
        }
        return result;
    }

    private double getAge(Date hiredate, String timelimitunit) {
        double age = -1.0;
        if ("Y".equals(timelimitunit)) {
            Calendar instance = Calendar.getInstance();
            int nowYear = instance.get(1);
            instance.setTime(hiredate);
            int beforeYear = instance.get(1);
            age = nowYear - beforeYear;
        } else {
            Calendar instance = Calendar.getInstance();
            int nowYear = instance.get(1);
            int nowMonth = instance.get(2);
            instance.setTime(hiredate);
            int beforeYear = instance.get(1);
            int beforeMonth = instance.get(2);
            age = (nowYear - beforeYear) * 12 + (nowMonth - beforeMonth);
        }
        return age;
    }

    private DataSet getDataSet(List<Long> currentsection, List<Long> positions) {
        DataSet ds = null;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (currentsection.size() > 0) {
            qFilters.add(new QFilter("department.id", "in", (Object)currentsection.toArray()));
        }
        if (positions.size() > 0) {
            qFilters.add(new QFilter("position.id", "in", (Object)positions.toArray()));
        }
        String fileds = "id,department,position,mbpratio,fixedvalue,mbpschema";
        ds = QueryServiceHelper.queryDataSet((String)(ALOGKEY + "_fmm_mbpratio"), (String)"fmm_mbpratio", (String)fileds, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"fixedvalue");
        return ds;
    }

    private List<Long>[] getSearchObj(DynamicObject[] data, Map<Long, DynamicObject> result, List<DynamicObject> objs) {
        List[] ids = new List[]{new ArrayList(), new ArrayList()};
        for (DynamicObject dyobj : data) {
            long id = dyobj.getLong("id");
            DynamicObject positions = dyobj.getDynamicObject("rank");
            DynamicObject currentsection = dyobj.getDynamicObject("currentsection");
            if (null == currentsection || null == positions) {
                dyobj.set("mbpratio", (Object)new BigDecimal(0));
                result.put(id, dyobj);
                continue;
            }
            objs.add(dyobj);
            ids[0].add(currentsection.getLong("id"));
            ids[1].add(positions.getLong("id"));
        }
        return ids;
    }
}

