/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.upgradsynconf.AbstractUpgradSync;
import kd.bos.bec.model.EntityEvent;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class EventServiceOperatorGroupSync
extends AbstractUpgradSync {
    private static final Log log = LogFactory.getLog(EventServiceOperatorGroupSync.class);

    @Override
    protected void excuteSync(EntityEvent evt, DynamicObject confObj) {
        String operation = evt.getOperation();
        List businesskeys = evt.getBusinesskeys();
        Set idSet = businesskeys.stream().map(Long::parseLong).collect(Collectors.toSet());
        HashMap<Long, DynamicObject> idDynMap = new HashMap<Long, DynamicObject>(16);
        String orgInsertField = "id,useorg,number,operatorgrouptype,org,enable,status,creator,createtime,modifier,modifytime,masterid,ctrlstrategy,createorg,name,description,srccreateorg,entryid,operator,operatornumber,opergrpnumber,opergrptype,operatorname,opergrpname,invalid";
        String qualityField = "id,useorg,number,status,creator,modifier,enable,createtime,modifytime,masterid,createorg,org,ctrlstrategy,operatorgrouptype,description,name,srccreateorg,srcid,entryid,operator,operatornumber,operatorname,opergrpnumber,opergrpname,opergrptype,invalid,srcentryid";
        QFilter qFilter = new QFilter("id", "in", idSet);
        qFilter.and("operatorgrouptype", "=", (Object)"ZJZ");
        DynamicObject[] operatorGroups = BusinessDataServiceHelper.load((String)"bd_operatorgroup", (String)orgInsertField, (QFilter[])new QFilter[]{qFilter});
        Arrays.stream(operatorGroups).forEach(f -> idDynMap.put(f.getLong("id"), (DynamicObject)f));
        DynamicObject[] qualityOrgs = BusinessDataServiceHelper.load((String)"qcbd_qualityorg", (String)qualityField, (QFilter[])new QFilter[]{new QFilter("srcid", "in", idSet)});
        switch (operation) {
            case "save": {
                this.saveQualityOrg(idDynMap, qualityOrgs);
                break;
            }
            case "delete": {
                this.deleteData(qualityOrgs);
                break;
            }
            case "enable": {
                if (qualityOrgs.length == 0) break;
                for (DynamicObject qualityOrg : qualityOrgs) {
                    qualityOrg.set("enable", (Object)"1");
                }
                SaveServiceHelper.save((DynamicObject[])qualityOrgs);
                break;
            }
            case "disable": {
                if (qualityOrgs.length == 0) break;
                for (DynamicObject qualityOrg : qualityOrgs) {
                    qualityOrg.set("enable", (Object)"0");
                }
                SaveServiceHelper.save((DynamicObject[])qualityOrgs);
                break;
            }
        }
    }

    private void deleteData(DynamicObject[] qualityOrgs) {
        if (qualityOrgs.length != 0) {
            HashSet<Object> deleteIdSet = new HashSet<Object>(16);
            BasedataEntityType dataEntityType = (BasedataEntityType)qualityOrgs[0].getDataEntityType();
            for (DynamicObject qualityOrg : qualityOrgs) {
                boolean isRefrenced = BaseDataRefrenceHelper.isRefrenced((BasedataEntityType)dataEntityType, (Object)qualityOrg.getPkValue());
                if (isRefrenced) continue;
                deleteIdSet.add(qualityOrg.getPkValue());
            }
            DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])deleteIdSet.toArray());
        }
    }

    private void saveQualityOrg(HashMap<Long, DynamicObject> idDynMap, DynamicObject[] qualityOrgs) {
        if (qualityOrgs.length != 0) {
            DynamicObject[] qualityorgs;
            log.info("\u5c06\u5df2\u5b58\u5728\u6570\u636e\u8fdb\u884c\u540c\u6b65\u66f4\u65b0");
            for (DynamicObject qualityOrg : qualityOrgs) {
                long srcId = qualityOrg.getLong("srcid");
                DynamicObject operatorGroup = idDynMap.get(srcId);
                this.updateField(qualityOrg, operatorGroup);
                qualityOrg.set("status", (Object)"A");
                idDynMap.remove(srcId);
            }
            OperationServiceHelper.executeOperate((String)"save", (String)"qcbd_qualityorg", (DynamicObject[])qualityOrgs, (OperateOption)OperateOption.create());
            Set qualityOrgIdSet = Arrays.stream(qualityOrgs).map(m -> m.getLong("id")).collect(Collectors.toSet());
            for (DynamicObject qualityorg : qualityorgs = BusinessDataServiceHelper.load((String)"qcbd_qualityorg", (String)"id,status", (QFilter[])new QFilter[]{new QFilter("id", "in", qualityOrgIdSet)})) {
                qualityorg.set("status", (Object)"C");
            }
            SaveServiceHelper.save((DynamicObject[])qualityorgs);
        }
        ArrayList<DynamicObject> newQualityOrgList = new ArrayList<DynamicObject>(16);
        for (Map.Entry<Long, DynamicObject> idDynEntry : idDynMap.entrySet()) {
            DynamicObject operatorGroup = idDynEntry.getValue();
            DynamicObject qualityOrg = BusinessDataServiceHelper.newDynamicObject((String)"qcbd_qualityorg");
            this.updateField(qualityOrg, operatorGroup);
            qualityOrg.set("srcid", operatorGroup.getPkValue());
            qualityOrg.set("status", (Object)"A");
            newQualityOrgList.add(qualityOrg);
        }
        if (!newQualityOrgList.isEmpty()) {
            DynamicObject[] qualityorgs;
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"qcbd_qualityorg", (DynamicObject[])newQualityOrgList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                log.info(operationResult.getAllErrorOrValidateInfo().toString());
            }
            log.info("\u540c\u6b65\u65b0\u589e\u6570\u636e\u6761\u6570\uff1a" + operationResult.getSuccessPkIds().size());
            for (DynamicObject qualityorg : qualityorgs = BusinessDataServiceHelper.load((String)"qcbd_qualityorg", (String)"id,status", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)operationResult.getSuccessPkIds())})) {
                qualityorg.set("status", (Object)"C");
            }
            SaveServiceHelper.save((DynamicObject[])qualityorgs);
        }
    }

    private void updateField(DynamicObject qualityOrg, DynamicObject operatorGroup) {
        String billField = "number,useorg,status,creator,modifier,enable,createtime,modifytime,masterid,createorg,org,ctrlstrategy,operatorgrouptype,description,name,srccreateorg";
        String entryField = "operator,operatornumber,operatorname,opergrpnumber,opergrpname,opergrptype,invalid";
        String[] billFields = billField.split(",");
        String[] entryFields = entryField.split(",");
        for (String field : billFields) {
            qualityOrg.set(field, operatorGroup.get(field));
        }
        HashMap idDynEntryMap = new HashMap(16);
        DynamicObjectCollection operatorGroupEntries = operatorGroup.getDynamicObjectCollection("entryentity");
        operatorGroupEntries.stream().forEach(f -> idDynEntryMap.put(f.getLong("id"), f));
        DynamicObjectCollection qualityOrgEntries = qualityOrg.getDynamicObjectCollection("entryentity");
        qualityOrgEntries.removeIf(f -> !idDynEntryMap.containsKey(f.getLong("id")));
        for (DynamicObject qualityOrgEntry : qualityOrgEntries) {
            long entryId = qualityOrgEntry.getLong("srcentryid");
            if (!idDynEntryMap.containsKey(entryId)) continue;
            DynamicObject operatorGroupEntry = (DynamicObject)idDynEntryMap.get(entryId);
            String[] stringArray = entryFields;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String field = stringArray[i];
                qualityOrgEntry.set(field, operatorGroupEntry.get(field));
            }
            idDynEntryMap.remove(entryId);
        }
        for (Map.Entry idDynEntry : idDynEntryMap.entrySet()) {
            DynamicObject operatorGroupEntry = (DynamicObject)idDynEntry.getValue();
            DynamicObject qualityOrgEntry = qualityOrgEntries.addNew();
            qualityOrgEntry.set("srcentryid", (Object)operatorGroupEntry.getLong("id"));
            for (String field : entryFields) {
                qualityOrgEntry.set(field, operatorGroupEntry.get(field));
            }
        }
    }
}

