/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import org.apache.commons.collections4.CollectionUtils;

public class ProcessReportUpgradeServiceHelper {
    public static void upgradeMaterialMasterid(String[] tables) {
        HashMap<String, Set<Long>> tableMaterials = new HashMap<String, Set<Long>>(16);
        HashSet<Long> materialIdSetAll = new HashSet<Long>(16);
        ProcessReportUpgradeServiceHelper.getMaterialIdInfos(tables, tableMaterials, materialIdSetAll);
        Map<Long, Long> materialIdReflex = ProcessReportUpgradeServiceHelper.getMaterialIdReflex(materialIdSetAll);
        Set entries = tableMaterials.entrySet();
        for (Map.Entry entry : entries) {
            String table = (String)entry.getKey();
            String sqlStr = String.format("UPDATE %s SET FMATERIELMASTERID = ? WHERE FMATERIALID = ? AND FMATERIELMASTERID = 0", table);
            LinkedList<Object[]> paramList = new LinkedList<Object[]>();
            Set materialIdset = (Set)entry.getValue();
            for (Long materialId : materialIdset) {
                Long materialMasterid = materialIdReflex.containsKey(materialId) ? materialIdReflex.get(materialId) : Long.valueOf(0L);
                paramList.add(new Object[]{materialMasterid, materialId});
                if (paramList.size() <= 1000) continue;
                ProcessReportUpgradeServiceHelper.batchUpdate(paramList, sqlStr);
            }
            ProcessReportUpgradeServiceHelper.batchUpdate(paramList, sqlStr);
        }
    }

    private static Map<Long, Long> getMaterialIdReflex(Set<Long> materialIdSetAll) {
        HashMap<Long, Long> materialIdReflex = new HashMap<Long, Long>(16);
        ArrayList<Long> materialIdList = new ArrayList<Long>(materialIdSetAll);
        int size = materialIdList.size();
        int currentIndex = 0;
        int count = 0;
        while (currentIndex < size) {
            int endIndex = 1000 * ++count;
            LinkedList materialIdQueryList = new LinkedList();
            while (currentIndex < endIndex && currentIndex < size) {
                materialIdQueryList.add(materialIdList.get(currentIndex++));
            }
            SqlBuilder sb = new SqlBuilder();
            sb.append("SELECT FID, FMASTERID FROM T_BD_MATERIALMFTINFO WHERE ", new Object[0]);
            sb.appendIn("FID", materialIdQueryList);
            DataSet dataSet = DB.queryDataSet((String)"ProcessReportUpgradeServiceImpl-T_BD_MATERIALMFTINFO", (DBRoute)new DBRoute("sys"), (SqlBuilder)sb);
            Throwable throwable = null;
            try {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    materialIdReflex.put(row.getLong("FID"), row.getLong("FMASTERID"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        return materialIdReflex;
    }

    private static void getMaterialIdInfos(String[] tables, Map<String, Set<Long>> tableMaterials, Set<Long> materialIdSetAll) {
        if (ArrayUtils.isNotEmpty((Object[])tables)) {
            for (String table : tables) {
                SqlBuilder sb = new SqlBuilder();
                String sqlStr = String.format("SELECT DISTINCT FMATERIALID FROM %s WHERE FMATERIELMASTERID = 0", table);
                sb.append(sqlStr, new Object[0]);
                try (DataSet dataSet = DB.queryDataSet((String)String.format("ProcessReportUpgradeServiceImpl-%s", table), (DBRoute)new DBRoute("scm"), (SqlBuilder)sb);){
                    HashSet<Long> materialIdSet = new HashSet<Long>(16);
                    while (dataSet.hasNext()) {
                        materialIdSet.add(dataSet.next().getLong("FMATERIALID"));
                    }
                    tableMaterials.put(table, materialIdSet);
                    materialIdSetAll.addAll(materialIdSet);
                }
            }
        }
    }

    private static void batchUpdate(List<Object[]> paramList, String sqlStr) {
        if (CollectionUtils.isNotEmpty(paramList)) {
            DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sqlStr, paramList);
            paramList.clear();
        }
    }
}

