/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.workcardinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;

public class CardBusinessUtils {
    private static final DBRoute scmDBRoute = new DBRoute("scm");

    public static List<Map<String, Object>> getModelOneList(DynamicObject materialtype) {
        if (materialtype == null || materialtype.get("modelmpdone") == null) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> maplist = new ArrayList<Map<String, Object>>(16);
        String modelmpdone = materialtype.getString("modelmpdone");
        StringBuilder bf = new StringBuilder();
        bf.append(" Select distinct fmodelone  from t_mpdm_mrtype where fmodelmpdone = ? and fenable = '1' and fstatus = 'C' ");
        try (DataSet ds = DB.queryDataSet((String)"mmc-CardBusinessUtils-getModelOneList", (DBRoute)scmDBRoute, (String)bf.toString(), (Object[])new String[]{modelmpdone});){
            for (Row row : ds) {
                String fmodelone = row.getString("fmodelone");
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("modelone", fmodelone);
                maplist.add(map1);
            }
        }
        return maplist;
    }

    public static String getCardMaterialMaxVersion(Long orgID, Long workCardID, String modelmpdone, Long cabinconfigID) {
        String selectFields = "version";
        QFilter qFilter = new QFilter("workcard.id", "=", (Object)workCardID);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        if (!StringUtils.isEmpty((String)modelmpdone)) {
            qFilter.and(new QFilter("modelmpdone", "=", (Object)modelmpdone));
        }
        if (cabinconfigID != null && cabinconfigID != 0L) {
            qFilter.and(new QFilter("cabinconfig.id", "=", (Object)cabinconfigID));
        }
        QFilter userOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_cardmatcommand", (Long)orgID);
        String maxVersion = "";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-CardBusinessUtils-getCardMaterialMaxVersion", (String)"mpdm_cardmatcommand", (String)selectFields, (QFilter[])new QFilter[]{qFilter, userOrgFilter}, (String)"");){
            for (Row row : ds) {
                String version = row.getString("version") == null ? "" : row.getString("version");
                if (version.compareTo(maxVersion) <= 0) continue;
                maxVersion = version;
            }
        }
        return maxVersion;
    }

    public static String getVersion(String entityName, String currentVersion) {
        QFilter qFilter = new QFilter("scope", "=", (Object)entityName);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        String selectProperties = "ruleentry,ruleentry.type,ruleentry.versionserial,ruleentry.versionserial.serialentry.serialumber,ruleentry.contchar,ruleentry.separator";
        DynamicObject versionRule = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_versiongeneraterule", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        if (versionRule == null) {
            return "";
        }
        DynamicObjectCollection coll = versionRule.getDynamicObjectCollection("ruleentry");
        if (coll == null || coll.isEmpty()) {
            return "";
        }
        int collSize = coll.size();
        StringBuilder sf = new StringBuilder();
        ArrayList list1 = new ArrayList(16);
        ArrayList list2 = new ArrayList(16);
        ArrayList list3 = new ArrayList(16);
        ArrayList list4 = new ArrayList(16);
        ArrayList list5 = new ArrayList(16);
        ArrayList list6 = new ArrayList(16);
        ArrayList list7 = new ArrayList(16);
        ArrayList list8 = new ArrayList(16);
        ArrayList list9 = new ArrayList(16);
        ArrayList list10 = new ArrayList(16);
        block12: for (int i = 0; i < collSize; ++i) {
            String separator;
            DynamicObject ruleEntry = (DynamicObject)coll.get(i);
            List<String> lists = new ArrayList<String>(16);
            String string = separator = ruleEntry.getString("separator") == null ? "" : ruleEntry.getString("separator");
            if ("A".equals(ruleEntry.getString("type"))) {
                lists.add((ruleEntry.getString("contchar") == null ? "" : ruleEntry.getString("contchar")) + separator);
            } else {
                DynamicObject vserionSerial = ruleEntry.getDynamicObject("versionserial");
                if (vserionSerial != null) {
                    lists = CardBusinessUtils.getSerialNumberList(vserionSerial.getDynamicObjectCollection("serialentry"), separator);
                }
            }
            if (lists.isEmpty()) {
                lists.add("");
            }
            switch (i) {
                case 0: {
                    list1.addAll(lists);
                    continue block12;
                }
                case 1: {
                    list2.addAll(lists);
                    continue block12;
                }
                case 2: {
                    list3.addAll(lists);
                    continue block12;
                }
                case 3: {
                    list4.addAll(lists);
                    continue block12;
                }
                case 4: {
                    list5.addAll(lists);
                    continue block12;
                }
                case 5: {
                    list6.addAll(lists);
                    continue block12;
                }
                case 6: {
                    list7.addAll(lists);
                    continue block12;
                }
                case 7: {
                    list8.addAll(lists);
                    continue block12;
                }
                case 8: {
                    list9.addAll(lists);
                    continue block12;
                }
                case 9: {
                    list10.addAll(lists);
                    continue block12;
                }
            }
        }
        if (list1.isEmpty()) {
            list1.add("");
        }
        if (list2.isEmpty()) {
            list2.add("");
        }
        if (list3.isEmpty()) {
            list3.add("");
        }
        if (list4.isEmpty()) {
            list4.add("");
        }
        if (list5.isEmpty()) {
            list5.add("");
        }
        if (list6.isEmpty()) {
            list6.add("");
        }
        if (list7.isEmpty()) {
            list7.add("");
        }
        if (list8.isEmpty()) {
            list8.add("");
        }
        if (list9.isEmpty()) {
            list9.add("");
        }
        if (list10.isEmpty()) {
            list10.add("");
        }
        for (int i1 = 0; i1 < list1.size(); ++i1) {
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                for (int i3 = 0; i3 < list3.size(); ++i3) {
                    for (int i4 = 0; i4 < list4.size(); ++i4) {
                        for (int i5 = 0; i5 < list5.size(); ++i5) {
                            for (int i6 = 0; i6 < list6.size(); ++i6) {
                                for (int i7 = 0; i7 < list7.size(); ++i7) {
                                    for (int i8 = 0; i8 < list8.size(); ++i8) {
                                        for (int i9 = 0; i9 < list9.size(); ++i9) {
                                            sf.setLength(0);
                                            sf.append((String)list1.get(i1));
                                            sf.append((String)list2.get(i2));
                                            sf.append((String)list3.get(i3));
                                            sf.append((String)list4.get(i4));
                                            sf.append((String)list5.get(i5));
                                            sf.append((String)list6.get(i6));
                                            sf.append((String)list7.get(i7));
                                            sf.append((String)list8.get(i8));
                                            sf.append((String)list9.get(i9));
                                            if (sf.toString().compareTo(currentVersion) <= 0) continue;
                                            return sf.toString();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return "";
    }

    private static List<String> getSerialNumberList(DynamicObjectCollection serialEntryColl, String separator) {
        if (serialEntryColl == null || serialEntryColl.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> serialNumberList = new ArrayList<String>(serialEntryColl.size());
        for (int i = 0; i < serialEntryColl.size(); ++i) {
            serialNumberList.add(((DynamicObject)serialEntryColl.get(i)).getString("serialumber") + separator);
        }
        return serialNumberList;
    }

    public static Map<Long, DynamicObject> getCardMaterialCmdAll(Set<Long> idSet, DynamicObjectType type) {
        DynamicObject[] dyColl;
        QFilter qFilter = new QFilter("id", "in", idSet);
        HashMap<Long, DynamicObject> dyMap = new HashMap<Long, DynamicObject>(idSet.size());
        DynamicObject cmdNullObj = ORM.create().newDynamicObject("mpdm_cardmatcommand");
        for (DynamicObject dy : dyColl = BusinessDataServiceHelper.load((Object[])idSet.toArray(), (DynamicObjectType)cmdNullObj.getDynamicObjectType())) {
            dyMap.put(dy.getLong("id"), dy);
        }
        return dyMap;
    }

    public static String getSelectProperties() {
        StringBuilder sf = new StringBuilder();
        sf.append("id, ");
        sf.append("workcard, ");
        sf.append("productmaterial, ");
        sf.append("modelmpdone, ");
        sf.append("cabinconfig, ");
        sf.append("version, ");
        sf.append("status, ");
        sf.append("enable, ");
        sf.append("needmaterial, ");
        sf.append("nocheck, ");
        sf.append("isnewversion, ");
        sf.append("fromchange, ");
        sf.append("entryentity.id, ");
        sf.append("entryentity.seq, ");
        sf.append("entryentity.entrytype, ");
        sf.append("entryentity.entrymaterial, ");
        sf.append("entryentity.entrymftmaterial, ");
        sf.append("entryentity.enrtyunit, ");
        sf.append("entryentity.entrybaseunit, ");
        sf.append("entryentity.entryqty, ");
        sf.append("entryentity.baseqty, ");
        sf.append("entryentity.isrequireqtyset, ");
        sf.append("entryentity.paramremark, ");
        sf.append("entryentity.entryprofessiona, ");
        sf.append("entryentity.isentryqtylimit, ");
        sf.append("entryentity.entrylimittop, ");
        sf.append("entryentity.entrylimitlow, ");
        sf.append("entryentity.validdate, ");
        sf.append("entryentity.invaliddate, ");
        sf.append("entryentity.materialattr, ");
        sf.append("entryentity.cmdentryid, ");
        sf.append("entryentity.cardoperationno, ");
        sf.append("entryentity.isreplacement, ");
        sf.append("entryentity.materielmtc, ");
        sf.append("entryentity.isbackflush, ");
        sf.append("entryentity.entryiskey, ");
        sf.append("entryentity.entrysn, ");
        sf.append("entryentity.entryresptype, ");
        sf.append("entryentity.entryresp, ");
        sf.append("entryentity.entryownertype, ");
        sf.append("entryentity.entryowner, ");
        sf.append("entryentity.issuemode, ");
        sf.append("entryentity.supplyorg, ");
        sf.append("entryentity.warehouse, ");
        sf.append("entryentity.location, ");
        sf.append("entryentity.isstockalloc, ");
        sf.append("entryentity.outorg, ");
        sf.append("entryentity.outwarehouse, ");
        sf.append("entryentity.outlocation, ");
        sf.append("entryentity.entryremark ");
        return sf.toString();
    }

    public static DynamicObject getCardMaterialCmd(Long pkID) {
        return BusinessDataServiceHelper.loadSingle((Object)pkID, (String)"mpdm_cardmatcommand", (String)CardBusinessUtils.getSelectProperties());
    }

    public static Map<String, List<Map<String, Object>>> getCardMaterialCmdEntryMap(Long pkID) {
        StringBuilder sf = new StringBuilder();
        sf.append("id, ");
        sf.append("entryentity.id entryentityid, ");
        sf.append("entryentity.entrymaterial.id entrymaterialID, ");
        sf.append("entryentity.entryprofessiona.id entryprofessionaid, ");
        sf.append("entryentity.validdate validdate, ");
        sf.append("entryentity.invaliddate invaliddate ");
        QFilter qFilter = new QFilter("id", "=", (Object)pkID);
        HashMap<String, List<Map<String, Object>>> returnMap = new HashMap<String, List<Map<String, Object>>>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-CardBusinessUtils-getCardMaterialCmdEntryMap", (String)"mpdm_cardmatcommand", (String)sf.toString(), (QFilter[])new QFilter[]{qFilter}, (String)"");){
            for (Row row : ds) {
                Long entryID = row.getLong("entryentityid");
                Long entrymaterialID = row.getLong("entrymaterialID");
                Long entryprofessionaid = row.getLong("entryprofessionaid");
                Date validdate = row.getDate("validdate");
                Date invaliddate = row.getDate("invaliddate");
                String midStr = String.valueOf(entrymaterialID) + "_" + String.valueOf(entryprofessionaid);
                HashMap<String, Comparable<Long>> rowMap = new HashMap<String, Comparable<Long>>(16);
                rowMap.put("entryID", entryID);
                rowMap.put("validdate", validdate);
                rowMap.put("invaliddate", invaliddate);
                ArrayList rowList = (ArrayList)returnMap.get(midStr);
                if (rowList == null) {
                    rowList = new ArrayList(16);
                }
                rowList.add(rowMap);
                returnMap.put(midStr, rowList);
            }
        }
        return returnMap;
    }

    public static boolean isDateUnion(Date beginDate1, Date endDate1, Date beginDate2, Date endDate2) {
        return beginDate1.before(endDate2) && endDate1.after(beginDate2);
    }

    public static DynamicObjectCollection getNullColl() {
        return new DynamicObjectCollection();
    }

    public static DynamicObjectCollection trasnsMulBaseDynamicObjectCollection(String entityName, Object sourceData, String propertyName, String proEntityNum) {
        if (sourceData == null) {
            return CardBusinessUtils.getNullColl();
        }
        if (sourceData instanceof MulBasedataDynamicObjectCollection) {
            MulBasedataDynamicObjectCollection sourceColl = (MulBasedataDynamicObjectCollection)sourceData;
            if (sourceColl.isEmpty()) {
                return sourceColl;
            }
            ArrayList<Object> baseDataObjectList = new ArrayList<Object>(sourceColl.size());
            for (int i = 0; i < sourceColl.size(); ++i) {
                DynamicObject dy = (DynamicObject)sourceColl.get(i);
                baseDataObjectList.add(dy.getDynamicObject("fbasedataid"));
            }
            return CardBusinessUtils.getEntryMulBaseDataDyColl(entityName, baseDataObjectList, propertyName, proEntityNum);
        }
        return CardBusinessUtils.getNullColl();
    }

    public static DynamicObjectCollection getEntryMulBaseDataDyColl(String entityName, List<Object> fieldValueIds, String fieldName, String mulBasedataEntity) {
        DynamicObject paySchDy = ORM.create().newDynamicObject(entityName);
        DynamicObjectCollection dyColl = paySchDy.getDynamicObjectCollection(fieldName);
        DynamicObjectType dynamicObjectType = dyColl.getDynamicObjectType();
        for (int i = 0; i < fieldValueIds.size(); ++i) {
            DynamicObject mulBasedataDy = new DynamicObject(dynamicObjectType);
            DynamicObject payBizActDy = BusinessDataServiceHelper.newDynamicObject((String)mulBasedataEntity);
            DynamicObject data = (DynamicObject)fieldValueIds.get(i);
            if (data == null) continue;
            payBizActDy.set("id", data.getPkValue());
            mulBasedataDy.set("fbasedataid", (Object)payBizActDy);
            dyColl.add((Object)mulBasedataDy);
        }
        return dyColl;
    }
}

