/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.workcardinfo;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.workcardinfo.CardBusinessUtils;
import kd.bd.mpdm.common.wordcard.consts.CardMaterialCommandChangeConsts;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CardMaterialCmdChangeBusiness {
    private static final String[] FIELD_HEAD_UPDATE_ARRAT = new String[]{"needmaterial", "nocheck"};
    private static final String[] FIELD_ENTRY_UPDATE_ARRAT = new String[]{"entrytype", "entrymaterial", "entrymftmaterial", "enrtyunit", "entrybaseunit", "entryqty", "baseqty", "isrequireqtyset", "paramremark", "entryprofessiona", "isentryqtylimit", "entrylimittop", "entrylimitlow", "validdate", "invaliddate", "materialattr", "cardoperationno", "isreplacement", "materielmtc", "isbackflush", "entryiskey", "entrysn", "entryresptype", "entryresp", "entryownertype", "entryowner", "issuemode", "supplyorg", "warehouse", "location", "isstockalloc", "outorg", "outwarehouse", "outlocation", "entryremark"};

    public void updateCardMaterialCmd(DynamicObject[] changeArray) {
        if (changeArray == null || changeArray.length < 1) {
            return;
        }
        HashSet<Long> cmdIDSet = new HashSet<Long>(changeArray.length);
        DynamicObjectType cmdType = null;
        for (DynamicObject changeBill : changeArray) {
            DynamicObject cmdBill = changeBill.getDynamicObject("cardmaterial");
            if (cmdBill == null) continue;
            cmdType = cmdBill.getDynamicObjectType();
            cmdIDSet.add(cmdBill.getLong("id"));
        }
        if (cmdIDSet.isEmpty()) {
            return;
        }
        Map<Long, DynamicObject> cmdMap = CardBusinessUtils.getCardMaterialCmdAll(cmdIDSet, cmdType);
        for (DynamicObject changeBill : changeArray) {
            String errorString;
            DynamicObject cmdBill = changeBill.getDynamicObject("cardmaterial");
            if (cmdBill == null) continue;
            if (!"C".equals((cmdBill = cmdMap.get(cmdBill.getLong("id"))).getString("status"))) {
                errorString = ResManager.loadKDString((String)"\u5de5\u5361\u7269\u6599\u9700\u6c42\u4e0d\u5904\u4e8e\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d8\u66f4!", (String)"CardMaterialCmdChangeBusiness_0", (String)"bd-mpdm-business", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("mmc-CardMaterialCmdChangeBusiness-updateCardMaterialCmd", errorString), new Object[0]);
            }
            if (!"1".equals(cmdBill.getString("enable"))) {
                errorString = ResManager.loadKDString((String)"\u5de5\u5361\u7269\u6599\u9700\u6c42\u4e0d\u5904\u4e8e\u53ef\u7528\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d8\u66f4!", (String)"CardMaterialCmdChangeBusiness_1", (String)"bd-mpdm-business", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("mmc-CardMaterialCmdChangeBusiness-updateCardMaterialCmd", errorString), new Object[0]);
            }
            if (this.isUpdateVersion(changeBill)) {
                this.updateCardMaterialCmdHead(changeBill, cmdBill);
                if (this.isNeedMaterial(changeBill)) {
                    this.updateCardMaterialCmdEntry(changeBill, cmdBill);
                } else {
                    this.disableCardMaterialCmdEntry(changeBill, cmdBill, Collections.emptySet());
                }
                this.saveCardMaterialCmd(cmdBill);
            }
            if (!this.isAddNewVersion(changeBill)) continue;
            if (this.isNeedMaterial(changeBill)) {
                this.updateCardMaterialCmdEntry(changeBill, cmdBill);
            } else {
                this.disableCardMaterialCmdEntry(changeBill, cmdBill, Collections.emptySet());
            }
            DynamicObject newCardMaterialCmd = (DynamicObject)OrmUtils.clone((IDataEntityBase)cmdBill, (boolean)false, (boolean)true);
            this.updateNewHeadData(cmdBill, newCardMaterialCmd);
            this.updateCardMaterialCmdHead(changeBill, newCardMaterialCmd);
            newCardMaterialCmd.set("fromchange", (Object)Boolean.TRUE);
            newCardMaterialCmd.set("isnewversion", (Object)Boolean.TRUE);
            newCardMaterialCmd.set("version", changeBill.get("newversion"));
            this.saveCardMaterialCmd(newCardMaterialCmd);
            this.updateOldVersionFlag(cmdBill);
        }
    }

    private void updateNewEntryData(DynamicObject oldEntryDy, DynamicObject newEntryDy) {
        IDataEntityType dt = oldEntryDy.getDataEntityType();
        DataEntityPropertyCollection properties = dt.getProperties();
        for (IDataEntityProperty prop : properties) {
            String name = prop.getName();
            if (!StringUtils.isNotEmpty((CharSequence)name) || !newEntryDy.containsProperty(name)) continue;
            newEntryDy.set(name, oldEntryDy.get(name));
        }
    }

    private void updateNewHeadData(DynamicObject oldCmdBill, DynamicObject newCmdBill) {
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user", (String)"id");
        Date thisDate = new Date();
        newCmdBill.set("auditor", (Object)userObj);
        newCmdBill.set("audittime", (Object)thisDate);
        newCmdBill.set("creator", (Object)userObj);
        newCmdBill.set("createtime", (Object)thisDate);
        newCmdBill.set("modifier", (Object)userObj);
        newCmdBill.set("modifytime", (Object)thisDate);
    }

    private void updateOldVersionFlag(DynamicObject cmdBill) {
        String updateSql = "update t_mpdm_cmaterialcmd set fisnewversion = ? where fid = ? ";
        DB.execute((DBRoute)CardMaterialCommandChangeConsts.scmDBRoute, (String)updateSql, (Object[])new Object[]{"0", cmdBill.getLong("id")});
    }

    private void saveCardMaterialCmd(DynamicObject cmdBill) {
        Object[] cmdBillCpll = new DynamicObject[]{cmdBill};
        SaveServiceHelper.save((IDataEntityType)cmdBill.getDataEntityType(), (Object[])cmdBillCpll);
    }

    private void updateCardMaterialCmdEntry(DynamicObject changeBill, DynamicObject cmdBill) {
        DynamicObjectCollection changeColl = changeBill.getDynamicObjectCollection("entryentity");
        if (changeColl == null || changeColl.isEmpty()) {
            return;
        }
        DynamicObjectCollection cmdColl = cmdBill.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < changeColl.size(); ++i) {
            DynamicObject changeEntryDy = (DynamicObject)changeColl.get(i);
            Long cmdEntryID = changeEntryDy.getLong("cmdentryid");
            if (this.isAddMaterial(changeEntryDy)) {
                DynamicObject newEntry = cmdColl.addNew();
                this.newCmardMaterialCmdEntry(changeEntryDy, newEntry);
            }
            if (!this.isAfterEditMaterial(changeEntryDy) && !this.isDisableMaterial(changeEntryDy)) continue;
            DynamicObject cmdEntry = this.getCmdEntry(cmdColl, cmdEntryID);
            if (cmdEntry == null) {
                DynamicObject workCard = cmdBill.getDynamicObject("workcard");
                String workCardNumber = workCard.getString("number");
                String errorString = String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u5bf9\u5e94\u7684\u5de5\u5361\u7269\u6599\u9700\u6c42\u5206\u5f55\u4e2d\u65e0\u6cd5\u627e\u5230\u5206\u5f55ID\u4e3a\u7684%2$s\u7684\u5206\u5f55\u6570\u636e\uff0c\u53ef\u80fd\u6570\u636e\u5b58\u5728\u5f02\u5e38!", (String)"CardMaterialCmdChangeBusiness_2", (String)"bd-mpdm-business", (Object[])new Object[0]), workCardNumber, String.valueOf(cmdEntryID));
                throw new KDBizException(new ErrorCode("mmc-CardMaterialCmdChangeBusiness-updateCardMaterialCmdEntry", errorString), new Object[0]);
            }
            if (this.isAfterEditMaterial(changeEntryDy)) {
                this.editCmardMaterialCmdEntry(changeEntryDy, cmdEntry);
                continue;
            }
            HashSet<Long> disableIDSet = new HashSet<Long>(1);
            disableIDSet.add(cmdEntryID);
            this.disableCardMaterialCmdEntry(changeBill, cmdBill, disableIDSet);
        }
    }

    private DynamicObject getCmdEntry(DynamicObjectCollection cmdColl, Long entryID) {
        for (int i = 0; i < cmdColl.size(); ++i) {
            Long rowID = ((DynamicObject)cmdColl.get(i)).getLong("id");
            if (!rowID.equals(entryID)) continue;
            return (DynamicObject)cmdColl.get(i);
        }
        return null;
    }

    private DynamicObject newCmardMaterialCmdEntry(DynamicObject changeEntryDy, DynamicObject newEntry) {
        this.editCmardMaterialCmdEntry(changeEntryDy, newEntry);
        return newEntry;
    }

    private DynamicObject editCmardMaterialCmdEntry(DynamicObject changeEntryDy, DynamicObject cmdEntry) {
        if (FIELD_ENTRY_UPDATE_ARRAT.length < 1) {
            return cmdEntry;
        }
        for (String filedNumber : FIELD_ENTRY_UPDATE_ARRAT) {
            if (!changeEntryDy.containsProperty(filedNumber) || !cmdEntry.containsProperty(filedNumber)) continue;
            if ("materielmtc".equalsIgnoreCase(filedNumber)) {
                if (changeEntryDy.get(filedNumber) == null || "[]".equals(changeEntryDy.get(filedNumber).toString())) continue;
                DynamicObjectCollection colls = CardBusinessUtils.trasnsMulBaseDynamicObjectCollection("mpdm_cardmatcommand.entryentity", changeEntryDy.get(filedNumber), filedNumber, "mpdm_materialmtcinfo");
                cmdEntry.set(filedNumber, (Object)colls);
                continue;
            }
            cmdEntry.set(filedNumber, changeEntryDy.get(filedNumber));
        }
        return cmdEntry;
    }

    private void disableCardMaterialCmdEntry(DynamicObject changeBill, DynamicObject cmdBill, Set<Long> disableIDSet) {
        DynamicObjectCollection coll = cmdBill.getDynamicObjectCollection("entryentity");
        if (coll == null || coll.isEmpty()) {
            return;
        }
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject entryDy = (DynamicObject)coll.get(i);
            if (!disableIDSet.isEmpty() && !disableIDSet.contains(entryDy.getLong("id"))) continue;
            Date invalidDate = changeBill.getDate("billdate");
            Date validDate = entryDy.getDate("validdate");
            entryDy.set("invaliddate", (Object)invalidDate);
            if (!validDate.after(invalidDate)) continue;
            entryDy.set("validdate", (Object)invalidDate);
        }
    }

    private void updateCardMaterialCmdHead(DynamicObject changeBill, DynamicObject cmdBill) {
        if (FIELD_HEAD_UPDATE_ARRAT.length < 1) {
            return;
        }
        for (String filedNumber : FIELD_HEAD_UPDATE_ARRAT) {
            if (!cmdBill.containsProperty(filedNumber) || !changeBill.containsProperty(filedNumber)) continue;
            cmdBill.set(filedNumber, changeBill.get(filedNumber));
        }
    }

    private boolean isAddMaterial(DynamicObject changeBillEntry) {
        return "A".equals(changeBillEntry.getString("rowtype"));
    }

    private boolean isAfterEditMaterial(DynamicObject changeBillEntry) {
        return "C".equals(changeBillEntry.getString("rowtype"));
    }

    private boolean isDisableMaterial(DynamicObject changeBillEntry) {
        return "D".equals(changeBillEntry.getString("rowtype"));
    }

    private boolean isNeedMaterial(DynamicObject changeBill) {
        return changeBill.getBoolean("needmaterial");
    }

    private boolean isAddNewVersion(DynamicObject changeBill) {
        return "B".equals(changeBill.getString("changetype"));
    }

    private boolean isUpdateVersion(DynamicObject changeBill) {
        return "A".equals(changeBill.getString("changetype"));
    }
}

