/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.workcardinfo;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class MroCardPhotoUtils {
    private static final Log logger = LogFactory.getLog(MroCardPhotoUtils.class);

    public static String getPhotoVersion(Object cardid, String entityNum) {
        Date starttime = MroCardPhotoUtils.getCurrentDate();
        Date endtime = MroCardPhotoUtils.getDayEndTime(starttime);
        Calendar cal = Calendar.getInstance();
        QFilter filter = new QFilter("cardid", "=", cardid);
        filter.and(new QFilter("moddate", ">=", (Object)starttime));
        filter.and(new QFilter("moddate", "<", (Object)endtime));
        String maxVersion = MroCardPhotoUtils.getMaxCardVersion(filter, entityNum);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String format = df.format(cal.getTime());
        int startindex = 0;
        DecimalFormat g1 = new DecimalFormat("00000");
        if (StringUtils.isNotBlank((CharSequence)maxVersion) && maxVersion.indexOf(format) >= 0) {
            String updateid2 = maxVersion.substring(8, maxVersion.length());
            startindex = Integer.parseInt(updateid2);
        }
        String startZeroStr = format + g1.format((long)startindex + 1L);
        return startZeroStr;
    }

    public static Date getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        Date time = calendar.getTime();
        return time;
    }

    public static Date getDayEndTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static String getMaxCardVersion(QFilter filter, String entityNum) {
        String maxV = "";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryMaxCardVersion", (String)entityNum, (String)"max(photoversion) as photoversion", (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                maxV = row.getString("photoversion");
            }
        }
        return maxV;
    }
}

