/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.applicablerule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserService;

public class ApplicableruleEditPlugin
extends AbstractBasePlugIn
implements CellClickListener {
    private static final String RULECONDITION = "rulecondition";
    private static final String ENTRYENTITY = "entryentity";
    private static final String FILTERRULE = "filterrule";
    private static final String FILTERRULEVALUE = "filterrulevalue_tag";
    private static final String OBJECTENTITY = "objectentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        if (entryGrid != null) {
            entryGrid.addCellClickListener((CellClickListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey)) {
            String rulecondition = (String)this.getModel().getValue(RULECONDITION);
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
            if ("C".equals(rulecondition) && entryentity.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9002\u7528\u89c4\u5219\u5206\u5f55\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ApplicableruleEditPlugin_5", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String rulecondition = (String)this.getModel().getValue(RULECONDITION);
        if (!"C".equals(rulecondition)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"newentry", "insertentry", "deleteentry"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length > 0 && RULECONDITION.equals(proName)) {
            String rulecondition = (String)changeSet[0].getNewValue();
            Boolean flag = Boolean.FALSE;
            if ("C".equals(rulecondition)) {
                flag = Boolean.TRUE;
            } else {
                this.getModel().deleteEntryData(ENTRYENTITY);
            }
            this.getView().setEnable(flag, new String[]{"newentry", "insertentry", "deleteentry"});
        }
    }

    public void cellClick(CellClickEvent e) {
        String fieldKey = e.getFieldKey();
        int row = e.getRow();
        if (FILTERRULE.equals(fieldKey)) {
            DynamicObject bill = (DynamicObject)this.getModel().getValue(OBJECTENTITY, row);
            if (bill == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5bf9\u8c61\u5b9e\u4f53\u3002", (String)"ApplicableruleEditPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.openConditionSet(row);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map data;
        super.closedCallBack(event);
        if ("conditiondatacallback".equals(event.getActionId()) && (data = (Map)event.getReturnData()) != null) {
            String filter = (String)data.get("filter");
            String number = (String)data.get("number");
            int row = (Integer)data.get("row");
            String filterDesc = this.translateJsonString(filter, number);
            this.getModel().setValue(FILTERRULE, (Object)filterDesc, row);
            this.getModel().setValue(FILTERRULEVALUE, (Object)filter, row);
        }
    }

    protected String translateJsonString(String filters, String number) {
        if (StringUtils.isBlank((CharSequence)filters) || StringUtils.isBlank((CharSequence)number)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filters, FilterCondition.class);
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)number);
        String filterStr = this.convertFilterCondition(filterCondition, mainType);
        FilterBuilder fb = new FilterBuilder(mainType, filterCondition, false);
        UserService userService = new UserService();
        fb.setUserService((IUserService)userService);
        fb.buildFilter(false);
        return filterStr;
    }

    protected String convertFilterCondition(FilterCondition filterCondition, MainEntityType mainType) {
        List simpleFilterRows = filterCondition.getFilterRow();
        Iterator simpleFilterRowIterator = simpleFilterRows.iterator();
        StringBuilder filterStr = new StringBuilder();
        ArrayList<SimpleFilterRow> filterRow = new ArrayList<SimpleFilterRow>(16);
        FilterCondition fc = new FilterCondition();
        int row = 1;
        int size = simpleFilterRows.size();
        while (simpleFilterRowIterator.hasNext()) {
            SimpleFilterRow simpleFilterRow = (SimpleFilterRow)simpleFilterRowIterator.next();
            String leftBracket = simpleFilterRow.getLeftBracket();
            String rightBracket = simpleFilterRow.getRightBracket();
            simpleFilterRow.setLeftBracket("");
            simpleFilterRow.setRightBracket("");
            String logicDesc = "";
            String logic = simpleFilterRow.getLogic();
            logicDesc = "1".equals(logic) ? ResManager.loadKDString((String)" \u6216\u8005", (String)"ApplicableruleEditPlugin_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)" \u5e76\u4e14", (String)"ApplicableruleEditPlugin_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]);
            String fieldName = simpleFilterRow.getFieldName();
            List filterValues = simpleFilterRow.getValue();
            UserService userService = new UserService();
            if (fieldName.endsWith("_mmc_formula") && filterValues != null && !filterValues.isEmpty()) {
                String value = ((FilterValue)filterValues.get(0)).getValue() == null ? "" : (String)((FilterValue)filterValues.get(0)).getValue();
                fieldName = fieldName.replaceAll("_mmc_formula", "");
                if (value.contains("@this")) {
                    value = value.replaceAll("\"@this\"", fieldName);
                }
                value = value.replaceAll("\\s+", " ");
                value = fieldName.concat(" ").concat(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f", (String)"ApplicableruleEditPlugin_4", (String)"bd-mpdm-formplugin", (Object[])new Object[0])).concat(" ").concat(value);
                filterStr.append(leftBracket);
                if (value.length() > 0) {
                    String[] strlen;
                    for (String str : strlen = value.split(" ")) {
                        DynamicProperty dynamicProperty = mainType.getProperty(str);
                        if (dynamicProperty != null && dynamicProperty.getDisplayName() != null) {
                            String displayName = dynamicProperty.getDisplayName().toString();
                            filterStr.append(displayName).append(' ');
                            continue;
                        }
                        filterStr.append(str).append(' ');
                    }
                }
                if (size == row) {
                    filterStr.append(rightBracket).append(' ');
                } else {
                    filterStr.append(rightBracket).append(logicDesc).append(' ');
                }
                simpleFilterRow.setCompareType("37");
                simpleFilterRow.setFieldName(fieldName);
                simpleFilterRow.setValue(new ArrayList(0));
            } else {
                filterRow.add(simpleFilterRow);
                fc.setFilterRow(filterRow);
                FilterBuilder fb = new FilterBuilder(mainType, fc, false);
                fb.setUserService((IUserService)userService);
                fb.buildFilter(false);
                filterRow.clear();
                if (size == row) {
                    filterStr.append(leftBracket).append(fb.getFilterString().trim()).append(rightBracket).append(' ');
                } else {
                    filterStr.append(leftBracket).append(fb.getFilterString().trim()).append(rightBracket).append(logicDesc).append(' ');
                }
            }
            simpleFilterRow.setLeftBracket(leftBracket);
            simpleFilterRow.setRightBracket(rightBracket);
            ++row;
        }
        return filterStr.toString();
    }

    private void openConditionSet(int row) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("mpdm_datacondition");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "conditiondatacallback"));
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String status = (String)this.getModel().getValue("status");
        DynamicObject objectentity = (DynamicObject)this.getModel().getValue(OBJECTENTITY, row);
        Object filterds = this.getModel().getValue(FILTERRULEVALUE, row);
        params.put("filter", filterds);
        params.put("number", objectentity.get("number"));
        params.put("row", row);
        params.put("status", status);
        fsp.setCustomParams(params);
        this.getView().showForm(fsp);
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }
}

