/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.basedata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bd.mpdm.common.constants.FeaturedefinitionConst;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class FeatureDefinitionEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BD_AUXPROPERTY = "bd_auxproperty";
    private static final String BD_ASSISTANTDATA_DETAIL = "bos_assistantdata_detail";
    private static final String ENTRY_AUXPROP = "entryauxproperty";
    private static final String ENTRY_QYTY_NUMBERATOR = "entryqtynumerator";
    private static final String ENTRY_QYTY_DENOMINATOR = "entryqtydenominator";
    private static final String ENTRY_ENTRYFIXSCRAP = "entryfixscrap";
    private static final String ENTRY_ENTRYSCRAPRATE = "entryscraprate";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit text = (TextEdit)this.getControl("fieldname");
        text.addClickListener((ClickListener)this);
        TextEdit filedNameShow = (TextEdit)this.getControl("fieldnameshow");
        filedNameShow.addClickListener((ClickListener)this);
        BasedataEdit featurerule = (BasedataEdit)this.getControl("featurerule");
        if (featurerule != null) {
            featurerule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String sourceFldKey = source.getKey();
        if ("fieldname".equals(sourceFldKey) || "fieldnameshow".equals(sourceFldKey)) {
            DynamicObject dynamicObject = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObject("bos_entityobject");
            if (dynamicObject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"FeatureDefinitionEditPlugin_6", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            } else {
                String name = dynamicObject.getString("number");
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)name);
                BillTreeBuildParameter parameter = new BillTreeBuildParameter(dataEntityType);
                parameter.setIncludePKField(Boolean.TRUE.booleanValue());
                TreeNode srcBillNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
                this.filterSrcBillNode(srcBillNode);
                this.showSelectFieldForm(srcBillNode);
            }
        }
    }

    private void filterSrcBillNode(TreeNode srcBillNode) {
        if (srcBillNode == null) {
            return;
        }
        srcBillNode.setDisabled(true);
        List children = srcBillNode.getChildren();
        Iterator iterator = children.iterator();
        List treeEntrys = new ArrayList(2);
        while (iterator.hasNext()) {
            TreeNode treeNode = (TreeNode)iterator.next();
            String nodeId = treeNode.getId();
            if ("treeentryentity".equals(nodeId)) {
                treeEntrys = treeNode.getChildren();
                treeNode.setDisabled(true);
                continue;
            }
            iterator.remove();
        }
        Iterator treeIterator = treeEntrys.iterator();
        while (treeIterator.hasNext()) {
            TreeNode next = (TreeNode)treeIterator.next();
            String nextId = next.getId();
            if (ENTRY_QYTY_NUMBERATOR.equals(nextId) || ENTRY_QYTY_DENOMINATOR.equals(nextId) || ENTRY_AUXPROP.equals(nextId) || ENTRY_ENTRYFIXSCRAP.equals(nextId) || ENTRY_ENTRYSCRAPRATE.equals(nextId)) {
                if (!ENTRY_AUXPROP.equals(nextId)) continue;
                next.setChildren(null);
                continue;
            }
            treeIterator.remove();
        }
    }

    private void showSelectFieldForm(TreeNode srcBillNode) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pdm_featuredefinition"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        String actionId = evt.getActionId();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"pdm_featuredefinition")) {
            if (returnData == null) {
                return;
            }
            this.getModel().setValue("fieldname", returnData);
            this.setFiledNameShow(returnData.toString());
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"itemselector")) {
            this.itemSelectorCallBack(view, model, returnData, true);
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"addentrycallback")) {
            this.itemSelectorCallBack(view, model, returnData, false);
        }
    }

    public void setFiledNameShow(String filedName) {
        if (ENTRY_AUXPROP.equals(filedName)) {
            this.getModel().setValue("fieldnameshow", (Object)FeaturedefinitionConst.AUXPROP_NAME);
        } else if (ENTRY_QYTY_NUMBERATOR.equals(filedName)) {
            this.getModel().setValue("fieldnameshow", (Object)FeaturedefinitionConst.QTYNUMERATOR_NAME);
        } else if (ENTRY_QYTY_DENOMINATOR.equals(filedName)) {
            this.getModel().setValue("fieldnameshow", (Object)FeaturedefinitionConst.QTYDENOMINATOR_NAME);
        } else if (ENTRY_ENTRYFIXSCRAP.equals(filedName)) {
            this.getModel().setValue("fieldnameshow", (Object)FeaturedefinitionConst.ENTRYFIXSCRAP_NAME);
        } else if (ENTRY_ENTRYSCRAPRATE.equals(filedName)) {
            this.getModel().setValue("fieldnameshow", (Object)FeaturedefinitionConst.ENTRYSCRAPRATE_NAME);
        }
        this.getView().updateView("fieldnameshow");
    }

    private void itemSelectorCallBack(IFormView view, IDataModel model, Object returnData, boolean isClear) {
        Object datas;
        Map returnDataMap = null;
        List<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(8);
        if (returnData instanceof Map && (datas = (returnDataMap = (Map)returnData).get("datas")) instanceof List) {
            dataList = (List)datas;
        }
        if (isClear) {
            DynamicObjectCollection entryEntity = model.getEntryEntity("treeentryentity");
            entryEntity.clear();
        }
        this.writeAuxListToEntry(model, dataList);
        view.updateView("treeentryentity");
    }

    private void writeAuxListToEntry(IDataModel model, List<Map<String, Object>> dataList) {
        if (dataList == null || dataList.isEmpty() || model == null) {
            return;
        }
        model.beginInit();
        DynamicObjectCollection entryEntity = model.getEntryEntity("treeentryentity");
        int start = 0;
        if (entryEntity != null) {
            start = entryEntity.size();
        }
        for (int i = 0; i < dataList.size(); ++i) {
            model.createNewEntryRow("treeentryentity");
            Map<String, Object> dataMap = dataList.get(i);
            Object entryValue = dataMap.get("entryvalue");
            Object entryValueName = dataMap.get("entryvaluename");
            Object entryid = dataMap.get("entryid");
            model.setValue("entryvalue", entryValue, start + i);
            model.setValue("entryvaluename", entryValueName, start + i);
            model.setValue("featurevalueid", entryid, start + i);
            this.getView().setEnable(Boolean.valueOf(false), start + i, new String[]{"entryvalue"});
            this.getView().setEnable(Boolean.valueOf(false), start + i, new String[]{"entryvaluename"});
        }
        model.endInit();
        model.updateCache();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object featureType = model.getValue("featuretype");
        if (StringUtils.equals((CharSequence)"newentry", (CharSequence)operateKey) && featureType instanceof String && StringUtils.equals((CharSequence)"C", (CharSequence)String.valueOf(featureType))) {
            Object auxpropetryObj = model.getValue(BD_AUXPROPERTY);
            DynamicObjectCollection auxpropetryDOC = null;
            if (auxpropetryObj != null) {
                auxpropetryDOC = this.queryFeatureData((DynamicObject)auxpropetryObj);
            }
            List<Map<String, Object>> paramData = this.resolveAuxpropertyDOC(auxpropetryDOC);
            this.showFeatureValueSelectForm(paramData, -1, true, false, "addentrycallback");
            args.setCancel(true);
            return;
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        super.propertyChanged(e);
        ChangeData[] changeData = e.getChangeSet();
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"entryvalue", (CharSequence)fieldKey)) {
            this.validateData(changeData);
        } else if (StringUtils.equals((CharSequence)"length", (CharSequence)fieldKey)) {
            ChangeData data = changeData[0];
            Object obj = data.getNewValue();
            BigDecimal strLenth = BigDecimal.ZERO;
            if (obj != null) {
                strLenth = new BigDecimal(obj.toString());
            }
            DynamicObjectCollection col = this.getModel().getEntryEntity("treeentryentity");
            for (DynamicObject entryObj : col) {
                int seq = entryObj.getInt("seq");
                String entryVal = entryObj.getString("entryvalue");
                if (entryVal == null || entryVal.length() <= strLenth.intValue()) continue;
                model.beginInit();
                model.setValue("entryvalue", (Object)entryVal.substring(0, strLenth.intValue()), seq - 1);
                model.endInit();
            }
            this.getView().updateView("treeentryentity");
        } else if (StringUtils.equals((CharSequence)"precision", (CharSequence)fieldKey)) {
            ChangeData data = changeData[0];
            Object obj = data.getNewValue();
            BigDecimal precision = BigDecimal.ZERO;
            if (obj != null) {
                precision = new BigDecimal(obj.toString());
            }
            DynamicObjectCollection col = this.getModel().getEntryEntity("treeentryentity");
            for (DynamicObject entryObj : col) {
                int seq = entryObj.getInt("seq");
                Object objVal = entryObj.get("entryvalue");
                if (objVal == null) continue;
                String objValStr = objVal.toString();
                if (objValStr.matches("\\d+\\.?\\d*")) {
                    BigDecimal entryVal = entryObj.getBigDecimal("entryvalue");
                    entryVal = entryVal.setScale(precision.intValue(), 4);
                    model.beginInit();
                    model.setValue("entryvalue", (Object)entryVal, seq - 1);
                    model.endInit();
                    continue;
                }
                model.beginInit();
                model.setValue("entryvalue", null, seq - 1);
                model.endInit();
            }
            this.getView().updateView("treeentryentity");
        } else if (StringUtils.equals((CharSequence)"featuretype", (CharSequence)fieldKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
            DynamicObjectCollection colls = dataEntity.getDynamicObjectCollection("treeentryentity");
            colls.clear();
            this.setIsMust();
            Object newObj = changeData[0].getNewValue();
            Object auxpropetryObj = model.getValue(BD_AUXPROPERTY);
            model.beginInit();
            this.setAuxiliaryAttr(newObj, auxpropetryObj);
            String featureType = newObj == null ? "" : newObj.toString();
            this.setVisibleField(featureType);
            this.getModel().setValue("fieldname", null);
            this.getView().updateView("fieldname");
            this.getModel().setValue("fieldnameshow", null);
            this.getView().updateView("fieldnameshow");
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"deleteentry"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"newentry"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"insertentry"});
            model.endInit();
            model.updateCache();
            this.getView().updateView("treeentryentity");
        } else if (StringUtils.equals((CharSequence)"isdefaultvalue", (CharSequence)fieldKey)) {
            Boolean isreplace;
            Object newObj = changeData[0].getNewValue();
            int rowIndex = changeData[0].getRowIndex();
            Boolean bl = isreplace = newObj instanceof Boolean ? (Boolean)newObj : Boolean.FALSE;
            if (isreplace.booleanValue()) {
                this.changeIsDefault(rowIndex, false);
            }
            this.getView().updateView("treeentryentity");
        } else if (StringUtils.equals((CharSequence)"number", (CharSequence)fieldKey)) {
            String regex = "^(?![0-9]+$)(?![_]+$)[A-Za-z0-9_-]+$";
            Object oldValue = changeData[0].getOldValue();
            Object newValue = changeData[0].getNewValue();
            if (newValue instanceof String && !Pattern.matches(regex, String.valueOf(newValue))) {
                model.setValue("number", oldValue);
                this.getView().updateView("number");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u53ea\u53ef\u4ee5\u8f93\u5165\u5b57\u6bcd\u3001\u963f\u62c9\u4f2f\u6570\u5b57+\u4e0b\u5212\u7ebf\u201c_\u201d+\u201c-\u201d\uff0c\u4e14\u4e0d\u80fd\u8f93\u5165\u7eaf\u6570\u5b57\u3001\u7eaf\u4e0b\u5212\u7ebf\u6216\u7eaf\u201c-\u201d\u3002", (String)"FeatureDefinitionEditPlugin_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if (!StringUtils.equals((CharSequence)"featurerule", (CharSequence)fieldKey) && !StringUtils.equals((CharSequence)"entryconfigrule", (CharSequence)fieldKey)) {
            if (StringUtils.equals((CharSequence)BD_AUXPROPERTY, (CharSequence)fieldKey)) {
                Object featureTypePbj = this.getModel().getValue("featuretype");
                Object auxObj = changeData[0].getNewValue();
                DynamicObject dataEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
                DynamicObjectCollection colls = dataEntity.getDynamicObjectCollection("treeentryentity");
                colls.clear();
                model.beginInit();
                this.setAuxiliaryAttr(featureTypePbj, auxObj);
                model.endInit();
                this.getView().updateView("treeentryentity");
            } else if ("fieldname".equals(fieldKey)) {
                this.relationHandleFeatureType(changeData);
            } else if ("fieldnameshow".equals(fieldKey)) {
                Object newValue = changeData[0].getNewValue();
                if (StringUtils.isBlank((Object)newValue)) {
                    model.setValue("fieldname", (Object)"");
                    this.getView().updateView("fieldname");
                }
            } else {
                return;
            }
        }
    }

    private void relationHandleFeatureType(ChangeData[] changeData) {
        if (changeData == null) {
            return;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        model.beginInit();
        for (int i = 0; i < changeData.length; ++i) {
            ChangeData changeDatum = changeData[i];
            Object filedNameNew = changeDatum.getNewValue();
            model.deleteEntryData("treeentryentity");
            if (StringUtils.isNotBlank((Object)filedNameNew)) {
                this.getPageCache().put("isrelationupdate", "1");
                if (ENTRY_AUXPROP.equals(filedNameNew.toString())) {
                    model.setValue("featuretype", (Object)"C");
                } else if (ENTRY_QYTY_NUMBERATOR.equals(filedNameNew.toString()) || ENTRY_QYTY_DENOMINATOR.equals(filedNameNew.toString())) {
                    model.setValue("featuretype", (Object)"B");
                }
                view.updateView("featuretype");
                view.updateView("fieldname");
                this.setIsMust();
                String featureType = model.getValue("featuretype") == null ? "" : model.getValue("featuretype").toString();
                Object auxpropetryObj = model.getValue(BD_AUXPROPERTY);
                model.beginInit();
                this.setAuxiliaryAttr(featureType, auxpropetryObj);
                this.setVisibleField(featureType);
                view.setEnable(Boolean.valueOf(false), new String[]{"deleteentry"});
                view.setEnable(Boolean.valueOf(false), new String[]{"newentry"});
                view.setEnable(Boolean.valueOf(false), new String[]{"insertentry"});
            } else {
                view.setEnable(Boolean.valueOf(true), new String[]{"deleteentry"});
                view.setEnable(Boolean.valueOf(true), new String[]{"newentry"});
                view.setEnable(Boolean.valueOf(true), new String[]{"insertentry"});
            }
            view.updateView("treeentryentity");
        }
        model.endInit();
    }

    private void setVisibleField(String featureType) {
        IFormView view = this.getView();
        if ("B".equals(featureType)) {
            view.setVisible(Boolean.valueOf(true), new String[]{"isallownegative"});
            view.setVisible(Boolean.valueOf(true), new String[]{"precision"});
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"isallownegative"});
            view.setVisible(Boolean.valueOf(false), new String[]{"precision"});
        }
        if ("A".equals(featureType)) {
            view.setVisible(Boolean.valueOf(true), new String[]{"length"});
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"length"});
        }
        if ("C".equals(featureType)) {
            view.setVisible(Boolean.valueOf(true), new String[]{BD_AUXPROPERTY});
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{BD_AUXPROPERTY});
        }
        if ("D".equals(featureType)) {
            view.setVisible(Boolean.valueOf(true), new String[]{"bos_entityobject"});
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"bos_entityobject"});
        }
        if ("D".equals(featureType) || "E".equals(featureType)) {
            view.setVisible(Boolean.valueOf(true), new String[]{"isvaluemust"});
            view.setVisible(Boolean.valueOf(true), new String[]{"isvalueshow"});
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"isvalueshow"});
        }
        view.setVisible(Boolean.valueOf(true), new String[]{"isvaluemust"});
    }

    private void setAuxiliaryAttr(Object featureTypePbj, Object auxpropetryObj) {
        String filedName;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String string = filedName = model.getValue("fieldname") == null ? "" : model.getValue("fieldname").toString();
        if (featureTypePbj instanceof String && StringUtils.equals((CharSequence)"C", (CharSequence)String.valueOf(featureTypePbj)) && StringUtils.isEmpty((CharSequence)filedName)) {
            if (!(auxpropetryObj instanceof DynamicObject)) {
                return;
            }
            DynamicObject auxpropetry = (DynamicObject)auxpropetryObj;
            DynamicObjectCollection auxproperty = this.queryFeatureData(auxpropetry);
            if (auxproperty == null || auxproperty.isEmpty()) {
                return;
            }
            if (auxproperty.size() > 50) {
                this.showAuxpropertySelect(auxproperty, 50);
            } else {
                this.writeAuxpropertyToEntry(model, auxproperty);
            }
        }
    }

    private DynamicObjectCollection queryFeatureData(DynamicObject auxpropetry) {
        DynamicObjectCollection auxpropertyDOC = null;
        if (auxpropetry == null) {
            return auxpropertyDOC;
        }
        String valueType = auxpropetry.getString("valuetype");
        QFilter statusQFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        if (StringUtils.equals((CharSequence)"1", (CharSequence)valueType)) {
            DynamicObject valuesource = auxpropetry.getDynamicObject("valuesource");
            if (valuesource == null) {
                return auxpropertyDOC;
            }
            String number = valuesource.getString("number");
            try {
                auxpropertyDOC = QueryServiceHelper.query((String)number, (String)"id,number,name", (QFilter[])new QFilter[]{statusQFilter, enableQFilter});
            }
            catch (KDBizException kDBizException) {}
        } else if (StringUtils.equals((CharSequence)"2", (CharSequence)valueType)) {
            DynamicObject assistanttype = auxpropetry.getDynamicObject("assistanttype");
            if (assistanttype == null) {
                return auxpropertyDOC;
            }
            long assistenTypePK = assistanttype.getLong("id");
            QFilter groupQFilter = new QFilter("group", "=", (Object)assistenTypePK);
            auxpropertyDOC = QueryServiceHelper.query((String)BD_ASSISTANTDATA_DETAIL, (String)"id,number,name", (QFilter[])new QFilter[]{statusQFilter, enableQFilter, groupQFilter});
        }
        return auxpropertyDOC;
    }

    private void showAuxpropertySelect(DynamicObjectCollection auxpropertyDOC, int selectRowCount) {
        if (auxpropertyDOC == null) {
            return;
        }
        List<Map<String, Object>> paramData = this.resolveAuxpropertyDOC(auxpropertyDOC);
        this.showFeatureValueSelectForm(paramData, selectRowCount, true, false, "itemselector");
    }

    private List<Map<String, Object>> resolveAuxpropertyDOC(DynamicObjectCollection auxpropertyDOC) {
        ArrayList<Map<String, Object>> paramData = new ArrayList<Map<String, Object>>();
        if (auxpropertyDOC == null) {
            return paramData;
        }
        for (int i = 0; i < auxpropertyDOC.size(); ++i) {
            DynamicObject auxpropertyDO = (DynamicObject)auxpropertyDOC.get(i);
            if (auxpropertyDO == null) continue;
            long entryPK = auxpropertyDO.getLong("id");
            String entryValue = auxpropertyDO.getString("number");
            String entryvalueName = auxpropertyDO.getString("name");
            HashMap<String, Object> auxMap = new HashMap<String, Object>(4);
            auxMap.put("entryvalue", entryValue);
            auxMap.put("entryvaluename", entryvalueName);
            auxMap.put("entryid", entryPK);
            paramData.add(auxMap);
        }
        return paramData;
    }

    private void showFeatureValueSelectForm(List<Map<String, Object>> paramData, int selectRowCount, boolean isAllowMulValue, boolean isEdit, String callBackName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("list", paramData);
        params.put("selectrowcount", selectRowCount);
        params.put("isedit", isEdit);
        params.put("isallowmulvalue", isAllowMulValue);
        params.put("formId", "mpdm_featurevalselector");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(params);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackName));
        this.getView().showForm(showParameter);
    }

    private void writeAuxpropertyToEntry(IDataModel model, DynamicObjectCollection auxproperty) {
        if (model == null || auxproperty == null) {
            return;
        }
        for (int i = 0; i < auxproperty.size(); ++i) {
            DynamicObject auxDO = (DynamicObject)auxproperty.get(i);
            if (auxDO == null) continue;
            String number = auxDO.getString("number");
            String name = auxDO.getString("name");
            String auxID = auxDO.getString("id");
            model.createNewEntryRow("treeentryentity");
            model.setValue("entryvalue", (Object)number, i);
            model.setValue("entryvaluename", (Object)name, i);
            model.setValue("featurevalueid", (Object)auxID, i);
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"entryvalue"});
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"entryvaluename"});
        }
    }

    public void checkEntryRule(IDataModel model, ChangeData changeDatum, String configEntityFlag, String ruleField) {
        DynamicObjectCollection configEntity = model.getEntryEntity(configEntityFlag);
        Object oldValue = changeDatum.getOldValue();
        Object newValue = changeDatum.getNewValue();
        int rowIndex = changeDatum.getRowIndex();
        DynamicObject ruleDO = null;
        if (newValue instanceof DynamicObject) {
            ruleDO = (DynamicObject)newValue;
            for (DynamicObject configDO : configEntity) {
                DynamicObject featureRuleDO;
                if (configDO == null || (featureRuleDO = configDO.getDynamicObject(ruleField)) == null) continue;
                int seq = configDO.getInt("seq");
                long rulePKValue = ruleDO.getLong("id");
                long featureRulePK = featureRuleDO.getLong("id");
                if (seq - 1 == rowIndex || rulePKValue != featureRulePK) continue;
                model.setValue(ruleField, oldValue, rowIndex);
                this.getView().updateView("configentity");
                this.getView().updateView("treeentryentity");
                String number = ruleDO.getString("number");
                if (StringUtils.equals((CharSequence)configEntityFlag, (CharSequence)"treeentryentity")) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u89c4\u5219\u7b2c\u201c%1$s\u201d\u884c\u4e2d\u7684\u914d\u7f6e\u89c4\u5219\u201c%2$s\u201d\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FeatureDefinitionEditPlugin_5", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), rowIndex, number));
                    return;
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u89c4\u5219\u7b2c\u201c%1$s\u201d\u884c\u4e2d\u7684\u914d\u7f6e\u89c4\u5219\u201c%2$s\u201d\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FeatureDefinitionEditPlugin_4", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), rowIndex, number));
                return;
            }
        }
    }

    public void changeIsDefault(int rowIndex, boolean isDefault) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entrys = model.getEntryEntity("treeentryentity");
        if (!entrys.isEmpty() && entrys.size() > 1) {
            for (int i = 0; i < entrys.size(); ++i) {
                if (i == rowIndex) continue;
                model.beginInit();
                model.setValue("isdefaultvalue", (Object)isDefault, i);
                model.endInit();
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setIsMust();
        this.setButtonIsEdit();
        this.setRelationFieldShow();
        this.afterBindShowEdit();
    }

    private void afterBindShowEdit() {
        IDataModel model = this.getModel();
        String featureType = model.getValue("featuretype") == null ? "" : model.getValue("featuretype").toString();
        this.setVisibleField(featureType);
    }

    private void setRelationFieldShow() {
        IDataModel model = this.getModel();
        String filedName = model.getValue("fieldname") == null ? "" : model.getValue("fieldname").toString();
        this.setFiledNameShow(filedName);
    }

    private void setButtonIsEdit() {
        String filedName;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String string = filedName = model.getValue("fieldname") == null ? "" : model.getValue("fieldname").toString();
        if (StringUtils.isNotEmpty((CharSequence)filedName)) {
            view.setEnable(Boolean.valueOf(false), new String[]{"deleteentry"});
            view.setEnable(Boolean.valueOf(false), new String[]{"newentry"});
            view.setEnable(Boolean.valueOf(false), new String[]{"insertentry"});
        } else {
            view.setEnable(Boolean.valueOf(true), new String[]{"deleteentry"});
            view.setEnable(Boolean.valueOf(true), new String[]{"newentry"});
            view.setEnable(Boolean.valueOf(true), new String[]{"insertentry"});
        }
    }

    private void setIsMust() {
        Object featuretypeObj = this.getModel().getValue("featuretype");
        String featuretype = featuretypeObj == null ? "" : featuretypeObj.toString();
        FieldEdit length = (FieldEdit)this.getView().getControl("length");
        FieldEdit precision = (FieldEdit)this.getView().getControl("precision");
        FieldEdit auxproperty = (FieldEdit)this.getView().getControl(BD_AUXPROPERTY);
        FieldEdit fieldname = (FieldEdit)this.getView().getControl("fieldname");
        FieldEdit entityobject = (FieldEdit)this.getView().getControl("bos_entityobject");
        FieldEdit entryvaluename = (FieldEdit)this.getView().getControl("entryvaluename");
        FieldEdit allowNegative = (FieldEdit)this.getView().getControl("isallownegative");
        if (StringUtils.equals((CharSequence)featuretype, (CharSequence)"A")) {
            length.setMustInput(Boolean.TRUE.booleanValue());
        } else {
            length.setMustInput(Boolean.FALSE.booleanValue());
        }
        if (StringUtils.equals((CharSequence)featuretype, (CharSequence)"B")) {
            precision.setMustInput(Boolean.TRUE.booleanValue());
            entryvaluename.setVisible("entryvaluename", false);
            entryvaluename.setMustInput(Boolean.FALSE.booleanValue());
            allowNegative.setMustInput(Boolean.TRUE.booleanValue());
        } else {
            precision.setMustInput(Boolean.FALSE.booleanValue());
            entryvaluename.setVisible("entryvaluename", true);
            entryvaluename.setMustInput(Boolean.TRUE.booleanValue());
            allowNegative.setMustInput(Boolean.FALSE.booleanValue());
        }
        if (StringUtils.equals((CharSequence)featuretype, (CharSequence)"C")) {
            auxproperty.setMustInput(Boolean.TRUE.booleanValue());
        } else {
            auxproperty.setMustInput(Boolean.FALSE.booleanValue());
        }
        if (StringUtils.equals((CharSequence)featuretype, (CharSequence)"D")) {
            fieldname.setMustInput(Boolean.TRUE.booleanValue());
            entityobject.setMustInput(Boolean.TRUE.booleanValue());
        } else {
            fieldname.setMustInput(Boolean.FALSE.booleanValue());
            entityobject.setMustInput(Boolean.FALSE.booleanValue());
        }
    }

    private void validateData(ChangeData[] changeDataArray) {
        ChangeData changeData = changeDataArray[0];
        int index = changeData.getRowIndex();
        Object obj = changeData.getNewValue();
        if (obj == null || obj == "") {
            return;
        }
        String featuretype = (String)this.getModel().getValue("featuretype");
        Object lengthObj = this.getModel().getValue("length");
        int length = 0;
        if (lengthObj instanceof Integer) {
            length = (Integer)lengthObj;
        }
        Object precisionObj = this.getModel().getValue("precision");
        int precision = 0;
        if (precisionObj instanceof Integer) {
            precision = (Integer)precisionObj;
        }
        if (StringUtils.equals((CharSequence)"A", (CharSequence)featuretype)) {
            String newVal = (String)obj;
            if (newVal.length() > length) {
                this.getModel().setValue("entryvalue", (Object)newVal.substring(0, length), index);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7\u8bbe\u5b9a\u957f\u5ea6\u3002", (String)"FeatureDefinitionEditPlugin_7", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if (StringUtils.equals((CharSequence)"B", (CharSequence)featuretype)) {
            Object isAllowNegative = this.getModel().getValue("isallownegative", index);
            String userRegex = isAllowNegative instanceof Boolean && Boolean.parseBoolean(String.valueOf(isAllowNegative)) ? "^(-)?\\d+\\.?\\d*$" : "^\\d+\\.?\\d*$";
            if (!Pattern.matches(userRegex, obj.toString())) {
                this.getModel().setValue("entryvalue", null, index);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6570\u503c\u3002", (String)"FeatureDefinitionEditPlugin_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                return;
            }
            BigDecimal newVal = new BigDecimal(obj.toString());
            newVal = newVal.setScale(precision, 4);
            this.getModel().setValue("entryvalue", (Object)newVal, index);
        } else {
            return;
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        int row = e.getRow();
        IFormView view = this.getView();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (propName) {
            case "featurerule": {
                QFilter qFilter = this.beforeF7SelectFeatureValue(model, row);
                if (qFilter == null) break;
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        }
    }

    private QFilter beforeF7SelectFeatureValue(IDataModel model, int row) {
        if (model == null) {
            return null;
        }
        DynamicObjectCollection configEntityDO = model.getEntryEntity("configentity");
        if (configEntityDO == null) {
            return null;
        }
        HashSet<Object> pkValueSet = new HashSet<Object>(4);
        for (int i = 0; i < configEntityDO.size(); ++i) {
            DynamicObject featureRuleDO;
            DynamicObject configDO;
            if (i == row || (configDO = (DynamicObject)configEntityDO.get(i)) == null || (featureRuleDO = configDO.getDynamicObject("featurerule")) == null) continue;
            pkValueSet.add(featureRuleDO.getPkValue());
        }
        if (pkValueSet != null && !pkValueSet.isEmpty()) {
            return new QFilter("id", "not in", pkValueSet);
        }
        return null;
    }
}

