/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.basedata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bd.mpdm.common.constants.FeaturedefinitionConst;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;

public class FeatureDefinitionImportPlugin
extends AbstractBillPlugIn {
    private static String REGEX_A = "^(?:[1-9][0-9]?|100)$";
    private static String REGEX_B = "^(?:[0-9]?|10)$";
    private static final String AUXPROP = "auxprop";
    private static final String ENTRY_QYTY_NUMBERATOR = "entryqtynumerator";
    private static final String ENTRY_QYTY_DENOMINATOR = "entryqtydenominator";

    public void beforeImportData(BeforeImportDataEventArgs e) {
        String featureValueCheck;
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        boolean checkFail = false;
        StringBuilder msgInfo = new StringBuilder();
        String featureType = sourceData.get("featuretype") == null ? "" : sourceData.get("featuretype").toString();
        Object len = sourceData.get("length");
        Object precision = sourceData.get("precision");
        Object fieldName = sourceData.get("fieldname");
        Object auxProperty = sourceData.get("bd_auxproperty");
        String number = sourceData.get("number") == null ? "" : sourceData.get("number").toString();
        Object featureEntry = sourceData.get("treeentryentity");
        if ("A".equals(featureType)) {
            if (StringUtils.isBlank(len) || !Pattern.matches(REGEX_A, len.toString())) {
                msgInfo.append(String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u7279\u5f81\u503c\u7c7b\u578b\u4e3a\u5b57\u7b26\uff0c\u957f\u5ea6\u5fc5\u987b\u6307\u5b9a\u4e14\u8303\u56f4\u5728(0,100]\u4e4b\u95f4\u3002", (String)"FeatureDefinitionImportPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), number));
                checkFail = true;
            }
            if (StringUtils.isNotBlank(precision)) {
                msgInfo.append(String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u7279\u5f81\u503c\u7c7b\u578b\u4e3a\u5b57\u7b26\u65f6\uff0c\u53ea\u5141\u8bb8\u5bfc\u5165\u957f\u5ea6\u3002", (String)"FeatureDefinitionImportPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), number));
                checkFail = true;
            }
            if (auxProperty != null) {
                msgInfo.append(String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u7279\u5f81\u503c\u7c7b\u578b\u4e3a\u5b57\u7b26\u65f6\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u8f85\u52a9\u5c5e\u6027\u3002", (String)"FeatureDefinitionImportPlugin_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), number));
                checkFail = true;
            }
        } else if ("B".equals(featureType)) {
            if (StringUtils.isBlank(precision) || !Pattern.matches(REGEX_B, precision.toString())) {
                msgInfo.append(String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u7279\u5f81\u503c\u7c7b\u578b\u4e3a\u6570\u503c\u65f6\uff0c\u7cbe\u5ea6\u5fc5\u987b\u6307\u5b9a\u4e14\u8303\u56f4\u5728[0,10]\u4e4b\u95f4\u7684\u6574\u6570\u3002", (String)"FeatureDefinitionImportPlugin_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), number));
                checkFail = true;
            }
            if (StringUtils.isNotBlank(len)) {
                msgInfo.append(String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u7279\u5f81\u503c\u7c7b\u578b\u4e3a\u6570\u503c\u65f6\uff0c\u53ea\u5141\u8bb8\u5bfc\u5165\u7cbe\u5ea6\u3002", (String)"FeatureDefinitionImportPlugin_4", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), number));
                checkFail = true;
            }
            if (auxProperty != null) {
                msgInfo.append(String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u7279\u5f81\u503c\u7c7b\u578b\u4e3a\u6570\u503c\u65f6\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u8f85\u52a9\u5c5e\u6027\u3002", (String)"FeatureDefinitionImportPlugin_5", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), number));
                checkFail = true;
            }
        } else if ("C".equals(featureType)) {
            msgInfo.append(String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u7279\u5f81\u503c\u7c7b\u578b\u4e3a\u8f85\u52a9\u5c5e\u6027\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"FeatureDefinitionImportPlugin_6", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), number));
            checkFail = true;
        }
        if (!this.mappingFieldName(sourceData)) {
            msgInfo.append(String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u5173\u8054\u5b57\u6bb5\u503c\u5bfc\u5165\u6709\u8bef\uff0c\u8bf7\u5bfc\u5165\u6709\u6548\u6570\u636e\u201c\u8f85\u52a9\u5c5e\u6027\u201d\u6216\u201c\u7528\u91cf\uff1a\u5206\u5b50\u201d\u6216\u201c\u7528\u91cf\uff1a\u5206\u6bcd\u201d\u3002", (String)"FeatureDefinitionImportPlugin_7", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), number));
            checkFail = true;
        }
        if (!this.checkFieldName(fieldName, featureEntry)) {
            msgInfo.append(String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u5173\u8054\u5b57\u6bb5\u503c\u4e0d\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u7279\u5f81\u503c\u3002", (String)"FeatureDefinitionImportPlugin_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), number));
            checkFail = true;
        }
        if (StringUtils.isNotEmpty((CharSequence)(featureValueCheck = this.checkFeatureVRepeat(number, featureEntry)))) {
            msgInfo.append(featureValueCheck);
            checkFail = true;
        }
        if (checkFail) {
            ArrayList<String> msgs = new ArrayList<String>(1);
            msgs.add(msgInfo.toString());
            e.setCancel(true);
            e.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), msgs);
            e.setFireAfterImportData(false);
        }
    }

    private String checkFeatureVRepeat(String number, Object featureEntry) {
        StringBuilder checkFeature = new StringBuilder();
        if (featureEntry instanceof JSONArray) {
            HashSet<String> uniqueValue = new HashSet<String>(4);
            for (int i = 0; i < ((JSONArray)featureEntry).size(); ++i) {
                Object featureVRow = ((JSONArray)featureEntry).get(i);
                if (featureVRow == null) continue;
                JSONObject featureVRowJO = (JSONObject)featureVRow;
                String entryValue = featureVRowJO.getString("entryvalue");
                if (uniqueValue.contains(entryValue.toLowerCase())) {
                    checkFeature.append(String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u7279\u5f81\u503c\u5206\u5f55\u7684\u7279\u5f81\u503c\u201c%2$s\u201d\u4e0d\u5141\u8bb8\u91cd\u590d\uff08\u4e0d\u533a\u5206\u5927\u5c0f\u5199\uff09\u3002", (String)"FeatureDefinitionImportPlugin_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), number, entryValue));
                    return checkFeature.toString();
                }
                uniqueValue.add(entryValue.toLowerCase());
            }
        }
        return "";
    }

    private boolean mappingFieldName(Map<String, Object> sourceData) {
        Object fieldName = sourceData.get("fieldname");
        if (StringUtils.isBlank((Object)fieldName)) {
            return true;
        }
        if (FeaturedefinitionConst.AUXPROP_NAME.equals(fieldName.toString())) {
            sourceData.put("fieldname", AUXPROP);
        } else if (FeaturedefinitionConst.QTYNUMERATOR_NAME.equals(fieldName.toString())) {
            sourceData.put("fieldname", ENTRY_QYTY_NUMBERATOR);
        } else if (FeaturedefinitionConst.QTYDENOMINATOR_NAME.equals(fieldName.toString())) {
            sourceData.put("fieldname", ENTRY_QYTY_DENOMINATOR);
        } else {
            return AUXPROP.equals(fieldName) || ENTRY_QYTY_NUMBERATOR.equals(fieldName) || ENTRY_QYTY_DENOMINATOR.equals(fieldName);
        }
        return true;
    }

    private boolean checkFieldName(Object fieldName, Object featureEntry) {
        boolean checkResult = true;
        if (StringUtils.isBlank((Object)fieldName) || featureEntry == null) {
            return checkResult;
        }
        JSONArray featureEntrys = (JSONArray)featureEntry;
        if (featureEntrys.size() > 0) {
            checkResult = false;
        }
        return checkResult;
    }
}

