/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.batchmaintain;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.helper.BatchMaintainHelper;
import kd.bd.mpdm.business.helper.bean.BillMutexInfo;
import kd.bd.mpdm.common.consts.BatchMaintainConsts;
import kd.bd.mpdm.common.enums.BatchMaintainChangeType;
import kd.bd.mpdm.common.enums.TriggerEventType;
import kd.bd.mpdm.common.ext.LifeCycleForBatchMaintain;
import kd.bd.mpdm.formplugin.batchmaintain.BatchMaintainWriteBackUtil;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.entity.rule.AbstractRule;
import kd.bos.entity.rule.BR;
import kd.bos.entity.rule.RuleContainer;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extension.ExtensionFactory;
import kd.bos.form.BinderMap;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.converter.FormMetadataConverter;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.mvc.form.FormRuleContainer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.beanutils.BeanUtils;

public abstract class AbstractBatchMaintainTpl
extends AbstractFormPlugin {
    private Set<String> ruleDepKeys = new HashSet<String>();
    private static final ExtensionFactory<LifeCycleForBatchMaintain> extensionFactory = ExtensionFactory.getExtensionFacotry(LifeCycleForBatchMaintain.class);

    protected abstract String getTargetEntityName();

    protected abstract String getTargetEntryName();

    protected abstract String getBatchMaintainEntityName();

    protected void modifyControlAp(ControlAp ap) {
    }

    protected Set<String> getLinkedHeadField() {
        return Collections.emptySet();
    }

    protected List<QFilter> genQFilter(Long orgId) {
        return Collections.emptyList();
    }

    protected void processSelectDate(DynamicObject[] billEntitys, Set<Long> selectEntryIds) {
    }

    protected void afterAddRow(DynamicObject newEntityRow, int focusRow) {
    }

    protected void runSingleRule(int row, DynamicObject col, TriggerEventType eventType) {
    }

    protected void runRule(TriggerEventType eventType) {
    }

    public void initialize() {
        this.getView().addCustomControls(new String[]{"entryentity"});
        FormRuleContainer ruleContaiber = (FormRuleContainer)this.getView().getService(RuleContainer.class);
        try {
            Field field = FormRuleContainer.class.getDeclaredField("allEntityRules");
            field.setAccessible(true);
            field.set(ruleContaiber, this.getTargetRule());
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("init form rule fail", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("access form rule fail", e);
        }
    }

    private Map<String, List<AbstractRule>> getTargetRule() {
        HashMap<String, List<AbstractRule>> rs = new HashMap<String, List<AbstractRule>>();
        Map allEntityRules = FormMetadataCache.getAllEntityRules((String)this.getTargetEntityName());
        if (allEntityRules != null && allEntityRules.containsKey(this.getTargetEntryName())) {
            List rules = (List)allEntityRules.get(this.getTargetEntryName());
            ArrayList<BR> ruleTemps = new ArrayList<BR>();
            for (AbstractRule rule : rules) {
                if (!this.getTargetEntryName().equals(rule.getSource()) || !rule.isEnabled()) continue;
                BR tmpRule = new BR();
                try {
                    BeanUtils.copyProperties((Object)tmpRule, (Object)rule);
                }
                catch (Exception e) {
                    throw new RuntimeException("copy bean error", e);
                }
                tmpRule.setSource("entryentity");
                this.ruleDepKeys.addAll(rule.getDepFldSet());
                ruleTemps.add(tmpRule);
            }
            rs.put("entryentity", ruleTemps);
        }
        return rs;
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        EntryAp entryAp = this.getEntryAp();
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        e.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        EntityType newTargetMainType;
        EntityType newTargetEntryType;
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getTargetEntityName());
        Map allTypes = entityType.getAllEntities();
        EntityType targetMainType = (EntityType)allTypes.get(this.getTargetEntityName());
        EntityType targetEntryType = (EntityType)allTypes.get(this.getTargetEntryName());
        try {
            newMainType = (MainEntityType)oldMainType.clone();
            newTargetEntryType = (EntityType)targetEntryType.clone();
            newTargetMainType = (EntityType)targetMainType.clone();
        }
        catch (CloneNotSupportedException var5) {
            throw new KDException((Throwable)var5, new ErrorCode("AbstractBatchMaintain-clone", var5.getMessage()), new Object[0]);
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("entryentity");
        HashSet<String> linkedHead = new HashSet<String>(this.getLinkedHeadField());
        this.getTargetRule();
        for (String depKey : this.ruleDepKeys) {
            if (!newTargetMainType.getProperties().containsKey((Object)depKey)) continue;
            linkedHead.add(depKey);
        }
        newTargetMainType.getProperties().forEach(x -> {
            if (linkedHead.contains(x.getName()) || x.getName().contains("_id") && linkedHead.contains(x.getName().replace("_id", ""))) {
                entryType.addProperty((DynamicProperty)x);
            }
        });
        newTargetEntryType.getProperties().forEach(x -> {
            if (Arrays.asList(BatchMaintainConsts.removedField).contains(x.getName()) || x instanceof EntryProp) {
                return;
            }
            entryType.addProperty((DynamicProperty)x);
            if (x instanceof MuliLangTextProp) {
                ((MuliLangTextProp)x).setLocaleProperty(null, null);
            }
        });
        this.fillMultiLangTextProp(entryType);
        try {
            newMainType = (MainEntityType)newMainType.clone();
            newMainType.setMainOrg("org");
        }
        catch (CloneNotSupportedException e1) {
            throw new KDException((Throwable)e1, new ErrorCode("AbstractBatchMaintain-clone", e1.getMessage()), new Object[0]);
        }
        e.setNewEntityType(newMainType);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String headIdStr = (String)showParameter.getCustomParam("head_ids");
        String entryIdStr = (String)showParameter.getCustomParam("entry_ids");
        String orgIdStr = (String)showParameter.getCustomParam("org_id");
        if (StringUtils.isNotEmpty((CharSequence)headIdStr) && StringUtils.isNotEmpty((CharSequence)entryIdStr) && StringUtils.isNotEmpty((CharSequence)orgIdStr)) {
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(orgIdStr), (String)"bos_org");
            this.getModel().getDataEntity().set("org", (Object)org);
            Set<Long> headIds = Arrays.stream(headIdStr.split(",")).map(Long::parseLong).collect(Collectors.toSet());
            Set<Long> entryIds = Arrays.stream(entryIdStr.split(",")).map(Long::parseLong).collect(Collectors.toSet());
            this.showEntry(headIds, entryIds);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        EntryGrid dynamicEntryAp = this.getRuntimeControl();
        dynamicEntryAp.setView(this.getView());
        for (Control ctl : dynamicEntryAp.getItems()) {
            ctl.setView(this.getView());
            ((FieldEdit)ctl).setEntryKey("entryentity");
        }
        ArrayList<EntryGrid> fieldEdits = new ArrayList<EntryGrid>(dynamicEntryAp.getItems());
        fieldEdits.add(dynamicEntryAp);
        Optional<Control> first = fieldEdits.stream().filter(x -> x.getKey().equals(e.getKey())).findFirst();
        if (first.isPresent()) {
            Control control = first.get();
            e.setControl(control);
        }
    }

    private EntryGrid getRuntimeControl() {
        String key = this.getBatchMaintainEntityName() + "_runtimeEntryAp_" + this.getView().getPageId();
        LocalMemoryCache localCache = BatchMaintainHelper.getLocalCache((String)this.getBatchMaintainEntityName());
        EntryGrid dynamicEntryAp = (EntryGrid)localCache.get(key);
        if (dynamicEntryAp == null) {
            dynamicEntryAp = (EntryGrid)this.getEntryAp().buildRuntimeControl();
            this.cacheEntryElement(dynamicEntryAp, key);
        }
        return dynamicEntryAp;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.bindData(new BindingContext((Object)this.getModel().getDataEntity(true)));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String resetOrg = this.getPageCache().get("reset_org");
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if ("org".equals(e.getProperty().getName()) && oldValue != null && !Boolean.parseBoolean(resetOrg)) {
            this.getPageCache().put("org_old_value", String.valueOf(((DynamicObject)oldValue).getPkValue()));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"AbstractBatchMaintainTpl_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("exchange_org_clear", (IFormPlugin)this));
            return;
        }
        IDataEntityProperty prop = e.getProperty();
        List<FieldEdit> edits = this.getTargetBingderEdits(prop.getName());
        this.bindEditData(prop, e.getChangeSet(), edits);
        this.updateChildren(prop, e.getChangeSet());
        this.runAllRule(TriggerEventType.PROCHANGE);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("batchmodify".equals(operateKey)) {
            if (operate.getOption().containsVariable("enableOperation") && "false".equals(operate.getOption().getVariableValue("enableOperation"))) {
                operate.getOption().removeVariable("enableOperation");
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection motifyBills = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            List<DynamicObject> newEntrys = motifyBills.stream().filter(o -> BatchMaintainChangeType.ADD.getCode().equals(o.getString("maintaintype"))).collect(Collectors.toList());
            BatchMaintainWriteBackUtil.writeBack(motifyBills, this.getTargetEntityName(), this.getTargetEntryName());
            Set<BillMutexInfo> mutexInfos = this.buildMutexInfoForAddNew(newEntrys);
            BatchMaintainHelper.tryLockBill((IPageCache)this.getView().getPageCache(), mutexInfos);
            this.runAllRule(TriggerEventType.PROCHANGE);
            this.getView().updateView("entryentity");
        } else if (StringUtils.equals((CharSequence)"query", (CharSequence)operateKey)) {
            this.showQueryForm();
        } else if ("insertentry".equals(operateKey)) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
            int focusRow = grid.getEntryState().getFocusRow();
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", focusRow);
            if (!"A".equals(entryRowEntity.get("targetstatus"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6570\u636e\u4e0d\u4e3a\u6682\u5b58\u3002", (String)"AbstractBatchMaintainTpl_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), focusRow + 1));
                args.setCancel(true);
                return;
            }
            this.getView().getPageCache().put("insertentry", "true");
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] rowIndexs = e.getRowIndexs();
        if (rowIndexs.length > 0) {
            ArrayList<String> entryIds = new ArrayList<String>(1);
            for (int i = 0; i < rowIndexs.length; ++i) {
                entryIds.add(String.valueOf(this.getModel().getValue("entryentity.id", rowIndexs[i])));
            }
            List<BillMutexInfo> billMutexInfos = this.buildMutexInfoForDel(this.getModel(), entryIds);
            BatchMaintainHelper.releasePartMutex((IPageCache)this.getPageCache(), billMutexInfos);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"deleteentry", (CharSequence)operateKey) && this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").size() == 0) {
            BatchMaintainHelper.releasePageMutex((IPageCache)this.getView().getPageCache());
        }
        this.runAllRule(TriggerEventType.AFTERDO);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        int focusRow = grid.getEntryState().getFocusRow();
        RowDataEntity entity = e.getRowDataEntities()[0];
        boolean isInsert = Boolean.parseBoolean(this.getView().getPageCache().get("insertentry"));
        if (entity.getDataEntity() != null && isInsert) {
            this.getView().getPageCache().put("insertentry", "false");
            DynamicObject dynamicObject = entity.getDataEntity();
            dynamicObject.set("id", (Object)ID.genLongId());
            dynamicObject.set("targetbillid", this.getModel().getValue("targetbillid", focusRow));
            dynamicObject.set("targetseq", this.getModel().getValue("targetseq", focusRow));
            dynamicObject.set("targetstatus", this.getModel().getValue("targetstatus", focusRow));
            dynamicObject.set("pid", (Object)0);
            List plugins = extensionFactory.getActivateExtension(null, this.getTargetEntityName());
            for (LifeCycleForBatchMaintain plugin : plugins) {
                Set HeadSet = plugin.headToEntry();
                HeadSet.forEach(t -> dynamicObject.set(t, this.getModel().getValue(t, focusRow)));
            }
            this.afterAddRow(dynamicObject, focusRow);
            BatchMaintainHelper.updateViewAndReFocus((IFormView)this.getView(), (String)"entryentity", (int)e.getInsertRow());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection rows;
        super.closedCallBack(closedCallBackEvent);
        String actionKey = closedCallBackEvent.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)"query", (CharSequence)actionKey) && (rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null) {
            int currentSit = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").size();
            if (currentSit + rows.size() > BatchMaintainConsts.LIMIT) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539\u7684\u6570\u91cf,\u8d85\u8fc7%s\u6761\u9650\u5236,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractBatchMaintainTpl_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), BatchMaintainConsts.LIMIT));
                return;
            }
            HashSet<Long> headIds = new HashSet<Long>(rows.size());
            HashSet<Long> entryIds = new HashSet<Long>(rows.size());
            for (ListSelectedRow listSelectedRow : rows) {
                Object pkValue = listSelectedRow.getEntryPrimaryKeyValue();
                if (null == pkValue) continue;
                entryIds.add(Long.parseLong(pkValue.toString()));
                headIds.add(Long.parseLong(listSelectedRow.getPrimaryKeyValue().toString()));
            }
            this.showEntry(headIds, entryIds);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (StringUtils.equalsIgnoreCase((CharSequence)e.getCallBackId(), (CharSequence)"exchange_org_clear")) {
            if (e.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("entryentity");
                BatchMaintainHelper.releasePageMutex((IPageCache)this.getView().getPageCache());
            } else {
                String oldOrgValue = this.getPageCache().get("org_old_value");
                if (StringUtils.isNotEmpty((CharSequence)oldOrgValue)) {
                    DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(oldOrgValue), (String)"bos_org");
                    this.getPageCache().put("reset_org", "true");
                    this.getModel().setValue("org", (Object)org);
                    this.getPageCache().remove("reset_org");
                }
            }
        }
    }

    private void showEntry(Set<Long> selectHeadIds, Set<Long> selectEntryIds) {
        MainEntityType targetMetaType = MetadataServiceHelper.getDataEntityType((String)this.getTargetEntityName());
        DynamicObject[] selectBills = BusinessDataServiceHelper.load((Object[])selectHeadIds.toArray(), (DynamicObjectType)targetMetaType);
        this.filterLocalData(selectEntryIds);
        this.processSelectDate(selectBills, selectEntryIds);
        this.filterSelectEntry(selectBills, selectEntryIds);
        Set<BillMutexInfo> mutexList = this.buildMutexInfo(selectBills);
        List fails = BatchMaintainHelper.tryLockBill((IPageCache)this.getPageCache(), mutexList);
        Set failLockedIds = fails.stream().map(k -> Long.parseLong(k.getId())).collect(Collectors.toSet());
        if (!failLockedIds.isEmpty()) {
            StringBuilder errMsg = new StringBuilder();
            fails.forEach(k -> {
                if (StringUtils.isNotEmpty((CharSequence)k.getErrMsg())) {
                    errMsg.append(k.getErrMsg()).append("\n");
                }
            });
            this.getView().showTipNotification(errMsg.toString());
        }
        selectEntryIds.removeAll(failLockedIds);
        this.filterSelectEntry(selectBills, selectEntryIds);
        this.showEntry(targetMetaType, selectBills);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        BatchMaintainHelper.releasePageMutex((IPageCache)this.getView().getPageCache());
        String runtimeEntryKey = this.getBatchMaintainEntityName() + "_runtimeEntryAp_" + this.getView().getPageId();
        this.deleteEntryElement(runtimeEntryKey);
    }

    private void cacheEntryElement(Object entryAp, String key) {
        LocalMemoryCache localCache = BatchMaintainHelper.getLocalCache((String)this.getBatchMaintainEntityName());
        localCache.put(key, entryAp);
    }

    private void deleteEntryElement(String key) {
        LocalMemoryCache localCache = BatchMaintainHelper.getLocalCache((String)this.getBatchMaintainEntityName());
        localCache.remove(new String[]{key});
    }

    private EntryAp getEntryAp() {
        String key = this.getBatchMaintainEntityName() + "_" + "entryap_meta";
        LocalMemoryCache localCache = BatchMaintainHelper.getLocalCache((String)this.getBatchMaintainEntityName());
        EntryAp entryAp = (EntryAp)localCache.get(key);
        if (entryAp != null) {
            return entryAp;
        }
        EntryAp currentEntryAp = (EntryAp)this.getDesignerControlAp(this.getBatchMaintainEntityName(), "entryentity");
        Map<String, ControlAp<?>> targetAps = this.getAllDesignerControlAp(this.getTargetEntityName());
        EntryAp targetEntryAp = (EntryAp)targetAps.get(this.getTargetEntryName());
        Set<String> linkedHeadField = this.getLinkedHeadField();
        if (linkedHeadField != null) {
            linkedHeadField.forEach(k -> {
                if (targetAps.containsKey(k)) {
                    FieldAp ap = (FieldAp)targetAps.get(k);
                    EntryFieldAp fieldAp = new EntryFieldAp();
                    fieldAp.setQuickAddNew(ap.isQuickAddNew());
                    fieldAp.setId(ap.getId());
                    fieldAp.setKey(ap.getKey());
                    fieldAp.setName(ap.getName());
                    fieldAp.setFireUpdEvt(ap.isFireUpdEvt());
                    fieldAp.setField(ap.getField());
                    fieldAp.setVisible(ap.getVisible());
                    fieldAp.setLock(ap.getLock());
                    fieldAp.setAlignSelf(ap.getAlignSelf());
                    fieldAp.setTextAlign(ap.getTextAlign());
                    this.modifyControlAp((ControlAp)fieldAp);
                    currentEntryAp.getItems().add(fieldAp);
                }
            });
        }
        currentEntryAp.getItems().addAll(targetEntryAp.getItems().stream().filter(x -> !x.getKey().equals("id") || !x.getKey().equals("seq")).map(item -> {
            this.modifyControlAp((ControlAp)item);
            return item;
        }).collect(Collectors.toList()));
        this.cacheEntryElement(currentEntryAp, key);
        return currentEntryAp;
    }

    private ControlAp getDesignerControlAp(String formNumber, String entryNumber) {
        Map<String, ControlAp<?>> key2Ap = this.getAllDesignerControlAp(formNumber);
        return key2Ap.get(entryNumber);
    }

    private Map<String, ControlAp<?>> getAllDesignerControlAp(String formNumber) {
        String formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Form);
        String localeId = RequestContext.get().getLang().toString();
        Map designerMetadata = BatchMaintainHelper.loadDesignerMetadata((String)formId, (String)localeId, (boolean)true);
        FormMetadata formMeta = (FormMetadata)new FormMetadataConverter().convertTo(designerMetadata);
        AbstractMetadata abstractMetadata = MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Entity);
        if (abstractMetadata instanceof EntityMetadata) {
            formMeta.bindEntityMetadata((EntityMetadata)abstractMetadata);
        }
        List controlAps = formMeta.getItems();
        Map<String, ControlAp<?>> key2Ap = controlAps.stream().collect(Collectors.toMap(AbstractElement::getKey, Function.identity()));
        return key2Ap;
    }

    private void fillMultiLangTextProp(EntryType entryType) {
        DynamicCollectionProperty prop = (DynamicCollectionProperty)entryType.getProperty("multilanguagetext");
        if (prop != null) {
            for (IDataEntityProperty p : prop.getItemType().getProperties()) {
                DynamicProperty mp = entryType.getProperty(p.getName());
                if (!(mp instanceof MuliLangTextProp)) continue;
                ((MuliLangTextProp)mp).setLocaleProperty((IDataEntityProperty)prop, (DynamicSimpleProperty)p);
            }
        }
    }

    private void showQueryForm() {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)this.getTargetEntityName(), (boolean)false);
        Long orgId = (Long)this.getModel().getValue("org_id");
        if (orgId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"AbstractBachMaintainTpl_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<QFilter> qfilters = this.genQFilter(orgId);
        List plugins = extensionFactory.getActivateExtension(null, this.getTargetEntityName());
        plugins.forEach(e -> e.dealTargetListFilter(qfilters));
        if (qfilters != null) {
            showParameter.getListFilterParameter().getQFilters().addAll(qfilters);
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setMultiSelect(true);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "query");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showEntry(MainEntityType targetMetaType, DynamicObject[] selectBills) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        DynamicObjectCollection batchEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject selectBill : selectBills) {
            DynamicObjectCollection selectTargetEntry = selectBill.getDynamicObjectCollection(this.getTargetEntryName());
            for (DynamicObject selectEntry : selectTargetEntry) {
                int rowIndex = this.getModel().createNewEntryRow("entryentity");
                batchEntry.getDynamicObjectType().getProperties().forEach(batchProp -> {
                    String mappingName = this.getBatchPrivateMappingName(batchProp.getName());
                    IDataEntityProperty targetProp = targetMetaType.findProperty(mappingName);
                    if (targetProp != null) {
                        if ("id".equals(batchProp.getName())) {
                            this.getModel().setValue("entryentity." + batchProp.getName(), selectEntry.get(targetProp.getName()), rowIndex);
                        } else if (this.isHeadField(batchProp.getName(), targetProp)) {
                            this.getModel().setValue(batchProp.getName(), selectBill.get(targetProp.getName()), rowIndex);
                        } else {
                            this.getModel().setValue(batchProp.getName(), selectEntry.get(targetProp.getName()), rowIndex);
                        }
                    } else if ("maintaintype".equals(batchProp.getName())) {
                        this.getModel().setValue(batchProp.getName(), (Object)"B", rowIndex);
                    }
                });
                List plugins = extensionFactory.getActivateExtension(null, this.getTargetEntityName());
                for (LifeCycleForBatchMaintain plugin : plugins) {
                    Set HeadSet = plugin.headToEntry();
                    HeadSet.forEach(t -> this.getModel().setValue(t, selectBill.get(t), rowIndex));
                }
            }
        }
        model.endInit();
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl("entryentity");
        grid.setCollapse(false);
        this.runAllRule(TriggerEventType.LOAD);
        this.getView().updateView("entryentity");
    }

    private boolean isHeadField(String fieldName, IDataEntityProperty targetProp) {
        return "targetbillid".equals(fieldName) || "targetstatus".equals(fieldName) || targetProp.getParent().getName().equals(this.getTargetEntityName());
    }

    private String getBatchPrivateMappingName(String propName) {
        String targetName = propName;
        if ("id".equals(propName)) {
            targetName = this.getTargetEntryName() + "." + "id";
        } else if ("targetbillid".equals(propName)) {
            targetName = "id";
        } else if ("targetseq".equals(propName)) {
            targetName = this.getTargetEntryName() + "." + "seq";
        } else if ("targetstatus".equals(propName)) {
            targetName = "billstatus";
        }
        return targetName;
    }

    private <T extends Control> List<T> getTargetBingderEdits(String propertyName) {
        List sf;
        BinderMap binderMap = (BinderMap)FormMetadataCache.getControl((String)this.getTargetEntityName(), (String)"_bindermap_");
        ArrayList<Control> fes = new ArrayList<Control>();
        if (binderMap != null && (sf = (List)binderMap.getMap().get(propertyName.toLowerCase())) != null) {
            for (String key : sf) {
                Control sfCtl = this.getView().getControl(key);
                if (sfCtl == null) continue;
                fes.add(this.getView().getControl(key));
            }
        }
        return fes;
    }

    private <T extends Control> List<T> getChildEdits(String propertyName) {
        List sf;
        BinderMap binderMap = (BinderMap)FormMetadataCache.getControl((String)this.getTargetEntityName(), (String)"_bindermap_");
        ArrayList<Control> fes = new ArrayList<Control>();
        if (binderMap != null && (sf = (List)binderMap.getMap().get(propertyName.toLowerCase() + ".child")) != null) {
            for (String key : sf) {
                if (this.getView().getControl(key) == null) continue;
                fes.add(this.getView().getControl(key));
            }
        }
        return fes;
    }

    private void updateChildren(IDataEntityProperty prop, ChangeData[] changeDatas) {
        List<FieldEdit> edits = this.getChildEdits(prop.getName());
        if (edits.isEmpty()) {
            return;
        }
        if (prop instanceof CurrencyProp || prop instanceof UnitProp || prop instanceof OrgProp) {
            ChangeData changeData;
            ArrayList<FieldEdit> propEdits = new ArrayList<FieldEdit>(1);
            for (FieldEdit fieldEdit : edits) {
                if (fieldEdit instanceof BasedataPropEdit) {
                    propEdits.add(fieldEdit);
                    continue;
                }
                if (!(fieldEdit instanceof DateTimeEdit)) continue;
                propEdits.add(fieldEdit);
            }
            if (prop instanceof UnitProp && ((UnitProp)prop).isFollowUnitToChange() && (changeData = changeDatas[0]).getNewValue() != null && changeData.getOldValue() != null) {
                Long newUnitPkid = (Long)((DynamicObject)changeData.getNewValue()).getPkValue();
                Long oldUnitPkId = (Long)((DynamicObject)changeData.getOldValue()).getPkValue();
                StringBuilder errMsg = new StringBuilder();
                UnitConvertHelper.convertQtyByNewUnit((IDataModel)this.getView().getModel(), (UnitProp)((UnitProp)prop), (long)newUnitPkid, (long)oldUnitPkId, (int)changeData.getRowIndex(), (StringBuilder)errMsg);
                if (errMsg.length() > 0) {
                    this.getView().showErrorNotification(errMsg.toString());
                }
            }
            this.bindEditData(prop, changeDatas, propEdits);
        } else {
            this.bindEditData(prop, changeDatas, edits);
        }
    }

    private void bindEditData(IDataEntityProperty prop, ChangeData[] changeDatas, List<FieldEdit> edits) {
        for (ChangeData o : changeDatas) {
            for (int i = 0; i < edits.size(); ++i) {
                FieldEdit edit = edits.get(i);
                this.bindEditData(prop, edit, o);
            }
        }
    }

    private void bindEditData(IDataEntityProperty prop, FieldEdit edit, ChangeData o) {
        if (StringUtils.isNotBlank((CharSequence)edit.getEntryKey())) {
            if (prop.getParent().getName().equals(edit.getEntryKey())) {
                edit.bindData(new BindingContext((Object)o.getDataEntity(), o.getRowIndex()));
            }
        } else {
            edit.bindData(new BindingContext((Object)o.getDataEntity(), o.getRowIndex()));
        }
    }

    private void filterSelectEntry(DynamicObject[] selectBills, Set<Long> entryIds) {
        for (DynamicObject bill : selectBills) {
            DynamicObjectCollection cols = bill.getDynamicObjectCollection(this.getTargetEntryName());
            if (!CollectionUtils.isNotEmpty((Collection)cols)) continue;
            cols.removeIf(entry -> !entryIds.contains(entry.getPkValue()));
        }
    }

    private void filterLocalData(Set<Long> selectEntryIds) {
        DynamicObjectCollection cols = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)cols)) {
            List existEntryIds = cols.stream().map(col -> col.getLong("id")).collect(Collectors.toList());
            selectEntryIds.removeIf(existEntryIds::contains);
        }
    }

    private Set<BillMutexInfo> buildMutexInfo(DynamicObject[] selectBills) {
        HashSet<BillMutexInfo> mutexInfos = new HashSet<BillMutexInfo>();
        for (DynamicObject bill : selectBills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(this.getTargetEntryName());
            for (DynamicObject entry : entrys) {
                BillMutexInfo mutexInfo = new BillMutexInfo();
                mutexInfo.setId(String.valueOf(entry.getPkValue()));
                mutexInfo.setParentId(String.valueOf(bill.getPkValue()));
                mutexInfo.setBillNo(bill.getString("billno"));
                mutexInfo.setSeq(entry.getString("seq"));
                mutexInfo.setEntryNo(mutexInfo.getBillNo() + "-" + mutexInfo.getSeq());
                mutexInfo.setEntryId(true);
                mutexInfo.setEntityName(this.getTargetEntityName());
                mutexInfos.add(mutexInfo);
            }
        }
        Map<String, BillMutexInfo> billInfo = mutexInfos.stream().collect(Collectors.toMap(BillMutexInfo::getParentId, info -> info, (exist, replace) -> replace));
        billInfo.forEach((k, v) -> {
            BillMutexInfo mutexInfo = new BillMutexInfo();
            mutexInfo.setId(k);
            mutexInfo.setBillNo(v.getBillNo());
            mutexInfo.setEntityName(v.getEntityName());
            mutexInfos.add(mutexInfo);
        });
        return mutexInfos;
    }

    private Set<BillMutexInfo> buildMutexInfoForAddNew(List<DynamicObject> newBatchObj) {
        HashSet<BillMutexInfo> mutexInfos = new HashSet<BillMutexInfo>(1);
        for (DynamicObject newObj : newBatchObj) {
            BillMutexInfo mutexInfo = new BillMutexInfo();
            mutexInfo.setId(String.valueOf(newObj.getPkValue()));
            mutexInfo.setParentId(String.valueOf(newObj.getString("targetbillid")));
            mutexInfo.setBillNo(newObj.getString("billno"));
            mutexInfo.setSeq(newObj.getString("seq"));
            mutexInfo.setEntryNo(mutexInfo.getBillNo() + "-" + mutexInfo.getSeq() + "-");
            mutexInfo.setEntryId(true);
            mutexInfo.setEntityName(this.getTargetEntityName());
            mutexInfos.add(mutexInfo);
        }
        return mutexInfos;
    }

    private List<BillMutexInfo> buildMutexInfoForDel(IDataModel batchModel, List<String> delEntryId) {
        DynamicObjectCollection cols = batchModel.getDataEntity(true).getDynamicObjectCollection("entryentity");
        ArrayList<BillMutexInfo> mutexInfos = new ArrayList<BillMutexInfo>(1);
        if (cols != null) {
            HashMap<String, List> parentIDEntryId = new HashMap<String, List>(cols.size());
            ArrayList delBatchObj = new ArrayList(delEntryId.size());
            cols.forEach(obj -> {
                String entryId = String.valueOf(obj.getPkValue());
                List entryIds = parentIDEntryId.computeIfAbsent(obj.getString("targetbillid"), k -> new ArrayList(4));
                entryIds.add(entryId);
                if (delEntryId.contains(entryId)) {
                    delBatchObj.add(obj);
                }
            });
            for (DynamicObject delObj : delBatchObj) {
                BillMutexInfo mutexInfo = new BillMutexInfo();
                mutexInfo.setId(String.valueOf(delObj.getPkValue()));
                mutexInfo.setParentId(String.valueOf(delObj.getString("targetbillid")));
                mutexInfo.setBillNo(delObj.getString("billno"));
                mutexInfo.setSeq(delObj.getString("seq"));
                mutexInfo.setEntryNo(mutexInfo.getBillNo() + "-" + mutexInfo.getSeq());
                mutexInfo.setEntryId(true);
                mutexInfo.setEntityName(this.getTargetEntityName());
                mutexInfos.add(mutexInfo);
                List existEntryIds = parentIDEntryId.computeIfAbsent(mutexInfo.getParentId(), k -> new ArrayList(4));
                existEntryIds.remove(mutexInfo.getId());
                if (!CollectionUtils.isEmpty((Collection)existEntryIds)) continue;
                BillMutexInfo billMutexInfo = new BillMutexInfo();
                billMutexInfo.setId(mutexInfo.getParentId());
                billMutexInfo.setBillNo(mutexInfo.getBillNo());
                billMutexInfo.setEntityName(mutexInfo.getEntityName());
                mutexInfos.add(billMutexInfo);
            }
        }
        return mutexInfos;
    }

    private void runAllRule(TriggerEventType evenType) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        List plugins = extensionFactory.getActivateExtension(null, this.getTargetEntityName());
        for (int i = 0; i < entry.size(); ++i) {
            String type = ((DynamicObject)entry.get(i)).getString("maintaintype");
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"maintaintype"});
            this.runSingleRule(i, (DynamicObject)entry.get(i), evenType);
            for (LifeCycleForBatchMaintain plugin : plugins) {
                plugin.runSingleRule(i, (DynamicObject)entry.get(i), evenType, this.getView(), this.getModel());
                for (String head : plugin.headToEntry()) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{head});
                }
            }
        }
        this.runRule(evenType);
        plugins.forEach(e -> e.runRule(evenType, this.getView(), this.getModel()));
    }
}

