/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.batchmaintain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.helper.bean.BillMutexInfo;
import kd.bd.mpdm.common.enums.BatchMaintainChangeType;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BatchMaintainWriteBackUtil {
    public static void writeBack(DynamicObjectCollection batchEntrys, String targetEntityName, String targetEntryName) {
        HashMap<Long, DynamicObject> targetBillIdObj = new HashMap<Long, DynamicObject>();
        Set billIds = batchEntrys.stream().map(o -> o.getLong("targetbillid")).collect(Collectors.toSet());
        if (billIds.size() > 0) {
            DynamicObject[] billEntitys;
            MainEntityType targetBillMainType = EntityMetadataCache.getDataEntityType((String)targetEntityName);
            for (DynamicObject billEntity : billEntitys = BusinessDataServiceHelper.load((Object[])billIds.toArray(), (DynamicObjectType)targetBillMainType)) {
                targetBillIdObj.put(billEntity.getLong("id"), billEntity);
            }
            ArrayList<DynamicObject> insertList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> deleteList = new ArrayList<DynamicObject>();
            for (DynamicObject batchEntry : batchEntrys) {
                long targetBillId = batchEntry.getLong("targetbillid");
                String maintainType = batchEntry.getString("maintaintype");
                if (BatchMaintainChangeType.ADD.getCode().equals(maintainType)) {
                    BatchMaintainWriteBackUtil.maintainBillForNew(targetEntryName, batchEntry, (DynamicObject)targetBillIdObj.get(targetBillId));
                    insertList.add(batchEntry);
                    continue;
                }
                if (BatchMaintainChangeType.MODIFY.getCode().equals(maintainType)) {
                    BatchMaintainWriteBackUtil.maintainBillForChange(targetEntryName, batchEntry, (DynamicObject)targetBillIdObj.get(targetBillId));
                    continue;
                }
                if (!BatchMaintainChangeType.DELETE.getCode().equals(maintainType) && !BatchMaintainChangeType.REPLACE_DELETE.getCode().equals(maintainType)) continue;
                BatchMaintainWriteBackUtil.maintainBillForDelete(targetEntryName, batchEntry, (DynamicObject)targetBillIdObj.get(targetBillId));
                deleteList.add(batchEntry);
            }
            if (targetBillIdObj.isEmpty()) {
                return;
            }
            Collection values = targetBillIdObj.values();
            OperateOption create = OperateOption.create();
            create.setVariableValue("ishasright", "true");
            create.setVariableValue("ignoreinteraction", "true");
            OperationResult saveOperate = SaveServiceHelper.saveOperate((String)targetEntityName, (DynamicObject[])values.toArray(new DynamicObject[0]), (OperateOption)create);
            if (!saveOperate.isSuccess()) {
                throw new KDBizException(new ErrorCode("BatchMaintainWriteBack", String.format(ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539%1$s\u5931\u8d25,\u539f\u5355\u5f02\u5e38\u4fe1\u606f\uff1a%2$s", (String)"BatchMaintainWriteBackUtil_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), targetBillMainType.getDisplayName().getLocaleValue(), BatchMaintainWriteBackUtil.getErrDetail(saveOperate))), new Object[0]);
            }
            insertList.forEach(add -> add.set("maintaintype", (Object)BatchMaintainChangeType.MODIFY.getCode()));
            batchEntrys.removeIf(deleteList::contains);
        }
    }

    public static void maintainBillForNew(String entryName, DynamicObject maintainEntry, DynamicObject targetEntity) {
        if (targetEntity != null) {
            DynamicObjectCollection targetEntrys = targetEntity.getDynamicObjectCollection(entryName);
            DynamicObjectType targetEntryType = targetEntrys.getDynamicObjectType();
            DynamicObject newEntry = targetEntrys.addNew();
            targetEntryType.getProperties().forEach(prop -> {
                if (maintainEntry.containsProperty(prop.getName())) {
                    newEntry.set(prop.getName(), maintainEntry.get(prop.getName()));
                }
            });
            newEntry.set("seq", (Object)targetEntrys.size());
        }
    }

    public static void maintainBillForChange(String entryName, DynamicObject maintainEntry, DynamicObject targetEntity) {
        if (targetEntity != null) {
            DynamicObjectType targetEntryType = targetEntity.getDynamicObjectCollection(entryName).getDynamicObjectType();
            Optional<DynamicObject> optional = targetEntity.getDynamicObjectCollection(entryName).stream().filter(o -> o.getPkValue().equals(maintainEntry.getPkValue())).findFirst();
            if (optional.isPresent()) {
                DynamicObject targetEntry = optional.get();
                targetEntryType.getProperties().forEach(prop -> {
                    if (maintainEntry.containsProperty(prop.getName())) {
                        targetEntry.set(prop.getName(), maintainEntry.get(prop.getName()));
                    }
                });
            }
        }
    }

    public static void maintainBillForDelete(String entryName, DynamicObject maintainEntry, DynamicObject targetEntity) {
        if (targetEntity != null) {
            DynamicObjectCollection stockEntryCol = targetEntity.getDynamicObjectCollection(entryName);
            stockEntryCol.removeIf(t -> t.getPkValue().equals(maintainEntry.getPkValue()));
        }
    }

    public static String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        if (optResult.getMessage() != null) {
            errDetail.append(optResult.getMessage());
        }
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage());
        }
        return errDetail.toString();
    }

    private Set<BillMutexInfo> getMutexInfoForAddNew(String targetEntityName, DynamicObject newObj) {
        HashSet<BillMutexInfo> mutexInfos = new HashSet<BillMutexInfo>();
        BillMutexInfo mutexInfo = new BillMutexInfo();
        mutexInfo.setId(String.valueOf(newObj.getPkValue()));
        mutexInfo.setParentId(String.valueOf(newObj.getString("targetbillid")));
        mutexInfo.setBillNo(newObj.getString("billno"));
        mutexInfo.setSeq(newObj.getString("seq"));
        mutexInfo.setEntryId(true);
        mutexInfo.setEntityName(targetEntityName);
        mutexInfos.add(mutexInfo);
        return mutexInfos;
    }
}

