/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.batchmaintain;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bd.mpdm.business.helper.BatchMaintainHelper;
import kd.bd.mpdm.common.ext.IBatchMaintainCallBackInterveneMapper;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.mftorder.utils.StockCulUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ReplaceSetEdit
extends AbstractBillPlugIn
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public int getSelectEntryRowIndex() {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    private List<Integer> getExistList(DynamicObject firstDym, Long mftStockId) {
        ArrayList<Integer> errExistList = new ArrayList<Integer>();
        DynamicObject load = BusinessDataServiceHelper.loadSingle((String)"pom_mftstock", (String)"replaceplan,pid,actissueqty,rejectedqty,feedingqty,allotqty,outqty", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)mftStockId)});
        if (load == null) {
            return errExistList;
        }
        DynamicObjectCollection entryEntity = load.getDynamicObjectCollection("stockentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            if (replacePlan == null || !replacePlan.getPkValue().equals(firstDym.getPkValue()) || "0".equals(entry.getString("pid"))) continue;
            BigDecimal actissueQty = entry.getBigDecimal("actissueqty");
            BigDecimal rejectedQty = entry.getBigDecimal("rejectedqty");
            BigDecimal feedingQty = entry.getBigDecimal("feedingqty");
            BigDecimal allotQty = entry.getBigDecimal("allotqty");
            BigDecimal outqty = entry.getBigDecimal("outqty");
            if (actissueQty.compareTo(BigDecimal.ZERO) != 0) {
                errExistList.add(i + 1);
                continue;
            }
            if (rejectedQty.compareTo(BigDecimal.ZERO) != 0) {
                errExistList.add(i + 1);
                continue;
            }
            if (feedingQty.compareTo(BigDecimal.ZERO) != 0) {
                errExistList.add(i + 1);
                continue;
            }
            if (allotQty.compareTo(BigDecimal.ZERO) != 0) {
                errExistList.add(i + 1);
                continue;
            }
            if (outqty.compareTo(BigDecimal.ZERO) == 0) continue;
            errExistList.add(i + 1);
        }
        return errExistList;
    }

    private void setMaintainTypeToD(DynamicObjectCollection entryentity, Set<String> entryIdSet) {
        for (int i = 0; i < entryentity.size(); ++i) {
            if (!entryIdSet.contains(String.valueOf(((DynamicObject)entryentity.get(i)).getPkValue())) || ((DynamicObject)entryentity.get(i)).getLong("pid") == 0L) continue;
            ((DynamicObject)entryentity.get(i)).set("maintaintype", (Object)"D");
            this.getView().updateView("maintaintype", i);
        }
    }

    private void clearReplaceInfo(DynamicObjectCollection entryEntity, Set<String> entryIdSet) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (!entryIdSet.contains(String.valueOf(((DynamicObject)entryEntity.get(i)).getPkValue()))) continue;
            if (((DynamicObject)entryEntity.get(i)).getLong("pid") == 0L) {
                this.getModel().setValue("replaceplan", null, i);
                this.getModel().setValue("priority", (Object)0, i);
                this.getModel().setValue("ismainreplace", (Object)false, i);
                this.getModel().setValue("useratio", (Object)100, i);
                continue;
            }
            this.getModel().setValue("replaceplan", null, i);
            this.getModel().setValue("useratio", (Object)0, i);
        }
    }

    private Set<Long> haveSameReplace(DynamicObjectCollection entryEntity, Map<Long, Set<DynamicObject>> entryIdReplaceMap) {
        HashSet<Long> sameReplaceIdSet = new HashSet<Long>(16);
        for (DynamicObject entry : entryEntity) {
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            Long targetBillId = entry.getLong("targetbillid");
            if (entryIdReplaceMap.get(targetBillId) == null || !entryIdReplaceMap.get(targetBillId).contains(replacePlan)) continue;
            sameReplaceIdSet.add((Long)entry.getPkValue());
        }
        return sameReplaceIdSet;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        List<Integer> moreThan100List;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList<Integer> errList = new ArrayList<Integer>(selectRows.length);
        for (int i : selectRows) {
            if (i >= entryentity.size() || !"D".equals(((DynamicObject)entryentity.get(i)).getString("maintaintype"))) continue;
            errList.add(i);
        }
        if (errList.size() > 0) {
            switch (op.getOperateKey()) {
                case "deleteentry": {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5df2\u6807\u8bb0\u4e3a\u66ff\u4ee3\u5220\u9664\uff0c\u8bf7\u5148\u63d0\u4ea4\u4fee\u6539\u540e\u518d\u8fdb\u884c\u79fb\u9664\u64cd\u4f5c\u3002", (String)"ReplaceSetEdit_21", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), errList));
                    e.setCancel(true);
                    return;
                }
                case "replaceset": {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5df2\u6807\u8bb0\u4e3a\u66ff\u4ee3\u5220\u9664\uff0c\u65e0\u6cd5\u518d\u8fdb\u884c\u66ff\u4ee3\u8bbe\u7f6e\u3002", (String)"ReplaceSetEdit_22", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), errList));
                    e.setCancel(true);
                    return;
                }
                case "replacedel": {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5df2\u6807\u8bb0\u4e3a\u66ff\u4ee3\u5220\u9664\u3002", (String)"ReplaceSetEdit_23", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), errList));
                    e.setCancel(true);
                    return;
                }
            }
        }
        if ("deleteentry".equals(op.getOperateKey())) {
            ArrayList<Integer> replaceList = new ArrayList<Integer>(selectRows.length);
            for (int i : selectRows) {
                if (((DynamicObject)entryentity.get(i)).getDynamicObject("replaceplan") == null) continue;
                replaceList.add(i + 1);
            }
            if (!replaceList.isEmpty()) {
                ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("deleteReplaceEntry", (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7b2c%1$s\u884c\u5206\u5f55\u5b58\u5728\u7ec4\u4ef6\u66ff\u4ee3\u5173\u7cfb\uff0c\u662f\u5426\u5c06\u66ff\u4ee3\u76f8\u5173\u884c\u4e00\u5e76\u79fb\u9664\u7ef4\u62a4\uff1f", (String)"ReplaceSetEdit_16", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), replaceList), MessageBoxOptions.OKCancel, confirmCallBack);
                e.setCancel(true);
            }
        } else if ("replacedel".equals(op.getOperateKey())) {
            if (entryGrid.getSelectRows().length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u5206\u5f55\u3002", (String)"ReplaceSetEdit_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Integer> errReplaceList = new ArrayList<Integer>(selectRows.length);
            ArrayList<Integer> errExistList = new ArrayList<Integer>(selectRows.length);
            HashMap<Long, Set<DynamicObject>> entryIdReplaceMap = new HashMap<Long, Set<DynamicObject>>(16);
            for (int i : selectRows) {
                DynamicObject replacePlan = ((DynamicObject)entryentity.get(i)).getDynamicObject("replaceplan");
                if (replacePlan == null) {
                    errReplaceList.add(i + 1);
                    continue;
                }
                Long targetBillId = ((DynamicObject)entryentity.get(i)).getLong("targetbillid");
                List<Integer> originalExistList = this.getExistList(replacePlan, targetBillId);
                if (originalExistList.size() > 0) {
                    errExistList.add(i + 1);
                    continue;
                }
                if (entryIdReplaceMap.get(targetBillId) != null) {
                    ((Set)entryIdReplaceMap.get(targetBillId)).add(replacePlan);
                    continue;
                }
                entryIdReplaceMap.put(targetBillId, Sets.newHashSet((Object[])new DynamicObject[]{replacePlan}));
            }
            Set<Long> entryIdSet = this.haveSameReplace(entryentity, entryIdReplaceMap);
            if (!errReplaceList.isEmpty()) {
                StringJoiner stringJoiner = new StringJoiner("\u3001");
                errReplaceList.forEach(t -> stringJoiner.add(String.valueOf(t)));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e0d\u5b58\u5728\u7ec4\u4ef6\u66ff\u4ee3\u5173\u7cfb\u3002", (String)"ReplaceSetEdit_18", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), stringJoiner));
            }
            if (!errExistList.isEmpty()) {
                StringJoiner stringJoiner = new StringJoiner("\u3001");
                errExistList.forEach(t -> stringJoiner.add(String.valueOf(t)));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u6709\u76f8\u5173\u66ff\u4ee3\u6599\u5df2\u7ecf\u53d1\u751f\u9886\u6599\u6216\u8c03\u62e8\u4e1a\u52a1\u3002", (String)"ReplaceSetEdit_19", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), stringJoiner));
            }
            StringJoiner entryIdStr = new StringJoiner("@");
            entryIdSet.forEach(id -> entryIdStr.add(String.valueOf(id)));
            op.getOption().setVariableValue("deleteEntryIdStr", entryIdStr.toString());
        } else if ("batchmodify".equals(op.getOperateKey()) && !(moreThan100List = this.getReplaceList()).isEmpty()) {
            StringJoiner stringJoiner = new StringJoiner("\u3001");
            moreThan100List.forEach(t -> stringJoiner.add(String.valueOf(t)));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5bf9\u5e94\u7684\u66ff\u4ee3\u5173\u7cfb\u4f7f\u7528\u6bd4\u4f8b\u4e4b\u548c\u4e0d\u7b49\u4e8e100%%\u3002", (String)"ReplaceSetEdit_24", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), stringJoiner));
            op.getOption().setVariableValue("enableOperation", "false");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        if (StringUtils.equals((CharSequence)"replaceset", (CharSequence)e.getOperateKey())) {
            this.showReplaceList();
        } else if (StringUtils.equals((CharSequence)"replacedel", (CharSequence)e.getOperateKey())) {
            FormOperate op = (FormOperate)e.getSource();
            if (!op.getOption().containsVariable("deleteEntryIdStr")) {
                return;
            }
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            String entryIdStr = op.getOption().getVariableValue("deleteEntryIdStr");
            Object[] entryIdArr = "".equals(entryIdStr) ? new String[]{} : entryIdStr.split("@");
            HashSet entryIdSet = Sets.newHashSet((Object[])entryIdArr);
            if (!entryIdSet.isEmpty()) {
                this.setMaintainTypeToD(entryentity, entryIdSet);
                this.clearReplaceInfo(entryentity, entryIdSet);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5c06\u76f8\u5bf9\u5e94\u7ec4\u4ef6\u66ff\u4ee3\u5173\u7cfb\u7684\u5b50\u7269\u6599\u6807\u8bb0\u4e3a\u66ff\u4ee3\u5220\u9664\uff0c\u8bf7\u5173\u6ce8\u7236\u7269\u6599\u53d8\u5316\u3002", (String)"ReplaceSetEdit_20", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
            op.getOption().removeVariable("deleteEntryIdStr");
            ReplaceSetEdit.setUseratioEnable(this.getModel(), this.getView());
            ReplaceSetEdit.setMaterialEnable(this.getModel(), this.getView());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (StringUtils.equalsIgnoreCase((CharSequence)e.getCallBackId(), (CharSequence)"deleteReplaceEntry") && e.getResult() == MessageBoxResult.Yes) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            HashMap<Long, Set<DynamicObject>> entryIdReplaceMap = new HashMap<Long, Set<DynamicObject>>(16);
            ArrayList<Integer> rowIndex = new ArrayList<Integer>(entryEntity.size());
            for (int i : selectRows) {
                DynamicObject replacePlan = ((DynamicObject)entryEntity.get(i)).getDynamicObject("replaceplan");
                Long targetBillId = ((DynamicObject)entryEntity.get(i)).getLong("targetbillid");
                if (replacePlan != null) {
                    if (entryIdReplaceMap.get(targetBillId) != null) {
                        ((Set)entryIdReplaceMap.get(targetBillId)).add(replacePlan);
                        continue;
                    }
                    entryIdReplaceMap.put(targetBillId, Sets.newHashSet((Object[])new DynamicObject[]{replacePlan}));
                    continue;
                }
                rowIndex.add(i);
            }
            Set<Long> entryIdSet = this.haveSameReplace(entryEntity, entryIdReplaceMap);
            if (!entryIdSet.isEmpty()) {
                for (int i = entryEntity.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entryEntity.get(i);
                    if (!entryIdSet.contains((Long)entry.getPkValue())) continue;
                    rowIndex.add(i);
                }
                if (rowIndex.size() > 0) {
                    this.getModel().deleteEntryRows("entryentity", rowIndex.stream().mapToInt(Integer::intValue).toArray());
                }
                entryGrid.selectRows(new int[0], 0);
            }
        }
    }

    private void showReplaceList() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        if (entryGrid.getSelectRows().length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u5206\u5f55\u3002", (String)"ReplaceSetEdit_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        } else {
            Map repConfigSet = StockCulUtils.getRepConfigSet();
            int selectSize = entryGrid.getSelectRows().length;
            HashMap<String, List<String>> mapInfoList = new HashMap<String, List<String>>(selectSize);
            HashMap<String, BigDecimal> infoListMap = new HashMap<String, BigDecimal>(16);
            ArrayList<Integer> errMaterialList = new ArrayList<Integer>(selectSize);
            ArrayList<Integer> errReplaceList = new ArrayList<Integer>(selectSize);
            ArrayList<Integer> mainList = new ArrayList<Integer>(selectSize);
            Long materialIdFind = 0L;
            for (int i = 0; i < selectSize; ++i) {
                DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", entryGrid.getSelectRows()[i]);
                DynamicObject material = entry.getDynamicObject("materialid");
                DynamicObject product = entry.getDynamicObject("productid");
                if (material == null) {
                    errMaterialList.add(entryGrid.getSelectRows()[i] + 1);
                    continue;
                }
                if (product != null && material.getPkValue().equals(product.getPkValue())) {
                    mainList.add(entryGrid.getSelectRows()[i] + 1);
                }
                if (entry.getDynamicObject("replaceplan") != null) {
                    errReplaceList.add(entryGrid.getSelectRows()[i] + 1);
                }
                materialIdFind = (Long)material.getDynamicObject("masterid").getPkValue();
                String stockCompareString = StockCulUtils.getStockCompareString((DynamicObject)entry, (Map)repConfigSet);
                String stockId = entry.getString("targetbillid");
                if (mapInfoList.get(stockId) != null) {
                    ((List)mapInfoList.get(stockId)).add(stockCompareString);
                } else {
                    mapInfoList.put(stockId, new ArrayList<String>(Collections.singletonList(stockCompareString)));
                }
                infoListMap.put(stockCompareString + "0", entry.getBigDecimal("qtynumerator"));
                infoListMap.put(stockCompareString + "1", entry.getBigDecimal("qtydenominator"));
            }
            if (!errMaterialList.isEmpty()) {
                StringJoiner stringJoiner = new StringJoiner("\u3001");
                errMaterialList.forEach(t -> stringJoiner.add(String.valueOf(t)));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7ec4\u4ef6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReplaceSetEdit_10", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), stringJoiner));
                return;
            }
            if (!mainList.isEmpty()) {
                StringJoiner stringJoiner = new StringJoiner("\u3001");
                mainList.forEach(t -> stringJoiner.add(String.valueOf(t)));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7269\u6599\u4e0e\u4e3b\u4ea7\u54c1\u76f8\u540c\uff0c\u4e0d\u5141\u8bb8\u88ab\u66ff\u4ee3\u3002", (String)"ReplaceSetEdit_11", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), stringJoiner));
                return;
            }
            if (!errReplaceList.isEmpty()) {
                StringJoiner stringJoiner = new StringJoiner("\u3001");
                errReplaceList.forEach(t -> stringJoiner.add(String.valueOf(t)));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5df2\u7ecf\u505a\u8fc7\u7ec4\u4ef6\u66ff\u4ee3\u3002", (String)"ReplaceSetEdit_12", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), stringJoiner));
                return;
            }
            DynamicObject[] loadSingles = null;
            DynamicObject mtfOrg = (DynamicObject)this.getModel().getValue("org");
            if (mtfOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"ReplaceSetEdit_13", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            } else {
                QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_replaceplan", (Long)((Long)mtfOrg.getPkValue()));
                orgFilter.and(new QFilter("status", "=", (Object)"C"));
                orgFilter.and(new QFilter("enable", "=", (Object)"1"));
                orgFilter.and(new QFilter("mainmaterentry.material.masterid", "=", (Object)materialIdFind));
                loadSingles = BusinessDataServiceHelper.load((String)"mpdm_replaceplan", (String)"mainmaterentry,mainmaterentry.material,mainmaterentry.bomversion,mainmaterentry.mole,mainmaterentry.deno,mainmaterentry.auxpty,mainmaterentry.unit", (QFilter[])new QFilter[]{orgFilter});
            }
            if (loadSingles != null) {
                List<Long> ids = this.getReplaceId(mapInfoList, loadSingles, infoListMap, repConfigSet);
                ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"mpdm_replaceplan", (boolean)false);
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(new QFilter("id", "in", ids));
                showParameter.getListFilterParameter().setQFilters(filters);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "replaceset");
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    private List<Long> getReplaceId(Map<String, List<String>> infoList, DynamicObject[] loadSingles, Map<String, BigDecimal> infoListMap, Map<String, Boolean> repConfigSet) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (DynamicObject loadSingle : loadSingles) {
            DynamicObjectCollection dymCol = loadSingle.getDynamicObjectCollection("mainmaterentry");
            ArrayList<String> replaceInfoList = new ArrayList<String>();
            HashMap<String, BigDecimal> replaceInfoListMap = new HashMap<String, BigDecimal>(16);
            for (DynamicObject dym : dymCol) {
                String replaceCompareString = StockCulUtils.getReplaceCompareString((DynamicObject)dym, repConfigSet);
                replaceInfoList.add(replaceCompareString);
                replaceInfoListMap.put(replaceCompareString + "0", dym.getBigDecimal("mole"));
                replaceInfoListMap.put(replaceCompareString + "1", dym.getBigDecimal("deno"));
            }
            if (!ReplaceSetEdit.isListEqual(infoList, replaceInfoList) || !ReplaceSetEdit.isAlike(infoList, infoListMap, replaceInfoListMap, repConfigSet)) continue;
            ids.add((Long)loadSingle.getPkValue());
        }
        return ids;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionKey = e.getActionId();
        if (e.getReturnData() != null) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
            Object pk = rows.get(0).getPrimaryKeyValue();
            if (StringUtils.equalsIgnoreCase((CharSequence)"replaceset", (CharSequence)actionKey)) {
                DynamicObject replacePlan = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"mpdm_replaceplan");
                this.setReplaceInfo(replacePlan);
                ReplaceSetEdit.setUseratioEnable(this.getModel(), this.getView());
                ReplaceSetEdit.setMaterialEnable(this.getModel(), this.getView());
                PluginProxy extPlugin = PluginProxy.create(null, IBatchMaintainCallBackInterveneMapper.class, (String)"POM_BATCHMAINTAIN_RUNRULEAFTERCALLBACK_EXT", null);
                extPlugin.callReplace(p -> {
                    p.runRuleAfterCallBackMainBatch(this.getView(), this.getModel());
                    return null;
                });
            }
        }
    }

    public static void setUseratioEnable(IDataModel model, IFormView view) {
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            if (replacePlan == null || "0".equals(entry.getString("pid"))) {
                view.setEnable(Boolean.FALSE, i, new String[]{"useratio"});
                continue;
            }
            view.setEnable(Boolean.TRUE, i, new String[]{"useratio"});
        }
    }

    public static void setMaterialEnable(IDataModel model, IFormView view) {
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            boolean isBomExtend = entry.getBoolean("isbomextend");
            if (replacePlan == null && !isBomExtend) {
                view.setEnable(Boolean.TRUE, i, new String[]{"materialid"});
                view.setEnable(Boolean.TRUE, i, new String[]{"qtytype"});
                view.setEnable(Boolean.TRUE, i, new String[]{"bomreversion"});
                view.setEnable(Boolean.TRUE, i, new String[]{"entryconfiguredcode"});
                continue;
            }
            view.setEnable(Boolean.FALSE, i, new String[]{"materialid"});
            view.setEnable(Boolean.FALSE, i, new String[]{"qtytype"});
            view.setEnable(Boolean.FALSE, i, new String[]{"bomreversion"});
            view.setEnable(Boolean.FALSE, i, new String[]{"entryconfiguredcode"});
        }
    }

    private void setReplaceInfo(DynamicObject replacePlan) {
        Map repConfigSet = StockCulUtils.getRepConfigSet();
        if (!this.validReplace(replacePlan, repConfigSet)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u4ef6\u66ff\u4ee3\u5173\u7cfb\u4e0d\u5b58\u5728\u6709\u6548\u7684\u66ff\u4ee3\u7269\u6599\u3002", (String)"ReplaceSetEdit_14", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObjectCollection dymCol = replacePlan.getDynamicObjectCollection("mainmaterentry");
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            if (entryGrid.getSelectRows().length > 0) {
                long replaceGroupId = ID.genLongId();
                for (int i = 0; i < entryGrid.getSelectRows().length; ++i) {
                    for (DynamicObject dym : dymCol) {
                        this.setReplaceInfoByID(entryGrid.getSelectRows()[i], dym, replacePlan, repConfigSet, replaceGroupId);
                    }
                }
            }
        }
    }

    private boolean validReplace(DynamicObject replacePlan, Map<String, Boolean> repConfigSet) {
        DynamicObjectCollection dymCol = replacePlan.getDynamicObjectCollection("mainmaterentry");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        for (int i = 0; i < entryGrid.getSelectRows().length; ++i) {
            for (DynamicObject dym : dymCol) {
                DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", entryGrid.getSelectRows()[i]);
                if (!StockCulUtils.getStockCompareString((DynamicObject)entry, repConfigSet).equals(StockCulUtils.getReplaceCompareString((DynamicObject)dym, repConfigSet)) || !dym.getBoolean("isreplace")) continue;
                return this.validReplaceEntry(entryGrid.getSelectRows()[i], replacePlan);
            }
        }
        return false;
    }

    private boolean validReplaceEntry(int curreuntIndex, DynamicObject replacePlan) {
        DynamicObjectCollection dymCol = replacePlan.getDynamicObjectCollection("repmaterentry");
        DynamicObject[] dymList = this.sortByReppriority(dymCol);
        for (int i = 0; i < dymList.length; ++i) {
            Date demandDate = (Date)this.getModel().getValue("demanddate", curreuntIndex);
            Date validDate = dymList[i].getDate("repeffectdate");
            Date invalidDate = dymList[i].getDate("repinvaliddate");
            if (demandDate.compareTo(validDate) < 0 || demandDate.compareTo(invalidDate) > 0) continue;
            return true;
        }
        return false;
    }

    private void setReplaceInfoByID(int i, DynamicObject dym, DynamicObject replacePlan, Map<String, Boolean> repConfigSet, long replaceGroupId) {
        DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", i);
        if (StockCulUtils.getStockCompareString((DynamicObject)entry, repConfigSet).equals(StockCulUtils.getReplaceCompareString((DynamicObject)dym, repConfigSet))) {
            this.getModel().setValue("priority", dym.get("priority"), i);
            this.getModel().setValue("ismainreplace", dym.get("isreplace"), i);
            this.getModel().setValue("replaceplan", replacePlan.getPkValue(), i);
            this.getModel().setValue("replacegroupid", (Object)replaceGroupId, i);
            if (dym.getBoolean("isreplace")) {
                this.insertReplaceEntry(i, replacePlan, dym, repConfigSet, replaceGroupId);
            }
        }
    }

    private void insertReplaceEntry(int curreuntIndex, DynamicObject replacePlan, DynamicObject dym, Map<String, Boolean> repConfigSet, long replaceGroupId) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection dymCol = replacePlan.getDynamicObjectCollection("repmaterentry");
        DynamicObject[] dymList = this.sortByReppriority(dymCol);
        for (int i = 0; i < dymList.length; ++i) {
            Date demandDate = (Date)this.getModel().getValue("demanddate", curreuntIndex);
            Date validDate = dymList[i].getDate("repeffectdate");
            Date invalidDate = dymList[i].getDate("repinvaliddate");
            if (demandDate.compareTo(validDate) < 0 || demandDate.compareTo(invalidDate) > 0) continue;
            int insertEntryRow = this.getModel().insertEntryRow("entryentity", curreuntIndex);
            for (int j = 0; j < selectRows.length; ++j) {
                if (selectRows[j] < insertEntryRow) continue;
                selectRows[j] = selectRows[j] + 1;
            }
            this.setReplaceValue(insertEntryRow, dymList[i], curreuntIndex, replacePlan, dym, repConfigSet, replaceGroupId);
            BatchMaintainHelper.updateViewAndReFocus((IFormView)this.getView(), (String)"entryentity", (int)insertEntryRow);
        }
        entryGrid.selectRows(selectRows, curreuntIndex);
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl("entryentity");
        grid.expand(curreuntIndex);
    }

    private void setReplaceValue(int insertEntryRow, DynamicObject dymList, int curreuntIndex, DynamicObject replacePlan, DynamicObject dym, Map<String, Boolean> repConfigSet, long replaceGroupId) {
        String isquotacontrol;
        DynamicObject pro;
        DynamicObject stockEntry = this.getModel().getEntryRowEntity("entryentity", curreuntIndex);
        Map res = StockCulUtils.calRepRes((DynamicObject)dymList, (DynamicObject)dym, (DynamicObject)stockEntry, repConfigSet);
        this.getPageCache().put("isIgnoreChangeMftstock", "true");
        this.getModel().setValue("replaceplan", replacePlan.getPkValue(), insertEntryRow);
        this.getModel().setValue("priority", dymList.get("reppriority"), insertEntryRow);
        this.getModel().setValue("replacegroupid", (Object)replaceGroupId, insertEntryRow);
        this.getModel().setValue("transactiontypeid", stockEntry.get("transactiontypeid"), insertEntryRow);
        DynamicObject materialold = dymList.getDynamicObject("repmaterial");
        if (materialold == null) {
            return;
        }
        DynamicObject mtfOrg = (DynamicObject)this.getModel().getValue("org");
        if (mtfOrg == null) {
            return;
        }
        DynamicObject masterid = materialold.getDynamicObject("masterid");
        QFilter filter = new QFilter("masterid", "=", masterid.getPkValue());
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)((Long)mtfOrg.getPkValue()));
        DynamicObject materialinfoold = BusinessDataServiceHelper.loadSingle((Object)materialold.getPkValue(), (String)"bd_materialmftinfo");
        DynamicObject[] materialinfos = BusinessDataServiceHelper.load((String)"bd_materialmftinfo", (String)"supplyorgunitid,warehouse,location,outstorageunit,outwarehouse,outwarelocation,issuemode,isbackflush,iskeypart,isquotacontrol,issinhighlimit,issinlowlimit,isstockallot,isbulkmaterial", (QFilter[])new QFilter[]{filter, orgFilter});
        DynamicObject materialinfo = materialinfoold;
        if (materialinfos != null && materialinfos.length > 0) {
            materialinfo = materialinfos[0];
        }
        if ((pro = stockEntry.getDynamicObject("productid")) != null && pro.getPkValue().equals(materialinfo.getPkValue())) {
            this.getModel().setValue("rework", (Object)Boolean.TRUE, insertEntryRow);
        }
        this.getModel().setValue("materialid", (Object)materialinfo, insertEntryRow);
        this.getModel().setValue("materielmasterid", materialinfo.get("masterid"), insertEntryRow);
        this.getModel().setValue("childauxpropertyid", dymList.get("repauxpty"), insertEntryRow);
        this.getModel().setValue("bomreversion", dymList.get("repbomversion"), insertEntryRow);
        this.getModel().setValue("ismainreplace", dymList.get("isrep"), insertEntryRow);
        this.getModel().setValue("materialunitid", dymList.get("repunit"), insertEntryRow);
        this.getModel().setValue("qtynumerator", res.get("mole"), insertEntryRow);
        this.getModel().setValue("qtydenominator", res.get("deno"), insertEntryRow);
        this.getModel().setValue("qtytype", stockEntry.get("qtytype"), insertEntryRow);
        this.getModel().setValue("useratio", (Object)0, insertEntryRow);
        this.getModel().setValue("fixscrap", stockEntry.get("fixscrap"), insertEntryRow);
        this.getModel().setValue("scraprate", stockEntry.get("scraprate"), insertEntryRow);
        this.getModel().setValue("wastagerateformula", stockEntry.get("wastagerateformula"), insertEntryRow);
        this.getModel().setValue("isbomextend", (Object)Boolean.FALSE, insertEntryRow);
        this.getModel().setValue("iscannegative", stockEntry.get("iscannegative"), insertEntryRow);
        this.getModel().setValue("supplymode", stockEntry.get("supplymode"), insertEntryRow);
        this.getModel().setValue("supplierid", stockEntry.get("supplierid"), insertEntryRow);
        this.getModel().setValue("parentid", stockEntry.getPkValue(), insertEntryRow);
        this.getModel().setValue("workprocedureid", stockEntry.get("workprocedureid"), insertEntryRow);
        this.getModel().setValue("oprno", stockEntry.get("oprno"), insertEntryRow);
        this.getModel().setValue("processseq", stockEntry.get("processseq"), insertEntryRow);
        this.getModel().setValue("oprworkcenter", stockEntry.get("oprworkcenter"), insertEntryRow);
        this.getModel().setValue("machiningtype", stockEntry.get("machiningtype"), insertEntryRow);
        this.getModel().setValue("outsupplier", stockEntry.get("outsupplier"), insertEntryRow);
        this.getModel().setValue("workstation", stockEntry.get("workstation"), insertEntryRow);
        this.getModel().setValue("demanddate", stockEntry.get("demanddate"), insertEntryRow);
        this.getModel().setValue("leadtime", stockEntry.get("leadtime"), insertEntryRow);
        this.getModel().setValue("parentmaterial", stockEntry.get("parentmaterial"), insertEntryRow);
        this.getModel().setValue("pstockentryid", stockEntry.get("pstockentryid"), insertEntryRow);
        this.getModel().setValue("supplyorgid", materialinfo.get("supplyorgunitid"), insertEntryRow);
        String entityName = this.getModel().getDataEntityType().getName();
        this.getModel().setValue("warehouseid", materialinfo.get("warehouse"), insertEntryRow);
        this.getModel().setValue("location", materialinfo.get("location"), insertEntryRow);
        this.getModel().setValue("outorgunitid", materialinfo.get("outstorageunit"), insertEntryRow);
        this.getModel().setValue("outwarehouseid", materialinfo.get("outwarehouse"), insertEntryRow);
        this.getModel().setValue("outlocation", materialinfo.get("outwarelocation"), insertEntryRow);
        String modestring = MPDMMftGenStocksUtils.getIssuemode((Object)materialinfo.get("issuemode"));
        this.getModel().setValue("issuemode", (Object)modestring, insertEntryRow);
        this.getModel().setValue("isbackflush", materialinfo.get("isbackflush"), insertEntryRow);
        if (StringUtils.equals((CharSequence)entityName, (CharSequence)"pom_stockbatchmaintain")) {
            MPDMMftGenStocksUtils.setStockEntryWarehouse((DynamicObject)mtfOrg, (String)"pom_mftstock", (IDataModel)this.getModel(), (int)insertEntryRow);
        }
        this.getModel().setValue("iskeypart", materialinfo.get("iskeypart"), insertEntryRow);
        String string = isquotacontrol = materialinfo.get("isquotacontrol") == null ? "" : materialinfo.getString("isquotacontrol");
        if (StringUtils.equals((CharSequence)isquotacontrol, (CharSequence)"true")) {
            this.getModel().setValue("overissuecontrl", (Object)"B", insertEntryRow);
        } else {
            this.getModel().setValue("overissuecontrl", (Object)"A", insertEntryRow);
        }
        BigDecimal issinhighlimit = materialinfo.get("issinhighlimit") == null ? BigDecimal.ZERO : materialinfo.getBigDecimal("issinhighlimit");
        this.getModel().setValue("issinhighlimit", (Object)issinhighlimit, insertEntryRow);
        BigDecimal issinlowlimit = materialinfo.get("issinlowlimit") == null ? BigDecimal.ZERO : materialinfo.getBigDecimal("issinlowlimit");
        this.getModel().setValue("issinlowlimit", (Object)issinlowlimit, insertEntryRow);
        this.getModel().setValue("isstockallot", materialinfo.get("isstockallot"), insertEntryRow);
        this.getModel().setValue("isbulkmaterial", materialinfo.get("isbulkmaterial"), insertEntryRow);
        this.getModel().setValue("targetbillid", stockEntry.get("targetbillid"), insertEntryRow);
        this.getModel().setValue("targetseq", (Object)(stockEntry.getInt("targetseq") + 1), insertEntryRow);
        this.getModel().setValue("targetstatus", stockEntry.get("targetstatus"), insertEntryRow);
        this.getModel().setValue("billno", stockEntry.get("billno"), insertEntryRow);
        this.getModel().setValue("productid", stockEntry.get("productid"), insertEntryRow);
        this.getModel().setValue("baseqty", stockEntry.get("baseqty"), insertEntryRow);
        this.getModel().setValue("pid", stockEntry.getPkValue(), insertEntryRow);
        this.getPageCache().put("isIgnoreChangeMftstock", "false");
    }

    private DynamicObject[] sortByReppriority(DynamicObjectCollection dymCol) {
        int i;
        DynamicObject[] dymList = new DynamicObject[dymCol.size()];
        for (i = 0; i < dymCol.size(); ++i) {
            dymList[i] = (DynamicObject)dymCol.get(i);
        }
        for (i = 0; i < dymList.length - 1; ++i) {
            for (int j = 0; j < dymList.length - 1 - i; ++j) {
                if (dymList[j].getInt("reppriority") <= dymList[j + 1].getInt("reppriority")) continue;
                DynamicObject temp = dymList[j];
                dymList[j] = dymList[j + 1];
                dymList[j + 1] = temp;
            }
        }
        return dymList;
    }

    public static boolean isListEqual(Map<String, List<String>> mapList1, List<String> list2) {
        for (Map.Entry<String, List<String>> list1 : mapList1.entrySet()) {
            if (list1.getValue().equals(list2)) continue;
            if (list1.getValue().size() != list2.size()) {
                return false;
            }
            if (list1.getValue().containsAll(list2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlike(Map<String, List<String>> mapInfoList, Map<String, BigDecimal> infoListMap, Map<String, BigDecimal> replaceInfoListMap, Map<String, Boolean> repConfigSet) {
        for (Map.Entry<String, List<String>> infoList : mapInfoList.entrySet()) {
            boolean isNeedNum = repConfigSet.get("isNeedNum");
            String infoOne = infoList.getValue().get(0);
            BigDecimal stockMole = infoListMap.get(infoOne + "0");
            if ((infoList.getValue().size() == 1 || !isNeedNum) && stockMole.compareTo(BigDecimal.ZERO) != 0) continue;
            BigDecimal stockDeno = infoListMap.get(infoOne + "1");
            BigDecimal repMole = replaceInfoListMap.get(infoOne + "0");
            BigDecimal repDeno = replaceInfoListMap.get(infoOne + "1");
            for (String info : infoList.getValue()) {
                BigDecimal stockMoleNew = infoListMap.get(info + "0");
                BigDecimal stockDenoNew = infoListMap.get(info + "1");
                BigDecimal repMoleNew = replaceInfoListMap.get(info + "0");
                BigDecimal repDenoNew = replaceInfoListMap.get(info + "1");
                BigDecimal moleMul = repMole.multiply(stockMoleNew);
                BigDecimal demoMul = repDeno.multiply(stockDenoNew);
                BigDecimal moleMulNew = stockMole.multiply(repMoleNew);
                BigDecimal demoMulNew = stockDeno.multiply(repDenoNew);
                if (stockMoleNew.compareTo(BigDecimal.ZERO) == 0) {
                    return false;
                }
                if (moleMul.multiply(demoMulNew).compareTo(demoMul.multiply(moleMulNew)) == 0) continue;
                return false;
            }
        }
        return true;
    }

    private List<Integer> getReplaceList() {
        ArrayList<Integer> replaceList = new ArrayList<Integer>();
        HashMap<String, HashSet> replaceIdMap = new HashMap<String, HashSet>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            if (replacePlan == null) continue;
            String targetId = entry.getString("targetbillid");
            if (replaceIdMap.get(targetId) != null) {
                ((Set)replaceIdMap.get(targetId)).add(replacePlan.getPkValue().toString());
                continue;
            }
            replaceIdMap.put(targetId, Sets.newHashSet((Object[])new String[]{replacePlan.getPkValue().toString()}));
        }
        for (Map.Entry replaceIdList : replaceIdMap.entrySet()) {
            for (String replaceStr : (Set)replaceIdList.getValue()) {
                int parentIndex = -1;
                HashSet<Integer> childSet = new HashSet<Integer>();
                BigDecimal childUseratio = BigDecimal.ZERO;
                for (int i = 0; i < entryEntity.size(); ++i) {
                    Integer childPriority;
                    DynamicObject entry = (DynamicObject)entryEntity.get(i);
                    DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
                    if (!entry.getString("targetbillid").equals(replaceIdList.getKey()) || replacePlan == null) continue;
                    if (replacePlan.getPkValue().toString().equals(replaceStr) && "0".equals(entry.getString("pid")) && entry.getBoolean("ismainreplace")) {
                        parentIndex = i;
                        childUseratio = childUseratio.add(entry.getBigDecimal("useratio"));
                    }
                    if (!replacePlan.getPkValue().toString().equals(replaceStr) || "0".equals(entry.getString("pid")) || !childSet.add(childPriority = Integer.valueOf(entry.getInt("priority")))) continue;
                    childUseratio = childUseratio.add(entry.getBigDecimal("useratio"));
                }
                if (childUseratio.compareTo(new BigDecimal(100)) == 0 || parentIndex == -1) continue;
                replaceList.add(parentIndex + 1);
            }
        }
        return replaceList;
    }
}

