/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.bombasedata;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.enums.BOMEntryQtyTypeEnum;
import kd.bd.mpdm.common.query.helper.MaterialPlanQueryHelper;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ReplacePlanEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener,
TabSelectListener {
    private static final String OPERATEKEY_UNSUBMIT = "unsubmit";
    private static final String OPERATEKEY_UNAUDIT = "unaudit";
    private static final String OPERATEKEY_PREVIOUSENTRY = "previousentry";
    private static final String OPERATEKEY_NEXTENTRY = "nextentry";
    private static final String KEY_MAINENTRY = "mainmaterentry";
    private static final String KEY_REPENTRY = "repmaterentry";
    private static final String KEY_QTYENTRY = "qtyentry";
    public static final String TAB_ENTRY = "tab_entry";
    public static final String TABPAGE_QTYENTRY = "tabpage_qtyentry";
    private static final String KEY_MATERIAL = "material";
    private static final String KEY_UNIT = "unit";
    private static final String KEY_AUXPTY = "auxpty";
    private static final String KEY_BOMVERSION = "bomversion";
    private static final String KEY_ISREPLACE = "isreplace";
    private static final String KEY_REPMATERIAL = "repmaterial";
    private static final String KEY_REPUNIT = "repunit";
    private static final String KEY_REPAUXPTY = "repauxpty";
    private static final String KEY_REPBOMVERSION = "repbomversion";
    private static final String KEY_ISREP = "isrep";
    private static final String KEY_REPPRIORITY = "reppriority";
    private static final String KEY_CHANGED = "changed";
    private static final String KEY_REPQTYTYPE = "repqtytype";
    private static final String KEY_REPFIXSCRAP = "repfixscrap";
    private static final String KEY_REPSCRAPRATE = "repscraprate";
    private static final String KEY_QTYENTRYBATCHSTARTQTY = "qtyentrybatchstartqty";
    private static final String KEY_QTYENTRYBATCHENDQTY = "qtyentrybatchendqty";
    private static final String KEY_QTYENTRYISSTEPFIX = "qtyentryisstepfix";
    private static final String KEY_QTYENTRYQTYNUMERATOR = "qtyentryqtynumerator";
    private static final String KEY_QTYENTRYQTYDENOMINATOR = "qtyentryqtydenominator";
    private static final String KEY_QTYENTRYFIXSCRAP = "qtyentryfixscrap";
    private static final String KEY_QTYENTRYSCRAPRATE = "qtyentryscraprate";
    private static final String KEY_QTYENTRYKEY = "qtyentrykey";
    public static final String FLEX_QTYENTRY = "flex_qtyentry";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (this.getPageCache().get("isIgnoreChangeListener") == "true") {
            return;
        }
        String proptyKey = e.getProperty().getName();
        Object newObj = e.getChangeSet()[0].getNewValue();
        Object oldObj = e.getChangeSet()[0].getOldValue();
        int index = e.getChangeSet()[0].getRowIndex();
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        if (KEY_MATERIAL.equalsIgnoreCase(proptyKey)) {
            this.change4material(newObj, index, KEY_CHANGED);
        } else if (KEY_REPMATERIAL.equalsIgnoreCase(proptyKey)) {
            this.change4repmaterial(newObj, index, KEY_CHANGED);
        } else if (KEY_ISREPLACE.equalsIgnoreCase(proptyKey)) {
            this.changeIsreplace(newObj, index);
        } else if (KEY_REPQTYTYPE.equalsIgnoreCase(proptyKey)) {
            this.qtyTypeChanged(fv, dm, index, (String)newObj, oldObj);
        }
    }

    private void change4material(Object newObj, int index, String operationType) {
        if (newObj instanceof DynamicObject) {
            DynamicObject mater;
            DynamicObject baseunit;
            DynamicObject materInfo = (DynamicObject)newObj;
            if (materInfo != null && (baseunit = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)(mater = materInfo.getDynamicObject("masterid")), (String)"baseunit")) != null) {
                this.getModel().setValue(KEY_UNIT, baseunit.get("id"), index);
            }
            this.setAuxptyAndVersionView(KEY_MAINENTRY, index, operationType);
            this.getView().updateView(KEY_MAINENTRY);
        }
    }

    private void change4repmaterial(Object newObj, int index, String operationType) {
        if (newObj instanceof DynamicObject) {
            DynamicObject materInfo = (DynamicObject)newObj;
            if (materInfo != null) {
                DynamicObject mater = materInfo.getDynamicObject("masterid");
                DynamicObject baseunit = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)mater, (String)"baseunit");
                if (baseunit != null) {
                    this.getModel().setValue(KEY_REPUNIT, baseunit.get("id"), index);
                }
                BigDecimal wastageRate = this.getWastagerate(materInfo);
                this.getModel().setValue(KEY_REPSCRAPRATE, (Object)wastageRate, index);
            }
            this.setAuxptyAndVersionView(KEY_REPENTRY, index, operationType);
            this.getView().updateView(KEY_REPENTRY);
        }
    }

    public void changeIsreplace(Object newObj, int index) {
        IDataModel model;
        DynamicObjectCollection entrys;
        Boolean isreplace;
        Boolean bl = isreplace = newObj instanceof Boolean ? (Boolean)newObj : Boolean.FALSE;
        if (isreplace.booleanValue() && !(entrys = (model = this.getModel()).getEntryEntity(KEY_MAINENTRY)).isEmpty() && entrys.size() > 1) {
            for (int i = 0; i < entrys.size(); ++i) {
                if (i == index) continue;
                model.setValue(KEY_ISREPLACE, (Object)Boolean.FALSE, i);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        RowDataEntity[] row = e.getRowDataEntities();
        IDataModel dm = this.getModel();
        IFormView fv = this.getView();
        if (row != null && row.length > 0) {
            IDataModel model = this.getModel();
            String name = e.getEntryProp().getName();
            int index = row[0].getRowIndex();
            if (index == 0 && KEY_MAINENTRY.equals(name)) {
                model.setValue(KEY_ISREPLACE, (Object)Boolean.TRUE, index);
            }
            if (KEY_REPENTRY.equals(name)) {
                if (index <= 0) {
                    model.setValue(KEY_REPPRIORITY, (Object)1, index);
                } else {
                    int lastrow = index - 1;
                    Object obj = this.getModel().getValue(KEY_REPPRIORITY, lastrow);
                    if (obj instanceof Integer) {
                        int reppriority = (Integer)obj + 1;
                        if (reppriority >= 99) {
                            reppriority = 99;
                        }
                        model.setValue(KEY_REPPRIORITY, (Object)reppriority, index);
                    }
                }
                model.setValue(KEY_ISREP, (Object)Boolean.TRUE, index);
            } else if (KEY_QTYENTRY.equals(name)) {
                int qtyEntryRowCount = dm.getEntryRowCount(KEY_QTYENTRY);
                int rdesSize = row.length;
                BigDecimal maxQtyEntryBatchEndQty = BigDecimal.ZERO;
                for (int qtyRowIndex = 0; qtyRowIndex < qtyEntryRowCount; ++qtyRowIndex) {
                    BigDecimal qtyEntryBatchEndQty;
                    if (qtyRowIndex >= qtyEntryRowCount - rdesSize || (qtyEntryBatchEndQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)KEY_QTYENTRYBATCHENDQTY, (int)qtyRowIndex, (BigDecimal)BigDecimal.ZERO)).compareTo(maxQtyEntryBatchEndQty) <= 0) continue;
                    maxQtyEntryBatchEndQty = qtyEntryBatchEndQty;
                }
                DynamicObject materialMft = (DynamicObject)dm.getValue("entrymaterial_qty");
                for (int i = 0; i < rdesSize; ++i) {
                    RowDataEntity rde = row[i];
                    if (rde == null) continue;
                    DynamicObject rowDO = rde.getDataEntity();
                    int rowIndex = rde.getRowIndex();
                    if (rowDO == null || rowIndex < 0) continue;
                    dm.beginInit();
                    rowDO.beginInit();
                    BigDecimal newQtyEntryBatchStartQty = maxQtyEntryBatchEndQty.add(BigDecimal.ZERO);
                    dm.setValue(KEY_QTYENTRYBATCHSTARTQTY, (Object)newQtyEntryBatchStartQty, rowIndex);
                    BigDecimal newQtyEntryBatchEndQty = newQtyEntryBatchStartQty.add(BigDecimal.ONE);
                    dm.setValue(KEY_QTYENTRYBATCHENDQTY, (Object)newQtyEntryBatchEndQty, rowIndex);
                    BigDecimal wastageRate = this.getWastagerate(materialMft);
                    dm.setValue(KEY_QTYENTRYSCRAPRATE, (Object)wastageRate, rowIndex);
                    maxQtyEntryBatchEndQty = newQtyEntryBatchEndQty;
                    rowDO.endInit();
                    dm.endInit();
                    fv.updateView(KEY_QTYENTRYBATCHSTARTQTY, rowIndex);
                    fv.updateView(KEY_QTYENTRYBATCHENDQTY, rowIndex);
                }
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String name = e.getEntryProp().getName();
        if (StringUtil.isNotEmpty((CharSequence)name)) {
            this.setAuxptyAndVersionView(name, 0, null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        int entryRowIndex;
        Tab entryTab;
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        if ((StringUtils.equals((CharSequence)OPERATEKEY_UNSUBMIT, (CharSequence)key) || StringUtils.equals((CharSequence)OPERATEKEY_UNAUDIT, (CharSequence)key)) && result != null && result.isSuccess()) {
            this.setAuxptyAndVersionView(KEY_MAINENTRY, 0, null);
            this.setAuxptyAndVersionView(KEY_REPENTRY, 0, null);
        }
        String tabPageKey = (entryTab = (Tab)this.getControl(TAB_ENTRY)) == null ? null : entryTab.getCurrentTab();
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_REPENTRY);
        AbstractGrid.GridState entryGS = entryGrid == null ? null : entryGrid.getEntryState();
        int n = entryRowIndex = entryGS == null ? -1 : entryGS.getFocusRow();
        if (TABPAGE_QTYENTRY.equalsIgnoreCase(tabPageKey) && entryRowIndex >= 0) {
            String pageFlex = null;
            if (TABPAGE_QTYENTRY.equalsIgnoreCase(tabPageKey)) {
                pageFlex = FLEX_QTYENTRY;
            }
            if (key.equalsIgnoreCase(OPERATEKEY_PREVIOUSENTRY) || key.equalsIgnoreCase(OPERATEKEY_NEXTENTRY)) {
                this.updateChildPage(pageFlex, true);
            }
        }
    }

    public void registerListener(EventObject e) {
        Tab tab;
        super.registerListener(e);
        BasedataEdit mainbomVersion = (BasedataEdit)this.getView().getControl(KEY_BOMVERSION);
        BasedataEdit repbomVersion = (BasedataEdit)this.getView().getControl(KEY_REPBOMVERSION);
        if (mainbomVersion != null) {
            mainbomVersion.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (repbomVersion != null) {
            repbomVersion.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit material = (BasedataEdit)this.getView().getControl(KEY_MATERIAL);
        BasedataEdit repmaterial = (BasedataEdit)this.getView().getControl(KEY_REPMATERIAL);
        if (material != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (repmaterial != null) {
            repmaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((tab = (Tab)this.getControl(TAB_ENTRY)) != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        int index = event.getRow();
        String key = event.getProperty().getName();
        if (KEY_BOMVERSION.equals(key)) {
            DynamicObject materInfo = (DynamicObject)this.getModel().getValue(KEY_MATERIAL, index);
            if (materInfo != null) {
                DynamicObject mater = materInfo.getDynamicObject("masterid");
                if (mater != null) {
                    QFilter qFilter = new QFilter(KEY_MATERIAL, "=", mater.getPkValue());
                    ListShowParameter fParameter = (ListShowParameter)event.getFormShowParameter();
                    ListFilterParameter filterParameter = fParameter.getListFilterParameter();
                    List qList = filterParameter.getQFilters();
                    qList.add(qFilter);
                } else {
                    event.setCancel(true);
                }
            } else {
                event.setCancel(true);
            }
        } else if (KEY_REPBOMVERSION.equals(key)) {
            DynamicObject materInfo = (DynamicObject)this.getModel().getValue(KEY_REPMATERIAL, index);
            if (materInfo != null) {
                DynamicObject mater = materInfo.getDynamicObject("masterid");
                if (mater != null) {
                    QFilter qFilter = new QFilter(KEY_MATERIAL, "=", mater.getPkValue());
                    ListShowParameter fParameter = (ListShowParameter)event.getFormShowParameter();
                    ListFilterParameter filterParameter = fParameter.getListFilterParameter();
                    List qList = filterParameter.getQFilters();
                    qList.add(qFilter);
                } else {
                    event.setCancel(true);
                }
            } else {
                event.setCancel(true);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)KEY_MATERIAL, (CharSequence)key) || StringUtils.equalsIgnoreCase((CharSequence)KEY_REPMATERIAL, (CharSequence)key)) {
            ListShowParameter fParameter = (ListShowParameter)event.getFormShowParameter();
            ListFilterParameter filterParameter = fParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            QFilter qFilterAttr = new QFilter("materialattr", "!=", (Object)"10020");
            qList.add(qFilterAttr);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String status = (String)this.getModel().getValue("status");
        if ("A".equals(status)) {
            this.setAuxptyAndVersionView(KEY_MAINENTRY, 0, null);
            this.setAuxptyAndVersionView(KEY_REPENTRY, 0, null);
        }
        this.hindPageTurn();
    }

    private void setAuxptyAndVersionView(String key, int index, String operationType) {
        String bomVsionName;
        String auxptyName;
        String materName;
        String entryName;
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)key, (CharSequence)KEY_MAINENTRY)) {
            entryName = KEY_MAINENTRY;
            materName = KEY_MATERIAL;
            auxptyName = KEY_AUXPTY;
            bomVsionName = KEY_BOMVERSION;
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)KEY_REPENTRY)) {
            entryName = KEY_REPENTRY;
            materName = KEY_REPMATERIAL;
            auxptyName = KEY_REPAUXPTY;
            bomVsionName = KEY_REPBOMVERSION;
        } else {
            return;
        }
        DynamicObjectCollection entrys = model.getEntryEntity(entryName);
        if (entrys != null && !entrys.isEmpty()) {
            this.setCell(entrys, materName, bomVsionName, auxptyName, index, operationType);
        } else {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(bomVsionName);
            if (basedataEdit != null) {
                basedataEdit.setMustInput(false);
            }
        }
    }

    private void setCell(DynamicObjectCollection entrys, String materName, String bomVsionName, String auxptyName, int index, String operationType) {
        Boolean bomVsionFlag = Boolean.TRUE;
        Boolean mateFlag = Boolean.TRUE;
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject mate;
            DynamicObject materInfo = (DynamicObject)this.getModel().getValue(materName, i);
            DynamicObject dynamicObject = mate = materInfo == null ? null : materInfo.getDynamicObject("masterid");
            if (mate != null) {
                if (mate.getBoolean("isuseauxpty")) {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{auxptyName});
                } else {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{auxptyName});
                    this.getModel().setValue(auxptyName, null, i);
                }
                if (!mate.getBoolean("isenablematerialversion")) {
                    bomVsionFlag = Boolean.FALSE;
                }
                if (!KEY_CHANGED.equals(operationType)) continue;
                this.getModel().setValue(bomVsionName, null, index);
                continue;
            }
            mateFlag = Boolean.FALSE;
        }
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(bomVsionName);
        if (basedataEdit != null) {
            if (bomVsionFlag.booleanValue() && mateFlag.booleanValue()) {
                basedataEdit.setMustInput(true);
            } else {
                basedataEdit.setMustInput(false);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object object = e.getSource();
        if (object != null) {
            DynamicObjectCollection repEntrys;
            IDataModel model = this.getModel();
            DynamicObjectCollection mianEntrys = model.getEntryEntity(KEY_MAINENTRY);
            if (!mianEntrys.isEmpty() && mianEntrys.size() > 0) {
                for (int i = 0; i < mianEntrys.size(); ++i) {
                    model.setValue(KEY_ISREPLACE, (Object)Boolean.TRUE, i);
                }
            }
            if (!(repEntrys = model.getEntryEntity(KEY_REPENTRY)).isEmpty() && repEntrys.size() > 0) {
                for (int j = 0; j < repEntrys.size(); ++j) {
                    model.setValue(KEY_ISREP, (Object)Boolean.TRUE, j);
                }
            }
        }
        this.setDefualtCreateOrg();
    }

    private void setDefualtCreateOrg() {
        Map customParams;
        Object org;
        IDataModel model = this.getModel();
        Object createorg = model.getValue("createorg");
        if (createorg == null && (org = (customParams = this.getView().getFormShowParameter().getCustomParams()).get("org")) != null) {
            model.setValue("createorg", org);
        }
    }

    private void hindPageTurn() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String parentFormId = formShowParameter.getParentFormId();
        if ("mpdm_replaceplanreport".equals(parentFormId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"pagepanel"});
        }
    }

    private void updateChildPage(String pageFlex, boolean isUpdateSubEntry) {
        int entryRowIndex;
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        IPageCache pc = this.getPageCache();
        if (pc == null) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_REPENTRY);
        AbstractGrid.GridState entryGS = entryGrid == null ? null : entryGrid.getEntryState();
        int n = entryRowIndex = entryGS == null ? -1 : entryGS.getFocusRow();
        if (entryRowIndex < 0) {
            return;
        }
        DynamicObject entryDO = dm.getEntryRowEntity(KEY_REPENTRY, entryRowIndex);
        if (entryDO == null) {
            return;
        }
        String entryQtyType = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)entryDO, (String)KEY_REPQTYTYPE);
        if (FLEX_QTYENTRY.equalsIgnoreCase(pageFlex)) {
            if (!BOMEntryQtyTypeEnum.STEP.getValue().equalsIgnoreCase(entryQtyType)) {
                fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7ec4\u4ef6\u7684\u201c\u7528\u91cf\u7c7b\u578b\u201d\u2260\u9636\u68af\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u9636\u68af\u7528\u91cf\u3002", (String)"ReplacePlanEdit_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), entryRowIndex + 1));
                fv.setVisible(Boolean.FALSE, new String[]{FLEX_QTYENTRY});
                return;
            }
            fv.setVisible(Boolean.TRUE, new String[]{FLEX_QTYENTRY});
            dm.setValue("entryseq_qty", (Object)(entryRowIndex + 1));
            DynamicObject entryMFTInfoDO = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)KEY_REPMATERIAL);
            Object entryMFTInfoPKObj = entryMFTInfoDO == null ? null : entryMFTInfoDO.getPkValue();
            Long entryMFTInfoPK = entryMFTInfoPKObj == null ? Long.valueOf(0L) : Long.valueOf(Long.parseLong(entryMFTInfoPKObj.toString()));
            dm.setValue("entrymaterial_qty", (Object)(entryMFTInfoPK <= 0L ? null : entryMFTInfoPK));
            DynamicObject entryMFTUnitDO = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)KEY_REPUNIT);
            Object entryMFTUnitPKObj = entryMFTUnitDO == null ? null : entryMFTUnitDO.getPkValue();
            Long entryMFTUnitPK = entryMFTUnitPKObj == null ? Long.valueOf(0L) : Long.valueOf(Long.parseLong(entryMFTUnitPKObj.toString()));
            dm.setValue("entryunit_qty", (Object)(entryMFTUnitPK <= 0L ? null : entryMFTUnitPK));
            fv.updateView(KEY_QTYENTRY);
        }
    }

    public void tabSelected(TabSelectEvent event) {
        int entryRowIndex;
        if (event == null) {
            return;
        }
        IFormView fv = this.getView();
        String tabPageKey = event.getTabKey();
        if (DynamicObjDataUtil.isEmptyString((String)tabPageKey)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_REPENTRY);
        AbstractGrid.GridState entryGS = entryGrid == null ? null : entryGrid.getEntryState();
        int n = entryRowIndex = entryGS == null ? -1 : entryGS.getFocusRow();
        if (tabPageKey.equalsIgnoreCase(TABPAGE_QTYENTRY)) {
            if (entryRowIndex >= 0) {
                fv.setVisible(Boolean.TRUE, new String[]{FLEX_QTYENTRY});
                String pageFlex = null;
                if (tabPageKey.equalsIgnoreCase(TABPAGE_QTYENTRY)) {
                    pageFlex = FLEX_QTYENTRY;
                }
                this.updateChildPage(pageFlex, true);
            } else {
                fv.setVisible(Boolean.FALSE, new String[]{FLEX_QTYENTRY});
                fv.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u7ec4\u4ef6\u3002", (String)"ReplacePlanEdit_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void qtyTypeChanged(IFormView fv, IDataModel dm, Integer rowIndex, String propertyValueStr, Object oldObj) {
        if (rowIndex < 0) {
            return;
        }
        DynamicObject entry = dm.getEntryRowEntity(KEY_REPENTRY, rowIndex.intValue());
        if (entry == null) {
            return;
        }
        DynamicObjectCollection qtyEntryCol = entry.getDynamicObjectCollection(KEY_QTYENTRY);
        if (qtyEntryCol == null) {
            return;
        }
        DynamicObject repMaterial = entry.getDynamicObject(KEY_REPMATERIAL);
        if (repMaterial == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u66ff\u4ee3\u7269\u6599\u7f16\u7801.", (String)"ReplacePlanEdit_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            this.getPageCache().put("isIgnoreChangeListener", "true");
            entry.set(KEY_REPQTYTYPE, oldObj);
            this.getPageCache().put("isIgnoreChangeListener", "false");
            return;
        }
        if (!BOMEntryQtyTypeEnum.STEP.value.equalsIgnoreCase(propertyValueStr)) {
            qtyEntryCol.clear();
            fv.updateView(KEY_QTYENTRY);
        } else if ("10020".equalsIgnoreCase(repMaterial.getString("materialattr"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u865a\u62df\u4ef6\u7269\u6599\u4e0d\u53ef\u8bbe\u4e3a\u9636\u68af\u7528\u91cf\u3002", (String)"ReplacePlanEdit_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            this.getPageCache().put("isIgnoreChangeListener", "true");
            entry.set(KEY_REPQTYTYPE, oldObj);
            this.getPageCache().put("isIgnoreChangeListener", "false");
            return;
        }
    }

    private BigDecimal getWastagerate(DynamicObject materialMft) {
        QFilter[] filters;
        DynamicObject materialplanDO;
        BigDecimal wastagerate = null;
        if (materialMft != null && (materialplanDO = MaterialPlanQueryHelper.getSingleDataCacheByQFilter((QFilter[])(filters = new QFilter[]{new QFilter("masterid", "=", materialMft.getDynamicObject("masterid").getPkValue()), BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_materialplan", (Long)((Long)materialMft.getDynamicObject("createorg").getPkValue()))}))) != null && materialplanDO.getBigDecimal("wastagerate") != null) {
            wastagerate = materialplanDO.getBigDecimal("wastagerate");
        }
        if (wastagerate == null) {
            wastagerate = BigDecimal.ZERO;
        }
        return wastagerate;
    }
}

