/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.bombasedata;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.bom.ReplacePlanBusiness;
import kd.bd.mpdm.common.bombasedata.ReplaceUpdateBomUtils;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.formplugin.bombasedata.ReplacePlanUpdateBomRunner;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;

public class ReplacePlanListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(ReplacePlanListPlugin.class);
    public static final String OPERATION_REPCONFIG = "repconfig";
    public static final String OPERATION_ADDBOMDATE = "addbomdata";
    public static final String OPERATION_UPDATEBOMDATA = "updatebomdata";
    public static final String OPERATION_REPLACEUPDATELOG = "replaceupdatelog";
    private static final String BILLLISTAP = "billlistap";
    private static final String LOCKENTITYNAME = "mpdm_replaceplan";
    private String LOCKID = null;

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            protected boolean isOnlyPK4SelectedAllRows() {
                return true;
            }
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        AbstractOperate operate = (AbstractOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if (OPERATION_REPCONFIG.equals(operateKey)) {
            this.showConfigSetForm(1742916443785135104L);
        } else if (OPERATION_ADDBOMDATE.equals(operateKey) || OPERATION_UPDATEBOMDATA.equals(operateKey)) {
            boolean isListPage = this.isListPage();
            Long bizOrgId = this.getBizOrgId(isListPage);
            Object[] pkIds = this.getSelectIdList(isListPage);
            if (!this.checkSelectDataSize(pkIds)) {
                e.setCancel(true);
                return;
            }
            Long pkId = (Long)pkIds[0];
            if (!this.checkReplacePlanData(pkId)) {
                e.setCancel(true);
                return;
            }
            Set<Long> bomEntryIdSet = this.getPPBomDataEntryIdSet(pkId, OPERATION_ADDBOMDATE.equals(operateKey), bizOrgId);
            if (bomEntryIdSet == null || bomEntryIdSet.isEmpty()) {
                DynamicObject replacePlan = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)LOCKENTITYNAME, (String)"id,number");
                String orgName = this.getOrgName(bizOrgId);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%1$s\u201d\u672a\u5728\u4e1a\u52a1\u7ec4\u7ec7\u201c%2$s\u201d\u4e0b\u627e\u5230\u5339\u914d\u7684BOM\u6570\u636e\u3002", (String)"ReplacePlanListPlugin_11", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), replacePlan.getString("number"), orgName));
                e.setCancel(true);
                return;
            }
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pdm_mftbomlist_f7", (boolean)true);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("entry.id", "in", bomEntryIdSet));
            listShowParameter.setSelectedEntity("entry");
            listShowParameter.setCustomParam("ismergerows", (Object)false);
            listShowParameter.setCaption(this.getBomF7Caption(operateKey));
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else if (OPERATION_REPLACEUPDATELOG.equals(operateKey)) {
            Object[] pkIds = this.getSelectIdList(this.isListPage());
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("mpdm_replaceplan_log");
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ListFilterParameter listFilter = new ListFilterParameter();
            QFilter qFilter = null;
            if (pkIds != null && pkIds.length > 0 && pkIds[0] != null && !pkIds[0].equals(0L)) {
                qFilter = new QFilter("entryentity.replaceplan", "in", (Object)pkIds);
            } else {
                Long bizOrgId = this.getBizOrgId(this.isListPage());
                qFilter = new QFilter("org", "=", (Object)bizOrgId);
            }
            listFilter.setFilter(qFilter);
            listFilter.setOrderBy("createtime desc , entryentity.replaceplan,entryentity.seq");
            listShowParameter.setListFilterParameter(listFilter);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private Long getBizOrgId(boolean isListPage) {
        if (isListPage) {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String createOrg = pageCache.get("createOrg");
            return Long.parseLong(createOrg);
        }
        DynamicObject useOrg = (DynamicObject)this.getModel().getValue("useorg");
        if (useOrg != null) {
            return useOrg.getLong("id");
        }
        useOrg = (DynamicObject)this.getModel().getValue("createorg");
        return useOrg.getLong("id");
    }

    private String getBomF7Caption(String operateKey) {
        if (OPERATION_ADDBOMDATE.equals(operateKey)) {
            return ResManager.loadKDString((String)"\u6279\u91cf\u65b0\u589e\u66ff\u4ee3", (String)"ReplacePlanListPlugin_18", (String)"bd-mpdm-formplugin", (Object[])new Object[0]);
        }
        if (OPERATION_UPDATEBOMDATA.equals(operateKey)) {
            return ResManager.loadKDString((String)"\u6279\u91cf\u66f4\u65b0\u66ff\u4ee3", (String)"ReplacePlanListPlugin_19", (String)"bd-mpdm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event == null) {
            return;
        }
        String actID = event.getActionId();
        Object returnDataObj = event.getReturnData();
        ListSelectedRowCollection returnLSRC = returnDataObj instanceof ListSelectedRowCollection ? (ListSelectedRowCollection)returnDataObj : null;
        int returnLSRCSize = returnLSRC == null || returnLSRC.isEmpty() ? 0 : returnLSRC.size();
        if (StringUtils.isEmpty((String)actID) || returnDataObj == null) {
            return;
        }
        if ((OPERATION_ADDBOMDATE.equalsIgnoreCase(actID) || OPERATION_UPDATEBOMDATA.equalsIgnoreCase(actID)) && returnLSRCSize > 0) {
            HashSet<Long> bomEntryIdSelectSet = new HashSet<Long>(16);
            for (int index = 0; index < returnLSRCSize; ++index) {
                ListSelectedRow returnLSR = returnLSRC.get(index);
                if (returnLSR == null) continue;
                Object returnPKObj = returnLSR.getEntryPrimaryKeyValue();
                if (returnPKObj == null) {
                    String msg = ResManager.loadKDString((String)"\u8bf7\u5728\u5f39\u51fa\u7684BOM\u9009\u62e9F7\u754c\u9762\uff0c\u70b9\u51fb\u8868\u683c\u53f3\u4e0a\u89d2\u7684\u5de5\u5177\u680f\u4e2d\u7684\u201c\u663e\u793a\u5168\u90e8\u201d\uff0c\u518d\u91cd\u8bd5\u3002", (String)"ReplacePlanListPlugin_27", (String)"bd-mpdm-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(msg);
                    return;
                }
                Long returnPK = returnPKObj == null ? -1L : Long.parseLong(returnPKObj.toString());
                if (returnPK <= 0L) continue;
                bomEntryIdSelectSet.add(returnPK);
            }
            if (!this.validBomData(bomEntryIdSelectSet, actID)) {
                return;
            }
            Object[] pkIds = this.getSelectIdList(this.isListPage());
            Long pkId = (Long)pkIds[0];
            Long orgId = this.getBizOrgId(this.isListPage());
            if (!this.addDataMutex(pkId)) {
                return;
            }
            try {
                boolean execResult = this.execUpdataOp(bomEntryIdSelectSet, pkId, orgId, actID);
                if (!execResult) {
                    this.release();
                }
            }
            catch (Exception exception) {
                logger.error((Throwable)exception);
                this.release();
                throw exception;
            }
        }
    }

    private boolean addDataMutex(Long pkId) {
        StringBuilder errMsg = new StringBuilder();
        this.LOCKID = String.valueOf(pkId);
        if (!MutexHelper.require((String)LOCKENTITYNAME, (Object)this.LOCKID, (String)"releasemutex", (boolean)true, (StringBuilder)errMsg)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u66ff\u4ee3\u65b9\u6848\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u6570\u636e\uff0c\u8bf7\u7a0d\u5019\u518d\u6267\u884c\u3002", (String)"ReplacePlanListPlugin_28", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean execUpdataOp(Set<Long> bomEntryIdSelectSet, Long replacePlanId, Long orgId, String opKey) {
        if (bomEntryIdSelectSet == null || bomEntryIdSelectSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u4efb\u4f55BOM\u5206\u5f55\u6570\u636e\u3002", (String)"ReplacePlanListPlugin_12", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Map<String, Set<Long>> bomentryIdMap = this.getMapBySelectIdSet(bomEntryIdSelectSet, opKey);
        if (bomentryIdMap == null || bomentryIdMap.isEmpty()) {
            return false;
        }
        ReplacePlanBusiness impl = new ReplacePlanBusiness();
        Long logId = impl.insertExecLogByOne(replacePlanId, bomentryIdMap, orgId, opKey);
        if (logId == null || logId.equals(0L)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u751f\u6210\u8fd0\u7b97\u65e5\u5fd7\u4fe1\u606f\u3002", (String)"ReplacePlanListPlugin_13", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        ThreadPools.executeOnceIncludeRequestContext((String)("MMC-ReplacePlanUpdateBom-logId-" + logId), (Runnable)new ReplacePlanUpdateBomRunner(RequestContext.get(), logId));
        this.showLogForm(logId);
        return true;
    }

    private void showLogForm(Long id) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("mpdm_replaceplan_log");
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setPkId((Object)id);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("id", (Object)id);
        this.getView().showForm((FormShowParameter)formShowParameter);
        ThreadPools.executeOnce((String)"MMC-ReplacePlanUpdateBom", () -> this.doRelease(id));
    }

    private void doRelease(Long id) {
        String status = this.getCalcStatus(id);
        int i = 0;
        while ("B".equals(status)) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            status = this.getCalcStatus(id);
            if (++i <= 10000) continue;
        }
        this.release();
    }

    private void release() {
        MutexHelper.release((String)LOCKENTITYNAME, (String)"releasemutex", (String)String.valueOf(this.LOCKID));
    }

    private String getCalcStatus(Long id) {
        String status = "";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"mpdm_replaceplan_log", (String)"runstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (dynamicObject != null) {
            status = dynamicObject.getString("runstatus");
        }
        return status;
    }

    private Map<String, Set<Long>> getMapBySelectIdSet(Set<Long> bomEntryIdSelectSet, String opKey) {
        Map<String, Set<Long>> cacheBomEntryIdMap = this.getCacheBomEntryData();
        if (cacheBomEntryIdMap.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5339\u914d\u7684BOM\u5206\u5f55\u7f13\u5b58\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"ReplacePlanListPlugin_14", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return Collections.emptyMap();
        }
        HashMap<String, Set<Long>> selectMap = new HashMap<String, Set<Long>>(16);
        for (Long bomentryId : bomEntryIdSelectSet) {
            boolean isFind = false;
            for (Map.Entry<String, Set<Long>> groups : cacheBomEntryIdMap.entrySet()) {
                Set<Long> unionBomEntryIdSet;
                String replaceGroupNo = groups.getKey();
                Set<Long> bomEntryIdsObject = groups.getValue();
                if (bomEntryIdsObject == null) continue;
                Set<Object> bomEntryIdSet = new HashSet(16);
                bomEntryIdSet = bomEntryIdsObject instanceof ArrayList ? new HashSet(groups.getValue()) : groups.getValue();
                if (!bomEntryIdSet.contains(bomentryId)) continue;
                isFind = true;
                if (selectMap.containsKey(replaceGroupNo)) break;
                if (OPERATION_ADDBOMDATE.equalsIgnoreCase(opKey) && (unionBomEntryIdSet = this.getUnionSet(bomEntryIdSet, bomEntryIdSelectSet)).size() != bomEntryIdSet.size()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u6570\u636e\u65e0\u6cd5\u4e0e\u66ff\u4ee3\u65b9\u6848\u7684\u4e3b\u7269\u6599\u8fdb\u884c\u5339\u914d\uff08\u65b0\u589e\u66ff\u4ee3\u6a21\u5f0f\u4e0b\uff0cBOM\u5206\u5f55\u6240\u9009\u62e9\u7684\u7ec4\u4ef6\u4e0e\u66ff\u4ee3\u65b9\u6848\u7684\u4e3b\u7269\u6599\u5fc5\u987b\u5b8c\u5168\u4e00\u81f4\uff09\u3002", (String)"ReplacePlanListPlugin_20", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                    return Collections.emptyMap();
                }
                selectMap.put(replaceGroupNo, bomEntryIdSet);
                break;
            }
            if (isFind) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"BOM\u5206\u5f55ID\u201c%1$s\u201d\u672a\u627e\u5230\u5339\u914d\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"ReplacePlanListPlugin_15", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), bomentryId));
            return Collections.emptyMap();
        }
        return selectMap;
    }

    private Set<Long> getUnionSet(Set<Long> setA, Set<Long> setB) {
        HashSet<Long> resSet = new HashSet<Long>(16);
        resSet.addAll(setA);
        resSet.retainAll(setB);
        return resSet;
    }

    private Set<Long> getPPBomDataEntryIdSet(Long replacePlanId, boolean isAdd, Long bizOrgId) {
        ReplacePlanBusiness impl = new ReplacePlanBusiness();
        Map maps = impl.getEffectBomEntryIdSet(bizOrgId, replacePlanId, isAdd);
        if (maps == null || maps.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> allBomEntryIdSet = new HashSet<Long>(64);
        this.setCacheBomEntryData(maps);
        for (Map.Entry groups : maps.entrySet()) {
            Set bomEntryIdSet = (Set)groups.getValue();
            if (bomEntryIdSet == null || bomEntryIdSet.isEmpty()) continue;
            allBomEntryIdSet.addAll(bomEntryIdSet);
        }
        return allBomEntryIdSet;
    }

    private void setCacheBomEntryData(Map<String, Set<Long>> maps) {
        String cacheJsonString = JSON.toJSONString(maps);
        this.getPageCache().put("bomEntryIdMaps", cacheJsonString);
    }

    private Map<String, Set<Long>> getCacheBomEntryData() {
        String cacheJsonString = this.getPageCache().get("bomEntryIdMaps");
        if (StringUtils.isEmpty((String)cacheJsonString)) {
            return Collections.emptyMap();
        }
        return (Map)SerializationUtils.fromJsonString((String)cacheJsonString, Map.class);
    }

    private String getReplacePlanSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",").append("number");
        sb.append(",").append("enable");
        sb.append(",").append("status");
        sb.append(",").append("createorg");
        sb.append(",").append("mainmaterentry").append(".").append("material");
        sb.append(",").append("mainmaterentry").append(".").append("isreplace");
        sb.append(",").append("repmaterentry").append(".").append("repmaterial");
        sb.append(",").append("repmaterentry").append(".").append("repauxpty");
        sb.append(",").append("repmaterentry").append(".").append("isrep");
        return sb.toString();
    }

    private boolean checkReplacePlanData(Long id) {
        int i;
        DynamicObject replacePlan = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)LOCKENTITYNAME, (String)this.getReplacePlanSelectProperties());
        if (!"1".equals(replacePlan.getString("enable"))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%1$s\u201d\u4e0d\u53ef\u7528\u3002", (String)"ReplacePlanListPlugin_03", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), replacePlan.getString("number")));
            return false;
        }
        if (!"C".equals(replacePlan.getString("status"))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%1$s\u201d\u672a\u901a\u8fc7\u5ba1\u6838\uff0c\u65e0\u6cd5\u4f7f\u7528\u3002", (String)"ReplacePlanListPlugin_04", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), replacePlan.getString("number")));
            return false;
        }
        DynamicObjectCollection coll1 = replacePlan.getDynamicObjectCollection("mainmaterentry");
        if (coll1 == null || coll1.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%1$s\u201d\u672a\u8bbe\u7f6e\u4e3b\u7269\u6599\u5206\u5f55\u6570\u636e\u3002", (String)"ReplacePlanListPlugin_05", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), replacePlan.getString("number")));
            return false;
        }
        DynamicObjectCollection coll2 = replacePlan.getDynamicObjectCollection("repmaterentry");
        if (coll2 == null || coll2.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%1$s\u201d\u672a\u8bbe\u7f6e\u66ff\u4ee3\u7269\u6599\u5206\u5f55\u6570\u636e\u3002", (String)"ReplacePlanListPlugin_06", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), replacePlan.getString("number")));
            return false;
        }
        boolean hasReplace = false;
        HashSet<Object> materialMftIdSet = new HashSet<Object>(16);
        for (i = 0; i < coll1.size(); ++i) {
            if (((DynamicObject)coll1.get(i)).getBoolean("isreplace")) {
                hasReplace = true;
            }
            materialMftIdSet.add(((DynamicObject)coll1.get(i)).getDynamicObject("material").getPkValue());
        }
        if (!hasReplace) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%1$s\u201d\u7684\u4e3b\u7269\u6599\u5206\u5f55\u4e2d\u672a\u52fe\u9009\u201c\u66ff\u4ee3\u4e3b\u6599\u201d\u3002", (String)"ReplacePlanListPlugin_07", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), replacePlan.getString("number")));
            return false;
        }
        hasReplace = false;
        for (i = 0; i < coll2.size(); ++i) {
            if (((DynamicObject)coll2.get(i)).getBoolean("isrep")) {
                hasReplace = true;
            }
            materialMftIdSet.add(((DynamicObject)coll2.get(i)).getDynamicObject("repmaterial").getPkValue());
        }
        if (!hasReplace) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%1$s\u201d\u7684\u66ff\u4ee3\u7269\u6599\u5206\u5f55\u4e2d\u672a\u52fe\u9009\u201c\u66ff\u4ee3\u4e3b\u6599\u201d\u3002", (String)"ReplacePlanListPlugin_08", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), replacePlan.getString("number")));
            return false;
        }
        return materialMftIdSet.isEmpty() || this.checkMaterialValidData(materialMftIdSet, replacePlan);
    }

    private boolean checkMaterialValidData(Set<Object> materialMftIdSet, DynamicObject replacePlan) {
        String sp = "id,status,enable,masterid.number,masterid.status,masterid.enable";
        Map mftMap = MaterialMftQueryHelper.getDataBySelectProperties(materialMftIdSet, (String)sp);
        for (Map.Entry mfts : mftMap.entrySet()) {
            DynamicObject mft = (DynamicObject)mfts.getValue();
            DynamicObject material = mft.getDynamicObject("masterid");
            if (!"C".equals(mft.getString("status")) || !"1".equals(mft.getString("enable"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%1$s\u201d\u7684\u7269\u6599\u201c%2$s\u201d\u5bf9\u5e94\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u4e0d\u53ef\u7528\u6216\u672a\u5ba1\u6838\u3002", (String)"ReplacePlanListPlugin_09", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), replacePlan.getString("number"), material.get("number")));
                return false;
            }
            if ("C".equals(material.getString("status")) && "1".equals(material.getString("enable"))) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%1$s\u201d\u4e2d\u7684\u7269\u6599\u201c%2$s\u201d\u4e0d\u53ef\u7528\u6216\u672a\u5ba1\u6838\u3002", (String)"ReplacePlanListPlugin_10", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), replacePlan.getString("number"), material.get("number")));
            return false;
        }
        return true;
    }

    private boolean checkSelectDataSize(Object[] pkIds) {
        if (pkIds == null || pkIds.length < 1 || pkIds[0] == null || pkIds[0].equals(0L)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u7ec4\u4ef6\u66ff\u4ee3\u5173\u7cfb\u6570\u636e\u3002", (String)"ReplacePlanListPlugin_01", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (pkIds != null && pkIds.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u53ef\u9009\u62e9\u4e00\u884c\u7ec4\u4ef6\u66ff\u4ee3\u5173\u7cfb\u6570\u636e\u3002", (String)"ReplacePlanListPlugin_02", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Object[] getSelectIdList(boolean isListPage) {
        if (isListPage) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            ListSelectedRowCollection selects = billList.getSelectedRows();
            if (selects == null || selects.isEmpty()) {
                return new Object[]{0L};
            }
            return selects.getPrimaryKeyValues();
        }
        Long id = (Long)this.getModel().getDataEntity().getPkValue();
        return new Object[]{id};
    }

    private void showConfigSetForm(Object pkId) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("mpdm_bomrepconfig");
        baseShowParameter.setPkId(pkId);
        baseShowParameter.setCustomParam("view", (Object)Boolean.TRUE);
        baseShowParameter.setShowTitle(true);
        baseShowParameter.setCaption(ResManager.loadKDString((String)"\u66ff\u4ee3\u53c2\u6570\u8bbe\u7f6e", (String)"ReplacePlanListPlugin_29", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        OperationStatus operationStatus = OperationStatus.EDIT;
        baseShowParameter.setStatus(operationStatus);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("1080px");
        css.setHeight("400px");
        baseShowParameter.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private boolean isListPage() {
        return !LOCKENTITYNAME.equals(this.getModel().getDataEntityType().getName());
    }

    private String getOrgName(Long bizOrgId) {
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)bizOrgId, (String)"bos_org", (String)"name");
        return org.getString("name");
    }

    private Map<Long, String> getMaterialNumberMap(Set<Long> materialIdSet) {
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_material", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", materialIdSet)});
        HashMap<Long, String> materialMap = new HashMap<Long, String>(16);
        for (DynamicObject bom : coll) {
            materialMap.put(bom.getLong("id"), bom.getString("number"));
        }
        return materialMap;
    }

    private boolean validBomData(Set<Long> bomentryIdSet, String opKey) {
        HashSet<Long> bomIdSet = new HashSet<Long>(16);
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        HashMap<Long, DynamicObject> bomentryMap = new HashMap<Long, DynamicObject>(16);
        DynamicObjectCollection coll = ReplaceUpdateBomUtils.queryBomEntryById(bomentryIdSet);
        for (DynamicObject bomentry : coll) {
            Long bomentryId = bomentry.getLong("entryid");
            Long bomId = bomentry.getLong("bomid");
            bomIdSet.add(bomId);
            bomentryMap.put(bomentryId, bomentry);
            Long l = bomentry.getLong("entrymaterialid");
            materialIdSet.add(l);
        }
        HashMap<Long, String> bomNumberMap = new HashMap<Long, String>(16);
        StringBuilder errorSb = new StringBuilder();
        Map bomMap = BusinessDataServiceHelper.loadFromCache((String)"pdm_mftbom", (String)"number,enable,id", (QFilter[])new QFilter[]{new QFilter("id", "in", bomIdSet)});
        for (Map.Entry entry : bomMap.entrySet()) {
            DynamicObject bom = (DynamicObject)entry.getValue();
            bomNumberMap.put(bom.getLong("id"), bom.getString("number"));
            if ("1".equals(bom.getString("enable"))) continue;
            errorSb.append(String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u66ff\u4ee3\u64cd\u4f5c\u3002\u201c%2$s\u201d", (String)"ReplacePlanListPlugin_21", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), bom.getString("number"), "\r\n"));
        }
        Date currentDate = new Date();
        Map<Long, String> map = this.getMaterialNumberMap(materialIdSet);
        for (Long bomentryId : bomentryIdSet) {
            DynamicObject bomentry = (DynamicObject)bomentryMap.get(bomentryId);
            if (bomentry == null) {
                errorSb.append(String.format(ResManager.loadKDString((String)"BOM\u5206\u5f55ID\u201c%1$s\u201d\u5df2\u4e0d\u5b58\u5728\u4e8e\u7cfb\u7edf\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002\u8bf7\u9000\u51fa\u91cd\u8bd5\u3002%2$s", (String)"ReplacePlanListPlugin_22", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), bomentryId, "\r\n"));
                continue;
            }
            String bomNumber = (String)bomNumberMap.get(bomentry.getLong("bomid"));
            int seq = bomentry.getInt("entryseq");
            Date entryinvaliddate = bomentry.getDate("entryinvaliddate");
            boolean isJumpLevel = bomentry.getBoolean("entryisjumplevel");
            Long replacePlanId = bomentry.getLong("entryreplaceplan");
            Long materialId = bomentry.getLong("entrymaterialid");
            String materialNumber = map.get(materialId);
            if (isJumpLevel) {
                errorSb.append(String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u7684\u7b2c\u201c%2$s\u201d\u884c\u5206\u5f55\u7ec4\u4ef6\u201c%3$s\u201d\u4e3a\u8df3\u5c42\u4ef6\uff0c\u4e0d\u5141\u8bb8\u66ff\u4ee3\u64cd\u4f5c\u3002%4$s", (String)"ReplacePlanListPlugin_23", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), bomNumber, seq, materialNumber, "\r\n"));
                continue;
            }
            if (OPERATION_ADDBOMDATE.equalsIgnoreCase(opKey) && entryinvaliddate.compareTo(currentDate) < 0) {
                errorSb.append(String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u7684\u7b2c\u201c%2$s\u201d\u884c\u5206\u5f55\u7ec4\u4ef6\u201c%3$s\u201d\u5931\u6548\u65e5\u671f\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u65e0\u6cd5\u6279\u91cf\u65b0\u589e\u66ff\u4ee3\u3002%4$s", (String)"ReplacePlanListPlugin_24", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), bomNumber, seq, materialNumber, "\r\n"));
                continue;
            }
            if (replacePlanId == null || replacePlanId.equals(0L)) {
                if (!OPERATION_UPDATEBOMDATA.equalsIgnoreCase(opKey)) continue;
                errorSb.append(String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u7684\u7b2c\u201c%2$s\u201d\u884c\u5206\u5f55\u7ec4\u4ef6\u201c%3$s\u201d\u6ca1\u6709\u53ef\u66ff\u4ee3\u65b9\u6848\uff0c\u65e0\u6cd5\u8fdb\u884c\u6279\u91cf\u66f4\u65b0\u66ff\u4ee3\u64cd\u4f5c\u3002%4$s", (String)"ReplacePlanListPlugin_25", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), bomNumber, seq, materialNumber, "\r\n"));
                continue;
            }
            if (!OPERATION_ADDBOMDATE.equalsIgnoreCase(opKey)) continue;
            errorSb.append(String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u7684\u7b2c\u201c%2$s\u201d\u884c\u5206\u5f55\u7ec4\u4ef6\u201c%3$s\u201d\u5df2\u5b58\u5728\u66ff\u4ee3\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u6279\u91cf\u65b0\u589e\u66ff\u4ee3\u3002%4$s", (String)"ReplacePlanListPlugin_26", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), bomNumber, seq, materialNumber, "\r\n"));
        }
        if (errorSb.length() > 1) {
            this.getView().showTipNotification(errorSb.toString());
            return false;
        }
        return true;
    }
}

