/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.bombasedata;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ReplacePlanLogEditPlugin
extends AbstractBillPlugIn
implements ProgresssListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(ReplacePlanLogEditPlugin.class);
    private static final String KEY_ORG = "org";
    private static final String PROGRESS_BARAP = "progressbarap";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String CREATEORG = "org";
    private static final String CALCULATE_STATUS = "runstatus";
    private static final String CALCULATE_PRO = "calculatepro";
    private static final String LABELAP = "labelap";
    private static final String IMAGE_FAIL = "image_fail";
    private static final String IMAGE_SUCCESS = "image_success";
    private static final BigDecimal ONE00 = new BigDecimal("100");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESS_BARAP);
        if (progressBar != null) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        if (e == null || e.getFieldName() == null) {
            return;
        }
        String fieldName = e.getFieldName();
        if ("bomnumber".equals(fieldName)) {
            int rowIndex = e.getRowIndex();
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(ENTRY_ENTITY, rowIndex);
            if (dynamicObject == null) {
                return;
            }
            Long bomId = dynamicObject.getLong("bomid");
            if (bomId == null || bomId.equals(0L)) {
                return;
            }
            this.openBillInfoShowPage("pdm_mftbom", bomId);
        }
    }

    public void openBillInfoShowPage(String billNumber, Long billId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(billNumber);
        showParameter.setPkId((Object)billId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterBindData(EventObject e) {
        ProgressBar progressBar;
        super.afterBindData(e);
        if (!this.getIsRefreshData() && (progressBar = (ProgressBar)this.getControl(PROGRESS_BARAP)) != null) {
            String calculatestatus = (String)this.getModel().getValue(CALCULATE_STATUS);
            if (StringUtils.equalsIgnoreCase((CharSequence)calculatestatus, (CharSequence)"B")) {
                progressBar.start();
            }
            BigDecimal calculatepro = (BigDecimal)this.getModel().getValue(CALCULATE_PRO);
            progressBar.setPercent(calculatepro.intValue());
            this.setProgressBarColorAndStatus(calculatestatus);
        }
    }

    public int updateData(IFormView fv) {
        ProgressBar progressBar = (ProgressBar)fv.getControl(PROGRESS_BARAP);
        this.refreshData();
        String status = (String)fv.getModel().getValue(CALCULATE_STATUS);
        BigDecimal percent = (BigDecimal)fv.getModel().getValue(CALCULATE_PRO);
        int newPercent = percent.intValue();
        progressBar.setPercent(newPercent);
        if (!"A".equalsIgnoreCase(status) && !"B".equalsIgnoreCase(status)) {
            this.endCalculat(progressBar);
        } else {
            this.setProgressBarColorAndStatus((String)this.getModel().getValue(CALCULATE_STATUS));
        }
        return newPercent;
    }

    private void endCalculat(ProgressBar progressBar) {
        progressBar.stop();
        this.setProgressBarColorAndStatus((String)this.getModel().getValue(CALCULATE_STATUS));
    }

    private boolean isRunningStatus() {
        String status = (String)this.getModel().getValue(CALCULATE_STATUS);
        return "B".equals(status);
    }

    private void setProgressBarColorAndStatus(String cStatus) {
        String color = "#1BA854";
        Label lab = (Label)this.getControl(LABELAP);
        if (StringUtils.equalsIgnoreCase((CharSequence)cStatus, (CharSequence)"A") || StringUtils.equalsIgnoreCase((CharSequence)cStatus, (CharSequence)"B")) {
            if (StringUtils.equalsIgnoreCase((CharSequence)cStatus, (CharSequence)"A")) {
                lab.setText(ResManager.loadKDString((String)"\u672a\u5f00\u59cb", (String)"ReplacePlanLogEditPlugin_01", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            } else {
                lab.setText(ResManager.loadKDString((String)"\u8fd0\u884c\u4e2d...", (String)"ReplacePlanLogEditPlugin_02", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{IMAGE_FAIL, IMAGE_SUCCESS});
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)cStatus, (CharSequence)"D")) {
            color = "rgba(255,0,0,0.7)";
            lab.setText(ResManager.loadKDString((String)"\u8fd0\u884c\u5931\u8d25", (String)"ReplacePlanLogEditPlugin_03", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{IMAGE_SUCCESS});
            this.getView().setVisible(Boolean.TRUE, new String[]{IMAGE_FAIL});
        } else {
            lab.setText(ResManager.loadKDString((String)"\u8fd0\u884c\u6210\u529f", (String)"ReplacePlanLogEditPlugin_04", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{IMAGE_FAIL});
            this.getView().setVisible(Boolean.TRUE, new String[]{IMAGE_SUCCESS});
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("fc", color);
        this.getView().updateControlMetadata(PROGRESS_BARAP, fieldMap);
    }

    public void onProgress(ProgressEvent progressEvent) {
        progressEvent.setProgress(this.updateData(this.getView()));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.isRunningStatus()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8fd0\u7b97\u8fdb\u884c\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u3002", (String)"ReplacePlanLogEditPlugin_05", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
        e.setCheckDataChange(false);
    }

    private void refreshData() {
        this.setIsRefreshData("true");
        String selectFields = "runstatus,calculatepro,entryentity.id entryid,entryentity.begindate begindate,entryentity.enddate enddate,entryentity.exectimelong exectimelong,entryentity.entryexecstatus entryexecstatus,entryentity.detiallog detiallog,entryentity.detiallog_tag detiallog_tag";
        Object id = this.getModel().getValue("id");
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"mpdm_replaceplan_log", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
        int size = coll.size();
        String runstatus = "";
        BigDecimal calculatepro = BigDecimal.ZERO;
        HashMap<Long, DynamicObject> cacheMap = new HashMap<Long, DynamicObject>(16);
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = (DynamicObject)coll.get(i);
            Long entryId = entry.getLong("entryid");
            runstatus = entry.getString(CALCULATE_STATUS);
            calculatepro = entry.getBigDecimal(CALCULATE_PRO);
            cacheMap.put(entryId, entry);
        }
        this.getModel().setValue(CALCULATE_STATUS, (Object)runstatus);
        if (StringUtils.equalsIgnoreCase((CharSequence)runstatus, (CharSequence)"B") && ONE00.compareTo(calculatepro) <= 0) {
            calculatepro = new BigDecimal("99");
        }
        this.getModel().setValue(CALCULATE_PRO, (Object)calculatepro);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            Long entryId = (Long)entry.getPkValue();
            DynamicObject newEntry = (DynamicObject)cacheMap.get(entryId);
            if (newEntry == null) continue;
            entry.set("begindate", newEntry.get("begindate"));
            entry.set("enddate", newEntry.get("enddate"));
            entry.set("detiallog", newEntry.get("detiallog"));
            entry.set("detiallog_tag", newEntry.get("detiallog_tag"));
            entry.set("entryexecstatus", newEntry.get("entryexecstatus"));
            entry.set("exectimelong", newEntry.get("exectimelong"));
        }
        this.getView().updateView(ENTRY_ENTITY);
        this.getView().updateView(CALCULATE_STATUS);
        this.getView().updateView(CALCULATE_PRO);
        this.setIsRefreshData("false");
    }

    private void setIsRefreshData(String value) {
        this.getPageCache().put("isRefreshData", value);
    }

    private boolean getIsRefreshData() {
        String data = this.getPageCache().get("isRefreshData");
        return data != null && "true".equalsIgnoreCase(data);
    }
}

