/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.calendar;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import kd.bd.mpdm.formplugin.calendar.CalendarSettingUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.portal.util.SerializationUtils;

public class CalendarSetEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String CACHEKEY_CALCENDARID = "cachecalendarid";
    private static final String CACHEKEY_CALCENDARDTENTRY = "cachecalendardateentry";
    private static final String CACHEKEY_CHILDPAGEID = "cachechildPageId";
    private static final String CACHEKEY_LASTPAGEDATA = "cachelastpagedata";

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
    }

    public void registerListener(EventObject e) {
        BasedataEdit calendar;
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
        if ((calendar = (BasedataEdit)this.getControl("calendar")) != null) {
            calendar.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            calendar.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int rowCount;
        int selectRowIndex;
        super.afterAddRow(e);
        EntryProp prop = e.getEntryProp();
        String key = prop.getName();
        if ("entryentity".equals(key) && (selectRowIndex = (rowCount = this.getModel().getEntryRowCount("entryentity")) - 1) >= 0) {
            this.updateParentPage(selectRowIndex, this.getCalendar(selectRowIndex), true);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        EntryProp prop = e.getEntryProp();
        String key = prop.getName();
        if ("entryentity".equals(key) || "dateentry".equals(key)) {
            int selectRowIndex = this.getSelectRowIndex();
            boolean isCache = "entryentity".equals(key);
            this.updateParentPage(selectRowIndex, this.getCalendar(selectRowIndex), isCache);
        }
    }

    public int getSelectRowIndex() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            return selectRows[0];
        }
        return -1;
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        int selectRowIndex;
        BasedataEdit calendarData;
        if (e.getSource() instanceof BasedataEdit && (calendarData = (BasedataEdit)e.getSource()).getKey().equals("calendar") && (selectRowIndex = this.getSelectRowIndex()) >= 0) {
            this.updateParentPage(selectRowIndex, this.getCalendar(selectRowIndex), true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String nodeId;
        super.afterCreateNewData(e);
        if (!(this.getView().getFormShowParameter() == null || this.getView().getFormShowParameter().getCustomParam("nodeId") == null || (nodeId = this.getView().getFormShowParameter().getCustomParam("nodeId").toString()) == null || "".equals(nodeId) || "0".equals(nodeId) || "-1".equals(nodeId))) {
            String type = (String)this.getView().getFormShowParameter().getCustomParam("nodetype");
            this.getModel().setValue("objecttype", (Object)type);
            Long id = Long.parseLong(nodeId);
            if ("B".equals(type)) {
                DynamicObject workShop = CalendarSettingUtils.getWorkShop(id);
                this.getModel().setValue("workshop", (Object)workShop);
                if (workShop != null && workShop.getDynamicObject("createorg") != null) {
                    this.getModel().setValue("org", (Object)CalendarSettingUtils.getOrg((Long)workShop.getDynamicObject("createorg").getPkValue()));
                }
            } else if ("C".equals(type)) {
                DynamicObject workCenter = CalendarSettingUtils.getWorkCenter(id);
                this.getModel().setValue("workcenter", (Object)workCenter);
                if (workCenter != null && workCenter.getDynamicObject("createorg") != null) {
                    this.getModel().setValue("org", (Object)CalendarSettingUtils.getOrg((Long)workCenter.getDynamicObject("createorg").getPkValue()));
                }
            } else {
                this.getModel().setValue("org", (Object)CalendarSettingUtils.getOrg(id));
            }
            this.getModel().getDataEntity().getDataEntityState().setBizChanged(this.getModel().getDataEntityType().getProperty("objecttype").getOrdinal(), false);
            this.getModel().getDataEntity().getDataEntityState().setBizChanged(this.getModel().getDataEntityType().getProperty("workshop").getOrdinal(), false);
            this.getModel().getDataEntity().getDataEntityState().setBizChanged(this.getModel().getDataEntityType().getProperty("workcenter").getOrdinal(), false);
            this.getModel().getDataEntity().getDataEntityState().setBizChanged(this.getModel().getDataEntityType().getProperty("org").getOrdinal(), false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String nodeType = (String)this.getView().getFormShowParameter().getCustomParam("nodetype");
        if (nodeType != null && !"".equals(nodeType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"titleapanel"});
            String pageId = this.getView().getPageId();
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            if (parentView != null) {
                parentView.getPageCache().put(CACHEKEY_CHILDPAGEID, pageId);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (this.getPageCache().get("isIgnoreChangeListener") == "true") {
            return;
        }
        String proName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length <= 0) {
            return;
        }
        Object oldValue = changeSet[0].getOldValue();
        Object newValue = changeSet[0].getNewValue();
        int rowIndex = changeSet[0].getRowIndex();
        if (Objects.equals(oldValue, newValue)) {
            return;
        }
        if ("iseffectplan".equals(proName) || "iseffectproduct".equals(proName)) {
            this.clearValueByEffect((Boolean)newValue, rowIndex, proName);
        }
        if ("calendar".equals(proName)) {
            DynamicObject dynamicObject = (DynamicObject)newValue;
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
    }

    public void clearValueByEffect(boolean newData, int rowIndex, String fieldNumber) {
        if (newData && rowIndex >= 0) {
            DynamicObjectCollection coll = this.getModel().getEntryEntity("entryentity");
            this.getPageCache().put("isIgnoreChangeListener", "true");
            this.getModel().beginInit();
            HashSet<Integer> upRowSet = new HashSet<Integer>(16);
            for (int i = 0; i < coll.size(); ++i) {
                if (rowIndex == i || !((Boolean)this.getModel().getValue(fieldNumber, i)).booleanValue()) continue;
                this.getModel().setValue(fieldNumber, (Object)false, i);
                upRowSet.add(i);
            }
            this.getModel().endInit();
            if (!upRowSet.isEmpty()) {
                Iterator iterator = upRowSet.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    this.getView().updateView(fieldNumber, i);
                }
            }
            this.getPageCache().put("isIgnoreChangeListener", "false");
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)entryGrid.getKey())) {
            int rowIndex = evt.getRow();
            if (rowIndex < 0) {
                return;
            }
            DynamicObject calendar = this.getCalendar(rowIndex);
            this.updateParentPage(rowIndex, calendar, true);
        }
    }

    public DynamicObject getCalendar(int rowIndex) {
        return rowIndex < 0 ? null : (DynamicObject)this.getModel().getValue("calendar", rowIndex);
    }

    public void updateParentPage(int rowIndex, DynamicObject calendar, boolean byCache) {
        String cacheKeys = rowIndex + "_" + (calendar == null ? "0" : String.valueOf(calendar.getPkValue()));
        if (byCache && cacheKeys.equals(this.getLastUpdateParentData())) {
            return;
        }
        IFormView parentView = this.getParentView();
        if (parentView != null) {
            this.setLastUpdateParentData(cacheKeys);
            String parentCalendarId = this.getParentViewCacheCalendarId(parentView);
            if (byCache && this.isSameCalendar(calendar, parentCalendarId)) {
                return;
            }
            Map<String, String> dateMap = this.getDtEntryDateMap(CalendarSettingUtils.getDynamicObjectId(calendar));
            String dtListStr = SerializationUtils.toJsonString(dateMap);
            this.setParentCache(parentView, CACHEKEY_CALCENDARID, String.valueOf(CalendarSettingUtils.getDynamicObjectId(calendar)));
            this.setParentCache(parentView, CACHEKEY_CALCENDARDTENTRY, dtListStr);
            parentView.invokeOperation("updateworkcalendarview");
            this.getView().sendFormAction(parentView);
        }
    }

    private String getLastUpdateParentData() {
        String data = this.getView().getPageCache().get(CACHEKEY_LASTPAGEDATA);
        return data == null ? "" : data;
    }

    private void setLastUpdateParentData(String data) {
        this.getView().getPageCache().put(CACHEKEY_LASTPAGEDATA, data);
    }

    private void setParentCache(IFormView parentView, String keys, String values) {
        parentView.getPageCache().put(keys, values);
    }

    private Map<String, String> getDtEntryDateMap(Long calendarId) {
        HashMap<String, String> dateMap = new HashMap<String, String>(64);
        if (calendarId == null || calendarId.equals(0L)) {
            return dateMap;
        }
        DynamicObjectCollection dtEntrys = this.getModel().getEntryEntity("dateentry");
        if (dtEntrys == null || dtEntrys.isEmpty()) {
            return dateMap;
        }
        SimpleDateFormat sdfFormat = new SimpleDateFormat("yyy-MM-dd");
        for (int i = 0; i < dtEntrys.size(); ++i) {
            Date workDate = (Date)this.getModel().getValue("workdate", i);
            String datetype = (String)this.getModel().getValue("datetype", i);
            if (workDate == null) continue;
            dateMap.put(sdfFormat.format(workDate), datetype);
        }
        return dateMap;
    }

    private boolean isSameCalendar(DynamicObject calendar, String parentCalendarId) {
        boolean isNullStr = kd.bos.util.StringUtils.isEmpty((String)parentCalendarId);
        if (calendar == null && isNullStr) {
            return true;
        }
        return calendar != null && !isNullStr && ((Long)calendar.getPkValue()).equals(Long.parseLong(parentCalendarId));
    }

    public IFormView getParentView() {
        return this.getView().getParentView();
    }

    public String getParentViewCacheCalendarId(IFormView parentView) {
        return parentView.getPageCache().get(CACHEKEY_CALCENDARID);
    }
}

