/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.calendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.business.calendar.SyncOrgDataToTreeBusiness;
import kd.bd.mpdm.common.bomcache.BomUtils;
import kd.bd.mpdm.common.query.helper.OrgQueryHelper;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bd.mpdm.formplugin.calendar.CalendarSettingUtils;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.WorkCalendar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class CalendarSettingFromPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
TreeNodeClickListener {
    private static final String KEY_TREEVIEW = "treeview";
    private static final String KEY_BAR = "toolbarap";
    private static final String KEY_SEARCH = "searchap";
    private static final String APPPARAM = "bd-mpdm-formplugin";
    private static final String CACHEKEY_ROOTNODE = "rootnode";
    private static final int MAX_LEVEL = 50;
    private static final String CACHEKEY_CALCENDARID = "cachecalendarid";
    private static final String CACHEKEY_CURRENTNODEID = "cachecurrentnodeid";
    private static final String CACHEKEY_CALCENDARDTENTRY = "cachecalendardateentry";
    private static final String CACHEKEY_CHILDPAGEID = "cachechildPageId";
    private static final String OP_UPDATEWORKCALENDARVIEW = "updateworkcalendarview";
    private static final String OP_REFRESHDATA = "refreshdata";
    private static final String OP_SAVEDATA = "savedata";
    private static final String OP_NEWORGDATA = "neworgdata";
    private static final String OP_SYNCORGDATA = "syncorgdata";
    private static final String OP_DELETEORGDATA = "deleteorgdata";
    private static final Log log = LogFactory.getLog(CalendarSettingFromPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_BAR});
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{"setdefoultworkcalendar", "setworkcalendar", "preyear", "nextyear"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadFirstOrgTreeData();
        this.initTree();
        this.setCurYear(CalendarSettingUtils.getCurrentYear());
        this.showChildPage("A-1", false, true);
        this.getView().setEnable(Boolean.FALSE, new String[]{OP_SAVEDATA});
    }

    public void loadFirstOrgTreeData() {
        boolean isExistsData = QueryServiceHelper.exists((String)"mpdm_org_workcenter_tree", (QFilter[])new QFilter[]{new QFilter("id", ">", (Object)0L)});
        if (!isExistsData) {
            this.syncOrgTreeData();
        }
    }

    private WorkCalendar getWorkCalendar() {
        return (WorkCalendar)this.getView().getControl("workcalendarap");
    }

    private TreeView getTreeView() {
        return (TreeView)this.getControl(KEY_TREEVIEW);
    }

    private void buildNullRootNode() {
        TreeView treeView = this.getTreeView();
        TreeNode rootNode = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"CalendarSettingFromPlugin_01", (String)APPPARAM, (Object[])new Object[0]));
        treeView.setRootVisible(true);
        rootNode.setIsOpened(false);
        rootNode.setChildren(new ArrayList());
        treeView.addNode(rootNode);
    }

    private DynamicObject getLastParentOrg(Map<Long, DynamicObject> orgMaps, DynamicObject orgData) {
        Long parentId = orgData.getLong("parent");
        DynamicObject parentOrgData = orgMaps.get(parentId);
        if ("A".equals(orgData.getString("type")) && parentOrgData == null) {
            long currentParentId = parentId;
            while (currentParentId > 0L && parentOrgData == null) {
                currentParentId = SyncOrgDataToTreeBusiness.getParentOrgId((Long)currentParentId);
                parentOrgData = orgMaps.get(currentParentId);
            }
        }
        return parentOrgData;
    }

    private void initTree() {
        this.setRootNode(null);
        TreeView treeView = this.getTreeView();
        treeView.setMulti(false);
        DynamicObjectCollection orgDatas = CalendarSettingUtils.getOrgDatas(this.getView().getFormShowParameter().getAppId());
        int size = orgDatas.size();
        if (size == 0) {
            this.buildNullRootNode();
            return;
        }
        Map<Long, DynamicObject> orgMaps = CalendarSettingUtils.buildKeyMap(orgDatas);
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(size);
        HashMap<String, TreeNode> cacheNodeMap = new HashMap<String, TreeNode>(128);
        TreeNode rootNode = null;
        for (DynamicObject orgData : orgDatas) {
            String type;
            String name = orgData.getString("name");
            String rootId = CalendarSettingUtils.getIdKeysByOrgData(orgData);
            DynamicObject parentOrgData = this.getLastParentOrg(orgMaps, orgData);
            String parentRootId = CalendarSettingUtils.getIdKeysByOrgData(parentOrgData);
            TreeNode node = new TreeNode(parentRootId, rootId, name);
            cacheNodeMap.put(rootId, node);
            TreeNode parentNode = (TreeNode)cacheNodeMap.get(parentRootId);
            if (parentNode != null) {
                ArrayList<TreeNode> childList = parentNode.getChildren();
                if (childList == null) {
                    childList = new ArrayList<TreeNode>(16);
                }
                childList.add(node);
                parentNode.setChildren(childList);
            }
            if ("B".equals(type = orgData.getString("type"))) {
                node.setColor("#1BA854");
            } else if ("C".equals(type)) {
                node.setColor("#FF991C");
            }
            nodes.add(node);
            if (!StringUtils.isEmpty((String)parentRootId)) continue;
            node.setIsOpened(true);
            rootNode = node;
        }
        if (rootNode != null) {
            this.setRootNode(rootNode);
        }
        treeView.setRootVisible(true);
        treeView.addNodes(nodes);
    }

    private void setRootNode(TreeNode treeNode) {
        String str = treeNode == null ? "" : SerializationUtils.toJsonString((Object)treeNode);
        this.getPageCache().put(CACHEKEY_ROOTNODE, str);
    }

    private TreeNode getRootNode() {
        String str = this.getPageCache().get(CACHEKEY_ROOTNODE);
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        return (TreeNode)SerializationUtils.fromJsonString((String)str, TreeNode.class);
    }

    private boolean chekHasSelectCalendar(Long id) {
        if (CalendarSettingUtils.isNullLong(id)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u5de5\u4f5c\u65e5\u5386\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"CalendarSettingFromPlugin_04", (String)APPPARAM, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean chekHasChildPageId() {
        if (CalendarSettingUtils.isBlank(this.getChildPageId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u65e5\u5386\u8bbe\u7f6e\u5b50\u9875\u9762\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"CalendarSettingFromPlugin_11", (String)APPPARAM, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String opKey = c.getKey();
        if (opKey.toLowerCase().startsWith("preyear") || opKey.toLowerCase().startsWith("nextyear")) {
            Object yearValue = this.getModel().getValue("year");
            if (CalendarSettingUtils.isDiagitObject(yearValue)) {
                int year = Integer.parseInt(yearValue.toString());
                Long calendarId = this.getCalendarId();
                if (!this.chekHasSelectCalendar(calendarId) || !this.chekHasChildPageId()) {
                    return;
                }
                int toyear = c.getKey().toLowerCase().startsWith("preyear") ? year - 1 : year + 1;
                DynamicObject calendar = CalendarSettingUtils.getCalendarData(calendarId, this.getWorkCalendarSelectProperties());
                if (CalendarSettingUtils.isSetCalendarAtYear(calendarId, toyear)) {
                    List<Map<String, String>> dateList = this.loadCalendarData(toyear, calendar);
                    this.setWorkCalendarData(calendarId, DateUtils.getYearFirstDate((int)toyear), DateUtils.getYearLastDate((int)toyear), (Long)calendar.getDynamicObject("createorg").getPkValue(), toyear, dateList);
                } else {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u65e5\u5386\u201c%1$s\u201d\u672a\u8bbe\u7f6e%2$s\u5e74\u7684\u5de5\u4f5c\u65e5\u5386\u3002", (String)"CalendarSettingFromPlugin_05", (String)APPPARAM, (Object[])new Object[0]), calendar.getString("name"), toyear));
                }
            }
        } else if (c.equals(this.getControl("workcalendarap"))) {
            Long calendarId = this.getCalendarId();
            if (!this.chekHasSelectCalendar(calendarId) || !this.chekHasChildPageId()) {
                return;
            }
            this.markWorkCalendar();
        }
    }

    private String getTreeNodeId() {
        TreeView treeView = this.getTreeView();
        TreeView.TreeState treeState = treeView.getTreeState();
        return treeState == null ? "" : treeState.getFocusNodeId();
    }

    private String getTreeNodeName() {
        TreeView treeView = this.getTreeView();
        TreeView.TreeState treeState = treeView.getTreeState();
        return treeState == null || treeState.getFocusNode() == null || treeState.getFocusNode().get("text") == null ? "" : treeState.getFocusNode().get("text").toString();
    }

    private boolean checkAddNodeData() {
        String nodeId = this.getTreeNodeId();
        if (StringUtils.isEmpty((String)nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u8282\u70b9\u3002", (String)"CalendarSettingFromPlugin_13", (String)APPPARAM, (Object[])new Object[0]));
            return false;
        }
        String nodeName = this.getTreeNodeName();
        String type = this.getNodeDataType(nodeId);
        if (!"A".equals(type)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bf9\u7c7b\u578b\u4e3a\u201c\u7ec4\u7ec7\u201d\u7684\u8282\u70b9\u8fdb\u884c\u65b0\u589e\u4e0b\u5c42\u7ec4\u7ec7\u8282\u70b9\u64cd\u4f5c\u3002", (String)"CalendarSettingFromPlugin_17", (String)APPPARAM, (Object[])new Object[0]));
            return false;
        }
        Long orgId = this.getNodeDataId(nodeId);
        DynamicObject orgTree = CalendarSettingUtils.getOrgAndWcTreeId(orgId, "A");
        if (orgTree == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u6811\u201c%1$s\u201d\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u9000\u51fa\u754c\u9762\u91cd\u65b0\u8fdb\u5165\u3002", (String)"CalendarSettingFromPlugin_19", (String)APPPARAM, (Object[])new Object[0]), nodeName));
            return false;
        }
        return true;
    }

    private boolean checkDeleteTreeNodeData() {
        String nodeId = this.getTreeNodeId();
        if (StringUtils.isEmpty((String)nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u7ec4\u7ec7\u8282\u70b9\u3002", (String)"CalendarSettingFromPlugin_23", (String)APPPARAM, (Object[])new Object[0]));
            return false;
        }
        String nodeName = this.getTreeNodeName();
        Long nodeDataId = this.getNodeDataId(nodeId);
        String type = this.getNodeDataType(nodeId);
        if (!("A".equals(type) || "B".equals(type) || "C".equals(type))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bf9\u7c7b\u578b\u4e3a\u201c\u7ec4\u7ec7\u3001\u8f66\u95f4\u3001\u5de5\u4f5c\u4e2d\u5fc3\u201d\u7684\u8282\u70b9\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\u3002", (String)"CalendarSettingFromPlugin_24", (String)APPPARAM, (Object[])new Object[0]));
            return false;
        }
        DynamicObject orgTree = CalendarSettingUtils.getOrgAndWcTreeId(nodeDataId, type);
        if (orgTree == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u6811\u201c%1$s\u201d\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u9000\u51fa\u754c\u9762\u91cd\u65b0\u8fdb\u5165\u3002", (String)"CalendarSettingFromPlugin_19", (String)APPPARAM, (Object[])new Object[0]), nodeName));
            return false;
        }
        if (orgTree.getBoolean("issyncdata")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bf9\u624b\u5de5\u65b0\u589e\u7684\u8282\u70b9\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\u3002", (String)"CalendarSettingFromPlugin_29", (String)APPPARAM, (Object[])new Object[0]));
            return false;
        }
        if (CalendarSettingUtils.checkHasNextNode(orgTree.getLong("id"))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u6811\u201c%1$s\u201d\u5b58\u5728\u4e0b\u7ea7\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CalendarSettingFromPlugin_21", (String)APPPARAM, (Object[])new Object[0]), nodeName));
            return false;
        }
        if (CalendarSettingUtils.checkHasSetData(nodeDataId, type)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u6811\u201c%1$s\u201d\u5df2\u7ecf\u521b\u5efa\u65e5\u5386\u4e2a\u6027\u5316\u8bbe\u7f6e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CalendarSettingFromPlugin_22", (String)APPPARAM, (Object[])new Object[0]), nodeName));
            return false;
        }
        return true;
    }

    private void showOrgTreeSetAddNewForm(Long parentOrgId, Long parentId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("mpdm_org_workcenter_tree");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mpdm_org_workcenter_tree"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u65e5\u5386\u7ec4\u7ec7", (String)"CalendarSettingFromPlugin_30", (String)APPPARAM, (Object[])new Object[0]));
        showParameter.getCustomParams().put("parentId", parentId);
        showParameter.getCustomParams().put("parentOrgId", parentOrgId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("mpdm_org_workcenter_tree".equals(actionId) && (returnData = event.getReturnData()) != null) {
            this.refreshTree();
        }
    }

    private void refreshTree() {
        TreeView treeView = this.getTreeView();
        treeView.deleteAllNodes();
        this.initTree();
    }

    private void markWorkCalendar() {
        WorkCalendar workCalendar = this.getWorkCalendar();
        Long calendarId = this.getCalendarId();
        ArrayList dateList = workCalendar.getDateList();
        if (!this.markDateValidate(dateList)) {
            return;
        }
        if ("2".equals(workCalendar.getDateType())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u6807\u6ce8\u534a\u5de5\u4f5c\u65e5\u3002", (String)"CalendarSettingFromPlugin_10", (String)APPPARAM, (Object[])new Object[0]));
            return;
        }
        QFilter calendarid = new QFilter("id", "=", (Object)calendarId);
        QFilter[] qfilters = new QFilter[]{calendarid};
        if (!QueryServiceHelper.exists((String)"mpdm_calendar", (QFilter[])qfilters)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u65e5\u5386ID\u201c%1$s\u201d\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u540e\u91cd\u8bd5\u3002", (String)"CalendarSettingFromPlugin_09", (String)APPPARAM, (Object[])new Object[0]), calendarId));
            return;
        }
        String dateType = workCalendar.getDateType();
        this.recordMarkCalendar(dateList, dateType, calendarId, workCalendar);
    }

    private void recordMarkCalendar(List<String> dateList, String dateType, Long calendarId, WorkCalendar workCalendar) {
        String dateStr = dateList.get(0);
        String childPageId = this.getChildPageId();
        IFormView childView = this.getView().getView(childPageId);
        if (childView == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b50\u9875\u9762ID\u201c%1$s\u201d\u5df2\u5931\u6548\uff0c\u8bf7\u9000\u51fa\u91cd\u8bd5\u3002", (String)"CalendarSettingFromPlugin_12", (String)APPPARAM, (Object[])new Object[0]), childPageId));
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = dateFormat.parse(dateStr);
            IDataModel childModel = childView.getModel();
            Long userId = RequestContext.get().getCurrUserId();
            Date currentDate = new Date();
            DynamicObjectCollection coll = childModel.getEntryEntity("dateentry");
            boolean isFind = false;
            if (!coll.isEmpty()) {
                for (int i = 0; i < coll.size(); ++i) {
                    DynamicObject dy = (DynamicObject)coll.get(i);
                    Date workdate = dy.getDate("workdate");
                    if (workdate == null || !dateFormat.format(workdate).equals(dateStr)) continue;
                    childModel.setValue("datetype", (Object)dateType, i);
                    childModel.setValue("entrycalendar", (Object)calendarId, i);
                    childModel.setValue("entrymodifydate", (Object)currentDate, i);
                    childModel.setValue("entrymodifyer", (Object)userId, i);
                    isFind = true;
                    break;
                }
            }
            if (!isFind) {
                childModel.batchCreateNewEntryRow("dateentry", 1);
                int rowIndex = coll.size() - 1;
                childModel.setValue("datetype", (Object)dateType, rowIndex);
                childModel.setValue("workdate", (Object)date, rowIndex);
                childModel.setValue("entrycalendar", (Object)calendarId, rowIndex);
                childModel.setValue("entrymodifydate", (Object)currentDate, rowIndex);
                childModel.setValue("entrymodifyer", (Object)userId, rowIndex);
            }
            childView.updateView("dateentry");
            this.getView().sendFormAction(childView);
            Map<String, String> markDateMap = this.getCalendarMarkDateMap();
            markDateMap.put(dateStr, dateType);
            this.setCalendarMarkDateMap(markDateMap);
            workCalendar.setDateTypeCallBack(dateList, dateType);
        }
        catch (ParseException e) {
            log.error((Throwable)e);
        }
    }

    private boolean markDateValidate(List<String> dateList) {
        if (dateList == null || dateList.isEmpty()) {
            return false;
        }
        boolean isSucess = true;
        String startDateStr = dateList.get(0);
        Date today = DateUtils.getStartOfDay((Date)new Date());
        SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
        try {
            Date startDate = SDF.parse(startDateStr);
            if (today.getTime() > startDate.getTime()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u6807\u6ce8\u5f53\u524d\u65e5\u671f\u4e4b\u524d\u7684\u65e5\u5386\u3002", (String)"CalendarSettingFromPlugin_06", (String)APPPARAM, (Object[])new Object[0]));
                isSucess = false;
            } else {
                String endDateStr = dateList.get(dateList.size() - 1);
                Date endDate = SDF.parse(endDateStr);
                Date startvaliddate = (Date)this.getModel().getValue("startvaliddate");
                Date endvaliddate = (Date)this.getModel().getValue("endvaliddate");
                if (startvaliddate == null || endvaliddate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u5de5\u4f5c\u65e5\u5386\u7684\u6709\u6548\u671f\u95f4\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u3002", (String)"CalendarSettingFromPlugin_07", (String)APPPARAM, (Object[])new Object[0]));
                    isSucess = false;
                    return isSucess;
                }
                if (startvaliddate.getTime() > startDate.getTime() || endvaliddate.getTime() < endDate.getTime()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u6807\u6ce8\u5f53\u524d\u7ec4\u7ec7\u8bbe\u7f6e\u7684\u6709\u6548\u671f\u95f4\u4e4b\u5916\u7684\u65e5\u5386\u3002", (String)"CalendarSettingFromPlugin_08", (String)APPPARAM, (Object[])new Object[0]));
                    isSucess = false;
                }
            }
        }
        catch (ParseException e) {
            log.error((Throwable)e);
        }
        return isSucess;
    }

    public void search(SearchEnterEvent evt) {
        List treeNodes;
        String searchText = evt.getText();
        TreeNode rootNode = this.getRootNode();
        if (rootNode == null) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        String pageId = this.getView().getPageId();
        String searchNodesCacheKey = pageId + "_searchNodes";
        String matchNodesCacheKey = pageId + "_matchNodes";
        String oldSearchTextCacheKey = pageId + "_oldSearchText";
        String searchIndexCacheKey = pageId + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || CalendarSettingUtils.isBlank(matchNodesCache)) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 50);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = CalendarSettingUtils.isBlank(searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 50);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(this.getMsgColsTreeSelectCompleteNoSel());
        } else {
            TreeView treeView = this.getTreeView();
            if (StringUtils.isNotEmpty((String)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache < treeNodes.size()) {
                    treeView.treeNodeClick(((TreeNode)treeNodes.get(indexCache)).getParentid(), ((TreeNode)treeNodes.get(indexCache)).getId());
                    treeView.showNode(((TreeNode)treeNodes.get(indexCache)).getParentid());
                    treeView.focusNode((TreeNode)treeNodes.get(indexCache));
                    pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                } else {
                    this.getView().showTipNotification(this.getMsgColsTreeSelectComplete());
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
            } else {
                treeView.treeNodeClick(((TreeNode)treeNodes.get(0)).getParentid(), ((TreeNode)treeNodes.get(0)).getId());
                treeView.showNode(((TreeNode)treeNodes.get(0)).getParentid());
                treeView.focusNode((TreeNode)treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }

    private String getMsgColsTreeSelectCompleteNoSel() {
        return ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"CalendarSettingFromPlugin_02", (String)APPPARAM, (Object[])new Object[0]);
    }

    private String getMsgColsTreeSelectComplete() {
        return ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\u3002", (String)"CalendarSettingFromPlugin_03", (String)APPPARAM, (Object[])new Object[0]);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        String currNodeId = (String)evt.getNodeId();
        if (currNodeId == null) {
            currNodeId = "";
        }
        if (currNodeId.equals(this.getCurrentTreeNodeId())) {
            return;
        }
        this.setCurrentTreeNodeId(currNodeId);
        this.showChildPage(currNodeId, true, true);
    }

    private void setPermissOrgData(Long nodeId, String type) {
        DynamicObject createOrg = null;
        if (nodeId != null && !nodeId.equals(0L) && !nodeId.equals(-1L)) {
            if ("C".equals(type)) {
                DynamicObject workCenter = CalendarSettingUtils.getWorkCenter(nodeId);
                createOrg = workCenter.getDynamicObject("createorg");
            } else if ("B".equals(type)) {
                DynamicObject workShop = CalendarSettingUtils.getWorkShop(nodeId);
                createOrg = workShop.getDynamicObject("createorg");
            } else {
                createOrg = CalendarSettingUtils.getOrg(nodeId);
            }
        }
        if (createOrg == null) {
            createOrg = OrgQueryHelper.getDataCacheByID((Object)RequestContext.get().getOrgId());
        }
        this.getModel().setValue("permissorg", (Object)createOrg);
    }

    private String getCurrentTreeNodeId() {
        String value = this.getView().getPageCache().get(CACHEKEY_CURRENTNODEID);
        return value == null ? "" : value;
    }

    private void setCurrentTreeNodeId(String nodeids) {
        this.getView().getPageCache().put(CACHEKEY_CURRENTNODEID, nodeids);
    }

    private String getChildPageId() {
        return this.getView().getPageCache().get(CACHEKEY_CHILDPAGEID);
    }

    private Map<String, String> getCalendarMarkDateMap() {
        String str = this.getView().getPageCache().get(CACHEKEY_CALCENDARDTENTRY);
        return CalendarSettingUtils.isBlank(str) ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)str, Map.class);
    }

    private void setCalendarMarkDateMap(Map<String, String> cacheMap) {
        this.getView().getPageCache().put(CACHEKEY_CALCENDARDTENTRY, SerializationUtils.toJsonString(cacheMap));
    }

    private Long getNodeDataId(String nodeId) {
        if (nodeId == null || "".equals(nodeId) || "".equals(nodeId.substring(1))) {
            return 0L;
        }
        return Long.parseLong(nodeId.substring(1));
    }

    private String getNodeDataType(String nodeId) {
        if (nodeId == null || "".equals(nodeId)) {
            return "A";
        }
        return nodeId.substring(0, 1);
    }

    public void showChildPage(String nodeIds, boolean checkChange, boolean isCheckLock) {
        IFormView childView;
        String oldChildPageId = this.getChildPageId();
        if (oldChildPageId != null && !"".equals(oldChildPageId) && (childView = this.getView().getView(oldChildPageId)) != null) {
            if (checkChange && childView.getModel().getDataChanged() && this.checkHasSavePermissItem()) {
                ConfirmCallBackListener listener = new ConfirmCallBackListener("showChildPage", (IFormPlugin)this);
                String msg = ResManager.loadKDString((String)"\u60a8\u8fd8\u6ca1\u6709\u4fdd\u5b58\u6570\u636e\uff0c\u662f\u5426\u5148\u8fdb\u884c\u4fdd\u5b58\uff1f", (String)"CalendarSettingFromPlugin_28", (String)APPPARAM, (Object[])new Object[0]);
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, listener);
                return;
            }
            childView.close();
        }
        this.openChildSetPage(nodeIds, isCheckLock);
    }

    public boolean checkHasSavePermissItem() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("permissorg");
        if (org != null) {
            HasPermOrgResult hasPermOrgResult;
            RequestContext requestContext = RequestContext.get();
            long userID = requestContext.getCurrUserId();
            String appId = "basedata";
            IFormView view = this.getView();
            if (view.getFormShowParameter() != null && !StringUtils.isEmpty((String)view.getFormShowParameter().getAppId())) {
                appId = view.getFormShowParameter().getAppId();
            }
            if (!(hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)BizAppServiceHelp.getAppIdByAppNumber((String)appId), (String)"mpdm_calendar_setting", (String)"0=KX5+QVF5+R")).hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains((Long)org.getPkValue())) {
                return Boolean.FALSE;
            }
        }
        return true;
    }

    public void openChildSetPage(String nodeIds, boolean isCheckLock) {
        Long nodeId = this.getNodeDataId(nodeIds);
        String type = this.getNodeDataType(nodeIds);
        Long setId = CalendarSettingUtils.getCalendarSetId(nodeId, type);
        boolean isNullSetId = CalendarSettingUtils.isNullLong(setId);
        this.getView().setEnable(Boolean.valueOf(!nodeId.equals(0L)), new String[]{OP_SAVEDATA});
        if (!isNullSetId && isCheckLock) {
            ArrayList<String> ids = new ArrayList<String>(16);
            ids.add(String.valueOf(setId));
            if (!BomUtils.checkEntityIsLock(ids, (String)"mpdm_calendarset", (String)"modify").isEmpty()) {
                String nodeName = this.getTreeNodeName();
                String msg = String.format(ResManager.loadKDString((String)"\u8282\u70b9\u201c%1$s\u201d\u5bf9\u5e94\u7684\u65e5\u5386\u8bbe\u7f6e\u5df2\u88ab\u9501\u5b9a\u3002", (String)"CalendarSettingFromPlugin_31", (String)APPPARAM, (Object[])new Object[0]), nodeName);
                this.getView().showTipNotification(msg);
                this.getView().setEnable(Boolean.FALSE, new String[]{OP_SAVEDATA});
            }
        }
        this.clearCachePageValue();
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("mpdm_calendarset");
        formShowParameter.setStatus(isNullSetId ? OperationStatus.ADDNEW : OperationStatus.EDIT);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("flexchild");
        formShowParameter.setCustomParam("nodetype", (Object)type);
        if (!isNullSetId) {
            formShowParameter.setPkId((Object)setId);
        } else {
            formShowParameter.setCustomParam("nodeId", (Object)nodeId);
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
        this.setPermissOrgData(nodeId, type);
    }

    public void showOrgAndWcSet() {
        ListShowParameter showParam = new ListShowParameter();
        showParam.setBillFormId("mpdm_org_workcenter_tree");
        showParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParam);
    }

    public void clearCachePageValue() {
        this.getView().getPageCache().remove(CACHEKEY_CALCENDARDTENTRY);
        this.getView().getPageCache().remove(CACHEKEY_CALCENDARID);
        this.getView().getPageCache().remove(CACHEKEY_CHILDPAGEID);
    }

    public Long getCalendarId() {
        String cacheid = this.getView().getPageCache().get(CACHEKEY_CALCENDARID);
        return CalendarSettingUtils.isBlank(cacheid) ? 0L : Long.parseLong(cacheid);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.clearCachePageValue();
    }

    public void updateChildViewBaseInfo() {
        String childPageId = this.getPageCache().get("childPageId");
        IFormView childView = this.getView().getView(childPageId);
        childView.updateView();
        this.getView().sendFormAction(childView);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if (OP_UPDATEWORKCALENDARVIEW.equals(operateKey)) {
            this.updateWorkCalendarView();
        } else if (OP_SAVEDATA.equals(operateKey)) {
            if (!this.checkSaveData()) {
                e.setCancel(true);
                return;
            }
        } else if (OP_DELETEORGDATA.equals(operateKey)) {
            RefObject afterConfirm = new RefObject();
            if (operate.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
                return;
            }
            if (!this.checkDeleteTreeNodeData()) {
                e.setCancel(true);
                return;
            }
            FormOperate source = (FormOperate)e.getSource();
            if (!source.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
                ConfirmCallBackListener listener = new ConfirmCallBackListener(operateKey, (IFormPlugin)this);
                String nodeName = this.getTreeNodeName();
                String msg = String.format(ResManager.loadKDString((String)"\u60a8\u786e\u5b9a\u8981\u5220\u9664\u6240\u9009\u62e9\u7684\u8282\u70b9\u201c%1$s\u201d\u5417\uff1f", (String)"CalendarSettingFromPlugin_20", (String)APPPARAM, (Object[])new Object[0]), nodeName);
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, listener);
                e.setCancel(true);
            }
        } else if (OP_NEWORGDATA.equals(operateKey)) {
            if (!this.checkAddNodeData()) {
                e.setCancel(true);
                return;
            }
        } else if (OP_SYNCORGDATA.equals(operateKey)) {
            ConfirmCallBackListener listener = new ConfirmCallBackListener(operateKey, (IFormPlugin)this);
            String msg = ResManager.loadKDString((String)"\u60a8\u786e\u5b9a\u8981\u8fdb\u884c\u751f\u4ea7\u7ec4\u7ec7\u89c6\u56fe\u53ca\u5de5\u4f5c\u4e2d\u5fc3\u3001\u8f66\u95f4\u7b49\u6570\u636e\u7684\u7ed3\u6784\u6811\u540c\u6b65\u5417\uff1f", (String)"CalendarSettingFromPlugin_26", (String)APPPARAM, (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.YesNo, listener);
            e.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (e.getOperationResult() != null && !e.getOperationResult().isSuccess()) {
            return;
        }
        if (OP_SAVEDATA.equals(key)) {
            this.saveData();
        }
        if (OP_REFRESHDATA.equals(key)) {
            this.refreshData();
        }
        if (OP_DELETEORGDATA.equals(key) && this.deleteTreeNode()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u8282\u70b9\u6570\u636e\u6210\u529f\u3002", (String)"CalendarSettingFromPlugin_25", (String)APPPARAM, (Object[])new Object[0]));
        }
        if (OP_NEWORGDATA.equals(key)) {
            String nodeId = this.getTreeNodeId();
            Long orgId = this.getNodeDataId(nodeId);
            DynamicObject orgTree = CalendarSettingUtils.getOrgAndWcTreeId(orgId, "A");
            this.showOrgTreeSetAddNewForm(orgId, orgTree.getLong("id"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (OP_DELETEORGDATA.equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation(callBackId, operateOption);
        }
        if (OP_SYNCORGDATA.equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.syncOrgTreeDataAndShow();
        }
        if ("showChildPage".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result) && !this.saveData()) {
                return;
            }
            this.showChildPage(this.getCurrentTreeNodeId(), false, true);
        }
    }

    private void syncOrgTreeData() {
        SyncOrgDataToTreeBusiness impl = new SyncOrgDataToTreeBusiness();
        impl.syncOrgData();
    }

    private void syncOrgTreeDataAndShow() {
        this.syncOrgTreeData();
        this.refreshTree();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u7ec4\u7ec7\u7ed3\u6784\u6811\u6210\u529f\u3002", (String)"CalendarSettingFromPlugin_27", (String)APPPARAM, (Object[])new Object[0]));
    }

    private boolean deleteTreeNode() {
        String nodeId = this.getTreeNodeId();
        Long nodeDataId = this.getNodeDataId(nodeId);
        String type = this.getNodeDataType(nodeId);
        Long setId = CalendarSettingUtils.getCalendarSetId(nodeDataId, type);
        try (TXHandle required = TX.requiresNew((String)"mmc-mpdm-CalendarSettingFromPlugin-deleteTreeNode");){
            try {
                if (!CalendarSettingUtils.isNullLong(setId)) {
                    DeleteServiceHelper.delete((String)"mpdm_calendarset", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)setId)});
                }
                QFilter qf = new QFilter("type", "=", (Object)type);
                String fieldNumber = "C".equals(type) ? "workcenter" : ("B".equals(type) ? "workshop" : "org");
                qf.and(new QFilter(fieldNumber, "=", (Object)nodeDataId));
                DeleteServiceHelper.delete((String)"mpdm_org_workcenter_tree", (QFilter[])new QFilter[]{qf});
            }
            catch (Exception e) {
                required.markRollback();
                throw e;
            }
        }
        TreeView treeView = this.getTreeView();
        treeView.deleteNode(nodeId);
        return true;
    }

    private boolean checkSaveData() {
        if (!this.chekHasChildPageId()) {
            return false;
        }
        String childPageId = this.getChildPageId();
        IFormView childView = this.getView().getView(childPageId);
        if (childView == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b50\u9875\u9762ID\u201c%1$s\u201d\u5df2\u5931\u6548\uff0c\u8bf7\u9000\u51fa\u91cd\u8bd5\u3002", (String)"CalendarSettingFromPlugin_12", (String)APPPARAM, (Object[])new Object[0]), childPageId));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveData() {
        String nodeId = this.getCurrentTreeNodeId();
        String lockKeys = "calendarSettngSaveData_" + nodeId;
        DLock lock = DLock.create((String)lockKeys, (String)lockKeys);
        lock.lock();
        try {
            String childPageId = this.getChildPageId();
            IFormView childView = this.getView().getView(childPageId);
            OperationResult saveResult = childView.invokeOperation("save", OperateOption.create());
            if (!saveResult.isSuccess()) {
                String msg = CalendarSettingUtils.getErrorMsg(saveResult);
                this.getView().showTipNotification(msg);
                boolean bl = false;
                return bl;
            }
            this.getView().sendFormAction(childView);
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    private boolean refreshData() {
        String childPageId = this.getChildPageId();
        if (childPageId != null && !"".equals(childPageId)) {
            this.showChildPage(this.getCurrentTreeNodeId(), false, false);
        }
        return true;
    }

    private void setCurYear(int year) {
        this.getModel().setValue("year", (Object)year);
        Label label = (Label)this.getControl("yearshow");
        label.setText(String.valueOf(year));
    }

    private void updateWorkCalendarView() {
        int year;
        Long calendarId = this.getCalendarId();
        DynamicObject calendar = CalendarSettingUtils.getCalendarData(calendarId, this.getWorkCalendarSelectProperties());
        int n = year = calendar == null ? CalendarSettingUtils.getCurrentYear() : calendar.getInt("expiringyearfrom");
        if (calendar == null) {
            this.setWorkCalendarData(0L, DateUtils.getYearFirstDate((int)year), DateUtils.getYearLastDate((int)year), 0L, year, new ArrayList<Map<String, String>>(16));
            return;
        }
        List<Map<String, String>> dateList = this.loadCalendarData(year, calendar);
        this.setWorkCalendarData(calendarId, DateUtils.getYearFirstDate((int)year), DateUtils.getYearLastDate((int)year), (Long)calendar.getDynamicObject("createorg").getPkValue(), year, dateList);
    }

    public void initialize() {
        super.initialize();
        WorkCalendar workCalendar = this.getWorkCalendar();
        if (workCalendar != null) {
            workCalendar.addClickListener((ClickListener)this);
        }
    }

    private String getWorkCalendarSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",createorg");
        sb.append(",number");
        sb.append(",name");
        sb.append(",expiringyearfrom");
        return sb.toString();
    }

    private void setWorkCalendarData(Long calendard, Date startvaliddate, Date endvaliddate, Long orgId, int year, List<Map<String, String>> workDataList) {
        this.getModel().setValue("calendarid", (Object)calendard);
        if (workDataList != null && !workDataList.isEmpty()) {
            this.getModel().setValue("startvaliddate", (Object)workDataList.get(0).get("workDate"));
            this.getModel().setValue("endvaliddate", (Object)workDataList.get(workDataList.size() - 1).get("workDate"));
        }
        this.getModel().setValue("dataorg", (Object)String.valueOf(orgId));
        WorkCalendar workCalendar = this.getWorkCalendar();
        workCalendar.setYear(year);
        workCalendar.setWorkDataList(workDataList);
        workCalendar.setData();
        this.setCurYear(year);
    }

    private List<Map<String, String>> loadCalendarData(int year, DynamicObject calendar) {
        ArrayList<Map<String, String>> workDataList = new ArrayList<Map<String, String>>(128);
        Date startDate = CalendarSettingUtils.getFirstDateByYear(year);
        Date endDate = CalendarSettingUtils.getLastDateByYear(year);
        QFilter qf = new QFilter("id", "=", calendar.getPkValue());
        qf.and(new QFilter("isindividuation", "=", (Object)0));
        qf.and(new QFilter("dateentry.workdate", ">=", (Object)startDate));
        qf.and(new QFilter("dateentry.workdate", "<=", (Object)endDate));
        String selectProperties = "dateentry.workDate workDate,dateentry.dateType dateType";
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"mpdm_calendar", (String)selectProperties, (QFilter[])new QFilter[]{qf}, (String)"dateentry.workDate");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Map<String, String> markDateMap = this.loadMarkDateBySet();
        for (DynamicObject workday : coll) {
            HashMap<String, String> data = new HashMap<String, String>(16);
            String dateKey = dateFormat.format(workday.getDate("workDate"));
            data.put("workDate", dateKey);
            String markDateType = markDateMap.get(dateKey);
            if (markDateType == null) {
                data.put("dateType", workday.getString("dateType"));
            } else {
                data.put("dateType", markDateType.toString());
            }
            workDataList.add(data);
        }
        return workDataList;
    }

    private Map<String, String> loadMarkDateBySet() {
        return this.getCalendarMarkDateMap();
    }
}

