/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.calendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bd.mpdm.business.calendar.SyncOrgDataToTreeBusiness;
import kd.bd.mpdm.common.query.helper.OrgQueryHelper;
import kd.bd.mpdm.common.query.helper.WorkcenterQueryHelper;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class CalendarSettingUtils {
    private static final Log log = LogFactory.getLog(CalendarSettingUtils.class);

    public static DynamicObjectCollection getOrgDatas(String appid) {
        SyncOrgDataToTreeBusiness imp = new SyncOrgDataToTreeBusiness();
        return imp.getOrgDatas(appid);
    }

    public static boolean isBlank(String str) {
        return str == null || "".equals(str);
    }

    public static String getIdKeysByOrgData(DynamicObject orgData) {
        if (orgData == null) {
            return "";
        }
        return CalendarSettingUtils.buildKeys(CalendarSettingUtils.getOrgType(orgData), orgData.getLong("org"), orgData.getLong("workshop"), orgData.getLong("workcenter"));
    }

    public static String getOrgType(DynamicObject orgData) {
        if (orgData == null) {
            return "";
        }
        return orgData.getString("type");
    }

    public static Map<Long, DynamicObject> buildKeyMap(DynamicObjectCollection orgDatas) {
        HashMap<Long, DynamicObject> maps = new HashMap<Long, DynamicObject>(orgDatas.size());
        for (DynamicObject orgData : orgDatas) {
            maps.put(orgData.getLong("id"), orgData);
        }
        return maps;
    }

    public static boolean isNullLong(Long data) {
        return data == null || data.equals(0L);
    }

    public static DynamicObject getOrg(Long id) {
        return OrgQueryHelper.getDataCacheByID((Object)id);
    }

    public static DynamicObject getWorkCenter(Long id) {
        return WorkcenterQueryHelper.getDataCacheByID((Object)id);
    }

    public static DynamicObject getWorkShop(Long id) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_workshopsetup", (String)CalendarSettingUtils.getWorkShopSelectProperties(), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
    }

    private static String getWorkShopSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",createorg");
        sb.append(",workshoporg");
        sb.append(",workshoporg.number workshoporgnumber");
        sb.append(",workshoporg.name workshoporgname");
        sb.append(",number");
        sb.append(",name");
        sb.append(",classsystem");
        sb.append(",classsystem.number");
        return sb.toString();
    }

    public static Long getDynamicObjectId(DynamicObject dy) {
        Long id = 0L;
        if (dy != null) {
            id = (Long)dy.getPkValue();
        }
        return id;
    }

    public static Long getCalendarSetId(Long nodeId, String type) {
        if (nodeId.equals(-1L) || nodeId.equals(0L)) {
            return 0L;
        }
        String queryField = "A".equals(type) ? "org" : ("B".equals(type) ? "workshop" : "workcenter");
        QFilter qfilter = new QFilter("objecttype", "=", (Object)type);
        qfilter.and(new QFilter(queryField, "=", (Object)nodeId));
        DynamicObject set = QueryServiceHelper.queryOne((String)"mpdm_calendarset", (String)"id", (QFilter[])new QFilter[]{qfilter});
        return set == null ? 0L : set.getLong("id");
    }

    public static int getCurrentYear() {
        return Calendar.getInstance().get(1);
    }

    public static DynamicObject getCalendarData(Long id, String selectProperties) {
        if (CalendarSettingUtils.isNullLong(id)) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"mpdm_calendar", (String)selectProperties);
    }

    public static DynamicObject getCalendarData(QFilter qf, String selectProperties) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_calendar", (String)selectProperties, (QFilter[])new QFilter[]{qf});
    }

    public static boolean isDiagitObject(Object data) {
        String yearValueStr = "";
        String pattern = "^[0-9]*$";
        boolean patternFlag = true;
        if (data instanceof String) {
            yearValueStr = data.toString();
            patternFlag = Pattern.matches(pattern, yearValueStr);
        }
        return patternFlag;
    }

    public static boolean isSetCalendarAtYear(Long calendarId, int year) {
        DynamicObject calendarInfo = CalendarSettingUtils.getCalendarData(calendarId, "id,name,expiringyearfrom,expiringyearto");
        if (calendarInfo == null) {
            return true;
        }
        String start = (String)calendarInfo.get("expiringyearfrom");
        String end = (String)calendarInfo.get("expiringyearto");
        int startYear = Integer.parseInt(start);
        int endYear = Integer.parseInt(end);
        return year >= startYear && year <= endYear;
    }

    public static Date getFirstDateByYear(int year) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = DateUtils.getYearFirstDate((int)year);
        try {
            startDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateFormat.format(startDate) + " 00:00:00");
        }
        catch (ParseException e) {
            log.error((Throwable)e);
        }
        return startDate;
    }

    public static Date getLastDateByYear(int year) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date endDate = DateUtils.getYearLastDate((int)year);
        try {
            endDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateFormat.format(endDate) + " 23:59:59");
        }
        catch (ParseException e) {
            log.error((Throwable)e);
        }
        return endDate;
    }

    public static String getErrorMsg(OperationResult operationResult) {
        StringBuilder errMsg = new StringBuilder();
        List validateErrors = operationResult.getValidateResult().getValidateErrors();
        for (ValidateResult validateResult : validateErrors) {
            List allErrorInfo = validateResult.getAllErrorInfo();
            allErrorInfo.forEach(operateErrorInfo -> {
                String message = operateErrorInfo.getMessage();
                errMsg.append(message);
            });
        }
        if (errMsg.length() < 1 && !operationResult.getAllErrorInfo().isEmpty()) {
            errMsg.append(operationResult.getAllErrorInfo());
        }
        if (errMsg.length() < 1 && !operationResult.isSuccess() && operationResult.getMessage() != null) {
            errMsg.append(operationResult.getMessage());
        }
        if (errMsg.length() < 1 && operationResult.getInteractionContext() != null && operationResult.getInteractionContext().getSimpleMessage() != null) {
            errMsg.append(operationResult.getInteractionContext().getSimpleMessage());
        }
        if (errMsg.length() < 1 && !operationResult.isSuccess()) {
            errMsg.append(operationResult.toString());
        }
        return errMsg.toString();
    }

    public static boolean checkIsExistsData(Long calendarSetId) {
        return QueryServiceHelper.exists((String)"mpdm_calendarset", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calendarSetId)});
    }

    public static String getNodeIdBySetId(Long calendarSetId) {
        String selectFields = "id,org,workshop,workcenter,objecttype";
        DynamicObject setObj = QueryServiceHelper.queryOne((String)"mpdm_calendarset", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calendarSetId)});
        String type = setObj.getString("objecttype");
        Long orgId = setObj.getLong("org");
        Long workCenterId = setObj.getLong("workcenter");
        Long workShopId = setObj.getLong("workshop");
        return CalendarSettingUtils.buildKeys(type, orgId, workShopId, workCenterId);
    }

    private static String buildKeys(String type, Long orgId, Long workShopId, Long workCenterId) {
        return "C".equals(type) ? type + workCenterId : ("B".equals(type) ? type + workShopId : type + orgId);
    }

    public static DynamicObject getOrgAndWcTreeId(Long nodeDataId, String type) {
        String fieldNumber = "C".equals(type) ? "workcenter" : ("B".equals(type) ? "workshop" : "org");
        String selectFields = "id,parent,type,issyncdata,org,org.name orgname,workcenter,workcenter.name workcentername,workshop,workshop.name workshopname";
        QFilter qf = new QFilter("type", "=", (Object)type);
        qf.and(new QFilter(fieldNumber, "=", (Object)nodeDataId));
        DynamicObject setObj = QueryServiceHelper.queryOne((String)"mpdm_org_workcenter_tree", (String)selectFields, (QFilter[])new QFilter[]{qf});
        return setObj;
    }

    public static boolean checkHasNextNode(Long parentId) {
        QFilter qf = new QFilter("parent", "=", (Object)parentId);
        return QueryServiceHelper.exists((String)"mpdm_org_workcenter_tree", (QFilter[])new QFilter[]{qf});
    }

    public static boolean checkHasSetData(Long nodeDataId, String type) {
        String fieldNumber = "C".equals(type) ? "workcenter" : ("B".equals(type) ? "workshop" : "org");
        QFilter qf = new QFilter("objecttype", "=", (Object)type);
        qf.and(new QFilter(fieldNumber, "=", (Object)nodeDataId));
        qf.and(new QFilter("entryentity.id", ">", (Object)0L));
        return QueryServiceHelper.exists((String)"mpdm_calendarset", (QFilter[])new QFilter[]{qf});
    }
}

