/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.capacity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.utils.CapacityUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.function.FunctionGroup;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;

public class CalcFormulaPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
TreeNodeClickListener {
    private static final String ROOTID = "root";
    private static final String PRE_GROUP = "group_";
    private static final String PRE_FUNC = "func_";
    private static final String KEY_OPERATOR_PANEL = "operator_panel";
    private static final String KEY_SEARCH = "searchap";
    private static final String KEY_TARGET = "target";
    private static final String KEY_FUNCTREE = "functree";
    private static final String KEY_ABILITYTREE = "abilitytree";
    private static final String KEY_FUNCNAME = "funcname";
    private static final String KEY_FUNCDESC = "funcdesc";
    private static final String KEY_RETURNTYPE = "returntype";
    private static final String KEY_FORMULA = "formula";
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BTN_CLEAR = "btn_clear";
    private static final String CACHEKEY_FUNCS = "functions";
    private static final String CACHEKEY_FUNCID = "funcId";
    private static final List<String> OPERATION_LIST = Arrays.asList("(", ")", "+", "-", "*", "/", "ABS", "sum", "min", "max", "avg", ",");

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        IDataModel model = this.getModel();
        model.setValue(KEY_TARGET, formShowParameter.getCustomParam("targetVariable"));
        String expression = (String)this.getView().getFormShowParameter().getCustomParam("expression");
        model.setValue(KEY_FORMULA, (Object)expression);
        this.initFuncTree();
        Map fixedValues = (Map)formShowParameter.getCustomParam("fixedValues");
        if (fixedValues != null) {
            this.initAbilityTree(fixedValues);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFuncInfo(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51fd\u6570", (String)"CalcFormulaPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), "");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        TreeView funcTree = (TreeView)this.getControl(KEY_FUNCTREE);
        funcTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView abilityTree = (TreeView)this.getControl(KEY_ABILITYTREE);
        abilityTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Container container = (Container)this.getControl(KEY_OPERATOR_PANEL);
        List items = container.getItems();
        ArrayList keys = Lists.newArrayListWithExpectedSize((int)(items.size() + 1));
        keys.add(KEY_BTNOK);
        for (Control item : items) {
            if (!(item instanceof Button)) continue;
            keys.add(item.getKey());
        }
        this.addClickListeners(keys.toArray(new String[0]));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (KEY_BTNOK.equals(key)) {
            this.validateAndReturnData();
        } else if (KEY_BTN_CLEAR.equals(key)) {
            this.getModel().setValue(KEY_FORMULA, null);
            this.setCursorIndex(0);
        } else {
            this.clickOperationButton(key);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        IPageCache pageCache;
        String funcId;
        String nodeId = String.valueOf(evt.getNodeId());
        if (nodeId.startsWith(PRE_FUNC) && !StringUtils.equals((CharSequence)(funcId = nodeId.substring(PRE_FUNC.length())), (CharSequence)(pageCache = this.getPageCache()).get(CACHEKEY_FUNCID))) {
            this.showFuncInfo(funcId);
            pageCache.put(CACHEKEY_FUNCID, funcId);
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        TreeView treeView = (TreeView)evt.getSource();
        String nodeId = String.valueOf(evt.getNodeId());
        if (KEY_ABILITYTREE.equals(treeView.getKey())) {
            this.insertExpression(treeView.getKey(), nodeId);
        } else if (nodeId.startsWith(PRE_FUNC)) {
            nodeId = nodeId.substring(PRE_FUNC.length());
            FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
            for (FunctionType functionType : functionTypes.getFunctionTypes()) {
                if (!nodeId.equals(functionType.getId())) continue;
                String def = functionType.getDef();
                def = def.replaceAll("number\\[\\]", " ");
                def = def.replaceAll("num", " ");
                this.insertExpression(treeView.getKey(), def);
            }
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        TreeNode treeNode;
        int i;
        String searchText = searchEnterEvent.getText();
        List<TreeNode> funcTreeNodes = this.getFuncTreeNodes();
        TreeView treeView = (TreeView)this.getControl(KEY_FUNCTREE);
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        int beginIndex = 0;
        if (focusNodeId != null && !ROOTID.equals(focusNodeId)) {
            for (TreeNode funcTreeNode : funcTreeNodes) {
                ++beginIndex;
                if (!focusNodeId.equals(funcTreeNode.getParentid()) && !focusNodeId.equals(funcTreeNode.getId())) continue;
                break;
            }
        }
        for (i = beginIndex; i < funcTreeNodes.size(); ++i) {
            treeNode = funcTreeNodes.get(i);
            if (!this.isSearchNode(treeNode, searchText)) continue;
            treeView.showNode(treeNode.getParentid());
            treeView.focusNode(treeNode);
            treeView.treeNodeClick("", treeNode.getId());
            return;
        }
        for (i = 0; i < beginIndex; ++i) {
            treeNode = funcTreeNodes.get(i);
            if (!this.isSearchNode(treeNode, searchText)) continue;
            treeView.showNode(treeNode.getParentid());
            treeView.focusNode(treeNode);
            treeView.treeNodeClick("", treeNode.getId());
            return;
        }
    }

    public List<String> getSearchList(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return null;
        }
        ArrayList<String> searchList = new ArrayList<String>();
        List<TreeNode> funcTreeNodes = this.getFuncTreeNodes();
        for (TreeNode funcTreeNode : funcTreeNodes) {
            String text = funcTreeNode.getText();
            if (!this.containsIgnoreCase(text, searchText)) continue;
            searchList.add(text);
        }
        for (TreeNode funcTreeNode : funcTreeNodes) {
            String id = funcTreeNode.getId();
            if (!this.containsIgnoreCase(id, searchText)) continue;
            searchList.add(id.substring(PRE_FUNC.length()));
        }
        return searchList;
    }

    private void validateAndReturnData() {
        String info;
        IFormView view = this.getView();
        String expression = (String)this.getModel().getValue(KEY_FORMULA);
        String formula = "";
        ArrayList<String> formulaList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)expression)) {
            this.getFormulaList(expression, formulaList);
        }
        Map fixedValues = (Map)view.getFormShowParameter().getCustomParam("fixedValues");
        for (int i = 0; i < formulaList.size(); ++i) {
            String value = (String)formulaList.get(i);
            String formulaKey = "";
            if (OPERATION_LIST.contains(value)) {
                formulaKey = value;
            } else if (CapacityUtils.isNumber((String)value)) {
                formulaKey = value;
            } else if (fixedValues != null) {
                for (Map.Entry entry : fixedValues.entrySet()) {
                    if (!value.equals(entry.getValue())) continue;
                    formulaKey = (String)entry.getKey();
                }
                if (StringUtils.isBlank((CharSequence)formulaKey)) {
                    String key = String.format(ResManager.loadKDString((String)"\u53d8\u91cf%s", (String)"CalcFormulaPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), "\uff1a\"");
                    this.getView().showErrorNotification(key.concat(value).concat(ResManager.loadKDString((String)"\"\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u66f4\u6539\u3002", (String)"CalcFormulaPlugin_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0])));
                    return;
                }
            }
            formula = formula.concat(formulaKey);
        }
        if ("".equals(formula) || formula == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u8868\u8fbe\u5f0f\u3002 ", (String)"CalcFormulaPlugin_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            FormulaEngine.extractVariables((String)formula);
        }
        catch (FormulaException formulaException) {
            info = String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%1$s", (String)"CalcFormulaPlugin_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), formulaException.getCause() == null ? formulaException.getMessage() : formulaException.getCause().getMessage());
            view.showErrorNotification(info);
            return;
        }
        catch (Exception exception) {
            info = String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%1$s", (String)"CalcFormulaPlugin_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), exception.getMessage());
            view.showErrorNotification(info);
            return;
        }
        view.returnDataToParent((Object)new String[]{expression, formula});
        view.close();
    }

    private void getFormulaList(String formula, List<String> formulaList) {
        int[] minandmax = new int[]{formula.length(), formula.length()};
        int i = formula.length();
        String splitString = "";
        for (String oper : OPERATION_LIST) {
            if (!formula.contains(oper) || formula.indexOf(oper) >= i) continue;
            i = formula.indexOf(oper);
            splitString = oper;
        }
        if (StringUtils.isNotBlank((CharSequence)splitString)) {
            minandmax = this.setMinAndMax(minandmax, i, splitString.length(), formula.length());
        }
        String substringPre = formula.substring(0, minandmax[0]);
        String substring = formula.substring(minandmax[0], minandmax[1]);
        if (StringUtils.isNotBlank((CharSequence)substringPre)) {
            formulaList.add(substringPre.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)substring)) {
            formulaList.add(substring.trim());
        }
        String formulanext = formula.substring(minandmax[1]);
        if (StringUtils.isNotBlank((CharSequence)formula)) {
            this.getFormulaList(formulanext, formulaList);
        }
    }

    private int[] setMinAndMax(int[] minandmax, int i, int length, int strLength) {
        if (i == 0) {
            minandmax[0] = 0;
            minandmax[1] = length;
        } else if (i == strLength - 1) {
            minandmax[0] = 0;
            minandmax[1] = i;
        } else {
            minandmax[0] = i;
            minandmax[1] = i + length;
        }
        return minandmax;
    }

    private void clickOperationButton(String key) {
        String insertValue;
        switch (key) {
            case "btn_0": {
                insertValue = "0";
                break;
            }
            case "btn_1": {
                insertValue = "1";
                break;
            }
            case "btn_2": {
                insertValue = "2";
                break;
            }
            case "btn_3": {
                insertValue = "3";
                break;
            }
            case "btn_4": {
                insertValue = "4";
                break;
            }
            case "btn_5": {
                insertValue = "5";
                break;
            }
            case "btn_6": {
                insertValue = "6";
                break;
            }
            case "btn_7": {
                insertValue = "7";
                break;
            }
            case "btn_8": {
                insertValue = "8";
                break;
            }
            case "btn_9": {
                insertValue = "9";
                break;
            }
            case "btn_add": {
                insertValue = "+";
                break;
            }
            case "btn_point": {
                insertValue = ".";
                break;
            }
            case "btn_subtract": {
                insertValue = "-";
                break;
            }
            case "btn_multiply": {
                insertValue = "*";
                break;
            }
            case "btn_divide": {
                insertValue = "/";
                break;
            }
            case "btn_leftbracket": {
                insertValue = "(";
                break;
            }
            case "btn_rightbracket": {
                insertValue = ")";
                break;
            }
            default: {
                insertValue = "";
            }
        }
        this.insertExpression(key, insertValue);
    }

    private void insertExpression(String controlKey, String insertStr) {
        IDataModel model = this.getModel();
        String text = (String)model.getValue(KEY_FORMULA);
        String expression = this.getExpression(controlKey, text, insertStr);
        model.setValue(KEY_FORMULA, (Object)expression);
    }

    private String getExpression(String controlKey, String text, String insertStr) {
        int cursorIndex;
        String expression = text;
        if (StringUtils.isBlank((CharSequence)text)) {
            expression = insertStr;
            cursorIndex = insertStr.length();
        } else {
            int pos = this.getCursorIndex(controlKey, text);
            expression = this.insertCharacter(expression, insertStr, pos);
            cursorIndex = pos + insertStr.length();
        }
        this.setCursorIndex(cursorIndex);
        return expression;
    }

    private String insertCharacter(String expression, String insertStr, int pos) {
        int length = expression.length();
        if (length < pos) {
            pos = length;
        }
        StringBuilder sb = new StringBuilder(expression);
        sb.insert(pos, insertStr);
        return sb.toString();
    }

    private int getCursorIndex(String controlKey, String text) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Object viewState = proxy.getViewState(controlKey);
        if (viewState instanceof Map) {
            Map map = (Map)viewState;
            Object focusResult = map.get("focus");
            if (focusResult instanceof Map) {
                Map focusMap = (Map)focusResult;
                return focusMap.getOrDefault(KEY_FORMULA, text.length());
            }
            return map.getOrDefault(KEY_FORMULA, text.length());
        }
        return text.length();
    }

    private void setCursorIndex(int cursorIndex) {
        LinkedHashMap cursorMap = Maps.newLinkedHashMapWithExpectedSize((int)2);
        cursorMap.put("ctrlKey", KEY_FORMULA);
        cursorMap.put("cursorIndex", cursorIndex);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("setTextareaCursorPosition", (Object)cursorMap);
    }

    private void showFuncInfo(String funcId) {
        FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
        for (FunctionType functionType : functionTypes.getFunctionTypes()) {
            if (!funcId.equals(functionType.getId())) continue;
            String info = String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u503c\uff1a%1$s", (String)"CalcFormulaPlugin_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), functionType.getReturnType());
            this.setFuncInfo(functionType.getDef(), info);
            this.getModel().setValue(KEY_FUNCDESC, (Object)this.analyzingDesc(functionType.getDesc().getLocaleValue()));
        }
    }

    private boolean isSearchNode(TreeNode treeNode, String searchText) {
        return this.containsIgnoreCase(treeNode.getText(), searchText) || this.containsIgnoreCase(treeNode.getId().substring(PRE_FUNC.length()), searchText);
    }

    private boolean containsIgnoreCase(String str, String searchStr) {
        if (StringUtils.isBlank((CharSequence)str) || StringUtils.isBlank((CharSequence)searchStr)) {
            return false;
        }
        return str.toLowerCase().contains(searchStr.toLowerCase());
    }

    private List<TreeNode> getFuncTreeNodes() {
        IPageCache pageCache = this.getPageCache();
        String str = pageCache.get(CACHEKEY_FUNCS);
        return StringUtils.isBlank((CharSequence)str) ? Collections.emptyList() : SerializationUtils.fromJsonStringToList((String)str, TreeNode.class);
    }

    private void initFuncTree() {
        TreeNode groupNode;
        TreeNode root = new TreeNode("", ROOTID, ResManager.loadKDString((String)"\u5168\u90e8\u51fd\u6570", (String)"CalcFormulaPlugin_6", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        root.setChildren(new ArrayList());
        root.setIsOpened(true);
        FunctionTypes commonFuncs = FunctionTypes.getCommonFuncs();
        List functionGroups = commonFuncs.getFunctionGroups();
        functionGroups.removeIf(functionGroup -> "Common".equals(functionGroup.getId()) || "String".equals(functionGroup.getId()) || "DateTime".equals(functionGroup.getId()) || "NullJudge".equals(functionGroup.getId()));
        functionGroups.sort(Comparator.comparingInt(FunctionGroup::getSeq));
        LinkedHashMap groupId2TreeNode = Maps.newLinkedHashMapWithExpectedSize((int)functionGroups.size());
        for (FunctionGroup functionGroup2 : functionGroups) {
            if (!functionGroup2.isVisible()) continue;
            TreeNode groupNode2 = new TreeNode();
            String string = functionGroup2.getId();
            groupNode2.setId(PRE_GROUP + string);
            groupNode2.setText(functionGroup2.getName().getLocaleValue());
            groupNode2.setParentid(ROOTID);
            groupNode2.setChildren(new ArrayList());
            groupId2TreeNode.put(string, groupNode2);
        }
        List functionTypes = commonFuncs.getFunctionTypes();
        ArrayList funcTreeNodes = Lists.newArrayListWithExpectedSize((int)functionTypes.size());
        functionTypes.sort(Comparator.comparingInt(FunctionType::getSeq));
        for (FunctionType functionType : functionTypes) {
            groupNode = (TreeNode)groupId2TreeNode.get(functionType.getGroupId());
            if (groupNode == null || "group_Set".equals(groupNode.getId()) && !Arrays.asList("sum", "min", "max", "avg").contains(functionType.getId()) || "group_Math".equals(groupNode.getId()) && !"ABS".equals(functionType.getId())) continue;
            TreeNode funcNode = new TreeNode();
            funcNode.setId(PRE_FUNC + functionType.getId());
            funcNode.setText(functionType.getName().getLocaleValue());
            funcNode.setParentid(groupNode.getId());
            groupNode.addChild(funcNode);
            funcTreeNodes.add(funcNode);
        }
        for (Map.Entry entry : groupId2TreeNode.entrySet()) {
            groupNode = (TreeNode)entry.getValue();
            if (groupNode.getChildren().isEmpty()) continue;
            root.addChild(groupNode);
        }
        TreeView treeView = (TreeView)this.getControl(KEY_FUNCTREE);
        treeView.addNode(root);
        this.getPageCache().put(CACHEKEY_FUNCS, SerializationUtils.toJsonString((Object)funcTreeNodes));
    }

    private void initAbilityTree(Map<String, String> fixedValues) {
        TreeNode root = new TreeNode("", ROOTID, ResManager.loadKDString((String)"\u5168\u90e8", (String)"CalcFormulaPlugin_7", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        root.setIsOpened(true);
        ArrayList childrens = Lists.newArrayListWithExpectedSize((int)fixedValues.size());
        for (Map.Entry<String, String> entry : fixedValues.entrySet()) {
            TreeNode treeNode = new TreeNode(ROOTID, entry.getValue(), entry.getValue());
            childrens.add(treeNode);
        }
        root.setChildren((List)childrens);
        TreeView treeView = (TreeView)this.getControl(KEY_ABILITYTREE);
        treeView.addNode(root);
    }

    private void setFuncInfo(String funcName, String returnType) {
        ((Label)this.getControl(KEY_FUNCNAME)).setText(funcName);
        ((Label)this.getControl(KEY_RETURNTYPE)).setText(returnType);
    }

    private String analyzingDesc(String desc) {
        ArrayList<String> descLines = new ArrayList<String>(10);
        String temp = desc;
        int index = temp.indexOf("\\n");
        while (index > 0) {
            descLines.add(temp.substring(0, index));
            temp = index < temp.length() - 2 ? temp.substring(index + 2) : "";
            index = temp.indexOf("\\n");
        }
        if (StringUtils.isNotBlank((CharSequence)temp)) {
            descLines.add(temp);
        }
        return StringUtils.join((Object[])descLines.toArray(), (char)'\n');
    }
}

