/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.capacity;

import java.util.Arrays;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.utils.CapacityUtils;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.orm.util.CollectionUtils;

public class CapacityGroupEdit
extends AbstractFormPlugin {
    private Boolean isIgnoreFieldChange = Boolean.FALSE;
    private static final String KEY_CAPACITY_CAL = "capacitycal";
    private static final String KEY_CAPACITY_CAL_EN = "capacitycalen";
    private static final String MPDM_CAPACITY_COMPLETE = "mpdm_capacomplete";
    private static final String CAL_CLOSE_EDIT = "calCloseEdit";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String CAPACITY_TYPE = "capacitytype";
    private static final String CAPACITY_NAME = "capacityname";
    private static final String CAPACITY_NUMBER = "capacitynumber";
    private static final String OPER_DELETEENTRY = "deleteentry";
    private static final List<String> OPERATION_LIST = Arrays.asList("(", ")", "+", "-", "*", "/", "ABS", "sum", "min", "max", "avg", ",");
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_CAPACITY_CAL});
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_CAPACITY_CAL, (CharSequence)source.getKey())) {
            int row = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(MPDM_CAPACITY_COMPLETE);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CAL_CLOSE_EDIT));
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            LinkedHashMap<String, String> fixedMap = new LinkedHashMap<String, String>();
            for (DynamicObject dynamicObject : entryEntity) {
                if (!"A".equals(dynamicObject.get(CAPACITY_TYPE)) || StringUtils.isBlank((Object)dynamicObject.get(CAPACITY_NUMBER))) continue;
                fixedMap.put(dynamicObject.getString(CAPACITY_NUMBER), dynamicObject.getString(CAPACITY_NAME));
            }
            String capacityName = (String)this.getModel().getValue(CAPACITY_NAME, row);
            String expression = (String)this.getModel().getValue(KEY_CAPACITY_CAL, row);
            params.put("targetVariable", capacityName);
            params.put("expression", expression);
            params.put("fixedValues", fixedMap);
            showParameter.setCustomParams(params);
            this.getView().showForm(showParameter);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.itemClick((ItemClickEvent)evt);
        String itemKey = evt.getItemKey();
        int row = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        if (OPER_DELETEENTRY.equals(itemKey)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            for (DynamicObject dynamicObject : entryEntity) {
                String capacityNumber = (String)this.getModel().getValue(CAPACITY_NUMBER, row);
                String capacityType = (String)this.getModel().getValue(CAPACITY_TYPE, row);
                if (StringUtils.isBlank((CharSequence)capacityNumber) || !"A".equals(capacityType) || !StringUtils.isNotBlank((CharSequence)dynamicObject.getString(KEY_CAPACITY_CAL_EN)) || !dynamicObject.getString(KEY_CAPACITY_CAL_EN).contains(capacityNumber)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u80fd\u529b\u9879\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"CapacityGroupEdit_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)CAL_CLOSE_EDIT) && closedCallBackEvent.getReturnData() != null) {
            int row = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            String[] returnData = (String[])closedCallBackEvent.getReturnData();
            this.getModel().setValue(KEY_CAPACITY_CAL, (Object)returnData[0], row);
            this.getModel().setValue(KEY_CAPACITY_CAL_EN, (Object)returnData[1], row);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.isIgnoreFieldChange.booleanValue()) {
            return;
        }
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (propertyName) {
            case "capacityname": {
                this.capacityNameChange(changeSet);
                break;
            }
            case "capacitytype": {
                for (ChangeData changeData : changeSet) {
                    String oldValue = (String)changeData.getOldValue();
                    String capanum = (String)this.getModel().getValue(CAPACITY_NUMBER, changeData.getRowIndex());
                    if (!"A".equals(oldValue)) continue;
                    this.clearCapacityCal(capanum);
                }
                break;
            }
        }
    }

    private void capacityNameChange(ChangeData[] changeSet) {
        for (ChangeData changeData : changeSet) {
            String newValue;
            int index = changeData.getRowIndex();
            if (this.checkCapacityNameChange(changeData, index, newValue = (String)changeData.getNewValue())) {
                return;
            }
            String capanum = (String)this.getModel().getValue(CAPACITY_NUMBER, index);
            if (StringUtils.isNotBlank((CharSequence)capanum)) {
                this.clearCapacityCal(capanum);
                continue;
            }
            List capacityNumber = this.getModel().getEntryEntity(ENTRY_ENTITY).stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getString(CAPACITY_NUMBER))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(capacityNumber)) {
                this.getModel().setValue(CAPACITY_NUMBER, (Object)"param_".concat("0"), index);
                continue;
            }
            Integer max = capacityNumber.stream().map(x -> Integer.parseInt(x.getString(CAPACITY_NUMBER).split("_")[1])).max(Integer::compareTo).get();
            this.getModel().setValue(CAPACITY_NUMBER, (Object)"param_".concat(Integer.toString(max + 1)), index);
        }
    }

    private boolean checkCapacityNameChange(ChangeData changeData, int index, String newValue) {
        if (CapacityUtils.isNumber((String)newValue)) {
            this.isIgnoreFieldChange = Boolean.TRUE;
            this.getModel().setValue(CAPACITY_NAME, changeData.getOldValue(), index);
            this.isIgnoreFieldChange = Boolean.FALSE;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u80fd\u529b\u9879\u540d\u79f0\u4e0d\u5141\u8bb8\u8f93\u5165\u7eaf\u6570\u5b57\u3001\u51fd\u6570\u3002", (String)"CapacityGroupEdit_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)newValue)) {
            this.isIgnoreFieldChange = Boolean.TRUE;
            for (String oper : OPERATION_LIST) {
                if (!newValue.contains(oper)) continue;
                this.showMsg(changeData, index, oper);
                return true;
            }
            long count = this.getModel().getEntryEntity(ENTRY_ENTITY).stream().filter(x -> newValue.equals(x.getString(CAPACITY_NAME))).count();
            if (count > 1L) {
                this.getModel().setValue(CAPACITY_NAME, changeData.getOldValue(), index);
                this.isIgnoreFieldChange = Boolean.FALSE;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u80fd\u529b\u9879\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"CapacityGroupEdit_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private void showMsg(ChangeData changeData, int index, String msg) {
        String key = String.format(ResManager.loadKDString((String)"\u80fd\u529b\u9879\u540d\u79f0\u4e0d\u80fd\u5e26%s", (String)"CapacityGroupEdit_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), "\"");
        this.getView().showTipNotification(key.concat(msg).concat(ResManager.loadKDString((String)"\"\u7684\u5b57\u7b26\u3002", (String)"CapacityGroupEdit_4", (String)"bd-mpdm-formplugin", (Object[])new Object[0])));
        this.getModel().setValue(CAPACITY_NAME, changeData.getOldValue(), index);
        this.isIgnoreFieldChange = Boolean.FALSE;
    }

    private void clearCapacityCal(String capanum) {
        this.isIgnoreFieldChange = Boolean.TRUE;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            String[] fixCapacitys;
            long count;
            String expression;
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            if ("A".equals(dynamicObject.getString(CAPACITY_TYPE)) || StringUtils.isBlank((CharSequence)(expression = dynamicObject.getString(KEY_CAPACITY_CAL_EN))) || (count = Arrays.stream(fixCapacitys = FormulaEngine.extractVariables((String)expression)).filter(x -> capanum.equals(x)).count()) <= 0L) continue;
            this.getModel().setValue(KEY_CAPACITY_CAL_EN, null, i);
            this.getModel().setValue(KEY_CAPACITY_CAL, null, i);
        }
        this.isIgnoreFieldChange = Boolean.FALSE;
    }
}

