/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.distr;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class MaterialDistrEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initMftOrg();
    }

    private void initMftOrg() {
        Object mftorg = this.getModel().getValue("mftorg");
        if (mftorg != null) {
            return;
        }
        Object orgid = this.getModel().getValue("useorg");
        if (orgid instanceof DynamicObject) {
            if (MaterialDistrEditPlugin.isFisproduce((DynamicObject)orgid)) {
                this.getModel().setValue("mftorg", orgid);
            } else {
                DynamicObject defaultOrg = null;
                ArrayList<Map<String, Object>> list = MaterialDistrEditPlugin.getOrgMaps((DynamicObject)orgid);
                list.stream().map(o -> o.get("orgId")).collect(Collectors.toSet());
                for (Map map : list) {
                    boolean isDefault = (Boolean)map.get("isDefault");
                    if (isDefault) {
                        defaultOrg = BusinessDataServiceHelper.loadSingleFromCache(map.get("orgId"), (String)"bos_org");
                        continue;
                    }
                    if (defaultOrg != null) continue;
                    defaultOrg = BusinessDataServiceHelper.loadSingleFromCache(map.get("orgId"), (String)"bos_org");
                }
                this.getModel().setValue("mftorg", defaultOrg);
            }
        }
        this.getModel().setDataChanged(false);
    }

    private static boolean isFisproduce(DynamicObject orgid) {
        boolean isproduce = false;
        if (orgid != null) {
            DynamicObject useorg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgid.getPkValue(), (String)"bos_org");
            isproduce = useorg.getBoolean("fisproduce");
        }
        return isproduce;
    }

    private static ArrayList<Map<String, Object>> getOrgMaps(DynamicObject orgid) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(orgid.getLong("id"));
        param.setFromViewType("04");
        param.setToViewType("05");
        param.setDirectViewType("fromorg");
        Map map = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
        ArrayList list = (ArrayList)map.get("data");
        return list;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if ("mftorg".equals(name)) {
            this.getModel().setValue("workcentre", null);
            this.getModel().setValue("workstation", null);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit mftorg = (BasedataEdit)this.getControl("mftorg");
        mftorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit workcentre = (BasedataEdit)this.getControl("workcentre");
        workcentre.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit workstation = (BasedataEdit)this.getControl("workstation");
        workstation.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Object mftorg;
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"mftorg")) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            Object orgid = this.getModel().getValue("createorg");
            if (orgid instanceof DynamicObject) {
                ArrayList<Map<String, Object>> list = MaterialDistrEditPlugin.getOrgMaps((DynamicObject)orgid);
                List orgList = list.stream().map(o -> o.get("orgId")).collect(Collectors.toList());
                if (MaterialDistrEditPlugin.isFisproduce((DynamicObject)orgid)) {
                    orgList.add(((DynamicObject)orgid).getPkValue());
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", orgList));
            } else {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", new ArrayList(16)));
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"workcentre")) {
            Object mftorg2 = this.getModel().getValue("mftorg");
            if (mftorg2 == null) {
                String errorString = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"MaterialDistrEditPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(errorString);
                evt.setCancel(true);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"workstation") && (mftorg = this.getModel().getValue("mftorg")) == null) {
            String errorString = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"MaterialDistrEditPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errorString);
            evt.setCancel(true);
        }
    }
}

