/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.handmapping;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;

public class HandMappingEdit
extends AbstractBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static final String SOURCEBILL = "sourcebill";
    private static final String HANDMODE = "handmode";
    private static final String HANDMODEID = "handmodeid";
    private static final String SOURCEFIELDNAME = "sourcefieldname";
    private static final String SOURCEFIELD = "sourcefield";
    private static final String ENTRY = "entry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit handModeText = (TextEdit)this.getView().getControl(HANDMODE);
        handModeText.addClickListener((ClickListener)this);
        TextEdit sourceFieldText = (TextEdit)this.getView().getControl(SOURCEFIELDNAME);
        sourceFieldText.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (HANDMODE.equalsIgnoreCase(key)) {
            this.showHandMode();
        } else if (SOURCEFIELDNAME.equalsIgnoreCase(key)) {
            this.showSourceField();
        }
    }

    private void showSourceField() {
        DynamicObject sourcebill = (DynamicObject)this.getModel().getValue(SOURCEBILL);
        if (sourcebill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u5355", (String)"HandMappingEdit_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mpdm_fieldselect");
        showParameter.getCustomParams().put("entity", sourcebill.getString("id"));
        showParameter.getCustomParams().put("entityname", sourcebill.getString("name"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SOURCEFIELDNAME));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showHandMode() {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"qcbd_badhandmode", (boolean)false);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setMultiSelect(false);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, HANDMODE);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map map;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HANDMODE.equalsIgnoreCase(actionId)) {
            ListSelectedRowCollection data = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (data != null && data.size() > 0) {
                ListSelectedRow selectRow = data.get(0);
                int row = this.getModel().getEntryCurrentRowIndex(ENTRY);
                this.getModel().setValue(HANDMODE, (Object)selectRow.getName(), row);
                this.getModel().setValue(HANDMODEID, selectRow.getEntryPrimaryKeyValue(), row);
            }
        } else if (SOURCEFIELDNAME.equalsIgnoreCase(actionId) && (map = (Map)closedCallBackEvent.getReturnData()) != null) {
            int row = this.getModel().getEntryCurrentRowIndex(ENTRY);
            this.getModel().setValue(SOURCEFIELDNAME, map.get("text"), row);
            this.getModel().setValue(SOURCEFIELD, map.get("id"), row);
        }
    }
}

