/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.license;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.formplugin.license.BaseDataLicenseCheck;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class LicenseCheckPlugin
extends AbstractListPlugin {
    private static Map<String, List<String>> licenseCheckForms = new HashMap<String, List<String>>(4);

    public void preOpenForm(PreOpenFormEventArgs e) {
        String formId = "";
        FormShowParameter formShowParameter = e.getFormShowParameter();
        formId = formShowParameter instanceof ListShowParameter ? ((ListShowParameter)formShowParameter).getBillFormId() : e.getFormShowParameter().getFormId();
        String licenseType = "pdm";
        for (Map.Entry<String, List<String>> typeToForms : licenseCheckForms.entrySet()) {
            String typeKey = typeToForms.getKey();
            List<String> checkFormIDs = typeToForms.getValue();
            if (!checkFormIDs.contains(formId)) continue;
            licenseType = typeKey;
            break;
        }
        switch (licenseType) {
            case "PRO_MMC_ECE": 
            case "PRO_MMC_PC": {
                this.ckeckPropMMCEceLisence(e, licenseType, formId);
                break;
            }
            default: {
                this.ckeckPdmLisence(e, licenseType, formId);
            }
        }
    }

    private void ckeckPdmLisence(PreOpenFormEventArgs e, String bizAppId, String formId) {
        LicenseCheckResult lr = BaseDataLicenseCheck.checkLicense(bizAppId, formId);
        if (!lr.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(lr.getMsg());
            e.setCancelFormShowParameter(lr.getCancelFormShowParameter());
        }
    }

    private void ckeckPropMMCEceLisence(PreOpenFormEventArgs e, String groupNumber, String formId) {
        LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)groupNumber);
        if (!checkResult.getHasLicense().booleanValue()) {
            e.setCancel(checkResult.getHasLicense() == false);
            String msg = checkResult.getMsg();
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                String resMsg = this.transfMessage(msg, groupNumber, checkResult);
                e.setCancelMessage(resMsg);
                e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
            }
        }
    }

    private String transfMessage(String msg, String groupNumber, LicenseCheckResult checkResult) {
        if (msg.contains(groupNumber)) {
            String resMsg = "";
            switch (groupNumber) {
                case "PRO_MMC_ECE": {
                    resMsg = msg.replace("PRO_MMC_ECE", ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u8bc4\u4f30", (String)"LicenseCheckPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "PRO_MMC_PC": {
                    resMsg = msg.replace("PRO_MMC_PC", ResManager.loadKDString((String)"\u4ea7\u54c1\u9009\u914d", (String)"LicenseCheckPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                }
            }
            checkResult.setMsg(resMsg);
            return resMsg;
        }
        return msg;
    }

    static {
        ArrayList<String> proMMCECEFormIds = new ArrayList<String>(16);
        proMMCECEFormIds.add("pdm_initdata");
        proMMCECEFormIds.add("pdm_ecoeffectorderbill");
        proMMCECEFormIds.add("pdm_planprogram_eco");
        proMMCECEFormIds.add("pdm_ecocal_log");
        proMMCECEFormIds.add("pdm_eco_changeplatform");
        proMMCECEFormIds.add("pdm_ecochangelog");
        proMMCECEFormIds.add("pdm_ecoestimate_exec");
        proMMCECEFormIds.add("pdm_ecoeffectrange_result");
        proMMCECEFormIds.add("pdm_ecoestimate_result");
        proMMCECEFormIds.add("pdm_ecorequirefilter");
        licenseCheckForms.put("PRO_MMC_ECE", proMMCECEFormIds);
        ArrayList<String> propFormIDs = new ArrayList<String>(1);
        propFormIDs.add("fmm_programe");
        licenseCheckForms.put("prop", propFormIDs);
        ArrayList<String> proMMCPCFormIDs = new ArrayList<String>(1);
        proMMCPCFormIDs.add("pdm_productconfig");
        proMMCPCFormIDs.add("pdm_productconfigure");
        proMMCPCFormIDs.add("mpdm_configmatrix");
        proMMCPCFormIDs.add("mpdm_featuretype");
        proMMCPCFormIDs.add("pdm_featuredefinition");
        proMMCPCFormIDs.add("pdm_chararule");
        proMMCPCFormIDs.add("pdm_proconfigscheme");
        proMMCPCFormIDs.add("pdm_simulamatch");
        proMMCPCFormIDs.add("pdm_chararule_rpt");
        proMMCPCFormIDs.add("pdm_featuretype_rpt");
        licenseCheckForms.put("PRO_MMC_PC", proMMCPCFormIDs);
        ArrayList<String> pdmFormIDs = new ArrayList<String>(1);
        pdmFormIDs.add("mpdm_replaceplanreport");
        pdmFormIDs.add("pdm_bomcomparerpt");
        pdmFormIDs.add("pdm_bomforwardsearch");
        pdmFormIDs.add("pdm_batchbomforwardsearch");
        pdmFormIDs.add("pdm_batchbombacksearch");
        pdmFormIDs.add("pdm_batchmftbom");
        pdmFormIDs.add("pdm_bombacksearch");
        pdmFormIDs.add("pdm_mftbom");
        pdmFormIDs.add("pdm_route");
        licenseCheckForms.put("pdm", pdmFormIDs);
    }
}

