/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.manufacturemodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;

public class PropTransactProductFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String STOCKMATERIALS_D = "D";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bizType = (BasedataEdit)this.getControl("transactiontype");
        bizType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propertyName = e.getProperty().getName();
        if ("transactiontype".equals(propertyName)) {
            e.getCustomQFilters().clear();
            e.getCustomQFilters().add(new QFilter("domain", "=", (Object)"9"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        model.setValue("stockmaterials", (Object)STOCKMATERIALS_D);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setIsShowValue("stockmaterials");
        this.setIsShowValue("materialsource");
    }

    private void setIsShowValue(String field) {
        ComboProp iDataEntityProperty = (ComboProp)this.getModel().getProperty(field);
        List comboItems = iDataEntityProperty.getComboItems();
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(10);
        switch (field) {
            case "stockmaterials": {
                this.alterStockMaterials(comboItems, comboItemList);
                break;
            }
            case "materialsource": {
                this.alterMaterialSource(comboItems, comboItemList);
                break;
            }
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(field);
        comboEdit.setComboItems(comboItemList);
    }

    private void alterMaterialSource(List<ValueMapItem> comboItems, List<ComboItem> comboItemList) {
        for (ValueMapItem comboItem : comboItems) {
            String materialSource = comboItem.getValue();
            if ("A".equals(materialSource)) {
                comboItem.getName().setLocaleValue(ResManager.loadKDString((String)"BOM\u6216\u914d\u65b9", (String)"PropTransactProductFormPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                comboItemList.add(new ComboItem(comboItem.getName(), comboItem.getValue()));
            }
            if (!"B".equals(materialSource)) continue;
            comboItemList.add(new ComboItem(comboItem.getName(), comboItem.getValue()));
        }
    }

    private void alterStockMaterials(List<ValueMapItem> comboItems, List<ComboItem> comboItemList) {
        for (ValueMapItem comboItem : comboItems) {
            String stockMaterials = comboItem.getValue();
            if ("A".equals(stockMaterials) || STOCKMATERIALS_D.equals(stockMaterials)) {
                comboItemList.add(new ComboItem(comboItem.getName(), comboItem.getValue()));
            }
            if (!"C".equals(stockMaterials)) continue;
            comboItem.getName().setLocaleValue(ResManager.loadKDString((String)"\u4e0d\u5c55\u5f00BOM\u6216\u914d\u65b9", (String)"PropTransactProductFormPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            comboItemList.add(new ComboItem(comboItem.getName(), comboItem.getValue()));
        }
    }
}

