/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.manufacturemodel;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bd.mpdm.common.consts.ProtransferBillConsts;
import kd.bd.mpdm.common.enums.ProtransferBiztypeEnum;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class ProtransferBillTplEditPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
BeforeF7SelectListener {
    protected Boolean isIgnoreChangeListener = Boolean.FALSE;
    public static final String[] notShowfileds = new String[]{"qualifyqty", "receiveqty", "workwasteqty", "scrapqty", "reworkqty", "qualifybaseqty", "receivebaseqty", "workwastebaseqty", "scrapbaseqty", "reworkbaseqty", "junkqty", "junkbaseqty", "outpurchaseorg", "inpurchaseorg"};

    protected void showEntryDetial(DynamicObject entryentity) {
        this.isIgnoreChangeListener = Boolean.TRUE;
        IDataModel model = this.getModel();
        if (entryentity != null) {
            Map<String, String> fieldMaps = this.getFiledMaps();
            for (Map.Entry<String, String> key : fieldMaps.entrySet()) {
                model.setValue(key.getKey(), entryentity.get(key.getValue()));
            }
        } else {
            Map<String, String> fieldMaps = this.getFiledMaps();
            for (String key : fieldMaps.keySet()) {
                model.setValue(key, null);
            }
        }
        this.isIgnoreChangeListener = Boolean.FALSE;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("outentryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid inentryGrid = (EntryGrid)this.getView().getControl("inentryentity");
        inentryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit transferredout = (BasedataEdit)this.getView().getControl("transferredout");
        transferredout.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit transferredin = (BasedataEdit)this.getView().getControl("transferredin");
        transferredin.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void selectInEntryRow(int index) {
        EntryGrid inentry = (EntryGrid)this.getView().getControl("inentryentity");
        if (index >= 0) {
            Integer inrow = this.getInEntryRow(index);
            inentry.selectRows(inrow.intValue());
        } else {
            inentry.selectRows(-1);
        }
    }

    private void selectOutEntryRow(int index) {
        Integer outrow = -1;
        EntryGrid outentry = (EntryGrid)this.getView().getControl("outentryentity");
        if (index >= 0) {
            outrow = this.getOutEntryRow(index);
        }
        outentry.selectRows(outrow.intValue());
        DynamicObject entryentity = this.getModel().getEntryRowEntity("outentryentity", outrow.intValue());
        this.showEntryDetial(entryentity);
        this.showPropertyByTransfertype(outrow);
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"outentryentity", (CharSequence)entryGrid.getKey())) {
            DynamicObject entryentity = this.getModel().getEntryRowEntity("outentryentity", evt.getRow());
            this.showEntryDetial(entryentity);
            this.showPropertyByTransfertype(evt.getRow());
            this.selectInEntryRow(evt.getRow());
        }
        if (StringUtils.equals((CharSequence)"inentryentity", (CharSequence)entryGrid.getKey())) {
            this.selectOutEntryRow(evt.getRow());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fileName = evt.getProperty().getName();
        if ("transferredout".equals(fileName) || "transferredin".equals(fileName)) {
            QFilter qFilter = QFilter.like((String)"bizfunction", (String)"1");
            QFilter qFilter1 = new QFilter("purchasehold", "=", (Object)"0");
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter.and(qFilter1));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.changebillname();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("outentryentity");
        int rowcount = this.getModel().getEntryRowCount("outentryentity");
        if (entryGrid != null && rowcount > 0) {
            entryGrid.selectRows(0, true);
            this.selectInEntryRow(0);
            DynamicObject entryentity = this.getModel().getEntryRowEntity("outentryentity", 0);
            this.showEntryDetial(entryentity);
            this.showPropertyByTransfertype(0);
        } else {
            this.showDefaultProperty();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String billtype;
        FormOperate formOperate = (FormOperate)e.getSource();
        if ("save".equals(formOperate.getOperateKey()) || "submit".equals(formOperate.getOperateKey())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("outentryentity");
            if (entryEntity.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f6c\u51fa\u5206\u5f55\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ProtransferBillTplEditPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                e.cancel = true;
            }
        } else if ("deleteentry".equals(formOperate.getOperateKey())) {
            int index = this.getModel().getEntryCurrentRowIndex("outentryentity");
            this.deleteEntryRow(index);
        } else if ("draw".equals(formOperate.getOperateKey()) && null != (billtype = this.getBillType())) {
            formOperate.getOption().setVariableValue("billtype", billtype);
        }
    }

    public int getSelectEntryRowIndex() {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("outentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.isIgnoreChangeListener.booleanValue()) {
            return;
        }
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        int currentIndex = this.getSelectEntryRowIndex();
        ChangeData[] changeArr = e.getChangeSet();
        Integer inrow = null;
        for (int i = 0; i < changeArr.length; ++i) {
            String entryFieldName;
            ChangeData changedata = changeArr[i];
            switch (propertyName) {
                case "biztype": {
                    int row = changedata.getRowIndex();
                    inrow = this.getInEntryRow(row);
                    if (inrow < 0) break;
                    model.setValue("inprocess", (Object)"", inrow.intValue());
                    model.setValue("inprocessid", (Object)"", inrow.intValue());
                    break;
                }
            }
            if (currentIndex <= -1 || !StringUtils.isNotEmpty((CharSequence)(entryFieldName = this.getFiledMaps().get(propertyName))) || currentIndex < 0) continue;
            this.getModel().setValue(entryFieldName, changedata.getNewValue(), currentIndex);
        }
    }

    private void deleteEntryRow(int index) {
        Integer inrow = this.getInEntryRow(index);
        if (inrow >= 0) {
            this.getModel().deleteEntryRow("inentryentity", inrow.intValue());
        }
    }

    protected Integer getInEntryRow(int index) {
        String outentryid = this.getModel().getValue("outentryentity.id", index).toString();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("inentryentity");
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String outentryentityid = dynamicObject.getString("outentryentityid");
            if (!outentryid.equals(outentryentityid)) continue;
            int row = dynamicObject.getInt("seq") - 1;
            return row < 0 ? 0 : row;
        }
        return -1;
    }

    protected Integer getOutEntryRow(int index) {
        String outentryid = this.getModel().getValue("outentryentityid", index).toString();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("outentryentity");
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String outentryentityid = dynamicObject.getString("id");
            if (!outentryid.equals(outentryentityid)) continue;
            return dynamicObject.getInt("seq") - 1;
        }
        return -1;
    }

    private void changebillname() {
        DynamicObjectCollection entryEntity;
        String billtype = this.getBillType();
        Boolean ischangename = Boolean.FALSE;
        if (null != billtype && "outprotransfer".equals(billtype)) {
            ischangename = Boolean.TRUE;
        } else if (null == billtype && (entryEntity = this.getModel().getEntryEntity("outentryentity")).size() > 0 && !"11".equals(((DynamicObject)entryEntity.get(0)).getString("transfertype"))) {
            ischangename = Boolean.TRUE;
        }
        if (ischangename.booleanValue()) {
            this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u5de5\u5e8f\u59d4\u5916\u8f6c\u79fb\u5355", (String)"ProtransferBillTplEditPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0])));
        }
    }

    private void showDefaultProperty() {
        Boolean isshow = Boolean.FALSE;
        String billtype = this.getBillType();
        if (null != billtype && "outprotransfer".equals(billtype)) {
            isshow = Boolean.TRUE;
        }
        this.getView().setVisible(isshow, notShowfileds);
    }

    private void showPropertyByTransfertype(int i) {
        if (i >= 0) {
            String transfertype = (String)this.getModel().getValue("transfertype", i);
            String biztype = (String)this.getModel().getValue("biztype", i);
            Boolean flag = ProtransferBiztypeEnum.SEQUENCE.getValue().equals(biztype) && ProtransferBillConsts.OUT_TRANSFERTYPE.contains(transfertype);
            Boolean reverseflag = ProtransferBiztypeEnum.REVERSESEQUENCE.getValue().equals(biztype) && ProtransferBillConsts.OUT_REVERSE_TRANSFERTYPE.contains(transfertype);
            if (flag.booleanValue() || reverseflag.booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, notShowfileds);
            } else {
                this.getView().setVisible(Boolean.FALSE, notShowfileds);
            }
        }
    }

    private String getBillType() {
        String billtype = null;
        if (null != this.getView().getFormShowParameter().getParentFormId() && !this.getView().getFormShowParameter().getParentFormId().equals("im_mdc_backflushform") && this.getView().getParentView() != null && this.getView().getParentView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter formShowParameter = (ListShowParameter)this.getView().getParentView().getFormShowParameter();
            billtype = (String)formShowParameter.getCustomParam("billtype");
        }
        return billtype;
    }

    public void initialize() {
        super.initialize();
    }

    private Map<String, String> getFiledMaps() {
        HashMap<String, String> fieldMaps = new HashMap<String, String>(256);
        fieldMaps.put("availableqty1", "availableqty");
        fieldMaps.put("transferqty1", "transferqty");
        fieldMaps.put("oprunit", "outoprunit");
        fieldMaps.put("qualifyqty", "outqualifyqty");
        fieldMaps.put("receiveqty", "outreceiveqty");
        fieldMaps.put("workwasteqty", "outworkwasteqty");
        fieldMaps.put("scrapqty", "outscrapqty");
        fieldMaps.put("reworkqty", "outreworkqty");
        fieldMaps.put("junkqty", "outjunkqty");
        fieldMaps.put("baseunit1", "baseunit");
        fieldMaps.put("availablebaseqty1", "availablebaseqty");
        fieldMaps.put("transferbaseqty1", "transferbaseqty");
        fieldMaps.put("qualifybaseqty", "outqualifybaseqty");
        fieldMaps.put("receivebaseqty", "outreceivebaseqty");
        fieldMaps.put("workwastebaseqty", "outworkwastebaseqty");
        fieldMaps.put("scrapbaseqty", "outscrapbaseqty");
        fieldMaps.put("reworkbaseqty", "outreworkbaseqty");
        fieldMaps.put("junkbaseqty", "outjunkbaseqty");
        return fieldMaps;
    }
}

