/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.manufacturemodel;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bd.mpdm.common.manuftech.utils.CheckPlanDateUtil;
import kd.bd.mpdm.common.mftorder.utils.ManuFactureTraceUtils;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class TechnicsTplListPlugin
extends AbstractListPlugin {
    protected static final String BILLLISTAP = "billlistap";
    protected static final String ROUTE_SYNC_OPEN = "syncProcessrouteDialog";
    protected static final String ROUTE_SYNC_FORM_ID = "sfc_manftch_route_dialog";
    protected static final String EXPEND_TIME = "expandtime";
    private static final Log logger = LogFactory.getLog(TechnicsTplListPlugin.class);

    public void initialize() {
        super.initialize();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String isshowtoolbarap = (String)formShowParameter.getCustomParam("isshowtoolbarap");
        if (null != isshowtoolbarap && "no".equals(isshowtoolbarap)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtercontainerap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarap"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"bar_dealbiz"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selects = billList.getSelectedRows();
        if (StringUtils.equals((CharSequence)ROUTE_SYNC_OPEN, (CharSequence)evt.getItemKey()) && selects != null && selects.size() > 0) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(ROUTE_SYNC_FORM_ID);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        formShowParameter.setHasRight(true);
        String isshowtoolbarap = (String)formShowParameter.getCustomParam("istmctracebillop");
        if (null != isshowtoolbarap && "yes".equals(isshowtoolbarap)) {
            List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
            commonFilterColumns.clear();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        FormOperate operate = (FormOperate)args.getSource();
        operate.getOption().setVariableValue("orderBillType", this.getOrderBillType());
        operate.getOption().setVariableValue("orderBillName", this.getOrderBillName());
        operate.getOption().setVariableValue("stockBillType", this.getStockBillType());
        if ("donothing".equalsIgnoreCase(operate.getType())) {
            ListSelectedRowCollection rowCollection = args.getListSelectedData();
            ArrayList<Object> message = new ArrayList<Object>(rowCollection.size());
            for (ListSelectedRow listSelectedRow : rowCollection) {
                if (!"oprentryentity".equals(listSelectedRow.getEntryEntityKey())) continue;
                message.add(listSelectedRow.getEntryPrimaryKeyValue());
            }
            operate.getOption().setVariableValue("operateOption", JSON.toJSONString(message));
        }
        this.checkIsBizOperation(args, key);
        if ("donothing_synchronization".equals(key)) {
            OperateOption option = operate.getOption();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object expendBomTime = formShowParameter.getCustomParams().get(EXPEND_TIME);
            option.setVariableValue(EXPEND_TIME, expendBomTime != null ? expendBomTime.toString() : null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        BillList list;
        super.afterDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("donothing_synchronization".equals(key)) {
            list = (BillList)this.getControl(BILLLISTAP);
            list.refresh();
        }
        list = (BillList)this.getControl(BILLLISTAP);
        list.refresh();
    }

    private void checkIsBizOperation(BeforeDoOperationEventArgs args, String operateKey) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selects = billList.getSelectedRows();
        StringBuilder errors = new StringBuilder();
        switch (operateKey) {
            case "donothing_synchronization": {
                break;
            }
            case "selectorder": {
                errors = this.validSelectOrder(billList, selects, args);
                break;
            }
            case "submit": {
                ArrayList<StringBuilder> messages = new ArrayList<StringBuilder>(10);
                ArrayList<String> errorsMsg = new ArrayList<String>();
                HashSet<Object> billPks = new HashSet<Object>(selects.size());
                for (int j = 0; j < selects.size(); ++j) {
                    billPks.add(selects.get(j).getPrimaryKeyValue());
                }
                QFilter qFilter = new QFilter("id", "in", billPks);
                DynamicObject[] load = BusinessDataServiceHelper.load((String)billList.getEntityId(), (String)TechnicsTplListPlugin.selectProperties(), (QFilter[])new QFilter[]{qFilter});
                for (int i = 0; i < load.length; ++i) {
                    DynamicObject obj = load[i];
                    DynamicObjectCollection dynamicObjectCollection = obj.getDynamicObjectCollection("oprentryentity");
                    if ("B".equals(obj.get("billstatus")) || "C".equals(obj.get("billstatus"))) continue;
                    for (int idx = 0; idx < dynamicObjectCollection.size(); ++idx) {
                        DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(idx);
                        DynamicObject dept = dynamicObject.getDynamicObject("oprorg");
                        if (dept != null) continue;
                        String info = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7684\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"TechnicsTplListPlugin_14", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), i + 1) + "\n";
                        errorsMsg.add(info);
                        args.setCancel(true);
                    }
                    StringBuilder planDate = CheckPlanDateUtil.checkPlanDate((DynamicObjectCollection)dynamicObjectCollection, null, null);
                    if (planDate.length() <= 0) continue;
                    messages.add(planDate);
                }
                if (!errorsMsg.isEmpty()) {
                    for (String string : errorsMsg) {
                        this.getView().showMessage(string);
                    }
                    args.setCancel(true);
                    return;
                }
                if (messages.size() <= 0) break;
                FormOperate source = (FormOperate)args.getSource();
                RefObject afterConfirm = new RefObject();
                for (int i = 0; i < messages.size(); ++i) {
                    if (source.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) continue;
                    ConfirmCallBackListener listener = new ConfirmCallBackListener("checkPlanDate", (IFormPlugin)this);
                    this.getView().showConfirm(((Object)messages).toString().substring(1, ((Object)messages).toString().length() - 2), MessageBoxOptions.YesNo, listener);
                    args.setCancel(true);
                    return;
                }
                break;
            }
        }
        if (errors.length() != 0) {
            args.setCancel(true);
            this.getView().showMessage(errors.toString());
        }
    }

    private StringBuilder validSelectOrder(BillList billList, ListSelectedRowCollection selects, BeforeDoOperationEventArgs args) {
        QFilter qfilter;
        ArrayList<Long> numberList = new ArrayList<Long>();
        StringBuilder errors = new StringBuilder();
        selects = args.getListSelectedData();
        for (int i = 0; i < selects.size(); ++i) {
            Object billPK = selects.get(i).getPrimaryKeyValue();
            qfilter = new QFilter("id", "=", billPK);
            DynamicObjectCollection col = QueryServiceHelper.query((String)billList.getEntityId(), (String)"id", (QFilter[])new QFilter[]{qfilter}, (String)"id");
            if (col.size() == 0) {
                String info = ResManager.loadKDString((String)"\u9009\u4e2d\u6570\u636e\u53d1\u751f\u6539\u53d8,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"TechnicsTplListPlugin_13", (String)"bd-mpdm-formplugin", (Object[])new Object[0]) + "\n";
                errors.append(info);
                continue;
            }
            DynamicObject technicsBill = BusinessDataServiceHelper.loadSingle((Object)billPK, (String)billList.getEntityId(), (String)"id,mftentryseq.id,org.id");
            if ("".equals(technicsBill.getString("mftentryseq.id"))) continue;
            numberList.add(technicsBill.getLong("mftentryseq.id"));
        }
        ArrayList<QFilter> qfilterList = new ArrayList<QFilter>();
        qfilter = new QFilter("treeentryentity.id", "in", numberList);
        qfilterList.add(qfilter);
        DynamicObject[] mftorders = BusinessDataServiceHelper.load((String)this.getOrderBillType(), (String)"id", (QFilter[])new QFilter[]{qfilter});
        if (mftorders.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u6765\u6e90\u751f\u4ea7\u5de5\u5355\u3002", (String)"TechnicsTplListPlugin_7", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        } else if (mftorders.length == 1) {
            this.getView().showForm((FormShowParameter)ManuFactureTraceUtils.createBillShowParam((String)this.getOrderBillType(), (Object)mftorders[0].getPkValue()));
        } else {
            this.getView().showForm((FormShowParameter)ManuFactureTraceUtils.createShowParam((String)this.getOrderBillType(), qfilterList));
        }
        return errors;
    }

    protected String getOrderBillType() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        if ("sfc_mromanuftech".equals(billList.getEntityId())) {
            return "pom_mroorder";
        }
        return "pom_mftorder";
    }

    protected String getOrderBillName() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        if ("sfc_mromanuftech".equals(billList.getEntityId())) {
            return ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u5355", (String)"TechnicsTplListPlugin_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355", (String)"TechnicsTplListPlugin_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]);
    }

    protected String getStockBillType() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        if ("sfc_mromanuftech".equals(billList.getEntityId())) {
            return "pom_mrostock";
        }
        return "pom_mftstock";
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result;
        if ("checkPlanDate".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)(result = messageBoxClosedEvent.getResult()))) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation("submit", operateOption);
        }
    }

    private static String selectProperties() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("id,");
        strBuilder.append("billstatus,");
        strBuilder.append("oprentryentity").append('.').append("oprorg").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprworkcenter").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprworkshop").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprplanbegintime").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprplanfinishtime").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprno").append(',');
        return strBuilder.toString();
    }
}

