/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.manufacturemodel;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bd.mpdm.common.transactproduct.helper.TransactProductEditHelper;
import kd.bd.mpdm.common.utils.MulBaseDataUtils;
import kd.bd.mpdm.formplugin.manufacturemodel.OMParameter;
import kd.bd.mpdm.formplugin.manufacturemodel.OMUtil;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class TransactionProductEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private OMUtil omUtil = new OMUtil();
    private OMParameter omp = new OMParameter();
    public static final String MPDM_TRANSACTPRODUCT = "mpdm_transactproduct";
    public static final String KEY_CREATEORG = "createorg";
    public static final String KEY_ISFAULT = "isfault";
    public static final String KEY_TRANSACTIONTYPE = "transactiontype";
    public static final String KEY_FLAG = "flag";

    public void afterCreateNewData(EventObject e) {
        String domain;
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        TransactProductEditHelper.setBizTypeValue((IFormView)view, (IDataModel)model, (String)KEY_TRANSACTIONTYPE);
        TransactProductEditHelper.setVisibleByDomain((IFormView)view, (IDataModel)model);
        DynamicObject biztype = (DynamicObject)this.getModel().getValue(KEY_TRANSACTIONTYPE);
        if (biztype != null && "7".equals(domain = biztype.getString("domain"))) {
            this.getModel().setValue("backflushtime", (Object)"B");
            this.getModel().setValue("stockmaterials", (Object)"C");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TransactProductEditHelper.setVisibleByDomain((IFormView)this.getView(), (IDataModel)this.getModel());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "isprocedure": {
                this.procedureChange();
                break;
            }
            case "executionmode": {
                break;
            }
            case "purbillmakemethod": {
                break;
            }
            case "isautomake": {
                break;
            }
            case "transactiontype": {
                TransactProductEditHelper.setVisibleByDomain((IFormView)this.getView(), (IDataModel)this.getModel());
                break;
            }
            case "isinnerprocess": {
                this.isInnerProcessChanged();
                break;
            }
            case "bomexpandconfig": {
                this.bomexpandconfigChanged();
                break;
            }
        }
    }

    private void bomexpandconfigChanged() {
        DynamicObject bomexpandconfig = (DynamicObject)this.getModel().getValue("bomexpandconfig");
        if (bomexpandconfig == null) {
            this.getModel().setValue("bomtypes", null);
        } else {
            DynamicObject expandconfig = BusinessDataServiceHelper.loadSingle((String)"mpdm_bomexpandconfig", (String)"number,entryentity,entryentity.bomtype", (QFilter[])new QFilter[]{new QFilter("id", "=", bomexpandconfig.getPkValue())});
            DynamicObjectCollection entryentity = expandconfig.getDynamicObjectCollection("entryentity");
            if (!entryentity.isEmpty()) {
                ArrayList<DynamicObject> bomTypeList = new ArrayList<DynamicObject>(16);
                for (DynamicObject entry : entryentity) {
                    if (entry.getDynamicObject("bomtype") == null) continue;
                    bomTypeList.add(entry.getDynamicObject("bomtype"));
                }
                this.getModel().setValue("bomtypes", (Object)MulBaseDataUtils.getMulBaseDataDyColl((String)MPDM_TRANSACTPRODUCT, (DynamicObject[])bomTypeList.toArray(new DynamicObject[0]), (String)"bomtypes", (String)"mpdm_bomtype"));
            } else {
                this.getModel().setValue("bomtypes", null);
            }
        }
    }

    private void procedureChange() {
        boolean flag = (Boolean)this.getModel().getValue("isprocedure");
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"isgentechnis"});
        if (flag) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"isprecedingprocess", "executionmode", "conversionrule", "isgentechnis"});
            this.getModel().setValue("executionmode", this.omp.getDefaultValue("executionmode"));
            this.omUtil.setMustInput(this.getView(), Boolean.TRUE, "executionmode");
            this.getModel().setValue("isgentechnis", (Object)Boolean.TRUE);
        } else {
            this.omUtil.setEnable(this.getView(), Boolean.FALSE, "conversionrule", "automaketime", "isautomake", "executionmode", "proctransmaketime", "purbillmakemethod", "isprecedingprocess");
            this.getModel().setValue("isprecedingprocess", this.omp.getDefaultValue("isprecedingprocess"));
            this.setModelValueIsNull("executionmode", "proctransmaketime", "purbillmakemethod");
            this.omUtil.setMustInput(this.getView(), Boolean.FALSE, "executionmode");
            this.getView().setEnable(Boolean.FALSE, new String[]{"isgentechnis"});
            this.getModel().setValue("isgentechnis", (Object)Boolean.FALSE);
        }
    }

    private void isInnerProcessChanged() {
        boolean isinnerprocess = (Boolean)this.getModel().getValue("isinnerprocess");
        this.getModel().beginInit();
        if (isinnerprocess) {
            this.getModel().setValue("stockmaterials", (Object)"C");
            this.getModel().setValue("isproceduremust", (Object)Boolean.FALSE);
        } else {
            this.getModel().setValue("stockmaterials", (Object)"A");
        }
        this.getModel().endInit();
        this.getView().updateView("stockmaterials");
        this.getView().updateView("isproceduremust");
    }

    private void setModelValueIsNull(String ... strings) {
        for (String string : strings) {
            this.getModel().setValue(string, null);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit purBillGenManner = (BasedataEdit)this.getControl("conversionrule");
        purBillGenManner.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizType = (BasedataEdit)this.getControl(KEY_TRANSACTIONTYPE);
        bizType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propertyName;
        switch (propertyName = e.getProperty().getName()) {
            case "conversionrule": {
                this.setAutoMakeBillTypeFilter(e);
                break;
            }
        }
    }

    private void setAutoMakeBillTypeFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        Object purBillMakeMethod = this.getModel().getValue("purbillmakemethod");
        if (purBillMakeMethod == null) {
            return;
        }
        QFilter autoMakeBillTypeQfilter = this.omp.getAutoMakeBillTypeQfilter(purBillMakeMethod.toString());
        if (autoMakeBillTypeQfilter != null) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(autoMakeBillTypeQfilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": 
            case "submit": {
                this.beforeSaveOrSubmit(args, operate);
                break;
            }
        }
    }

    private void beforeSaveOrSubmit(BeforeDoOperationEventArgs args, FormOperate operate) {
        if (this.isFirstDoPayment(operate)) {
            DynamicObject createorgInfo = (DynamicObject)this.getModel().getValue(KEY_CREATEORG);
            DynamicObject transactiontypeInfo = (DynamicObject)this.getModel().getValue(KEY_TRANSACTIONTYPE);
            QFilter[] filters = new QFilter[]{new QFilter(KEY_CREATEORG, "=", createorgInfo.getPkValue()), new QFilter(KEY_TRANSACTIONTYPE, "=", transactiontypeInfo.getPkValue()), new QFilter(KEY_ISFAULT, "=", (Object)"1"), new QFilter("number", "!=", this.getModel().getValue("number"))};
            DynamicObject[] cols = BusinessDataServiceHelper.load((String)MPDM_TRANSACTPRODUCT, (String)"id,number,isfault", (QFilter[])filters);
            if (cols.length > 0 && !"C".equals(this.getModel().getValue("status"))) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operate.getOperateKey(), (IFormPlugin)this);
                String msg = ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\uff08%1$s\uff09\u5df2\u8bbe\u7f6e\u9ed8\u8ba4\u7684%2$s\u4e8b\u52a1\u7c7b\u578b\uff0c\u662f\u5426\u9700\u8981\u91cd\u65b0\u8bbe\u7f6e\uff1f", (String)"TransactionProductEditPlugin_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]);
                String orgName = createorgInfo.getString("name");
                String biztypeName = transactiontypeInfo.getString("name");
                this.getView().showConfirm(String.format(msg, orgName, biztypeName), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
                operate.getOption().setVariableValue(KEY_FLAG, "true");
            }
        }
        if (Boolean.TRUE.equals(this.getModel().getValue(KEY_ISFAULT))) {
            this.getModel().setValue(KEY_ISFAULT, (Object)Boolean.FALSE);
            this.getModel().setValue(KEY_ISFAULT, (Object)Boolean.TRUE);
        }
    }

    private boolean isFirstDoPayment(FormOperate operate) {
        RefObject afterConfirm = new RefObject();
        return (Boolean)this.getModel().getValue(KEY_ISFAULT) != false && !operate.getOption().tryGetVariableValue(KEY_FLAG, afterConfirm);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (("save".equals(event.getCallBackId()) || "submit".equals(event.getCallBackId())) && event.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(KEY_FLAG, "true");
            DynamicObject createorgInfo = (DynamicObject)this.getModel().getValue(KEY_CREATEORG);
            DynamicObject transactiontypeInfo = (DynamicObject)this.getModel().getValue(KEY_TRANSACTIONTYPE);
            QFilter[] filters = new QFilter[]{new QFilter(KEY_CREATEORG, "=", createorgInfo.getPkValue()), new QFilter(KEY_TRANSACTIONTYPE, "=", transactiontypeInfo.getPkValue()), new QFilter(KEY_ISFAULT, "=", (Object)"1")};
            DynamicObject[] cols = BusinessDataServiceHelper.load((String)MPDM_TRANSACTPRODUCT, (String)"id,number,isfault", (QFilter[])filters);
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(cols.length);
            for (DynamicObject info : cols) {
                info.set(KEY_ISFAULT, (Object)"0");
                saveList.add(info);
            }
            DynamicObject[] saveLi = new DynamicObject[saveList.size()];
            for (int i = 0; i < saveList.size(); ++i) {
                saveLi[i] = (DynamicObject)saveList.get(i);
            }
            SaveServiceHelper.save((DynamicObject[])saveLi);
            this.getView().invokeOperation(event.getCallBackId(), operateOption);
        }
    }
}

