/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.manufacturemodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class TransactionProductPlugin
extends StandardTreeListPlugin
implements TreeNodeClickListener {
    public static final String MPDM_TRANSACTPRODUCT = "mpdm_transactproduct";
    public static final String KEY_BILLLISTAP = "billlistap";
    public static final String KEY_CREATEORG = "createorg";
    public static final String KEY_ISFAULT = "isfault";
    public static final String KEY_TRANSACTIONTYPE = "transactiontype";

    public void initialize() {
        super.initialize();
        TreeView tree = (TreeView)this.getControl("treeview");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTree();
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnedit"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"btndel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"searchap"});
    }

    private void initTree() {
        TreeNode root = this.getTreeModel().getRoot();
        QFilter[] filter = new QFilter[2];
        filter[0] = new QFilter("enable", "=", (Object)"1");
        HashSet<String> domain = new HashSet<String>(3);
        domain.add("3");
        domain.add("5");
        domain.add("7");
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("pom".equalsIgnoreCase(appId)) {
            domain.clear();
            domain.add("3");
        }
        filter[1] = new QFilter("domain", "in", domain);
        this.addSubNodes(root, appId);
        Map biztypeInfo = BusinessDataServiceHelper.loadFromCache((String)"bd_biztype", (String)"id,name,number,domain", (QFilter[])filter);
        for (Map.Entry entry : biztypeInfo.entrySet()) {
            DynamicObject data = (DynamicObject)entry.getValue();
            String lv2nodeID = data.getString("domain");
            TreeNode tr = new TreeNode();
            tr.setParentid(lv2nodeID);
            tr.setText(data.getString("name"));
            tr.setId(data.getPkValue().toString());
            TreeNode subnode = root.getTreeNode(lv2nodeID);
            subnode.addChild(tr);
        }
    }

    private void addSubNodes(TreeNode root, String appId) {
        TreeNode tr3 = new TreeNode();
        tr3.setParentid(root.getId());
        tr3.setText(ResManager.loadKDString((String)"\u751f\u4ea7", (String)"TransactionProductPlugin_54", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        tr3.setId("3");
        root.addChild(tr3);
        if (!"pom".equalsIgnoreCase(appId)) {
            TreeNode tr5 = new TreeNode();
            tr5.setParentid(root.getId());
            tr5.setText(ResManager.loadKDString((String)"\u59d4\u5916", (String)"TransactionProductPlugin_55", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            tr5.setId("5");
            root.addChild(tr5);
            TreeNode tr7 = new TreeNode();
            tr7.setParentid(root.getId());
            tr7.setText(ResManager.loadKDString((String)"\u68c0\u4fee", (String)"TransactionProductPlugin_56", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            tr7.setId("7");
            root.addChild(tr7);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        String nodeid = (String)evt.getNodeId();
        this.getPageCache().put("domainid", nodeid);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("fault".equals(operateKey)) {
            this.setFaultTansaction();
            this.initTree();
        }
        if ("refresh".equals(operateKey)) {
            this.initTree();
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String nodeid = (String)this.getTreeModel().getCurrentNodeId();
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        switch (nodeid) {
            case "8609760E-EF83-4775-A9FF-CCDEC7C0B689": {
                filter.add(new QFilter("id", "!=", (Object)Long.valueOf("0")));
                String appId = this.getView().getFormShowParameter().getAppId();
                if (!"pom".equalsIgnoreCase(appId)) break;
                filter.add(new QFilter("transactiontype.domain", "=", (Object)"3"));
                break;
            }
            case "3": 
            case "5": 
            case "7": {
                filter.add(new QFilter("transactiontype.domain", "=", (Object)nodeid));
                break;
            }
            default: {
                filter.add(new QFilter(KEY_TRANSACTIONTYPE, "=", (Object)Long.valueOf(nodeid)));
            }
        }
        e.setCustomQFilters(filter);
    }

    private void setFaultTansaction() {
        BillList grid = (BillList)this.getView().getControl(KEY_BILLLISTAP);
        ListSelectedRowCollection rowCollection = grid.getSelectedRows();
        if (rowCollection.size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u9ed8\u8ba4\u53ea\u80fd\u5355\u884c\u64cd\u4f5c\u3002", (String)"TransactionProductPlugin_45", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow row = rowCollection.get(0);
        long id = (Long)row.getPrimaryKeyValue();
        DynamicObject transactInfo = BusinessDataServiceHelper.loadSingle((Object)id, (String)MPDM_TRANSACTPRODUCT);
        String enable = transactInfo.getString("enable");
        String status = transactInfo.getString("status");
        if (!"C".equals(status)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u624d\u80fd\u8bbe\u7f6e\u9ed8\u8ba4\u3002", (String)"TransactionProductPlugin_46", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("0".equals(enable)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7981\u7528\u72b6\u6001\u4e0d\u80fd\u8bbe\u7f6e\u9ed8\u8ba4\u3002", (String)"TransactionProductPlugin_47", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (transactInfo.getBoolean(KEY_ISFAULT)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b%1$s\uff0c\u5df2\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"TransactionProductPlugin_57", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), transactInfo.getString("number")));
            return;
        }
        DynamicObject createorgInfo = (DynamicObject)transactInfo.get(KEY_CREATEORG);
        DynamicObject transactiontypeInfo = (DynamicObject)transactInfo.get(KEY_TRANSACTIONTYPE);
        QFilter[] filters = new QFilter[]{new QFilter(KEY_CREATEORG, "=", createorgInfo.getPkValue()), new QFilter(KEY_TRANSACTIONTYPE, "=", transactiontypeInfo.getPkValue()), new QFilter(KEY_ISFAULT, "=", (Object)"1")};
        DynamicObject[] cols = BusinessDataServiceHelper.load((String)MPDM_TRANSACTPRODUCT, (String)"id,number,isfault", (QFilter[])filters);
        if (cols.length > 0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirm", (IFormPlugin)this);
            String orgName = createorgInfo.getString("name");
            String transactionTypeName = transactiontypeInfo.getString("name");
            String tipMsg = String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7:%1$s\u5df2\u8bbe\u7f6e\u9ed8\u8ba4\u7684%2$s\u4e8b\u52a1\u7c7b\u578b\uff0c\u662f\u5426\u9700\u8981\u91cd\u65b0\u8bbe\u7f6e\uff1f", (String)"TransactionProductPlugin_52", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), orgName, transactionTypeName);
            this.getView().showConfirm(tipMsg, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        } else {
            transactInfo.set(KEY_ISFAULT, (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{transactInfo});
            grid.refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6210\u529f\u3002", (String)"TransactionProductPlugin_53", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if ("confirm".equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            BillList grid = (BillList)this.getView().getControl(KEY_BILLLISTAP);
            ListSelectedRowCollection rowCollection = grid.getSelectedRows();
            ListSelectedRow row = rowCollection.get(0);
            long id = (Long)row.getPrimaryKeyValue();
            DynamicObject transactInfo = BusinessDataServiceHelper.loadSingle((Object)id, (String)MPDM_TRANSACTPRODUCT);
            DynamicObject createorgInfo = (DynamicObject)transactInfo.get(KEY_CREATEORG);
            DynamicObject transactiontypeInfo = (DynamicObject)transactInfo.get(KEY_TRANSACTIONTYPE);
            QFilter[] filters = new QFilter[]{new QFilter(KEY_CREATEORG, "=", createorgInfo.getPkValue()), new QFilter(KEY_TRANSACTIONTYPE, "=", transactiontypeInfo.getPkValue()), new QFilter(KEY_ISFAULT, "=", (Object)"1")};
            DynamicObject[] cols = BusinessDataServiceHelper.load((String)MPDM_TRANSACTPRODUCT, (String)"id,number,isfault", (QFilter[])filters);
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(cols.length);
            for (DynamicObject info : cols) {
                info.set(KEY_ISFAULT, (Object)"0");
                saveList.add(info);
            }
            transactInfo.set(KEY_ISFAULT, (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{transactInfo});
            DynamicObject[] saveLi = new DynamicObject[saveList.size()];
            for (int i = 0; i < saveList.size(); ++i) {
                saveLi[i] = (DynamicObject)saveList.get(i);
            }
            SaveServiceHelper.save((DynamicObject[])saveLi);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6210\u529f\u3002", (String)"TransactionProductPlugin_53", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            grid.refresh();
        }
    }
}

