/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.materialplan;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import kd.bd.mpdm.common.colsassist.SelectParams;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ColsTreeSelectPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private SelectParams params;

    private SelectParams getParams() {
        if (this.params == null) {
            this.params = new SelectParams();
            this.params.fillByFormShowParameter(this.getView().getFormShowParameter().getCustomParams());
        }
        return this.params;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.bindTree();
    }

    private void bindTree() {
        TreeNode rootNode = this.parseTree();
        TreeView tree = (TreeView)this.getView().getControl("tree");
        tree.addNode(rootNode);
        boolean isMulti = this.getParams().isMulti();
        tree.setMulti(isMulti);
        this.getView().setEnable(Boolean.valueOf(!isMulti), new String[]{"filterap"});
        this.getView().setVisible(Boolean.valueOf(!isMulti), new String[]{"filterap"});
    }

    private static String getMsgColsTreeSelectNotObj() {
        return ResManager.loadKDString((String)"\u6ca1\u6709\u6307\u5b9a\u5b9e\u4f53\u5bf9\u8c61\u3002", (String)"ColsTreeSelectPlugin_4", (String)"bd-mpdm-formplugin", (Object[])new Object[0]);
    }

    private static String getMsgColsTreeSelectFieldFail() {
        return ResManager.loadKDString((String)"\u5b57\u6bb5\u6811\u89e3\u6790\u5931\u8d25\u3002", (String)"ColsTreeSelectPlugin_5", (String)"bd-mpdm-formplugin", (Object[])new Object[0]);
    }

    private TreeNode parseTree() {
        String treeStr = this.getParams().getJsonTree();
        if (StringUtils.isBlank((CharSequence)treeStr)) {
            return new TreeNode("", "0", ColsTreeSelectPlugin.getMsgColsTreeSelectNotObj());
        }
        TreeNode rootNode = null;
        try {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)treeStr, TreeNode.class);
        }
        catch (Exception e) {
            rootNode = new TreeNode("", "0", ColsTreeSelectPlugin.getMsgColsTreeSelectFieldFail());
            Log log = LogFactory.getLog(ColsTreeSelectPlugin.class);
            log.error(String.format("\u5b57\u6bb5\u6811\u89e3\u6790\u5931\u8d25:jsonTree[%s]", treeStr), (Throwable)e);
        }
        return rootNode;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "ok": {
                this.clickOK();
                break;
            }
            case "cancel": {
                this.clickCancel();
                break;
            }
        }
    }

    private void clickCancel() {
        this.getView().close();
    }

    private void clickOK() {
        List<String> ids = this.getSelectedNodeId();
        JSONArray returnInfo = this.getReturnInfo(ids);
        this.getView().returnDataToParent((Object)returnInfo.toJSONString());
        this.getView().close();
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (this.getParams().isMulti()) {
            return;
        }
        String currNodeId = (String)e.getNodeId();
        if (StringUtils.isBlank((CharSequence)currNodeId)) {
            currNodeId = "";
        }
        this.getPageCache().put("selectedNodeIds", currNodeId);
    }

    private List<String> getSelectedNodeId() {
        TreeView tree = (TreeView)this.getControl("tree");
        TreeView.TreeState treeState = tree.getTreeState();
        if (this.getParams().isMulti()) {
            return treeState.getCheckedNodeIds();
        }
        ArrayList<String> ids = new ArrayList<String>();
        String nodeId = treeState.getFocusNodeId();
        ids.add(nodeId);
        return ids;
    }

    private JSONArray getReturnInfo(List<String> ids) {
        JSONArray infos = new JSONArray();
        if (ids == null) {
            return infos;
        }
        TreeNode tree = this.parseTree();
        for (String id : ids) {
            TreeNode node;
            if ("0".equals(id) || (node = tree.getTreeNode(id, 6)) == null) continue;
            JSONObject info = new JSONObject(2);
            info.put("id", (Object)node.getId());
            info.put("text", (Object)node.getText());
            infos.add((Object)info);
        }
        return infos;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"cancel", "ok"});
        Search search = (Search)this.getControl("search");
        search.addEnterListener((SearchEnterListener)this);
        TreeView tree = (TreeView)this.getControl("tree");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    private static String getMsgColsTreeSelectCompleteNoSel() {
        return ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"ColsTreeSelectPlugin_6", (String)"bd-mpdm-formplugin", (Object[])new Object[0]);
    }

    private static String getMsgColsTreeSelectComplete() {
        return ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\u3002", (String)"ColsTreeSelectPlugin_7", (String)"bd-mpdm-formplugin", (Object[])new Object[0]);
    }

    public void search(SearchEnterEvent e) {
        List treeNodes;
        String searchText = e.getText();
        TreeNode rootNode = this.parseTree();
        IPageCache pageCache = this.getPageCache();
        String pageId = this.getView().getPageId();
        String searchNodesCacheKey = pageId + "_searchNodes";
        String matchNodesCacheKey = pageId + "_matchNodes";
        String oldSearchTextCacheKey = pageId + "_oldSearchText";
        String searchIndexCacheKey = pageId + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(ColsTreeSelectPlugin.getMsgColsTreeSelectCompleteNoSel());
        } else {
            TreeView treeView = (TreeView)this.getView().getControl("tree");
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache < treeNodes.size()) {
                    treeView.treeNodeClick(((TreeNode)treeNodes.get(indexCache)).getParentid(), ((TreeNode)treeNodes.get(indexCache)).getId());
                    treeView.showNode(((TreeNode)treeNodes.get(indexCache)).getParentid());
                    treeView.focusNode((TreeNode)treeNodes.get(indexCache));
                    pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                } else {
                    this.getView().showTipNotification(ColsTreeSelectPlugin.getMsgColsTreeSelectComplete());
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
            } else {
                treeView.treeNodeClick(((TreeNode)treeNodes.get(0)).getParentid(), ((TreeNode)treeNodes.get(0)).getId());
                treeView.showNode(((TreeNode)treeNodes.get(0)).getParentid());
                treeView.focusNode((TreeNode)treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }
}

