/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.materialplan;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.constant.StatusEnum;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class MaterialPlanBatchUpdPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(MaterialPlanBatchUpdPlugin.class);
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String BATCHUPDFIELD = "batchupdfield";
    private static final ThreadLocal<SimpleDateFormat> DATETIME = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    private final int count = 200;
    private static final String BATCHUPD_COUNT = "batchupdcount";
    private static final String BATCHUPD_SUM = "batchupdnumber";
    private static final String BATCHUPD_SUCCESS_COUNT = "batchupdsuccesscount";
    private static final String BATCHUPD_SUCCESS_BIllNO = "batchupdsuccessbillno";
    private static final String BATCHUPD_FAILD_COUNT = "batchupdfaildcount";
    private static final String BATCHOPERA = "batchopera";
    private static final String NEWVALUE = "newvalue";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String MPDM_BATCH_EDIT = "mpdm_batch_edit";
    private static final String MPDM_BATCHUPDFIELD = "mpdm_batchupdfield";
    private static final String UPDATEEXTFIELD = "updateextfield";
    private static final String PLAN_ISLOG = "plan_islog";
    private static final String CACHEKEY_ERROR = "error";
    private static final String CACHEKEY_ERRORMSG = "errorMsg";

    private String getTip() {
        String tip = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6279\u91cf\u4fee\u6539%1$d/%2$d\u6761", (String)"MaterialPlanBatchUpdPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), this.getDropCount(), this.getDropSum());
        return tip;
    }

    private int getProgress() {
        int sum;
        int count = StringUtils.isBlank((Object)this.getDropCount()) ? 0 : this.getDropCount();
        int n = sum = StringUtils.isBlank((Object)this.getDropSum()) ? 0 : this.getDropSum();
        if (sum == 0) {
            return 0;
        }
        return count * 100 / sum;
    }

    private synchronized void setDropCount(int batchupdcount) {
        int oldbatchupdcount = this.getDropCount();
        int oldcount = StringUtils.isBlank((Object)oldbatchupdcount) ? 0 : oldbatchupdcount;
        this.getPageCache().put(BATCHUPD_COUNT, String.valueOf(oldcount + batchupdcount));
    }

    private synchronized int getDropCount() {
        return StringUtils.isBlank((CharSequence)this.getPageCache().get(BATCHUPD_COUNT)) ? 0 : Integer.parseInt(this.getPageCache().get(BATCHUPD_COUNT));
    }

    private void setDropSum(int batchupdsum) {
        this.getPageCache().put(BATCHUPD_SUM, String.valueOf(batchupdsum));
    }

    private int getDropSum() {
        return StringUtils.isBlank((CharSequence)this.getPageCache().get(BATCHUPD_SUM)) ? 0 : Integer.parseInt(this.getPageCache().get(BATCHUPD_SUM));
    }

    private synchronized void setDropSuccessCount(int batchupdsuccesscount, String batchupdSuccessBillno) {
        int oldbatchupdsuccesscount = this.getDropSuccessCount();
        int oldsuccesscount = StringUtils.isBlank((Object)oldbatchupdsuccesscount) ? 0 : oldbatchupdsuccesscount;
        this.getPageCache().put(BATCHUPD_SUCCESS_COUNT, String.valueOf(batchupdsuccesscount + oldsuccesscount));
        String billno = this.getDropSuccessBillno();
        if (StringUtils.isBlank((CharSequence)billno)) {
            this.getPageCache().put(BATCHUPD_SUCCESS_BIllNO, batchupdSuccessBillno);
        } else {
            this.getPageCache().put(BATCHUPD_SUCCESS_BIllNO, String.valueOf(billno + "###" + batchupdSuccessBillno));
        }
    }

    private String getDropSuccessBillno() {
        return this.getPageCache().get(BATCHUPD_SUCCESS_BIllNO);
    }

    private int getDropSuccessCount() {
        return StringUtils.isBlank((CharSequence)this.getPageCache().get(BATCHUPD_SUCCESS_COUNT)) ? 0 : Integer.parseInt(this.getPageCache().get(BATCHUPD_SUCCESS_COUNT));
    }

    private synchronized void setDropFaildCount(int batchupdfaildcount) {
        int oldbatchupdfaildcount = this.getDropFaildCount();
        int oldfaildcount = StringUtils.isBlank((Object)oldbatchupdfaildcount) ? 0 : oldbatchupdfaildcount;
        this.getPageCache().put(BATCHUPD_FAILD_COUNT, String.valueOf(batchupdfaildcount + oldfaildcount));
    }

    private synchronized int getDropFaildCount() {
        return StringUtils.isBlank((CharSequence)this.getPageCache().get(BATCHUPD_FAILD_COUNT)) ? 0 : Integer.parseInt(this.getPageCache().get(BATCHUPD_FAILD_COUNT));
    }

    private synchronized void setError(String errorMsg) {
        this.getPageCache().put(CACHEKEY_ERROR, String.valueOf(true));
        if (this.getPageCache().get(CACHEKEY_ERRORMSG) != null) {
            String error = this.getPageCache().get(CACHEKEY_ERRORMSG);
            StringBuilder sb = new StringBuilder();
            sb.append(error);
            sb.append("###");
            sb.append(errorMsg);
            this.getPageCache().put(CACHEKEY_ERRORMSG, sb.toString());
        } else {
            this.getPageCache().put(CACHEKEY_ERRORMSG, errorMsg);
        }
    }

    private void settaskid(String taskid) {
        this.getPageCache().put("taskid", taskid);
    }

    private String gettaskid() {
        return this.getPageCache().get("taskid");
    }

    public static <T> List<List<T>> averageAssign(List<T> source, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int remainder = source.size() % n;
        int number = source.size() / n;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            List<T> value = null;
            if (remainder > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remainder;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            if (value == null || value.size() <= 0) continue;
            result.add(value);
        }
        return result;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
        if (progressBar != null) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
    }

    private void execute(List<Long> materialPlanIds, DynamicObject batchopera, Object newValue, String entitynumber, Map<String, Object> extFields) {
        String threadname = Thread.currentThread().getName();
        if (materialPlanIds != null && materialPlanIds.size() > 0) {
            this.settaskid(String.valueOf(materialPlanIds.size()));
            try {
                DynamicObject[] updates;
                HashMap planOrderIdBillNo = Maps.newHashMapWithExpectedSize((int)materialPlanIds.size());
                HashMap errors = new HashMap(materialPlanIds.size());
                for (DynamicObject update : updates = BusinessDataServiceHelper.load((String)entitynumber, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", materialPlanIds)})) {
                    Long planorderId = update.getLong("id");
                    if (!errors.containsKey(planorderId)) continue;
                    errors.remove(planorderId);
                }
                Map<String, Object> result = this.batchUpdate(materialPlanIds, entitynumber, batchopera, newValue, extFields, planOrderIdBillNo);
                Map errorMap = (Map)result.get(CACHEKEY_ERROR);
                List successIds = (List)result.get("success");
                errorMap.putAll(errors);
                for (Map.Entry entry : planOrderIdBillNo.entrySet()) {
                    Long planOrderId = (Long)entry.getKey();
                    String error = (String)errorMap.get(planOrderId);
                    if (StringUtils.isNotBlank((CharSequence)error)) {
                        this.setError(error);
                        this.setDropFaildCount(1);
                        this.setDropCount(1);
                        continue;
                    }
                    if (successIds.contains(planOrderId)) {
                        this.setDropCount(1);
                        this.setDropSuccessCount(1, (String)entry.getValue());
                        continue;
                    }
                    this.setDropFaildCount(1);
                    this.setDropCount(1);
                }
            }
            catch (Exception ex) {
                int size = materialPlanIds.size();
                this.setError(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u4fe1\u606f\u6279\u91cf\u4fee\u6539\u5931\u8d25%s", (String)"MaterialPlanBatchUpdPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), ex.getMessage()));
                this.setDropFaildCount(size);
                this.setDropCount(size);
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        logger.info("\u7ebf\u7a0b" + threadname + "\u7684\u7ed3\u675f\u65f6\u95f4\u4e3a" + new Date());
    }

    /*
     * Could not resolve type clashes
     */
    public Map<String, Object> batchUpdate(List<Long> dataIds, String entityNumber, DynamicObject property, Object newValue, Map<String, Object> extFields, Map<Long, String> planOrderIdBillNo) {
        StringBuilder error;
        DynamicObject[] datas;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String dbField = property.getString("field");
        HashMap errorMap = Maps.newHashMapWithExpectedSize((int)100);
        result.put(CACHEKEY_ERROR, errorMap);
        ArrayList<Long> successIds = new ArrayList<Long>(dataIds.size());
        result.put("success", successIds);
        HashMap<Long, List> orgDataMap = new HashMap<Long, List>(100);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DynamicProperty pro = dataEntityType.getProperty(dbField);
        if (pro == null) {
            for (Long dataId : dataIds) {
                errorMap.put(dataId, ResManager.loadKDString((String)"\u8ba1\u5212\u4fe1\u606f\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u9009\u62e9\u7684\u5b57\u6bb5\u4e0d\u5b58\u5728\u3002", (String)"MaterialPlanBatchUpdPlugin_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
            return result;
        }
        HashSet<Object> materialInfoIds = new HashSet<Object>();
        for (DynamicObject data : datas = BusinessDataServiceHelper.load((Object[])dataIds.toArray(new Object[0]), (DynamicObjectType)dataEntityType)) {
            DynamicObject org = data.getDynamicObject("createorg");
            Long orgId = org.getLong("id");
            planOrderIdBillNo.put(data.getLong("id"), data.getString("number"));
            orgDataMap.computeIfAbsent(orgId, k -> new ArrayList()).add(data);
        }
        ArrayList<DynamicObject> updateOrders = new ArrayList<DynamicObject>();
        for (Map.Entry orgDatas : orgDataMap.entrySet()) {
            List orderDatas = (List)orgDatas.getValue();
            for (DynamicObject data : orderDatas) {
                Long dataId = data.getLong("id");
                String number = data.getString("number");
                String leadtimetype = "";
                String lotpolicy = "";
                String planmode = "";
                switch (dbField) {
                    case "materialattr": {
                        String materialattr = data.getString("materialattr");
                        if ("10060".equals(materialattr)) {
                            data.set("supplynetwork", null);
                        } else {
                            materialInfoIds.add(dataId);
                        }
                        data.set(dbField, newValue);
                        break;
                    }
                    case "leadtimetype": {
                        leadtimetype = data.getString("leadtimetype");
                        if ("A".equals(leadtimetype)) {
                            data.set("changeleadtime", (Object)BigDecimal.ZERO);
                            data.set("changebatch", (Object)BigDecimal.ZERO);
                        } else if ("B".equals(leadtimetype)) {
                            data.set("fixedleadtime", (Object)BigDecimal.ZERO);
                        } else {
                            data.set("changeleadtime", (Object)BigDecimal.ZERO);
                            data.set("changebatch", (Object)BigDecimal.ZERO);
                            data.set("fixedleadtime", (Object)BigDecimal.ZERO);
                        }
                        data.set(dbField, newValue);
                        break;
                    }
                    case "fixedleadtime": {
                        leadtimetype = data.getString("leadtimetype");
                        if ("B".equals(leadtimetype)) {
                            errorMap.put(dataId, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u4fe1\u606f\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u4fe1\u606f\u7269\u6599\u7f16\u7801\u201c%s\u201d\u63d0\u524d\u671f\u7c7b\u578b\u4e3a\u53d8\u52a8\u63d0\u524d\u671f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"MaterialPlanBatchUpdPlugin_14", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), number));
                            break;
                        }
                        data.set(dbField, newValue);
                        break;
                    }
                    case "changeleadtime": 
                    case "changebatch": {
                        leadtimetype = data.getString("leadtimetype");
                        if ("A".equals(leadtimetype)) {
                            errorMap.put(dataId, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u4fe1\u606f\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u4fe1\u606f\u7269\u6599\u7f16\u7801\u201c%s\u201d\u63d0\u524d\u671f\u7c7b\u578b\u4e3a\u56fa\u5b9a\u63d0\u524d\u671f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"MaterialPlanBatchUpdPlugin_15", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), number));
                            break;
                        }
                        data.set(dbField, newValue);
                        break;
                    }
                    case "lotpolicy": {
                        lotpolicy = data.getString("lotpolicy");
                        if ("A".equals(lotpolicy)) {
                            data.set("batchqty", (Object)BigDecimal.ZERO);
                            data.set("partitionbase", (Object)BigDecimal.ZERO);
                            data.set("dynamiccycle", (Object)BigDecimal.ZERO);
                            data.set("fixedperiod", (Object)BigDecimal.ZERO);
                            data.set("specifiedperiod", null);
                        } else if ("B".equals(lotpolicy)) {
                            data.set("batchqty", (Object)BigDecimal.ZERO);
                            data.set("partitionbase", (Object)BigDecimal.ZERO);
                            data.set("minlotsize", (Object)BigDecimal.ZERO);
                            data.set("maxlotsize", (Object)BigDecimal.ZERO);
                            data.set("dynamiccycle", (Object)BigDecimal.ZERO);
                            data.set("fixedperiod", (Object)BigDecimal.ZERO);
                            data.set("specifiedperiod", null);
                        } else if ("C".equals(lotpolicy)) {
                            data.set("batchqty", (Object)BigDecimal.ZERO);
                            data.set("partitionbase", (Object)BigDecimal.ZERO);
                        }
                        data.set(dbField, newValue);
                        break;
                    }
                    case "dynamiccycle": {
                        if (!this.checkLotpolicy(data, dataId, errorMap, number)) break;
                        data.set("fixedperiod", (Object)BigDecimal.ZERO);
                        data.set("specifiedperiod", null);
                        break;
                    }
                    case "fixedperiod": {
                        if (!this.checkLotpolicy(data, dataId, errorMap, number)) break;
                        data.set(dbField, newValue);
                        data.set("dynamiccycle", (Object)BigDecimal.ZERO);
                        data.set("specifiedperiod", null);
                        break;
                    }
                    case "specifiedperiod": {
                        if (!this.checkLotpolicy(data, dataId, errorMap, number)) break;
                        data.set(dbField, newValue);
                        data.set("dynamiccycle", (Object)BigDecimal.ZERO);
                        data.set("fixedperiod", (Object)BigDecimal.ZERO);
                        break;
                    }
                    case "partitionbase": 
                    case "minlotsize": 
                    case "maxlotsize": {
                        lotpolicy = data.getString("lotpolicy");
                        if ("B".equals(lotpolicy)) {
                            errorMap.put(dataId, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u4fe1\u606f\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u4fe1\u606f\u7269\u6599\u7f16\u7801\u201c%s\u201d\u6279\u91cf\u653f\u7b56\u4e3a\u56fa\u5b9a\u6279\u91cf\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"MaterialPlanBatchUpdPlugin_17", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), number));
                            break;
                        }
                        data.set(dbField, newValue);
                        break;
                    }
                    default: {
                        data.set(dbField, newValue);
                    }
                }
                for (Map.Entry entry : extFields.entrySet()) {
                    data.set((String)entry.getKey(), entry.getValue());
                    DynamicProperty property2 = dataEntityType.getProperty((String)entry.getKey());
                    if (!(property2 instanceof BasedataProp) || entry.getValue() == null) continue;
                    BasedataProp baseData = (BasedataProp)property2;
                    DynamicObject base = BusinessDataServiceHelper.loadSingleFromCache(entry.getValue(), (String)baseData.getBaseEntityId(), (String)"id,number,name");
                    data.set((String)entry.getKey(), (Object)base);
                    data.set((String)entry.getKey() + "_id", entry.getValue());
                }
                updateOrders.add(data);
            }
        }
        HashMap<Object, DynamicObject> updateOrderMap = new HashMap<Object, DynamicObject>(updateOrders.size());
        for (DynamicObject updateOrder : updateOrders) {
            updateOrderMap.put(updateOrder.getPkValue(), updateOrder);
        }
        OperateOption option = OperateOption.create();
        OperationResult operationResult = null;
        option.setVariableValue("batchUpdate", "batchUpdate");
        option.setVariableValue(PLAN_ISLOG, PLAN_ISLOG);
        try {
            operationResult = OperationServiceHelper.executeOperate((String)"save", (String)entityNumber, (DynamicObject[])updateOrders.toArray(new DynamicObject[0]), (OperateOption)option);
            List successPkIds = operationResult.getSuccessPkIds();
            HashSet<Object> materialPlanInfoIds = new HashSet<Object>(successPkIds);
            for (Object successPkId : successPkIds) {
                successIds.add(Long.valueOf(successPkId.toString()));
                if (!materialInfoIds.contains(successPkId)) continue;
                materialPlanInfoIds.add(successPkId);
            }
            if (materialPlanInfoIds != null && !materialPlanInfoIds.isEmpty()) {
                HashSet successAuditPkIds = new HashSet(16);
                for (Object materialPlanInfoId : materialPlanInfoIds) {
                    DynamicObject updateOrder = (DynamicObject)updateOrderMap.get(materialPlanInfoId);
                    if (!StatusEnum.C.name().equals(updateOrder.getString("status"))) continue;
                    successAuditPkIds.add(materialPlanInfoId);
                }
                DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"IMaterialBizInfoSyncService", (String)"materialAttrSync", (Object[])new Object[]{successAuditPkIds, "mpdm_materialplan"});
            }
            if (!operationResult.isSuccess()) {
                List allErrors;
                error = new StringBuilder();
                error.append(ResManager.loadKDString((String)"\u8ba1\u5212\u4fe1\u606f\u6279\u91cf\u4fee\u6539\u4fdd\u5b58\u5931\u8d25\uff1a\u8ba1\u5212\u4fe1\u606f\u7f16\u7801:%s", (String)"MaterialPlanBatchUpdPlugin_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                if (StringUtils.isNotBlank((CharSequence)operationResult.getMessage())) {
                    error.append(operationResult.getMessage());
                }
                if ((allErrors = operationResult.getAllErrorOrValidateInfo()) == null || allErrors.size() == 0) {
                    this.failInfoUpdate(error.toString(), updateOrders, errorMap);
                } else {
                    for (IOperateInfo info : allErrors) {
                        StringBuilder infoerror;
                        Object pkValue = info.getPkValue();
                        if (successIds.contains(pkValue) || pkValue == null) continue;
                        Long errorOrderId = Long.valueOf(pkValue.toString());
                        DynamicObject errorOrder = (DynamicObject)updateOrderMap.get(pkValue);
                        String errorStr = (String)errorMap.get(errorOrderId);
                        if (StringUtils.isBlank((CharSequence)errorStr)) {
                            infoerror = new StringBuilder();
                            errorStr = String.format(infoerror.append((CharSequence)error).append(info.getMessage()).append("\n\r").toString(), errorOrder.getString("number"));
                        } else {
                            infoerror = new StringBuilder();
                            errorStr = infoerror.append(errorStr).append(info.getMessage()).append("\n\r").toString();
                        }
                        errorMap.put(errorOrderId, errorStr);
                    }
                }
            }
            return result;
        }
        catch (Exception e) {
            String errorStr = ResManager.loadKDString((String)"\u8ba1\u5212\u4fe1\u606f\u6279\u91cf\u4fee\u6539\u4fdd\u5b58\u5931\u8d25\uff1a\u8ba1\u5212\u4fe1\u606f\u7f16\u7801\u3010%s\u3011\u5f02\u5e38\u4fe1\u606f\u4e3a", (String)"MaterialPlanBatchUpdPlugin_5", (String)"bd-mpdm-formplugin", (Object[])new Object[0]);
            error = new StringBuilder();
            error.append(errorStr);
            error.append(String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MaterialPlanBatchUpdPlugin_13", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), e.getMessage()));
            this.failInfoUpdate(error.toString(), updateOrders, errorMap);
            return result;
        }
    }

    private boolean checkLotpolicy(DynamicObject data, Long dataId, Map<Long, String> errorMap, String number) {
        String lotpolicy = data.getString("lotpolicy");
        if ("A".equals(lotpolicy)) {
            errorMap.put(dataId, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u4fe1\u606f\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u4fe1\u606f\u7269\u6599\u7f16\u7801\u201c%s\u201d\u6279\u91cf\u653f\u7b56\u4e3a\u76f4\u63a5\u6279\u91cf\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"MaterialPlanBatchUpdPlugin_16", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), number));
            return false;
        }
        if ("B".equals(lotpolicy)) {
            errorMap.put(dataId, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u4fe1\u606f\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u4fe1\u606f\u7269\u6599\u7f16\u7801\u201c%s\u201d\u6279\u91cf\u653f\u7b56\u4e3a\u56fa\u5b9a\u6279\u91cf\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"MaterialPlanBatchUpdPlugin_17", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), number));
            return false;
        }
        return true;
    }

    private void failInfoUpdate(String error, List<DynamicObject> updateOrders, Map<Long, String> errorMap) {
        for (DynamicObject planorder : updateOrders) {
            String errorStr = error;
            if (error == null) continue;
            if (error.split("%s").length == 2) {
                errorStr = String.format(error, planorder.getString("number"));
            }
            Long orderId = planorder.getLong("id");
            if (errorStr.length() > 450) {
                errorStr = errorStr.substring(0, 450);
            }
            errorMap.put(orderId, errorStr);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
        this.settaskid("-1");
        progressBar.start();
    }

    public void onProgress(ProgressEvent paramProgressEvent) {
        Label lblTip;
        int progress = this.getProgress();
        if (progress == 0) {
            lblTip = (Label)this.getControl("labelap");
            lblTip.setText(ResManager.loadKDString((String)"\u51c6\u5907\u6279\u91cf\u4fee\u6539...", (String)"MaterialPlanBatchUpdPlugin_6", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            paramProgressEvent.setProgress(0);
            logger.info("\u8ba1\u5212\u4fe1\u606f\u6279\u91cf\u4fee\u6539");
        } else {
            lblTip = (Label)this.getControl("labelap");
            lblTip.setText(this.getTip());
            paramProgressEvent.setProgress(this.getProgress());
        }
        if ("0".equals(this.gettaskid())) {
            ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
            progressBar.stop();
        } else if ("-1".equals(this.gettaskid())) {
            this.settaskid("-2");
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            List ids = (List)formShowParameter.getCustomParam(BATCHUPDFIELD);
            String entitynumber = (String)formShowParameter.getCustomParam(ENTITYNUMBER);
            Long batchoperaId = (Long)formShowParameter.getCustomParam(BATCHOPERA);
            DynamicObject batchopera = BusinessDataServiceHelper.loadSingleFromCache((Object)batchoperaId, (String)MPDM_BATCH_EDIT);
            String mapping = batchopera.getString("mapping");
            String entityNumber = batchopera.getString("datasource");
            Map extFields = (Map)formShowParameter.getCustomParam(UPDATEEXTFIELD);
            Object newValue = this.dealNewValue(formShowParameter, mapping, entityNumber);
            long starttime = System.currentTimeMillis();
            long endtime = System.currentTimeMillis();
            if (ids != null && ids.size() > 0) {
                logger.info("\u5904\u7406\u8ba1\u5212\u4fe1\u606f\u96c6\u5408\u8f6c\u6362\u8017\u65f6" + (endtime - starttime) + "ms");
                this.setDropSum(ids.size());
                ThreadPool pool = ThreadPools.newFixedThreadPool((String)("PlanOrder-batchupdate-onProgress-" + UUID.randomUUID()), (int)Integer.getInteger("plan.order.batchupdate.poolsize", 1));
                int averageNum = ids.size() % 200 == 0 ? ids.size() / 200 : ids.size() / 200 + 1;
                List averagelist = MaterialPlanBatchUpdPlugin.averageAssign(ids, averageNum);
                for (List planorders : averagelist) {
                    pool.execute(() -> this.execute(planorders, batchopera, newValue, entitynumber, extFields));
                }
                pool.close();
            }
        }
        int count = this.getDropCount();
        int sum = this.getDropSum();
        if (count != 0 && sum != 0 && count == sum) {
            Label lblTip2 = (Label)this.getControl("labelap");
            lblTip2.setText(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539\u603b\u6570\uff1a%1$s,\u5df2\u6279\u91cf\u4fee\u6539\uff1a%2$s,\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a%3$s", (String)"MaterialPlanBatchUpdPlugin_7", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), this.getDropSum(), this.getDropSuccessCount(), this.getDropFaildCount()));
            String error = this.getPageCache().get(CACHEKEY_ERROR);
            if (Boolean.parseBoolean(error)) {
                this.errorMsg();
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6279\u91cf\u4fee\u6539\u3002", (String)"MaterialPlanBatchUpdPlugin_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                this.getView().returnDataToParent((Object)"success");
                this.getView().invokeOperation("close");
            }
            this.settaskid("0");
        }
    }

    private Object dealNewValue(FormShowParameter formShowParameter, String mapping, String entityNumber) {
        Object newValue = formShowParameter.getCustomParam(NEWVALUE);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)MPDM_BATCHUPDFIELD);
        IDataEntityProperty property = dataEntityType.findProperty(mapping);
        if (property instanceof DateTimeProp) {
            try {
                newValue = DATETIME.get().parse(newValue.toString());
                newValue = MaterialPlanBatchUpdPlugin.getCompDate((Date)newValue);
            }
            catch (ParseException e) {
                logger.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (Throwable)e);
            }
        } else if (property instanceof BasedataProp && StringUtils.isNotBlank((CharSequence)entityNumber) && newValue instanceof JSONObject) {
            Long newValueId = 0L;
            JSONObject jobj = (JSONObject)newValue;
            newValueId = jobj.getLong("id");
            newValue = newValueId == 0L ? null : BusinessDataServiceHelper.loadSingleFromCache((Object)newValueId, (String)entityNumber);
        }
        return newValue;
    }

    public static Date getCompDate(Date date) {
        if (date == null) {
            return date;
        }
        Calendar fromDate = Calendar.getInstance();
        fromDate.setTime(date);
        fromDate.clear(12);
        fromDate.clear(13);
        fromDate.clear(14);
        fromDate.set(11, 0);
        return fromDate.getTime();
    }

    private void errorMsg() {
        int i;
        int batchupdSum = this.getDropSum();
        if (batchupdSum == 0) {
            return;
        }
        String errormsgs = this.getPageCache().get(CACHEKEY_ERRORMSG);
        String successBillNO = this.getDropSuccessBillno();
        IFormView entryView = this.getView();
        OperationResult operationResult = new OperationResult();
        String operateName = ResManager.loadKDString((String)"\u5df2\u6279\u91cf\u4fee\u6539\u7ed3\u679c\uff1a", (String)"MaterialPlanBatchUpdPlugin_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]);
        operationResult.setBillCount(batchupdSum);
        ArrayList<String> successIndexs = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)successBillNO)) {
            String[] successBillNOs = successBillNO.split("###");
            for (i = 0; i < successBillNOs.length; ++i) {
                successIndexs.add(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\u5df2\u6279\u91cf\u4fee\u6539", (String)"MaterialPlanBatchUpdPlugin_10", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), successBillNOs[i]));
            }
        }
        operationResult.setSuccessPkIds(successIndexs);
        if (errormsgs == null) {
            return;
        }
        String[] errormsg = errormsgs.split("###");
        for (i = 0; i < errormsg.length; ++i) {
            String error = errormsg[i];
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo("errorcode_001", ErrorLevel.Error, (Object)i);
            operateErrorInfo.setMessage(error);
            operateErrorInfo.setTitle(ResManager.loadKDString((String)"\u8ba1\u5212\u4fe1\u606f\u6279\u91cf\u4fee\u6539", (String)"MaterialPlanBatchUpdPlugin_11", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            operationResult.addErrorInfo(operateErrorInfo);
        }
        operationResult.setMessage(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"MaterialPlanBatchUpdPlugin_12", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        entryView.showOperationResult(operationResult, operateName);
    }
}

